/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.painterpack.fill;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import org.pushingpixels.substance.api.ColorSchemeTransform;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public abstract class WaveDelegateFillPainter
implements SubstanceFillPainter {
    protected String painterName;
    protected ColorSchemeTransform transformation;
    protected SubstanceFillPainter delegate;

    public WaveDelegateFillPainter(String painterName, ColorSchemeTransform transformation, SubstanceFillPainter delegate) {
        this.painterName = painterName;
        this.transformation = transformation;
        this.delegate = delegate;
    }

    public String getDisplayName() {
        return this.painterName;
    }

    public void paintContourBackground(Graphics g, Component comp, int width, int height, Shape contour, boolean isFocused, SubstanceColorScheme fillScheme, boolean hasShine) {
        GeneralPath clipBottom = new GeneralPath();
        clipBottom.moveTo(0.0f, height);
        clipBottom.lineTo(width, height);
        clipBottom.lineTo(width, 0.0f);
        clipBottom.curveTo(5 * width / 6, height / 3, 3 * width / 4, height / 2, width / 2, height / 2);
        clipBottom.curveTo(width / 3, height / 2, width / 4, height, 0.0f, 7 * height / 8);
        clipBottom.lineTo(0.0f, height);
        BufferedImage clipShapeBottom = this.createClipImage(clipBottom, width, height);
        BufferedImage bottomImage = SubstanceCoreUtilities.getBlankImage((int)width, (int)height);
        Graphics2D bottomGraphics = (Graphics2D)bottomImage.getGraphics();
        bottomGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        SubstanceColorScheme bottomColorScheme = this.transformation == null ? fillScheme : this.transformation.transform(fillScheme);
        bottomGraphics.setComposite(AlphaComposite.Src);
        bottomGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        bottomGraphics.drawImage((Image)clipShapeBottom, 0, 0, null);
        bottomGraphics.setComposite(AlphaComposite.SrcAtop);
        this.delegate.paintContourBackground((Graphics)bottomGraphics, comp, width, height, contour, isFocused, bottomColorScheme, hasShine);
        BufferedImage image = SubstanceCoreUtilities.getBlankImage((int)width, (int)height);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setClip(contour);
        this.delegate.paintContourBackground((Graphics)graphics, comp, width, height, contour, isFocused, fillScheme, hasShine);
        graphics.drawImage((Image)bottomImage, 0, 0, null);
        graphics.setClip(null);
    }

    BufferedImage createClipImage(Shape s, int width, int height) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        BufferedImage img = c.createCompatibleImage(width, height, 3);
        Graphics2D g2 = img.createGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, width, height);
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fill(s);
        g2.dispose();
        return img;
    }
}

