/*
 * Decompiled with CFR 0.152.
 */
package plugins.map;

import freemind.modes.MindMapNode;
import plugins.map.MapDialog;
import plugins.map.MapMarkerBase;
import plugins.map.MapNodePositionHolder;

public class MapMarkerLocation
extends MapMarkerBase {
    private final MapNodePositionHolder mNodePositionHolder;

    public MapMarkerLocation(MapNodePositionHolder pNodePositionHolder, MapDialog pMapDialog) {
        super(pMapDialog);
        this.mNodePositionHolder = pNodePositionHolder;
        this.update();
    }

    public void update() {
        MindMapNode node = this.mNodePositionHolder.getNode();
        this.setText(node.getText());
        this.setForeground(node.getColor());
        this.setSize(this.getPreferredSize());
    }

    public double getLat() {
        return this.mNodePositionHolder.getPosition().getLat();
    }

    public double getLon() {
        return this.mNodePositionHolder.getPosition().getLon();
    }

    @Override
    public String toString() {
        return "MapMarkerLocation for node " + this.mNodePositionHolder.getNode().getText() + " at " + this.getLat() + " " + this.getLon();
    }

    public MapNodePositionHolder getNodePositionHolder() {
        return this.mNodePositionHolder;
    }
}

