/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.model;

import java.beans.PropertyDescriptor;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.reflect.EntityReflector;
import org.grails.datastore.mapping.reflect.NameUtils;

public abstract class AbstractPersistentProperty<T extends Property>
implements PersistentProperty<T> {
    protected final PersistentEntity owner;
    protected final MappingContext context;
    protected final String name;
    protected final Class type;
    protected Boolean inherited;
    private EntityReflector.PropertyReader reader;
    private EntityReflector.PropertyWriter writer;

    public AbstractPersistentProperty(PersistentEntity owner, MappingContext context, PropertyDescriptor descriptor) {
        this(owner, context, descriptor.getName(), descriptor.getPropertyType());
    }

    public AbstractPersistentProperty(PersistentEntity owner, MappingContext context, String name, Class type) {
        this.owner = owner;
        this.context = context;
        this.name = name;
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCapitilizedName() {
        return NameUtils.capitalize(this.getName());
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public PersistentEntity getOwner() {
        return this.owner;
    }

    public String toString() {
        String mappingType = this.getClass().getName();
        if (mappingType.contains("$")) {
            mappingType = this.getClass().getSuperclass().getName();
        }
        return this.getName() + ":" + this.getType().getName() + " (" + mappingType + ")";
    }

    @Override
    public boolean isNullable() {
        Object mappedForm = this.getMapping().getMappedForm();
        return mappedForm != null && ((Property)mappedForm).isNullable();
    }

    @Override
    public boolean isInherited() {
        if (this.inherited == null) {
            if (this.owner.isRoot()) {
                this.inherited = false;
            } else {
                boolean foundInParent = false;
                for (PersistentEntity parentEntity = this.owner.getParentEntity(); parentEntity != null; parentEntity = parentEntity.getParentEntity()) {
                    PersistentProperty p = parentEntity.getPropertyByName(this.name);
                    if (p == null) continue;
                    foundInParent = true;
                    break;
                }
                this.inherited = foundInParent;
            }
        }
        return this.inherited;
    }

    @Override
    public EntityReflector.PropertyReader getReader() {
        if (this.reader == null) {
            this.reader = this.getOwner().getReflector().getPropertyReader(this.getName());
        }
        return this.reader;
    }

    @Override
    public EntityReflector.PropertyWriter getWriter() {
        if (this.writer == null) {
            this.writer = this.getOwner().getReflector().getPropertyWriter(this.getName());
        }
        return this.writer;
    }
}

