/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class EquidistantCylindrical
extends AbstractProj {
    private double cosStandardParallel;

    @Override
    public String getName() {
        return I18n.tr("Equidistant Cylindrical (Plate Caree)", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "eqc";
    }

    @Override
    public void initialize(ProjParameters params) throws ProjectionConfigurationException {
        super.initialize(params);
        this.cosStandardParallel = params.lat_ts != null ? Math.cos(Utils.toRadians(Math.abs(params.lat_ts))) : 1.0;
    }

    @Override
    public double[] project(double latRad, double lonRad) {
        return new double[]{lonRad * this.cosStandardParallel, latRad};
    }

    @Override
    public double[] invproject(double east, double north) {
        return new double[]{north, east / this.cosStandardParallel};
    }

    @Override
    public Bounds getAlgorithmBounds() {
        return new Bounds(-89.0, -180.0, 89.0, 180.0, false);
    }
}

