/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.command.conflict.ConflictResolveCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.conflict.pair.AbstractListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.ComparePairListCellRenderer;
import org.openstreetmap.josm.gui.conflict.pair.ComparePairType;
import org.openstreetmap.josm.gui.conflict.pair.IConflictResolver;
import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.AdjustmentSynchronizer;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.OsmPrimitivesTable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.ImageResource;

public abstract class AbstractListMerger<T extends PrimitiveId, C extends ConflictResolveCommand>
extends JPanel
implements PropertyChangeListener,
ChangeListener,
IConflictResolver {
    protected OsmPrimitivesTable myEntriesTable;
    protected OsmPrimitivesTable mergedEntriesTable;
    protected OsmPrimitivesTable theirEntriesTable;
    protected transient AbstractListMergeModel<T, C> model;
    private CopyStartLeftAction copyStartLeftAction;
    private CopyBeforeCurrentLeftAction copyBeforeCurrentLeftAction;
    private CopyAfterCurrentLeftAction copyAfterCurrentLeftAction;
    private CopyEndLeftAction copyEndLeftAction;
    private CopyAllLeft copyAllLeft;
    private CopyStartRightAction copyStartRightAction;
    private CopyBeforeCurrentRightAction copyBeforeCurrentRightAction;
    private CopyAfterCurrentRightAction copyAfterCurrentRightAction;
    private CopyEndRightAction copyEndRightAction;
    private CopyAllRight copyAllRight;
    private MoveUpMergedAction moveUpMergedAction;
    private MoveDownMergedAction moveDownMergedAction;
    private RemoveMergedAction removeMergedAction;
    private FreezeAction freezeAction;
    private transient AdjustmentSynchronizer adjustmentSynchronizer;
    private JLabel lblMyVersion;
    private JLabel lblMergedVersion;
    private JLabel lblTheirVersion;
    private JLabel lblFrozenState;

    protected abstract JScrollPane buildMyElementsTable();

    protected abstract JScrollPane buildMergedElementsTable();

    protected abstract JScrollPane buildTheirElementsTable();

    protected JScrollPane embeddInScrollPane(JTable table) {
        JScrollPane pane = new JScrollPane(table);
        if (this.adjustmentSynchronizer == null) {
            this.adjustmentSynchronizer = new AdjustmentSynchronizer();
        }
        return pane;
    }

    protected void wireActionsToSelectionModels() {
        this.myEntriesTable.getSelectionModel().addListSelectionListener(this.copyStartLeftAction);
        this.myEntriesTable.getSelectionModel().addListSelectionListener(this.copyBeforeCurrentLeftAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.copyBeforeCurrentLeftAction);
        this.myEntriesTable.getSelectionModel().addListSelectionListener(this.copyAfterCurrentLeftAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.copyAfterCurrentLeftAction);
        this.myEntriesTable.getSelectionModel().addListSelectionListener(this.copyEndLeftAction);
        this.theirEntriesTable.getSelectionModel().addListSelectionListener(this.copyStartRightAction);
        this.theirEntriesTable.getSelectionModel().addListSelectionListener(this.copyBeforeCurrentRightAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.copyBeforeCurrentRightAction);
        this.theirEntriesTable.getSelectionModel().addListSelectionListener(this.copyAfterCurrentRightAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.copyAfterCurrentRightAction);
        this.theirEntriesTable.getSelectionModel().addListSelectionListener(this.copyEndRightAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.moveUpMergedAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.moveDownMergedAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.removeMergedAction);
        this.model.addChangeListener(this.copyAllLeft);
        this.model.addChangeListener(this.copyAllRight);
        this.model.addPropertyChangeListener(this.copyAllLeft);
        this.model.addPropertyChangeListener(this.copyAllRight);
    }

    protected JPanel buildLeftButtonPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        this.copyStartLeftAction = new CopyStartLeftAction();
        JButton btn = new JButton(this.copyStartLeftAction);
        btn.setName("button.copystartleft");
        pnl.add((Component)btn, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        this.copyBeforeCurrentLeftAction = new CopyBeforeCurrentLeftAction();
        btn = new JButton(this.copyBeforeCurrentLeftAction);
        btn.setName("button.copybeforecurrentleft");
        pnl.add((Component)btn, gc);
        gc.gridx = 0;
        gc.gridy = 2;
        this.copyAfterCurrentLeftAction = new CopyAfterCurrentLeftAction();
        btn = new JButton(this.copyAfterCurrentLeftAction);
        btn.setName("button.copyaftercurrentleft");
        pnl.add((Component)btn, gc);
        gc.gridx = 0;
        gc.gridy = 3;
        this.copyEndLeftAction = new CopyEndLeftAction();
        btn = new JButton(this.copyEndLeftAction);
        btn.setName("button.copyendleft");
        pnl.add((Component)btn, gc);
        gc.gridx = 0;
        gc.gridy = 4;
        this.copyAllLeft = new CopyAllLeft();
        btn = new JButton(this.copyAllLeft);
        btn.setName("button.copyallleft");
        pnl.add((Component)btn, gc);
        return pnl;
    }

    protected JPanel buildRightButtonPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        this.copyStartRightAction = new CopyStartRightAction();
        pnl.add((Component)new JButton(this.copyStartRightAction), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        this.copyBeforeCurrentRightAction = new CopyBeforeCurrentRightAction();
        pnl.add((Component)new JButton(this.copyBeforeCurrentRightAction), gc);
        gc.gridx = 0;
        gc.gridy = 2;
        this.copyAfterCurrentRightAction = new CopyAfterCurrentRightAction();
        pnl.add((Component)new JButton(this.copyAfterCurrentRightAction), gc);
        gc.gridx = 0;
        gc.gridy = 3;
        this.copyEndRightAction = new CopyEndRightAction();
        pnl.add((Component)new JButton(this.copyEndRightAction), gc);
        gc.gridx = 0;
        gc.gridy = 4;
        this.copyAllRight = new CopyAllRight();
        pnl.add((Component)new JButton(this.copyAllRight), gc);
        return pnl;
    }

    protected JPanel buildMergedListControlButtons() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 2;
        gc.anchor = 10;
        gc.weightx = 0.3;
        gc.weighty = 0.0;
        this.moveUpMergedAction = new MoveUpMergedAction();
        pnl.add((Component)new JButton(this.moveUpMergedAction), gc);
        gc.gridx = 1;
        gc.gridy = 0;
        this.moveDownMergedAction = new MoveDownMergedAction();
        pnl.add((Component)new JButton(this.moveDownMergedAction), gc);
        gc.gridx = 2;
        gc.gridy = 0;
        this.removeMergedAction = new RemoveMergedAction();
        pnl.add((Component)new JButton(this.removeMergedAction), gc);
        return pnl;
    }

    protected JPanel buildAdjustmentLockControlPanel(JCheckBox cb) {
        JPanel panel = new JPanel(new FlowLayout(2));
        panel.add(new JLabel(I18n.tr("lock scrolling", new Object[0])));
        panel.add(cb);
        return panel;
    }

    protected JPanel buildComparePairSelectionPanel() {
        JPanel p = new JPanel(new FlowLayout(0));
        p.add(new JLabel(I18n.tr("Compare ", new Object[0])));
        JosmComboBox<ComparePairType> cbComparePair = new JosmComboBox<ComparePairType>(this.model.getComparePairListModel());
        cbComparePair.setRenderer(new ComparePairListCellRenderer());
        p.add(cbComparePair);
        return p;
    }

    protected JPanel buildFrozeStateControlPanel() {
        JPanel p = new JPanel(new FlowLayout(0));
        this.lblFrozenState = new JLabel();
        p.add(this.lblFrozenState);
        this.freezeAction = new FreezeAction();
        JToggleButton btn = new JToggleButton(this.freezeAction);
        this.freezeAction.adapt(btn);
        btn.setName("button.freeze");
        p.add(btn);
        return p;
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(10, 0, 0, 0);
        this.lblMyVersion = new JLabel(I18n.tr("My version", new Object[0]));
        this.lblMyVersion.setToolTipText(I18n.tr("List of elements in my dataset, i.e. the local dataset", new Object[0]));
        this.add((Component)this.lblMyVersion, gc);
        gc.gridx = 2;
        gc.gridy = 0;
        this.lblMergedVersion = new JLabel(I18n.tr("Merged version", new Object[0]));
        this.lblMergedVersion.setToolTipText(I18n.tr("List of merged elements. They will replace the list of my elements when the merge decisions are applied.", new Object[0]));
        this.add((Component)this.lblMergedVersion, gc);
        gc.gridx = 4;
        gc.gridy = 0;
        this.lblTheirVersion = new JLabel(I18n.tr("Their version", new Object[0]));
        this.lblTheirVersion.setToolTipText(I18n.tr("List of elements in their dataset, i.e. the server dataset", new Object[0]));
        this.add((Component)this.lblTheirVersion, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 2;
        gc.anchor = 23;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        gc.insets = new Insets(0, 0, 0, 0);
        JCheckBox cbLockMyScrolling = new JCheckBox();
        cbLockMyScrolling.setName("checkbox.lockmyscrolling");
        this.add((Component)this.buildAdjustmentLockControlPanel(cbLockMyScrolling), gc);
        gc.gridx = 2;
        gc.gridy = 1;
        JCheckBox cbLockMergedScrolling = new JCheckBox();
        cbLockMergedScrolling.setName("checkbox.lockmergedscrolling");
        this.add((Component)this.buildAdjustmentLockControlPanel(cbLockMergedScrolling), gc);
        gc.gridx = 4;
        gc.gridy = 1;
        JCheckBox cbLockTheirScrolling = new JCheckBox();
        cbLockTheirScrolling.setName("checkbox.locktheirscrolling");
        this.add((Component)this.buildAdjustmentLockControlPanel(cbLockTheirScrolling), gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 1;
        gc.anchor = 23;
        gc.weightx = 0.33;
        gc.weighty = 1.0;
        gc.insets = new Insets(0, 0, 0, 0);
        JScrollPane pane = this.buildMyElementsTable();
        this.lblMyVersion.setLabelFor(pane);
        this.adjustmentSynchronizer.adapt(cbLockMyScrolling, pane.getVerticalScrollBar());
        this.add((Component)pane, gc);
        gc.gridx = 1;
        gc.gridy = 2;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        this.add((Component)this.buildLeftButtonPanel(), gc);
        gc.gridx = 2;
        gc.gridy = 2;
        gc.fill = 1;
        gc.anchor = 23;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        pane = this.buildMergedElementsTable();
        this.lblMergedVersion.setLabelFor(pane);
        this.adjustmentSynchronizer.adapt(cbLockMergedScrolling, pane.getVerticalScrollBar());
        this.add((Component)pane, gc);
        gc.gridx = 3;
        gc.gridy = 2;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        this.add((Component)this.buildRightButtonPanel(), gc);
        gc.gridx = 4;
        gc.gridy = 2;
        gc.fill = 1;
        gc.anchor = 23;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        pane = this.buildTheirElementsTable();
        this.lblTheirVersion.setLabelFor(pane);
        this.adjustmentSynchronizer.adapt(cbLockTheirScrolling, pane.getVerticalScrollBar());
        this.add((Component)pane, gc);
        gc.gridx = 2;
        gc.gridy = 3;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        this.add((Component)this.buildMergedListControlButtons(), gc);
        gc.gridx = 0;
        gc.gridy = 4;
        gc.gridwidth = 2;
        gc.gridheight = 1;
        gc.fill = 2;
        gc.anchor = 21;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        this.add((Component)this.buildComparePairSelectionPanel(), gc);
        gc.gridx = 2;
        gc.gridy = 4;
        gc.gridwidth = 3;
        gc.gridheight = 1;
        gc.fill = 2;
        gc.anchor = 21;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        this.add((Component)this.buildFrozeStateControlPanel(), gc);
        this.wireActionsToSelectionModels();
    }

    public AbstractListMerger(AbstractListMergeModel<T, C> model) {
        this.model = model;
        model.addChangeListener(this);
        this.build();
        model.addPropertyChangeListener(this);
    }

    protected void handlePropertyChangeFrozen(boolean newValue) {
        this.myEntriesTable.getSelectionModel().clearSelection();
        this.myEntriesTable.setEnabled(!newValue);
        this.theirEntriesTable.getSelectionModel().clearSelection();
        this.theirEntriesTable.setEnabled(!newValue);
        this.mergedEntriesTable.getSelectionModel().clearSelection();
        this.mergedEntriesTable.setEnabled(!newValue);
        this.freezeAction.putValue(FreezeActionProperties.PROP_SELECTED, newValue);
        if (newValue) {
            this.lblFrozenState.setText(I18n.tr("<html>Click <strong>{0}</strong> to start merging my and their entries.</html>", this.freezeAction.getValue("Name")));
        } else {
            this.lblFrozenState.setText(I18n.tr("<html>Click <strong>{0}</strong> to finish merging my and their entries.</html>", this.freezeAction.getValue("Name")));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(AbstractListMergeModel.FROZEN_PROP)) {
            this.handlePropertyChangeFrozen((Boolean)evt.getNewValue());
        }
    }

    public AbstractListMergeModel<T, C> getModel() {
        return this.model;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.lblMyVersion.setText(I18n.trn("My version ({0} entry)", "My version ({0} entries)", this.model.getMyEntriesSize(), this.model.getMyEntriesSize()));
        this.lblMergedVersion.setText(I18n.trn("Merged version ({0} entry)", "Merged version ({0} entries)", this.model.getMergedEntriesSize(), this.model.getMergedEntriesSize()));
        this.lblTheirVersion.setText(I18n.trn("Their version ({0} entry)", "Their version ({0} entries)", this.model.getTheirEntriesSize(), this.model.getTheirEntriesSize()));
    }

    public void registerListeners() {
        this.myEntriesTable.registerListeners();
        this.mergedEntriesTable.registerListeners();
        this.theirEntriesTable.registerListeners();
    }

    public void unregisterListeners() {
        this.myEntriesTable.unregisterListeners();
        this.mergedEntriesTable.unregisterListeners();
        this.theirEntriesTable.unregisterListeners();
    }

    protected final <P extends OsmPrimitive> OsmDataLayer findLayerFor(P primitive) {
        if (primitive != null) {
            List<OsmDataLayer> layers = MainApplication.getLayerManager().getLayersOfType(OsmDataLayer.class);
            for (OsmDataLayer layer : layers) {
                if (layer.data != primitive.getDataSet()) continue;
                return layer;
            }
            for (OsmDataLayer layer : layers) {
                Collection<OsmPrimitive> collection = primitive instanceof Way ? layer.data.getWays() : (primitive instanceof Relation ? layer.data.getRelations() : layer.data.allPrimitives());
                for (OsmPrimitive osmPrimitive : collection) {
                    if (!osmPrimitive.getPrimitiveId().equals(primitive.getPrimitiveId())) continue;
                    return layer;
                }
            }
        }
        return null;
    }

    @Override
    public void decideRemaining(MergeDecisionType decision) {
        if (!this.model.isFrozen()) {
            this.model.copyAll(MergeDecisionType.KEEP_MINE.equals((Object)decision) ? ListRole.MY_ENTRIES : ListRole.THEIR_ENTRIES);
            this.model.setFrozen(true);
        }
    }

    private final class FreezeAction
    extends AbstractAction
    implements ItemListener,
    FreezeActionProperties {
        private FreezeAction() {
            this.putValue("Name", I18n.tr("Freeze", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Freeze the current list of merged elements.", new Object[0]));
            this.putValue(PROP_SELECTED, Boolean.FALSE);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
        }

        public void adapt(JToggleButton btn) {
            btn.addItemListener(this);
            this.addPropertyChangeListener(evt -> {
                if (evt.getPropertyName().equals(PROP_SELECTED)) {
                    btn.setSelected((Boolean)evt.getNewValue());
                }
            });
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            int state = e.getStateChange();
            if (state == 1) {
                this.putValue("Name", I18n.tr("Unfreeze", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Unfreeze the list of merged elements and start merging.", new Object[0]));
                AbstractListMerger.this.model.setFrozen(true);
            } else if (state == 2) {
                this.putValue("Name", I18n.tr("Freeze", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Freeze the current list of merged elements.", new Object[0]));
                AbstractListMerger.this.model.setFrozen(false);
            }
            boolean isSelected = (Boolean)this.getValue(PROP_SELECTED);
            if (isSelected != (e.getStateChange() == 1)) {
                this.putValue(PROP_SELECTED, e.getStateChange() == 1);
            }
        }
    }

    private static interface FreezeActionProperties {
        public static final String PROP_SELECTED = FreezeActionProperties.class.getName() + ".selected";
    }

    class RemoveMergedAction
    extends AbstractAction
    implements ListSelectionListener {
        RemoveMergedAction() {
            ImageResource icon = new ImageProvider("dialogs/conflict", "remove").getResource();
            if (icon == null) {
                this.putValue("Name", I18n.tr("Remove", new Object[0]));
            } else {
                icon.attachImageIcon(this, true);
            }
            this.putValue("ShortDescription", I18n.tr("Remove the selected entries from the list of merged elements.", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int[] rows = AbstractListMerger.this.mergedEntriesTable.getSelectedRows();
            AbstractListMerger.this.model.removeMerged(rows);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int[] rows = AbstractListMerger.this.mergedEntriesTable.getSelectedRows();
            this.setEnabled(rows.length > 0);
        }
    }

    class MoveDownMergedAction
    extends AbstractAction
    implements ListSelectionListener {
        MoveDownMergedAction() {
            ImageResource icon = new ImageProvider("dialogs/conflict", "movedown").getResource();
            if (icon == null) {
                this.putValue("Name", I18n.tr("Down", new Object[0]));
            } else {
                icon.attachImageIcon(this, true);
            }
            this.putValue("ShortDescription", I18n.tr("Move down the selected entries by one position.", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int[] rows = AbstractListMerger.this.mergedEntriesTable.getSelectedRows();
            AbstractListMerger.this.model.moveDownMerged(rows);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int[] rows = AbstractListMerger.this.mergedEntriesTable.getSelectedRows();
            this.setEnabled(rows.length > 0 && rows[rows.length - 1] != AbstractListMerger.this.mergedEntriesTable.getRowCount() - 1);
        }
    }

    class MoveUpMergedAction
    extends AbstractAction
    implements ListSelectionListener {
        MoveUpMergedAction() {
            ImageResource icon = new ImageProvider("dialogs/conflict", "moveup").getResource();
            if (icon == null) {
                this.putValue("Name", I18n.tr("Up", new Object[0]));
            } else {
                icon.attachImageIcon(this, true);
            }
            this.putValue("ShortDescription", I18n.tr("Move up the selected entries by one position.", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int[] rows = AbstractListMerger.this.mergedEntriesTable.getSelectedRows();
            AbstractListMerger.this.model.moveUpMerged(rows);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int[] rows = AbstractListMerger.this.mergedEntriesTable.getSelectedRows();
            this.setEnabled(rows.length > 0 && rows[0] != 0);
        }
    }

    class CopyAllRight
    extends AbstractAction
    implements ChangeListener,
    PropertyChangeListener {
        CopyAllRight() {
            new ImageProvider("dialogs/conflict", "useallright").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Copy all their elements to the target", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            AbstractListMerger.this.model.copyAll(ListRole.THEIR_ENTRIES);
            AbstractListMerger.this.model.setFrozen(true);
        }

        private void updateEnabledState() {
            this.setEnabled(AbstractListMerger.this.model.getMergedEntries().isEmpty() && !AbstractListMerger.this.model.isFrozen());
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.updateEnabledState();
        }
    }

    class CopyAllLeft
    extends AbstractAction
    implements ChangeListener,
    PropertyChangeListener {
        CopyAllLeft() {
            new ImageProvider("dialogs/conflict", "useallleft").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Copy all my elements to the target", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            AbstractListMerger.this.model.copyAll(ListRole.MY_ENTRIES);
            AbstractListMerger.this.model.setFrozen(true);
        }

        private void updateEnabledState() {
            this.setEnabled(AbstractListMerger.this.model.getMergedEntries().isEmpty() && !AbstractListMerger.this.model.isFrozen());
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.updateEnabledState();
        }
    }

    class CopyAfterCurrentRightAction
    extends CopyAction {
        CopyAfterCurrentRightAction() {
            super("copyaftercurrentright", I18n.tr("< after", new Object[0]), I18n.tr("Copy their selected element after the first selected element in the list of merged elements", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] mergedRows = AbstractListMerger.this.mergedEntriesTable.getSelectedRows();
            if (mergedRows.length == 0) {
                return;
            }
            int[] myRows = AbstractListMerger.this.theirEntriesTable.getSelectedRows();
            int current = mergedRows[0];
            AbstractListMerger.this.model.copyTheirAfterCurrent(myRows, current);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!AbstractListMerger.this.theirEntriesTable.getSelectionModel().isSelectionEmpty() && !AbstractListMerger.this.mergedEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyBeforeCurrentRightAction
    extends CopyAction {
        CopyBeforeCurrentRightAction() {
            super("copybeforecurrentright", I18n.tr("< before", new Object[0]), I18n.tr("Copy their selected elements before the first selected element in the list of merged elements.", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] mergedRows = AbstractListMerger.this.mergedEntriesTable.getSelectedRows();
            if (mergedRows.length == 0) {
                return;
            }
            int[] myRows = AbstractListMerger.this.theirEntriesTable.getSelectedRows();
            int current = mergedRows[0];
            AbstractListMerger.this.model.copyTheirBeforeCurrent(myRows, current);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!AbstractListMerger.this.theirEntriesTable.getSelectionModel().isSelectionEmpty() && !AbstractListMerger.this.mergedEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyEndRightAction
    extends CopyAction {
        CopyEndRightAction() {
            super("copyendright", I18n.tr("< bottom", new Object[0]), I18n.tr("Copy their selected elements to the end of the list of merged elements.", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            AbstractListMerger.this.model.copyTheirToEnd(AbstractListMerger.this.theirEntriesTable.getSelectedRows());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!AbstractListMerger.this.theirEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyStartRightAction
    extends CopyAction {
        CopyStartRightAction() {
            super("copystartright", I18n.tr("< top", new Object[0]), I18n.tr("Copy their selected element to the start of the list of merged elements.", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractListMerger.this.model.copyTheirToTop(AbstractListMerger.this.theirEntriesTable.getSelectedRows());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!AbstractListMerger.this.theirEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyAfterCurrentLeftAction
    extends CopyAction {
        CopyAfterCurrentLeftAction() {
            super("copyaftercurrentleft", I18n.tr("> after", new Object[0]), I18n.tr("Copy my selected elements after the first selected element in the list of merged elements.", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] mergedRows = AbstractListMerger.this.mergedEntriesTable.getSelectedRows();
            if (mergedRows.length == 0) {
                return;
            }
            int[] myRows = AbstractListMerger.this.myEntriesTable.getSelectedRows();
            int current = mergedRows[0];
            AbstractListMerger.this.model.copyMyAfterCurrent(myRows, current);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!AbstractListMerger.this.myEntriesTable.getSelectionModel().isSelectionEmpty() && !AbstractListMerger.this.mergedEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyBeforeCurrentLeftAction
    extends CopyAction {
        CopyBeforeCurrentLeftAction() {
            super("copybeforecurrentleft", I18n.tr("> before", new Object[0]), I18n.tr("Copy my selected elements before the first selected element in the list of merged elements.", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] mergedRows = AbstractListMerger.this.mergedEntriesTable.getSelectedRows();
            if (mergedRows.length == 0) {
                return;
            }
            int[] myRows = AbstractListMerger.this.myEntriesTable.getSelectedRows();
            int current = mergedRows[0];
            AbstractListMerger.this.model.copyMyBeforeCurrent(myRows, current);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!AbstractListMerger.this.myEntriesTable.getSelectionModel().isSelectionEmpty() && !AbstractListMerger.this.mergedEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyEndLeftAction
    extends CopyAction {
        CopyEndLeftAction() {
            super("copyendleft", I18n.tr("> bottom", new Object[0]), I18n.tr("Copy my selected elements to the end of the list of merged elements.", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractListMerger.this.model.copyMyToEnd(AbstractListMerger.this.myEntriesTable.getSelectedRows());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!AbstractListMerger.this.myEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyStartLeftAction
    extends CopyAction {
        CopyStartLeftAction() {
            super("copystartleft", I18n.tr("> top", new Object[0]), I18n.tr("Copy my selected nodes to the start of the merged node list", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractListMerger.this.model.copyMyToTop(AbstractListMerger.this.myEntriesTable.getSelectedRows());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!AbstractListMerger.this.myEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    static abstract class CopyAction
    extends AbstractAction
    implements ListSelectionListener {
        protected CopyAction(String iconName, String actionName, String shortDescription) {
            ImageResource icon = new ImageProvider("dialogs/conflict", iconName).getResource();
            if (icon == null) {
                this.putValue("Name", actionName);
            } else {
                icon.attachImageIcon(this, true);
            }
            this.putValue("ShortDescription", shortDescription);
            this.setEnabled(false);
        }
    }
}

