/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.draw.SymbolShape;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.StyleElementList;
import org.openstreetmap.josm.gui.mappaint.styleelement.BoxTextElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.MapImage;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.Symbol;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.RotationAngle;
import org.openstreetmap.josm.tools.Utils;

public class NodeElement
extends StyleElement {
    public final MapImage mapImage;
    public final RotationAngle mapImageAngle;
    public final Symbol symbol;
    private static final String[] ICON_KEYS = new String[]{"icon-image", "icon-width", "icon-height", "icon-opacity", "icon-offset-x", "icon-offset-y"};
    public static final NodeElement SIMPLE_NODE_ELEMSTYLE;
    public static final BoxTextElement.BoxProvider SIMPLE_NODE_ELEMSTYLE_BOXPROVIDER;
    public static final StyleElementList DEFAULT_NODE_STYLELIST;
    public static final StyleElementList DEFAULT_NODE_STYLELIST_TEXT;

    protected NodeElement(Cascade c, MapImage mapImage, Symbol symbol, float defaultMajorZindex, RotationAngle rotationAngle) {
        super(c, defaultMajorZindex);
        this.mapImage = mapImage;
        this.symbol = symbol;
        this.mapImageAngle = Objects.requireNonNull(rotationAngle, "rotationAngle");
    }

    public static NodeElement create(Environment env) {
        return NodeElement.create(env, 4.0f, false);
    }

    private static NodeElement create(Environment env, float defaultMajorZindex, boolean allowDefault) {
        MapImage mapImage = NodeElement.createIcon(env);
        Symbol symbol = null;
        if (mapImage == null) {
            symbol = NodeElement.createSymbol(env);
        }
        if (!allowDefault && symbol == null && mapImage == null) {
            return null;
        }
        Cascade c = env.mc.getCascade(env.layer);
        RotationAngle rotationAngle = NodeElement.createRotationAngle(env);
        return new NodeElement(c, mapImage, symbol, defaultMajorZindex, rotationAngle);
    }

    public static RotationAngle createRotationAngle(Environment env) {
        Cascade c = env.mc.getCascade(env.layer);
        RotationAngle rotationAngle = RotationAngle.NO_ROTATION;
        Float angle = c.get("icon-rotation", null, Float.class, true);
        if (angle != null) {
            rotationAngle = RotationAngle.buildStaticRotation(angle.floatValue());
        } else {
            Keyword rotationKW = c.get("icon-rotation", null, Keyword.class);
            if (rotationKW != null) {
                if ("way".equals(rotationKW.val)) {
                    rotationAngle = RotationAngle.buildWayDirectionRotation();
                } else {
                    try {
                        rotationAngle = RotationAngle.buildStaticRotation(rotationKW.val);
                    }
                    catch (IllegalArgumentException ignore) {
                        Logging.trace(ignore);
                    }
                }
            }
        }
        return rotationAngle;
    }

    public static MapImage createIcon(Environment env) {
        return NodeElement.createIcon(env, ICON_KEYS);
    }

    public static MapImage createIcon(Environment env, String ... keys) {
        CheckParameterUtil.ensureParameterNotNull(env, "env");
        CheckParameterUtil.ensureParameterNotNull(keys, "keys");
        Cascade c = env.mc.getCascade(env.layer);
        MapPaintStyles.IconReference iconRef = c.get(keys[0], null, MapPaintStyles.IconReference.class, true);
        if (iconRef == null) {
            return null;
        }
        Cascade cDef = env.mc.getCascade("default");
        Float widthOnDefault = cDef.get(keys[1], null, Float.class);
        if (widthOnDefault != null && widthOnDefault.floatValue() <= 0.0f) {
            widthOnDefault = null;
        }
        Float widthF = NodeElement.getWidth(c, keys[1], widthOnDefault);
        Float heightOnDefault = cDef.get(keys[2], null, Float.class);
        if (heightOnDefault != null && heightOnDefault.floatValue() <= 0.0f) {
            heightOnDefault = null;
        }
        Float heightF = NodeElement.getWidth(c, keys[2], heightOnDefault);
        int width = widthF == null ? -1 : Math.round(widthF.floatValue());
        int height = heightF == null ? -1 : Math.round(heightF.floatValue());
        float offsetXF = 0.0f;
        float offsetYF = 0.0f;
        if (keys[4] != null) {
            offsetXF = c.get(keys[4], Float.valueOf(0.0f), Float.class).floatValue();
            offsetYF = c.get(keys[5], Float.valueOf(0.0f), Float.class).floatValue();
        }
        MapImage mapImage = new MapImage(iconRef.iconName, iconRef.source);
        mapImage.width = width;
        mapImage.height = height;
        mapImage.offsetX = Math.round(offsetXF);
        mapImage.offsetY = Math.round(offsetYF);
        mapImage.alpha = Utils.clamp(Config.getPref().getInt("mappaint.icon-image-alpha", 255), 0, 255);
        Integer pAlpha = Utils.colorFloat2int(c.get(keys[3], null, Float.TYPE));
        if (pAlpha != null) {
            mapImage.alpha = pAlpha;
        }
        return mapImage;
    }

    private static Symbol createSymbol(Environment env) {
        Integer fillAlpha;
        Float size;
        Cascade c = env.mc.getCascade(env.layer);
        Keyword shapeKW = c.get("symbol-shape", null, Keyword.class);
        if (shapeKW == null) {
            return null;
        }
        Optional<SymbolShape> shape = SymbolShape.forName(shapeKW.val);
        if (!shape.isPresent()) {
            return null;
        }
        Cascade cDef = env.mc.getCascade("default");
        Float sizeOnDefault = cDef.get("symbol-size", null, Float.class);
        if (sizeOnDefault != null && sizeOnDefault.floatValue() <= 0.0f) {
            sizeOnDefault = null;
        }
        if ((size = Optional.ofNullable(NodeElement.getWidth(c, "symbol-size", sizeOnDefault)).orElse(Float.valueOf(10.0f))).floatValue() <= 0.0f) {
            return null;
        }
        Float strokeWidthOnDefault = NodeElement.getWidth(cDef, "symbol-stroke-width", null);
        Float strokeWidth = NodeElement.getWidth(c, "symbol-stroke-width", strokeWidthOnDefault);
        Color strokeColor = c.get("symbol-stroke-color", null, Color.class);
        if (strokeWidth == null && strokeColor != null) {
            strokeWidth = Float.valueOf(1.0f);
        } else if (strokeWidth != null && strokeColor == null) {
            strokeColor = Color.ORANGE;
        }
        BasicStroke stroke = null;
        if (strokeColor != null && strokeWidth != null) {
            Integer strokeAlpha = Utils.colorFloat2int(c.get("symbol-stroke-opacity", null, Float.class));
            if (strokeAlpha != null) {
                strokeColor = new Color(strokeColor.getRed(), strokeColor.getGreen(), strokeColor.getBlue(), strokeAlpha);
            }
            stroke = new BasicStroke(strokeWidth.floatValue());
        }
        Color fillColor = c.get("symbol-fill-color", null, Color.class);
        if (stroke == null && fillColor == null) {
            fillColor = Color.BLUE;
        }
        if (fillColor != null && (fillAlpha = Utils.colorFloat2int(c.get("symbol-fill-opacity", null, Float.class))) != null) {
            fillColor = new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), fillAlpha);
        }
        return new Symbol(shape.get(), Math.round(size.floatValue()), stroke, strokeColor, fillColor);
    }

    @Override
    public void paintPrimitive(IPrimitive primitive, MapPaintSettings settings, StyledMapRenderer painter, boolean selected, boolean outermember, boolean member) {
        if (primitive instanceof INode) {
            INode n = (INode)primitive;
            if (this.mapImage != null && painter.isShowIcons()) {
                painter.drawNodeIcon(n, this.mapImage, painter.isInactiveMode() || n.isDisabled(), selected, member, this.mapImageAngle == null ? 0.0 : this.mapImageAngle.getRotationAngle(primitive));
            } else if (this.symbol != null) {
                this.paintWithSymbol(settings, painter, selected, member, n);
            } else {
                boolean isConnection = n.isConnectionNode();
                Color color = painter.isInactiveMode() || n.isDisabled() ? settings.getInactiveColor() : (selected ? settings.getSelectedColor() : (member ? settings.getRelationSelectedColor() : (isConnection ? (n.isTagged() ? settings.getTaggedConnectionColor() : settings.getConnectionColor()) : (n.isTagged() ? settings.getTaggedColor() : settings.getNodeColor()))));
                int size = NodeElement.max(selected ? settings.getSelectedNodeSize() : 0, n.isTagged() ? settings.getTaggedNodeSize() : 0, isConnection ? settings.getConnectionNodeSize() : 0, settings.getUnselectedNodeSize());
                boolean fill = selected && settings.isFillSelectedNode() || n.isTagged() && settings.isFillTaggedNode() || isConnection && settings.isFillConnectionNode() || settings.isFillUnselectedNode();
                painter.drawNode(n, color, size, fill);
            }
        } else if (primitive instanceof IRelation && this.mapImage != null) {
            painter.drawRestriction((IRelation)primitive, this.mapImage, painter.isInactiveMode() || primitive.isDisabled());
        }
    }

    private void paintWithSymbol(MapPaintSettings settings, StyledMapRenderer painter, boolean selected, boolean member, INode n) {
        Color strokeColor;
        Color fillColor = this.symbol.fillColor;
        if (fillColor != null) {
            if (painter.isInactiveMode() || n.isDisabled()) {
                fillColor = settings.getInactiveColor();
            } else if (this.defaultSelectedHandling && selected) {
                fillColor = settings.getSelectedColor(fillColor.getAlpha());
            } else if (member) {
                fillColor = settings.getRelationSelectedColor(fillColor.getAlpha());
            }
        }
        if ((strokeColor = this.symbol.strokeColor) != null) {
            if (painter.isInactiveMode() || n.isDisabled()) {
                strokeColor = settings.getInactiveColor();
            } else if (this.defaultSelectedHandling && selected) {
                strokeColor = settings.getSelectedColor(strokeColor.getAlpha());
            } else if (member) {
                strokeColor = settings.getRelationSelectedColor(strokeColor.getAlpha());
            }
        }
        painter.drawNodeSymbol(n, this.symbol, fillColor, strokeColor);
    }

    public BoxTextElement.BoxProvider getBoxProvider() {
        if (this.mapImage != null) {
            return this.mapImage.getBoxProvider();
        }
        if (this.symbol != null) {
            return new BoxTextElement.SimpleBoxProvider(new Rectangle(-this.symbol.size / 2, -this.symbol.size / 2, this.symbol.size, this.symbol.size));
        }
        int size = NodeElement.max(Config.getPref().getInt("mappaint.node.selected-size", 5), Config.getPref().getInt("mappaint.node.unselected-size", 3), Config.getPref().getInt("mappaint.node.connection-size", 5), Config.getPref().getInt("mappaint.node.tagged-size", 3));
        return new BoxTextElement.SimpleBoxProvider(new Rectangle(-size / 2, -size / 2, size, size));
    }

    private static int max(int ... elements) {
        return IntStream.of(elements).max().orElseThrow(IllegalStateException::new);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mapImage, this.mapImageAngle, this.symbol);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        NodeElement that = (NodeElement)obj;
        return Objects.equals(this.mapImage, that.mapImage) && Objects.equals(this.mapImageAngle, that.mapImageAngle) && Objects.equals(this.symbol, that.symbol);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(64).append("NodeElement{").append(super.toString());
        if (this.mapImage != null) {
            s.append(" icon=[" + this.mapImage + ']');
        }
        if (this.mapImage != null && this.mapImageAngle != null) {
            s.append(" mapImageAngle=[" + this.mapImageAngle + ']');
        }
        if (this.symbol != null) {
            s.append(" symbol=[" + this.symbol + ']');
        }
        s.append('}');
        return s.toString();
    }

    static {
        MultiCascade mc = new MultiCascade();
        mc.getOrCreateCascade("default");
        SIMPLE_NODE_ELEMSTYLE = NodeElement.create(new Environment(null, mc, "default", null), 4.1f, true);
        if (SIMPLE_NODE_ELEMSTYLE == null) {
            throw new AssertionError();
        }
        SIMPLE_NODE_ELEMSTYLE_BOXPROVIDER = SIMPLE_NODE_ELEMSTYLE.getBoxProvider();
        DEFAULT_NODE_STYLELIST = new StyleElementList(SIMPLE_NODE_ELEMSTYLE);
        DEFAULT_NODE_STYLELIST_TEXT = new StyleElementList(SIMPLE_NODE_ELEMSTYLE, BoxTextElement.SIMPLE_NODE_TEXT_ELEMSTYLE);
    }
}

