/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionStub;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.MethodReferenceResolver;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.conflictResolvers.DuplicateConflictResolver;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodReferenceExpressionImpl
extends JavaStubPsiElement<FunctionalExpressionStub<PsiMethodReferenceExpression>>
implements PsiMethodReferenceExpression {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiMethodReferenceExpressionImpl");
    private static final MethodReferenceResolver RESOLVER = new MethodReferenceResolver();

    public PsiMethodReferenceExpressionImpl(@NotNull FunctionalExpressionStub<PsiMethodReferenceExpression> stub) {
        if (stub == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(0);
        }
        super(stub, JavaStubElementTypes.METHOD_REFERENCE);
    }

    public PsiMethodReferenceExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(1);
        }
        super(node);
    }

    @Override
    public PsiTypeElement getQualifierType() {
        PsiElement qualifier = this.getQualifier();
        return qualifier instanceof PsiTypeElement ? (PsiTypeElement)qualifier : null;
    }

    @Override
    @Nullable
    public PsiType getFunctionalInterfaceType() {
        return this.getGroundTargetType(LambdaUtil.getFunctionalInterfaceType(this, true));
    }

    @Override
    public boolean isExact() {
        return this.getPotentiallyApplicableMember() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPotentiallyCompatible(PsiType functionalInterfaceType) {
        JavaResolveResult[] result2;
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(functionalInterfaceType);
        if (interfaceMethod == null) {
            return false;
        }
        MethodReferenceResolver resolver2 = new MethodReferenceResolver(){

            @Override
            protected PsiConflictResolver createResolver(PsiMethodReferenceExpressionImpl referenceExpression, PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, PsiMethod interfaceMethod, MethodSignature signature) {
                return DuplicateConflictResolver.INSTANCE;
            }
        };
        Map<PsiElement, PsiType> map2 = LambdaUtil.getFunctionalTypeMap();
        PsiType added = map2.put(this, functionalInterfaceType);
        try {
            result2 = resolver2.resolve(this, this.getContainingFile(), false);
        }
        finally {
            if (added == null) {
                map2.remove(this);
            }
        }
        PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(this);
        int interfaceArity = interfaceMethod.getParameterList().getParametersCount();
        for (JavaResolveResult resolveResult : result2) {
            PsiElement element = resolveResult.getElement();
            if (element instanceof PsiMethod) {
                boolean isStatic = ((PsiMethod)element).hasModifierProperty("static");
                int parametersCount = ((PsiMethod)element).getParameterList().getParametersCount();
                if (qualifierResolveResult.isReferenceTypeQualified() && this.getReferenceNameElement() instanceof PsiIdentifier) {
                    if (parametersCount == interfaceArity && isStatic) {
                        return true;
                    }
                    if (parametersCount == interfaceArity - 1 && !isStatic) {
                        return true;
                    }
                    if (!((PsiMethod)element).isVarArgs()) continue;
                    return true;
                }
                if (isStatic || parametersCount != interfaceArity && !((PsiMethod)element).isVarArgs()) continue;
                return true;
            }
            if (!(element instanceof PsiClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public PsiType getGroundTargetType(PsiType functionalInterfaceType) {
        return FunctionalInterfaceParameterizationUtil.getGroundTargetType(functionalInterfaceType);
    }

    @Override
    public PsiMember getPotentiallyApplicableMember() {
        return (PsiMember)CachedValuesManager.getCachedValue(this, () -> CachedValueProvider.Result.create(this.getPotentiallyApplicableMemberInternal(), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT, this));
    }

    private PsiMember getPotentiallyApplicableMemberInternal() {
        PsiElement resolve2;
        PsiElement element = this.getReferenceNameElement();
        PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(this);
        PsiClass containingClass = qualifierResolveResult.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        PsiElement qualifier = this.getQualifier();
        if (qualifier instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)qualifier).resolve()) instanceof PsiClass && ((PsiClass)resolve2).hasTypeParameters()) {
            return null;
        }
        PsiMethod[] methods2 = null;
        if (element instanceof PsiIdentifier) {
            String identifierName = element.getText();
            ArrayList<PsiMethod> result2 = new ArrayList<PsiMethod>();
            for (HierarchicalMethodSignature signature : containingClass.getVisibleSignatures()) {
                if (!identifierName.equals(signature.getName())) continue;
                result2.add(signature.getMethod());
            }
            if (result2.isEmpty()) {
                return null;
            }
            methods2 = result2.toArray(PsiMethod.EMPTY_ARRAY);
        } else if (this.isConstructor()) {
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(this.getProject());
            PsiClass arrayClass = factory2.getArrayClass(PsiUtil.getLanguageLevel(this));
            if (arrayClass == containingClass) {
                PsiTypeParameter[] typeParameters2 = arrayClass.getTypeParameters();
                if (typeParameters2.length != 1) {
                    return null;
                }
                PsiType componentType = qualifierResolveResult.getSubstitutor().substitute(typeParameters2[0]);
                LOG.assertTrue(componentType != null, qualifierResolveResult.getSubstitutor());
                return factory2.createMethodFromText("public " + componentType.createArrayType().getCanonicalText() + " __array__(int i) {return null;}", this);
            }
            methods2 = containingClass.getConstructors();
        }
        if (methods2 != null) {
            PsiTypeParameterListOwner psiMethod = null;
            if (methods2.length > 0) {
                for (PsiClass psiClass : methods2) {
                    if (!PsiUtil.isAccessible(psiClass, this, null)) continue;
                    if (psiMethod != null) {
                        return null;
                    }
                    psiMethod = psiClass;
                }
                if (psiMethod == null) {
                    return null;
                }
                if (psiMethod.isVarArgs()) {
                    return null;
                }
                if (psiMethod.getTypeParameters().length > 0) {
                    PsiReferenceParameterList parameterList = this.getParameterList();
                    return parameterList != null && parameterList.getTypeParameterElements().length > 0 ? psiMethod : null;
                }
            }
            return psiMethod == null ? containingClass : psiMethod;
        }
        return null;
    }

    @Override
    public PsiExpression getQualifierExpression() {
        PsiElement qualifier = this.getQualifier();
        return qualifier instanceof PsiExpression ? (PsiExpression)qualifier : null;
    }

    @Override
    public PsiType getType() {
        return new PsiMethodReferenceType(this);
    }

    @Override
    public PsiElement getReferenceNameElement() {
        PsiElement element = this.getLastChild();
        return element instanceof PsiIdentifier || PsiUtil.isJavaToken(element, JavaTokenType.NEW_KEYWORD) ? element : null;
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor2) {
        if (processor2 == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(2);
        }
        FilterScopeProcessor proc = new FilterScopeProcessor((ElementFilter)ElementClassFilter.METHOD, processor2);
        PsiScopesUtil.resolveAndWalk(proc, this, null, true);
    }

    @Override
    public void setQualifierExpression(@Nullable PsiExpression newQualifier) throws IncorrectOperationException {
        if (newQualifier == null) {
            LOG.error("Forbidden null qualifier");
            return;
        }
        PsiExpression expression2 = this.getQualifierExpression();
        if (expression2 != null) {
            expression2.replace(newQualifier);
        } else {
            PsiElement qualifier = this.getQualifier();
            if (qualifier != null) {
                qualifier.replace(newQualifier);
            }
        }
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray = PsiImplUtil.multiResolveImpl(this, incompleteCode, RESOLVER);
        if (javaResolveResultArray == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(3);
        }
        return javaResolveResultArray;
    }

    @Override
    public PsiElement getQualifier() {
        PsiElement element = this.getFirstChild();
        return element instanceof PsiExpression || element instanceof PsiTypeElement ? element : null;
    }

    @Override
    public TextRange getRangeInElement() {
        PsiElement element = this.getReferenceNameElement();
        if (element != null) {
            int offsetInParent = element.getStartOffsetInParent();
            return new TextRange(offsetInParent, offsetInParent + element.getTextLength());
        }
        Object colons = this.findChildByType(JavaTokenType.DOUBLE_COLON);
        if (colons != null) {
            int offsetInParent = colons.getStartOffsetInParent();
            return new TextRange(offsetInParent, offsetInParent + colons.getTextLength());
        }
        LOG.error(this.getText());
        return null;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)element;
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement instanceof PsiIdentifier ? !nameElement.getText().equals(method.getName()) : PsiUtil.isJavaToken(nameElement, JavaTokenType.NEW_KEYWORD) && !method.isConstructor()) {
            return false;
        }
        return element.getManager().areElementsEquivalent(element, this.resolve());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(5);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitMethodReferenceExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(6);
        }
        CheckUtil.checkWritable(this);
        if (this.isReferenceTo(element) || !this.isPhysical()) {
            return this;
        }
        if (element instanceof PsiMethod) {
            return this.handleElementRename(((PsiMethod)element).getName());
        }
        if (element instanceof PsiClass) {
            return this;
        }
        throw new IncorrectOperationException(element.toString());
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        Object oldIdentifier = this.findChildByType(JavaTokenType.IDENTIFIER);
        if (oldIdentifier == null) {
            oldIdentifier = this.findChildByType(JavaElementType.REFERENCE_EXPRESSION);
        }
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        String oldRefName = oldIdentifier.getText();
        if ("this".equals(oldRefName) || "super".equals(oldRefName) || "new".equals(oldRefName) || Comparing.strEqual(oldRefName, newElementName)) {
            return this;
        }
        PsiIdentifier identifier = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createIdentifier(newElementName);
        oldIdentifier.replace(identifier);
        return this;
    }

    @Override
    public boolean isConstructor() {
        PsiElement element = this.getReferenceNameElement();
        return element instanceof PsiKeyword && "new".equals(element.getText());
    }

    @Override
    public String toString() {
        return "PsiMethodReferenceExpression";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAcceptable(PsiType left) {
        JavaResolveResult result2;
        MethodCandidateInfo.CurrentCandidateProperties candidateProperties;
        if (left instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)left).getConjuncts()) {
                if (!this.isAcceptable(conjunct)) continue;
                return true;
            }
            return false;
        }
        PsiExpressionList argsList = PsiTreeUtil.getParentOfType((PsiElement)this, PsiExpressionList.class);
        boolean isExact = this.isExact();
        if (MethodCandidateInfo.ourOverloadGuard.currentStack().contains(argsList) && (candidateProperties = MethodCandidateInfo.getCurrentMethod(argsList)) != null) {
            PsiMethod method = candidateProperties.getMethod();
            if (isExact && !InferenceSession.isPertinentToApplicability(this, method)) {
                return true;
            }
            if (LambdaUtil.isPotentiallyCompatibleWithTypeParameter(this, argsList, method)) {
                return true;
            }
        }
        if (!this.isPotentiallyCompatible(left = this.getGroundTargetType(left))) {
            return false;
        }
        if (MethodCandidateInfo.ourOverloadGuard.currentStack().contains(argsList) && !isExact) {
            return true;
        }
        Map<PsiElement, PsiType> map2 = LambdaUtil.getFunctionalTypeMap();
        try {
            if (map2.put(this, left) != null) {
                boolean bl = false;
                return bl;
            }
            result2 = this.advancedResolve(false);
        }
        finally {
            map2.remove(this);
        }
        if (result2 instanceof MethodCandidateInfo && !((MethodCandidateInfo)result2).isApplicable()) {
            return false;
        }
        PsiElement resolve2 = result2.getElement();
        if (resolve2 == null) {
            return false;
        }
        return PsiMethodReferenceUtil.isReturnTypeCompatible(this, result2, left);
    }

    @Override
    @Nullable
    public Icon getIcon(int flags) {
        return AllIcons.Nodes.MethodReference;
    }

    @Override
    public PsiElement bindToElementViaStaticImport(@NotNull PsiClass qualifierClass) throws IncorrectOperationException {
        if (qualifierClass == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(7);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement getElement() {
        return this;
    }

    @Override
    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(8);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        JavaResolveResult javaResolveResult = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(9);
        }
        return javaResolveResult;
    }

    @Override
    public String getReferenceName() {
        PsiElement element = this.getReferenceNameElement();
        return element != null ? element.getText() : null;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return PsiTreeUtil.getChildOfType(this, PsiReferenceParameterList.class);
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        PsiReferenceParameterList parameterList = this.getParameterList();
        PsiType[] psiTypeArray = parameterList != null ? parameterList.getTypeArguments() : PsiType.EMPTY_ARRAY;
        if (psiTypeArray == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(10);
        }
        return psiTypeArray;
    }

    @Override
    public boolean isQualified() {
        return this.getQualifier() != null;
    }

    @Override
    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "advancedResolve";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processVariants";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "bindToElementViaStaticImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

