/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ImageLoader;
import com.intellij.util.JBHiDPIScaledImage;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import org.jetbrains.annotations.NotNull;

public class ImageUtil {
    public static BufferedImage toBufferedImage(@NotNull Image image) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(0);
        }
        return ImageUtil.toBufferedImage(image, false);
    }

    public static BufferedImage toBufferedImage(@NotNull Image image, boolean inUserSize) {
        JBHiDPIScaledImage jbImage;
        Image img;
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(1);
        }
        if (image instanceof JBHiDPIScaledImage && (img = (jbImage = (JBHiDPIScaledImage)image).getDelegate()) != null) {
            if (inUserSize) {
                double scale = jbImage.getScale();
                img = ImageUtil.scaleImage(img, 1.0 / scale);
            }
            image = img;
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        final int width = image.getWidth(null);
        final int height = image.getHeight(null);
        if (width <= 0 || height <= 0) {
            return new BufferedImage(Math.max(width, 1), Math.max(height, 1), 2){

                @Override
                public int getWidth() {
                    return Math.max(width, 0);
                }

                @Override
                public int getHeight() {
                    return Math.max(height, 0);
                }

                @Override
                public int getWidth(ImageObserver observer) {
                    return Math.max(width, 0);
                }

                @Override
                public int getHeight(ImageObserver observer) {
                    return Math.max(height, 0);
                }
            };
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bufferedImage;
    }

    public static int getUserWidth(@NotNull Image image) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(4);
        }
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).getUserWidth(null);
        }
        return image.getWidth(null);
    }

    public static int getUserHeight(@NotNull Image image) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(5);
        }
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).getUserHeight(null);
        }
        return image.getHeight(null);
    }

    public static Image filter(Image image, ImageFilter filter2) {
        if (image == null || filter2 == null) {
            return image;
        }
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(ImageUtil.toBufferedImage(image).getSource(), filter2));
    }

    public static Image scaleImage(Image image, double scale) {
        return ImageLoader.scaleImage(image, scale);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "image";
        objectArray2[1] = "com/intellij/util/ui/ImageUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "toBufferedImage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRealWidth";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getRealHeight";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getUserWidth";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getUserHeight";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

