/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.HasPrefixedName;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public final class EntityType<E extends OWLEntity>
implements Serializable,
HasShortForm,
HasPrefixedName,
HasIRI {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    public static final EntityType<OWLClass> CLASS = new EntityType("Class", "Class", "Classes", OWLRDFVocabulary.OWL_CLASS);
    @Nonnull
    public static final EntityType<OWLObjectProperty> OBJECT_PROPERTY = new EntityType("ObjectProperty", "Object property", "Object properties", OWLRDFVocabulary.OWL_OBJECT_PROPERTY);
    @Nonnull
    public static final EntityType<OWLDataProperty> DATA_PROPERTY = new EntityType("DataProperty", "Data property", "Data properties", OWLRDFVocabulary.OWL_DATA_PROPERTY);
    @Nonnull
    public static final EntityType<OWLAnnotationProperty> ANNOTATION_PROPERTY = new EntityType("AnnotationProperty", "Annotation property", "Annotation properties", OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY);
    @Nonnull
    public static final EntityType<OWLNamedIndividual> NAMED_INDIVIDUAL = new EntityType("NamedIndividual", "Named individual", "Named individuals", OWLRDFVocabulary.OWL_NAMED_INDIVIDUAL);
    @Nonnull
    public static final EntityType<OWLDatatype> DATATYPE = new EntityType("Datatype", "Datatype", "Datatypes", OWLRDFVocabulary.RDFS_DATATYPE);
    private static final List<EntityType<?>> VALUES = Collections.unmodifiableList(Arrays.asList(CLASS, OBJECT_PROPERTY, DATA_PROPERTY, ANNOTATION_PROPERTY, NAMED_INDIVIDUAL, DATATYPE));
    @Nonnull
    private final String name;
    @Nonnull
    private final OWLRDFVocabulary vocabulary;
    @Nonnull
    private final String printName;
    @Nonnull
    private final String pluralPrintName;

    private EntityType(@Nonnull String name, @Nonnull String print, @Nonnull String pluralPrint, @Nonnull OWLRDFVocabulary vocabulary) {
        this.name = name;
        this.vocabulary = vocabulary;
        this.printName = print;
        this.pluralPrintName = pluralPrint;
    }

    public OWLRDFVocabulary getVocabulary() {
        return this.vocabulary;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static List<EntityType<?>> values() {
        return VALUES;
    }

    @Nonnull
    public String getPrintName() {
        return this.printName;
    }

    @Nonnull
    public String getPluralPrintName() {
        return this.pluralPrintName;
    }

    @Override
    public String getShortForm() {
        return this.name;
    }

    @Override
    public String getPrefixedName() {
        return this.vocabulary.getPrefixedName();
    }

    @Override
    public IRI getIRI() {
        return this.vocabulary.getIRI();
    }
}

