/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.util;

import java.lang.reflect.Method;
import javax.swing.JOptionPane;
import org.protege.editor.core.platform.OSUtils;

public class NativeBrowserLauncher {
    private static final String errMsg = "Sorry, could not launch web browser";

    public static void openURL(String url) {
        try {
            if (OSUtils.isOSX()) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (OSUtils.isWindows()) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Sorry, could not launch web browser:\n" + e.getLocalizedMessage());
        }
    }
}

