from pybtex.bibtex.interpreter import (
    Integer, String, QuotedVar, Identifier, FunctionLiteral,
)

bst = [[u'FUNCTION',
  [Identifier(u'identify.apacite.version')],
  [String(u'apacite.bst'),
   String(u' [2009/03/01 v4.05 APA bibliography style]'),
   Identifier(u'*'),
   Identifier(u'top$')]],
 [u'ENTRY',
  [Identifier(u'address'),
   Identifier(u'annote'),
   Identifier(u'annotate'),
   Identifier(u'author'),
   Identifier(u'booktitle'),
   Identifier(u'chair'),
   Identifier(u'chapter'),
   Identifier(u'day'),
   Identifier(u'edition'),
   Identifier(u'editor'),
   Identifier(u'englishtitle'),
   Identifier(u'firstkey'),
   Identifier(u'howpublished'),
   Identifier(u'institution'),
   Identifier(u'journal'),
   Identifier(u'key'),
   Identifier(u'lastchecked'),
   Identifier(u'month'),
   Identifier(u'note'),
   Identifier(u'number'),
   Identifier(u'organization'),
   Identifier(u'originaladdress'),
   Identifier(u'originalbooktitle'),
   Identifier(u'originaledition'),
   Identifier(u'originaleditor'),
   Identifier(u'originaljournal'),
   Identifier(u'originalnumber'),
   Identifier(u'originalpages'),
   Identifier(u'originalpublisher'),
   Identifier(u'originalvolume'),
   Identifier(u'originalyear'),
   Identifier(u'pages'),
   Identifier(u'publisher'),
   Identifier(u'school'),
   Identifier(u'series'),
   Identifier(u'symposium'),
   Identifier(u'text'),
   Identifier(u'title'),
   Identifier(u'translator'),
   Identifier(u'type'),
   Identifier(u'url'),
   Identifier(u'volume'),
   Identifier(u'year')],
  [Identifier(u'title.number'),
   Identifier(u'cite.initials'),
   Identifier(u'cite.num.names.full'),
   Identifier(u'cite.num.names.short'),
   Identifier(u'add.to.year')],
  [Identifier(u'year.label'),
   Identifier(u'author.year.sort.label'),
   Identifier(u'title.sort.label'),
   Identifier(u'type.2')]],
 [u'INTEGERS',
  [Identifier(u'len'),
   Identifier(u'pos'),
   Identifier(u'name.max'),
   Identifier(u'old.number'),
   Identifier(u'numnames'),
   Identifier(u'numnames.old'),
   Identifier(u'nameptr'),
   Identifier(u'lastname'),
   Identifier(u'format.num.names'),
   Identifier(u'cite.initials.old'),
   Identifier(u'cite.num.names.old'),
   Identifier(u'add.to.year.old'),
   Identifier(u'forward'),
   Identifier(u'multiresult'),
   Identifier(u'dot'),
   Identifier(u'brace.level')]],
 [u'STRINGS',
  [Identifier(u's'),
   Identifier(u't'),
   Identifier(u'u'),
   Identifier(u'old.label'),
   Identifier(u'field'),
   Identifier(u'aut1f'),
   Identifier(u'aut1s'),
   Identifier(u'aut1f.old'),
   Identifier(u'aut1s.old'),
   Identifier(u'aut2'),
   Identifier(u'aut2.old'),
   Identifier(u'aut3'),
   Identifier(u'aut3.old'),
   Identifier(u'aut4'),
   Identifier(u'aut4.old'),
   Identifier(u'aut5'),
   Identifier(u'aut5.old'),
   Identifier(u'aut6'),
   Identifier(u'aut6.old'),
   Identifier(u'year.label.old')]],
 [u'FUNCTION', [Identifier(u'test')], [Integer(0)]],
 [u'FUNCTION', [Identifier(u'make.index')], [Integer(0)]],
 [u'MACRO', [Identifier(u'jan')], [String(u'{\\APACmonth{01}}')]],
 [u'MACRO', [Identifier(u'feb')], [String(u'{\\APACmonth{02}}')]],
 [u'MACRO', [Identifier(u'mar')], [String(u'{\\APACmonth{03}}')]],
 [u'MACRO', [Identifier(u'apr')], [String(u'{\\APACmonth{04}}')]],
 [u'MACRO', [Identifier(u'may')], [String(u'{\\APACmonth{05}}')]],
 [u'MACRO', [Identifier(u'jun')], [String(u'{\\APACmonth{06}}')]],
 [u'MACRO', [Identifier(u'jul')], [String(u'{\\APACmonth{07}}')]],
 [u'MACRO', [Identifier(u'aug')], [String(u'{\\APACmonth{08}}')]],
 [u'MACRO', [Identifier(u'sep')], [String(u'{\\APACmonth{09}}')]],
 [u'MACRO', [Identifier(u'oct')], [String(u'{\\APACmonth{10}}')]],
 [u'MACRO', [Identifier(u'nov')], [String(u'{\\APACmonth{11}}')]],
 [u'MACRO', [Identifier(u'dec')], [String(u'{\\APACmonth{12}}')]],
 [u'MACRO', [Identifier(u'winter')], [String(u'{\\APACmonth{13}}')]],
 [u'MACRO', [Identifier(u'spring')], [String(u'{\\APACmonth{14}}')]],
 [u'MACRO', [Identifier(u'summer')], [String(u'{\\APACmonth{15}}')]],
 [u'MACRO', [Identifier(u'fall')], [String(u'{\\APACmonth{16}}')]],
 [u'FUNCTION',
  [Identifier(u'not')],
  [FunctionLiteral([Integer(0)]),
   FunctionLiteral([Integer(1)]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'and')],
  [QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'pop$'), Integer(0)]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'or')],
  [FunctionLiteral([Identifier(u'pop$'), Integer(1)]),
   QuotedVar(u'skip$'),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'warning.if.empty')],
  [Identifier(u'empty$'),
   FunctionLiteral([String(u'No '), Identifier(u'swap$'), Identifier(u'*'), String(u' in '), Identifier(u'*'), Identifier(u'cite$'), Identifier(u'*'), Identifier(u'warning$')]),
   FunctionLiteral([Identifier(u'pop$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'check.relevant.fields')],
  [Identifier(u'title'),
   Identifier(u'empty$'),
   Identifier(u'type'),
   Identifier(u'empty$'),
   Identifier(u'and'),
   Identifier(u'howpublished'),
   Identifier(u'empty$'),
   Identifier(u'and'),
   FunctionLiteral([String(u'No title, type, and howpublished in '), Identifier(u'cite$'), Identifier(u'*'), Identifier(u'warning$')]),
   QuotedVar(u'skip$'),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'editor.ne.trans')],
  [Identifier(u'translator'),
   Identifier(u'empty$'),
   FunctionLiteral([Integer(0)]),
   FunctionLiteral([Identifier(u'editor'), Identifier(u'empty$'), FunctionLiteral([Integer(0)]), FunctionLiteral([Identifier(u'translator'), Identifier(u'editor'), Identifier(u'='), FunctionLiteral([Integer(0)]), FunctionLiteral([Integer(1)]), Identifier(u'if$')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'conv.int.to.str')],
  [Identifier(u'duplicate$'),
   Integer(10),
   Identifier(u'<'),
   FunctionLiteral([String(u'0000'), Identifier(u'swap$'), Identifier(u'int.to.str$'), Identifier(u'*')]),
   FunctionLiteral([Identifier(u'duplicate$'), Integer(100), Identifier(u'<'), FunctionLiteral([String(u'000'), Identifier(u'swap$'), Identifier(u'int.to.str$'), Identifier(u'*')]), FunctionLiteral([Identifier(u'duplicate$'), Integer(1000), Identifier(u'<'), FunctionLiteral([String(u'00'), Identifier(u'swap$'), Identifier(u'int.to.str$'), Identifier(u'*')]), FunctionLiteral([Identifier(u'duplicate$'), Integer(10000), Identifier(u'<'), FunctionLiteral([String(u'0'), Identifier(u'swap$'), Identifier(u'int.to.str$'), Identifier(u'*')]), FunctionLiteral([Identifier(u'int.to.str$')]), Identifier(u'if$')]), Identifier(u'if$')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'ref.type')],
  [Identifier(u'type$'),
   String(u'article'),
   Identifier(u'='),
   Identifier(u'type$'),
   String(u'magazine'),
   Identifier(u'='),
   Identifier(u'type$'),
   String(u'newspaper'),
   Identifier(u'='),
   Identifier(u'type$'),
   String(u'book'),
   Identifier(u'='),
   Identifier(u'type$'),
   String(u'techreport'),
   Identifier(u'='),
   Identifier(u'type$'),
   String(u'unpublished'),
   Identifier(u'='),
   Identifier(u'type$'),
   String(u'misc'),
   Identifier(u'='),
   Identifier(u'type$'),
   String(u'booklet'),
   Identifier(u'='),
   Identifier(u'type$'),
   String(u'manual'),
   Identifier(u'='),
   Identifier(u'type$'),
   String(u'proceedings'),
   Identifier(u'='),
   Identifier(u'or'),
   Identifier(u'or'),
   Identifier(u'or'),
   Identifier(u'or'),
   Identifier(u'or'),
   Identifier(u'or'),
   Identifier(u'or'),
   Identifier(u'or'),
   Identifier(u'or'),
   FunctionLiteral([Integer(1)]),
   FunctionLiteral([Identifier(u'type$'), String(u'incollection'), Identifier(u'='), Identifier(u'type$'), String(u'phdthesis'), Identifier(u'='), Identifier(u'type$'), String(u'mastersthesis'), Identifier(u'='), Identifier(u'type$'), String(u'lecture'), Identifier(u'='), Identifier(u'type$'), String(u'inbook'), Identifier(u'='), Identifier(u'type$'), String(u'inproceedings'), Identifier(u'='), Identifier(u'type$'), String(u'conference'), Identifier(u'='), Identifier(u'type$'), String(u'intechreport'), Identifier(u'='), Identifier(u'or'), Identifier(u'or'), Identifier(u'or'), Identifier(u'or'), Identifier(u'or'), Identifier(u'or'), Identifier(u'or'), FunctionLiteral([Integer(2)]), FunctionLiteral([Identifier(u'type$'), String(u'literal'), Identifier(u'='), FunctionLiteral([Integer(3)]), FunctionLiteral([Integer(0)]), Identifier(u'if$')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'is.atype')],
  [Identifier(u'type$'),
   String(u'article'),
   Identifier(u'='),
   Identifier(u'type$'),
   String(u'magazine'),
   Identifier(u'='),
   Identifier(u'type$'),
   String(u'newspaper'),
   Identifier(u'='),
   Identifier(u'type$'),
   String(u'incollection'),
   Identifier(u'='),
   Identifier(u'type$'),
   String(u'inbook'),
   Identifier(u'='),
   Identifier(u'type$'),
   String(u'inproceedings'),
   Identifier(u'='),
   Identifier(u'type$'),
   String(u'conference'),
   Identifier(u'='),
   Identifier(u'type$'),
   String(u'intechreport'),
   Identifier(u'='),
   Identifier(u'type$'),
   String(u'manual'),
   Identifier(u'='),
   Identifier(u'or'),
   Identifier(u'or'),
   Identifier(u'or'),
   Identifier(u'or'),
   Identifier(u'or'),
   Identifier(u'or'),
   Identifier(u'or'),
   Identifier(u'or'),
   FunctionLiteral([Integer(1)]),
   FunctionLiteral([Identifier(u'journal'), Identifier(u'empty$'), Identifier(u'not'), Identifier(u'type$'), String(u'phdthesis'), Identifier(u'='), Identifier(u'type$'), String(u'mastersthesis'), Identifier(u'='), Identifier(u'or'), Identifier(u'and'), FunctionLiteral([Integer(1)]), FunctionLiteral([Identifier(u'type$'), String(u'misc'), Identifier(u'='), Identifier(u'type'), Identifier(u'empty$'), Identifier(u'not'), Identifier(u'and'), FunctionLiteral([Identifier(u'type'), String(u'\\bibmessage'), Identifier(u'='), Identifier(u'type'), String(u'\\bibcomputerprogram'), Identifier(u'='), Identifier(u'type'), String(u'\\bibcomputerprogrammanual'), Identifier(u'='), Identifier(u'type'), String(u'\\bibcomputerprogramandmanual'), Identifier(u'='), Identifier(u'type'), String(u'\\bibcomputersoftware'), Identifier(u'='), Identifier(u'type'), String(u'\\bibcomputersoftwaremanual'), Identifier(u'='), Identifier(u'type'), String(u'\\bibcomputersoftwareandmanual'), Identifier(u'='), Identifier(u'type'), String(u'\\bibprogramminglanguage'), Identifier(u'='), Identifier(u'or'), Identifier(u'or'), Identifier(u'or'), Identifier(u'or'), Identifier(u'or'), Identifier(u'or'), Identifier(u'or'), FunctionLiteral([Integer(1)]), FunctionLiteral([Integer(0)]), Identifier(u'if$')]), FunctionLiteral([Integer(0)]), Identifier(u'if$')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'connect.check')],
  [QuotedVar(u'u'),
   Identifier(u':='),
   Identifier(u'duplicate$'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'pop$'), Identifier(u'duplicate$'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'pop$'), String(u'')]), QuotedVar(u'skip$'), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'swap$'), Identifier(u'duplicate$'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'pop$')]), FunctionLiteral([Identifier(u'u'), Identifier(u'*'), Identifier(u'swap$'), Identifier(u'*')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'tie.or.space.connect')],
  [Identifier(u'duplicate$'),
   Identifier(u'text.length$'),
   Integer(4),
   Identifier(u'<'),
   FunctionLiteral([String(u'~')]),
   FunctionLiteral([String(u'\\ ')]),
   Identifier(u'if$'),
   Identifier(u'swap$'),
   Identifier(u'*'),
   Identifier(u'*')]],
 [u'FUNCTION',
  [Identifier(u'connect.with.comma.check')],
  [String(u', '), Identifier(u'connect.check')]],
 [u'FUNCTION',
  [Identifier(u'connect.with.semicolon.check')],
  [String(u'; '), Identifier(u'connect.check')]],
 [u'FUNCTION',
  [Identifier(u'connect.with.colon.check')],
  [String(u': '), Identifier(u'connect.check')]],
 [u'FUNCTION',
  [Identifier(u'connect.with.space.check')],
  [String(u'\\ '), Identifier(u'connect.check')]],
 [u'FUNCTION',
  [Identifier(u'enclose.check')],
  [Identifier(u'duplicate$'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'pop$'), Identifier(u'pop$'), Identifier(u'pop$'), String(u'')]),
   FunctionLiteral([Identifier(u'swap$'), Identifier(u'*'), Identifier(u'*')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'emphasize.check')],
  [String(u'\\Bem{'),
   Identifier(u'swap$'),
   String(u'}'),
   Identifier(u'swap$'),
   Identifier(u'enclose.check')]],
 [u'FUNCTION',
  [Identifier(u'bracket.check')],
  [String(u'['),
   Identifier(u'swap$'),
   String(u']'),
   Identifier(u'swap$'),
   Identifier(u'enclose.check')]],
 [u'FUNCTION',
  [Identifier(u'parenthesize.check')],
  [String(u'('),
   Identifier(u'swap$'),
   String(u')'),
   Identifier(u'swap$'),
   Identifier(u'enclose.check')]],
 [u'FUNCTION',
  [Identifier(u'multi.result.check')],
  [QuotedVar(u't'),
   Identifier(u':='),
   Integer(0),
   QuotedVar(u'multiresult'),
   Identifier(u':='),
   FunctionLiteral([Identifier(u'multiresult'), Identifier(u'not'), Identifier(u't'), Identifier(u'text.length$'), Integer(1), Identifier(u'>'), Identifier(u'and')]),
   FunctionLiteral([Identifier(u't'), Integer(1), Integer(2), Identifier(u'substring$'), QuotedVar(u's'), Identifier(u':='), String(u'--'), Identifier(u's'), Identifier(u'='), FunctionLiteral([Integer(1), QuotedVar(u'multiresult'), Identifier(u':=')]), FunctionLiteral([Identifier(u't'), Integer(1), Integer(1), Identifier(u'substring$'), QuotedVar(u's'), Identifier(u':='), String(u'+'), Identifier(u's'), Identifier(u'='), String(u','), Identifier(u's'), Identifier(u'='), Identifier(u'or'), FunctionLiteral([Integer(1), QuotedVar(u'multiresult'), Identifier(u':=')]), FunctionLiteral([Identifier(u't'), Integer(2), Identifier(u'global.max$'), Identifier(u'substring$'), QuotedVar(u't'), Identifier(u':=')]), Identifier(u'if$')]), Identifier(u'if$')]),
   Identifier(u'while$'),
   Identifier(u'multiresult')]],
 [u'FUNCTION',
  [Identifier(u'is.bibcorporate')],
  [Integer(1),
   Integer(14),
   Identifier(u'substring$'),
   String(u'{\\bibcorporate'),
   Identifier(u'=')]],
 [u'FUNCTION',
  [Identifier(u'sortify')],
  [Identifier(u'purify$'), String(u'l'), Identifier(u'change.case$')]],
 [u'FUNCTION',
  [Identifier(u'remove.spaces')],
  [QuotedVar(u's'),
   Identifier(u':='),
   Identifier(u's'),
   Identifier(u'text.length$'),
   QuotedVar(u'len'),
   Identifier(u':='),
   String(u''),
   QuotedVar(u't'),
   Identifier(u':='),
   Integer(0),
   QuotedVar(u'pos'),
   Identifier(u':='),
   FunctionLiteral([Identifier(u'pos'), Identifier(u'len'), Identifier(u'<')]),
   FunctionLiteral([Identifier(u'pos'), Integer(1), Identifier(u'+'), QuotedVar(u'pos'), Identifier(u':='), Identifier(u's'), Identifier(u'pos'), Integer(1), Identifier(u'substring$'), QuotedVar(u'u'), Identifier(u':='), Identifier(u'u'), String(u' '), Identifier(u'='), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u't'), Identifier(u'u'), Identifier(u'*'), QuotedVar(u't'), Identifier(u':=')]), Identifier(u'if$')]),
   Identifier(u'while$'),
   Identifier(u't')]],
 [u'FUNCTION',
  [Identifier(u'output.end.block')],
  [Identifier(u'write$'), Identifier(u'newline$')]],
 [u'FUNCTION',
  [Identifier(u'output.new.block')],
  [Identifier(u'output.end.block'),
   String(u'\\newblock'),
   Identifier(u'write$'),
   Identifier(u'newline$')]],
 [u'FUNCTION',
  [Identifier(u'output.dot.new.block')],
  [Identifier(u'add.period$'), Identifier(u'output.new.block')]],
 [u'FUNCTION',
  [Identifier(u'start.new.block')],
  [Identifier(u'newline$'),
   String(u'\\unskip\\ '),
   Identifier(u'write$'),
   Identifier(u'newline$'),
   String(u'\\newblock '),
   Identifier(u'write$'),
   Identifier(u'newline$')]],
 [u'FUNCTION',
  [Identifier(u'fin.entry')],
  [Identifier(u'output.end.block'),
   String(u'\\PrintBackRefs{\\CurrentBib}'),
   Identifier(u'write$'),
   Identifier(u'newline$'),
   Identifier(u'test'),
   FunctionLiteral([String(u'\\vspace{\\baselineskip}'), Identifier(u'write$'), Identifier(u'newline$')]),
   QuotedVar(u'skip$'),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'sort.name.format')],
  [String(u'{ll{}}{  f{}}{  vv{}}{  jj{}}')]],
 [u'FUNCTION', [Identifier(u'cite.name.format')], [String(u'{ll}')]],
 [u'FUNCTION',
  [Identifier(u'cite.initials.name.format')],
  [String(u'{f{\\BPBI }.~~}{vv }{ll}{ jj}')]],
 [u'FUNCTION',
  [Identifier(u'author.name.format')],
  [String(u'{ll}{, f{\\BPBI }.}{ vv}{, jj}')]],
 [u'FUNCTION',
  [Identifier(u'editor.name.format')],
  [String(u'{f{\\BPBI }.~~}{vv }{ll}{ jj}')]],
 [u'FUNCTION',
  [Identifier(u'index.name.format')],
  [String(u'{ll}{, f{\\BPBI }.}{ vv}{, jj}')]],
 [u'FUNCTION',
  [Identifier(u'init.initials')],
  [String(u'yyyyy'),
   QuotedVar(u'aut1f.old'),
   Identifier(u':='),
   String(u'yyyyy'),
   QuotedVar(u'aut1s.old'),
   Identifier(u':='),
   Integer(0),
   QuotedVar(u'cite.initials.old'),
   Identifier(u':=')]],
 [u'FUNCTION',
  [Identifier(u'update.no.initials')],
  [QuotedVar(u'field'),
   Identifier(u':='),
   Identifier(u'field'),
   QuotedVar(u'aut1f.old'),
   Identifier(u':='),
   Identifier(u'field'),
   QuotedVar(u'aut1s.old'),
   Identifier(u':='),
   Integer(0),
   QuotedVar(u'cite.initials.old'),
   Identifier(u':=')]],
 [u'FUNCTION',
  [Identifier(u'check.add.initials.aut')],
  [Identifier(u'aut1s'),
   Identifier(u'aut1s.old'),
   Identifier(u'='),
   FunctionLiteral([Identifier(u'aut1f'), Identifier(u'aut1f.old'), Identifier(u'='), FunctionLiteral([Identifier(u'cite.initials.old'), QuotedVar(u'cite.initials'), Identifier(u':=')]), FunctionLiteral([Integer(1), QuotedVar(u'cite.initials'), Identifier(u':='), Identifier(u'aut1f'), QuotedVar(u'aut1f.old'), Identifier(u':='), Identifier(u'aut1s'), QuotedVar(u'aut1s.old'), Identifier(u':='), Identifier(u'cite.initials'), QuotedVar(u'cite.initials.old'), Identifier(u':=')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'aut1f'), QuotedVar(u'aut1f.old'), Identifier(u':='), Identifier(u'aut1s'), QuotedVar(u'aut1s.old'), Identifier(u':='), Identifier(u'cite.initials'), QuotedVar(u'cite.initials.old'), Identifier(u':=')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'check.add.initials.field')],
  [QuotedVar(u'field'),
   Identifier(u':='),
   Identifier(u'field'),
   Integer(1),
   Identifier(u'cite.initials.name.format'),
   Identifier(u'format.name$'),
   QuotedVar(u'aut1f'),
   Identifier(u':='),
   Identifier(u'field'),
   Integer(1),
   Identifier(u'cite.name.format'),
   Identifier(u'format.name$'),
   QuotedVar(u'aut1s'),
   Identifier(u':='),
   Identifier(u'check.add.initials.aut')]],
 [u'FUNCTION',
  [Identifier(u'check.add.initials')],
  [Identifier(u'firstkey'),
   Identifier(u'empty$'),
   Identifier(u'not'),
   FunctionLiteral([Identifier(u'key'), Identifier(u'empty$'), Identifier(u'not'), FunctionLiteral([Identifier(u'firstkey'), Identifier(u'sortify'), Identifier(u'remove.spaces'), QuotedVar(u'aut1f'), Identifier(u':='), Identifier(u'key'), Identifier(u'sortify'), Identifier(u'remove.spaces'), QuotedVar(u'aut1s'), Identifier(u':='), Identifier(u'check.add.initials.aut')]), FunctionLiteral([Identifier(u'firstkey'), Identifier(u'sortify'), Identifier(u'remove.spaces'), Identifier(u'update.no.initials')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'key'), Identifier(u'empty$'), Identifier(u'not'), FunctionLiteral([Identifier(u'key'), Identifier(u'sortify'), Identifier(u'remove.spaces'), Identifier(u'update.no.initials')]), FunctionLiteral([Identifier(u'ref.type'), Integer(2), Identifier(u'='), FunctionLiteral([Identifier(u'author'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'title.sort.label'), Identifier(u'update.no.initials')]), FunctionLiteral([Identifier(u'author'), Identifier(u'check.add.initials.field')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'author'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'editor'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'title.sort.label'), Identifier(u'update.no.initials')]), FunctionLiteral([Identifier(u'editor'), Identifier(u'check.add.initials.field')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'author'), Identifier(u'check.add.initials.field')]), Identifier(u'if$')]), Identifier(u'if$')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'tentative.cite.num.names.field')],
  [QuotedVar(u'field'),
   Identifier(u':='),
   Identifier(u'field'),
   Identifier(u'num.names$'),
   QuotedVar(u'numnames'),
   Identifier(u':='),
   Identifier(u'numnames'),
   Integer(3),
   Identifier(u'<'),
   FunctionLiteral([Identifier(u'numnames'), QuotedVar(u'cite.num.names.full'), Identifier(u':='), Identifier(u'numnames'), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]),
   FunctionLiteral([Identifier(u'numnames'), Integer(6), Identifier(u'<'), FunctionLiteral([Identifier(u'numnames'), QuotedVar(u'cite.num.names.full'), Identifier(u':='), Integer(1), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), FunctionLiteral([Integer(1), QuotedVar(u'cite.num.names.full'), Identifier(u':='), Integer(1), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'tentative.cite.num.names')],
  [Identifier(u'firstkey'),
   Identifier(u'empty$'),
   Identifier(u'not'),
   FunctionLiteral([Integer(1), QuotedVar(u'cite.num.names.full'), Identifier(u':='), Integer(1), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]),
   FunctionLiteral([Identifier(u'key'), Identifier(u'empty$'), Identifier(u'not'), FunctionLiteral([Integer(1), QuotedVar(u'cite.num.names.full'), Identifier(u':='), Integer(1), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), FunctionLiteral([Identifier(u'ref.type'), Integer(2), Identifier(u'='), FunctionLiteral([Identifier(u'author'), Identifier(u'empty$'), FunctionLiteral([Integer(1), QuotedVar(u'cite.num.names.full'), Identifier(u':='), Integer(1), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), FunctionLiteral([Identifier(u'author'), Identifier(u'tentative.cite.num.names.field')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'author'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'editor'), Identifier(u'empty$'), FunctionLiteral([Integer(1), QuotedVar(u'cite.num.names.full'), Identifier(u':='), Integer(1), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), FunctionLiteral([Identifier(u'editor'), Identifier(u'tentative.cite.num.names.field')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'author'), Identifier(u'tentative.cite.num.names.field')]), Identifier(u'if$')]), Identifier(u'if$')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'init.cite.num.names')],
  [Integer(0),
   QuotedVar(u'cite.num.names.old'),
   Identifier(u':='),
   Integer(0),
   QuotedVar(u'numnames.old'),
   Identifier(u':='),
   String(u'yyyy'),
   QuotedVar(u'year.label.old'),
   Identifier(u':='),
   Integer(0),
   QuotedVar(u'add.to.year.old'),
   Identifier(u':='),
   String(u''),
   QuotedVar(u'aut1f.old'),
   Identifier(u':='),
   String(u''),
   QuotedVar(u'aut2.old'),
   Identifier(u':='),
   String(u''),
   QuotedVar(u'aut3.old'),
   Identifier(u':='),
   String(u''),
   QuotedVar(u'aut4.old'),
   Identifier(u':='),
   String(u''),
   QuotedVar(u'aut5.old'),
   Identifier(u':='),
   String(u''),
   QuotedVar(u'aut6.old'),
   Identifier(u':=')]],
 [u'FUNCTION',
  [Identifier(u'update.cite.num.names')],
  [Identifier(u'cite.num.names.short'),
   QuotedVar(u'cite.num.names.old'),
   Identifier(u':='),
   Identifier(u'numnames'),
   QuotedVar(u'numnames.old'),
   Identifier(u':='),
   Identifier(u'year.label'),
   QuotedVar(u'year.label.old'),
   Identifier(u':='),
   Identifier(u'add.to.year'),
   QuotedVar(u'add.to.year.old'),
   Identifier(u':='),
   Identifier(u'aut1f'),
   QuotedVar(u'aut1f.old'),
   Identifier(u':='),
   Identifier(u'aut2'),
   QuotedVar(u'aut2.old'),
   Identifier(u':='),
   Identifier(u'aut3'),
   QuotedVar(u'aut3.old'),
   Identifier(u':='),
   Identifier(u'aut4'),
   QuotedVar(u'aut4.old'),
   Identifier(u':='),
   Identifier(u'aut5'),
   QuotedVar(u'aut5.old'),
   Identifier(u':='),
   Identifier(u'aut6'),
   QuotedVar(u'aut6.old'),
   Identifier(u':=')]],
 [u'FUNCTION',
  [Identifier(u'format.6.authors')],
  [Identifier(u'field'),
   Integer(1),
   Identifier(u'cite.initials.name.format'),
   Identifier(u'format.name$'),
   QuotedVar(u'aut1f'),
   Identifier(u':='),
   Identifier(u'numnames'),
   Integer(1),
   Identifier(u'>'),
   Identifier(u'name.max'),
   Integer(1),
   Identifier(u'>'),
   Identifier(u'and'),
   FunctionLiteral([Identifier(u'field'), Integer(2), Identifier(u'cite.name.format'), Identifier(u'format.name$'), QuotedVar(u'aut2'), Identifier(u':='), Identifier(u'numnames'), Integer(2), Identifier(u'>'), Identifier(u'name.max'), Integer(2), Identifier(u'>'), Identifier(u'and'), FunctionLiteral([Identifier(u'field'), Integer(3), Identifier(u'cite.name.format'), Identifier(u'format.name$'), QuotedVar(u'aut3'), Identifier(u':='), Identifier(u'numnames'), Integer(3), Identifier(u'>'), Identifier(u'name.max'), Integer(3), Identifier(u'>'), Identifier(u'and'), FunctionLiteral([Identifier(u'field'), Integer(4), Identifier(u'cite.name.format'), Identifier(u'format.name$'), QuotedVar(u'aut4'), Identifier(u':='), Identifier(u'numnames'), Integer(4), Identifier(u'>'), Identifier(u'name.max'), Integer(4), Identifier(u'>'), Identifier(u'and'), FunctionLiteral([Identifier(u'field'), Integer(5), Identifier(u'cite.name.format'), Identifier(u'format.name$'), QuotedVar(u'aut5'), Identifier(u':='), Identifier(u'numnames'), Integer(5), Identifier(u'>'), Identifier(u'name.max'), Integer(5), Identifier(u'>'), Identifier(u'and'), FunctionLiteral([Identifier(u'field'), Integer(6), Identifier(u'cite.name.format'), Identifier(u'format.name$'), QuotedVar(u'aut6'), Identifier(u':=')]), FunctionLiteral([String(u''), QuotedVar(u'aut6'), Identifier(u':=')]), Identifier(u'if$')]), FunctionLiteral([String(u''), QuotedVar(u'aut5'), Identifier(u':='), String(u''), QuotedVar(u'aut6'), Identifier(u':=')]), Identifier(u'if$')]), FunctionLiteral([String(u''), QuotedVar(u'aut4'), Identifier(u':='), String(u''), QuotedVar(u'aut5'), Identifier(u':='), String(u''), QuotedVar(u'aut6'), Identifier(u':=')]), Identifier(u'if$')]), FunctionLiteral([String(u''), QuotedVar(u'aut3'), Identifier(u':='), String(u''), QuotedVar(u'aut4'), Identifier(u':='), String(u''), QuotedVar(u'aut5'), Identifier(u':='), String(u''), QuotedVar(u'aut6'), Identifier(u':=')]), Identifier(u'if$')]),
   FunctionLiteral([String(u''), QuotedVar(u'aut2'), Identifier(u':='), String(u''), QuotedVar(u'aut3'), Identifier(u':='), String(u''), QuotedVar(u'aut4'), Identifier(u':='), String(u''), QuotedVar(u'aut5'), Identifier(u':='), String(u''), QuotedVar(u'aut6'), Identifier(u':=')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'change.add.to.year')],
  [Identifier(u'forward'),
   Integer(1),
   Identifier(u'='),
   FunctionLiteral([Identifier(u'add.to.year.old'), Integer(0), Identifier(u'>'), FunctionLiteral([Identifier(u'add.to.year.old'), Integer(1), Identifier(u'+'), QuotedVar(u'add.to.year'), Identifier(u':=')]), FunctionLiteral([Integer(2), QuotedVar(u'add.to.year'), Identifier(u':=')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'add.to.year.old'), Integer(1), Identifier(u'-'), QuotedVar(u'add.to.year'), Identifier(u':=')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'definitive.cite.num.names.1.or.2')],
  [Identifier(u'numnames'),
   Identifier(u'numnames.old'),
   Identifier(u'='),
   FunctionLiteral([Identifier(u'aut1f'), Identifier(u'aut1f.old'), Identifier(u'='), FunctionLiteral([Identifier(u'aut2'), Identifier(u'aut2.old'), Identifier(u'='), Identifier(u'numnames'), Integer(2), Identifier(u'='), Identifier(u'and'), Identifier(u'numnames'), Integer(1), Identifier(u'='), Identifier(u'or'), FunctionLiteral([Identifier(u'change.add.to.year')]), FunctionLiteral([Identifier(u'skip$')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'skip$')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'skip$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'definitive.cite.num.names.3.or.more')],
  [Identifier(u'aut1f'),
   Identifier(u'aut1f.old'),
   Identifier(u'='),
   FunctionLiteral([Identifier(u'aut2'), Identifier(u'aut2.old'), Identifier(u'='), FunctionLiteral([Identifier(u'aut3'), Identifier(u'aut3.old'), Identifier(u'='), FunctionLiteral([Identifier(u'numnames.old'), Integer(3), Identifier(u'='), FunctionLiteral([Identifier(u'numnames'), Integer(3), Identifier(u'='), FunctionLiteral([Identifier(u'change.add.to.year'), Identifier(u'cite.num.names.short'), Identifier(u'cite.num.names.old'), Identifier(u'<'), FunctionLiteral([Identifier(u'cite.num.names.old'), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), QuotedVar(u'skip$'), Identifier(u'if$')]), FunctionLiteral([Identifier(u'cite.num.names.short'), Integer(4), Identifier(u'<'), FunctionLiteral([Integer(4), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), QuotedVar(u'skip$'), Identifier(u'if$')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'numnames'), Integer(3), Identifier(u'='), FunctionLiteral([Identifier(u'numnames'), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), FunctionLiteral([Identifier(u'aut4'), Identifier(u'aut4.old'), Identifier(u'='), FunctionLiteral([Identifier(u'numnames.old'), Integer(4), Identifier(u'='), FunctionLiteral([Identifier(u'numnames'), Integer(4), Identifier(u'='), FunctionLiteral([Identifier(u'change.add.to.year'), Identifier(u'cite.num.names.short'), Identifier(u'cite.num.names.old'), Identifier(u'<'), FunctionLiteral([Identifier(u'cite.num.names.old'), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), QuotedVar(u'skip$'), Identifier(u'if$')]), FunctionLiteral([Identifier(u'cite.num.names.short'), Integer(5), Identifier(u'<'), FunctionLiteral([Integer(5), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), QuotedVar(u'skip$'), Identifier(u'if$')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'numnames'), Integer(4), Identifier(u'='), FunctionLiteral([Identifier(u'numnames'), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), FunctionLiteral([Identifier(u'aut5'), Identifier(u'aut5.old'), Identifier(u'='), FunctionLiteral([Identifier(u'numnames.old'), Integer(5), Identifier(u'='), FunctionLiteral([Identifier(u'numnames'), Integer(5), Identifier(u'='), FunctionLiteral([Identifier(u'change.add.to.year'), Identifier(u'cite.num.names.short'), Identifier(u'cite.num.names.old'), Identifier(u'<'), FunctionLiteral([Identifier(u'cite.num.names.old'), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), QuotedVar(u'skip$'), Identifier(u'if$')]), FunctionLiteral([Identifier(u'cite.num.names.short'), Integer(6), Identifier(u'<'), FunctionLiteral([Integer(6), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), QuotedVar(u'skip$'), Identifier(u'if$')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'numnames'), Integer(5), Identifier(u'='), FunctionLiteral([Identifier(u'numnames'), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), FunctionLiteral([Identifier(u'numnames'), Integer(6), Identifier(u'>'), Identifier(u'numnames.old'), Integer(6), Identifier(u'='), Identifier(u'and'), Identifier(u'numnames'), Integer(6), Identifier(u'='), Identifier(u'numnames.old'), Integer(6), Identifier(u'>'), Identifier(u'and'), Identifier(u'or'), Identifier(u'aut6'), Identifier(u'aut6.old'), Identifier(u'='), Identifier(u'not'), Identifier(u'or'), FunctionLiteral([Integer(6), Identifier(u'cite.num.names.short'), Identifier(u'<'), FunctionLiteral([Integer(6), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), QuotedVar(u'skip$'), Identifier(u'if$')]), FunctionLiteral([Identifier(u'change.add.to.year'), Identifier(u'cite.num.names.short'), Identifier(u'cite.num.names.old'), Identifier(u'<'), FunctionLiteral([Identifier(u'cite.num.names.old'), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), QuotedVar(u'skip$'), Identifier(u'if$')]), Identifier(u'if$')]), Identifier(u'if$')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'cite.num.names.short'), Integer(5), Identifier(u'<'), FunctionLiteral([Integer(5), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), QuotedVar(u'skip$'), Identifier(u'if$')]), Identifier(u'if$')]), Identifier(u'if$')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'cite.num.names.short'), Integer(4), Identifier(u'<'), FunctionLiteral([Integer(4), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), QuotedVar(u'skip$'), Identifier(u'if$')]), Identifier(u'if$')]), Identifier(u'if$')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'cite.num.names.short'), Integer(3), Identifier(u'<'), FunctionLiteral([Integer(3), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), QuotedVar(u'skip$'), Identifier(u'if$')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'cite.num.names.short'), Integer(2), Identifier(u'<'), FunctionLiteral([Integer(2), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]), QuotedVar(u'skip$'), Identifier(u'if$')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'skip$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'definitive.cite.num.names.field')],
  [QuotedVar(u'field'),
   Identifier(u':='),
   Identifier(u'field'),
   Identifier(u'num.names$'),
   QuotedVar(u'numnames'),
   Identifier(u':='),
   Identifier(u'format.6.authors'),
   Identifier(u'cite.num.names.short'),
   Identifier(u'numnames.old'),
   Identifier(u'>'),
   FunctionLiteral([Identifier(u'skip$')]),
   FunctionLiteral([Identifier(u'year.label'), Identifier(u'year.label.old'), Identifier(u'='), FunctionLiteral([Identifier(u'numnames'), Integer(3), Identifier(u'<'), Identifier(u'numnames.old'), Integer(3), Identifier(u'<'), Identifier(u'or'), FunctionLiteral([Identifier(u'definitive.cite.num.names.1.or.2')]), FunctionLiteral([Identifier(u'definitive.cite.num.names.3.or.more')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'skip$')]), Identifier(u'if$')]),
   Identifier(u'if$'),
   Identifier(u'cite.num.names.short'),
   Identifier(u'name.max'),
   Identifier(u'>'),
   FunctionLiteral([Identifier(u'name.max'), QuotedVar(u'cite.num.names.short'), Identifier(u':=')]),
   QuotedVar(u'skip$'),
   Identifier(u'if$'),
   Identifier(u'cite.num.names.full'),
   Identifier(u'cite.num.names.short'),
   Identifier(u'<'),
   FunctionLiteral([Identifier(u'cite.num.names.short'), QuotedVar(u'cite.num.names.full'), Identifier(u':=')]),
   QuotedVar(u'skip$'),
   Identifier(u'if$'),
   Identifier(u'update.cite.num.names')]],
 [u'FUNCTION',
  [Identifier(u'definitive.cite.no.names')],
  [QuotedVar(u'aut1f'),
   Identifier(u':='),
   String(u''),
   QuotedVar(u'aut2'),
   Identifier(u':='),
   String(u''),
   QuotedVar(u'aut3'),
   Identifier(u':='),
   String(u''),
   QuotedVar(u'aut4'),
   Identifier(u':='),
   String(u''),
   QuotedVar(u'aut5'),
   Identifier(u':='),
   String(u''),
   QuotedVar(u'aut6'),
   Identifier(u':='),
   Integer(1),
   QuotedVar(u'numnames'),
   Identifier(u':='),
   Identifier(u'year.label'),
   Identifier(u'year.label.old'),
   Identifier(u'='),
   FunctionLiteral([Identifier(u'definitive.cite.num.names.1.or.2')]),
   FunctionLiteral([Identifier(u'skip$')]),
   Identifier(u'if$'),
   Identifier(u'update.cite.num.names')]],
 [u'FUNCTION',
  [Identifier(u'definitive.cite.num.names')],
  [Identifier(u'firstkey'),
   Identifier(u'empty$'),
   Identifier(u'not'),
   FunctionLiteral([Identifier(u'firstkey'), Identifier(u'sortify'), Identifier(u'remove.spaces'), Identifier(u'definitive.cite.no.names')]),
   FunctionLiteral([Identifier(u'key'), Identifier(u'empty$'), Identifier(u'not'), FunctionLiteral([Identifier(u'key'), Identifier(u'sortify'), Identifier(u'remove.spaces'), Identifier(u'definitive.cite.no.names')]), FunctionLiteral([Identifier(u'ref.type'), Integer(2), Identifier(u'='), FunctionLiteral([Identifier(u'author'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'title.sort.label'), Identifier(u'definitive.cite.no.names')]), FunctionLiteral([Identifier(u'author'), Identifier(u'definitive.cite.num.names.field')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'author'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'editor'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'title.sort.label'), Identifier(u'definitive.cite.no.names')]), FunctionLiteral([Identifier(u'editor'), Identifier(u'definitive.cite.num.names.field')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'author'), Identifier(u'definitive.cite.num.names.field')]), Identifier(u'if$')]), Identifier(u'if$')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'make.tentative.year.sort.label')],
  [Identifier(u'year'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'0000'), QuotedVar(u'year.label'), Identifier(u':=')]),
   FunctionLiteral([Identifier(u'year'), String(u'\\bibnodate'), Identifier(u'='), Identifier(u'year'), String(u'n.d.'), Identifier(u'='), Identifier(u'or'), FunctionLiteral([String(u'0000'), QuotedVar(u'year.label'), Identifier(u':=')]), FunctionLiteral([Identifier(u'year'), String(u'\\BIP'), Identifier(u'='), FunctionLiteral([String(u'9999'), QuotedVar(u'year.label'), Identifier(u':=')]), FunctionLiteral([Identifier(u'year'), Identifier(u'sortify'), Identifier(u'remove.spaces'), QuotedVar(u'year.label'), Identifier(u':=')]), Identifier(u'if$')]), Identifier(u'if$')]),
   Identifier(u'if$'),
   Identifier(u'year.label')]],
 [u'FUNCTION',
  [Identifier(u'month.number.day')],
  [Identifier(u'month'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'')]),
   FunctionLiteral([Identifier(u'month'), Identifier(u'sortify'), Identifier(u'remove.spaces'), Identifier(u'day'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([String(u'/'), Identifier(u'*'), Identifier(u'day'), Identifier(u'sortify'), Identifier(u'remove.spaces'), Identifier(u'*')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'make.name.sort.label')],
  [QuotedVar(u'field'),
   Identifier(u':='),
   Identifier(u'field'),
   Identifier(u'num.names$'),
   QuotedVar(u'numnames'),
   Identifier(u':='),
   Identifier(u'field'),
   Integer(1),
   Identifier(u'sort.name.format'),
   Identifier(u'format.name$'),
   Identifier(u'numnames'),
   Integer(1),
   Identifier(u'='),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'numnames'), Integer(2), Identifier(u'='), FunctionLiteral([Identifier(u'field'), Integer(2), String(u'{ll{}}'), Identifier(u'format.name$'), QuotedVar(u's'), Identifier(u':='), Identifier(u's'), String(u'others'), Identifier(u'='), FunctionLiteral([String(u'   zzzz'), Identifier(u'*')]), FunctionLiteral([String(u'   '), Identifier(u'*'), Identifier(u's'), Identifier(u'*')]), Identifier(u'if$')]), FunctionLiteral([String(u'   zzzz'), Identifier(u'*')]), Identifier(u'if$')]),
   Identifier(u'if$'),
   String(u'    '),
   Identifier(u'*'),
   Identifier(u'make.tentative.year.sort.label'),
   Identifier(u'*'),
   String(u'    '),
   Identifier(u'*'),
   Identifier(u'numnames'),
   Integer(3),
   Identifier(u'<'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'numnames'), Identifier(u'name.max'), Identifier(u'>'), FunctionLiteral([Identifier(u'name.max'), QuotedVar(u'lastname'), Identifier(u':='), String(u'   zzzz')]), FunctionLiteral([Identifier(u'numnames'), QuotedVar(u'lastname'), Identifier(u':='), String(u'')]), Identifier(u'if$'), String(u''), Integer(2), QuotedVar(u'nameptr'), Identifier(u':='), FunctionLiteral([Identifier(u'nameptr'), Identifier(u'lastname'), Identifier(u'<')]), FunctionLiteral([Identifier(u'field'), Identifier(u'nameptr'), String(u'{ll{}}'), Identifier(u'format.name$'), Identifier(u'*'), String(u'   '), Identifier(u'*'), Identifier(u'nameptr'), Integer(1), Identifier(u'+'), QuotedVar(u'nameptr'), Identifier(u':=')]), Identifier(u'while$'), Identifier(u'field'), Identifier(u'lastname'), String(u'{ll{}}'), Identifier(u'format.name$'), QuotedVar(u's'), Identifier(u':='), Identifier(u's'), String(u'others'), Identifier(u'='), FunctionLiteral([String(u'zzzz'), Identifier(u'*')]), FunctionLiteral([Identifier(u's'), Identifier(u'*')]), Identifier(u'if$'), Identifier(u'swap$'), Identifier(u'*'), Identifier(u'*')]),
   Identifier(u'if$'),
   String(u'    '),
   Identifier(u'*'),
   Identifier(u'title.number'),
   Identifier(u'conv.int.to.str'),
   Identifier(u'*'),
   Identifier(u'sortify'),
   String(u'    '),
   Identifier(u'*'),
   Identifier(u'month.number.day'),
   Identifier(u'*'),
   QuotedVar(u'author.year.sort.label'),
   Identifier(u':=')]],
 [u'FUNCTION',
  [Identifier(u'make.field.year.sort.label')],
  [String(u'    '),
   Identifier(u'*'),
   Identifier(u'make.tentative.year.sort.label'),
   Identifier(u'*'),
   String(u'    '),
   Identifier(u'*'),
   String(u'    '),
   Identifier(u'*'),
   Identifier(u'title.number'),
   Identifier(u'conv.int.to.str'),
   Identifier(u'*'),
   Identifier(u'sortify'),
   String(u'    '),
   Identifier(u'*'),
   Identifier(u'month.number.day'),
   Identifier(u'*'),
   QuotedVar(u'author.year.sort.label'),
   Identifier(u':=')]],
 [u'FUNCTION',
  [Identifier(u'make.author.editor.sort.label')],
  [Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'editor'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'title.sort.label'), Identifier(u'make.field.year.sort.label')]), FunctionLiteral([Identifier(u'editor'), Identifier(u'make.name.sort.label')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'author'), Identifier(u'make.name.sort.label')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'make.author.sort.label')],
  [Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'title.sort.label'), Identifier(u'make.field.year.sort.label')]),
   FunctionLiteral([Identifier(u'author'), Identifier(u'make.name.sort.label')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'make.tentative.sort.label')],
  [Identifier(u'firstkey'),
   Identifier(u'empty$'),
   Identifier(u'not'),
   FunctionLiteral([Identifier(u'key'), Identifier(u'empty$'), Identifier(u'not'), FunctionLiteral([Identifier(u'key'), Identifier(u'sortify'), Identifier(u'remove.spaces'), String(u'  '), Identifier(u'*'), Identifier(u'firstkey'), Identifier(u'sortify'), Identifier(u'remove.spaces'), Identifier(u'*'), Identifier(u'make.field.year.sort.label')]), FunctionLiteral([Identifier(u'firstkey'), Identifier(u'sortify'), Identifier(u'remove.spaces'), Identifier(u'make.field.year.sort.label')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'key'), Identifier(u'empty$'), Identifier(u'not'), FunctionLiteral([Identifier(u'key'), Identifier(u'sortify'), Identifier(u'remove.spaces'), Identifier(u'make.field.year.sort.label')]), FunctionLiteral([Identifier(u'ref.type'), Identifier(u'duplicate$'), Integer(1), Identifier(u'='), FunctionLiteral([Identifier(u'pop$'), Identifier(u'make.author.editor.sort.label')]), FunctionLiteral([Identifier(u'duplicate$'), Integer(2), Identifier(u'='), FunctionLiteral([Identifier(u'pop$'), Identifier(u'make.author.sort.label')]), FunctionLiteral([Integer(3), Identifier(u'='), FunctionLiteral([String(u'no key in '), Identifier(u'cite$'), Identifier(u'*'), Identifier(u'warning$'), Identifier(u'make.author.editor.sort.label')]), FunctionLiteral([Identifier(u'make.author.editor.sort.label')]), Identifier(u'if$')]), Identifier(u'if$')]), Identifier(u'if$')]), Identifier(u'if$')]),
   Identifier(u'if$'),
   Identifier(u'author.year.sort.label'),
   QuotedVar(u'sort.key$'),
   Identifier(u':=')]],
 [u'FUNCTION',
  [Identifier(u'make.definitive.name.sort.label')],
  [QuotedVar(u'field'),
   Identifier(u':='),
   Identifier(u'field'),
   Identifier(u'num.names$'),
   QuotedVar(u'numnames'),
   Identifier(u':='),
   Identifier(u'numnames'),
   Identifier(u'name.max'),
   Identifier(u'>'),
   FunctionLiteral([Identifier(u'name.max'), QuotedVar(u'format.num.names'), Identifier(u':=')]),
   FunctionLiteral([Identifier(u'numnames'), QuotedVar(u'format.num.names'), Identifier(u':=')]),
   Identifier(u'if$'),
   String(u''),
   Integer(1),
   QuotedVar(u'nameptr'),
   Identifier(u':='),
   FunctionLiteral([Identifier(u'nameptr'), Identifier(u'format.num.names'), Identifier(u'<')]),
   FunctionLiteral([Identifier(u'field'), Identifier(u'nameptr'), Identifier(u'sort.name.format'), Identifier(u'format.name$'), Identifier(u'*'), String(u'   '), Identifier(u'*'), Identifier(u'nameptr'), Integer(1), Identifier(u'+'), QuotedVar(u'nameptr'), Identifier(u':=')]),
   Identifier(u'while$'),
   Identifier(u'field'),
   Identifier(u'nameptr'),
   Identifier(u'sort.name.format'),
   Identifier(u'format.name$'),
   Identifier(u'*'),
   Identifier(u'nameptr'),
   Identifier(u'numnames'),
   Identifier(u'<'),
   FunctionLiteral([String(u'   zzzz'), Identifier(u'*')]),
   QuotedVar(u'skip$'),
   Identifier(u'if$'),
   Identifier(u'sortify'),
   String(u'    '),
   Identifier(u'*'),
   Identifier(u'year.label'),
   Identifier(u'*'),
   String(u'    '),
   Identifier(u'*'),
   Identifier(u'title.number'),
   Identifier(u'conv.int.to.str'),
   Identifier(u'*'),
   String(u'    '),
   Identifier(u'*'),
   Identifier(u'month.number.day'),
   Identifier(u'*'),
   QuotedVar(u'author.year.sort.label'),
   Identifier(u':=')]],
 [u'FUNCTION',
  [Identifier(u'make.definitive.field.year.sort.label')],
  [String(u'    '),
   Identifier(u'*'),
   Identifier(u'year.label'),
   Identifier(u'*'),
   String(u'    '),
   Identifier(u'*'),
   Identifier(u'title.number'),
   Identifier(u'conv.int.to.str'),
   Identifier(u'*'),
   String(u'    '),
   Identifier(u'*'),
   Identifier(u'month.number.day'),
   Identifier(u'*'),
   QuotedVar(u'author.year.sort.label'),
   Identifier(u':=')]],
 [u'FUNCTION',
  [Identifier(u'make.definitive.author.editor.sort.label')],
  [Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'editor'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'title.sort.label'), Identifier(u'make.definitive.field.year.sort.label')]), FunctionLiteral([Identifier(u'editor'), Identifier(u'make.definitive.name.sort.label')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'author'), Identifier(u'make.definitive.name.sort.label')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'make.definitive.author.sort.label')],
  [Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'title.sort.label'), Identifier(u'make.definitive.field.year.sort.label')]),
   FunctionLiteral([Identifier(u'author'), Identifier(u'make.definitive.name.sort.label')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'make.final.sort.key')],
  [Identifier(u'ref.type'),
   Integer(2),
   Identifier(u'='),
   FunctionLiteral([Identifier(u'make.definitive.author.sort.label')]),
   FunctionLiteral([Identifier(u'make.definitive.author.editor.sort.label')]),
   Identifier(u'if$'),
   Identifier(u'author.year.sort.label'),
   QuotedVar(u'sort.key$'),
   Identifier(u':=')]],
 [u'FUNCTION',
  [Identifier(u'chop.word')],
  [QuotedVar(u's'),
   Identifier(u':='),
   QuotedVar(u'len'),
   Identifier(u':='),
   Identifier(u's'),
   Integer(1),
   Identifier(u'len'),
   Identifier(u'substring$'),
   Identifier(u'='),
   FunctionLiteral([Identifier(u's'), Identifier(u'len'), Integer(1), Identifier(u'+'), Identifier(u'global.max$'), Identifier(u'substring$')]),
   FunctionLiteral([Identifier(u's')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'chop.articles')],
  [QuotedVar(u's'),
   Identifier(u':='),
   String(u'a '),
   Integer(2),
   String(u'an '),
   Integer(3),
   String(u'the '),
   Integer(4),
   Identifier(u's'),
   Identifier(u'chop.word'),
   Identifier(u'chop.word'),
   Identifier(u'chop.word')]],
 [u'FUNCTION',
  [Identifier(u'format.sort.title')],
  [Identifier(u'sortify'),
   Identifier(u'chop.articles'),
   Integer(1),
   Identifier(u'entry.max$'),
   Identifier(u'substring$')]],
 [u'FUNCTION',
  [Identifier(u'make.sort.title')],
  [Identifier(u'title'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'text'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'type'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'howpublished'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'note'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'url'), Identifier(u'empty$'), FunctionLiteral([String(u' ')]), FunctionLiteral([Identifier(u'url'), Identifier(u'format.sort.title')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'note'), Identifier(u'format.sort.title')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'howpublished'), Identifier(u'format.sort.title')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'type'), Identifier(u'format.sort.title')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'text'), Identifier(u'format.sort.title')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'title'), Identifier(u'format.sort.title')]),
   Identifier(u'if$'),
   Identifier(u'remove.spaces'),
   QuotedVar(u'title.sort.label'),
   Identifier(u':='),
   Identifier(u'title.sort.label'),
   QuotedVar(u'sort.key$'),
   Identifier(u':=')]],
 [u'FUNCTION',
  [Identifier(u'make.title.number')],
  [Identifier(u'title.sort.label'),
   Identifier(u'old.label'),
   Identifier(u'='),
   FunctionLiteral([Identifier(u'old.number'), QuotedVar(u'title.number'), Identifier(u':=')]),
   FunctionLiteral([Identifier(u'old.number'), Integer(1), Identifier(u'+'), QuotedVar(u'title.number'), Identifier(u':='), Identifier(u'title.number'), QuotedVar(u'old.number'), Identifier(u':='), Identifier(u'title.sort.label'), QuotedVar(u'old.label'), Identifier(u':=')]),
   Identifier(u'if$')]],
 [u'FUNCTION', [Identifier(u'last.part.name.format')], [String(u'{ll}')]],
 [u'FUNCTION',
  [Identifier(u'initials.with.space.name.format')],
  [String(u'{f.}')]],
 [u'FUNCTION',
  [Identifier(u'von.last.junior.name.format')],
  [String(u'{vv }{ll}{ jj}')]],
 [u'FUNCTION',
  [Identifier(u'von.junior.name.format')],
  [String(u'{ vv}{, jj}')]],
 [u'FUNCTION',
  [Identifier(u'one.complete.name.format')],
  [String(u'{vv }{ll}{, jj}{, ff}')]],
 [u'FUNCTION',
  [Identifier(u'string.length')],
  [Integer(0),
   QuotedVar(u'pos'),
   Identifier(u':='),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'pos'), Integer(1), Identifier(u'+'), Integer(1), Identifier(u'substring$'), String(u''), Identifier(u'='), Identifier(u'not')]),
   FunctionLiteral([Identifier(u'pos'), Integer(1), Identifier(u'+'), QuotedVar(u'pos'), Identifier(u':=')]),
   Identifier(u'while$'),
   Identifier(u'pop$'),
   Identifier(u'pos')]],
 [u'FUNCTION',
  [Identifier(u'transform.spaces.and.hyphens')],
  [QuotedVar(u's'),
   Identifier(u':='),
   Identifier(u's'),
   Identifier(u'string.length'),
   QuotedVar(u'len'),
   Identifier(u':='),
   String(u''),
   QuotedVar(u't'),
   Identifier(u':='),
   Integer(1),
   QuotedVar(u'pos'),
   Identifier(u':='),
   Integer(0),
   QuotedVar(u'brace.level'),
   Identifier(u':='),
   FunctionLiteral([Identifier(u'pos'), Identifier(u'len'), Identifier(u'<')]),
   FunctionLiteral([Identifier(u'brace.level'), Integer(0), Identifier(u'='), FunctionLiteral([Identifier(u's'), Identifier(u'pos'), Integer(2), Identifier(u'substring$'), String(u'. '), Identifier(u'='), Identifier(u's'), Identifier(u'pos'), Integer(2), Identifier(u'substring$'), String(u'.~'), Identifier(u'='), Identifier(u'or'), FunctionLiteral([Identifier(u't'), String(u'\\BPBI '), Identifier(u'*'), QuotedVar(u't'), Identifier(u':='), Identifier(u'pos'), Integer(2), Identifier(u'+'), QuotedVar(u'pos'), Identifier(u':=')]), FunctionLiteral([Identifier(u's'), Identifier(u'pos'), Integer(2), Identifier(u'substring$'), String(u'.-'), Identifier(u'='), FunctionLiteral([Identifier(u't'), String(u'\\BHBI '), Identifier(u'*'), QuotedVar(u't'), Identifier(u':='), Identifier(u'pos'), Integer(2), Identifier(u'+'), QuotedVar(u'pos'), Identifier(u':=')]), FunctionLiteral([Identifier(u't'), Identifier(u's'), Identifier(u'pos'), Integer(1), Identifier(u'substring$'), Identifier(u'*'), QuotedVar(u't'), Identifier(u':='), Identifier(u's'), Identifier(u'pos'), Integer(1), Identifier(u'substring$'), String(u'{'), Identifier(u'='), FunctionLiteral([Identifier(u'brace.level'), Integer(1), Identifier(u'+'), QuotedVar(u'brace.level'), Identifier(u':=')]), QuotedVar(u'skip$'), Identifier(u'if$'), Identifier(u'pos'), Integer(1), Identifier(u'+'), QuotedVar(u'pos'), Identifier(u':=')]), Identifier(u'if$')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u't'), Identifier(u's'), Identifier(u'pos'), Integer(1), Identifier(u'substring$'), Identifier(u'*'), QuotedVar(u't'), Identifier(u':='), Identifier(u's'), Identifier(u'pos'), Integer(1), Identifier(u'substring$'), String(u'{'), Identifier(u'='), FunctionLiteral([Identifier(u'brace.level'), Integer(1), Identifier(u'+'), QuotedVar(u'brace.level'), Identifier(u':=')]), FunctionLiteral([Identifier(u's'), Identifier(u'pos'), Integer(1), Identifier(u'substring$'), String(u'}'), Identifier(u'='), FunctionLiteral([Identifier(u'brace.level'), Integer(1), Identifier(u'-'), QuotedVar(u'brace.level'), Identifier(u':=')]), QuotedVar(u'skip$'), Identifier(u'if$')]), Identifier(u'if$'), Identifier(u'pos'), Integer(1), Identifier(u'+'), QuotedVar(u'pos'), Identifier(u':=')]), Identifier(u'if$')]),
   Identifier(u'while$'),
   Identifier(u'pos'),
   Identifier(u'len'),
   Identifier(u'='),
   FunctionLiteral([Identifier(u't'), Identifier(u's'), Identifier(u'pos'), Integer(1), Identifier(u'substring$'), Identifier(u'*'), QuotedVar(u't'), Identifier(u':=')]),
   FunctionLiteral([Identifier(u's'), Identifier(u'len'), Integer(1), Identifier(u'-'), Integer(2), Identifier(u'substring$'), Identifier(u't'), Identifier(u'text.length$'), QuotedVar(u'len'), Identifier(u':='), Identifier(u't'), Integer(1), Identifier(u'len'), Integer(6), Identifier(u'-'), Identifier(u'substring$'), Identifier(u'swap$'), Identifier(u'*'), QuotedVar(u't'), Identifier(u':=')]),
   Identifier(u'if$'),
   Identifier(u't')]],
 [u'FUNCTION',
  [Identifier(u'format.initials.with.hyphen')],
  [Identifier(u'initials.with.space.name.format'),
   Identifier(u'format.name$'),
   Identifier(u'transform.spaces.and.hyphens')]],
 [u'FUNCTION',
  [Identifier(u'format.last.part.name')],
  [Identifier(u'last.part.name.format'), Identifier(u'format.name$')]],
 [u'FUNCTION',
  [Identifier(u'format.von.last.junior.name')],
  [Identifier(u'von.last.junior.name.format'), Identifier(u'format.name$')]],
 [u'FUNCTION',
  [Identifier(u'format.von.junior.name')],
  [Identifier(u'von.junior.name.format'), Identifier(u'format.name$')]],
 [u'FUNCTION',
  [Identifier(u'format.cite.initials.name')],
  [Identifier(u'one.complete.name.format'),
   Identifier(u'format.name$'),
   Identifier(u'duplicate$'),
   Integer(1),
   Identifier(u'format.initials.with.hyphen'),
   Identifier(u'swap$'),
   Integer(1),
   Identifier(u'format.von.last.junior.name'),
   String(u'~'),
   Identifier(u'connect.check')]],
 [u'FUNCTION',
  [Identifier(u'format.author.name')],
  [Identifier(u'one.complete.name.format'),
   Identifier(u'format.name$'),
   Identifier(u'duplicate$'),
   Identifier(u'duplicate$'),
   Integer(1),
   Identifier(u'format.last.part.name'),
   Identifier(u'swap$'),
   Integer(1),
   Identifier(u'format.initials.with.hyphen'),
   Identifier(u'connect.with.comma.check'),
   Identifier(u'swap$'),
   Integer(1),
   Identifier(u'format.von.junior.name'),
   String(u''),
   Identifier(u'connect.check')]],
 [u'FUNCTION',
  [Identifier(u'format.editor.name')],
  [Identifier(u'format.cite.initials.name')]],
 [u'FUNCTION',
  [Identifier(u'format.index.name')],
  [Identifier(u'format.author.name')]],
 [u'FUNCTION', [Identifier(u'comma.between.two')], [String(u'\\BCBT{}')]],
 [u'FUNCTION', [Identifier(u'comma.between.names')], [String(u', ')]],
 [u'FUNCTION', [Identifier(u'comma.before.last')], [String(u'\\BCBL{}')]],
 [u'FUNCTION', [Identifier(u'and.before.last')], [String(u'\\ \\BBA{} ')]],
 [u'FUNCTION',
  [Identifier(u'et.al.string.cite')],
  [String(u'\\ \\protect\\BOthers{.}')]],
 [u'FUNCTION', [Identifier(u'et.al.string')], [String(u'\\ \\BOthers{.}')]],
 [u'FUNCTION',
  [Identifier(u'et.al.string.period')],
  [String(u'\\ \\BOthersPeriod{.}')]],
 [u'FUNCTION',
  [Identifier(u'add.name.index')],
  [Identifier(u'make.index'),
   FunctionLiteral([String(u'%'), Identifier(u'*'), Identifier(u'write$'), Identifier(u'newline$'), Identifier(u'field'), Identifier(u'is.bibcorporate'), FunctionLiteral([String(u'\\corporateAX{')]), FunctionLiteral([String(u'\\AX{')]), Identifier(u'if$'), Identifier(u'write$'), Identifier(u'field'), Identifier(u'nameptr'), Identifier(u'sort.name.format'), Identifier(u'format.name$'), Identifier(u'sortify'), Identifier(u'write$'), Identifier(u'newline$'), String(u'@'), Identifier(u'write$'), Identifier(u'field'), Identifier(u'nameptr'), Identifier(u'format.index.name'), String(u'}%'), Identifier(u'*'), Identifier(u'write$'), Identifier(u'newline$')]),
   FunctionLiteral([String(u'%'), Identifier(u'*'), Identifier(u'write$'), Identifier(u'newline$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'make.name.cite.label')],
  [QuotedVar(u'field'),
   Identifier(u':='),
   QuotedVar(u'format.num.names'),
   Identifier(u':='),
   Identifier(u'field'),
   Identifier(u'num.names$'),
   QuotedVar(u'numnames'),
   Identifier(u':='),
   Identifier(u'format.num.names'),
   Identifier(u'numnames'),
   Integer(1),
   Identifier(u'-'),
   Identifier(u'='),
   FunctionLiteral([Identifier(u'numnames'), QuotedVar(u'format.num.names'), Identifier(u':=')]),
   QuotedVar(u'skip$'),
   Identifier(u'if$'),
   Integer(1),
   QuotedVar(u'nameptr'),
   Identifier(u':='),
   Identifier(u'cite.initials'),
   Integer(1),
   Identifier(u'='),
   FunctionLiteral([Identifier(u'field'), Identifier(u'nameptr'), Identifier(u'format.cite.initials.name')]),
   FunctionLiteral([Identifier(u'field'), Identifier(u'nameptr'), Identifier(u'cite.name.format'), Identifier(u'format.name$')]),
   Identifier(u'if$'),
   Identifier(u'add.name.index'),
   Identifier(u'numnames'),
   Integer(1),
   Identifier(u'='),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'format.num.names'), Integer(1), Identifier(u'='), FunctionLiteral([Identifier(u'et.al.string.cite'), Identifier(u'write$')]), FunctionLiteral([Identifier(u'numnames'), Integer(2), Identifier(u'='), FunctionLiteral([Integer(2), QuotedVar(u'nameptr'), Identifier(u':='), Identifier(u'field'), Identifier(u'nameptr'), Identifier(u'cite.name.format'), Identifier(u'format.name$'), QuotedVar(u's'), Identifier(u':='), Identifier(u's'), String(u'others'), Identifier(u'='), FunctionLiteral([Identifier(u'et.al.string.cite'), Identifier(u'write$')]), FunctionLiteral([Identifier(u'and.before.last'), Identifier(u'write$'), Identifier(u's'), Identifier(u'add.name.index')]), Identifier(u'if$')]), FunctionLiteral([Integer(2), QuotedVar(u'nameptr'), Identifier(u':='), FunctionLiteral([Identifier(u'nameptr'), Identifier(u'format.num.names'), Identifier(u'<')]), FunctionLiteral([Identifier(u'comma.between.names'), Identifier(u'write$'), Identifier(u'field'), Identifier(u'nameptr'), Identifier(u'cite.name.format'), Identifier(u'format.name$'), Identifier(u'add.name.index'), Identifier(u'nameptr'), Integer(1), Identifier(u'+'), QuotedVar(u'nameptr'), Identifier(u':=')]), Identifier(u'while$'), Identifier(u'field'), Identifier(u'nameptr'), Identifier(u'cite.name.format'), Identifier(u'format.name$'), QuotedVar(u's'), Identifier(u':='), Identifier(u'format.num.names'), Identifier(u'numnames'), Identifier(u'='), FunctionLiteral([Identifier(u'comma.before.last'), Identifier(u'write$'), Identifier(u's'), String(u'others'), Identifier(u'='), FunctionLiteral([Identifier(u'et.al.string.cite'), Identifier(u'write$')]), FunctionLiteral([Identifier(u'and.before.last'), Identifier(u'write$'), Identifier(u's'), Identifier(u'add.name.index')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'comma.between.names'), Identifier(u'write$'), Identifier(u's'), Identifier(u'add.name.index'), Identifier(u'comma.before.last'), Identifier(u'et.al.string.cite'), Identifier(u'*'), Identifier(u'write$')]), Identifier(u'if$')]), Identifier(u'if$')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'make.title.cite.label')],
  [Identifier(u'is.atype'),
   FunctionLiteral([String(u'\\APACciteatitle{')]),
   FunctionLiteral([String(u'\\APACcitebtitle{')]),
   Identifier(u'if$'),
   Identifier(u'title'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'text'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'type'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'howpublished'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'note'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'url'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'cite$')]), FunctionLiteral([Identifier(u'url')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'note')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'howpublished')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'type')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'text')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'title')]),
   Identifier(u'if$'),
   Identifier(u'*'),
   String(u'}'),
   Identifier(u'*'),
   Identifier(u'write$')]],
 [u'FUNCTION',
  [Identifier(u'make.author.editor.cite.label')],
  [Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'editor'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'make.title.cite.label'), String(u'}{%'), Identifier(u'write$'), Identifier(u'newline$'), Identifier(u'make.title.cite.label')]), FunctionLiteral([Identifier(u'cite.num.names.full'), Identifier(u'editor'), Identifier(u'make.name.cite.label'), String(u'}{%'), Identifier(u'write$'), Identifier(u'newline$'), Identifier(u'cite.num.names.short'), Identifier(u'editor'), Identifier(u'make.name.cite.label')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'cite.num.names.full'), Identifier(u'author'), Identifier(u'make.name.cite.label'), String(u'}{%'), Identifier(u'write$'), Identifier(u'newline$'), Identifier(u'cite.num.names.short'), Identifier(u'author'), Identifier(u'make.name.cite.label')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'make.author.cite.label')],
  [Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'make.title.cite.label'), String(u'}{%'), Identifier(u'write$'), Identifier(u'newline$'), Identifier(u'make.title.cite.label')]),
   FunctionLiteral([Identifier(u'cite.num.names.full'), Identifier(u'author'), Identifier(u'make.name.cite.label'), String(u'}{%'), Identifier(u'write$'), Identifier(u'newline$'), Identifier(u'cite.num.names.short'), Identifier(u'author'), Identifier(u'make.name.cite.label')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'make.definitive.year.supplement')],
  [Identifier(u'add.to.year'),
   Integer(0),
   Identifier(u'='),
   FunctionLiteral([String(u'')]),
   FunctionLiteral([String(u'{\\protect'), Identifier(u'year'), Identifier(u'empty$'), FunctionLiteral([String(u'\\BCntND'), Identifier(u'*')]), FunctionLiteral([Identifier(u'year'), String(u'\\bibnodate'), Identifier(u'='), FunctionLiteral([String(u'\\BCntND'), Identifier(u'*')]), FunctionLiteral([Identifier(u'year'), String(u'\\BIP'), Identifier(u'='), FunctionLiteral([String(u'\\BCntIP'), Identifier(u'*')]), FunctionLiteral([String(u'\\BCnt'), Identifier(u'*')]), Identifier(u'if$')]), Identifier(u'if$')]), Identifier(u'if$'), String(u'{'), Identifier(u'*'), Identifier(u'add.to.year'), Identifier(u'int.to.str$'), Identifier(u'*'), String(u'}}'), Identifier(u'*')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'protect.year')],
  [Identifier(u'year'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'{\\protect\\bibnodate{}}')]),
   FunctionLiteral([Identifier(u'year'), String(u'\\bibnodate'), Identifier(u'='), FunctionLiteral([String(u'{\\protect\\bibnodate{}}')]), FunctionLiteral([Identifier(u'year'), String(u'\\BIP'), Identifier(u'='), FunctionLiteral([String(u'{\\protect\\BIP{}}')]), FunctionLiteral([Identifier(u'year')]), Identifier(u'if$')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'make.definitive.year.label')],
  [String(u'{\\protect\\APACyear{'),
   Identifier(u'originalyear'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'protect.year')]),
   FunctionLiteral([Identifier(u'originalyear'), String(u'\\bibnodate'), Identifier(u'='), FunctionLiteral([Identifier(u'translator'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'protect.year')]), FunctionLiteral([Identifier(u'year'), Identifier(u'empty$'), FunctionLiteral([String(u'{\\protect\\BTRANSL{}~\\protect\\bibnodate{}}')]), FunctionLiteral([String(u'{\\protect\\BTRANSL{}}~'), Identifier(u'protect.year'), Identifier(u'*')]), Identifier(u'if$')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'year'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'originalyear'), String(u'/{\\protect\\bibnodate{}}'), Identifier(u'*')]), FunctionLiteral([Identifier(u'originalyear'), Identifier(u'year'), Identifier(u'='), FunctionLiteral([Identifier(u'protect.year')]), FunctionLiteral([Identifier(u'originalyear'), String(u'/'), Identifier(u'*'), Identifier(u'protect.year'), Identifier(u'*')]), Identifier(u'if$')]), Identifier(u'if$')]), Identifier(u'if$')]),
   Identifier(u'if$'),
   Identifier(u'*'),
   String(u'}}%'),
   Identifier(u'*'),
   Identifier(u'write$'),
   Identifier(u'newline$'),
   String(u'{\\protect\\APACexlab{'),
   String(u'}}'),
   Identifier(u'make.definitive.year.supplement'),
   Identifier(u'enclose.check')]],
 [u'FUNCTION',
  [Identifier(u'make.cite.labels')],
  [Identifier(u'newline$'),
   Identifier(u'test'),
   FunctionLiteral([String(u'\\bibitem[]{} \\fullciteA{'), Identifier(u'cite$'), Identifier(u'*'), String(u'}'), Identifier(u'*'), Identifier(u'write$'), Identifier(u'newline$'), String(u'\\bibitem[]{} \\citeA{'), Identifier(u'cite$'), Identifier(u'*'), String(u'}'), Identifier(u'*'), Identifier(u'write$'), Identifier(u'newline$')]),
   QuotedVar(u'skip$'),
   Identifier(u'if$'),
   String(u'\\bibitem[\\protect\\citeauthoryear{%'),
   Identifier(u'write$'),
   Identifier(u'newline$'),
   Identifier(u'firstkey'),
   Identifier(u'empty$'),
   Identifier(u'not'),
   FunctionLiteral([Identifier(u'firstkey'), Identifier(u'write$'), String(u'}{%'), Identifier(u'write$'), Identifier(u'newline$'), Identifier(u'cite.initials'), Integer(0), Identifier(u'='), Identifier(u'key'), Identifier(u'empty$'), Identifier(u'not'), Identifier(u'and'), FunctionLiteral([Identifier(u'key')]), FunctionLiteral([Identifier(u'firstkey')]), Identifier(u'if$'), Identifier(u'write$')]),
   FunctionLiteral([Identifier(u'key'), Identifier(u'empty$'), Identifier(u'not'), FunctionLiteral([Identifier(u'key'), Identifier(u'write$'), String(u'}{%'), Identifier(u'write$'), Identifier(u'newline$'), Identifier(u'key'), Identifier(u'write$')]), FunctionLiteral([Identifier(u'ref.type'), Integer(2), Identifier(u'='), FunctionLiteral([Identifier(u'make.author.cite.label')]), FunctionLiteral([Identifier(u'make.author.editor.cite.label')]), Identifier(u'if$')]), Identifier(u'if$')]),
   Identifier(u'if$'),
   String(u'}{%'),
   Identifier(u'write$'),
   Identifier(u'newline$'),
   Identifier(u'make.definitive.year.label'),
   Identifier(u'write$'),
   String(u'}]{%'),
   Identifier(u'write$'),
   Identifier(u'newline$'),
   Identifier(u'cite$'),
   Identifier(u'write$'),
   String(u'}%'),
   Identifier(u'write$'),
   Identifier(u'newline$'),
   String(u'\\APACinsertmetastar{%'),
   Identifier(u'write$'),
   Identifier(u'newline$'),
   Identifier(u'cite$'),
   Identifier(u'write$'),
   String(u'}%'),
   Identifier(u'write$'),
   Identifier(u'newline$')]],
 [u'FUNCTION',
  [Identifier(u'editor.postfix')],
  [Identifier(u'editor'),
   Identifier(u'num.names$'),
   Integer(1),
   Identifier(u'>'),
   FunctionLiteral([String(u'(\\BEDS)')]),
   FunctionLiteral([String(u'(\\BED)')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'editor.trans.postfix')],
  [Identifier(u'editor'),
   Identifier(u'num.names$'),
   Integer(1),
   Identifier(u'>'),
   FunctionLiteral([String(u'(\\BEDS{} \\BAnd{} \\BTRANSS)')]),
   FunctionLiteral([String(u'(\\BED{} \\BAnd{} \\BTRANS)')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'trans.postfix')],
  [Identifier(u'translator'),
   Identifier(u'num.names$'),
   Integer(1),
   Identifier(u'>'),
   FunctionLiteral([String(u'(\\BTRANSS)')]),
   FunctionLiteral([String(u'(\\BTRANS)')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.author.names')],
  [QuotedVar(u'field'),
   Identifier(u':='),
   QuotedVar(u'dot'),
   Identifier(u':='),
   Identifier(u'field'),
   Identifier(u'num.names$'),
   QuotedVar(u'numnames'),
   Identifier(u':='),
   Identifier(u'numnames'),
   QuotedVar(u'format.num.names'),
   Identifier(u':='),
   Identifier(u'format.num.names'),
   Identifier(u'name.max'),
   Identifier(u'>'),
   FunctionLiteral([Identifier(u'dot'), FunctionLiteral([Identifier(u'name.max'), QuotedVar(u'format.num.names'), Identifier(u':=')]), FunctionLiteral([Identifier(u'cite.num.names.full'), QuotedVar(u'format.num.names'), Identifier(u':=')]), Identifier(u'if$')]),
   QuotedVar(u'skip$'),
   Identifier(u'if$'),
   Integer(1),
   QuotedVar(u'nameptr'),
   Identifier(u':='),
   Identifier(u'field'),
   Identifier(u'nameptr'),
   Identifier(u'format.author.name'),
   Identifier(u'numnames'),
   Integer(1),
   Identifier(u'='),
   Identifier(u'dot'),
   Identifier(u'and'),
   FunctionLiteral([Identifier(u'add.period$')]),
   QuotedVar(u'skip$'),
   Identifier(u'if$'),
   Identifier(u'add.name.index'),
   Identifier(u'numnames'),
   Integer(1),
   Identifier(u'='),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'format.num.names'), Integer(1), Identifier(u'='), FunctionLiteral([Identifier(u'comma.between.two'), Identifier(u'dot'), FunctionLiteral([Identifier(u'et.al.string.period'), Identifier(u'*')]), FunctionLiteral([Identifier(u'et.al.string'), Identifier(u'*')]), Identifier(u'if$'), Identifier(u'write$')]), FunctionLiteral([Identifier(u'numnames'), Integer(2), Identifier(u'='), FunctionLiteral([Identifier(u'comma.between.two'), Identifier(u'write$'), Integer(2), QuotedVar(u'nameptr'), Identifier(u':='), Identifier(u'field'), Identifier(u'nameptr'), Identifier(u'format.author.name'), QuotedVar(u's'), Identifier(u':='), Identifier(u's'), String(u'others'), Identifier(u'='), FunctionLiteral([Identifier(u'dot'), FunctionLiteral([Identifier(u'et.al.string.period')]), FunctionLiteral([Identifier(u'et.al.string')]), Identifier(u'if$'), Identifier(u'write$')]), FunctionLiteral([Identifier(u'and.before.last'), Identifier(u'write$'), Identifier(u'dot'), FunctionLiteral([Identifier(u's'), Identifier(u'add.period$')]), FunctionLiteral([Identifier(u's')]), Identifier(u'if$'), Identifier(u'add.name.index')]), Identifier(u'if$')]), FunctionLiteral([Integer(2), QuotedVar(u'nameptr'), Identifier(u':='), FunctionLiteral([Identifier(u'nameptr'), Identifier(u'format.num.names'), Identifier(u'<')]), FunctionLiteral([Identifier(u'comma.between.names'), Identifier(u'write$'), Identifier(u'field'), Identifier(u'nameptr'), Identifier(u'format.author.name'), Identifier(u'add.name.index'), Identifier(u'nameptr'), Integer(1), Identifier(u'+'), QuotedVar(u'nameptr'), Identifier(u':=')]), Identifier(u'while$'), Identifier(u'field'), Identifier(u'nameptr'), Identifier(u'format.author.name'), QuotedVar(u's'), Identifier(u':='), Identifier(u'format.num.names'), Identifier(u'numnames'), Identifier(u'='), FunctionLiteral([Identifier(u'comma.before.last'), Identifier(u'write$'), Identifier(u's'), String(u'others'), Identifier(u'='), FunctionLiteral([Identifier(u'dot'), FunctionLiteral([Identifier(u'et.al.string.period')]), FunctionLiteral([Identifier(u'et.al.string')]), Identifier(u'if$'), Identifier(u'write$')]), FunctionLiteral([Identifier(u'and.before.last'), Identifier(u'write$'), Identifier(u'dot'), FunctionLiteral([Identifier(u's'), Identifier(u'add.period$')]), FunctionLiteral([Identifier(u's')]), Identifier(u'if$'), Identifier(u'add.name.index')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'comma.between.names'), Identifier(u'write$'), Identifier(u's'), Identifier(u'add.name.index'), Identifier(u'comma.before.last'), Identifier(u'dot'), FunctionLiteral([Identifier(u'et.al.string.period'), Identifier(u'*')]), FunctionLiteral([Identifier(u'et.al.string'), Identifier(u'*')]), Identifier(u'if$'), Identifier(u'write$')]), Identifier(u'if$')]), Identifier(u'if$')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.authors')],
  [Integer(1),
   Identifier(u'author'),
   Identifier(u'format.author.names'),
   String(u'%'),
   Identifier(u'write$')]],
 [u'FUNCTION',
  [Identifier(u'format.editors.as.authors')],
  [Integer(0),
   Identifier(u'editor'),
   Identifier(u'format.author.names'),
   String(u'\\ '),
   Identifier(u'editor.postfix'),
   Identifier(u'*'),
   Identifier(u'add.period$'),
   Identifier(u'write$')]],
 [u'FUNCTION',
  [Identifier(u'format.ed.trans.as.authors')],
  [Integer(0),
   Identifier(u'editor'),
   Identifier(u'format.author.names'),
   String(u'\\ '),
   Identifier(u'editor.trans.postfix'),
   Identifier(u'*'),
   Identifier(u'add.period$'),
   Identifier(u'write$')]],
 [u'FUNCTION',
  [Identifier(u'format.editor.names')],
  [QuotedVar(u'field'),
   Identifier(u':='),
   Identifier(u'field'),
   Identifier(u'num.names$'),
   QuotedVar(u'numnames'),
   Identifier(u':='),
   Identifier(u'numnames'),
   QuotedVar(u'format.num.names'),
   Identifier(u':='),
   Identifier(u'format.num.names'),
   Identifier(u'name.max'),
   Identifier(u'>'),
   FunctionLiteral([Integer(1), QuotedVar(u'format.num.names'), Identifier(u':=')]),
   QuotedVar(u'skip$'),
   Identifier(u'if$'),
   Identifier(u'field'),
   Integer(1),
   Identifier(u'format.editor.name'),
   Identifier(u'numnames'),
   Integer(1),
   Identifier(u'='),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'format.num.names'), Integer(1), Identifier(u'='), FunctionLiteral([Identifier(u'et.al.string'), Identifier(u'*')]), FunctionLiteral([Identifier(u'numnames'), Integer(2), Identifier(u'='), FunctionLiteral([Identifier(u'field'), Integer(2), Identifier(u'format.editor.name'), QuotedVar(u's'), Identifier(u':='), Identifier(u's'), String(u'others'), Identifier(u'='), FunctionLiteral([Identifier(u'et.al.string'), Identifier(u'*')]), FunctionLiteral([Identifier(u'and.before.last'), Identifier(u'*'), Identifier(u's'), Identifier(u'*')]), Identifier(u'if$')]), FunctionLiteral([Integer(2), QuotedVar(u'nameptr'), Identifier(u':='), FunctionLiteral([Identifier(u'nameptr'), Identifier(u'format.num.names'), Identifier(u'<')]), FunctionLiteral([Identifier(u'comma.between.names'), Identifier(u'*'), Identifier(u'field'), Identifier(u'nameptr'), Identifier(u'format.editor.name'), Identifier(u'*'), Identifier(u'nameptr'), Integer(1), Identifier(u'+'), QuotedVar(u'nameptr'), Identifier(u':=')]), Identifier(u'while$'), Identifier(u'field'), Identifier(u'nameptr'), Identifier(u'format.editor.name'), QuotedVar(u's'), Identifier(u':='), Identifier(u'format.num.names'), Identifier(u'numnames'), Identifier(u'='), FunctionLiteral([Identifier(u'comma.before.last'), Identifier(u'*'), Identifier(u's'), String(u'others'), Identifier(u'='), FunctionLiteral([Identifier(u'et.al.string'), Identifier(u'*')]), FunctionLiteral([Identifier(u'and.before.last'), Identifier(u'*'), Identifier(u's'), Identifier(u'*')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'comma.between.names'), Identifier(u'*'), Identifier(u's'), Identifier(u'*'), Identifier(u'comma.before.last'), Identifier(u'*'), Identifier(u'et.al.string'), Identifier(u'*')]), Identifier(u'if$')]), Identifier(u'if$')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.editors.in.line')],
  [Identifier(u'editor'),
   Identifier(u'format.editor.names'),
   Identifier(u'editor.postfix'),
   Identifier(u'connect.with.space.check')]],
 [u'FUNCTION',
  [Identifier(u'format.editors.trans.in.line')],
  [Identifier(u'editor'),
   Identifier(u'format.editor.names'),
   Identifier(u'editor.trans.postfix'),
   Identifier(u'connect.with.space.check')]],
 [u'FUNCTION',
  [Identifier(u'format.translators.in.line')],
  [Identifier(u'translator'),
   Identifier(u'format.editor.names'),
   Identifier(u'trans.postfix'),
   Identifier(u'connect.with.space.check')]],
 [u'FUNCTION',
  [Identifier(u'format.translators.in.paren.check')],
  [Identifier(u'translator'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'')]),
   FunctionLiteral([Identifier(u'translator'), Identifier(u'format.editor.names'), Identifier(u'translator'), Identifier(u'num.names$'), Integer(1), Identifier(u'>'), FunctionLiteral([String(u', \\BTRANSS{}'), Identifier(u'*')]), FunctionLiteral([String(u', \\BTRANS{}'), Identifier(u'*')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.editors.translators.in.paren.check')],
  [Identifier(u'editor'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'translator'), Identifier(u'empty$'), FunctionLiteral([String(u'')]), FunctionLiteral([Identifier(u'translator'), Identifier(u'format.editor.names'), Identifier(u'translator'), Identifier(u'num.names$'), Integer(1), Identifier(u'>'), FunctionLiteral([String(u', \\BTRANSS{}'), Identifier(u'*')]), FunctionLiteral([String(u', \\BTRANS{}'), Identifier(u'*')]), Identifier(u'if$')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'editor'), Identifier(u'format.editor.names'), Identifier(u'editor'), Identifier(u'num.names$'), Integer(1), Identifier(u'>'), FunctionLiteral([String(u', \\BEDS{}'), Identifier(u'*')]), FunctionLiteral([String(u', \\BED{}'), Identifier(u'*')]), Identifier(u'if$'), Identifier(u'translator'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'editor'), Identifier(u'translator'), Identifier(u'='), FunctionLiteral([Identifier(u'editor'), Identifier(u'num.names$'), Integer(1), Identifier(u'>'), FunctionLiteral([String(u' \\BAnd{} \\BTRANSS'), Identifier(u'*')]), FunctionLiteral([String(u' \\BAnd{} \\BTRANS'), Identifier(u'*')]), Identifier(u'if$')]), FunctionLiteral([String(u' \\BAnd{} '), Identifier(u'*'), Identifier(u'translator'), Identifier(u'format.editor.names'), Identifier(u'*'), Identifier(u'translator'), Identifier(u'num.names$'), Integer(1), Identifier(u'>'), FunctionLiteral([String(u', \\BTRANSS{}'), Identifier(u'*')]), FunctionLiteral([String(u', \\BTRANS{}'), Identifier(u'*')]), Identifier(u'if$')]), Identifier(u'if$')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.atrans.check')],
  [Identifier(u'format.translators.in.paren.check'),
   Identifier(u'parenthesize.check')]],
 [u'FUNCTION',
  [Identifier(u'format.in.editors')],
  [String(u'\\BIn{} '),
   Identifier(u'editor'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'format.editors.in.line'), Identifier(u'*'), String(u', '), Identifier(u'*')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.in.trans')],
  [String(u'\\BIn{} '),
   Identifier(u'translator'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'format.translators.in.line'), Identifier(u'*'), String(u', '), Identifier(u'*')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.in.editors.trans')],
  [String(u'\\BIn{} '),
   Identifier(u'editor'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'translator'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'format.translators.in.line'), Identifier(u'*'), String(u', '), Identifier(u'*')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'translator'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'format.editors.in.line'), Identifier(u'*')]), FunctionLiteral([Identifier(u'editor'), Identifier(u'translator'), Identifier(u'='), FunctionLiteral([Identifier(u'format.editors.trans.in.line'), Identifier(u'*')]), FunctionLiteral([Identifier(u'format.editors.in.line'), Identifier(u'*')]), Identifier(u'if$')]), Identifier(u'if$'), String(u', '), Identifier(u'*')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.year.check')],
  [String(u'\\APACrefYear{'),
   Identifier(u'year'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'\\bibnodate{}'), Identifier(u'*')]),
   FunctionLiteral([Identifier(u'year'), Identifier(u'*')]),
   Identifier(u'if$'),
   Identifier(u'make.definitive.year.supplement'),
   Identifier(u'*'),
   String(u'}'),
   Identifier(u'*')]],
 [u'FUNCTION',
  [Identifier(u'format.year.month.day.check')],
  [String(u'\\APACrefYearMonthDay{'),
   Identifier(u'year'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'\\bibnodate{}'), Identifier(u'*')]),
   FunctionLiteral([Identifier(u'year'), Identifier(u'*')]),
   Identifier(u'if$'),
   Identifier(u'make.definitive.year.supplement'),
   Identifier(u'*'),
   String(u'}{'),
   Identifier(u'*'),
   Identifier(u'month'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'month'), Identifier(u'*')]),
   Identifier(u'if$'),
   String(u'}{'),
   Identifier(u'*'),
   Identifier(u'day'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'day'), Identifier(u'*')]),
   Identifier(u'if$'),
   String(u'}'),
   Identifier(u'*')]],
 [u'FUNCTION',
  [Identifier(u'format.atitle.no.dot')],
  [String(u'\\BBOQ{}'),
   Identifier(u'swap$'),
   String(u'\\BBCQ{}'),
   Identifier(u'swap$'),
   Identifier(u'duplicate$'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), String(u'\\APACrefatitle{'), Identifier(u'swap$'), Identifier(u'*'), String(u'}{'), Identifier(u'*'), Identifier(u'swap$'), String(u't'), Identifier(u'change.case$'), Identifier(u'*'), String(u'}'), Identifier(u'*')]),
   Identifier(u'if$'),
   Identifier(u'enclose.check')]],
 [u'FUNCTION',
  [Identifier(u'format.atitle.dot')],
  [String(u'\\BBOQ{}'),
   Identifier(u'swap$'),
   String(u'\\BBCQ{}'),
   Identifier(u'swap$'),
   Identifier(u'duplicate$'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), String(u'\\APACrefatitle{'), Identifier(u'swap$'), Identifier(u'*'), String(u'}{'), Identifier(u'*'), Identifier(u'swap$'), String(u't'), Identifier(u'change.case$'), Identifier(u'*'), String(u'}'), Identifier(u'*'), Identifier(u'add.period$')]),
   Identifier(u'if$'),
   Identifier(u'enclose.check')]],
 [u'FUNCTION',
  [Identifier(u'format.atitle.connect')],
  [Identifier(u'swap$'),
   Identifier(u'duplicate$'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'pop$'), Identifier(u'format.atitle.dot')]),
   FunctionLiteral([Identifier(u'swap$'), Identifier(u'format.atitle.no.dot'), Identifier(u'swap$'), Identifier(u'connect.with.space.check'), Identifier(u'add.period$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.btitle.no.dot')],
  [Identifier(u'duplicate$'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), String(u'\\APACrefbtitle{'), Identifier(u'swap$'), Identifier(u'*'), String(u'}{'), Identifier(u'*'), Identifier(u'swap$'), String(u't'), Identifier(u'change.case$'), Identifier(u'*'), String(u'}'), Identifier(u'*')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.btitle.dot')],
  [Identifier(u'duplicate$'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'add.period$'), Identifier(u'format.btitle.no.dot')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.btitle.connect')],
  [Identifier(u'swap$'),
   Identifier(u'duplicate$'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'pop$'), Identifier(u'format.btitle.dot')]),
   FunctionLiteral([Identifier(u'swap$'), Identifier(u'format.btitle.no.dot'), Identifier(u'swap$'), Identifier(u'connect.with.space.check'), Identifier(u'add.period$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.btitle.connect.no.dot')],
  [Identifier(u'swap$'),
   Identifier(u'duplicate$'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'pop$'), Identifier(u'format.btitle.no.dot')]),
   FunctionLiteral([Identifier(u'swap$'), Identifier(u'format.btitle.no.dot'), Identifier(u'swap$'), Identifier(u'connect.with.space.check')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.aetitle.check')],
  [Identifier(u'englishtitle'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'')]),
   FunctionLiteral([String(u'\\APACrefaetitle{'), Identifier(u'englishtitle'), Identifier(u'*'), String(u'}{'), Identifier(u'*'), Identifier(u'englishtitle'), String(u't'), Identifier(u'change.case$'), Identifier(u'*'), String(u'}'), Identifier(u'*')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.betitle.check')],
  [Identifier(u'englishtitle'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'')]),
   FunctionLiteral([String(u'\\APACrefbetitle{'), Identifier(u'englishtitle'), Identifier(u'*'), String(u'}{'), Identifier(u'*'), Identifier(u'englishtitle'), String(u't'), Identifier(u'change.case$'), Identifier(u'*'), String(u'}'), Identifier(u'*')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.atype.check')],
  [Identifier(u'type'), Identifier(u'bracket.check')]],
 [u'FUNCTION',
  [Identifier(u'format.atitle.check')],
  [Identifier(u'format.aetitle.check'),
   Identifier(u'title'),
   Identifier(u'format.atitle.connect')]],
 [u'FUNCTION',
  [Identifier(u'format.atitle.type.check')],
  [Identifier(u'format.aetitle.check'),
   Identifier(u'format.atype.check'),
   Identifier(u'connect.with.space.check'),
   Identifier(u'title'),
   Identifier(u'format.atitle.connect')]],
 [u'FUNCTION',
  [Identifier(u'format.atitle.trans.check')],
  [Identifier(u'format.aetitle.check'),
   Identifier(u'format.atrans.check'),
   Identifier(u'connect.with.space.check'),
   Identifier(u'title'),
   Identifier(u'format.atitle.connect')]],
 [u'FUNCTION',
  [Identifier(u'format.atitle.type.trans.check')],
  [Identifier(u'format.aetitle.check'),
   Identifier(u'format.atype.check'),
   Identifier(u'connect.with.space.check'),
   Identifier(u'format.atrans.check'),
   Identifier(u'connect.with.space.check'),
   Identifier(u'title'),
   Identifier(u'format.atitle.connect')]],
 [u'FUNCTION',
  [Identifier(u'format.journal.vol.num.pages.check')],
  [String(u'journal'),
   Identifier(u'journal'),
   Identifier(u'warning.if.empty'),
   Identifier(u'duplicate$'),
   Identifier(u'empty$'),
   Identifier(u'journal'),
   Identifier(u'empty$'),
   Identifier(u'and'),
   Identifier(u'volume'),
   Identifier(u'empty$'),
   Identifier(u'and'),
   Identifier(u'number'),
   Identifier(u'empty$'),
   Identifier(u'and'),
   FunctionLiteral([Identifier(u'pop$'), String(u'')]),
   FunctionLiteral([String(u'\\APACjournalVolNumPages{'), Identifier(u'journal'), String(u''), Identifier(u'connect.check'), String(u'}{'), Identifier(u'*'), Identifier(u'volume'), String(u''), Identifier(u'connect.check'), String(u'}{'), Identifier(u'*'), Identifier(u'number'), String(u''), Identifier(u'connect.check'), String(u'}{'), Identifier(u'*'), Identifier(u'swap$'), String(u''), Identifier(u'connect.check'), String(u'}'), Identifier(u'*')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.bvolume.check')],
  [Identifier(u'duplicate$'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'multi.result.check'), FunctionLiteral([String(u'\\BVOLS'), Identifier(u'swap$'), Identifier(u'tie.or.space.connect')]), FunctionLiteral([String(u'\\BVOL'), Identifier(u'swap$'), Identifier(u'tie.or.space.connect')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.edition.check')],
  [Identifier(u'duplicate$'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([String(u'\\PrintOrdinal{'), Identifier(u'swap$'), Identifier(u'*'), String(u'}'), Identifier(u'*'), String(u'\\BEd'), Identifier(u'connect.with.space.check')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.bvol.edition.check')],
  [Identifier(u'edition'),
   Identifier(u'format.edition.check'),
   Identifier(u'volume'),
   Identifier(u'format.bvolume.check'),
   Identifier(u'connect.with.comma.check')]],
 [u'FUNCTION',
  [Identifier(u'format.bvol.edition')],
  [Identifier(u'format.bvol.edition.check'),
   Identifier(u'parenthesize.check')]],
 [u'FUNCTION',
  [Identifier(u'format.bvol.edition.trans')],
  [Identifier(u'format.bvol.edition.check'),
   Identifier(u'format.translators.in.paren.check'),
   Identifier(u'connect.with.semicolon.check'),
   Identifier(u'parenthesize.check')]],
 [u'FUNCTION',
  [Identifier(u'format.bvol.edition.editor.trans')],
  [Identifier(u'format.bvol.edition.check'),
   Identifier(u'format.editors.translators.in.paren.check'),
   Identifier(u'connect.with.semicolon.check'),
   Identifier(u'parenthesize.check')]],
 [u'FUNCTION',
  [Identifier(u'format.bpages.check')],
  [Identifier(u'duplicate$'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'multi.result.check'), FunctionLiteral([String(u'\\BPGS'), Identifier(u'swap$'), Identifier(u'tie.or.space.connect')]), FunctionLiteral([String(u'\\BPG~'), Identifier(u'swap$'), Identifier(u'*')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.bchapter.check')],
  [Identifier(u'duplicate$'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'multi.result.check'), FunctionLiteral([String(u'\\BCHAPS'), Identifier(u'swap$'), Identifier(u'tie.or.space.connect')]), FunctionLiteral([String(u'\\BCHAP'), Identifier(u'swap$'), Identifier(u'tie.or.space.connect')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.bvol.edition.pages')],
  [Identifier(u'format.bvol.edition.check'),
   Identifier(u'pages'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'chapter'), Identifier(u'format.bchapter.check'), Identifier(u'connect.with.comma.check')]),
   FunctionLiteral([Identifier(u'pages'), Identifier(u'format.bpages.check'), Identifier(u'connect.with.comma.check')]),
   Identifier(u'if$'),
   Identifier(u'parenthesize.check')]],
 [u'FUNCTION',
  [Identifier(u'format.btitle.vol.edition')],
  [Identifier(u'format.betitle.check'),
   Identifier(u'format.bvol.edition'),
   Identifier(u'connect.with.space.check'),
   Identifier(u'title'),
   Identifier(u'format.btitle.connect.no.dot')]],
 [u'FUNCTION',
  [Identifier(u'format.btitle.vol.edition.trans')],
  [Identifier(u'format.betitle.check'),
   Identifier(u'format.bvol.edition.trans'),
   Identifier(u'connect.with.space.check'),
   Identifier(u'title'),
   Identifier(u'format.btitle.connect.no.dot')]],
 [u'FUNCTION',
  [Identifier(u'format.btitle.vol.edition.editor.trans')],
  [Identifier(u'format.betitle.check'),
   Identifier(u'format.bvol.edition.editor.trans'),
   Identifier(u'connect.with.space.check'),
   Identifier(u'title'),
   Identifier(u'format.btitle.connect.no.dot')]],
 [u'FUNCTION',
  [Identifier(u'format.address.publisher')],
  [Identifier(u'author'),
   Identifier(u'empty$'),
   Identifier(u'publisher'),
   Identifier(u'empty$'),
   Identifier(u'or'),
   FunctionLiteral([Identifier(u'publisher'), String(u'\\APACaddressPublisher{')]),
   FunctionLiteral([Identifier(u'author'), Identifier(u'publisher'), Identifier(u'='), String(u'author'), Identifier(u'publisher'), Identifier(u'='), Identifier(u'or'), String(u'Author'), Identifier(u'publisher'), Identifier(u'='), Identifier(u'or'), FunctionLiteral([Identifier(u'author'), String(u'\\APACaddressPublisherEqAuth{')]), FunctionLiteral([Identifier(u'publisher'), String(u'\\APACaddressPublisher{')]), Identifier(u'if$')]),
   Identifier(u'if$'),
   Identifier(u'address'),
   String(u''),
   Identifier(u'connect.check'),
   String(u'}{'),
   Identifier(u'*'),
   Identifier(u'swap$'),
   String(u''),
   Identifier(u'connect.check'),
   String(u'}'),
   Identifier(u'*')]],
 [u'FUNCTION',
  [Identifier(u'format.address.publisher.check')],
  [String(u'publisher'),
   Identifier(u'publisher'),
   Identifier(u'warning.if.empty'),
   String(u'address'),
   Identifier(u'address'),
   Identifier(u'warning.if.empty'),
   Identifier(u'publisher'),
   Identifier(u'empty$'),
   Identifier(u'address'),
   Identifier(u'empty$'),
   Identifier(u'and'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'output.new.block')]), Identifier(u'if$'), Identifier(u'format.address.publisher')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.rnumber.check')],
  [Identifier(u'duplicate$'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'multi.result.check'), FunctionLiteral([String(u'\\BNUMS'), Identifier(u'swap$'), Identifier(u'tie.or.space.connect')]), FunctionLiteral([String(u'\\BNUM'), Identifier(u'swap$'), Identifier(u'tie.or.space.connect')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.type.number')],
  [Identifier(u'type'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'type.2')]),
   FunctionLiteral([Identifier(u'type')]),
   Identifier(u'if$'),
   Identifier(u'number'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'bracket.check')]),
   FunctionLiteral([Identifier(u'number'), Identifier(u'format.rnumber.check'), Identifier(u'connect.with.space.check'), Identifier(u'parenthesize.check')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.howpublished')],
  [Identifier(u'howpublished'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'empty$'), QuotedVar(u'pop$'), FunctionLiteral([Identifier(u'output.dot.new.block')]), Identifier(u'if$'), String(u'\\APAChowpublished{'), Identifier(u'howpublished'), Identifier(u'*'), String(u'}'), Identifier(u'*')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'output.howpublished')],
  [Identifier(u'howpublished'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([String(u'\\APAChowpublished{'), Identifier(u'howpublished'), Identifier(u'*'), String(u'}'), Identifier(u'*'), Identifier(u'output.dot.new.block')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'begin.end.url.env')],
  [String(u' \\begin{APACrefURL} '),
   Identifier(u'lastchecked'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([String(u'[{'), Identifier(u'*'), Identifier(u'lastchecked'), Identifier(u'*'), String(u'}]'), Identifier(u'*')]),
   Identifier(u'if$'),
   String(u' \\end{APACrefURL} ')]],
 [u'FUNCTION',
  [Identifier(u'begin.end.msg.env')],
  [String(u' \\begin{APACrefURLmsg} '), String(u' \\end{APACrefURLmsg} ')]],
 [u'FUNCTION',
  [Identifier(u'format.url')],
  [Identifier(u'type.2'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'begin.end.url.env')]),
   FunctionLiteral([Identifier(u'type.2'), String(u'\\bibmessage'), Identifier(u'='), FunctionLiteral([Identifier(u'begin.end.msg.env')]), FunctionLiteral([Identifier(u'begin.end.url.env')]), Identifier(u'if$')]),
   Identifier(u'if$'),
   String(u'\\url{'),
   Identifier(u'url'),
   Identifier(u'*'),
   String(u'}'),
   Identifier(u'*'),
   Identifier(u'enclose.check')]],
 [u'FUNCTION',
  [Identifier(u'format.note')],
  [String(u'\\APACrefnote{'),
   String(u'}'),
   Identifier(u'note'),
   Identifier(u'enclose.check')]],
 [u'FUNCTION',
  [Identifier(u'format.orig.year.note')],
  [Identifier(u'originalyear'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'format.note')]),
   FunctionLiteral([String(u'\\APACorigyearnote{'), Identifier(u'originalyear'), String(u''), Identifier(u'connect.check'), String(u'}{'), Identifier(u'*'), Identifier(u'note'), String(u''), Identifier(u'connect.check'), String(u'}'), Identifier(u'*')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.orig.journal.note')],
  [String(u'\\APACorigjournalnote{'),
   Identifier(u'originalyear'),
   String(u''),
   Identifier(u'connect.check'),
   String(u'}{'),
   Identifier(u'*'),
   Identifier(u'originaljournal'),
   String(u''),
   Identifier(u'connect.check'),
   String(u'}{'),
   Identifier(u'*'),
   Identifier(u'originalvolume'),
   String(u''),
   Identifier(u'connect.check'),
   String(u'}{'),
   Identifier(u'*'),
   Identifier(u'originalnumber'),
   String(u''),
   Identifier(u'connect.check'),
   String(u'}{'),
   Identifier(u'*'),
   Identifier(u'originalpages'),
   String(u''),
   Identifier(u'connect.check'),
   String(u'}{'),
   Identifier(u'*'),
   Identifier(u'note'),
   String(u''),
   Identifier(u'connect.check'),
   String(u'}'),
   Identifier(u'*')]],
 [u'FUNCTION',
  [Identifier(u'format.orig.book.note')],
  [String(u'\\APACorigbooknote{'),
   Identifier(u'originalyear'),
   String(u''),
   Identifier(u'connect.check'),
   String(u'}{'),
   Identifier(u'*'),
   Identifier(u'originaleditor'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'originaleditor'), Identifier(u'num.names$'), Integer(1), Identifier(u'>'), FunctionLiteral([String(u'\\APACorigEDS{'), Identifier(u'*'), Identifier(u'originaleditor'), Identifier(u'format.editor.names'), Identifier(u'*'), String(u'}'), Identifier(u'*')]), FunctionLiteral([String(u'\\APACorigED{'), Identifier(u'*'), Identifier(u'originaleditor'), Identifier(u'format.editor.names'), Identifier(u'*'), String(u'}'), Identifier(u'*')]), Identifier(u'if$')]),
   Identifier(u'if$'),
   String(u'}{'),
   Identifier(u'*'),
   Identifier(u'originalbooktitle'),
   Identifier(u'format.btitle.no.dot'),
   String(u''),
   Identifier(u'connect.check'),
   String(u'}{'),
   Identifier(u'*'),
   Identifier(u'originaledition'),
   Identifier(u'format.edition.check'),
   String(u''),
   Identifier(u'connect.check'),
   String(u'}{'),
   Identifier(u'*'),
   Identifier(u'originalvolume'),
   Identifier(u'format.bvolume.check'),
   String(u''),
   Identifier(u'connect.check'),
   String(u'}{'),
   Identifier(u'*'),
   Identifier(u'originalpages'),
   Identifier(u'format.bpages.check'),
   String(u''),
   Identifier(u'connect.check'),
   String(u'}{'),
   Identifier(u'*'),
   Identifier(u'originaladdress'),
   String(u''),
   Identifier(u'connect.check'),
   String(u'}{'),
   Identifier(u'*'),
   Identifier(u'originalpublisher'),
   String(u''),
   Identifier(u'connect.check'),
   String(u'}{'),
   Identifier(u'*'),
   Identifier(u'note'),
   String(u''),
   Identifier(u'connect.check'),
   String(u'}'),
   Identifier(u'*')]],
 [u'FUNCTION',
  [Identifier(u'format.orig.note')],
  [Identifier(u'originaljournal'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'originalbooktitle'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'note'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'originalyear'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'originalyear'), String(u'\\bibnodate'), Identifier(u'='), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'output.new.block'), Identifier(u'format.orig.year.note')]), Identifier(u'if$')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'output.new.block'), Identifier(u'format.orig.year.note')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'output.new.block'), Identifier(u'format.orig.book.note')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'output.new.block'), Identifier(u'format.orig.journal.note')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'periodical')],
  [Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'editor'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'format.atitle.type.trans.check'), Identifier(u'output.new.block'), Identifier(u'output.dot.new.block')]), FunctionLiteral([Identifier(u'format.editors.as.authors'), Identifier(u'start.new.block'), Identifier(u'output.dot.new.block'), Identifier(u'format.atitle.type.trans.check'), Identifier(u'output.new.block')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'format.authors'), Identifier(u'start.new.block'), Identifier(u'output.dot.new.block'), Identifier(u'format.atitle.type.trans.check'), Identifier(u'output.new.block')]),
   Identifier(u'if$'),
   Identifier(u'format.journal.vol.num.pages.check'),
   Identifier(u'format.howpublished'),
   Identifier(u'add.period$'),
   Identifier(u'url'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'output.new.block')]), Identifier(u'if$'), Identifier(u'format.url')]),
   Identifier(u'if$'),
   Identifier(u'format.orig.note'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'article')],
  [Identifier(u'pages'),
   Identifier(u'format.year.month.day.check'),
   Identifier(u'periodical')]],
 [u'FUNCTION',
  [Identifier(u'magazine')],
  [Identifier(u'pages'),
   Identifier(u'format.year.month.day.check'),
   Identifier(u'periodical')]],
 [u'FUNCTION',
  [Identifier(u'newspaper')],
  [Identifier(u'pages'),
   Identifier(u'format.bpages.check'),
   Identifier(u'format.year.month.day.check'),
   Identifier(u'periodical')]],
 [u'FUNCTION',
  [Identifier(u'book')],
  [Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'editor'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'format.btitle.vol.edition.trans'), Identifier(u'format.type.number'), Identifier(u'connect.with.space.check'), Identifier(u'output.dot.new.block'), Identifier(u'format.year.check'), Identifier(u'add.period$')]), FunctionLiteral([Identifier(u'translator'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'format.editors.as.authors'), Identifier(u'start.new.block'), Identifier(u'format.year.check'), Identifier(u'output.dot.new.block'), Identifier(u'format.btitle.vol.edition')]), FunctionLiteral([Identifier(u'translator'), Identifier(u'editor'), Identifier(u'='), Identifier(u'not'), FunctionLiteral([Identifier(u'format.editors.as.authors'), Identifier(u'start.new.block'), Identifier(u'format.year.check'), Identifier(u'output.dot.new.block'), Identifier(u'format.btitle.vol.edition.trans')]), FunctionLiteral([Identifier(u'format.ed.trans.as.authors'), Identifier(u'start.new.block'), Identifier(u'format.year.check'), Identifier(u'output.dot.new.block'), Identifier(u'format.btitle.vol.edition')]), Identifier(u'if$')]), Identifier(u'if$'), Identifier(u'format.type.number'), Identifier(u'connect.with.space.check'), Identifier(u'add.period$')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'format.authors'), Identifier(u'start.new.block'), Identifier(u'format.year.check'), Identifier(u'output.dot.new.block'), Identifier(u'format.btitle.vol.edition.editor.trans'), Identifier(u'format.type.number'), Identifier(u'connect.with.space.check'), Identifier(u'add.period$')]),
   Identifier(u'if$'),
   Identifier(u'format.address.publisher.check'),
   Identifier(u'format.howpublished'),
   Identifier(u'add.period$'),
   Identifier(u'url'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'output.new.block')]), Identifier(u'if$'), Identifier(u'format.url')]),
   Identifier(u'if$'),
   Identifier(u'format.orig.note'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'incollection')],
  [Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'editor.ne.trans'), FunctionLiteral([Identifier(u'format.atitle.type.trans.check')]), FunctionLiteral([Identifier(u'format.atitle.type.check')]), Identifier(u'if$'), Identifier(u'output.new.block'), Identifier(u'format.year.month.day.check'), Identifier(u'add.period$')]),
   FunctionLiteral([Identifier(u'format.authors'), Identifier(u'start.new.block'), Identifier(u'format.year.month.day.check'), Identifier(u'output.dot.new.block'), Identifier(u'editor.ne.trans'), FunctionLiteral([Identifier(u'format.atitle.type.trans.check')]), FunctionLiteral([Identifier(u'format.atitle.type.check')]), Identifier(u'if$')]),
   Identifier(u'if$'),
   Identifier(u'output.new.block'),
   Identifier(u'format.in.editors.trans'),
   Identifier(u'format.bvol.edition.pages'),
   Identifier(u'booktitle'),
   Identifier(u'format.btitle.connect'),
   Identifier(u'*'),
   Identifier(u'add.period$'),
   Identifier(u'format.address.publisher.check'),
   Identifier(u'format.howpublished'),
   Identifier(u'add.period$'),
   Identifier(u'url'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'output.new.block')]), Identifier(u'if$'), Identifier(u'format.url')]),
   Identifier(u'if$'),
   Identifier(u'format.orig.note'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'format.tr.number')],
  [Identifier(u'type'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'\\BTR{}')]),
   FunctionLiteral([Identifier(u'type'), String(u'\\bibnotype'), Identifier(u'='), FunctionLiteral([String(u'')]), FunctionLiteral([Identifier(u'type')]), Identifier(u'if$')]),
   Identifier(u'if$'),
   Identifier(u'number'),
   Identifier(u'format.rnumber.check'),
   Identifier(u'connect.with.space.check')]],
 [u'FUNCTION',
  [Identifier(u'format.tr.title.number')],
  [Identifier(u'format.betitle.check'),
   Identifier(u'type'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'\\APACbVolEdTR{'), Identifier(u'format.bvol.edition.check'), Identifier(u'*'), String(u'}{'), Identifier(u'*'), Identifier(u'format.tr.number'), Identifier(u'*'), String(u'}'), Identifier(u'*')]),
   FunctionLiteral([Identifier(u'type'), String(u'\\bibnotype'), Identifier(u'='), Identifier(u'number'), Identifier(u'empty$'), Identifier(u'volume'), Identifier(u'empty$'), Identifier(u'edition'), Identifier(u'empty$'), Identifier(u'and'), Identifier(u'and'), Identifier(u'and'), FunctionLiteral([String(u'')]), FunctionLiteral([String(u'\\APACbVolEdTR{'), Identifier(u'format.bvol.edition.check'), Identifier(u'*'), String(u'}{'), Identifier(u'*'), Identifier(u'format.tr.number'), Identifier(u'*'), String(u'}'), Identifier(u'*')]), Identifier(u'if$')]),
   Identifier(u'if$'),
   Identifier(u'connect.with.space.check'),
   Identifier(u'title'),
   Identifier(u'format.btitle.connect')]],
 [u'FUNCTION',
  [Identifier(u'format.address.institution.check')],
  [String(u'institution'),
   Identifier(u'institution'),
   Identifier(u'warning.if.empty'),
   String(u'address'),
   Identifier(u'address'),
   Identifier(u'warning.if.empty'),
   Identifier(u'institution'),
   Identifier(u'empty$'),
   Identifier(u'address'),
   Identifier(u'empty$'),
   Identifier(u'and'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'output.new.block')]), Identifier(u'if$'), Identifier(u'author'), Identifier(u'empty$'), Identifier(u'institution'), Identifier(u'empty$'), Identifier(u'or'), FunctionLiteral([Identifier(u'institution'), String(u'\\APACaddressInstitution{')]), FunctionLiteral([Identifier(u'author'), Identifier(u'institution'), Identifier(u'='), String(u'author'), Identifier(u'institution'), Identifier(u'='), Identifier(u'or'), String(u'Author'), Identifier(u'institution'), Identifier(u'='), Identifier(u'or'), FunctionLiteral([Identifier(u'author'), String(u'\\APACaddressInstitutionEqAuth{')]), FunctionLiteral([Identifier(u'institution'), String(u'\\APACaddressInstitution{')]), Identifier(u'if$')]), Identifier(u'if$'), Identifier(u'address'), String(u''), Identifier(u'connect.check'), String(u'}{'), Identifier(u'*'), Identifier(u'swap$'), String(u''), Identifier(u'connect.check'), String(u'}'), Identifier(u'*')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'techreport')],
  [Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'editor'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'format.tr.title.number'), Identifier(u'output.dot.new.block'), Identifier(u'format.year.month.day.check'), Identifier(u'add.period$')]), FunctionLiteral([Identifier(u'format.editors.as.authors'), Identifier(u'start.new.block'), Identifier(u'format.year.month.day.check'), Identifier(u'output.dot.new.block'), Identifier(u'format.tr.title.number'), Identifier(u'add.period$')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'format.authors'), Identifier(u'start.new.block'), Identifier(u'format.year.month.day.check'), Identifier(u'output.dot.new.block'), Identifier(u'format.tr.title.number'), Identifier(u'add.period$')]),
   Identifier(u'if$'),
   Identifier(u'format.address.institution.check'),
   Identifier(u'format.howpublished'),
   Identifier(u'add.period$'),
   Identifier(u'url'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'output.new.block')]), Identifier(u'if$'), Identifier(u'format.url')]),
   Identifier(u'if$'),
   Identifier(u'note'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'output.new.block')]), Identifier(u'if$'), Identifier(u'format.note')]),
   Identifier(u'if$'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'intechreport')],
  [Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'editor.ne.trans'), FunctionLiteral([Identifier(u'format.atitle.trans.check')]), FunctionLiteral([Identifier(u'format.atitle.check')]), Identifier(u'if$'), Identifier(u'output.new.block'), Identifier(u'format.year.month.day.check'), Identifier(u'output.dot.new.block')]),
   FunctionLiteral([Identifier(u'format.authors'), Identifier(u'start.new.block'), Identifier(u'format.year.month.day.check'), Identifier(u'output.dot.new.block'), Identifier(u'editor.ne.trans'), FunctionLiteral([Identifier(u'format.atitle.trans.check')]), FunctionLiteral([Identifier(u'format.atitle.check')]), Identifier(u'if$'), Identifier(u'output.new.block')]),
   Identifier(u'if$'),
   Identifier(u'format.in.editors.trans'),
   String(u'\\APACbVolEdTRpgs{'),
   Identifier(u'format.bvol.edition.check'),
   Identifier(u'*'),
   String(u'}{'),
   Identifier(u'*'),
   Identifier(u'format.tr.number'),
   Identifier(u'*'),
   String(u'}{'),
   Identifier(u'*'),
   Identifier(u'pages'),
   Identifier(u'format.bpages.check'),
   Identifier(u'*'),
   String(u'}'),
   Identifier(u'*'),
   Identifier(u'booktitle'),
   Identifier(u'format.btitle.connect'),
   Identifier(u'*'),
   Identifier(u'add.period$'),
   Identifier(u'format.address.institution.check'),
   Identifier(u'format.howpublished'),
   Identifier(u'add.period$'),
   Identifier(u'url'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'output.new.block')]), Identifier(u'if$'), Identifier(u'format.url')]),
   Identifier(u'if$'),
   Identifier(u'format.orig.note'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'lecture')],
  [Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'author'), Identifier(u'author'), Identifier(u'warning.if.empty')]),
   FunctionLiteral([Identifier(u'format.authors'), Identifier(u'start.new.block')]),
   Identifier(u'if$'),
   Identifier(u'format.year.month.day.check'),
   Identifier(u'output.dot.new.block'),
   Identifier(u'symposium'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'format.betitle.check'), Identifier(u'title'), Identifier(u'format.btitle.connect'), Identifier(u'output.new.block'), Identifier(u'howpublished'), Identifier(u'empty$'), FunctionLiteral([String(u'symposium and howpublished missing in '), Identifier(u'cite$'), Identifier(u'*'), Identifier(u'warning$'), String(u'')]), FunctionLiteral([String(u'\\APAChowpublished{'), Identifier(u'howpublished'), Identifier(u'*'), String(u'}'), Identifier(u'*')]), Identifier(u'if$'), Identifier(u'address'), Identifier(u'connect.with.comma.check')]),
   FunctionLiteral([Identifier(u'format.atitle.type.check'), Identifier(u'output.new.block'), String(u'\\BIn{} '), Identifier(u'chair'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'chair'), Identifier(u'format.editor.names'), Identifier(u'chair'), Identifier(u'num.names$'), Integer(1), Identifier(u'>'), FunctionLiteral([String(u'(\\BCHAIRS)')]), FunctionLiteral([String(u'(\\BCHAIR)')]), Identifier(u'if$'), Identifier(u'connect.with.space.check'), Identifier(u'*'), String(u', '), Identifier(u'*')]), Identifier(u'if$'), Identifier(u'symposium'), Identifier(u'format.btitle.no.dot'), Identifier(u'*'), Identifier(u'format.howpublished'), Identifier(u'address'), Identifier(u'connect.with.comma.check')]),
   Identifier(u'if$'),
   Identifier(u'add.period$'),
   Identifier(u'url'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'output.new.block')]), Identifier(u'if$'), Identifier(u'format.url')]),
   Identifier(u'if$'),
   Identifier(u'note'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'output.new.block')]), Identifier(u'if$'), Identifier(u'format.note')]),
   Identifier(u'if$'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'format.type.school')],
  [Identifier(u'type'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'pop$'), Identifier(u'type'), String(u't'), Identifier(u'change.case$')]),
   Identifier(u'if$'),
   Identifier(u'school'),
   Identifier(u'connect.with.comma.check')]],
 [u'FUNCTION',
  [Identifier(u'thesis')],
  [Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'author'), Identifier(u'author'), Identifier(u'warning.if.empty')]),
   FunctionLiteral([Identifier(u'format.authors'), Identifier(u'start.new.block')]),
   Identifier(u'if$'),
   Identifier(u'format.year.check'),
   Identifier(u'output.dot.new.block'),
   Identifier(u'journal'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'format.btitle.vol.edition'), Identifier(u'output.dot.new.block'), Identifier(u'swap$'), Identifier(u'pop$'), Identifier(u'format.type.school'), Identifier(u'address'), Identifier(u'connect.with.comma.check')]),
   FunctionLiteral([Identifier(u'pop$'), Identifier(u'type'), Identifier(u'empty$'), Identifier(u'school'), Identifier(u'empty$'), Identifier(u'originalyear'), Identifier(u'empty$'), Identifier(u'and'), Identifier(u'and'), FunctionLiteral([Identifier(u'pop$'), String(u'')]), FunctionLiteral([Identifier(u'format.type.school'), Identifier(u'originalyear'), Identifier(u'connect.with.comma.check'), Identifier(u'parenthesize.check')]), Identifier(u'if$'), Identifier(u'format.aetitle.check'), Identifier(u'swap$'), Identifier(u'connect.with.space.check'), String(u'title'), Identifier(u'title'), Identifier(u'warning.if.empty'), Identifier(u'title'), Identifier(u'format.atitle.connect'), Identifier(u'output.new.block'), Identifier(u'pages'), Identifier(u'format.journal.vol.num.pages.check')]),
   Identifier(u'if$'),
   Identifier(u'format.howpublished'),
   Identifier(u'add.period$'),
   Identifier(u'url'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'output.new.block')]), Identifier(u'if$'), Identifier(u'format.url')]),
   Identifier(u'if$'),
   Identifier(u'note'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'output.new.block')]), Identifier(u'if$'), Identifier(u'format.note')]),
   Identifier(u'if$'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'phdthesis')],
  [String(u'\\BPhD'), String(u'\\BUPhD'), Identifier(u'thesis')]],
 [u'FUNCTION',
  [Identifier(u'mastersthesis')],
  [String(u'\\BMTh'), String(u'\\BUMTh'), Identifier(u'thesis')]],
 [u'FUNCTION',
  [Identifier(u'format.btitle.type.num')],
  [Identifier(u'format.betitle.check'),
   Identifier(u'format.bvol.edition'),
   Identifier(u'connect.with.space.check'),
   Identifier(u'format.type.number'),
   Identifier(u'connect.with.space.check'),
   Identifier(u'title'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'add.period$')]),
   FunctionLiteral([Identifier(u'title'), Identifier(u'format.btitle.connect')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'format.mtitle.type.num')],
  [Identifier(u'format.aetitle.check'),
   Identifier(u'format.bvol.edition'),
   Identifier(u'connect.with.space.check'),
   Identifier(u'type.2'),
   String(u'\\bibmessage'),
   Identifier(u'='),
   FunctionLiteral([Identifier(u'number'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'type.2'), Identifier(u'number'), Identifier(u'tie.or.space.connect'), Identifier(u'bracket.check'), Identifier(u'connect.with.space.check')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'format.type.number'), Identifier(u'connect.with.space.check')]),
   Identifier(u'if$'),
   Identifier(u'title'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'add.period$')]),
   FunctionLiteral([Identifier(u'title'), Identifier(u'format.atitle.connect')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'output.misctitle.type.num')],
  [Identifier(u'type.2'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'format.btitle.type.num')]),
   FunctionLiteral([Identifier(u'type.2'), String(u'\\bibmessage'), Identifier(u'='), Identifier(u'type.2'), String(u'\\bibcomputerprogram'), Identifier(u'='), Identifier(u'or'), Identifier(u'type.2'), String(u'\\bibcomputerprogrammanual'), Identifier(u'='), Identifier(u'or'), Identifier(u'type.2'), String(u'\\bibcomputerprogramandmanual'), Identifier(u'='), Identifier(u'or'), Identifier(u'type.2'), String(u'\\bibcomputersoftware'), Identifier(u'='), Identifier(u'or'), Identifier(u'type.2'), String(u'\\bibcomputersoftwaremanual'), Identifier(u'='), Identifier(u'or'), Identifier(u'type.2'), String(u'\\bibcomputersoftwareandmanual'), Identifier(u'='), Identifier(u'or'), Identifier(u'type.2'), String(u'\\bibprogramminglanguage'), Identifier(u'='), Identifier(u'or'), FunctionLiteral([Identifier(u'format.mtitle.type.num')]), FunctionLiteral([Identifier(u'format.btitle.type.num')]), Identifier(u'if$')]),
   Identifier(u'if$')]],
 [u'FUNCTION',
  [Identifier(u'unpublished')],
  [Identifier(u'check.relevant.fields'),
   Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'editor'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'format.btitle.type.num'), Identifier(u'output.new.block'), Identifier(u'format.year.month.day.check'), Identifier(u'add.period$')]), FunctionLiteral([Identifier(u'format.editors.as.authors'), Identifier(u'start.new.block'), Identifier(u'format.year.month.day.check'), Identifier(u'output.dot.new.block'), Identifier(u'format.btitle.type.num')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'format.authors'), Identifier(u'start.new.block'), Identifier(u'format.year.month.day.check'), Identifier(u'output.dot.new.block'), Identifier(u'format.btitle.type.num')]),
   Identifier(u'if$'),
   Identifier(u'howpublished'),
   Identifier(u'empty$'),
   Identifier(u'organization'),
   Identifier(u'empty$'),
   Identifier(u'and'),
   Identifier(u'address'),
   Identifier(u'empty$'),
   Identifier(u'and'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'output.new.block'), String(u'\\APAChowpublished{'), String(u'}'), Identifier(u'howpublished'), Identifier(u'enclose.check'), Identifier(u'organization'), Identifier(u'connect.with.comma.check'), Identifier(u'address'), Identifier(u'connect.with.comma.check'), Identifier(u'add.period$')]),
   Identifier(u'if$'),
   Identifier(u'url'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'output.new.block')]), Identifier(u'if$'), Identifier(u'format.url')]),
   Identifier(u'if$'),
   Identifier(u'note'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'output.new.block')]), Identifier(u'if$'), Identifier(u'format.note')]),
   Identifier(u'if$'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'misc')],
  [Identifier(u'type.2'),
   Identifier(u'empty$'),
   Identifier(u'type'),
   Identifier(u'empty$'),
   Identifier(u'not'),
   Identifier(u'and'),
   FunctionLiteral([Identifier(u'type'), QuotedVar(u'type.2'), Identifier(u':=')]),
   QuotedVar(u'skip$'),
   Identifier(u'if$'),
   Identifier(u'author'),
   Identifier(u'empty$'),
   FunctionLiteral([Identifier(u'editor'), Identifier(u'empty$'), FunctionLiteral([Identifier(u'title'), Identifier(u'empty$'), Identifier(u'type.2'), Identifier(u'empty$'), Identifier(u'and'), FunctionLiteral([Identifier(u'howpublished'), Identifier(u'empty$'), FunctionLiteral([String(u'No author, editor, title, type, and howpublished in '), Identifier(u'cite$'), Identifier(u'*'), Identifier(u'warning$'), String(u'')]), FunctionLiteral([String(u'\\APAChowpublished{'), Identifier(u'howpublished'), Identifier(u'*'), String(u'}'), Identifier(u'*'), Identifier(u'add.period$')]), Identifier(u'if$'), Identifier(u'format.year.month.day.check'), Identifier(u'add.period$')]), FunctionLiteral([Identifier(u'output.misctitle.type.num'), Identifier(u'output.new.block'), Identifier(u'format.year.month.day.check'), Identifier(u'add.period$'), Identifier(u'format.howpublished'), Identifier(u'add.period$')]), Identifier(u'if$')]), FunctionLiteral([Identifier(u'format.editors.as.authors'), Identifier(u'start.new.block'), Identifier(u'format.year.month.day.check'), Identifier(u'output.dot.new.block'), Identifier(u'output.misctitle.type.num'), Identifier(u'format.howpublished'), Identifier(u'add.period$')]), Identifier(u'if$')]),
   FunctionLiteral([Identifier(u'format.authors'), Identifier(u'start.new.block'), Identifier(u'format.year.month.day.check'), Identifier(u'output.dot.new.block'), Identifier(u'output.misctitle.type.num'), Identifier(u'format.howpublished'), Identifier(u'add.period$')]),
   Identifier(u'if$'),
   Identifier(u'address'),
   Identifier(u'empty$'),
   Identifier(u'publisher'),
   Identifier(u'empty$'),
   Identifier(u'and'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'output.new.block')]), Identifier(u'if$'), Identifier(u'format.address.publisher'), Identifier(u'add.period$')]),
   Identifier(u'if$'),
   Identifier(u'url'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'output.new.block')]), Identifier(u'if$'), Identifier(u'format.url')]),
   Identifier(u'if$'),
   Identifier(u'note'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'duplicate$'), Identifier(u'empty$'), QuotedVar(u'skip$'), FunctionLiteral([Identifier(u'output.new.block')]), Identifier(u'if$'), Identifier(u'format.note')]),
   Identifier(u'if$'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'literal')],
  [String(u'key'),
   Identifier(u'key'),
   Identifier(u'warning.if.empty'),
   String(u'text'),
   Identifier(u'text'),
   Identifier(u'warning.if.empty'),
   Identifier(u'text'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'')]),
   FunctionLiteral([Identifier(u'text')]),
   Identifier(u'if$'),
   Identifier(u'fin.entry')]],
 [u'FUNCTION',
  [Identifier(u'manual')],
  [Identifier(u'type'),
   Identifier(u'empty$'),
   FunctionLiteral([String(u'\\bibcomputersoftwaremanual'), QuotedVar(u'type.2'), Identifier(u':=')]),
   QuotedVar(u'skip$'),
   Identifier(u'if$'),
   Identifier(u'misc')]],
 [u'FUNCTION', [Identifier(u'booklet')], [Identifier(u'misc')]],
 [u'FUNCTION', [Identifier(u'inbook')], [Identifier(u'incollection')]],
 [u'FUNCTION', [Identifier(u'inproceedings')], [Identifier(u'incollection')]],
 [u'FUNCTION', [Identifier(u'conference')], [Identifier(u'inproceedings')]],
 [u'FUNCTION', [Identifier(u'proceedings')], [Identifier(u'misc')]],
 [u'FUNCTION', [Identifier(u'default.type')], [Identifier(u'misc')]],
 [u'FUNCTION',
  [Identifier(u'initialize')],
  [Integer(6), QuotedVar(u'name.max'), Identifier(u':=')]],
 [u'FUNCTION',
  [Identifier(u'init.old.number')],
  [Integer(0), QuotedVar(u'old.number'), Identifier(u':=')]],
 [u'FUNCTION',
  [Identifier(u'init.old.label')],
  [String(u'zzzzzz'), QuotedVar(u'old.label'), Identifier(u':=')]],
 [u'FUNCTION',
  [Identifier(u'init.cite.initials.add.to.year')],
  [Integer(0),
   QuotedVar(u'cite.initials'),
   Identifier(u':='),
   Integer(0),
   QuotedVar(u'add.to.year'),
   Identifier(u':=')]],
 [u'FUNCTION',
  [Identifier(u'move.forward')],
  [Integer(1), QuotedVar(u'forward'), Identifier(u':=')]],
 [u'FUNCTION',
  [Identifier(u'move.backward')],
  [Integer(0), QuotedVar(u'forward'), Identifier(u':=')]],
 [u'FUNCTION',
  [Identifier(u'begin.bib')],
  [Identifier(u'preamble$'),
   Identifier(u'empty$'),
   QuotedVar(u'skip$'),
   FunctionLiteral([Identifier(u'preamble$'), Identifier(u'write$'), Identifier(u'newline$')]),
   Identifier(u'if$'),
   String(u'\\begin{thebibliography}{}'),
   Identifier(u'write$'),
   Identifier(u'newline$')]],
 [u'FUNCTION',
  [Identifier(u'end.bib')],
  [Identifier(u'newline$'),
   String(u'\\end{thebibliography}'),
   Identifier(u'write$'),
   Identifier(u'newline$')]],
 [u'FUNCTION',
  [Identifier(u'write.bbl.entry')],
  [Identifier(u'make.cite.labels'), Identifier(u'call.type$')]],
 [u'READ'],
 [u'EXECUTE', [Identifier(u'identify.apacite.version')]],
 [u'EXECUTE', [Identifier(u'initialize')]],
 [u'ITERATE', [Identifier(u'make.sort.title')]],
 [u'SORT'],
 [u'EXECUTE', [Identifier(u'init.old.number')]],
 [u'EXECUTE', [Identifier(u'init.old.label')]],
 [u'ITERATE', [Identifier(u'make.title.number')]],
 [u'ITERATE', [Identifier(u'make.tentative.sort.label')]],
 [u'SORT'],
 [u'ITERATE', [Identifier(u'init.cite.initials.add.to.year')]],
 [u'EXECUTE', [Identifier(u'init.initials')]],
 [u'ITERATE', [Identifier(u'check.add.initials')]],
 [u'EXECUTE', [Identifier(u'init.initials')]],
 [u'REVERSE', [Identifier(u'check.add.initials')]],
 [u'ITERATE', [Identifier(u'tentative.cite.num.names')]],
 [u'EXECUTE', [Identifier(u'init.cite.num.names')]],
 [u'EXECUTE', [Identifier(u'move.forward')]],
 [u'ITERATE', [Identifier(u'definitive.cite.num.names')]],
 [u'EXECUTE', [Identifier(u'init.cite.num.names')]],
 [u'EXECUTE', [Identifier(u'move.backward')]],
 [u'REVERSE', [Identifier(u'definitive.cite.num.names')]],
 [u'ITERATE', [Identifier(u'make.final.sort.key')]],
 [u'SORT'],
 [u'EXECUTE', [Identifier(u'begin.bib')]],
 [u'ITERATE', [Identifier(u'write.bbl.entry')]],
 [u'EXECUTE', [Identifier(u'end.bib')]]]
