﻿
# game/tutorial_quickstart.rpy:28
translate french tutorial_create_27048c11:

    # e "When you're ready to use Ren'Py to create your visual novel, the first step is to create a new project."
    e "Quand vous êtes prêt à utiliser Ren’Py pour créer vos propres romans visuels, la première étape consiste à créer un nouveau projet."

# game/tutorial_quickstart.rpy:30
translate french tutorial_create_bae6289c:

    # e "You can create a new project by clicking 'Create New Project' on the front screen of the launcher."
    e "Vous pouvez créer un nouveau projet en cliquant sur « Créer un nouveau projet » sur l’écran principal du lanceur."

# game/tutorial_quickstart.rpy:32
translate french tutorial_create_45915fcb:

    # e "If this is your first time using Ren'Py, it'll ask you for the place you want to keep your projects. The best place is always somewhere that's frequently backed up."
    e "Si c’est la première fois que vous utilisez Ren’Py, il vous demandera l’emplacement où vous souhaitez stocker vos projets. Le meilleur emplacement est toujours un répertoire que vous sauvegardez régulièrement."

# game/tutorial_quickstart.rpy:36
translate french tutorial_create_55e30cb5:

    # e "After that, Ren'Py will ask for a name for your project. You'll have to stick to English letters and numbers, as zip files can't handle anything more than that."
    e "Après cela, Ren’Py va vous demander un nom pour votre projet. Vous ne devrez utiliser que des caractères non accentués et des nombres, car les archives zip ne supportent que ceux-ci."

# game/tutorial_quickstart.rpy:40
translate french tutorial_create_dea3e5c2:

    # e "The next thing Ren'Py will ask for is the resolution the visual novel will run at. This controls how large or small you'll have to make your game's artwork."
    e "L’information que vous demande ensuite Ren’Py, c’est la résolution de votre roman visuel. Ceci contrôle la taille des créations artistiques que vous aurez à créer."

# game/tutorial_quickstart.rpy:44
translate french tutorial_create_3289ea75:

    # e "Finally, Ren'Py will ask you to select a color scheme. You can change this after the game has been created, so just pick a color that's pleasing."
    e "Enfin, Ren’Py vous demandera la couleur principale de votre jeu. Vous pouvez la changer après la création du jeu, alors sélectionner simplement la couleur qui vous plait."

# game/tutorial_quickstart.rpy:48
translate french tutorial_create_6b9e3b96:

    # e "Once that's done, Ren'Py will work for a bit and return you to the main menu with the new project selected. Now, when you click Launch, Ren'Py will start your new game."
    e "Quand tout cela est fait, Ren’Py va travailler quelques temps et vous retournerez au menu principal du lanceur où le nouveau projet sera selectionné. Maintenant, quand vous cliquez sur « Lancer le projet », Ren’Py démarre votre nouveau jeu."

# game/tutorial_quickstart.rpy:50
translate french tutorial_create_bdf94f9b:

    # e "To get back here, you can choose 'Tutorial' to switch to this tutorial game."
    e "Pour revenir ici, vous pouvez cliquer sur « Tutoriel » pour basculer de nouveau sur le jeu de ce tutoriel."

# game/tutorial_quickstart.rpy:52
translate french tutorial_create_22f516df:

    # e "You'll also need to edit the games script to make changes. To do that, click 'script.rpy' on the front page of the launcher."
    e "Vous aurez besoin d’éditer les scripts du jeu pour effectuer des changements. Pour ce faire, cliquez sur « script.rpy » sur la page principale du lanceur."

# game/tutorial_quickstart.rpy:54
translate french tutorial_create_18cd1d9d:

    # e "If it's your first time doing so, Ren'Py will ask you to select a text editor. Editra might be a safe choice, but read the descriptions to be sure."
    e "Si c’est la première fois que vous le faites, Ren’Py vous demandera de sélectionner un éditeur. Editra est un choix fiable, mais lisez les descriptions pour vous informer au mieux sur les éditeurs proposés."

# game/tutorial_quickstart.rpy:56
translate french tutorial_create_bfbd6220:

    # e "After the text editor is downloaded, the script will open up and you can start to change what characters are saying."
    e "Une fois l’éditeur de jeu téléchargé, le script s’ouvrira et vous pourrez commencer à changer les dialogues des personnages."

# game/tutorial_quickstart.rpy:69
translate french tutorial_dialogue_112ff505:

    # e "Probably the most common thing a creator does with Ren'Py is to write dialogue for the player to read."
    e "La chose la plus commune que fait un créateur sur Ren’Py, c’est d’écrire les dialogues que le joueur lira."

# game/tutorial_quickstart.rpy:71
translate french tutorial_dialogue_be2be31a:

    # e "But before I can show you how to write dialogue, let me show you how we present script examples."
    e "Mais avant que je ne vous montre comment écrire des dialogues, laissez-moi vous présenter quelques exemples de script."

# game/tutorial_quickstart.rpy:74
translate french tutorial_dialogue_7b6be28e:

    # "Eileen" "Examples will show up in a window like the one above. You'll need to click outside of the example window in order to advance the tutorial."
    "Eileen" "Les exemples seront présentés dans une fenêtre comme celle ci-dessus. Cliquez hors de la fenêtre pour avancer dans le tutoriel."

# game/tutorial_quickstart.rpy:76
translate french tutorial_dialogue_5269d005:

    # "Eileen" "When an example is bigger than the screen, you can scroll around in it using the mouse wheel or by simply dragging the mouse."
    "Eileen" "Quand un exemple est plus grand que l’écran, vous pouvez le faire défiler en utilisant la roulette de la souris ou simplement en le faisant glisser avec la souris."

# game/tutorial_quickstart.rpy:78
translate french tutorial_dialogue_241c0c74:

    # "Eileen" "Script might seem scary at first, but if you look you'll see it's easy to match it up to what I'm saying."
    "Eileen" "Les scripts peuvent paraître impressionnant au début, mais vous allez voir rapidement comme il facile de faire la correspondance avec ce que je dis."

# game/tutorial_quickstart.rpy:82
translate french tutorial_dialogue_f0d66410:

    # e "Let's see the simplest possible Ren'Py game."
    e "Découvrons ensemble le jeu Ren’Py le plus simple possible !"

# game/tutorial_quickstart.rpy:89
translate french tutorial_dialogue_3e6b0068:

    # "Wow, It's really really dark in here."
    "Ouah, c’est vraiment sombre ici."

# game/tutorial_quickstart.rpy:91
translate french tutorial_dialogue_5072a404:

    # "Lucy" "Better watch out. You don't want to be eaten by a Grue."
    "Lucy" "Soyons vigilants ! Vous ne voulez pas être mangé par une grue."

# game/tutorial_quickstart.rpy:99
translate french tutorial_dialogue_d39d1b2b:

    # e "I'll show you the script of that example."
    e "Je vais vous montrer le script de cet exemple."

# game/tutorial_quickstart.rpy:101
translate french tutorial_dialogue_f51ecf1f:

    # e "This script demonstrates two kinds of Ren'Py statements, labels and say statements."
    e "Ce script démontre deux type de déclarations Ren’Py : les labels et les dialogues."

# game/tutorial_quickstart.rpy:103
translate french tutorial_dialogue_bc7ec147:

    # e "The first line is a label statement. The label statement is used to give a name to a place in the program."
    e "La première ligne est une déclaration 'label'. La déclaration de label est utilisée pour donner un nom à cet emplacement dans le programme."

# game/tutorial_quickstart.rpy:105
translate french tutorial_dialogue_b20db833:

    # e "In this case, we're naming a place \"start\". The start label is special, as it marks the place a game begins running."
    e "Dans ce cas, nous avons nommé cet emplacement « start ». Ce label est particulier, car il marque le point de départ de votre jeu."

# game/tutorial_quickstart.rpy:107
translate french tutorial_dialogue_b0afbe96:

    # e "The next line is a simple say statement. It consists of a string beginning with a double-quote, and ending at the next double-quote."
    e "La ligne suivante est une simple déclaration 'say'. Elle est composée d’une chaîne de caractère entre deux double-quote (\")."

# game/tutorial_quickstart.rpy:109
translate french tutorial_dialogue_628c9e4c:

    # e "Special characters in strings can be escaped with a backslash. To include \" in a string, we have to write \\\"."
    e "Les caractères spéciaux dans une châine de caractère doivent être protégés par un antislash. Pour inclure une \" dans une chaîne de caractères, vous devez taper \\\"."

# game/tutorial_quickstart.rpy:116
translate french tutorial_dialogue_3e6b0068_1:

    # "Wow, It's really really dark in here."
    "Ouah, c’est vraiment vraiment sombre ici."

# game/tutorial_quickstart.rpy:125
translate french tutorial_dialogue_d7f0b5b7:

    # e "When Ren'Py sees a single string on a line by itself, it uses the narrator to say that string. So a single string can be used to express a character's thoughts."
    e "Quand Ren’Py voit une simple chaîne dans une ligne, il considère que c’est le narrateur qui parle. Ainsi une simple chaîne peut être utilisée pour exprimer les pensées d’un personnage."

# game/tutorial_quickstart.rpy:131
translate french tutorial_dialogue_5072a404_1:

    # "Lucy" "Better watch out. You don't want to be eaten by a Grue."
    "Lucy" "Soyons vigilants ! Vous ne voulez pas être mangé par une grue."

# game/tutorial_quickstart.rpy:139
translate french tutorial_dialogue_9dd2d543:

    # e "When we have two strings separated by a space, the first is used as the character's name, and the second is what the character is saying."
    e "Quand nous avons deux chaînes séparées par un espace, la première est utilisée comme le nom du personnage et la seconde comme ce que ce personnage dit."

# game/tutorial_quickstart.rpy:141
translate french tutorial_dialogue_64ffe685:

    # e "This two-argument form of the say statement is used for dialogue, where a character is speaking out loud."
    e "Cette forme à deux arguments est utilisée pour le dialogue, quand un personnage parle à voix haute."

# game/tutorial_quickstart.rpy:143
translate french tutorial_dialogue_97a33275:

    # e "If you'd like, you can run this game yourself by erasing everything in your project's script.rpy file, and replacing it with the code in the box above."
    e "Si vous le souhaitez, vous pouvez éxecuter ce jeu vous-même en effaçant tout ce que contient le fichier script.rpy dans votre projet et en le remplaçant par le code de la boîte ci-dessus."

# game/tutorial_quickstart.rpy:145
translate french tutorial_dialogue_c5e70d7e:

    # e "Be sure to preserve the spacing before lines. That's known as indentation, and it's used to help Ren'Py group lines of script into blocks."
    e "Soyez attentif à préserver les espaces au début des lignes. Cela s’appelle une indentation et c’est utilisé pour aider Ren’Py à regrouper les lignes de script dans des blocs."

# game/tutorial_quickstart.rpy:149
translate french tutorial_dialogue_90719f73:

    # e "Using a string for a character's name is inconvenient, for two reasons."
    e "Utiliser une chaîne de caractère pour le nom d’un personnage est problématique pour deux raisons."

# game/tutorial_quickstart.rpy:151
translate french tutorial_dialogue_910f286a:

    # e "The first is that's it's a bit verbose. While typing \"Lucy\" isn't so bad, imagine if you had to type \"Eileen Richardson\" thousands of times."
    e "La première, c’est que c’est une solution un peu verbeuse. Même si écrire \"Lucy\" n’est pas faux, imaginez ce que cela va être si vous devez taper \"Eileen Richardson\" un millier de fois !"

# game/tutorial_quickstart.rpy:153
translate french tutorial_dialogue_9c9d59c2:

    # e "The second is that it doesn't leave any place to put styling, which can change the look of a character."
    e "La seconde, c’est que cela ne laisse pas beaucoup de place pour placer le style qui peut changer le look du personnage."

# game/tutorial_quickstart.rpy:155
translate french tutorial_dialogue_2a2d1e51:

    # e "To solve these problems, Ren'Py lets you define Characters."
    e "Pour résoudre ces problèmes, Ren’Py vous permet de définir des Characters (des objets Personnages)."

# game/tutorial_quickstart.rpy:159
translate french tutorial_dialogue_16e8c5fd:

    # e "Here's an example Character definition. It begins with the word \"define\". That tells Ren'Py that we are defining something."
    e "Voici un exemple de définition d’un personnage. Il commence par le mot-clé \"define\". Ce qui informe Ren’Py que vous allez définir quelque chose."

# game/tutorial_quickstart.rpy:161
translate french tutorial_dialogue_34fe5aa0:

    # e "Define is followed by a short name for the character, like \"l\". We'll be able to use that short name when writing dialogue."
    e "'define' est suivi par un nom court pour le personnage, comme \"l\". Nous serons alors en mesure d’utiliser ce nom court comme raccourci pour écrire les dialogues."

# game/tutorial_quickstart.rpy:163
translate french tutorial_dialogue_67f90201:

    # e "This is followed by an equals sign, and the thing that we're defining. In this case, it's a Character."
    e "C’est suivi par le signe égal et la chose que nous définissons. Dans notre cas, c’est un Character (un personnage)."

# game/tutorial_quickstart.rpy:165
translate french tutorial_dialogue_4e454a89:

    # e "On the first line, the character's name is given to be \"Lucy\", and her name will be drawn a reddish color."
    e "À la première ligne, le nom du personnage est renseigné avec \"Lucy\" et son nom sera dessiné en utilisant une couleur rouge sombre."

# game/tutorial_quickstart.rpy:167
translate french tutorial_dialogue_db11f026:

    # e "These short names are case-sensitive. Capital L is a different name from lower-case l, so you'll need to be careful about that."
    e "Ces noms courts sont sensibles à la casse. Un L majuscule est un nom différent d’un l minuscule. Alors, vous allez devoir être attentif à cela."

# game/tutorial_quickstart.rpy:171
translate french tutorial_dialogue_1d161320:

    # e "Now that we have a character defined, we can use it to say dialogue."
    e "Maintenant que nous avons un personnage défini, nous allons utiliser les dialogues pour le faire parler."

# game/tutorial_quickstart.rpy:178
translate french tutorial_dialogue_3710169c:

    # l "Why are you trying to put words into my mouth? And who are you calling \"it\"?"
    l "Pourquoi êtes-vous en train de placer des mots dans ma bouche ? Et pourquoi parlez-vous de \"ça\" ?"

# game/tutorial_quickstart.rpy:180
translate french tutorial_dialogue_6d463776:

    # l "What's more, what are you going to do about the Grue problem? Are you just going to leave me here?"
    l "Qui plus est, qu’allez-vous faire à propos de la Grue ? Vous allez juste me laisser ici ?"

# game/tutorial_quickstart.rpy:188
translate french tutorial_dialogue_023bcd31:

    # e "Here's the full game, including the two new lines of dialogue, both of which use the Character we defined to say dialogue."
    e "Voici le jeu complet, incluant les deux lignes de dialogues qui utilisent le Character que nous avons défini pour prononcer les dialogues."

# game/tutorial_quickstart.rpy:190
translate french tutorial_dialogue_48bb9547:

    # e "The one-argument form of the say statement is unchanged, but in the two-argument form, instead of the first string we can use a short name."
    e "La déclaration formée d’un seul argument ne change pas, mais la forme avec deux arguments évolue. À la place de la chaîne de caractère, on peut utiliser le nom court."

# game/tutorial_quickstart.rpy:192
translate french tutorial_dialogue_56a9936f:

    # e "When this say statement is run, Ren'Py will look up the short name, which is really a Python variable. It will then use the associated Character to show the dialogue."
    e "Quand cette déclaration est exécutée, Ren’Py cherchera le nom court, qui est en fait une variable Python. Il utilisera alors le Character associé pour afficher le dialogue."

# game/tutorial_quickstart.rpy:194
translate french tutorial_dialogue_d5984a21:

    # e "The Character object controls who is speaking, the color of their name, and many other properties of the dialogue."
    e "L’objet Character contrôle qui parle, la couleur de son nom et de nombreuses autres propriétés de dialogue."

# game/tutorial_quickstart.rpy:198
translate french tutorial_dialogue_a5bcac8b:

    # e "Since the bulk of a visual novel is dialogue, we've tried to make it as easy to write as possible."
    e "Comme l’essence des romans visuel est le dialogue, nous avons essayé de les rendre aussi simple que possible à écrire."

# game/tutorial_quickstart.rpy:200
translate french tutorial_dialogue_6b9a42d0:

    # e "Hopefully, by allowing the use of short names for characters, we've succeeded."
    e "En autorisant l’utilisation des noms courts pour les personnages, nous avons réussi."

# game/tutorial_quickstart.rpy:206
translate french tutorial_images_e09ac970:

    # e "A visual novel isn't much without images. So let's add some images to our little game."
    e "Un roman visuel ne serait rien sans images. Alors, ajoutons quelques images à notre petit jeu !"

# game/tutorial_quickstart.rpy:208
translate french tutorial_images_40140793:

    # e "Before we can show images, we must first choose image names, then place the image files into the images directory."
    e "Avant de pouvoir afficher des images, nous devons d’abord choisir des noms d’images puis placer les fichiers dans le répertoire image."

# game/tutorial_quickstart.rpy:210
translate french tutorial_images_d73388f8:

    # e "An image name is something like 'bg cave' or 'lucy happy', with one or more parts separated by spaces."
    e "Une image, c’est quelque chose comme 'bg cave' ou 'lucy happy', avec une ou plusieurs parties séparées par des espaces."

# game/tutorial_quickstart.rpy:212
translate french tutorial_images_2d5596d4:

    # e "Each part should start with a lower-case letter, and then contain lower-case letters, numbers, and underscores."
    e "Chacune des parties doit commencer par une lettre minuscule et ensuite ne contenir que des lettres minuscules, des nombres et des underscores _ ."

# game/tutorial_quickstart.rpy:214
translate french tutorial_images_e02c0c82:

    # e "The first part of an image is called the tag. For 'bg cave' the tag is 'bg', while for 'lucy happy' the tag is 'lucy'."
    e "La première partie de l’image est appelée une étiquette, un tag. Pour 'bg cave' c’est 'bg', pour 'lucy happy' l’étiquette, le tag, c’est 'lucy'."

# game/tutorial_quickstart.rpy:216
translate french tutorial_images_d5eafcf2:

    # e "You can open the images directory by clicking the appropriate button in the Ren'Py launcher."
    e "Vous pouvez ouvrir le répertoire 'images' en cliquant sur le bouton 'images' dans le lanceur Ren’Py."

# game/tutorial_quickstart.rpy:218
translate french tutorial_images_e4b12fb6:

    # e "The files in the images directory should have the same name as the image, followed by an extension like .jpg, .png, or .webp."
    e "Les fichiers dans le répertoire 'images' doivent avoir le même nom que l’image, suivi d’une extension comme .jpg, .png ou .webp."

# game/tutorial_quickstart.rpy:220
translate french tutorial_images_a3bd89b2:

    # e "Our example uses 'bg cave.jpg', 'lucy happy.png', and 'lucy mad.png'."
    e "Notre exemple utilise 'bg cave.jpg', 'lucy happy.png' et 'lucy mad.png'."

# game/tutorial_quickstart.rpy:224
translate french tutorial_images_76b954de:

    # e "Let's see what those look like in the game."
    e "Regardons à quoi cela ressemble dans notre jeu."

# game/tutorial_quickstart.rpy:230
translate french tutorial_images_f04e72ea:

    # l "Now that the lights are on, we don't have to worry about Grues anymore."
    l "Maintenant que les lumières sont allumées, nous n’avons plus à nous préoccuper des Grues."

# game/tutorial_quickstart.rpy:234
translate french tutorial_images_d77ffa1c:

    # l "But what's the deal with me being in a cave? Eileen gets to be out in the sun, and I'm stuck here!"
    l "Mais pourquoi est-ce que je suis dans une cave ? Eileen est sous le soleil et, moi, je me sens mal ici !"

# game/tutorial_quickstart.rpy:242
translate french tutorial_images_6c0c938b:

    # e "Here's the script for that scene. Notice how it includes two new statements, the scene and show statement."
    e "Voici le script pour cette scène. Remarquez comment sont inclus les deux nouvelles déclarations, les déclarations 'scene' et 'show'."

# game/tutorial_quickstart.rpy:244
translate french tutorial_images_1a4660b9:

    # e "The scene statement clears the screen, and then adds a background image."
    e "La déclaration 'scene' vide l’écran et ajoute une image d’arrière-plan."

# game/tutorial_quickstart.rpy:246
translate french tutorial_images_672c8cb8:

    # e "The show statement adds a background image on top of all the other images on the screen."
    e "La déclaration 'show' ajoute une image au dessus de toutes les images déjà à l’écran."

# game/tutorial_quickstart.rpy:248
translate french tutorial_images_2fc7baee:

    # e "If there was already an image with the same tag, the new image is used to replace the old one."
    e "S’il y avait déjà une image avec la même étiquette, le même tag, une nouvelle image remplacerait l’ancienne."

# game/tutorial_quickstart.rpy:250
translate french tutorial_images_802825f2:

    # e "Changes to the list of shown images take place instantly, so in the example, the user won't see the background by itself."
    e "Les changements sur la liste des images affichées prend place instantanément. Alors, dans notre exemple, l’utilisateur ne verra pas l’arrière-plan seul."

# game/tutorial_quickstart.rpy:252
translate french tutorial_images_b246dfdd:

    # e "The second show statement has an at clause, which gives a location on the screen. Common locations are left, right, and center, but you can define many more."
    e "La seconde déclaration 'show' a une clause 'at', celle-ci donne la position de l’image à l’écran. Les localisations communes sont 'left' (à gauche), 'right' (à droite) et 'center' (au centre), mais vous pouvez en définir d’autres."

# game/tutorial_quickstart.rpy:257
translate french tutorial_images_82fceeb8:

    # e "In this example, we show an image named logo base, and we show it at a creator-defined position, rightish."
    e "Dans cet exemple, nous affichons une image nommée 'logo base' et nous l’affichons à un emplacement défini par le créateur : rightish."

# game/tutorial_quickstart.rpy:259
translate french tutorial_images_9defda43:

    # e "We also specify that it should be shown behind another image, in this case eileen. That's me."
    e "Nous spécifions aussi qu'elle doit être affichée derrière (behind) une autre image, dans ce cas précis derrière 'eileen'. Eileen, c’est moi."

# game/tutorial_quickstart.rpy:264
translate french tutorial_images_73d331f7:

    # e "Finally, there's the hide statement, which hides the image with the given tag."
    e "Enfin, il y a une déclaration 'hide' qui cache l’image dont on fournit l’étiquette, le tag."

# game/tutorial_quickstart.rpy:266
translate french tutorial_images_f34f62d5:

    # e "Since the show statement replaces an image, and the scene statement clears the scene, it's pretty rare to hide an image."
    e "Elle le restera jusqu’à ce qu'une déclaration 'show' remplace l’image ou qu’une déclaration 'scene' vide l'écran. C’est plutôt rare de cacher une image."

# game/tutorial_quickstart.rpy:268
translate french tutorial_images_e06fa53a:

    # e "The main use is for when a character or prop leaves before the scene is over."
    e "On utilise principalement cette déclaration 'hide' pour faire disparaître un personnage avant que la scène ne soit terminée."

# game/tutorial_quickstart.rpy:282
translate french tutorial_simple_positions_b492e793:

    # e "When the standard positions that come with Ren'Py aren't enough for you, you can create your own. Here, I'll show you the easy way to do it."
    e "Quand les positions standards qui viennent avec Ren’Py ne suffisent pas, vous pouvez créer les vôtres. Je vais vous montrer une méthode simple pour le faire."

# game/tutorial_quickstart.rpy:291
translate french tutorial_simple_positions_04e3bc44:

    # e "The first way to do it is to show an image followed by a colon. Then indented on the next couple of lines are the xalign and yalign transform properties."
    e "La première façon de le faire est d’afficher l’image suivie de deux points (:). Ensuite, après une indentation, sur les lignes suivantes on va renseigner les propriétés des transformations xalign et y align."

# game/tutorial_quickstart.rpy:293
translate french tutorial_simple_positions_3ecad5f8:

    # e "Each of the transform properties is a name followed by a value. For xalign and yalign, the values are numbers."
    e "Pour chaque propriété des transformations, le nom est suivi par une valeur. Pour 'xalign' et 'yalign', les valeurs attendues sont des nombres."

# game/tutorial_quickstart.rpy:295
translate french tutorial_simple_positions_61c1b124:

    # e "The xalign transform property is the important one, as it controls where the image is placed horizontally on the screen."
    e "La valeur 'xalign' est celle qui est importante, car elle contrôle où l’image sera positionnée horizantalement."

# game/tutorial_quickstart.rpy:305
translate french tutorial_simple_positions_67ebea97:

    # e "An xalign of 0.0 is the left side."
    e "Pour 'xalign', une valeur de 0.0 signifie à gauche."

# game/tutorial_quickstart.rpy:315
translate french tutorial_simple_positions_bd4f56d8:

    # e "0.5 is the center."
    e "0.5 correspond au centre."

# game/tutorial_quickstart.rpy:324
translate french tutorial_simple_positions_fb2c48f2:

    # e "And 1.0 is the right. The decimal place is important and has to be there. Just 1 by itself won't work the same."
    e "Et 1.0 est à la droite de l’écran. La décimale après la virgule est importante et doit être présente. Une valeur de 1 ne donnera pas le même résultat."

# game/tutorial_quickstart.rpy:333
translate french tutorial_simple_positions_8eebc9a7:

    # e "Of course, you can pick any position in between."
    e "Bien sûr, vous pouvez choisir n’importe quelle position entre ces valeurs."

# game/tutorial_quickstart.rpy:335
translate french tutorial_simple_positions_4cd917f6:

    # e "The yalign property is the same way, with 0.0 being the top of the screen and 1.0 being the bottom. Since most sprites stick to the bottom, it's almost always 1.0."
    e "La propriété 'yalign' fonctionne de la même façon, avec 0.0 pour le haut de l’écran et 1.0 pour le bas. Comme la plupart des sprites sont positionnés en bas, cette propriété prend souvent la valeur 1.0."

# game/tutorial_quickstart.rpy:341
translate french tutorial_simple_positions_fbd1a3eb:

    # e "While being able to write positions like this is useful, having to repeatedly do so isn't. So Ren'Py lets you define a transform once, and reuse it."
    e "Même si avoir la possibilité de noter les positions de cette façon est pratique, le faire de façon répétitive ne l’est pas. Ren’Py vous permet de définir donc une transformation et de la réutiliser."

# game/tutorial_quickstart.rpy:345
translate french tutorial_simple_positions_2377e3b3:

    # e "Usually transforms are defined at the top of a file, right after the characters. But it doesn't matter to Ren'Py where you define them."
    e "Habituellement les transformations sont définies au début du fichier, juste après les personnages, mais l’endroit où vous les définissez n’a pas vraiment d’importance."

# game/tutorial_quickstart.rpy:347
translate french tutorial_simple_positions_3ce7e367:

    # e "The transform is given a name, slightleft, and then the xalign and yalign properties."
    e "La transformation est définie par un nom 'slightleft' et ensuite par les propriétés 'xalign' et 'yalign'."

# game/tutorial_quickstart.rpy:355
translate french tutorial_simple_positions_82d640d9:

    # e "Once a transform has been defined, you can use it in the at clause of the show statement."
    e "Une fois la transformation définie, vous pouvez l’utiliser grâce à la clause 'at' de la déclaration 'show'."

# game/tutorial_quickstart.rpy:360
translate french tutorial_simple_positions_16b66785:

    # e "Transforms are sticky. If you replace an image without using a transform, Ren'Py will keep the same transforms it had been using."
    e "Les transformations sont mémorisées. Si vous remplacez une image sans utiliser de transformation, Ren’Py gardera la même transformation que celle qui avait été utilisée initialement."

# game/tutorial_quickstart.rpy:364
translate french tutorial_simple_positions_5d5e0cfd:

    # e "Of course, there's a lot more to transforms than this. If you want to learn more, you can read the sections on Position Properties, Transforms and Animation, and Transform Properties."
    e "Bien sûr, il y a beaucoup plus de transformations que celles-ci. Si vous souhaitez en apprendre d’autres, vous pouvez lire les sections « Position Properties », « Transforms and Animation » et « Transform Properties » de la documentation."

# game/tutorial_quickstart.rpy:366
translate french tutorial_simple_positions_e65da9bf:

    # e "But for many visual novels, xalign and yalign are the only properties that matter."
    e "Mais pour la plupart des romans visules, les propriétés 'xalign' et 'yalign' sont les seules propriétés qui importent."

# game/tutorial_quickstart.rpy:381
translate french tutorial_transitions_9b8c714c:

    # e "It can be somewhat jarring for the game to jump from place to place."
    e "Cela peut être quelque peu gênant pour le jeu de sauter soudainement d’un endroit à l’autre."

# game/tutorial_quickstart.rpy:388
translate french tutorial_transitions_3e290ea8:

    # e "To help take some of edge off a change in scene, Ren'Py supports the use of transitions. Let's try that scene change again, but this time we'll use transitions."
    e "Pour aider à ce que la scène ne change pas brutalement, Ren’Py supporte des transitions. Essayons de modifier la scène à nouveau, mais cette fois, nous utiliserons des transitions."

# game/tutorial_quickstart.rpy:402
translate french tutorial_transitions_9c0a86c4:

    # e "That's much smoother. Here's some example code showing how we include transitions in our game."
    e "C'est beaucoup plus lisse. Voici un exemple de code montrant comment nous incluons des transitions dans notre jeu."

# game/tutorial_quickstart.rpy:404
translate french tutorial_transitions_3e490d40:

    # e "It uses the with statement. The with statement causes the scene to transition from the last things shown to the things currently being shown."
    e "Nous utilisons la déclaration 'with'. La déclaration 'with' provoque une transition de la dernière chose affichée vers celle actuellement affichée."

# game/tutorial_quickstart.rpy:406
translate french tutorial_transitions_a43847df:

    # e "It takes a transition as an argument. In this case, we're using the Dissolve transition. This transition takes as an argument the amount of time the dissolve should take."
    e "La transition est prise comme argument. Dans ce cas, nous utilisons la transition 'Dissolve'. Cette transition prend en argument le temps pour dissoudre l’image."

# game/tutorial_quickstart.rpy:408
translate french tutorial_transitions_6fcee414:

    # e "In this case, each transition takes half a second."
    e "Dans ce cas, chaque transition dure une demie seconde."

# game/tutorial_quickstart.rpy:412
translate french tutorial_transitions_033042cc:

    # e "We can define a short name for a transition, using the define statement. Here, we're defining slowdissolve to be a dissolve that takes a whole second."
    e "Nous pouvons définir un nom court pour la transition en utilisant la déclaration 'define'. Ici, nous avons défini 'slowdissolve' pour être une dissolution qui prend une seconde complète."

# game/tutorial_quickstart.rpy:427
translate french tutorial_transitions_0ba82f00:

    # e "Once a transition has been given a short name, we can use it in our game."
    e "Une fois que nous avons donné un nom à la transtion, nous pouvons l’utiliser dans notre jeu."

# game/tutorial_quickstart.rpy:431
translate french tutorial_transitions_51ff9600:

    # e "Ren'Py defines some transitions for you, like dissolve, fade, and move. For more complex or customized transitions, you'll have to define your own."
    e "Ren’Py prédéfinit quelques transitions pour vous, comme la dissolution (dissolve), le fondu (fade) et le déplacement (move). Pour des transitions plus complexes ou personnalisées, vous aurez à les définir vous-même."

# game/tutorial_quickstart.rpy:433
translate french tutorial_transitions_1528f73f:

    # e "If you're interested, check out the Transitions Gallery section of this tutorial."
    e "Si vous voulez en savoir plus, regardez la section « galerie de transition » de ce tutoriel."

# game/tutorial_quickstart.rpy:439
translate french tutorial_music_8b92efb7:

    # e "Another important part of a visual novel or simulation game is the soundtrack."
    e "La bande-son est une autre partie importante des romans visuels ou des jeux de simulation."

# game/tutorial_quickstart.rpy:441
translate french tutorial_music_53910317:

    # e "Ren'Py breaks sound up into channels. The channel a sound is played on determines if the sound loops, and if it is saved and restored with the game."
    e "Ren’Py sépare les sons dans des canaux (channel). Le canal dans lequel est joué un son détermine si le son est répété en boucle et s’il est sauvegardé et restauré avec le jeu."

# game/tutorial_quickstart.rpy:443
translate french tutorial_music_a1e37712:

    # e "When a sound is played on the music channel, it is looped, and it is saved when the game is saved."
    e "Quand un son est joué sur le canal 'music' (musique), il est joué en boucle et il est sauvegardé avec le jeu."

# game/tutorial_quickstart.rpy:445
translate french tutorial_music_d9086d22:

    # e "When the channel named sound is used, the sound is played once and then stopped. It isn't saved."
    e "Quand un son est joué sur le canal 'sound' (effet sonore), il est joué une seule fois avant d’être stoppé. Il n’est pas sauvegardé."

# game/tutorial_quickstart.rpy:447
translate french tutorial_music_3555b640:

    # e "The sounds themselves are stored in audio files. Ren'Py supports the Opus, Ogg Vorbis, and mp3 formats."
    e "Les sons sont stockés dans des fichiers sons. Ren’Py supporte les formats Opus, Ogg Vorbis et mp3."

# game/tutorial_quickstart.rpy:449
translate french tutorial_music_a776b6ad:

    # e "Let's check out some of the commands that can effect the music channel."
    e "Regardons ensemble quelques commandes qui affectent le canal musical (music channel)."

# game/tutorial_quickstart.rpy:454
translate french tutorial_music_8b606a55:

    # e "The play music command replaces the currently playing music, and replaces it with the named filename."
    e "La commande 'play music' remplace la musique actuellement jouée par celle dont le nom de fichier a été précisé."

# game/tutorial_quickstart.rpy:456
translate french tutorial_music_18650fe7:

    # e "If you specify the currently-playing song, it will restart it."
    e "Si vous spécifiez une musique en train d’être jouée, elle repartira depuis le début."

# game/tutorial_quickstart.rpy:458
translate french tutorial_music_413d91fc:

    # e "If the optional fadeout clause is given, it will fade out the currently playing music before starting the new music."
    e "Si la clause optionnelle 'fadeout' est donnée, alors la nouvelle musique remplacera la précédente avec un fondu."

# game/tutorial_quickstart.rpy:463
translate french tutorial_music_a282a0e3:

    # e "The queue statement also adds music to the named channel, but it waits until the currently-playing song is finished before playing the new music."
    e "La déclaration 'queue' ajoute une musique au canal musical, mais elle attendra que la musique en cours soit terminée avant de jouer la nouvelle."

# game/tutorial_quickstart.rpy:468
translate french tutorial_music_01ca6bad:

    # e "The third statement is the stop statement. It stops the music playing on a channel. It too takes the fadeout clause."
    e "La troisième déclaration est un 'stop'. Elle stoppe la musique en cours sur le canal. La déclaration comprend aussi la clause 'fadeout'."

# game/tutorial_quickstart.rpy:473
translate french tutorial_music_384937da:

    # e "Unlike the music channel, playing a sound on the sound channel causes it to play only once."
    e "Contrairement au canal 'music', un son exécuté sur le canal sound n’est joué qu’une seule fois."

# game/tutorial_quickstart.rpy:480
translate french tutorial_music_1d3e9fd2:

    # e "You can queue up multiple sounds on the sound channel, but the sounds will only play one at a time."
    e "Vous pouvez empiler plusieurs sons sur le canal 'sound', mais chaque son sera joué l’un après l’autre."

# game/tutorial_quickstart.rpy:486
translate french tutorial_music_aa01c19d:

    # e "Ren'Py has separate mixers for sound, music, and voices, so the player can adjust them as they like."
    e "Ren’Py a séparé des mixeurs « sound », « music » et « voices », alors le joueur peut ajuster leur volume comme il le veut."

# game/tutorial_quickstart.rpy:492
translate french tutorial_menus_0426904b:

    # e "Many visual novels require the player to make choices from in-game menus. These choices can add some challenge to the game, or adjust it to the player's preferences."
    e "Beaucoup de romans visuels demandent au joueur de faire des choix durant la partie. Ces choix peuvent ajouter quelque challenge à la partie ou ajuster les préférences du joueur."

# game/tutorial_quickstart.rpy:494
translate french tutorial_menus_431eeff0:

    # e "Do you like to play visual novels with choices in them?"
    e "Est-ce que vous aimez jouer à des romans visuels avec des choix en leur sein ?"

# game/tutorial_quickstart.rpy:509
translate french choice1_yes_f6d95df8:

    # e "While creating a multi-path visual novel can be a bit more work, it can yield a unique experience."
    e "Créer un roman visuel avec plusieurs cheminements possibles demande un peu plus de travail, cela crée une expérience unique."

# game/tutorial_quickstart.rpy:517
translate french choice1_no_72958b50:

    # e "Games without menus are called kinetic novels, and there are dozens of them available to play."
    e "Les jeux sans choix sont des romans kinétiques et des douzaines sont prêts à jouer."

# game/tutorial_quickstart.rpy:528
translate french choice1_done_acba9504:

    # e "Here, you can see the code for that menu. If you scroll down, you can see the code we run after the menu."
    e "Ici, vous pouvez voir le code d’un menu de choix. Si vous faites défiler l’écran, vous pourrez voir le code après le menu."

# game/tutorial_quickstart.rpy:530
translate french choice1_done_f9fa6889:

    # e "Menus are introduced by the menu statement. The menu statement takes an indented block, in which there can be one line of dialogue and multiple choices."
    e "Les menus sont introduits par la déclaration 'menu'. Cette déclaration 'menu' prend un bloc d’indentation dans lequel on pourra placer une ligne de dialogue et des choix multiples."

# game/tutorial_quickstart.rpy:532
translate french choice1_done_ebb2db38:

    # e "Each choice must end with a colon, as each choice has its own block of Ren'Py code, that is run when that choice is selected."
    e "Chaque choix se termine par deux points (:). Comme chaque choix à son propre bloc de code Ren’Py, c'est le bloc indenté qui est exécuté pour le choix sélectionné."

# game/tutorial_quickstart.rpy:534
translate french choice1_done_59cac95d:

    # e "Here, each block jumps to a label. While you could put small amounts of Ren'Py code inside a menu label, it's probably good practice to usually jump to a bigger block of code."
    e "Ici chaque bloc effectue un saut vers un label. Même si vous pouvez placer un ensemble de code Ren’Py dans un label, c’est probablement une bonne pratique de faire un saut quand il s’agit d’un bloc de code plus important."

# game/tutorial_quickstart.rpy:536
translate french choice1_done_2851a313:

    # e "Scrolling down past the menu, you can see the labels that the menu jumps to. There are three labels here, named choice1_yes, choice1_no, and choice1_done."
    e "En déroulant le menu, vous pourrez voir les labels où le menu renvoie. Il y a trois label, nommé 'choice1_yes', 'choice1_no' et 'choice1_done'."

# game/tutorial_quickstart.rpy:538
translate french choice1_done_ff761b03:

    # e "When the first menu choice is picked, we jump to the choice1_yes, which runs two lines of script before jumping to choice1_done."
    e "Quand le premier choix du menu est sélectionné, nous sautons au label 'choice1_yes' qui éxecute deux lignes de script avant de sauter au label 'choice1_done'."

# game/tutorial_quickstart.rpy:540
translate french choice1_done_664fe702:

    # e "Similarly, picking the second choice jumps us to choice1_no, which also runs two lines of script."
    e "De façon similaire, choisir le second choix du menu renvoie au label 'choice1_no' qui exécute deux autres lignes de codes."

# game/tutorial_quickstart.rpy:542
translate french choice1_done_31d12b1e:

    # e "The lines beginning with the dollar sign are lines of python code, which are used to set a flag based on the user's choice."
    e "Les lignes qui commencent par un symbole dollar sont des lignes de code en python qui sont utilisées pour initialiser une variable basée sur le choix du joueur."

# game/tutorial_quickstart.rpy:544
translate french choice1_done_88398d3e:

    # e "The flag is named menu_flag, and it's set to True or False based on the user's choice. The if statement can be used to test a flag, so the game can remember the user's choices."
    e "Cette variable est nommée 'menu_flag' et est initialisée à True ou False, selon le choix du joueur. La déclaration 'if' peut être utilisée pour tester cette variable, ainsi le jeu peut se souvenir du choix du joueur."

# game/tutorial_quickstart.rpy:549
translate french choice1_done_2828dbfc:

    # e "For example, I remember that you plan to use menus in your game."
    e "Par exemple, je me souviens que vous envisagez d’utiliser les menus dans votre jeu."

# game/tutorial_quickstart.rpy:553
translate french choice1_done_503786e4:

    # e "For example, I remember that you're planning to make a kinetic novel, without menus."
    e "Par exemple, je me souviens que vous envisagez de réaliser un roman sans menu."

# game/tutorial_quickstart.rpy:555
translate french choice1_done_819e234a:

    # e "Here's an example that shows how we can test a flag, and do different things if it is true or not."
    e "Ici, vous avez un exemple qui montre comment nous pouvons tester une variable et faire différentes choses selon que sa valeur soit à vrai ou à faux."

# game/tutorial_quickstart.rpy:559
translate french choice1_done_461e6a59:

    # e "Finally, this shows how you can show dialogue and menus at the same time. Understand?" nointeract
    e "Enfin, ceci montre comment vous pouvez afficher un dialogue et des menus en même temps. Compris ?" nointeract

# game/tutorial_quickstart.rpy:564
translate french choice1_done_a32e30fd:

    # e "Great."
    e "Bien."

# game/tutorial_quickstart.rpy:568
translate french choice1_done_fbd1dbc1:

    # e "If you look at the example, before the first choice, there's an indented say statement."
    e "Si vous regardez l’exemple, avant le premier choix, il y a une déclaration indentée de dialogue."

# game/tutorial_quickstart.rpy:574
translate french menu3_done_47fa2268:

    # e "Although we won't demonstrate it here, Ren'Py supports making decisions based on a combinations of points, flags, and other factors."
    e "Même si nous n’en ferons pas la démonstration ici, Ren’Py permet de prendre des décisions basées sur une combinaison de points, de flags et d’autres facteurs."

# game/tutorial_quickstart.rpy:576
translate french menu3_done_826a600b:

    # e "One of Ren'Py's big advantages is the flexibility using a scripting language like Python provides us. It lets us easily scale from kinetic novels to complex simulation games."
    e "La fléxibilité est l’un des gros avantages de Ren’Py, elle est apportée par le langage de script Python. Il nous permet de transformer facilement un roman kinétique en un jeu de simulation complexe."

# game/tutorial_quickstart.rpy:585
translate french tutorial_input_066611c5:

    # e "Some games might prompt the player for input."
    e "Certains jeux peuvent demander au joueur de renseigner une information."

# game/tutorial_quickstart.rpy:599
translate french tutorial_input_dc3b4560:

    # e "That's done with Python, and especially the renpy.input function. The first line of this example prompts the player for some texts, and sticks it in the name variable."
    e "C’est réalisé avec Python, plus précisément avec la fonction 'renpy.input'. La première ligne de cet exemple demande au joueur de renseigner du texte et rattache le contenu au nom de la variable."

# game/tutorial_quickstart.rpy:601
translate french tutorial_input_c88b3f4e:

    # e "Often times, you'll want to clean the name up before you use it. The last line does that, by calling the strip method to remove whitespace, and replacing the name with a default if it's missing."
    e "Dans la plupart des cas, vous allez vouloir nettoyer le nom qui vous a été fourni avant de l’utiliser. La dernière ligne de code fait cela en appelant la méthode 'strip' pour retirer les espaces superflus et remplacer le nom par une valeur par défaut si le joueur n’a rien voulu renseigner."

# game/tutorial_quickstart.rpy:605
translate french tutorial_input_1236e9da:

    # e "To interpolate a variable, write it in square brackets. Isn't that right, [name]?"
    e "Pour interpoler une variable, écrivez son nom entre crochets. N’est-ce pas, [name] ?"

# game/tutorial_quickstart.rpy:609
translate french tutorial_input_c1f7a808:

    # e "Variable names can also be shown in character names. To do that, just include the variable in square brackets in the character's name. Got it?"
    e "Les noms de variables peuvent également être affichés comme noms de personnages. Pour faire cela, incluez simplement la variable entre des crochets dans le nom du personnage. Compris ?"

# game/tutorial_quickstart.rpy:612
translate french tutorial_input_f7757a8e:

    # g "I think I do."
    g "Je pense que j’ai compris."

# game/tutorial_quickstart.rpy:619
translate french tutorial_input_0548d3e2:

    # e "Variable interpolation also works with other variables. Here, the answer is [answer] and the flag is [flag]."
    e "L’interpolation de variable fonctionne aussi avec d’autres variables. Ici la réponse est [answer] et la variable flag vaut [flag]."

translate french strings:

    # tutorial_quickstart.rpy:2
    old "Lucy"
    new "Lucy"

    # tutorial_quickstart.rpy:497
    old "Yes, I do."
    new "Oui."

    # tutorial_quickstart.rpy:497
    old "No, I don't."
    new "Non."

    # tutorial_quickstart.rpy:589
    old "What's your name?"
    new "Quel est votre nom ?"

    # tutorial_quickstart.rpy:591
    old "Guy Shy"
    new "Homme timide"
