/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import java.io.Serializable;
import sbt.internal.librarymanagement.CompatibilityWarning$;
import sbt.internal.librarymanagement.CompatibilityWarningOptions;
import sbt.io.IO$;
import sbt.librarymanagement.DependencyResolution;
import sbt.librarymanagement.EvictionWarning;
import sbt.librarymanagement.EvictionWarning$;
import sbt.librarymanagement.EvictionWarningOptions;
import sbt.librarymanagement.GetClassifiersConfiguration;
import sbt.librarymanagement.LibraryManagementCodec$;
import sbt.librarymanagement.LogicalClock$;
import sbt.librarymanagement.ModuleDescriptor;
import sbt.librarymanagement.ModuleID;
import sbt.librarymanagement.ModuleID$;
import sbt.librarymanagement.ModuleSettings;
import sbt.librarymanagement.UnresolvedWarning;
import sbt.librarymanagement.UnresolvedWarning$;
import sbt.librarymanagement.UnresolvedWarningConfiguration;
import sbt.librarymanagement.UpdateConfiguration;
import sbt.librarymanagement.UpdateReport;
import sbt.librarymanagement.syntax$;
import sbt.util.CacheStore;
import sbt.util.CacheStoreFactory;
import sbt.util.Logger;
import sbt.util.ShowLines$;
import sbt.util.SingletonCache$;
import sbt.util.Tracked$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception$;
import sjsonnew.JsonFormat;

public final class LibraryManagement$ {
    public static LibraryManagement$ MODULE$;

    static {
        new LibraryManagement$();
    }

    public UpdateReport cachedUpdate(DependencyResolution lm, ModuleDescriptor module, CacheStoreFactory cacheStoreFactory, String label, UpdateConfiguration updateConfig, Function1<UpdateReport, UpdateReport> transform, boolean skip, boolean force, boolean depsUpdated, UnresolvedWarningConfiguration uwConfig, EvictionWarningOptions ewo, boolean mavenStyle, CompatibilityWarningOptions compatWarning, Logger log) {
        long extraInputHash = module.extraInputHash();
        ModuleSettings settings = module.moduleSettings();
        CacheStore outStore = cacheStoreFactory.make("output");
        Function1 handler = skip && !force ? LibraryManagement$.skipResolve$1(outStore) : this.doResolve$1(outStore, lm, module, cacheStoreFactory, label, updateConfig, transform, force, depsUpdated, uwConfig, ewo, mavenStyle, compatWarning, log);
        UpdateConfiguration withoutClock = updateConfig.withLogicalClock(LogicalClock$.MODULE$.unknown());
        return (UpdateReport)handler.apply((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)extraInputHash), (Object)settings, (Object)withoutClock));
    }

    private boolean fileUptodate(File file, Map<File, Object> stamps) {
        return stamps.get((Object)file).forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$5 -> x$5 == IO$.MODULE$.getModifiedTimeOrZero(file));
    }

    public Either<UnresolvedWarning, UpdateReport> transitiveScratch(DependencyResolution lm, String label, GetClassifiersConfiguration config, UnresolvedWarningConfiguration uwconfig, Logger log) {
        UpdateReport r;
        ModuleID base = this.restrictedCopy(config.module().id(), true).withName(config.module().id().name() + "$" + label);
        ModuleDescriptor module = lm.moduleDescriptor(base, config.module().dependencies(), config.module().scalaModuleInfo());
        Either either = lm.update(module, config.updateConfiguration(), uwconfig, log);
        if (!(either instanceof Right)) {
            if (either instanceof Left) {
                Left left = (Left)either;
                UnresolvedWarning w = (UnresolvedWarning)left.value();
                throw w.resolveException();
            }
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        UpdateReport updateReport = r = (UpdateReport)right.value();
        UpdateReport report = updateReport;
        GetClassifiersConfiguration newConfig = config.withModule(config.module().withDependencies(report.allModules()));
        return lm.updateClassifiers(newConfig, uwconfig, (Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$), log);
    }

    public ModuleID restrictedCopy(ModuleID m, boolean confs) {
        return ModuleID$.MODULE$.apply(m.organization(), m.name(), m.revision()).withCrossVersion(m.crossVersion()).withExtraAttributes(m.extraAttributes()).withConfigurations((Option)(confs ? m.configurations() : None$.MODULE$)).branch(m.branchName());
    }

    private static final UpdateReport resolve$1(Tuple3 inputs, DependencyResolution lm$1, ModuleDescriptor module$1, String label$1, UpdateConfiguration updateConfig$1, Function1 transform$1, UnresolvedWarningConfiguration uwConfig$1, EvictionWarningOptions ewo$1, boolean mavenStyle$1, CompatibilityWarningOptions compatWarning$1, Logger log$1) {
        UpdateReport report0;
        Either reportOrUnresolved;
        log$1.info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating ", "..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{label$1})));
        Either either = reportOrUnresolved = lm$1.update(module$1, updateConfig$1, uwConfig$1, log$1);
        if (!(either instanceof Right)) {
            if (either instanceof Left) {
                Left left = (Left)either;
                UnresolvedWarning unresolvedWarning = (UnresolvedWarning)left.value();
                ShowLines$.MODULE$.ShowLinesOp((Object)unresolvedWarning, UnresolvedWarning$.MODULE$.unresolvedWarningLines()).lines().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    log$1.warn((Function0 & Serializable & scala.Serializable)() -> x$1);
                    return BoxedUnit.UNIT;
                });
                throw unresolvedWarning.resolveException();
            }
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        UpdateReport updateReport = report0 = (UpdateReport)right.value();
        UpdateReport report = updateReport;
        log$1.info((Function0 & Serializable & scala.Serializable)() -> "Done updating.");
        UpdateReport finalReport = (UpdateReport)transform$1.apply((Object)report);
        EvictionWarning ew = EvictionWarning$.MODULE$.apply(module$1, ewo$1, finalReport, log$1);
        ShowLines$.MODULE$.ShowLinesOp((Object)ew, EvictionWarning$.MODULE$.evictionWarningLines()).lines().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            log$1.warn((Function0 & Serializable & scala.Serializable)() -> x$2);
            return BoxedUnit.UNIT;
        });
        ew.infoAllTheThings().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            log$1.info((Function0 & Serializable & scala.Serializable)() -> x$3);
            return BoxedUnit.UNIT;
        });
        CompatibilityWarning$.MODULE$.run(compatWarning$1, module$1, mavenStyle$1, log$1);
        return finalReport;
    }

    private final boolean upToDate$1(boolean inChanged, UpdateReport out, boolean force$1, boolean depsUpdated$1) {
        return !force$1 && !depsUpdated$1 && !inChanged && syntax$.MODULE$.richUpdateReport(out).allFiles().forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LibraryManagement$.MODULE$.fileUptodate(f, (Map<File, Object>)out.stamps()))) && this.fileUptodate(out.cachedDescriptor(), (Map<File, Object>)out.stamps());
    }

    private static final Function1 skipResolve$1(CacheStore cache) {
        return Tracked$.MODULE$.lastOutput(cache, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Option option;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null || !((option = (Option)tuple2._2()) instanceof Some)) {
                throw scala.sys.package$.MODULE$.error("Skipping update requested, but update has not previously run successfully.");
            }
            Some some = (Some)option;
            UpdateReport out = (UpdateReport)some.value();
            UpdateReport updateReport = LibraryManagement$.markAsCached$1(out);
            return updateReport;
        }, LibraryManagementCodec$.MODULE$.UpdateReportFormat());
    }

    private static final UpdateReport markAsCached$1(UpdateReport ur) {
        return ur.withStats(ur.stats().withCached(true));
    }

    public static final /* synthetic */ UpdateReport $anonfun$cachedUpdate$11(LibraryManagement$ $this, DependencyResolution lm$1, ModuleDescriptor module$1, String label$1, UpdateConfiguration updateConfig$1, Function1 transform$1, boolean force$1, boolean depsUpdated$1, UnresolvedWarningConfiguration uwConfig$1, EvictionWarningOptions ewo$1, boolean mavenStyle$1, CompatibilityWarningOptions compatWarning$1, Logger log$1, CacheStore cache$1, boolean inChanged, Tuple3 updateInputs) {
        Function1 cachedResolve = Tracked$.MODULE$.lastOutput(cache$1, (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            Some some;
            UpdateReport out;
            Option option;
            Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
            UpdateReport updateReport = tuple2 != null && (option = (Option)tuple2._2()) instanceof Some && $this.upToDate$1(inChanged, out = (UpdateReport)(some = (Some)option).value(), force$1, depsUpdated$1) ? LibraryManagement$.markAsCached$1(out) : LibraryManagement$.resolve$1(updateInputs, lm$1, module$1, label$1, updateConfig$1, transform$1, uwConfig$1, ewo$1, mavenStyle$1, compatWarning$1, log$1);
            return updateReport;
        }, LibraryManagementCodec$.MODULE$.UpdateReportFormat());
        return (UpdateReport)Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{NullPointerException.class, OutOfMemoryError.class})).withApply((Function1 & Serializable & scala.Serializable)t -> {
            UpdateReport resolvedAgain = LibraryManagement$.resolve$1(updateInputs, lm$1, module$1, label$1, updateConfig$1, transform$1, uwConfig$1, ewo$1, mavenStyle$1, compatWarning$1, log$1);
            String culprit = t.getClass().getSimpleName();
            log$1.warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Update task caching failed due to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{culprit})));
            log$1.warn((Function0 & Serializable & scala.Serializable)() -> "Report the following output to sbt:");
            new StringOps(Predef$.MODULE$.augmentString(resolvedAgain.toString())).lines().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                log$1.warn((Function0 & Serializable & scala.Serializable)() -> x$4);
                return BoxedUnit.UNIT;
            });
            log$1.trace((Function0 & Serializable & scala.Serializable)() -> t);
            return resolvedAgain;
        }).apply((Function0 & Serializable & scala.Serializable)() -> (UpdateReport)cachedResolve.apply((Object)updateInputs));
    }

    private final Function1 doResolve$1(CacheStore cache, DependencyResolution lm$1, ModuleDescriptor module$1, CacheStoreFactory cacheStoreFactory$1, String label$1, UpdateConfiguration updateConfig$1, Function1 transform$1, boolean force$1, boolean depsUpdated$1, UnresolvedWarningConfiguration uwConfig$1, EvictionWarningOptions ewo$1, boolean mavenStyle$1, CompatibilityWarningOptions compatWarning$1, Logger log$1) {
        Function2 & Serializable & scala.Serializable doCachedResolve = (Function2 & Serializable & scala.Serializable)(inChanged, updateInputs) -> LibraryManagement$.$anonfun$cachedUpdate$11(this, lm$1, module$1, label$1, updateConfig$1, transform$1, force$1, depsUpdated$1, uwConfig$1, ewo$1, mavenStyle$1, compatWarning$1, log$1, cache, BoxesRunTime.unboxToBoolean((Object)inChanged), updateInputs);
        return Tracked$.MODULE$.inputChanged(cacheStoreFactory$1.make("inputs"), (Function2)doCachedResolve, LibraryManagementCodec$.MODULE$.tuple3Format((JsonFormat)LibraryManagementCodec$.MODULE$.LongJsonFormat(), LibraryManagementCodec$.MODULE$.ModuleSettingsFormat(), LibraryManagementCodec$.MODULE$.UpdateConfigurationFormat()), SingletonCache$.MODULE$.basicSingletonCache(LibraryManagementCodec$.MODULE$.tuple3Format((JsonFormat)LibraryManagementCodec$.MODULE$.LongJsonFormat(), LibraryManagementCodec$.MODULE$.ModuleSettingsFormat(), LibraryManagementCodec$.MODULE$.UpdateConfigurationFormat())));
    }

    private LibraryManagement$() {
        MODULE$ = this;
    }
}

