/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.cached;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.FileAnalysisStore$;
import sbt.internal.inc.JavaInterfaceUtil$;
import sbt.internal.inc.Stamper$;
import sbt.internal.inc.Stamps;
import sbt.internal.inc.Stamps$;
import sbt.internal.inc.cached.CleanClasses$;
import sbt.internal.inc.cached.CleanOutput$;
import sbt.internal.inc.cached.CleanOutputMode;
import sbt.internal.inc.cached.CompilationCache;
import sbt.internal.inc.cached.ExportableCache$;
import sbt.internal.inc.cached.FailOnNonEmpty$;
import sbt.io.FileFilter;
import sbt.io.FileFilter$;
import sbt.io.IO$;
import sbt.io.NameFilter;
import sbt.io.PathFinder;
import sbt.io.PathFinder$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import xsbti.compile.AnalysisContents;
import xsbti.compile.AnalysisStore;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.MiniSetup;
import xsbti.compile.Output;
import xsbti.compile.SingleOutput;
import xsbti.compile.analysis.ReadWriteMappers;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0001\u0003\u0001-\u0011q\"\u0012=q_J$\u0018M\u00197f\u0007\u0006\u001c\u0007.\u001a\u0006\u0003\u0007\u0011\taaY1dQ\u0016$'BA\u0003\u0007\u0003\rIgn\u0019\u0006\u0003\u000f!\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0002\u0013\u0005\u00191O\u0019;\u0004\u0001M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\t\u0019B#D\u0001\u0003\u0013\t)\"A\u0001\tD_6\u0004\u0018\u000e\\1uS>t7)Y2iK\"Aq\u0003\u0001BC\u0002\u0013\u0005\u0001$A\u0007dC\u000eDW\rT8dCRLwN\\\u000b\u00023A\u0011!$I\u0007\u00027)\u0011A$H\u0001\u0005M&dWM\u0003\u0002\u001f?\u0005\u0019a.[8\u000b\u0003\u0001\nAA[1wC&\u0011!e\u0007\u0002\u0005!\u0006$\b\u000e\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\u001a\u00039\u0019\u0017m\u00195f\u0019>\u001c\u0017\r^5p]\u0002B\u0001B\n\u0001\u0003\u0002\u0003\u0006IaJ\u0001\u0010G2,\u0017M\\(viB,H/T8eKB\u00111\u0003K\u0005\u0003S\t\u0011qb\u00117fC:|U\u000f\u001e9vi6{G-\u001a\u0005\u0006W\u0001!\t\u0001L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00075rs\u0006\u0005\u0002\u0014\u0001!)qC\u000ba\u00013!9aE\u000bI\u0001\u0002\u00049\u0003bB\u0019\u0001\u0005\u0004%\t\u0001G\u0001\rC:\fG._:jg\u001aKG.\u001a\u0005\u0007g\u0001\u0001\u000b\u0011B\r\u0002\u001b\u0005t\u0017\r\\=tSN4\u0015\u000e\\3!\u0011\u001d)\u0004A1A\u0005\u0002a\tab\u00197bgN,7OW5q\r&dW\r\u0003\u00048\u0001\u0001\u0006I!G\u0001\u0010G2\f7o]3t5&\u0004h)\u001b7fA!)\u0011\b\u0001C\tu\u0005aq.\u001e;qkR$\u0015N\u001d$peR\u00111(\u0011\t\u0003y}j\u0011!\u0010\u0006\u0003}}\t!![8\n\u0005\u0001k$\u0001\u0002$jY\u0016DQA\u0011\u001dA\u0002\r\u000bQa]3ukB\u0004\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\u000f\r|W\u000e]5mK*\t\u0001*A\u0003yg\n$\u0018.\u0003\u0002K\u000b\nIQ*\u001b8j'\u0016$X\u000f\u001d\u0005\u0006\u0019\u0002!\t%T\u0001\nY>\fGmQ1dQ\u0016$\"AT,\u0011\u00075y\u0015+\u0003\u0002Q\u001d\t1q\n\u001d;j_:\u0004B!\u0004*U\u0007&\u00111K\u0004\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005\u0011+\u0016B\u0001,F\u0005=\u0019u.\u001c9jY\u0016\fe.\u00197zg&\u001c\b\"\u0002-L\u0001\u0004Y\u0014a\u00049s_*,7\r\u001e'pG\u0006$\u0018n\u001c8\t\u000bi\u0003A\u0011B.\u0002?U\u0004H-\u0019;f'R\fW\u000e]:G_JLU\u000e]8si\u0016$\u0007K]8ek\u000e$8\u000fF\u0002]A\n\u0004\"!\u00180\u000e\u0003\u0011I!a\u0018\u0003\u0003\u0011\u0005s\u0017\r\\=tSNDQ!Y-A\u0002q\u000b\u0001\"\u00198bYf\u001c\u0018n\u001d\u0005\u0006Gf\u0003\r\u0001Z\u0001\u000eS6\u0004xN\u001d;fI\u001aKG.Z:\u0011\u0007\u0015d7H\u0004\u0002gUB\u0011qMD\u0007\u0002Q*\u0011\u0011NC\u0001\u0007yI|w\u000e\u001e \n\u0005-t\u0011A\u0002)sK\u0012,g-\u0003\u0002n]\n\u00191+\u001a;\u000b\u0005-t\u0001\"\u00029\u0001\t\u0003\t\u0018aC3ya>\u0014HoQ1dQ\u0016$2A\u001d<x!\riqj\u001d\t\u0003\u001bQL!!\u001e\b\u0003\tUs\u0017\u000e\u001e\u0005\u00061>\u0004\ra\u000f\u0005\u0006q>\u0004\r!_\u0001\u0015GV\u0014(/\u001a8u\u0003:\fG._:jgN#xN]3\u0011\u0005\u0011S\u0018BA>F\u00055\te.\u00197zg&\u001c8\u000b^8sK\")Q\u0010\u0001C\t}\u0006Y1\r\\3b]>+H\u000f];u)\t\u0019x\u0010\u0003\u0004\u0002\u0002q\u0004\raO\u0001\u0007_V$\b/\u001e;\t\u000f\u0005\u0015\u0001\u0001\"\u0005\u0002\b\u0005\t\u0012.\u001c9peR\u0014\u0015N\\1ss\u000e\u000b7\r[3\u0015\u000b\u0011\fI!!\u0004\t\u000f\u0005-\u00111\u0001a\u00019\u0006Ya.Z<B]\u0006d\u0017p]5t\u0011\u001d\ty!a\u0001A\u0002\r\u000b\u0001B\\3x'\u0016$X\u000f\u001d\u0005\b\u0003'\u0001A\u0011CA\u000b\u0003E)\u0007\u0010]8si\nKg.\u0019:z\u0007\u0006\u001c\u0007.\u001a\u000b\u0006g\u0006]\u00111\u0004\u0005\b\u00033\t\t\u00021\u0001]\u0003=\u0019WO\u001d:f]R\fe.\u00197zg&\u001c\bbBA\u000f\u0003#\u0001\raQ\u0001\rGV\u0014(/\u001a8u'\u0016$X\u000f]\u0004\n\u0003C\u0011\u0011\u0011!E\u0001\u0003G\tq\"\u0012=q_J$\u0018M\u00197f\u0007\u0006\u001c\u0007.\u001a\t\u0004'\u0005\u0015b\u0001C\u0001\u0003\u0003\u0003E\t!a\n\u0014\u0007\u0005\u0015B\u0002C\u0004,\u0003K!\t!a\u000b\u0015\u0005\u0005\r\u0002BCA\u0018\u0003K\t\n\u0011\"\u0001\u00022\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!a\r+\u0007\u001d\n)d\u000b\u0002\u00028A!\u0011\u0011HA\"\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012!C;oG\",7m[3e\u0015\r\t\tED\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA#\u0003w\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ExportableCache
implements CompilationCache {
    private final Path cacheLocation;
    private final CleanOutputMode cleanOutputMode;
    private final Path analysisFile;
    private final Path classesZipFile;

    public static CleanOutputMode $lessinit$greater$default$2() {
        return ExportableCache$.MODULE$.$lessinit$greater$default$2();
    }

    public Path cacheLocation() {
        return this.cacheLocation;
    }

    public Path analysisFile() {
        return this.analysisFile;
    }

    public Path classesZipFile() {
        return this.classesZipFile;
    }

    public File outputDirFor(MiniSetup setup) {
        Output output = setup.output();
        if (!(output instanceof SingleOutput)) {
            throw new RuntimeException("Only single output is supported");
        }
        SingleOutput singleOutput = (SingleOutput)output;
        File file = singleOutput.getOutputDirectory();
        return file;
    }

    @Override
    public Option<Tuple2<CompileAnalysis, MiniSetup>> loadCache(File projectLocation) {
        ReadWriteMappers mappers = ReadWriteMappers.getMachineIndependentMappers(projectLocation.toPath());
        AnalysisStore store = FileAnalysisStore$.MODULE$.binary(this.analysisFile().toFile(), mappers);
        return JavaInterfaceUtil$.MODULE$.EnrichOptional(store.get()).toOption().map((Function1 & Serializable & scala.Serializable)analysisContents -> {
            Analysis newAnalysis = (Analysis)analysisContents.getAnalysis();
            MiniSetup newSetup = analysisContents.getMiniSetup();
            Set<File> importedClassFiles = this.importBinaryCache(newAnalysis, newSetup);
            Analysis analysisForLocalProducts = this.updateStampsForImportedProducts(newAnalysis, importedClassFiles);
            return new Tuple2((Object)analysisForLocalProducts, (Object)newSetup);
        });
    }

    private Analysis updateStampsForImportedProducts(Analysis analysis, Set<File> importedFiles) {
        Stamps oldStamps = analysis.stamps();
        Map updatedProducts = (Map)oldStamps.products().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            File file;
            Tuple2 tuple2 = x0$1;
            Tuple2 tuple22 = tuple2 != null && importedFiles.contains((Object)(file = (File)tuple2._1())) ? new Tuple2((Object)file, Stamper$.MODULE$.forLastModified().apply((Object)file)) : tuple2;
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        Stamps newStamps = Stamps$.MODULE$.apply(updatedProducts, oldStamps.sources(), oldStamps.binaries());
        return analysis.copy(newStamps, analysis.copy$default$2(), analysis.copy$default$3(), analysis.copy$default$4(), analysis.copy$default$5());
    }

    public Option<BoxedUnit> exportCache(File projectLocation, AnalysisStore currentAnalysisStore) {
        return JavaInterfaceUtil$.MODULE$.EnrichOptional(currentAnalysisStore.get()).toOption().map((Function1 & Serializable & scala.Serializable)analysisContents -> {
            ExportableCache.$anonfun$exportCache$1(this, projectLocation, analysisContents);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cleanOutput(File output) {
        if (!output.exists()) return;
        if (!output.isDirectory()) throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output file: ", " is not a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{output})));
        CleanOutputMode cleanOutputMode = this.cleanOutputMode;
        if (CleanOutput$.MODULE$.equals(cleanOutputMode)) {
            BoxedUnit boxedUnit;
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])output.list())).nonEmpty()) {
                IO$.MODULE$.delete(output);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return;
        } else if (FailOnNonEmpty$.MODULE$.equals(cleanOutputMode)) {
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])output.list())).nonEmpty()) {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output directory: ", " is not empty and cleanOutput is false"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{output})));
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else {
            if (!CleanClasses$.MODULE$.equals(cleanOutputMode)) throw new MatchError((Object)cleanOutputMode);
            PathFinder classFiles = PathFinder$.MODULE$.apply(output).$times$times((FileFilter)FileFilter$.MODULE$.globFilter("*.class"));
            IO$.MODULE$.delete((Iterable)classFiles.get());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Set<File> importBinaryCache(Analysis newAnalysis, MiniSetup newSetup) {
        File output = this.outputDirFor(newSetup);
        this.cleanOutput(output);
        File x$2 = this.classesZipFile().toFile();
        File x$3 = output;
        boolean x$4 = true;
        NameFilter x$5 = IO$.MODULE$.unzip$default$3();
        return IO$.MODULE$.unzip(x$2, x$3, x$5, x$4);
    }

    public void exportBinaryCache(Analysis currentAnalysis, MiniSetup currentSetup) {
        Path out = this.outputDirFor(currentSetup).toPath();
        List entries = (List)ExportableCache.files$1(out.toFile()).map((Function1 & Serializable & scala.Serializable)classFile -> {
            String mapping = ((Object)out.relativize(classFile.toPath())).toString();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(classFile), (Object)mapping);
        }, List$.MODULE$.canBuildFrom());
        IO$.MODULE$.zip((Traversable)entries, this.classesZipFile().toFile());
    }

    public static final /* synthetic */ void $anonfun$exportCache$1(ExportableCache $this, File projectLocation$1, AnalysisContents analysisContents) {
        Analysis currentAnalysis = (Analysis)analysisContents.getAnalysis();
        MiniSetup currentSetup = analysisContents.getMiniSetup();
        ReadWriteMappers mappers = ReadWriteMappers.getMachineIndependentMappers(projectLocation$1.toPath());
        AnalysisStore remoteStore = FileAnalysisStore$.MODULE$.binary($this.analysisFile().toFile(), mappers);
        $this.exportBinaryCache(currentAnalysis, currentSetup);
        AnalysisContents contents = AnalysisContents.create((CompileAnalysis)currentAnalysis, (MiniSetup)currentSetup);
        remoteStore.set(contents);
    }

    private static final List files$1(File f2) {
        File file = f2;
        return ((List)(f2.isDirectory() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])IO$.MODULE$.listFiles(f2))).toList().flatMap((Function1 & Serializable & scala.Serializable)f -> ExportableCache.files$1(f), List$.MODULE$.canBuildFrom()) : Nil$.MODULE$)).$colon$colon((Object)file);
    }

    public ExportableCache(Path cacheLocation, CleanOutputMode cleanOutputMode) {
        this.cacheLocation = cacheLocation;
        this.cleanOutputMode = cleanOutputMode;
        this.analysisFile = cacheLocation.resolve("analysis.zip");
        this.classesZipFile = cacheLocation.resolve("classes.zip");
    }
}

