/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EndpointInfo;
import Ice.EndpointParseException;
import Ice.InputStream;
import Ice.OutputStream;
import Ice.TCPEndpointInfo;
import IceInternal.Acceptor;
import IceInternal.Connector;
import IceInternal.EndpointI;
import IceInternal.HashUtil;
import IceInternal.IPEndpointI;
import IceInternal.NetworkProxy;
import IceInternal.ProtocolInstance;
import IceInternal.TcpAcceptor;
import IceInternal.TcpConnector;
import IceInternal.Transceiver;
import java.net.InetSocketAddress;

final class TcpEndpointI
extends IPEndpointI {
    private int _timeout;
    private boolean _compress;

    public TcpEndpointI(ProtocolInstance instance, String ho, int po, InetSocketAddress sourceAddr, int ti, String conId, boolean co) {
        super(instance, ho, po, sourceAddr, conId);
        this._timeout = ti;
        this._compress = co;
    }

    public TcpEndpointI(ProtocolInstance instance) {
        super(instance);
        this._timeout = this._instance.defaultTimeout();
        this._compress = false;
    }

    public TcpEndpointI(ProtocolInstance instance, InputStream s) {
        super(instance, s);
        this._timeout = s.readInt();
        this._compress = s.readBool();
    }

    @Override
    public EndpointInfo getInfo() {
        TCPEndpointInfo info = new TCPEndpointInfo(){

            @Override
            public short type() {
                return TcpEndpointI.this.type();
            }

            @Override
            public boolean datagram() {
                return TcpEndpointI.this.datagram();
            }

            @Override
            public boolean secure() {
                return TcpEndpointI.this.secure();
            }
        };
        this.fillEndpointInfo(info);
        return info;
    }

    @Override
    public int timeout() {
        return this._timeout;
    }

    @Override
    public EndpointI timeout(int timeout) {
        if (timeout == this._timeout) {
            return this;
        }
        return new TcpEndpointI(this._instance, this._host, this._port, this._sourceAddr, timeout, this._connectionId, this._compress);
    }

    @Override
    public boolean compress() {
        return this._compress;
    }

    @Override
    public EndpointI compress(boolean compress) {
        if (compress == this._compress) {
            return this;
        }
        return new TcpEndpointI(this._instance, this._host, this._port, this._sourceAddr, this._timeout, this._connectionId, compress);
    }

    @Override
    public boolean datagram() {
        return false;
    }

    @Override
    public Transceiver transceiver() {
        return null;
    }

    @Override
    public Acceptor acceptor(String adapterName) {
        return new TcpAcceptor(this, this._instance, this._host, this._port);
    }

    public TcpEndpointI endpoint(TcpAcceptor acceptor) {
        int port = acceptor.effectivePort();
        if (port == this._port) {
            return this;
        }
        return new TcpEndpointI(this._instance, this._host, port, this._sourceAddr, this._timeout, this._connectionId, this._compress);
    }

    @Override
    public String options() {
        String s = super.options();
        s = this._timeout == -1 ? s + " -t infinite" : s + " -t " + this._timeout;
        if (this._compress) {
            s = s + " -z";
        }
        return s;
    }

    @Override
    public int compareTo(EndpointI obj) {
        if (!(obj instanceof TcpEndpointI)) {
            return this.type() < obj.type() ? -1 : 1;
        }
        TcpEndpointI p = (TcpEndpointI)obj;
        if (this == p) {
            return 0;
        }
        if (this._timeout < p._timeout) {
            return -1;
        }
        if (p._timeout < this._timeout) {
            return 1;
        }
        if (!this._compress && p._compress) {
            return -1;
        }
        if (!p._compress && this._compress) {
            return 1;
        }
        return super.compareTo(obj);
    }

    @Override
    public void streamWriteImpl(OutputStream s) {
        super.streamWriteImpl(s);
        s.writeInt(this._timeout);
        s.writeBool(this._compress);
    }

    @Override
    public int hashInit(int h) {
        h = super.hashInit(h);
        h = HashUtil.hashAdd(h, this._timeout);
        h = HashUtil.hashAdd(h, this._compress);
        return h;
    }

    @Override
    protected boolean checkOption(String option, String argument, String endpoint) {
        if (super.checkOption(option, argument, endpoint)) {
            return true;
        }
        switch (option.charAt(1)) {
            case 't': {
                if (argument == null) {
                    throw new EndpointParseException("no argument provided for -t option in endpoint " + endpoint);
                }
                if (argument.equals("infinite")) {
                    this._timeout = -1;
                } else {
                    try {
                        this._timeout = Integer.parseInt(argument);
                        if (this._timeout < 1) {
                            throw new EndpointParseException("invalid timeout value `" + argument + "' in endpoint " + endpoint);
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new EndpointParseException("invalid timeout value `" + argument + "' in endpoint " + endpoint);
                    }
                }
                return true;
            }
            case 'z': {
                if (argument != null) {
                    throw new EndpointParseException("unexpected argument `" + argument + "' provided for -z option in " + endpoint);
                }
                this._compress = true;
                return true;
            }
        }
        return false;
    }

    @Override
    protected Connector createConnector(InetSocketAddress addr, NetworkProxy proxy) {
        return new TcpConnector(this._instance, addr, proxy, this._sourceAddr, this._timeout, this._connectionId);
    }

    @Override
    protected IPEndpointI createEndpoint(String host, int port, String connectionId) {
        return new TcpEndpointI(this._instance, host, port, this._sourceAddr, this._timeout, connectionId, this._compress);
    }
}

