/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.track;

import com.google.earth.kml._2.KmlType;
import com.topografix.gpx._1._0.Gpx;
import java.io.File;
import java.io.InputStream;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.fibs.geotag.track.GpxReader;
import org.fibs.geotag.track.KmlTransformer;
import org.fibs.geotag.track.KmlWriter;
import org.fibs.geotag.track.TrackStoreTest;

public class KmlTest
extends TestCase {
    private Gpx gpx;

    protected void setUp() throws Exception {
        InputStream stream = TrackStoreTest.class.getClassLoader().getResourceAsStream("all.gpx");
        KmlTest.assertNotNull((Object)stream);
        this.gpx = GpxReader.read(stream);
        stream.close();
        KmlTest.assertNotNull((Object)this.gpx);
    }

    public void testKml() {
        KmlTest.assertNotNull((Object)this.gpx);
        KmlType kml = new KmlTransformer().transform(this.gpx);
        KmlTest.assertNotNull((Object)kml);
        try {
            System.out.println();
            File file = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "tracksall.kml");
            System.out.println(file.getPath());
            new KmlWriter().write(this.gpx, file);
        }
        catch (Exception e) {
            throw new AssertionFailedError();
        }
    }
}

