/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.javadoc;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.javadoc.internal.JavadocSpec;
import org.gradle.external.javadoc.MinimalJavadocOptions;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;
import org.gradle.jvm.internal.toolchain.JavaToolChainInternal;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.platform.base.Platform;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

@CacheableTask
public class Javadoc
extends SourceTask {
    private File destinationDir;
    private boolean failOnError = true;
    private String title;
    private String maxMemory;
    private final StandardJavadocDocletOptions options = new StandardJavadocDocletOptions();
    private FileCollection classpath = this.getProject().files(new Object[0]);
    private String executable;

    @TaskAction
    protected void generate() {
        String maxMemory;
        File destinationDir = this.getDestinationDir();
        StandardJavadocDocletOptions options = new StandardJavadocDocletOptions((StandardJavadocDocletOptions)this.getOptions());
        if (options.getDestinationDirectory() == null) {
            options.destinationDirectory(destinationDir);
        }
        options.classpath(new ArrayList<File>(this.getClasspath().getFiles()));
        if (!GUtil.isTrue((Object)options.getWindowTitle()) && GUtil.isTrue((Object)this.getTitle())) {
            options.windowTitle(this.getTitle());
        }
        if (!GUtil.isTrue((Object)options.getDocTitle()) && GUtil.isTrue((Object)this.getTitle())) {
            options.setDocTitle(this.getTitle());
        }
        if ((maxMemory = this.getMaxMemory()) != null) {
            List<String> jFlags = options.getJFlags();
            Iterator<String> jFlagsIt = jFlags.iterator();
            boolean containsXmx = false;
            while (!containsXmx && jFlagsIt.hasNext()) {
                String jFlag = jFlagsIt.next();
                if (!jFlag.startsWith("-Xmx")) continue;
                containsXmx = true;
            }
            if (!containsXmx) {
                options.jFlags("-Xmx" + maxMemory);
            }
        }
        ArrayList<String> sourceNames = new ArrayList<String>();
        for (File sourceFile : this.getSource()) {
            sourceNames.add(sourceFile.getAbsolutePath());
        }
        options.setSourceNames(sourceNames);
        this.executeExternalJavadoc(options);
    }

    private void executeExternalJavadoc(StandardJavadocDocletOptions options) {
        JavadocSpec spec = new JavadocSpec();
        spec.setExecutable(this.getExecutable());
        spec.setOptions(options);
        spec.setIgnoreFailures(!this.isFailOnError());
        spec.setWorkingDir(this.getProject().getProjectDir());
        spec.setOptionsFile(this.getOptionsFile());
        Compiler generator = ((JavaToolChainInternal)this.getToolChain()).select((Platform)this.getPlatform()).newCompiler(JavadocSpec.class);
        generator.execute((CompileSpec)spec);
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @Incubating
    @Inject
    public JavaToolChain getToolChain() {
        throw new UnsupportedOperationException();
    }

    @Incubating
    public void setToolChain(JavaToolChain toolChain) {
        throw new UnsupportedOperationException();
    }

    private JavaPlatform getPlatform() {
        return DefaultJavaPlatform.current();
    }

    @Internal
    @Nullable
    public File getDestinationDir() {
        return this.destinationDir;
    }

    @OutputDirectory
    protected File getOutputDirectory() {
        File destinationDir = this.getDestinationDir();
        if (destinationDir == null) {
            destinationDir = this.options.getDestinationDirectory();
        }
        return destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    @Internal
    @Nullable
    public String getMaxMemory() {
        return this.maxMemory;
    }

    public void setMaxMemory(String maxMemory) {
        this.maxMemory = maxMemory;
    }

    @Nullable
    @Optional
    @Input
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @Internal
    public boolean isVerbose() {
        return this.options.isVerbose();
    }

    public void setVerbose(boolean verbose) {
        if (verbose) {
            this.options.verbose();
        }
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Nested
    public MinimalJavadocOptions getOptions() {
        return this.options;
    }

    public void options(Closure<?> block) {
        ConfigureUtil.configure(block, (Object)this.getOptions());
    }

    public void options(Action<? super MinimalJavadocOptions> action) {
        action.execute((Object)this.getOptions());
    }

    @Input
    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Internal
    public File getOptionsFile() {
        return new File(this.getTemporaryDir(), "javadoc.options");
    }

    @Nullable
    @Optional
    @Input
    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(@Nullable String executable) {
        this.executable = executable;
    }
}

