/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.jvm.JvmTypeDeclaration;
import org.jetbrains.kotlin.com.intellij.lang.jvm.types.JvmReferenceType;
import org.jetbrains.kotlin.com.intellij.lang.jvm.types.JvmSubstitutor;
import org.jetbrains.kotlin.com.intellij.lang.jvm.types.JvmType;
import org.jetbrains.kotlin.com.intellij.lang.jvm.types.JvmTypeResolveResult;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJvmSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayFactory;

public abstract class PsiClassType
extends PsiType
implements JvmReferenceType {
    public static final PsiClassType[] EMPTY_ARRAY = new PsiClassType[0];
    public static final ArrayFactory<PsiClassType> ARRAY_FACTORY = count2 -> count2 == 0 ? EMPTY_ARRAY : new PsiClassType[count2];
    protected final LanguageLevel myLanguageLevel;

    protected PsiClassType(LanguageLevel languageLevel) {
        this(languageLevel, PsiAnnotation.EMPTY_ARRAY);
    }

    protected PsiClassType(LanguageLevel languageLevel, @NotNull PsiAnnotation[] annotations2) {
        if (annotations2 == null) {
            PsiClassType.$$$reportNull$$$0(0);
        }
        super(annotations2);
        this.myLanguageLevel = languageLevel;
    }

    public PsiClassType(LanguageLevel languageLevel, @NotNull TypeAnnotationProvider provider) {
        if (provider == null) {
            PsiClassType.$$$reportNull$$$0(1);
        }
        super(provider);
        this.myLanguageLevel = languageLevel;
    }

    @Override
    @NotNull
    public PsiClassType annotate(@NotNull TypeAnnotationProvider provider) {
        if (provider == null) {
            PsiClassType.$$$reportNull$$$0(2);
        }
        PsiClassType psiClassType = (PsiClassType)super.annotate(provider);
        if (psiClassType == null) {
            PsiClassType.$$$reportNull$$$0(3);
        }
        return psiClassType;
    }

    @Nullable
    public abstract PsiClass resolve();

    public abstract String getClassName();

    @NotNull
    public abstract PsiType[] getParameters();

    public int getParameterCount() {
        return this.getParameters().length;
    }

    public boolean equals(Object obj) {
        ClassResolveResult otherResult;
        String otherClassName;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PsiClassType)) {
            return obj instanceof PsiCapturedWildcardType && ((PsiCapturedWildcardType)obj).getLowerBound().equalsToText("java.lang.Object") && this.equalsToText("java.lang.Object");
        }
        PsiClassType otherClassType = (PsiClassType)obj;
        String className2 = this.getClassName();
        if (!Comparing.equal(className2, otherClassName = otherClassType.getClassName())) {
            return false;
        }
        if (this.getParameterCount() != otherClassType.getParameterCount()) {
            return false;
        }
        ClassResolveResult result2 = this.resolveGenerics();
        if (result2 == (otherResult = otherClassType.resolveGenerics())) {
            return true;
        }
        PsiClass aClass2 = result2.getElement();
        PsiClass otherClass = otherResult.getElement();
        if (aClass2 == null || otherClass == null) {
            return aClass2 == otherClass;
        }
        return aClass2.getManager().areElementsEquivalent(aClass2, otherClass) && (PsiUtil.isRawSubstitutor(aClass2, result2.getSubstitutor()) || PsiUtil.equalOnEquivalentClasses(this, aClass2, otherClassType, otherClass));
    }

    public boolean hasParameters() {
        ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass aClass2 = resolveResult.getElement();
        if (aClass2 == null) {
            return false;
        }
        boolean hasParams = false;
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aClass2)) {
            if (resolveResult.getSubstitutor().substitute(parameter) == null) {
                return false;
            }
            hasParams = true;
        }
        return hasParams;
    }

    public boolean hasNonTrivialParameters() {
        ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass aClass2 = resolveResult.getElement();
        if (aClass2 == null) {
            return false;
        }
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aClass2)) {
            PsiClass superClass;
            PsiType type2 = resolveResult.getSubstitutor().substitute(parameter);
            if (type2 == null) continue;
            if (!(type2 instanceof PsiWildcardType)) {
                return true;
            }
            PsiType bound = ((PsiWildcardType)type2).getBound();
            if (bound == null || ((PsiWildcardType)type2).isExtends() && (superClass = parameter.getSuperClass()) != null && PsiUtil.resolveClassInType(bound) == superClass) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        String className2 = this.getClassName();
        if (className2 == null) {
            return 0;
        }
        return className2.hashCode();
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass aClass2 = resolveResult.getElement();
        if (aClass2 == null) {
            if (EMPTY_ARRAY == null) {
                PsiClassType.$$$reportNull$$$0(4);
            }
            return EMPTY_ARRAY;
        }
        PsiClassType[] superTypes2 = aClass2.getSuperTypes();
        PsiType[] substitutionResults = PsiClassType.createArray(superTypes2.length);
        for (int i = 0; i < superTypes2.length; ++i) {
            substitutionResults[i] = resolveResult.getSubstitutor().substitute(superTypes2[i]);
        }
        if (substitutionResults == null) {
            PsiClassType.$$$reportNull$$$0(5);
        }
        return substitutionResults;
    }

    public static boolean isRaw(ClassResolveResult resolveResult) {
        PsiClass psiClass = resolveResult.getElement();
        return psiClass != null && PsiUtil.isRawSubstitutor(psiClass, resolveResult.getSubstitutor());
    }

    public boolean isRaw() {
        return PsiClassType.isRaw(this.resolveGenerics());
    }

    @NotNull
    public abstract ClassResolveResult resolveGenerics();

    @NotNull
    public abstract PsiClassType rawType();

    @Override
    @NotNull
    public abstract GlobalSearchScope getResolveScope();

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            PsiClassType.$$$reportNull$$$0(6);
        }
        return visitor2.visitClassType(this);
    }

    @NotNull
    public abstract LanguageLevel getLanguageLevel();

    @NotNull
    @Contract(pure=true)
    public abstract PsiClassType setLanguageLevel(@NotNull LanguageLevel var1);

    @NotNull
    public String getName() {
        String string = this.getClassName();
        if (string == null) {
            PsiClassType.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public JvmTypeResolveResult resolveType() {
        final ClassResolveResult resolveResult = this.resolveGenerics();
        final PsiClass clazz = resolveResult.getElement();
        return clazz == null ? null : new JvmTypeResolveResult(){
            private final JvmSubstitutor mySubstitutor;
            {
                this.mySubstitutor = new PsiJvmSubstitutor(clazz.getProject(), resolveResult.getSubstitutor());
            }

            @NotNull
            public JvmTypeDeclaration getDeclaration() {
                PsiClass psiClass = clazz;
                if (psiClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiClass;
            }

            @NotNull
            public JvmSubstitutor getSubstitutor() {
                JvmSubstitutor jvmSubstitutor = this.mySubstitutor;
                if (jvmSubstitutor == null) {
                    1.$$$reportNull$$$0(1);
                }
                return jvmSubstitutor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/kotlin/com/intellij/psi/PsiClassType$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubstitutor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    public Iterable<JvmType> typeArguments() {
        List<JvmType> list2 = Arrays.asList(this.getParameters());
        if (list2 == null) {
            PsiClassType.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/PsiClassType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/PsiClassType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "typeArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Stub
    extends PsiClassType {
        protected Stub(LanguageLevel languageLevel, @NotNull PsiAnnotation[] annotations2) {
            if (annotations2 == null) {
                Stub.$$$reportNull$$$0(0);
            }
            super(languageLevel, annotations2);
        }

        protected Stub(LanguageLevel languageLevel, @NotNull TypeAnnotationProvider annotations2) {
            if (annotations2 == null) {
                Stub.$$$reportNull$$$0(1);
            }
            super(languageLevel, annotations2);
        }

        @Override
        @NotNull
        public final String getPresentableText() {
            String string = this.getPresentableText(false);
            if (string == null) {
                Stub.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public abstract String getPresentableText(boolean var1);

        @Override
        @NotNull
        public final String getCanonicalText() {
            String string = this.getCanonicalText(false);
            if (string == null) {
                Stub.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public abstract String getCanonicalText(boolean var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotations";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/PsiClassType$Stub";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/PsiClassType$Stub";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ClassResolveResult
    extends JavaResolveResult {
        public static final ClassResolveResult EMPTY = new ClassResolveResult(){

            @Override
            public PsiClass getElement() {
                return null;
            }

            @Override
            @NotNull
            public PsiSubstitutor getSubstitutor() {
                PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
                if (psiSubstitutor == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiSubstitutor;
            }

            @Override
            public boolean isValidResult() {
                return false;
            }

            @Override
            public boolean isAccessible() {
                return false;
            }

            @Override
            public boolean isStaticsScopeCorrect() {
                return false;
            }

            @Override
            public PsiElement getCurrentFileResolveScope() {
                return null;
            }

            @Override
            public boolean isPackagePrefixPackageReference() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiClassType$ClassResolveResult$1", "getSubstitutor"));
            }
        };

        @Override
        public PsiClass getElement();
    }
}

