/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.RuleMatchListener;
import org.languagetool.UserConfig;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class MultiThreadedJLanguageTool
extends JLanguageTool {
    private final int threadPoolSize;
    private final ExecutorService threadPool;

    public MultiThreadedJLanguageTool(Language language) {
        this(language, null);
    }

    public MultiThreadedJLanguageTool(Language language, int threadPoolSize) {
        this(language, null, threadPoolSize, null);
    }

    public MultiThreadedJLanguageTool(Language language, Language motherTongue) {
        this(language, motherTongue, MultiThreadedJLanguageTool.getDefaultThreadCount(), null);
    }

    public MultiThreadedJLanguageTool(Language language, Language motherTongue, UserConfig userConfig) {
        this(language, motherTongue, MultiThreadedJLanguageTool.getDefaultThreadCount(), userConfig);
    }

    public MultiThreadedJLanguageTool(Language language, Language motherTongue, int threadPoolSize, UserConfig userConfig) {
        super(language, motherTongue, null, userConfig);
        this.threadPoolSize = threadPoolSize;
        this.threadPool = Executors.newFixedThreadPool(this.getThreadPoolSize(), new DaemonThreadFactory());
    }

    public void shutdown() {
        this.threadPool.shutdownNow();
    }

    public void shutdownWhenDone() {
        this.threadPool.shutdown();
    }

    private static int getDefaultThreadCount() {
        String threadCountStr = System.getProperty("org.languagetool.thread_count_internal", "-1");
        int threadPoolSize = Integer.parseInt(threadCountStr);
        if (threadPoolSize == -1) {
            threadPoolSize = Runtime.getRuntime().availableProcessors();
        }
        return threadPoolSize;
    }

    protected int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    protected ExecutorService getExecutorService() {
        return this.threadPool;
    }

    @Override
    protected List<AnalyzedSentence> analyzeSentences(List<String> sentences) throws IOException {
        ArrayList<AnalyzedSentence> analyzedSentences = new ArrayList<AnalyzedSentence>();
        ExecutorService executorService = this.getExecutorService();
        int j = 0;
        ArrayList<AnalyzeSentenceCallable> callables = new ArrayList<AnalyzeSentenceCallable>();
        for (String sentence : sentences) {
            AnalyzeSentenceCallable analyzeSentenceCallable = ++j < sentences.size() ? new AnalyzeSentenceCallable(sentence) : new ParagraphEndAnalyzeSentenceCallable(sentence);
            callables.add(analyzeSentenceCallable);
        }
        try {
            List futures = executorService.invokeAll(callables);
            for (Future future : futures) {
                AnalyzedSentence analyzedSentence = (AnalyzedSentence)future.get();
                this.rememberUnknownWords(analyzedSentence);
                this.printSentenceInfo(analyzedSentence);
                analyzedSentences.add(analyzedSentence);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return analyzedSentences;
    }

    @Override
    protected List<RuleMatch> performCheck(List<AnalyzedSentence> analyzedSentences, List<String> sentences, List<Rule> allRules, JLanguageTool.ParagraphHandling paraMode, AnnotatedText annotatedText, RuleMatchListener listener) throws IOException {
        int charCount = 0;
        int lineCount = 0;
        int columnCount = 1;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        ExecutorService executorService = this.getExecutorService();
        try {
            List<Callable<List<RuleMatch>>> callables = this.createTextCheckCallables(paraMode, annotatedText, analyzedSentences, sentences, allRules, charCount, lineCount, columnCount, listener);
            List<Future<List<RuleMatch>>> futures = executorService.invokeAll(callables);
            for (Future<List<RuleMatch>> future : futures) {
                ruleMatches.addAll((Collection<RuleMatch>)future.get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return ruleMatches;
    }

    private List<Callable<List<RuleMatch>>> createTextCheckCallables(JLanguageTool.ParagraphHandling paraMode, AnnotatedText annotatedText, List<AnalyzedSentence> analyzedSentences, List<String> sentences, List<Rule> allRules, int charCount, int lineCount, int columnCount, RuleMatchListener listener) {
        int threads = this.getThreadPoolSize();
        int totalRules = allRules.size();
        int chunkSize = totalRules / threads;
        int firstItem = 0;
        ArrayList<Callable<List<RuleMatch>>> callables = new ArrayList<Callable<List<RuleMatch>>>();
        for (int i = 0; i < threads; ++i) {
            List<Rule> subRules = i == threads - 1 ? allRules.subList(firstItem, totalRules) : allRules.subList(firstItem, firstItem + chunkSize);
            callables.add(new JLanguageTool.TextCheckCallable(subRules, sentences, analyzedSentences, paraMode, annotatedText, charCount, lineCount, columnCount, listener));
            firstItem += chunkSize;
        }
        return callables;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("lt-multithread");
            return thread;
        }
    }

    private final class ParagraphEndAnalyzeSentenceCallable
    extends AnalyzeSentenceCallable {
        private ParagraphEndAnalyzeSentenceCallable(String sentence) {
            super(sentence);
        }

        @Override
        public AnalyzedSentence call() throws Exception {
            AnalyzedSentence analyzedSentence = super.call();
            AnalyzedTokenReadings[] anTokens = analyzedSentence.getTokens();
            anTokens[anTokens.length - 1].setParagraphEnd();
            analyzedSentence = new AnalyzedSentence(anTokens);
            return analyzedSentence;
        }
    }

    private class AnalyzeSentenceCallable
    implements Callable<AnalyzedSentence> {
        private final String sentence;

        private AnalyzeSentenceCallable(String sentence) {
            this.sentence = sentence;
        }

        @Override
        public AnalyzedSentence call() throws Exception {
            return MultiThreadedJLanguageTool.this.getAnalyzedSentence(this.sentence);
        }
    }
}

