/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.ClientId;
import com.sun.jndi.ldap.DigestClientId;
import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapClientFactory;
import com.sun.jndi.ldap.Obj;
import com.sun.jndi.ldap.SimpleClientId;
import com.sun.jndi.ldap.pool.Pool;
import com.sun.jndi.ldap.pool.PoolCleaner;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.ldap.Control;

public final class LdapPoolManager {
    private static final String DEBUG = "com.sun.jndi.ldap.connect.pool.debug";
    public static final boolean debug = "all".equalsIgnoreCase(LdapPoolManager.getProperty("com.sun.jndi.ldap.connect.pool.debug", null));
    public static final boolean trace = debug || "fine".equalsIgnoreCase(LdapPoolManager.getProperty("com.sun.jndi.ldap.connect.pool.debug", null));
    private static final String POOL_AUTH = "com.sun.jndi.ldap.connect.pool.authentication";
    private static final String POOL_PROTOCOL = "com.sun.jndi.ldap.connect.pool.protocol";
    private static final String MAX_POOL_SIZE = "com.sun.jndi.ldap.connect.pool.maxsize";
    private static final String PREF_POOL_SIZE = "com.sun.jndi.ldap.connect.pool.prefsize";
    private static final String INIT_POOL_SIZE = "com.sun.jndi.ldap.connect.pool.initsize";
    private static final String POOL_TIMEOUT = "com.sun.jndi.ldap.connect.pool.timeout";
    private static final String SASL_CALLBACK = "java.naming.security.sasl.callback";
    private static final int DEFAULT_MAX_POOL_SIZE = 0;
    private static final int DEFAULT_PREF_POOL_SIZE = 0;
    private static final int DEFAULT_INIT_POOL_SIZE = 1;
    private static final int DEFAULT_TIMEOUT = 0;
    private static final String DEFAULT_AUTH_MECHS = "none simple";
    private static final String DEFAULT_PROTOCOLS = "plain";
    private static final int NONE = 0;
    private static final int SIMPLE = 1;
    private static final int DIGEST = 2;
    private static final long idleTimeout;
    private static final int maxSize;
    private static final int prefSize;
    private static final int initSize;
    private static boolean supportPlainProtocol;
    private static boolean supportSslProtocol;
    private static final Pool[] pools;

    private LdapPoolManager() {
    }

    private static int findPool(String mech) {
        if ("none".equalsIgnoreCase(mech)) {
            return 0;
        }
        if ("simple".equalsIgnoreCase(mech)) {
            return 1;
        }
        if ("digest-md5".equalsIgnoreCase(mech)) {
            return 2;
        }
        return -1;
    }

    static boolean isPoolingAllowed(String socketFactory, OutputStream trace, String authMech, String protocol, Hashtable<?, ?> env) throws NamingException {
        int p;
        if (trace != null && !debug || protocol == null && !supportPlainProtocol || "ssl".equalsIgnoreCase(protocol) && !supportSslProtocol) {
            LdapPoolManager.d("Pooling disallowed due to tracing or unsupported pooling of protocol");
            return false;
        }
        String COMPARATOR = "java.util.Comparator";
        boolean foundSockCmp = false;
        if (socketFactory != null && !socketFactory.equals("javax.net.ssl.SSLSocketFactory")) {
            try {
                Class<?> socketFactoryClass = Obj.helper.loadClass(socketFactory);
                Class<?>[] interfaces = socketFactoryClass.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!interfaces[i].getCanonicalName().equals(COMPARATOR)) continue;
                    foundSockCmp = true;
                }
            }
            catch (Exception e) {
                CommunicationException ce = new CommunicationException("Loading the socket factory");
                ce.setRootCause(e);
                throw ce;
            }
            if (!foundSockCmp) {
                return false;
            }
        }
        if ((p = LdapPoolManager.findPool(authMech)) < 0 || pools[p] == null) {
            LdapPoolManager.d("authmech not found: ", authMech);
            return false;
        }
        LdapPoolManager.d("using authmech: ", authMech);
        switch (p) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return env == null || env.get(SASL_CALLBACK) == null;
            }
        }
        return false;
    }

    static LdapClient getLdapClient(String host, int port, String socketFactory, int connTimeout, int readTimeout, OutputStream trace, int version, String authMech, Control[] ctls, String protocol, String user, Object passwd, Hashtable<?, ?> env) throws NamingException {
        Pool pool;
        ClientId id = null;
        int p = LdapPoolManager.findPool(authMech);
        if (p < 0 || (pool = pools[p]) == null) {
            throw new IllegalArgumentException("Attempting to use pooling for an unsupported mechanism: " + authMech);
        }
        switch (p) {
            case 0: {
                id = new ClientId(version, host, port, protocol, ctls, trace, socketFactory);
                break;
            }
            case 1: {
                id = new SimpleClientId(version, host, port, protocol, ctls, trace, socketFactory, user, passwd);
                break;
            }
            case 2: {
                id = new DigestClientId(version, host, port, protocol, ctls, trace, socketFactory, user, passwd, env);
            }
        }
        return (LdapClient)pool.getPooledConnection(id, connTimeout, new LdapClientFactory(host, port, socketFactory, connTimeout, readTimeout, trace));
    }

    public static void showStats(PrintStream out) {
        out.println("***** start *****");
        out.println("idle timeout: " + idleTimeout);
        out.println("maximum pool size: " + maxSize);
        out.println("preferred pool size: " + prefSize);
        out.println("initial pool size: " + initSize);
        out.println("protocol types: " + (supportPlainProtocol ? "plain " : "") + (supportSslProtocol ? "ssl" : ""));
        out.println("authentication types: " + (pools[0] != null ? "none " : "") + (pools[1] != null ? "simple " : "") + (pools[2] != null ? "DIGEST-MD5 " : ""));
        for (int i = 0; i < pools.length; ++i) {
            if (pools[i] == null) continue;
            out.println((i == 0 ? "anonymous pools" : (i == 1 ? "simple auth pools" : (i == 2 ? "digest pools" : ""))) + ":");
            pools[i].showStats(out);
        }
        out.println("***** end *****");
    }

    public static void expire(long threshold) {
        for (int i = 0; i < pools.length; ++i) {
            if (pools[i] == null) continue;
            pools[i].expire(threshold);
        }
    }

    private static void d(String msg) {
        if (debug) {
            System.err.println("LdapPoolManager: " + msg);
        }
    }

    private static void d(String msg, String o) {
        if (debug) {
            System.err.println("LdapPoolManager: " + msg + o);
        }
    }

    private static final String getProperty(final String propName, final String defVal) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    return System.getProperty(propName, defVal);
                }
                catch (SecurityException e) {
                    return defVal;
                }
            }
        });
    }

    private static final int getInteger(final String propName, final int defVal) {
        Integer val = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                try {
                    return Integer.getInteger(propName, defVal);
                }
                catch (SecurityException e) {
                    return new Integer(defVal);
                }
            }
        });
        return val;
    }

    private static final long getLong(final String propName, final long defVal) {
        Long val = AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                try {
                    return Long.getLong(propName, defVal);
                }
                catch (SecurityException e) {
                    return new Long(defVal);
                }
            }
        });
        return val;
    }

    static {
        supportPlainProtocol = false;
        supportSslProtocol = false;
        pools = new Pool[3];
        maxSize = LdapPoolManager.getInteger(MAX_POOL_SIZE, 0);
        prefSize = LdapPoolManager.getInteger(PREF_POOL_SIZE, 0);
        initSize = LdapPoolManager.getInteger(INIT_POOL_SIZE, 1);
        idleTimeout = LdapPoolManager.getLong(POOL_TIMEOUT, 0L);
        String str = LdapPoolManager.getProperty(POOL_AUTH, DEFAULT_AUTH_MECHS);
        StringTokenizer parser = new StringTokenizer(str);
        int count = parser.countTokens();
        for (int i = 0; i < count; ++i) {
            int p;
            String mech = parser.nextToken().toLowerCase(Locale.ENGLISH);
            if (mech.equals("anonymous")) {
                mech = "none";
            }
            if ((p = LdapPoolManager.findPool(mech)) < 0 || pools[p] != null) continue;
            LdapPoolManager.pools[p] = new Pool(initSize, prefSize, maxSize);
        }
        str = LdapPoolManager.getProperty(POOL_PROTOCOL, DEFAULT_PROTOCOLS);
        parser = new StringTokenizer(str);
        count = parser.countTokens();
        for (int i = 0; i < count; ++i) {
            String proto = parser.nextToken();
            if (DEFAULT_PROTOCOLS.equalsIgnoreCase(proto)) {
                supportPlainProtocol = true;
                continue;
            }
            if (!"ssl".equalsIgnoreCase(proto)) continue;
            supportSslProtocol = true;
        }
        if (idleTimeout > 0L) {
            new PoolCleaner(idleTimeout, pools).start();
        }
        if (debug) {
            LdapPoolManager.showStats(System.err);
        }
    }
}

