/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ThroughputInterceptor
extends ChannelInterceptorBase {
    private static final Log log = LogFactory.getLog(ThroughputInterceptor.class);
    double mbTx = 0.0;
    double mbAppTx = 0.0;
    double mbRx = 0.0;
    double timeTx = 0.0;
    double lastCnt = 0.0;
    AtomicLong msgTxCnt = new AtomicLong(1L);
    AtomicLong msgRxCnt = new AtomicLong(0L);
    AtomicLong msgTxErr = new AtomicLong(0L);
    int interval = 10000;
    AtomicInteger access = new AtomicInteger(0);
    long txStart = 0L;
    long rxStart = 0L;
    DecimalFormat df = new DecimalFormat("#0.00");

    @Override
    public void sendMessage(Member[] destination, ChannelMessage msg, InterceptorPayload payload) throws ChannelException {
        if (this.access.addAndGet(1) == 1) {
            this.txStart = System.currentTimeMillis();
        }
        long bytes = XByteBuffer.getDataPackageLength(((ChannelData)msg).getDataPackageLength());
        try {
            super.sendMessage(destination, msg, payload);
        }
        catch (ChannelException x) {
            this.msgTxErr.addAndGet(1L);
            if (this.access.get() == 1) {
                this.access.addAndGet(-1);
            }
            throw x;
        }
        this.mbTx += (double)(bytes * (long)destination.length) / 1048576.0;
        this.mbAppTx += (double)bytes / 1048576.0;
        if (this.access.addAndGet(-1) == 0) {
            long stop = System.currentTimeMillis();
            this.timeTx += (double)(stop - this.txStart) / 1000.0;
            if ((double)(this.msgTxCnt.get() / (long)this.interval) >= this.lastCnt) {
                this.lastCnt += 1.0;
                this.report(this.timeTx);
            }
        }
        this.msgTxCnt.addAndGet(1L);
    }

    @Override
    public void messageReceived(ChannelMessage msg) {
        if (this.rxStart == 0L) {
            this.rxStart = System.currentTimeMillis();
        }
        long bytes = XByteBuffer.getDataPackageLength(((ChannelData)msg).getDataPackageLength());
        this.mbRx += (double)bytes / 1048576.0;
        this.msgRxCnt.addAndGet(1L);
        if (this.msgRxCnt.get() % (long)this.interval == 0L) {
            this.report(this.timeTx);
        }
        super.messageReceived(msg);
    }

    public void report(double timeTx) {
        StringBuilder buf = new StringBuilder("ThroughputInterceptor Report[\n\tTx Msg:");
        buf.append(this.msgTxCnt).append(" messages\n\tSent:");
        buf.append(this.df.format(this.mbTx));
        buf.append(" MB (total)\n\tSent:");
        buf.append(this.df.format(this.mbAppTx));
        buf.append(" MB (application)\n\tTime:");
        buf.append(this.df.format(timeTx));
        buf.append(" seconds\n\tTx Speed:");
        buf.append(this.df.format(this.mbTx / timeTx));
        buf.append(" MB/sec (total)\n\tTxSpeed:");
        buf.append(this.df.format(this.mbAppTx / timeTx));
        buf.append(" MB/sec (application)\n\tError Msg:");
        buf.append(this.msgTxErr).append("\n\tRx Msg:");
        buf.append(this.msgRxCnt);
        buf.append(" messages\n\tRx Speed:");
        buf.append(this.df.format(this.mbRx / (double)((System.currentTimeMillis() - this.rxStart) / 1000L)));
        buf.append(" MB/sec (since 1st msg)\n\tReceived:");
        buf.append(this.df.format(this.mbRx)).append(" MB]\n");
        if (log.isInfoEnabled()) {
            log.info((Object)buf);
        }
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public int getInterval() {
        return this.interval;
    }

    public double getLastCnt() {
        return this.lastCnt;
    }

    public double getMbAppTx() {
        return this.mbAppTx;
    }

    public double getMbRx() {
        return this.mbRx;
    }

    public double getMbTx() {
        return this.mbTx;
    }

    public AtomicLong getMsgRxCnt() {
        return this.msgRxCnt;
    }

    public AtomicLong getMsgTxCnt() {
        return this.msgTxCnt;
    }

    public AtomicLong getMsgTxErr() {
        return this.msgTxErr;
    }

    public long getRxStart() {
        return this.rxStart;
    }

    public double getTimeTx() {
        return this.timeTx;
    }

    public long getTxStart() {
        return this.txStart;
    }
}

