/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.analysis.FieldNameAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperForType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.percolator.PercolateQuery;
import org.elasticsearch.percolator.PercolatorFieldMapper;

public class PercolateQueryBuilder
extends AbstractQueryBuilder<PercolateQueryBuilder> {
    public static final String NAME = "percolate";
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(ParseField.class));
    static final ParseField DOCUMENT_FIELD = new ParseField("document", new String[0]);
    static final ParseField DOCUMENTS_FIELD = new ParseField("documents", new String[0]);
    private static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    private static final ParseField QUERY_FIELD = new ParseField("field", new String[0]);
    private static final ParseField DOCUMENT_TYPE_FIELD = new ParseField("document_type", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_INDEX = new ParseField("index", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_TYPE = new ParseField("type", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_ID = new ParseField("id", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_ROUTING = new ParseField("routing", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_PREFERENCE = new ParseField("preference", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_VERSION = new ParseField("version", new String[0]);
    private final String field;
    private String name;
    @Deprecated
    private final String documentType;
    private final List<BytesReference> documents;
    private final XContentType documentXContentType;
    private final String indexedDocumentIndex;
    private final String indexedDocumentType;
    private final String indexedDocumentId;
    private final String indexedDocumentRouting;
    private final String indexedDocumentPreference;
    private final Long indexedDocumentVersion;
    private final Supplier<BytesReference> documentSupplier;

    @Deprecated
    public PercolateQueryBuilder(String field, String documentType, BytesReference document) {
        this(field, documentType, Collections.singletonList(document), XContentHelper.xContentType((BytesReference)document));
    }

    public PercolateQueryBuilder(String field, BytesReference document, XContentType documentXContentType) {
        this(field, null, Collections.singletonList(document), documentXContentType);
    }

    public PercolateQueryBuilder(String field, List<BytesReference> documents, XContentType documentXContentType) {
        this(field, null, documents, documentXContentType);
    }

    @Deprecated
    public PercolateQueryBuilder(String field, String documentType, List<BytesReference> documents, XContentType documentXContentType) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        if (documents == null) {
            throw new IllegalArgumentException("[document] is a required argument");
        }
        this.field = field;
        this.documentType = documentType;
        this.documents = documents;
        this.documentXContentType = Objects.requireNonNull(documentXContentType);
        this.indexedDocumentIndex = null;
        this.indexedDocumentType = null;
        this.indexedDocumentId = null;
        this.indexedDocumentRouting = null;
        this.indexedDocumentPreference = null;
        this.indexedDocumentVersion = null;
        this.documentSupplier = null;
    }

    private PercolateQueryBuilder(String field, String documentType, Supplier<BytesReference> documentSupplier) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        this.field = field;
        this.documentType = documentType;
        this.documents = Collections.emptyList();
        this.documentXContentType = null;
        this.documentSupplier = documentSupplier;
        this.indexedDocumentIndex = null;
        this.indexedDocumentType = null;
        this.indexedDocumentId = null;
        this.indexedDocumentRouting = null;
        this.indexedDocumentPreference = null;
        this.indexedDocumentVersion = null;
    }

    public PercolateQueryBuilder(String field, String indexedDocumentIndex, String indexedDocumentType, String indexedDocumentId, String indexedDocumentRouting, String indexedDocumentPreference, Long indexedDocumentVersion) {
        this(field, null, indexedDocumentIndex, indexedDocumentType, indexedDocumentId, indexedDocumentRouting, indexedDocumentPreference, indexedDocumentVersion);
    }

    @Deprecated
    public PercolateQueryBuilder(String field, String documentType, String indexedDocumentIndex, String indexedDocumentType, String indexedDocumentId, String indexedDocumentRouting, String indexedDocumentPreference, Long indexedDocumentVersion) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        if (indexedDocumentIndex == null) {
            throw new IllegalArgumentException("[index] is a required argument");
        }
        if (indexedDocumentType == null) {
            throw new IllegalArgumentException("[type] is a required argument");
        }
        if (indexedDocumentId == null) {
            throw new IllegalArgumentException("[id] is a required argument");
        }
        this.field = field;
        this.documentType = documentType;
        this.indexedDocumentIndex = indexedDocumentIndex;
        this.indexedDocumentType = indexedDocumentType;
        this.indexedDocumentId = indexedDocumentId;
        this.indexedDocumentRouting = indexedDocumentRouting;
        this.indexedDocumentPreference = indexedDocumentPreference;
        this.indexedDocumentVersion = indexedDocumentVersion;
        this.documents = Collections.emptyList();
        this.documentXContentType = null;
        this.documentSupplier = null;
    }

    PercolateQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.field = in.readString();
        if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
            this.name = in.readOptionalString();
        }
        this.documentType = in.getVersion().before(Version.V_6_0_0_beta1) ? in.readString() : in.readOptionalString();
        this.indexedDocumentIndex = in.readOptionalString();
        this.indexedDocumentType = in.readOptionalString();
        this.indexedDocumentId = in.readOptionalString();
        this.indexedDocumentRouting = in.readOptionalString();
        this.indexedDocumentPreference = in.readOptionalString();
        this.indexedDocumentVersion = in.readBoolean() ? Long.valueOf(in.readVLong()) : null;
        if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
            this.documents = in.readList(StreamInput::readBytesReference);
        } else {
            BytesReference document = in.readOptionalBytesReference();
            List<Object> list = this.documents = document != null ? Collections.singletonList(document) : Collections.emptyList();
        }
        this.documentXContentType = !this.documents.isEmpty() ? (in.getVersion().onOrAfter(Version.V_5_3_0) ? (XContentType)in.readEnum(XContentType.class) : XContentHelper.xContentType((BytesReference)this.documents.iterator().next())) : null;
        this.documentSupplier = null;
    }

    public PercolateQueryBuilder setName(String name) {
        this.name = name;
        return this;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.documentSupplier != null) {
            throw new IllegalStateException("supplier must be null, can't serialize suppliers, missing a rewriteAndFetch?");
        }
        out.writeString(this.field);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeOptionalString(this.name);
        }
        if (out.getVersion().before(Version.V_6_0_0_beta1)) {
            out.writeString(this.documentType);
        } else {
            out.writeOptionalString(this.documentType);
        }
        out.writeOptionalString(this.indexedDocumentIndex);
        out.writeOptionalString(this.indexedDocumentType);
        out.writeOptionalString(this.indexedDocumentId);
        out.writeOptionalString(this.indexedDocumentRouting);
        out.writeOptionalString(this.indexedDocumentPreference);
        if (this.indexedDocumentVersion != null) {
            out.writeBoolean(true);
            out.writeVLong(this.indexedDocumentVersion.longValue());
        } else {
            out.writeBoolean(false);
        }
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeVInt(this.documents.size());
            for (BytesReference document : this.documents) {
                out.writeBytesReference(document);
            }
        } else {
            if (this.documents.size() > 1) {
                throw new IllegalArgumentException("Nodes prior to 6.1.0 cannot accept multiple documents");
            }
            BytesReference doc = this.documents.isEmpty() ? null : this.documents.iterator().next();
            out.writeOptionalBytesReference(doc);
        }
        if (!this.documents.isEmpty() && out.getVersion().onOrAfter(Version.V_5_3_0)) {
            out.writeEnum((Enum)this.documentXContentType);
        }
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(DOCUMENT_TYPE_FIELD.getPreferredName(), this.documentType);
        builder.field(QUERY_FIELD.getPreferredName(), this.field);
        if (this.name != null) {
            builder.field(NAME_FIELD.getPreferredName(), this.name);
        }
        if (!this.documents.isEmpty()) {
            builder.startArray(DOCUMENTS_FIELD.getPreferredName());
            for (BytesReference document : this.documents) {
                XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)document);
                Throwable throwable = null;
                try {
                    parser.nextToken();
                    builder.generator().copyCurrentStructure(parser);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (parser == null) continue;
                    PercolateQueryBuilder.$closeResource(throwable, (AutoCloseable)parser);
                }
            }
            builder.endArray();
        }
        if (this.indexedDocumentIndex != null || this.indexedDocumentType != null || this.indexedDocumentId != null) {
            if (this.indexedDocumentIndex != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_INDEX.getPreferredName(), this.indexedDocumentIndex);
            }
            if (this.indexedDocumentType != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_TYPE.getPreferredName(), this.indexedDocumentType);
            }
            if (this.indexedDocumentId != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_ID.getPreferredName(), this.indexedDocumentId);
            }
            if (this.indexedDocumentRouting != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_ROUTING.getPreferredName(), this.indexedDocumentRouting);
            }
            if (this.indexedDocumentPreference != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_PREFERENCE.getPreferredName(), this.indexedDocumentPreference);
            }
            if (this.indexedDocumentVersion != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_VERSION.getPreferredName(), this.indexedDocumentVersion);
            }
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static PercolateQueryBuilder fromXContent(XContentParser parser) throws IOException {
        PercolateQueryBuilder queryBuilder;
        XContentParser.Token token;
        float boost = 1.0f;
        String field = null;
        String name = null;
        String documentType = null;
        String indexedDocumentIndex = null;
        String indexedDocumentType = null;
        String indexedDocumentId = null;
        String indexedDocumentRouting = null;
        String indexedDocumentPreference = null;
        Long indexedDocumentVersion = null;
        ArrayList<BytesReference> documents = new ArrayList<BytesReference>();
        String queryName = null;
        String currentFieldName = null;
        boolean documentsSpecified = false;
        boolean documentSpecified = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            Throwable throwable;
            XContentBuilder builder;
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (DOCUMENTS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (documentSpecified) {
                        throw new IllegalArgumentException("[percolate] Either specified [document] or [documents], not both");
                    }
                    documentsSpecified = true;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.START_OBJECT) {
                            builder = XContentFactory.jsonBuilder();
                            throwable = null;
                            try {
                                builder.copyCurrentStructure(parser);
                                builder.flush();
                                documents.add(BytesReference.bytes((XContentBuilder)builder));
                                continue;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (builder != null) {
                                    PercolateQueryBuilder.$closeResource(throwable, (AutoCloseable)builder);
                                }
                                continue;
                            }
                        }
                        throw new ParsingException(parser.getTokenLocation(), "[percolate] query does not support [" + token + "]", new Object[0]);
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[percolate] query does not field name [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (DOCUMENT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (documentsSpecified) {
                        throw new IllegalArgumentException("[percolate] Either specified [document] or [documents], not both");
                    }
                    documentSpecified = true;
                    builder = XContentFactory.jsonBuilder();
                    throwable = null;
                    try {
                        builder.copyCurrentStructure(parser);
                        builder.flush();
                        documents.add(BytesReference.bytes((XContentBuilder)builder));
                        continue;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (builder != null) {
                            PercolateQueryBuilder.$closeResource(throwable, (AutoCloseable)builder);
                        }
                        continue;
                    }
                }
                throw new ParsingException(parser.getTokenLocation(), "[percolate] query does not support field name [" + currentFieldName + "]", new Object[0]);
            }
            if (token.isValue() || token == XContentParser.Token.VALUE_NULL) {
                if (QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    field = parser.text();
                    continue;
                }
                if (NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    name = parser.textOrNull();
                    continue;
                }
                if (DOCUMENT_TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    documentType = parser.textOrNull();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_INDEX.match(currentFieldName, parser.getDeprecationHandler())) {
                    indexedDocumentIndex = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                    indexedDocumentType = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_ID.match(currentFieldName, parser.getDeprecationHandler())) {
                    indexedDocumentId = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_ROUTING.match(currentFieldName, parser.getDeprecationHandler())) {
                    indexedDocumentRouting = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_PREFERENCE.match(currentFieldName, parser.getDeprecationHandler())) {
                    indexedDocumentPreference = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_VERSION.match(currentFieldName, parser.getDeprecationHandler())) {
                    indexedDocumentVersion = parser.longValue();
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    boost = parser.floatValue();
                    continue;
                }
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queryName = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[percolate] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[percolate] query does not support [" + token + "]", new Object[0]);
        }
        if (!documents.isEmpty()) {
            queryBuilder = new PercolateQueryBuilder(field, documentType, documents, XContentType.JSON);
        } else if (indexedDocumentId != null) {
            queryBuilder = new PercolateQueryBuilder(field, documentType, indexedDocumentIndex, indexedDocumentType, indexedDocumentId, indexedDocumentRouting, indexedDocumentPreference, indexedDocumentVersion);
        } else {
            throw new IllegalArgumentException("[percolate] query, nothing to percolate");
        }
        if (name != null) {
            queryBuilder.setName(name);
        }
        queryBuilder.queryName(queryName);
        queryBuilder.boost(boost);
        return queryBuilder;
    }

    protected boolean doEquals(PercolateQueryBuilder other) {
        return Objects.equals(this.field, other.field) && Objects.equals(this.documentType, other.documentType) && Objects.equals(this.documents, other.documents) && Objects.equals(this.indexedDocumentIndex, other.indexedDocumentIndex) && Objects.equals(this.indexedDocumentType, other.indexedDocumentType) && Objects.equals(this.documentSupplier, other.documentSupplier) && Objects.equals(this.indexedDocumentId, other.indexedDocumentId);
    }

    protected int doHashCode() {
        return Objects.hash(this.field, this.documentType, this.documents, this.indexedDocumentIndex, this.indexedDocumentType, this.indexedDocumentId, this.documentSupplier);
    }

    public String getWriteableName() {
        return NAME;
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) {
        if (!this.documents.isEmpty()) {
            return this;
        }
        if (this.documentSupplier != null) {
            BytesReference source = this.documentSupplier.get();
            if (source == null) {
                return this;
            }
            return new PercolateQueryBuilder(this.field, this.documentType, Collections.singletonList(source), XContentHelper.xContentType((BytesReference)source));
        }
        GetRequest getRequest = new GetRequest(this.indexedDocumentIndex, this.indexedDocumentType, this.indexedDocumentId);
        getRequest.preference("_local");
        getRequest.routing(this.indexedDocumentRouting);
        getRequest.preference(this.indexedDocumentPreference);
        if (this.indexedDocumentVersion != null) {
            getRequest.version(this.indexedDocumentVersion.longValue());
        }
        SetOnce documentSupplier = new SetOnce();
        queryShardContext.registerAsyncAction((client, listener) -> client.get(getRequest, ActionListener.wrap(getResponse -> {
            if (!getResponse.isExists()) {
                throw new ResourceNotFoundException("indexed document [{}/{}/{}] couldn't be found", new Object[]{this.indexedDocumentIndex, this.indexedDocumentType, this.indexedDocumentId});
            }
            if (getResponse.isSourceEmpty()) {
                throw new IllegalArgumentException("indexed document [" + this.indexedDocumentIndex + "/" + this.indexedDocumentType + "/" + this.indexedDocumentId + "] source disabled");
            }
            documentSupplier.set((Object)getResponse.getSourceAsBytesRef());
            listener.onResponse(null);
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
        return new PercolateQueryBuilder(this.field, this.documentType, () -> ((SetOnce)documentSupplier).get());
    }

    protected Query doToQuery(final QueryShardContext context) throws IOException {
        IndexSearcher docSearcher;
        DocumentMapper docMapper;
        context.nowInMillis();
        if (this.indexedDocumentIndex != null || this.indexedDocumentType != null || this.indexedDocumentId != null || this.documentSupplier != null) {
            throw new IllegalStateException("query builder must be rewritten first");
        }
        if (this.documents.isEmpty()) {
            throw new IllegalStateException("no document to percolate");
        }
        MappedFieldType fieldType = context.fieldMapper(this.field);
        if (fieldType == null) {
            throw new QueryShardException(context, "field [" + this.field + "] does not exist", new Object[0]);
        }
        if (!(fieldType instanceof PercolatorFieldMapper.FieldType)) {
            throw new QueryShardException(context, "expected field [" + this.field + "] to be of type [percolator], but is of type [" + fieldType.typeName() + "]", new Object[0]);
        }
        ArrayList<ParsedDocument> docs = new ArrayList<ParsedDocument>();
        MapperService mapperService = context.getMapperService();
        if (context.getIndexSettings().isSingleType()) {
            Collection types = mapperService.types();
            if (types.size() != 1) {
                throw new IllegalStateException("Only a single type should exist, but [" + types.size() + " types exists");
            }
            String type = (String)types.iterator().next();
            if (this.documentType != null) {
                DEPRECATION_LOGGER.deprecated("[document_type] parameter has been deprecated because types have been deprecated", new Object[0]);
                if (!this.documentType.equals(type)) {
                    throw new IllegalArgumentException("specified document_type [" + this.documentType + "] is not equal to the actual type [" + (String)type + "]");
                }
            }
            docMapper = mapperService.documentMapper(type);
            for (BytesReference document : this.documents) {
                docs.add(docMapper.parse(SourceToParse.source((String)context.index().getName(), (String)type, (String)"_temp_id", (BytesReference)document, (XContentType)this.documentXContentType)));
            }
        } else {
            if (this.documentType == null) {
                throw new IllegalArgumentException("[percolate] query is missing required [document_type] parameter");
            }
            DocumentMapperForType docMapperForType = mapperService.documentMapperWithAutoCreate(this.documentType);
            docMapper = docMapperForType.getDocumentMapper();
            for (BytesReference document : this.documents) {
                docs.add(docMapper.parse(SourceToParse.source((String)context.index().getName(), (String)this.documentType, (String)"_temp_id", (BytesReference)document, (XContentType)this.documentXContentType)));
            }
        }
        final FieldNameAnalyzer fieldNameAnalyzer = (FieldNameAnalyzer)docMapper.mappers().indexAnalyzer();
        DelegatingAnalyzerWrapper analyzer = new DelegatingAnalyzerWrapper(Analyzer.PER_FIELD_REUSE_STRATEGY){

            protected Analyzer getWrappedAnalyzer(String fieldName) {
                Analyzer analyzer = (Analyzer)fieldNameAnalyzer.analyzers().get(fieldName);
                if (analyzer != null) {
                    return analyzer;
                }
                return context.getIndexAnalyzers().getDefaultIndexAnalyzer();
            }
        };
        if (docs.size() > 1 || ((ParsedDocument)docs.get(0)).docs().size() > 1) {
            assert (docs.size() != 1 || docMapper.hasNestedObjects());
            docSearcher = PercolateQueryBuilder.createMultiDocumentSearcher((Analyzer)analyzer, docs);
        } else {
            MemoryIndex memoryIndex = MemoryIndex.fromDocument((Iterable)((ParsedDocument)docs.get(0)).rootDoc(), (Analyzer)analyzer, (boolean)true, (boolean)false);
            docSearcher = memoryIndex.createSearcher();
            docSearcher.setQueryCache(null);
        }
        PercolatorFieldMapper.FieldType pft = (PercolatorFieldMapper.FieldType)fieldType;
        String name = this.name != null ? this.name : pft.name();
        QueryShardContext percolateShardContext = PercolateQueryBuilder.wrap(context);
        PercolateQuery.QueryStore queryStore = PercolateQueryBuilder.createStore(pft.queryBuilderField, percolateShardContext, pft.mapUnmappedFieldsAsText);
        return pft.percolateQuery(name, queryStore, this.documents, docSearcher, context.indexVersionCreated());
    }

    public String getField() {
        return this.field;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public List<BytesReference> getDocuments() {
        return this.documents;
    }

    XContentType getXContentType() {
        return this.documentXContentType;
    }

    static IndexSearcher createMultiDocumentSearcher(Analyzer analyzer, Collection<ParsedDocument> docs) {
        IndexSearcher indexSearcher;
        RAMDirectory ramDirectory = new RAMDirectory();
        IndexWriter indexWriter = new IndexWriter((Directory)ramDirectory, new IndexWriterConfig(analyzer));
        Throwable throwable = null;
        try {
            Iterable iterable = () -> docs.stream().map(ParsedDocument::docs).flatMap(Collection::stream).iterator();
            indexWriter.addDocuments(iterable);
            DirectoryReader directoryReader = DirectoryReader.open((IndexWriter)indexWriter);
            assert (directoryReader.leaves().size() == 1) : "Expected single leaf, but got [" + directoryReader.leaves().size() + "]";
            IndexSearcher slowSearcher = new IndexSearcher((IndexReader)directoryReader){

                public Weight createNormalizedWeight(Query query, boolean needsScores) throws IOException {
                    BooleanQuery.Builder bq = new BooleanQuery.Builder();
                    bq.add(query, BooleanClause.Occur.MUST);
                    bq.add(Queries.newNestedFilter(), BooleanClause.Occur.MUST_NOT);
                    return super.createNormalizedWeight((Query)bq.build(), needsScores);
                }
            };
            slowSearcher.setQueryCache(null);
            indexSearcher = slowSearcher;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    PercolateQueryBuilder.$closeResource(throwable, (AutoCloseable)indexWriter);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to create index for percolator with nested document ", (Throwable)e, new Object[0]);
            }
        }
        PercolateQueryBuilder.$closeResource(throwable, (AutoCloseable)indexWriter);
        return indexSearcher;
    }

    static PercolateQuery.QueryStore createStore(MappedFieldType queryBuilderFieldType, QueryShardContext context, boolean mapUnmappedFieldsAsString) {
        Version indexVersion = context.indexVersionCreated();
        NamedWriteableRegistry registry = context.getWriteableRegistry();
        return ctx -> {
            LeafReader leafReader = ctx.reader();
            BinaryDocValues binaryDocValues = leafReader.getBinaryDocValues(queryBuilderFieldType.name());
            if (binaryDocValues == null) {
                return docId -> null;
            }
            if (indexVersion.onOrAfter(Version.V_6_0_0_beta2)) {
                return docId -> {
                    if (binaryDocValues.advanceExact(docId.intValue())) {
                        BytesRef qbSource = binaryDocValues.binaryValue();
                        ByteArrayInputStream in = new ByteArrayInputStream(qbSource.bytes, qbSource.offset, qbSource.length);
                        Throwable throwable = null;
                        try {
                            Query query;
                            NamedWriteableAwareStreamInput input = new NamedWriteableAwareStreamInput((StreamInput)new InputStreamStreamInput((InputStream)in, (long)qbSource.length), registry);
                            Throwable throwable2 = null;
                            try {
                                input.setVersion(indexVersion);
                                int numValues = input.readVInt();
                                assert (numValues == 1);
                                int valueLength = input.readVInt();
                                assert (valueLength > 0);
                                QueryBuilder queryBuilder = (QueryBuilder)input.readNamedWriteable(QueryBuilder.class);
                                assert (((InputStream)in).read() == -1);
                                query = PercolatorFieldMapper.toQuery(context, mapUnmappedFieldsAsString, queryBuilder);
                            }
                            catch (Throwable throwable3) {
                                try {
                                    try {
                                        throwable2 = throwable3;
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        PercolateQueryBuilder.$closeResource(throwable2, (AutoCloseable)input);
                                        throw throwable4;
                                    }
                                }
                                catch (Throwable throwable5) {
                                    throwable = throwable5;
                                    throw throwable5;
                                }
                            }
                            PercolateQueryBuilder.$closeResource(throwable2, (AutoCloseable)input);
                            return query;
                        }
                        finally {
                            PercolateQueryBuilder.$closeResource(throwable, in);
                        }
                    }
                    return null;
                };
            }
            return docId -> {
                if (binaryDocValues.advanceExact(docId.intValue())) {
                    BytesRef qbSource = binaryDocValues.binaryValue();
                    if (qbSource.length > 0) {
                        XContent xContent = PercolatorFieldMapper.QUERY_BUILDER_CONTENT_TYPE.xContent();
                        XContentParser sourceParser = xContent.createParser(context.getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, qbSource.bytes, qbSource.offset, qbSource.length);
                        Throwable throwable = null;
                        try {
                            Query query = PercolatorFieldMapper.parseQuery(context, mapUnmappedFieldsAsString, sourceParser);
                            return query;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (sourceParser != null) {
                                PercolateQueryBuilder.$closeResource(throwable, (AutoCloseable)sourceParser);
                            }
                        }
                    }
                    return null;
                }
                return null;
            };
        };
    }

    static QueryShardContext wrap(final QueryShardContext shardContext) {
        return new QueryShardContext(shardContext){

            public BitSetProducer bitsetFilter(Query query) {
                return context -> {
                    IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)context);
                    IndexSearcher searcher = new IndexSearcher(topLevelContext);
                    searcher.setQueryCache(null);
                    Weight weight = searcher.createNormalizedWeight(query, false);
                    Scorer s = weight.scorer(context);
                    if (s != null) {
                        return new BitDocIdSet(BitSet.of((DocIdSetIterator)s.iterator(), (int)context.reader().maxDoc())).bits();
                    }
                    return null;
                };
            }

            public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType fieldType) {
                IndexFieldData.Builder builder = fieldType.fielddataBuilder(shardContext.getFullyQualifiedIndexName());
                IndexFieldDataCache.None cache = new IndexFieldDataCache.None();
                NoneCircuitBreakerService circuitBreaker = new NoneCircuitBreakerService();
                return (IFD)builder.build(shardContext.getIndexSettings(), fieldType, (IndexFieldDataCache)cache, (CircuitBreakerService)circuitBreaker, shardContext.getMapperService());
            }
        };
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

