/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.rollup.RollupField;

public class DeleteRollupJobAction
extends Action<Request, Response, RequestBuilder> {
    public static final DeleteRollupJobAction INSTANCE = new DeleteRollupJobAction();
    public static final String NAME = "cluster:admin/xpack/rollup/delete";

    private DeleteRollupJobAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, INSTANCE);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class Response
    extends AcknowledgedResponse {
        public Response() {
        }

        public Response(boolean acknowledged) {
            super(acknowledged);
        }
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, Response, RequestBuilder> {
        protected RequestBuilder(ElasticsearchClient client, DeleteRollupJobAction action) {
            super(client, (Action)action, (MasterNodeRequest)new Request());
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContent {
        private String id;

        public Request(String id) {
            this.id = ExceptionsHelper.requireNonNull(id, RollupField.ID.getPreferredName());
        }

        public Request() {
        }

        public String getId() {
            return this.id;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.id = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.id);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(RollupField.ID.getPreferredName(), this.id);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.id, other.id);
        }
    }
}

