/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.AsyncCompareResultListener;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.CommonAsyncHelper;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

@InternalUseOnly
final class AsyncCompareHelper
implements CommonAsyncHelper,
IntermediateResponseListener {
    private static final long serialVersionUID = 8888333889563000881L;
    private final AsyncCompareResultListener resultListener;
    private final AsyncRequestID asyncRequestID;
    private final AtomicBoolean responseReturned;
    private final IntermediateResponseListener intermediateResponseListener;
    private final LDAPConnection connection;
    private final long createTime;

    @InternalUseOnly
    AsyncCompareHelper(LDAPConnection connection, int messageID, AsyncCompareResultListener resultListener, IntermediateResponseListener intermediateResponseListener) {
        this.connection = connection;
        this.resultListener = resultListener;
        this.intermediateResponseListener = intermediateResponseListener;
        this.asyncRequestID = new AsyncRequestID(messageID, connection);
        this.responseReturned = new AtomicBoolean(false);
        this.createTime = System.nanoTime();
    }

    public AsyncRequestID getAsyncRequestID() {
        return this.asyncRequestID;
    }

    public LDAPConnection getConnection() {
        return this.connection;
    }

    public long getCreateTimeNanos() {
        return this.createTime;
    }

    public OperationType getOperationType() {
        return OperationType.COMPARE;
    }

    @InternalUseOnly
    public void responseReceived(LDAPResponse response) throws LDAPException {
        ConnectionClosedResponse ccr;
        String msg;
        if (!this.responseReturned.compareAndSet(false, true)) {
            return;
        }
        long responseTime = System.nanoTime() - this.createTime;
        CompareResult result = response instanceof ConnectionClosedResponse ? ((msg = (ccr = (ConnectionClosedResponse)response).getMessage()) == null ? new CompareResult(this.asyncRequestID.getMessageID(), ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE.get(), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS) : new CompareResult(this.asyncRequestID.getMessageID(), ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE_WITH_MESSAGE.get(msg), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS)) : (CompareResult)response;
        this.connection.getConnectionStatistics().incrementNumCompareResponses(responseTime);
        this.resultListener.compareResultReceived(this.asyncRequestID, result);
        this.asyncRequestID.setResult(result);
    }

    @InternalUseOnly
    public void intermediateResponseReturned(IntermediateResponse intermediateResponse) {
        if (this.intermediateResponseListener == null) {
            Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_INTERMEDIATE_RESPONSE_WITH_NO_LISTENER.get(String.valueOf(intermediateResponse)));
        } else {
            this.intermediateResponseListener.intermediateResponseReturned(intermediateResponse);
        }
    }
}

