/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.BlendedTermQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.search.MatchQuery;

public class MultiMatchQuery
extends MatchQuery {
    private Float groupTieBreaker = null;
    private QueryBuilder queryBuilder;

    public void setTieBreaker(float tieBreaker) {
        this.groupTieBreaker = Float.valueOf(tieBreaker);
    }

    public MultiMatchQuery(QueryShardContext context) {
        super(context);
    }

    private Query parseAndApply(MatchQuery.Type type, String fieldName, Object value, String minimumShouldMatch, Float boostValue) throws IOException {
        Query query = this.parse(type, fieldName, value);
        if ((query = Queries.maybeApplyMinimumShouldMatch(query, minimumShouldMatch)) != null && boostValue != null && boostValue.floatValue() != 1.0f && !(query instanceof MatchNoDocsQuery)) {
            query = new BoostQuery(query, boostValue.floatValue());
        }
        return query;
    }

    public Query parse(MultiMatchQueryBuilder.Type type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) throws IOException {
        Query result;
        if (fieldNames.size() == 1) {
            Map.Entry<String, Float> fieldBoost = fieldNames.entrySet().iterator().next();
            Float boostValue = fieldBoost.getValue();
            result = this.parseAndApply(type.matchQueryType(), fieldBoost.getKey(), value, minimumShouldMatch, boostValue);
        } else {
            float tieBreaker = this.groupTieBreaker == null ? type.tieBreaker() : this.groupTieBreaker.floatValue();
            switch (type) {
                case PHRASE: 
                case PHRASE_PREFIX: 
                case BEST_FIELDS: 
                case MOST_FIELDS: {
                    this.queryBuilder = new QueryBuilder(tieBreaker);
                    break;
                }
                case CROSS_FIELDS: {
                    this.queryBuilder = new CrossFieldsQueryBuilder(tieBreaker);
                    break;
                }
                default: {
                    throw new IllegalStateException("No such type: " + type);
                }
            }
            List<Query> queries = this.queryBuilder.buildGroupedQueries(type, fieldNames, value, minimumShouldMatch);
            result = this.queryBuilder.combineGrouped(queries);
        }
        return result;
    }

    static Query blendTerm(QueryShardContext context, BytesRef value, Float commonTermsCutoff, float tieBreaker, FieldAndFieldType ... blendedFields) {
        return MultiMatchQuery.blendTerms(context, new BytesRef[]{value}, commonTermsCutoff, tieBreaker, blendedFields);
    }

    static Query blendTerms(QueryShardContext context, BytesRef[] values, Float commonTermsCutoff, float tieBreaker, FieldAndFieldType ... blendedFields) {
        ArrayList<Query> queries = new ArrayList<Query>();
        Term[] terms = new Term[blendedFields.length * values.length];
        float[] blendedBoost = new float[blendedFields.length * values.length];
        int i = 0;
        for (FieldAndFieldType ft : blendedFields) {
            for (BytesRef term : values) {
                Query query;
                try {
                    query = ft.fieldType.termQuery(term, context);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                catch (ElasticsearchParseException parseException) {
                    if (parseException.getCause() instanceof IllegalArgumentException) continue;
                    throw parseException;
                }
                float boost = ft.boost;
                while (query instanceof BoostQuery) {
                    BoostQuery bq = (BoostQuery)query;
                    query = bq.getQuery();
                    boost *= bq.getBoost();
                }
                if (query.getClass() == TermQuery.class) {
                    terms[i] = ((TermQuery)query).getTerm();
                    blendedBoost[i] = boost;
                    ++i;
                    continue;
                }
                if (boost != 1.0f && !(query instanceof MatchNoDocsQuery)) {
                    query = new BoostQuery(query, boost);
                }
                queries.add(query);
            }
        }
        if (i > 0) {
            terms = Arrays.copyOf(terms, i);
            blendedBoost = Arrays.copyOf(blendedBoost, i);
            if (commonTermsCutoff != null) {
                queries.add(BlendedTermQuery.commonTermsBlendedQuery(terms, blendedBoost, commonTermsCutoff.floatValue()));
            } else {
                queries.add(BlendedTermQuery.dismaxBlendedQuery(terms, blendedBoost, tieBreaker));
            }
        }
        if (queries.size() == 1) {
            return (Query)queries.get(0);
        }
        return new DisjunctionMaxQuery(queries, 1.0f);
    }

    static Query blendPhrase(PhraseQuery query, float tiebreaker, FieldAndFieldType ... fields) {
        ArrayList<PhraseQuery> disjunctions = new ArrayList<PhraseQuery>();
        for (FieldAndFieldType field : fields) {
            int[] positions = query.getPositions();
            Term[] terms = query.getTerms();
            PhraseQuery.Builder builder = new PhraseQuery.Builder();
            for (int i = 0; i < terms.length; ++i) {
                builder.add(new Term(field.fieldType.name(), terms[i].bytes()), positions[i]);
            }
            PhraseQuery q = builder.build();
            if (field.boost != 1.0f) {
                q = new BoostQuery((Query)q, field.boost);
            }
            disjunctions.add(q);
        }
        return new DisjunctionMaxQuery(disjunctions, tiebreaker);
    }

    @Override
    protected Query blendTermQuery(Term term, MappedFieldType fieldType) {
        if (this.queryBuilder == null) {
            return super.blendTermQuery(term, fieldType);
        }
        return this.queryBuilder.blendTerm(term, fieldType);
    }

    @Override
    protected Query blendTermsQuery(Term[] terms, MappedFieldType fieldType) {
        if (this.queryBuilder == null) {
            return super.blendTermsQuery(terms, fieldType);
        }
        return this.queryBuilder.blendTerms(terms, fieldType);
    }

    @Override
    protected Query blendPhraseQuery(PhraseQuery query, MappedFieldType fieldType) {
        if (this.queryBuilder == null) {
            return super.blendPhraseQuery(query, fieldType);
        }
        return this.queryBuilder.blendPhrase(query, fieldType);
    }

    static final class FieldAndFieldType {
        final MappedFieldType fieldType;
        final float boost;

        FieldAndFieldType(MappedFieldType fieldType, float boost) {
            this.fieldType = Objects.requireNonNull(fieldType);
            this.boost = boost;
        }
    }

    final class CrossFieldsQueryBuilder
    extends QueryBuilder {
        private FieldAndFieldType[] blendedFields;

        CrossFieldsQueryBuilder(float tiebreaker) {
            super(tiebreaker);
        }

        @Override
        public List<Query> buildGroupedQueries(MultiMatchQueryBuilder.Type type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) throws IOException {
            HashMap groups = new HashMap();
            ArrayList<Query> queries = new ArrayList<Query>();
            for (Map.Entry<String, Float> entry : fieldNames.entrySet()) {
                String name = entry.getKey();
                Object fieldType = MultiMatchQuery.this.context.fieldMapper(name);
                if (fieldType != null) {
                    Float boost;
                    Analyzer actualAnalyzer = MultiMatchQuery.this.getAnalyzer((MappedFieldType)((Object)fieldType), type == MultiMatchQueryBuilder.Type.PHRASE);
                    name = fieldType.name();
                    if (!groups.containsKey(actualAnalyzer)) {
                        groups.put(actualAnalyzer, new ArrayList());
                    }
                    boost = (boost = entry.getValue()) == null ? Float.valueOf(1.0f) : boost;
                    ((List)groups.get(actualAnalyzer)).add(new FieldAndFieldType((MappedFieldType)((Object)fieldType), boost.floatValue()));
                    continue;
                }
                queries.add((Query)new MatchNoDocsQuery("unknown field " + name));
            }
            for (List group : groups.values()) {
                if (group.size() > 1) {
                    this.blendedFields = new FieldAndFieldType[group.size()];
                    int i = 0;
                    for (FieldAndFieldType fieldAndFieldType : group) {
                        this.blendedFields[i++] = fieldAndFieldType;
                    }
                } else {
                    this.blendedFields = null;
                }
                String representativeField = ((FieldAndFieldType)group.get((int)0)).fieldType.name();
                Query q = this.parseGroup(type.matchQueryType(), representativeField, Float.valueOf(1.0f), value, minimumShouldMatch);
                if (q == null) continue;
                queries.add(q);
            }
            return queries.isEmpty() ? null : queries;
        }

        @Override
        public Query blendTerms(Term[] terms, MappedFieldType fieldType) {
            if (this.blendedFields == null || this.blendedFields.length == 1) {
                return super.blendTerms(terms, fieldType);
            }
            BytesRef[] values = new BytesRef[terms.length];
            for (int i = 0; i < terms.length; ++i) {
                values[i] = terms[i].bytes();
            }
            return MultiMatchQuery.blendTerms(MultiMatchQuery.this.context, values, MultiMatchQuery.this.commonTermsCutoff, this.tieBreaker, this.blendedFields);
        }

        @Override
        public Query blendTerm(Term term, MappedFieldType fieldType) {
            if (this.blendedFields == null) {
                return super.blendTerm(term, fieldType);
            }
            return MultiMatchQuery.blendTerm(MultiMatchQuery.this.context, term.bytes(), MultiMatchQuery.this.commonTermsCutoff, this.tieBreaker, this.blendedFields);
        }

        @Override
        public Query termQuery(MappedFieldType fieldType, BytesRef value) {
            return this.blendTerm(new Term(fieldType.name(), value.utf8ToString()), fieldType);
        }

        @Override
        public Query blendPhrase(PhraseQuery query, MappedFieldType type) {
            if (this.blendedFields == null) {
                return super.blendPhrase(query, type);
            }
            return MultiMatchQuery.blendPhrase(query, this.tieBreaker, this.blendedFields);
        }
    }

    public class QueryBuilder {
        protected final float tieBreaker;

        public QueryBuilder(float tieBreaker) {
            this.tieBreaker = tieBreaker;
        }

        public List<Query> buildGroupedQueries(MultiMatchQueryBuilder.Type type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) throws IOException {
            ArrayList<Query> queries = new ArrayList<Query>();
            for (String fieldName : fieldNames.keySet()) {
                Float boostValue = fieldNames.get(fieldName);
                Query query = this.parseGroup(type.matchQueryType(), fieldName, boostValue, value, minimumShouldMatch);
                if (query == null) continue;
                queries.add(query);
            }
            return queries;
        }

        public Query parseGroup(MatchQuery.Type type, String field, Float boostValue, Object value, String minimumShouldMatch) throws IOException {
            return MultiMatchQuery.this.parseAndApply(type, field, value, minimumShouldMatch, boostValue);
        }

        private Query combineGrouped(List<? extends Query> groupQuery) {
            if (groupQuery == null || groupQuery.isEmpty()) {
                return new MatchNoDocsQuery("[multi_match] list of group queries was empty");
            }
            if (groupQuery.size() == 1) {
                return groupQuery.get(0);
            }
            ArrayList<Query> queries = new ArrayList<Query>();
            for (Query query : groupQuery) {
                queries.add(query);
            }
            return new DisjunctionMaxQuery(queries, this.tieBreaker);
        }

        public Query blendTerm(Term term, MappedFieldType fieldType) {
            return MultiMatchQuery.super.blendTermQuery(term, fieldType);
        }

        public Query blendTerms(Term[] terms, MappedFieldType fieldType) {
            return MultiMatchQuery.super.blendTermsQuery(terms, fieldType);
        }

        public Query termQuery(MappedFieldType fieldType, BytesRef value) {
            return MultiMatchQuery.this.termQuery(fieldType, value, MultiMatchQuery.this.lenient);
        }

        public Query blendPhrase(PhraseQuery query, MappedFieldType type) {
            return MultiMatchQuery.super.blendPhraseQuery(query, type);
        }
    }
}

