/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.util;

import java.util.regex.Matcher;
import junit.framework.TestCase;
import org.fibs.geotag.util.CoordinatesParser;

public class CoordinatesParserTest
extends TestCase {
    String coordMachuPicchu = "Machu Picchu 13\u00b0 9\u2032 47\u2033 S, 72\u00b0 32\u2032 44\u2033 W  ";
    String decimalMachuPicchu = "Machu Picchu -13.163056\u00b0, -72.545556\u00b0";

    private void printMatches(Matcher matcher) {
        boolean first = true;
        System.out.print("[");
        while (matcher.find()) {
            System.out.print("<" + matcher.group() + ">");
        }
        System.out.println("]");
    }

    public void testFloat() {
        Matcher matcher = CoordinatesParser.FLOAT_PATTERN.matcher(this.coordMachuPicchu);
        CoordinatesParserTest.assertNotNull((Object)matcher);
        CoordinatesParserTest.assertTrue((boolean)matcher.find());
        CoordinatesParserTest.assertEquals((String)"13", (String)matcher.group());
        CoordinatesParserTest.assertTrue((boolean)matcher.find());
        CoordinatesParserTest.assertEquals((String)"9", (String)matcher.group());
        CoordinatesParserTest.assertTrue((boolean)matcher.find());
        CoordinatesParserTest.assertEquals((String)"47", (String)matcher.group());
        CoordinatesParserTest.assertTrue((boolean)matcher.find());
        CoordinatesParserTest.assertEquals((String)"72", (String)matcher.group());
        CoordinatesParserTest.assertTrue((boolean)matcher.find());
        CoordinatesParserTest.assertEquals((String)"32", (String)matcher.group());
        CoordinatesParserTest.assertTrue((boolean)matcher.find());
        CoordinatesParserTest.assertEquals((String)"44", (String)matcher.group());
        CoordinatesParserTest.assertFalse((boolean)matcher.find());
        matcher = CoordinatesParser.FLOAT_PATTERN.matcher(this.decimalMachuPicchu);
        CoordinatesParserTest.assertNotNull((Object)matcher);
        CoordinatesParserTest.assertTrue((boolean)matcher.find());
        CoordinatesParserTest.assertEquals((String)"-13.163056", (String)matcher.group());
        CoordinatesParserTest.assertTrue((boolean)matcher.find());
        CoordinatesParserTest.assertEquals((String)"-72.545556", (String)matcher.group());
        CoordinatesParserTest.assertFalse((boolean)matcher.find());
    }

    public void testParser() {
        CoordinatesParser parser = new CoordinatesParser(this.coordMachuPicchu);
        double coordinate = parser.nextCoordinate();
        CoordinatesParserTest.assertEquals((double)-13.163056, (double)coordinate, (double)1.0E-6);
        coordinate = parser.nextCoordinate();
        CoordinatesParserTest.assertEquals((double)-72.545556, (double)coordinate, (double)1.0E-6);
        coordinate = parser.nextCoordinate();
        CoordinatesParserTest.assertTrue((boolean)Double.isNaN(coordinate));
    }
}

