/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import net.jcip.annotations.ThreadSafe;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.cache.ModelSchemaCache;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractor;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DefaultModelSchemaStore
implements ModelSchemaStore {
    final Object lock = new Object();
    final ModelSchemaCache cache = new ModelSchemaCache();
    final ModelSchemaExtractor schemaExtractor;

    public DefaultModelSchemaStore(ModelSchemaExtractor schemaExtractor) {
        this.schemaExtractor = schemaExtractor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ModelSchema<T> getSchema(ModelType<T> type) {
        Object object = this.lock;
        synchronized (object) {
            ModelSchema<T> schema = this.cache.get(type);
            if (schema != null) {
                return schema;
            }
            return this.schemaExtractor.extract(type, this.cache);
        }
    }

    @Override
    public <T> ModelSchema<T> getSchema(Class<T> type) {
        return this.getSchema(ModelType.of(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() {
        Object object = this.lock;
        synchronized (object) {
            this.cache.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size() {
        Object object = this.lock;
        synchronized (object) {
            return this.cache.size();
        }
    }
}

