/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.hub;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.dispatch.MethodInvocation;
import org.gradle.internal.remote.internal.hub.MethodArgsSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ObjectReader;
import org.gradle.internal.serialize.ObjectWriter;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.StatefulSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInvocationSerializer
implements StatefulSerializer<MethodInvocation> {
    private final ClassLoader classLoader;
    private final MethodArgsSerializer methodArgsSerializer;

    public MethodInvocationSerializer(ClassLoader classLoader, MethodArgsSerializer methodArgsSerializer) {
        this.classLoader = classLoader;
        this.methodArgsSerializer = methodArgsSerializer;
    }

    @Override
    public ObjectReader<MethodInvocation> newReader(Decoder decoder) {
        return new MethodInvocationReader(decoder, this.classLoader, this.methodArgsSerializer);
    }

    @Override
    public ObjectWriter<MethodInvocation> newWriter(Encoder encoder) {
        return new MethodInvocationWriter(encoder, this.methodArgsSerializer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodInvocationReader
    implements ObjectReader<MethodInvocation> {
        private static final Map<String, Class<?>> PRIMITIVE_TYPES = new HashMap();
        private final Decoder decoder;
        private final ClassLoader classLoader;
        private final MethodArgsSerializer methodArgsSerializer;
        private final Map<Integer, MethodDetails> methods = new HashMap<Integer, MethodDetails>();

        MethodInvocationReader(Decoder decoder, ClassLoader classLoader, MethodArgsSerializer methodArgsSerializer) {
            this.decoder = decoder;
            this.classLoader = classLoader;
            this.methodArgsSerializer = methodArgsSerializer;
        }

        @Override
        public MethodInvocation read() throws Exception {
            MethodDetails methodDetails = this.readMethod();
            Object[] args = this.readArguments(methodDetails);
            return new MethodInvocation(methodDetails.method, args);
        }

        private Object[] readArguments(MethodDetails methodDetails) throws Exception {
            return methodDetails.argsSerializer.read(this.decoder);
        }

        private MethodDetails readMethod() throws ClassNotFoundException, NoSuchMethodException, IOException {
            int methodId = this.decoder.readSmallInt();
            MethodDetails methodDetails = this.methods.get(methodId);
            if (methodDetails == null) {
                Class<?> declaringClass = this.readType();
                String methodName = this.decoder.readString();
                int paramCount = this.decoder.readSmallInt();
                Class[] paramTypes = new Class[paramCount];
                for (int i = 0; i < paramTypes.length; ++i) {
                    paramTypes[i] = this.readType();
                }
                Method method = declaringClass.getDeclaredMethod(methodName, paramTypes);
                methodDetails = new MethodDetails(methodId, method, this.methodArgsSerializer.forTypes(method.getParameterTypes()));
                this.methods.put(methodId, methodDetails);
            }
            return methodDetails;
        }

        private Class<?> readType() throws ClassNotFoundException, IOException {
            String typeName = this.decoder.readString();
            Class<?> paramType = PRIMITIVE_TYPES.get(typeName);
            if (paramType == null) {
                paramType = Class.forName(typeName, false, this.classLoader);
            }
            return paramType;
        }

        static {
            PRIMITIVE_TYPES.put(Integer.TYPE.getName(), Integer.TYPE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodInvocationWriter
    implements ObjectWriter<MethodInvocation> {
        private final Encoder encoder;
        private final MethodArgsSerializer methodArgsSerializer;
        private final Map<Method, MethodDetails> methods = new HashMap<Method, MethodDetails>();

        MethodInvocationWriter(Encoder encoder, MethodArgsSerializer methodArgsSerializer) {
            this.encoder = encoder;
            this.methodArgsSerializer = methodArgsSerializer;
        }

        @Override
        public void write(MethodInvocation value) throws Exception {
            if (value.getArguments().length != value.getMethod().getParameterTypes().length) {
                throw new IllegalArgumentException(String.format("Mismatched number of parameters to method %s.", value.getMethod()));
            }
            MethodDetails methodDetails = this.writeMethod(value.getMethod());
            this.writeArgs(methodDetails, value);
        }

        private void writeArgs(MethodDetails methodDetails, MethodInvocation value) throws Exception {
            methodDetails.argsSerializer.write(this.encoder, value.getArguments());
        }

        private MethodDetails writeMethod(Method method) throws IOException {
            MethodDetails methodDetails = this.methods.get(method);
            if (methodDetails == null) {
                int methodId = this.methods.size();
                methodDetails = new MethodDetails(methodId, method, this.methodArgsSerializer.forTypes(method.getParameterTypes()));
                this.methods.put(method, methodDetails);
                this.encoder.writeSmallInt(methodId);
                this.encoder.writeString(method.getDeclaringClass().getName());
                this.encoder.writeString(method.getName());
                this.encoder.writeSmallInt(method.getParameterTypes().length);
                for (int i = 0; i < method.getParameterTypes().length; ++i) {
                    Class<?> paramType = method.getParameterTypes()[i];
                    this.encoder.writeString(paramType.getName());
                }
            } else {
                this.encoder.writeSmallInt(methodDetails.methodId);
            }
            return methodDetails;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodDetails {
        final int methodId;
        final Method method;
        final Serializer<Object[]> argsSerializer;

        MethodDetails(int methodId, Method method, Serializer<Object[]> argsSerializer) {
            this.methodId = methodId;
            this.method = method;
            this.argsSerializer = argsSerializer;
        }
    }
}

