/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.capabilities.Capability;

public class Configurations {
    public static Set<String> getNames(Collection<Configuration> configurations) {
        if (configurations.isEmpty()) {
            return Collections.emptySet();
        }
        if (configurations.size() == 1) {
            return Collections.singleton(configurations.iterator().next().getName());
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>(configurations.size());
        for (Configuration configuration : configurations) {
            names.add(configuration.getName());
        }
        return names;
    }

    public static Set<Capability> collectCapabilities(Configuration configuration, Set<Capability> out, Set<Configuration> visited) {
        if (visited.add(configuration)) {
            out.addAll(configuration.getOutgoing().getCapabilities());
            for (Configuration parent : configuration.getExtendsFrom()) {
                Configurations.collectCapabilities(parent, out, visited);
            }
        }
        return out;
    }

    public static String uploadTaskName(String configurationName) {
        return "upload".concat(Configurations.getCapitalName(configurationName));
    }

    private static String getCapitalName(String configurationName) {
        return configurationName.substring(0, 1).toUpperCase() + configurationName.substring(1);
    }
}

