/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import javax.annotation.Nullable;
import org.gradle.api.Plugin;
import org.gradle.api.internal.plugins.PluginAwareInternal;
import org.gradle.api.internal.plugins.PluginTarget;
import org.gradle.configuration.ConfigurationTargetIdentifier;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImperativeOnlyPluginTarget<T extends PluginAwareInternal>
implements PluginTarget {
    private final T target;

    public ImperativeOnlyPluginTarget(T target) {
        this.target = target;
    }

    @Override
    public ConfigurationTargetIdentifier getConfigurationTargetIdentifier() {
        return this.target.getConfigurationTargetIdentifier();
    }

    @Override
    public void applyImperative(@Nullable String pluginId, Plugin<?> plugin) {
        Plugin cast = (Plugin)Cast.uncheckedCast(plugin);
        cast.apply(this.target);
    }

    @Override
    public void applyRules(@Nullable String pluginId, Class<?> clazz) {
        String message = String.format("Cannot apply model rules of plugin '%s' as the target '%s' is not model rule aware", clazz.getName(), this.target.toString());
        throw new UnsupportedOperationException(message);
    }

    @Override
    public void applyImperativeRulesHybrid(@Nullable String pluginId, Plugin<?> plugin) {
        this.applyRules(pluginId, plugin.getClass());
    }

    public String toString() {
        return this.target.toString();
    }
}

