/*
 * Decompiled with CFR 0.152.
 */
package org.gennbo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javajs.util.PT;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gennbo.NBODialog;
import org.gennbo.NBOPlugin;
import org.gennbo.NBOService;
import org.gennbo.NBOUtil;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.GuiMap;

class NBOConfig {
    protected static final String NBO_WEB_SITE = "http://nbo7.chem.wisc.edu";
    protected static final String ARCHIVE_DIR = "http://nbo7.chem.wisc.edu/jmol_nborxiv/";
    protected static final String DEFAULT_SCRIPT = "zap;set nbocharges false;set antialiasdisplay;set fontscaling;set bondpicking true;set multipleBondSpacing -0.2; set multipleBondRadiusFactor 0.6;set zoomlarge false;select none;";
    protected static final String INPUT_FILE_EXTENSIONS = "adf;cfi;com;g09;gau;gms;jag;log;mm2;mnd;mol;mp;nw;orc;pqs;qc;vfi;xyz;47";
    protected static final String OUTPUT_FILE_EXTENSIONS = "adf;cfi;gau;gms;jag;mm2;mnd;mp;nw;orc;pqs;qc;mol;xyz;vfi;g09;com";
    protected static final String JMOL_EXTENSIONS = "xyz;mol";
    protected static final String SCRIPT_VIDEO_EXTENSIONS = "script";
    protected static final String GIF_VIDEO_EXTENSIONS = "gif";
    protected static final String JMOL_FONT_SCRIPT = ";set fontscaling true;select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;";
    protected static final Font listFont = new Font("Monospaced", 1, 14);
    protected static final Font monoFont = new Font("Monospaced", 1, 16);
    protected static final Font userInputFont = new Font("Arial", 0, 12);
    protected static final Font settingHelpFont = new Font("Arial", 0, 14);
    protected static final Font searchOpListFont;
    protected static final Font statusFont;
    protected static final Font searchTextAreaFont;
    protected static final Font iconFont;
    protected static final Font nboFont;
    protected static final Font homeTextFont;
    protected static final Font titleFont;
    protected static final Font runButtonFont;
    protected static final Font topFont;
    protected static final Font homeButtonFont;
    protected static final Font nboFontLarge;
    protected static final Font nboProTitleFont;
    private static final int MODE_PATH_SERVICE = 0;
    private static final int MODE_PATH_WORKING = 1;
    protected static final Color titleColor;
    private static final String NBOPROPERTY_DISPLAY_OPTIONS = "displayOptions";
    protected final NBODialog dialog;
    protected final Viewer vwr;
    private final NBOPlugin nboPlugin;
    private final NBOService nboService;
    protected JSlider opacity = new JSlider(0, 10);
    protected JComboBox<Color> colorBox1;
    protected JComboBox<Color> colorBox2;
    protected JCheckBox jCheckAtomNum;
    protected JCheckBox jCheckSelHalo;
    protected JCheckBox jCheckDebugVerbose;
    protected JCheckBox jCheckNboView;
    protected JCheckBox jCheckWireMesh;
    protected static Color orbColor1;
    protected static Color orbColor2;
    protected static Color backgroundColor;
    protected static String orbColorJmol1;
    protected static String orbColorJmol2;
    protected static float opacityOp;
    protected static boolean nboView;
    protected static boolean useWireMesh;
    protected static boolean showAtNum;
    protected static boolean debugVerbose;

    protected NBOConfig(NBODialog dialog) {
        this.dialog = dialog;
        this.vwr = dialog.vwr;
        this.nboPlugin = dialog.nboPlugin;
        this.nboService = dialog.nboService;
    }

    protected JPanel buildSettingsPanel(JPanel settingsPanel) {
        settingsPanel.removeAll();
        this.checkNBOStatus();
        String viewOpts = this.getOrbitalDisplayOptions();
        settingsPanel.setLayout(new BoxLayout(settingsPanel, 1));
        this.addPathSetting(settingsPanel, 0);
        this.addPathSetting(settingsPanel, 1);
        JButton jbDefaults = new JButton("Set Defaults");
        jbDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOConfig.this.doSetDefaults(false);
            }
        });
        settingsPanel.add(NBOUtil.createTitleBox(" Settings ", jbDefaults));
        this.jCheckAtomNum = new JCheckBox("Show Atom Numbers");
        this.jCheckAtomNum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOConfig.this.doSettingAtomNums();
            }
        });
        showAtNum = true;
        this.jCheckAtomNum.setSelected(true);
        Box settingsBox = NBOUtil.createBorderBox(true);
        settingsBox.add(this.jCheckAtomNum);
        this.jCheckSelHalo = new JCheckBox("Show selection halos on atoms");
        this.jCheckSelHalo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOConfig.this.doSettingShowHalos();
            }
        });
        this.jCheckSelHalo.doClick();
        settingsBox.add(this.jCheckSelHalo);
        this.jCheckWireMesh = new JCheckBox("Use wire mesh for orbital display");
        settingsBox.add(this.jCheckWireMesh);
        Color[] colors = new Color[]{Color.red, Color.orange, Color.yellow, Color.green, Color.cyan, Color.blue, Color.magenta};
        JPanel displayOps = new JPanel(new GridLayout(1, 4));
        JLabel label = new JLabel("     (+) color: ");
        displayOps.add(label);
        this.colorBox1 = new JComboBox<Color>(colors);
        this.colorBox1.setRenderer(new ColorRenderer());
        this.colorBox1.setSelectedItem(orbColor1);
        displayOps.add(this.colorBox1);
        this.colorBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                orbColor1 = (Color)NBOConfig.this.colorBox1.getSelectedItem();
                NBOConfig.this.setOrbitalDisplayOptions();
            }
        });
        displayOps.add(new JLabel("     (-) color: "));
        this.colorBox2 = new JComboBox<Color>(colors);
        this.colorBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                orbColor2 = (Color)NBOConfig.this.colorBox2.getSelectedItem();
                NBOConfig.this.setOrbitalDisplayOptions();
            }
        });
        this.colorBox2.setSelectedItem(orbColor2);
        this.colorBox2.setRenderer(new ColorRenderer());
        displayOps.add(this.colorBox2);
        displayOps.setAlignmentX(0.0f);
        settingsBox.add(displayOps);
        settingsBox.add(Box.createRigidArea(new Dimension(10, 10)));
        this.opacity.setMajorTickSpacing(1);
        this.opacity.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 10; ++i) {
            labelTable.put(new Integer(i), new JLabel(i == 10 ? "1" : "0." + i));
        }
        this.opacity.setPaintLabels(true);
        this.opacity.setLabelTable(labelTable);
        this.opacity.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                opacityOp = (float)NBOConfig.this.opacity.getValue() / 10.0f;
                NBOConfig.this.setOrbitalDisplayOptions();
            }
        });
        Box opacBox = Box.createHorizontalBox();
        opacBox.add(new JLabel("Orbital opacity:  "));
        opacBox.setAlignmentX(0.0f);
        opacBox.add(this.opacity);
        settingsBox.add(opacBox);
        this.jCheckWireMesh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOConfig.this.doSettingWireMesh();
            }
        });
        if (useWireMesh) {
            this.jCheckWireMesh.setSelected(true);
        }
        this.jCheckNboView = new JCheckBox("Emulate NBO View");
        this.jCheckNboView.setSelected(true);
        this.jCheckNboView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOConfig.this.doSetDefaults(!NBOConfig.this.jCheckNboView.isSelected());
            }
        });
        this.jCheckDebugVerbose = new JCheckBox("Verbose Debugging");
        settingsBox.add(this.jCheckDebugVerbose);
        this.jCheckDebugVerbose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                debugVerbose = ((JCheckBox)e.getSource()).isSelected();
            }
        });
        if (!"nboView".equals(viewOpts) && !"default".equals(viewOpts)) {
            this.jCheckNboView.doClick();
        } else {
            this.opacity.setValue((int)(opacityOp * 10.0f));
        }
        settingsBox.setBorder(BorderFactory.createLineBorder(Color.black));
        settingsPanel.add(settingsBox);
        return settingsPanel;
    }

    protected void doSettingShowHalos() {
        this.dialog.runScriptQueued("select " + this.jCheckSelHalo.isSelected());
    }

    protected void doSettingWireMesh() {
        useWireMesh = !useWireMesh;
        this.opacity.setValue(0);
    }

    protected void doSettingAtomNums() {
        showAtNum = !showAtNum;
        this.dialog.doSetStructure(null);
    }

    protected void doSetDefaults(boolean isJmol) {
        this.nboPlugin.setNBOProperty(NBOPROPERTY_DISPLAY_OPTIONS, "default");
        this.getOrbitalDisplayOptions();
        this.opacity.setValue((int)(opacityOp * 10.0f));
        this.colorBox1.setSelectedItem(orbColor1);
        this.colorBox2.setSelectedItem(orbColor2);
        this.jCheckWireMesh.setSelected(useWireMesh);
        this.jCheckAtomNum.setSelected(true);
        this.jCheckSelHalo.setSelected(true);
        this.jCheckDebugVerbose.setSelected(false);
        this.jCheckNboView.setSelected(false);
        if (isJmol) {
            if (!this.dialog.jmolOptionNONBO) {
                this.dialog.runScriptQueued("background gray;set defaultcolors Jmol;refresh;");
            }
        } else {
            if (this.jCheckWireMesh.isSelected()) {
                this.jCheckWireMesh.doClick();
            }
            this.colorBox1.setSelectedItem(Color.cyan);
            this.colorBox2.setSelectedItem(Color.yellow);
            this.opacity.setValue(7);
            try {
                String atomColors = "";
                atomColors = GuiMap.getResourceString((Object)this, (String)"org/gennbo/assets/atomColors.txt");
                this.dialog.runScriptQueued(atomColors + ";refresh");
            }
            catch (IOException e) {
                this.dialog.logError("atomColors.txt not found");
            }
            nboView = true;
        }
        this.dialog.updatePanelSettings();
    }

    protected void setOrbitalDisplayOptions() {
        orbColorJmol1 = "[" + orbColor1.getRed() + " " + orbColor1.getGreen() + " " + orbColor1.getBlue() + "]";
        orbColorJmol2 = "[" + orbColor2.getRed() + " " + orbColor2.getGreen() + " " + orbColor2.getBlue() + "]";
        this.dialog.updatePanelSettings();
        if (!nboView) {
            this.nboPlugin.setNBOProperty(NBOPROPERTY_DISPLAY_OPTIONS, orbColor1.getRGB() + "," + orbColor2.getRGB() + "," + opacityOp + "," + useWireMesh);
        }
    }

    private String getOrbitalDisplayOptions() {
        String options;
        String string = options = this.dialog.jmolOptionNONBO ? "jmol" : this.nboPlugin.getNBOProperty(NBOPROPERTY_DISPLAY_OPTIONS, "default");
        if (options.equals("default") || options.equals("nboView")) {
            orbColor1 = Color.cyan;
            orbColor2 = Color.yellow;
            opacityOp = 0.7f;
            useWireMesh = false;
        } else if (options.equals("jmol")) {
            orbColor1 = Color.blue;
            orbColor2 = Color.red;
            opacityOp = 1.0f;
            useWireMesh = true;
        } else {
            String[] toks = options.split(",");
            orbColor1 = new Color(Integer.parseInt(toks[0]));
            orbColor2 = new Color(Integer.parseInt(toks[1]));
            opacityOp = Float.parseFloat(toks[2]);
            useWireMesh = toks[3].contains("true");
        }
        return options;
    }

    protected static String getJmolIsosurfaceScript(String id, String type, int orbitalNumber, boolean isBeta, boolean isNegative) {
        return ";select 1.1;isosurface ID \"" + id + "\" color " + (isNegative ? orbColorJmol1 + " " + orbColorJmol2 : orbColorJmol2 + " " + orbColorJmol1) + " cutoff 0.0316 NBO " + type + " " + orbitalNumber + (isBeta && !type.equals("MO") ? " beta" : "") + " frontonly " + (useWireMesh ? " mesh nofill" : " nomesh fill translucent " + (1.0f - opacityOp)) + ";select none;";
    }

    private void addPathSetting(JPanel panel, final int mode) {
        String title = "";
        String path = "";
        switch (mode) {
            case 0: {
                title = " NBOPro Executables Folder ";
                path = this.nboService.getServerPath(null);
                break;
            }
            case 1: {
                title = " User Work Folder ";
                path = this.dialog.getWorkingPath();
            }
        }
        final JTextField tfPath = new JTextField(path);
        tfPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOConfig.this.doSetNBOPath(tfPath, mode);
            }
        });
        panel.add(NBOUtil.createTitleBox(title, null));
        Box serverBox = NBOUtil.createBorderBox(true);
        serverBox.add(this.createPathBox(tfPath, mode));
        serverBox.setMaximumSize(new Dimension(350, 50));
        panel.add(serverBox);
    }

    protected void doSetNBOPath(JTextField tf, int mode) {
        String path = PT.rep(tf.getText(), "\\", "/");
        if (path.length() == 0) {
            return;
        }
        switch (mode) {
            case 0: {
                this.nboService.setServerPath(path);
                this.dialog.log("NBOServe location changed changed:<br> " + path, 'b');
                this.connect();
                break;
            }
            case 1: {
                if ((path + "/").equals(this.nboService.getServerPath(null))) {
                    this.vwr.alert("The working directory may not be the same as the directory containing NBOServe");
                    return;
                }
                this.nboPlugin.setNBOProperty("workingPath", path);
                this.dialog.log("Working path directory changed:<br> " + path, 'b');
            }
        }
    }

    protected boolean connect() {
        if (!this.nboService.haveGenNBO()) {
            return false;
        }
        boolean isOK = this.dialog.checkEnabled();
        if (isOK) {
            this.dialog.icon.setText("Connected");
        }
        return isOK;
    }

    private void checkNBOStatus() {
        if (this.dialog.jmolOptionNONBO) {
            return;
        }
        if (!this.nboService.restartIfNecessary()) {
            String s = "Could not connect to NBOServe. Check to make sure its path is correct. \nIf it is already running from another instance of Jmol, you must first close that instance.";
            this.dialog.alertError(s);
        }
    }

    private Box createPathBox(final JTextField tf, final int mode) {
        Box box = Box.createHorizontalBox();
        box.add(tf);
        JButton b = new JButton("Browse");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOConfig.this.doPathBrowseClicked(tf, tf.getText(), mode);
            }
        });
        box.add(b);
        return box;
    }

    protected void doPathBrowseClicked(JTextField tf, String fname, int mode) {
        JFileChooser myChooser = new JFileChooser();
        myChooser.setFileSelectionMode(1);
        myChooser.setSelectedFile(new File(fname + "/ "));
        int button = myChooser.showDialog(this.dialog, GT.$("Select"));
        if (button == 0) {
            File newFile = myChooser.getSelectedFile();
            tf.setText(PT.rep(newFile.toString(), "\\", "/"));
            tf.postActionEvent();
        }
    }

    static {
        statusFont = searchOpListFont = new Font("Arial", 1, 14);
        iconFont = searchTextAreaFont = new Font("Arial", 0, 16);
        nboFont = new Font("Arial", 1, 16);
        homeTextFont = new Font("Arial", 3, 16);
        titleFont = new Font("Arial", 3, 18);
        runButtonFont = new Font("Arial", 0, 20);
        topFont = new Font("Arial", 1, 20);
        homeButtonFont = new Font("Arial", 3, 22);
        nboProTitleFont = nboFontLarge = new Font("Arial", 1, 26);
        titleColor = Color.blue;
    }

    class ColorRenderer
    extends JButton
    implements ListCellRenderer {
        boolean b = false;

        public ColorRenderer() {
            this.setOpaque(true);
        }

        @Override
        public void setBackground(Color bg) {
            if (!this.b) {
                return;
            }
            super.setBackground(bg);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.b = true;
            this.setText(" ");
            this.setBackground((Color)value);
            this.b = false;
            return this;
        }
    }
}

