/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javajs.util.AU;
import javajs.util.BS;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.shape.Mesh;
import org.jmol.shapespecial.Draw;
import org.jmol.util.BSUtil;
import org.jmol.viewer.Viewer;

public class DrawMesh
extends Mesh {
    public BS bsMeshesVisible;
    public BS modelFlags;
    public Draw.EnumDrawType drawType = Draw.EnumDrawType.NONE;
    Draw.EnumDrawType[] drawTypes;
    P3[] ptCenters;
    V3 axis = V3.new3(1.0f, 0.0f, 0.0f);
    V3[] axes;
    int drawVertexCount;
    int[] drawVertexCounts;
    boolean isFixed;
    public boolean isVector;
    public float drawArrowScale;
    public boolean noHead;
    public boolean isBarb;
    public float scale = 1.0f;
    public boolean isScaleSet;

    public DrawMesh(Viewer vwr, String thisID, short colix, int index) {
        this.bsMeshesVisible = new BS();
        this.mesh1(vwr, thisID, colix, index);
    }

    @Override
    public void clear(String meshType) {
        this.clearMesh(meshType);
        this.scale = 1.0f;
        this.isScaleSet = false;
    }

    void setCenters() {
        if (this.ptCenters == null) {
            this.setCenter(-1);
        } else {
            int i = this.ptCenters.length;
            while (--i >= 0) {
                this.setCenter(i);
            }
        }
    }

    final void setCenter(int iModel) {
        P3 center = P3.new3(0.0f, 0.0f, 0.0f);
        int iptlast = -1;
        int ipt = 0;
        int n = 0;
        int i = this.pc;
        while (--i >= 0) {
            int iV;
            if (iModel >= 0 && i != iModel || this.pis[i] == null) continue;
            iptlast = -1;
            int n2 = iV = this.drawType == Draw.EnumDrawType.POLYGON ? 3 : this.pis[i].length;
            while (--iV >= 0) {
                ipt = this.pis[i][iV];
                if (ipt == iptlast) continue;
                iptlast = ipt;
                center.add(this.vs[ipt]);
                ++n;
            }
            if (n <= 0 || i != iModel && i != 0) continue;
            center.scale(1.0f / (float)n);
            if (this.mat4 == null) break;
            this.mat4.rotTrans(center);
            break;
        }
        if (iModel < 0) {
            this.ptCenter.setT(center);
        } else {
            this.ptCenters[iModel] = center;
        }
    }

    void offset(V3 offset) {
        this.rotateTranslate(null, offset, false);
        this.setCenters();
    }

    public void deleteAtoms(int modelIndex) {
        if (modelIndex >= this.pc) {
            return;
        }
        --this.pc;
        this.pis = (int[][])AU.deleteElements(this.pis, modelIndex, 1);
        this.drawTypes = (Draw.EnumDrawType[])AU.deleteElements(this.drawTypes, modelIndex, 1);
        this.drawVertexCounts = (int[])AU.deleteElements(this.drawVertexCounts, modelIndex, 1);
        this.ptCenters = (P3[])AU.deleteElements(this.ptCenters, modelIndex, 1);
        this.axes = (V3[])AU.deleteElements(this.axes, modelIndex, 1);
        BS bs = BSUtil.newAndSetBit(modelIndex);
        BSUtil.deleteBits(this.modelFlags, bs);
    }

    public boolean isRenderScalable() {
        switch (this.drawType) {
            case ARROW: {
                return this.connectedAtoms != null;
            }
            case ARC: 
            case CIRCLE: 
            case CIRCULARPLANE: {
                return true;
            }
        }
        return this.haveXyPoints;
    }
}

