/****************************************************************************
**
*W  dt.h                        GAP source                  Wolfgang Merkwitz
**
**
*Y  Copyright (C)  1996,  Lehrstuhl D für Mathematik,  RWTH Aachen,  Germany
*Y  (C) 1998 School Math and Comp. Sci., University of St Andrews, Scotland
*Y  Copyright (C) 2002 The GAP Group
**
**  This file implements the part of the deep thought package which deals
**  with computing the deep thought polynomials. See dt.c for further
**  information.
*/

#ifndef libGAP_GAP_DT_H
#define libGAP_GAP_DT_H

extern void  libGAP_UnmarkTree(
                  libGAP_Obj   z );


extern libGAP_UInt   libGAP_Mark(
            libGAP_Obj   tree,
            libGAP_Obj   reftree,
            libGAP_Int   indexx  );


extern libGAP_Int     libGAP_AlmostEqual(
                     libGAP_Obj    tree1,
                     libGAP_Int    index1,
                     libGAP_Obj    tree2,
                     libGAP_Int    index2    );


extern libGAP_Int     libGAP_Equal(
               libGAP_Obj     tree1,
               libGAP_Int     index1,
               libGAP_Obj     tree2,
               libGAP_Int     index2   );



extern libGAP_Obj    libGAP_Mark2(
              libGAP_Obj        tree,
              libGAP_Int        index1,
              libGAP_Obj        reftree,
              libGAP_Int        index2   );


extern libGAP_UInt    libGAP_FindTree(
                 libGAP_Obj     tree,
                 libGAP_Int     indexx );


extern libGAP_Obj    libGAP_MakeFormulaVector(
                          libGAP_Obj    tree,
                          libGAP_Obj    pr   );


extern libGAP_Obj  libGAP_binomial(
               libGAP_Obj     n,
               libGAP_Obj     k    );


extern libGAP_Int     libGAP_Leftof(
                libGAP_Obj     tree1,
                libGAP_Int     index1,
                libGAP_Obj     tree2,
                libGAP_Int     index2    );



extern libGAP_Int    libGAP_Leftof2(
                libGAP_Obj    tree1,
                libGAP_Int    index1,
                libGAP_Obj    tree2,
                libGAP_Int    index2     );



extern libGAP_Int    libGAP_Earlier(
                libGAP_Obj    tree1,
                libGAP_Int    index1,
                libGAP_Obj    tree2,
                libGAP_Int    index2         );

extern void   libGAP_FindNewReps(
                    libGAP_Obj     tree,
                    libGAP_Obj     reps,
                    libGAP_Obj     pr,
                    libGAP_Obj     max      );



extern void  libGAP_FindSubs(
                libGAP_Obj        tree,
                libGAP_Int        x,
                libGAP_Obj        list1,
                libGAP_Obj        list2,
                libGAP_Obj        a,
                libGAP_Obj        b,
                libGAP_Int        al,
                libGAP_Int        ar,
                libGAP_Int        bl,
                libGAP_Int        br,
                libGAP_Obj        reps,
                libGAP_Obj        pr,
                libGAP_Obj        max       );



extern void    libGAP_SetSubs(
                 libGAP_Obj       list,
                 libGAP_Obj       a,
                 libGAP_Obj       tree    );



extern void    libGAP_UnmarkAEClass(
                       libGAP_Obj      tree,
                       libGAP_Obj      list  );


extern void    libGAP_TestTree(
                         libGAP_Obj     tree);


extern libGAP_Obj      libGAP_Part(
                      libGAP_Obj   list,
                      libGAP_Int   pos1,
                      libGAP_Int   pos2         );



/*
**  Functions from dteval.c.
*/
extern void libGAP_MultGen(
                    libGAP_Obj     xk,
                    libGAP_UInt    gen,
                    libGAP_Obj     power,
                    libGAP_Obj     pseudoreps    );

extern libGAP_Obj libGAP_Power(
                libGAP_Obj         x,
                libGAP_Obj         n,
                libGAP_Obj         pseudoreps     );


/****************************************************************************
**

*F * * * * * * * * * * * * * initialize package * * * * * * * * * * * * * * *
*/


/****************************************************************************
**

*F  InitInfoDeepThought() . . . . . . . . . . . . . . table of init functions
*/
libGAP_StructInitInfo * libGAP_InitInfoDeepThought ( void );


#endif // GAP_DT_H

/****************************************************************************
**

*E  dt.h  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
**
*/

