/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.jdbc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsDiff;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.jdbc.JDBCTreeTableView;
import org.netbeans.lib.profiler.ui.jdbc.JDBCView;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;

public abstract class SnapshotJDBCView
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.jdbc.Bundle");
    private static final String COMPARE_SNAPSHOTS = messages.getString("SnapshotJDBCView_CompareSnapshots");
    private static final String RESET_COMPARE_SNAPSHOTS = messages.getString("SnapshotJDBCView_ResetCompareSnapshots");
    private JdbcResultsSnapshot snapshot;
    private JdbcResultsSnapshot refSnapshot;
    private DataView lastFocused;
    private JDBCTreeTableView jdbcCallsView;
    private JToggleButton compareButton;
    private ExecutorService executor;

    public SnapshotJDBCView(JdbcResultsSnapshot jdbcResultsSnapshot, Action action, Action action2, Action action3, ExportUtils.Exportable exportable) {
        this.initUI(action, action2, action3, exportable);
        this.registerActions();
        this.setSnapshot(jdbcResultsSnapshot);
    }

    public void setRefSnapshot(JdbcResultsSnapshot jdbcResultsSnapshot) {
        this.refSnapshot = jdbcResultsSnapshot;
        if (this.compareButton != null && jdbcResultsSnapshot != null) {
            this.compareButton.setSelected(true);
            this.compareButton.setToolTipText(RESET_COMPARE_SNAPSHOTS);
        }
        this.setData();
    }

    protected abstract boolean showSourceSupported();

    protected abstract void showSource(ClientUtils.SourceCodeSelection var1);

    protected abstract void showSQLQuery(String var1, String var2);

    protected abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    private void profileMethod(ClientUtils.SourceCodeSelection sourceCodeSelection) {
        this.selectForProfiling(sourceCodeSelection);
    }

    private void profileClass(ClientUtils.SourceCodeSelection sourceCodeSelection) {
        this.selectForProfiling(new ClientUtils.SourceCodeSelection(sourceCodeSelection.getClassName(), "*", null));
    }

    private void initUI(Action action, final Action action2, Action action3, ExportUtils.Exportable exportable) {
        this.setLayout(new BorderLayout(0, 0));
        this.jdbcCallsView = new JDBCTreeTableView(null, false){

            @Override
            protected void installDefaultAction() {
                this.getResultsComponent().setDefaultAction(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n;
                        ProfilerTable profilerTable = this.getResultsComponent();
                        PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)profilerTable.getValueForRow(n = profilerTable.getSelectedRow());
                        if (JDBCTreeTableView.isSQL(presoObjAllocCCTNode)) {
                            SnapshotJDBCView.this.showQueryImpl(presoObjAllocCCTNode);
                        } else {
                            ClientUtils.SourceCodeSelection sourceCodeSelection = this.getUserValueForRow(n);
                            if (sourceCodeSelection != null) {
                                this.performDefaultAction(sourceCodeSelection);
                            }
                        }
                    }
                });
            }

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                if (SnapshotJDBCView.this.showSourceSupported()) {
                    SnapshotJDBCView.this.showSource(sourceCodeSelection);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
                SnapshotJDBCView.this.populatePopup(SnapshotJDBCView.this.jdbcCallsView, jPopupMenu, object, sourceCodeSelection);
            }
        };
        this.jdbcCallsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                SnapshotJDBCView.this.lastFocused = SnapshotJDBCView.this.jdbcCallsView;
            }
        });
        this.add((Component)this.jdbcCallsView, "Center");
        ProfilerToolbar profilerToolbar = ProfilerToolbar.create(true);
        if (action != null) {
            profilerToolbar.add(action);
        }
        profilerToolbar.add(ExportUtils.exportButton(this, JDBCView.EXPORT_TOOLTIP, this.getExportables(exportable)));
        if (action2 != null) {
            profilerToolbar.addSpace(2);
            profilerToolbar.addSeparator();
            profilerToolbar.addSpace(2);
            Icon icon = (Icon)action2.getValue("SmallIcon");
            this.compareButton = new JToggleButton(icon){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    boolean bl = this.isSelected();
                    if (bl) {
                        action2.actionPerformed(actionEvent);
                        if (SnapshotJDBCView.this.refSnapshot == null) {
                            this.setSelected(false);
                        }
                    } else {
                        SnapshotJDBCView.this.setRefSnapshot(null);
                    }
                    this.setToolTipText(this.isSelected() ? RESET_COMPARE_SNAPSHOTS : COMPARE_SNAPSHOTS);
                }
            };
            this.compareButton.setToolTipText(COMPARE_SNAPSHOTS);
            profilerToolbar.add(this.compareButton);
        }
        if (action3 != null) {
            profilerToolbar.addFiller();
            profilerToolbar.add(action3);
        }
        this.add((Component)profilerToolbar.getComponent(), "North");
    }

    private void registerActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataView dataView = SnapshotJDBCView.this.getLastFocused();
                if (dataView != null) {
                    dataView.activateFilter();
                }
            }
        });
        actionMap.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataView dataView = SnapshotJDBCView.this.getLastFocused();
                if (dataView != null) {
                    dataView.activateSearch();
                }
            }
        });
    }

    private DataView getLastFocused() {
        if (this.lastFocused != null && !this.lastFocused.isShowing()) {
            this.lastFocused = null;
        }
        if (this.lastFocused == null && this.jdbcCallsView.isShowing()) {
            this.lastFocused = this.jdbcCallsView;
        }
        return this.lastFocused;
    }

    private void showQueryImpl(PresoObjAllocCCTNode presoObjAllocCCTNode) {
        this.showSQLQuery(presoObjAllocCCTNode.getNodeName(), ((JDBCTreeTableView.SQLQueryNode)presoObjAllocCCTNode).htmlName);
    }

    private void populatePopup(final DataView dataView, JPopupMenu jPopupMenu, final Object object, final ClientUtils.SourceCodeSelection sourceCodeSelection) {
        final PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)object;
        if (JDBCTreeTableView.isSQL(presoObjAllocCCTNode)) {
            jPopupMenu.add(new JMenuItem(JDBCView.ACTION_VIEWSQLQUERY){
                {
                    super(string);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    SnapshotJDBCView.this.showQueryImpl((JDBCTreeTableView.SQLQueryNode)((Object)object));
                }
            });
            jPopupMenu.addSeparator();
        } else if (this.showSourceSupported()) {
            jPopupMenu.add(new JMenuItem(JDBCView.ACTION_GOTOSOURCE){
                {
                    super(string);
                    this.setEnabled(sourceCodeSelection != null);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    SnapshotJDBCView.this.showSource(sourceCodeSelection);
                }
            });
            jPopupMenu.addSeparator();
        }
        jPopupMenu.add(new JMenuItem(JDBCView.ACTION_PROFILE_METHOD){
            {
                super(string);
                this.setEnabled(sourceCodeSelection != null && JDBCTreeTableView.isSelectable(presoObjAllocCCTNode));
            }

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                SnapshotJDBCView.this.profileMethod(sourceCodeSelection);
            }
        });
        jPopupMenu.add(new JMenuItem(JDBCView.ACTION_PROFILE_CLASS){
            {
                super(string);
                this.setEnabled(sourceCodeSelection != null);
            }

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                SnapshotJDBCView.this.profileClass(sourceCodeSelection);
            }
        });
        this.customizeNodePopup(dataView, jPopupMenu, object, sourceCodeSelection);
        jPopupMenu.addSeparator();
        final ProfilerTreeTable profilerTreeTable = (ProfilerTreeTable)this.jdbcCallsView.getResultsComponent();
        JMenu jMenu = new JMenu(JDBCView.EXPAND_MENU);
        jPopupMenu.add(jMenu);
        jMenu.add(new JMenuItem(JDBCView.EXPAND_PLAIN_ITEM){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                profilerTreeTable.expandPlainPath(profilerTreeTable.getSelectedRow(), 1);
            }
        });
        jMenu.add(new JMenuItem(JDBCView.EXPAND_TOPMOST_ITEM){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                profilerTreeTable.expandFirstPath(profilerTreeTable.getSelectedRow());
            }
        });
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(JDBCView.COLLAPSE_CHILDREN_ITEM){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                profilerTreeTable.collapseChildren(profilerTreeTable.getSelectedRow());
            }
        });
        jMenu.add(new JMenuItem(JDBCView.COLLAPSE_ALL_ITEM){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                profilerTreeTable.collapseAll();
            }
        });
        jPopupMenu.addSeparator();
        jPopupMenu.add(dataView.createCopyMenuItem());
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem(FilterUtils.ACTION_FILTER){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                dataView.activateFilter();
            }
        });
        jPopupMenu.add(new JMenuItem(SearchUtils.ACTION_FIND){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                dataView.activateSearch();
            }
        });
    }

    protected void customizeNodePopup(DataView dataView, JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
    }

    private void setData() {
        this.getExecutor().submit(new Runnable(){

            @Override
            public void run() {
                final JdbcResultsSnapshot jdbcResultsSnapshot = SnapshotJDBCView.this.refSnapshot == null ? SnapshotJDBCView.this.snapshot : SnapshotJDBCView.this.snapshot.createDiff(SnapshotJDBCView.this.refSnapshot);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean bl = jdbcResultsSnapshot instanceof JdbcResultsDiff;
                        SnapshotJDBCView.this.jdbcCallsView.setData(jdbcResultsSnapshot, null, -1, null, false, false, bl);
                    }
                });
            }
        });
    }

    protected final void setSnapshot(JdbcResultsSnapshot jdbcResultsSnapshot) {
        this.snapshot = jdbcResultsSnapshot;
        this.setData();
    }

    private ExportUtils.Exportable[] getExportables(final ExportUtils.Exportable exportable) {
        return new ExportUtils.Exportable[]{new ExportUtils.Exportable(){

            @Override
            public boolean isEnabled() {
                return SnapshotJDBCView.this.refSnapshot == null && exportable.isEnabled();
            }

            @Override
            public String getName() {
                return exportable.getName();
            }

            @Override
            public ExportUtils.ExportProvider[] getProviders() {
                return exportable.getProviders();
            }
        }, new ExportUtils.Exportable(){

            @Override
            public boolean isEnabled() {
                return SnapshotJDBCView.this.jdbcCallsView.isVisible();
            }

            @Override
            public String getName() {
                return MessageFormat.format(JDBCView.EXPORT_LBL, JDBCView.EXPORT_QUERIES);
            }

            @Override
            public ExportUtils.ExportProvider[] getProviders() {
                return SnapshotJDBCView.this.jdbcCallsView.getExportProviders();
            }
        }};
    }

    private synchronized ExecutorService getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        return this.executor;
    }
}

