/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.features;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.filters.JavaTypeFilter;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.lib.profiler.ui.swing.SmallButton;
import org.netbeans.lib.profiler.ui.swing.TextArea;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.project.ProjectContentsSupport;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.features.Bundle;
import org.netbeans.modules.profiler.v2.features.FeatureMode;
import org.netbeans.modules.profiler.v2.impl.ClassMethodList;
import org.netbeans.modules.profiler.v2.impl.ClassMethodSelector;
import org.netbeans.modules.profiler.v2.impl.ProjectsSelector;
import org.netbeans.modules.profiler.v2.ui.SettingsPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

final class ObjectsFeatureModes {
    ObjectsFeatureModes() {
    }

    private static Component createStrut(JComponent jComponent, int n, boolean bl) {
        Insets insets;
        Border border = jComponent.getBorder();
        Insets insets2 = insets = border != null ? border.getBorderInsets(jComponent) : null;
        int n2 = insets == null ? n : Math.max(n - (bl ? insets.left : insets.right), 0);
        return Box.createHorizontalStrut(n2);
    }

    static abstract class CustomClassesMode
    extends MemoryMode {
        private static final String LIFECYCLE_FLAG = "LIFECYCLE_FLAG";
        private static final String ALLOCATIONS_FLAG = "ALLOCATIONS_FLAG";
        private static final String LIMIT_ALLOCATIONS_FLAG = "LIMIT_ALLOCATIONS_FLAG";
        private static final String CLASSES_FLAG = "SELECTION_FLAG";
        private static final int MIN_ROWS = 1;
        private static final int MAX_ROWS = 15;
        private static final int DEFAULT_ROWS = 3;
        private static final int MIN_COLUMNS = 10;
        private static final int MAX_COLUMNS = 100;
        private static final int DEFAULT_COLUMNS = 40;
        private static final Integer LIMIT_ALLOCATIONS_DEFAULT = 10;
        private JComponent ui;
        private TextArea classesArea;
        private JCheckBox lifecycleCheckbox;
        private JCheckBox outgoingCheckbox;
        private JSpinner outgoingSpinner;

        CustomClassesMode() {
        }

        @Override
        String getID() {
            return "CustomMethodsMode";
        }

        @Override
        String getName() {
            return Bundle.ObjectsFeatureModes_definedClasses();
        }

        @Override
        void configureSettings(ProfilingSettings profilingSettings) {
            assert (SwingUtilities.isEventDispatchThread());
            super.configureSettings(profilingSettings);
            String string = CustomClassesMode.getFlatValues(this.readFlag(CLASSES_FLAG, "").split("\\n"));
            profilingSettings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter(string, 10));
            boolean bl = Boolean.parseBoolean(this.readFlag(LIFECYCLE_FLAG, Boolean.TRUE.toString()));
            profilingSettings.setProfilingType(bl ? 4 : 2);
            boolean bl2 = Boolean.parseBoolean(this.readFlag(ALLOCATIONS_FLAG, Boolean.TRUE.toString()));
            int n = Integer.parseInt(this.readFlag(LIMIT_ALLOCATIONS_FLAG, LIMIT_ALLOCATIONS_DEFAULT.toString()));
            profilingSettings.setAllocStackTraceLimit(!bl2 ? -10 : n);
        }

        @Override
        void confirmSettings() {
            if (this.ui != null && this.classesArea != null) {
                assert (SwingUtilities.isEventDispatchThread());
                String string = this.classesArea.showsHint() ? "" : this.classesArea.getText().trim();
                this.storeFlag(CLASSES_FLAG, string.isEmpty() ? null : string);
                this.storeFlag(LIFECYCLE_FLAG, this.lifecycleCheckbox.isSelected() ? null : Boolean.FALSE.toString());
                this.storeFlag(ALLOCATIONS_FLAG, this.outgoingCheckbox.isSelected() ? null : Boolean.FALSE.toString());
                String string2 = ((Integer)this.outgoingSpinner.getValue()).toString();
                boolean bl = LIMIT_ALLOCATIONS_DEFAULT.equals(string2);
                this.storeFlag(LIMIT_ALLOCATIONS_FLAG, bl ? null : string2);
            }
        }

        @Override
        boolean pendingChanges() {
            if (this.ui != null) {
                int n;
                boolean bl;
                boolean bl2;
                String string;
                assert (SwingUtilities.isEventDispatchThread());
                String string2 = string = this.classesArea.showsHint() ? "" : this.classesArea.getText().trim();
                if (!string.equals(this.readFlag(CLASSES_FLAG, ""))) {
                    return true;
                }
                boolean bl3 = this.lifecycleCheckbox.isSelected();
                if (bl3 != (bl2 = Boolean.parseBoolean(this.readFlag(LIFECYCLE_FLAG, Boolean.TRUE.toString())))) {
                    return true;
                }
                boolean bl4 = this.outgoingCheckbox.isSelected();
                if (bl4 != (bl = Boolean.parseBoolean(this.readFlag(ALLOCATIONS_FLAG, Boolean.TRUE.toString())))) {
                    return true;
                }
                int n2 = Integer.parseInt(this.readFlag(LIMIT_ALLOCATIONS_FLAG, LIMIT_ALLOCATIONS_DEFAULT.toString()));
                if (n2 != (n = ((Integer)this.outgoingSpinner.getValue()).intValue())) {
                    return true;
                }
            }
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            assert (SwingUtilities.isEventDispatchThread());
            return !(this.ui != null ? this.classesArea.showsHint() || this.classesArea.getText().trim().isEmpty() : this.readFlag(CLASSES_FLAG, "").isEmpty());
        }

        private static String getFlatValues(String[] stringArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].trim();
                if (i != stringArray.length - 1 && !string.endsWith(",")) {
                    string = string + ",";
                }
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }

        @Override
        JComponent getUI() {
            if (this.ui == null) {
                JFormattedTextField jFormattedTextField;
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.setOpaque(false);
                SettingsPanel settingsPanel = new SettingsPanel();
                settingsPanel.add(new JLabel(Bundle.ObjectsFeatureModes_classesLbl()));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 5);
                gridBagConstraints.anchor = 18;
                jPanel.add((Component)settingsPanel, gridBagConstraints);
                final JScrollPane[] jScrollPaneArray = new JScrollPane[1];
                this.classesArea = new TextArea(this.readFlag(CLASSES_FLAG, "")){

                    protected void changed() {
                        CustomClassesMode.this.settingsChanged();
                    }

                    protected boolean changeSize(boolean bl, boolean bl2) {
                        if (bl) {
                            int n = CustomClassesMode.this.readRows();
                            n = bl2 ? Math.min(n + 1, 15) : Math.max(n - 1, 1);
                            CustomClassesMode.this.storeRows(n);
                        } else {
                            int n = CustomClassesMode.this.readColumns();
                            n = bl2 ? Math.min(n + 3, 100) : Math.max(n - 3, 10);
                            CustomClassesMode.this.storeColumns(n);
                        }
                        this.layoutImpl();
                        return true;
                    }

                    protected boolean resetSize() {
                        CustomClassesMode.this.storeRows(3);
                        CustomClassesMode.this.storeColumns(40);
                        this.layoutImpl();
                        return true;
                    }

                    private void layoutImpl() {
                        this.setRows(CustomClassesMode.this.readRows());
                        this.setColumns(CustomClassesMode.this.readColumns());
                        jScrollPaneArray[0].setPreferredSize(null);
                        jScrollPaneArray[0].setPreferredSize(jScrollPaneArray[0].getPreferredSize());
                        jScrollPaneArray[0].setMinimumSize(jScrollPaneArray[0].getPreferredSize());
                        JRootPane jRootPane = SwingUtilities.getRootPane(jScrollPaneArray[0]);
                        jRootPane.doLayout();
                        jRootPane.repaint();
                        this.setColumns(0);
                    }

                    protected void customizePopup(JPopupMenu jPopupMenu) {
                        jPopupMenu.addSeparator();
                        jPopupMenu.add(this.createResizeMenu());
                    }

                    public Point getToolTipLocation(MouseEvent mouseEvent) {
                        Container container = this.getParent().getParent();
                        return SwingUtilities.convertPoint(container, 0, container.getHeight(), (Component)((Object)this));
                    }
                };
                this.classesArea.setFont(new Font("Monospaced", 0, this.classesArea.getFont().getSize()));
                this.classesArea.setRows(this.readRows());
                this.classesArea.setColumns(this.readColumns());
                jScrollPaneArray[0] = new JScrollPane((Component)this.classesArea);
                jScrollPaneArray[0].setPreferredSize(jScrollPaneArray[0].getPreferredSize());
                jScrollPaneArray[0].setMinimumSize(jScrollPaneArray[0].getPreferredSize());
                this.classesArea.setColumns(0);
                this.classesArea.setHint(Bundle.ObjectsFeatureModes_classesHint());
                this.classesArea.setToolTipText(Bundle.ObjectsFeatureModes_classesTooltip());
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 3;
                gridBagConstraints.insets = new Insets(0, 0, 0, 5);
                gridBagConstraints.anchor = 18;
                jPanel.add((Component)jScrollPaneArray[0], gridBagConstraints);
                SettingsPanel settingsPanel2 = new SettingsPanel();
                settingsPanel2.add(Box.createHorizontalStrut(4));
                Component component = Box.createHorizontalStrut(1);
                component.setBackground(Color.GRAY);
                if (component instanceof JComponent) {
                    ((JComponent)component).setOpaque(true);
                }
                Dimension dimension = component.getMaximumSize();
                dimension.height = 20;
                component.setMaximumSize(dimension);
                settingsPanel2.add(component);
                boolean bl = Boolean.parseBoolean(this.readFlag(LIFECYCLE_FLAG, Boolean.TRUE.toString()));
                this.lifecycleCheckbox = new JCheckBox(Bundle.ObjectsFeatureModes_recordLifecycle(), bl){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        CustomClassesMode.this.settingsChanged();
                    }
                };
                this.lifecycleCheckbox.setToolTipText(Bundle.ObjectsFeatureModes_profileAllObjectsToolTip());
                this.lifecycleCheckbox.setOpaque(false);
                settingsPanel2.add(ObjectsFeatureModes.createStrut(this.lifecycleCheckbox, 8, true));
                settingsPanel2.add(this.lifecycleCheckbox);
                settingsPanel2.add(ObjectsFeatureModes.createStrut(this.lifecycleCheckbox, 5, false));
                if (UIUtils.isOracleLookAndFeel()) {
                    jPanel.add(Box.createHorizontalStrut(4));
                }
                GrayLabel grayLabel = new GrayLabel(Bundle.ObjectsFeatureModes_lblUnlimited());
                GrayLabel grayLabel2 = new GrayLabel(Bundle.ObjectsFeatureModes_lblNoAllocations());
                boolean bl2 = Boolean.parseBoolean(this.readFlag(ALLOCATIONS_FLAG, Boolean.TRUE.toString()));
                this.outgoingCheckbox = new JCheckBox(Bundle.ObjectsFeatureModes_limitAllocations(), bl2, (JLabel)grayLabel, (JLabel)grayLabel2){
                    final /* synthetic */ JLabel val$unlimited;
                    final /* synthetic */ JLabel val$noAllocs;
                    {
                        this.val$unlimited = jLabel;
                        this.val$noAllocs = jLabel2;
                        super(string, bl);
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        boolean bl = this.isSelected();
                        this.val$unlimited.setVisible(!bl);
                        CustomClassesMode.this.outgoingSpinner.setVisible(bl);
                        this.val$noAllocs.setVisible(bl && (Integer)CustomClassesMode.this.outgoingSpinner.getValue() == 0);
                        CustomClassesMode.this.settingsChanged();
                    }
                };
                this.outgoingCheckbox.setToolTipText(Bundle.ObjectsFeatureModes_collectFullStacksToolTip());
                this.outgoingCheckbox.setOpaque(false);
                settingsPanel2.add(this.outgoingCheckbox);
                settingsPanel2.add(ObjectsFeatureModes.createStrut(this.outgoingCheckbox, 5, false));
                if (UIUtils.isOracleLookAndFeel()) {
                    settingsPanel2.add(Box.createHorizontalStrut(4));
                }
                grayLabel.setVisible(!this.outgoingCheckbox.isSelected());
                settingsPanel2.add((Component)grayLabel);
                int n = Integer.parseInt(this.readFlag(LIMIT_ALLOCATIONS_FLAG, LIMIT_ALLOCATIONS_DEFAULT.toString()));
                this.outgoingSpinner = new JExtendedSpinner(new SpinnerNumberModel(Math.abs(n), 0, 99, 1)){

                    public Dimension getPreferredSize() {
                        return this.getMinimumSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getMinimumSize();
                    }

                    protected void fireStateChanged() {
                        CustomClassesMode.this.settingsChanged();
                        super.fireStateChanged();
                    }
                };
                this.outgoingSpinner.setToolTipText(Bundle.ObjectsFeatureModes_limitAllocationsDepthToolTip());
                JComponent jComponent = this.outgoingSpinner.getEditor();
                JFormattedTextField jFormattedTextField2 = jFormattedTextField = jComponent instanceof JSpinner.DefaultEditor ? ((JSpinner.DefaultEditor)jComponent).getTextField() : null;
                if (jFormattedTextField != null) {
                    jFormattedTextField.getDocument().addDocumentListener(new DocumentListener((JLabel)grayLabel2){
                        final /* synthetic */ JLabel val$noAllocs;
                        {
                            this.val$noAllocs = jLabel;
                        }

                        @Override
                        public void insertUpdate(DocumentEvent documentEvent) {
                            this.change();
                        }

                        @Override
                        public void removeUpdate(DocumentEvent documentEvent) {
                            this.change();
                        }

                        @Override
                        public void changedUpdate(DocumentEvent documentEvent) {
                            this.change();
                        }

                        private void change() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    val$noAllocs.setVisible(CustomClassesMode.this.outgoingSpinner.isVisible() && (Integer)CustomClassesMode.this.outgoingSpinner.getValue() == 0);
                                }
                            });
                        }
                    });
                }
                this.outgoingSpinner.setVisible(this.outgoingCheckbox.isSelected());
                settingsPanel2.add(this.outgoingSpinner);
                settingsPanel2.add(Box.createHorizontalStrut(5));
                grayLabel2.setVisible(this.outgoingSpinner.isVisible() && (Integer)this.outgoingSpinner.getValue() == 0);
                settingsPanel2.add((Component)grayLabel2);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagConstraints.anchor = 18;
                jPanel.add((Component)settingsPanel2, gridBagConstraints);
                this.ui = jPanel;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CustomClassesMode.this.settingsChanged();
                    }
                });
            }
            return this.ui;
        }

        private int readRows() {
            return NbPreferences.forModule(ObjectsFeatureModes.class).getInt("ObjectsFeatureModes.rows", 3);
        }

        private void storeRows(int n) {
            NbPreferences.forModule(ObjectsFeatureModes.class).putInt("ObjectsFeatureModes.rows", n);
        }

        private int readColumns() {
            return NbPreferences.forModule(ObjectsFeatureModes.class).getInt("ObjectsFeatureModes.columns", 40);
        }

        private void storeColumns(int n) {
            NbPreferences.forModule(ObjectsFeatureModes.class).putInt("ObjectsFeatureModes.columns", n);
        }
    }

    static abstract class SelectedClassesMode
    extends MemoryMode {
        private static final String LIFECYCLE_FLAG = "LIFECYCLE_FLAG";
        private static final String ALLOCATIONS_FLAG = "ALLOCATIONS_FLAG";
        private static final String LIMIT_ALLOCATIONS_FLAG = "LIMIT_ALLOCATIONS_FLAG";
        private static final String SELECTION_FLAG = "SELECTION_FLAG";
        private static final Integer LIMIT_ALLOCATIONS_DEFAULT = 10;
        private FeatureMode.Selection selection;
        private JComponent ui;
        private JPanel selectionContent;
        private JPanel noSelectionContent;
        private JCheckBox lifecycleCheckbox;
        private JButton addSelectionButton;
        private JButton editSelectionLink;
        private JCheckBox outgoingCheckbox;
        private JSpinner outgoingSpinner;

        SelectedClassesMode() {
        }

        abstract void selectionChanging();

        abstract void selectionChanged();

        abstract ProfilerSession getSession();

        abstract void selectForProfiling(Collection<SourceClassInfo> var1);

        @Override
        String getID() {
            return "SelectedClassesMode";
        }

        @Override
        String getName() {
            return Bundle.ObjectsFeatureModes_selectedClasses();
        }

        @Override
        void configureSettings(ProfilingSettings profilingSettings) {
            assert (SwingUtilities.isEventDispatchThread());
            super.configureSettings(profilingSettings);
            boolean bl = Boolean.parseBoolean(this.readFlag(LIFECYCLE_FLAG, Boolean.TRUE.toString()));
            profilingSettings.setProfilingType(bl ? 4 : 2);
            boolean bl2 = Boolean.parseBoolean(this.readFlag(ALLOCATIONS_FLAG, Boolean.TRUE.toString()));
            int n = Integer.parseInt(this.readFlag(LIMIT_ALLOCATIONS_FLAG, LIMIT_ALLOCATIONS_DEFAULT.toString()));
            profilingSettings.setAllocStackTraceLimit(!bl2 ? -10 : n);
            StringBuilder stringBuilder = new StringBuilder();
            HashSet<ClientUtils.SourceCodeSelection> hashSet = this.getSelection();
            ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = hashSet.toArray(new ClientUtils.SourceCodeSelection[0]);
            for (int i = 0; i < sourceCodeSelectionArray.length; ++i) {
                stringBuilder.append(sourceCodeSelectionArray[i].getClassName());
                if (i >= sourceCodeSelectionArray.length - 1) continue;
                stringBuilder.append(", ");
            }
            JavaTypeFilter javaTypeFilter = new JavaTypeFilter(stringBuilder.toString(), 10);
            profilingSettings.setInstrumentationFilter((GenericFilter)javaTypeFilter);
        }

        @Override
        void confirmSettings() {
            if (this.ui != null) {
                assert (SwingUtilities.isEventDispatchThread());
                this.storeFlag(LIFECYCLE_FLAG, this.lifecycleCheckbox.isSelected() ? null : Boolean.FALSE.toString());
                this.storeFlag(ALLOCATIONS_FLAG, this.outgoingCheckbox.isSelected() ? null : Boolean.FALSE.toString());
                String string = ((Integer)this.outgoingSpinner.getValue()).toString();
                boolean bl = LIMIT_ALLOCATIONS_DEFAULT.equals(string);
                this.storeFlag(LIMIT_ALLOCATIONS_FLAG, bl ? null : string);
                this.saveSelection();
            }
        }

        @Override
        boolean pendingChanges() {
            if (this.ui != null) {
                int n;
                boolean bl;
                boolean bl2;
                assert (SwingUtilities.isEventDispatchThread());
                boolean bl3 = this.lifecycleCheckbox.isSelected();
                if (bl3 != (bl2 = Boolean.parseBoolean(this.readFlag(LIFECYCLE_FLAG, Boolean.TRUE.toString())))) {
                    return true;
                }
                boolean bl4 = this.outgoingCheckbox.isSelected();
                if (bl4 != (bl = Boolean.parseBoolean(this.readFlag(ALLOCATIONS_FLAG, Boolean.TRUE.toString())))) {
                    return true;
                }
                int n2 = Integer.parseInt(this.readFlag(LIMIT_ALLOCATIONS_FLAG, LIMIT_ALLOCATIONS_DEFAULT.toString()));
                if (n2 != (n = ((Integer)this.outgoingSpinner.getValue()).intValue())) {
                    return true;
                }
                if (!this.initSelection(false).equals(this.getSelection())) {
                    return true;
                }
            }
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            assert (SwingUtilities.isEventDispatchThread());
            return !this.getSelection().isEmpty();
        }

        HashSet<ClientUtils.SourceCodeSelection> getSelection() {
            if (this.selection == null) {
                this.selection = this.initSelection(true);
            }
            return this.selection;
        }

        private FeatureMode.Selection initSelection(boolean bl) {
            FeatureMode.Selection selection = new FeatureMode.Selection(){

                @Override
                protected void changing() {
                    SelectedClassesMode.this.selectionChanging();
                }

                @Override
                protected void changed() {
                    SelectedClassesMode.this.selectionChanged();
                    SelectedClassesMode.this.updateSelectionCustomizer();
                }
            };
            selection.disableEvents();
            String string = this.readFlag(SELECTION_FLAG, null);
            if (string != null) {
                for (String string2 : string.split(" ")) {
                    selection.add(ClientUtils.stringToSelection((String)string2));
                }
            }
            if (bl) {
                selection.enableEvents();
            }
            return selection;
        }

        private void saveSelection() {
            if (this.selection != null) {
                StringBuilder stringBuilder = new StringBuilder();
                for (ClientUtils.SourceCodeSelection sourceCodeSelection : this.selection) {
                    stringBuilder.append(ClientUtils.selectionToString((ClientUtils.SourceCodeSelection)sourceCodeSelection));
                    stringBuilder.append(" ");
                }
                String string = stringBuilder.toString();
                this.storeFlag(SELECTION_FLAG, string.isEmpty() ? null : string);
            }
        }

        @Override
        JComponent getUI() {
            if (this.ui == null) {
                JFormattedTextField jFormattedTextField;
                this.ui = new SettingsPanel();
                this.selectionContent = new SettingsPanel();
                this.editSelectionLink = new JButton(){

                    @Override
                    public void setText(String string) {
                        super.setText(Bundle.ObjectsFeatureModes_editLink(string));
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        ClassMethodList.showClasses(SelectedClassesMode.this.getSession(), SelectedClassesMode.this.selection, SelectedClassesMode.this.ui);
                    }

                    @Override
                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    @Override
                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.editSelectionLink.setContentAreaFilled(false);
                this.editSelectionLink.setBorderPainted(true);
                this.editSelectionLink.setMargin(new Insets(0, 0, 0, 0));
                this.editSelectionLink.setBorder(BorderFactory.createEmptyBorder());
                this.editSelectionLink.setCursor(Cursor.getPredefinedCursor(12));
                this.selectionContent.add(this.editSelectionLink);
                this.selectionContent.add(Box.createHorizontalStrut(8));
                Component component = Box.createHorizontalStrut(1);
                component.setBackground(Color.GRAY);
                if (component instanceof JComponent) {
                    ((JComponent)component).setOpaque(true);
                }
                Dimension dimension = component.getMaximumSize();
                dimension.height = 20;
                component.setMaximumSize(dimension);
                this.selectionContent.add(component);
                boolean bl = Boolean.parseBoolean(this.readFlag(LIFECYCLE_FLAG, Boolean.TRUE.toString()));
                this.lifecycleCheckbox = new JCheckBox(Bundle.ObjectsFeatureModes_recordLifecycle(), bl){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        SelectedClassesMode.this.settingsChanged();
                    }
                };
                this.lifecycleCheckbox.setToolTipText(Bundle.ObjectsFeatureModes_profileAllObjectsToolTip());
                this.lifecycleCheckbox.setOpaque(false);
                this.selectionContent.add(ObjectsFeatureModes.createStrut(this.lifecycleCheckbox, 8, true));
                this.selectionContent.add(this.lifecycleCheckbox);
                this.selectionContent.add(ObjectsFeatureModes.createStrut(this.lifecycleCheckbox, 5, false));
                if (UIUtils.isOracleLookAndFeel()) {
                    this.selectionContent.add(Box.createHorizontalStrut(4));
                }
                GrayLabel grayLabel = new GrayLabel(Bundle.ObjectsFeatureModes_lblUnlimited());
                GrayLabel grayLabel2 = new GrayLabel(Bundle.ObjectsFeatureModes_lblNoAllocations());
                boolean bl2 = Boolean.parseBoolean(this.readFlag(ALLOCATIONS_FLAG, Boolean.TRUE.toString()));
                this.outgoingCheckbox = new JCheckBox(Bundle.ObjectsFeatureModes_limitAllocations(), bl2, (JLabel)grayLabel, (JLabel)grayLabel2){
                    final /* synthetic */ JLabel val$unlimited;
                    final /* synthetic */ JLabel val$noAllocs;
                    {
                        this.val$unlimited = jLabel;
                        this.val$noAllocs = jLabel2;
                        super(string, bl);
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        boolean bl = this.isSelected();
                        this.val$unlimited.setVisible(!bl);
                        SelectedClassesMode.this.outgoingSpinner.setVisible(bl);
                        this.val$noAllocs.setVisible(bl && (Integer)SelectedClassesMode.this.outgoingSpinner.getValue() == 0);
                        SelectedClassesMode.this.settingsChanged();
                    }
                };
                this.outgoingCheckbox.setToolTipText(Bundle.ObjectsFeatureModes_collectFullStacksToolTip());
                this.outgoingCheckbox.setOpaque(false);
                this.selectionContent.add(this.outgoingCheckbox);
                this.selectionContent.add(ObjectsFeatureModes.createStrut(this.outgoingCheckbox, 5, false));
                if (UIUtils.isOracleLookAndFeel()) {
                    this.selectionContent.add(Box.createHorizontalStrut(4));
                }
                grayLabel.setVisible(!this.outgoingCheckbox.isSelected());
                this.selectionContent.add((Component)grayLabel);
                int n = Integer.parseInt(this.readFlag(LIMIT_ALLOCATIONS_FLAG, LIMIT_ALLOCATIONS_DEFAULT.toString()));
                this.outgoingSpinner = new JExtendedSpinner(new SpinnerNumberModel(Math.abs(n), 0, 99, 1)){

                    public Dimension getPreferredSize() {
                        return this.getMinimumSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getMinimumSize();
                    }

                    protected void fireStateChanged() {
                        SelectedClassesMode.this.settingsChanged();
                        super.fireStateChanged();
                    }
                };
                this.outgoingSpinner.setToolTipText(Bundle.ObjectsFeatureModes_limitAllocationsDepthToolTip());
                JComponent jComponent = this.outgoingSpinner.getEditor();
                JFormattedTextField jFormattedTextField2 = jFormattedTextField = jComponent instanceof JSpinner.DefaultEditor ? ((JSpinner.DefaultEditor)jComponent).getTextField() : null;
                if (jFormattedTextField != null) {
                    jFormattedTextField.getDocument().addDocumentListener(new DocumentListener((JLabel)grayLabel2){
                        final /* synthetic */ JLabel val$noAllocs;
                        {
                            this.val$noAllocs = jLabel;
                        }

                        @Override
                        public void insertUpdate(DocumentEvent documentEvent) {
                            this.change();
                        }

                        @Override
                        public void removeUpdate(DocumentEvent documentEvent) {
                            this.change();
                        }

                        @Override
                        public void changedUpdate(DocumentEvent documentEvent) {
                            this.change();
                        }

                        private void change() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    val$noAllocs.setVisible(SelectedClassesMode.this.outgoingSpinner.isVisible() && (Integer)SelectedClassesMode.this.outgoingSpinner.getValue() == 0);
                                }
                            });
                        }
                    });
                }
                this.outgoingSpinner.setVisible(this.outgoingCheckbox.isSelected());
                this.selectionContent.add(this.outgoingSpinner);
                this.selectionContent.add(Box.createHorizontalStrut(5));
                grayLabel2.setVisible(this.outgoingSpinner.isVisible() && (Integer)this.outgoingSpinner.getValue() == 0);
                this.selectionContent.add((Component)grayLabel2);
                this.noSelectionContent = new SettingsPanel();
                GrayLabel grayLabel3 = new GrayLabel(Bundle.ObjectsFeatureModes_noClassSelected());
                grayLabel3.setEnabled(false);
                this.noSelectionContent.add((Component)grayLabel3);
                this.noSelectionContent.add(Box.createHorizontalStrut(5));
                String string = "LanguageIcons.Class";
                Image image = Icons.getImage((String)string);
                Image image2 = Icons.getImage((String)"GeneralIcons.BadgeAdd");
                Image image3 = ImageUtilities.mergeImages((Image)image, (Image)image2, (int)0, (int)0);
                this.addSelectionButton = new SmallButton(ImageUtilities.image2Icon((Image)image3)){

                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        SelectedClassesMode.this.selectForProfiling(ClassMethodSelector.selectClasses(SelectedClassesMode.this.getSession()));
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.addSelectionButton.setToolTipText(Bundle.ObjectsFeatureModes_addClass());
                this.noSelectionContent.add(this.addSelectionButton);
                this.updateSelectionCustomizer();
            }
            return this.ui;
        }

        private void updateSelectionCustomizer() {
            if (this.ui != null) {
                JPanel jPanel;
                int n = this.getSelection().size();
                JPanel jPanel2 = jPanel = n == 0 ? this.noSelectionContent : this.selectionContent;
                if (this.ui.getComponentCount() > 0 && jPanel == this.ui.getComponent(0)) {
                    jPanel = null;
                }
                if (n > 0) {
                    this.editSelectionLink.setText(n == 1 ? Bundle.ObjectsFeatureModes_oneClassSelected() : Bundle.ObjectsFeatureModes_multipleClassesSelected(n));
                }
                if (jPanel != null) {
                    this.ui.removeAll();
                    this.ui.add(jPanel);
                    this.ui.doLayout();
                    this.ui.repaint();
                }
            }
        }
    }

    static abstract class ProjectClassesMode
    extends SampledMemoryMode {
        private final Collection<Lookup.Provider> selectedProjects = new HashSet<Lookup.Provider>();
        private static final String PROJECTS_FLAG = "PROJECTS_FLAG";
        private JComponent ui;
        private JButton editProjectLink;

        abstract Lookup.Provider getProject();

        ProjectClassesMode() {
            Collection<File> collection = this.createFilesFromStorage();
            if (collection.isEmpty()) {
                this.selectedProjects.add(this.getProject());
            } else {
                for (File file : collection) {
                    Lookup.Provider provider;
                    if (!file.exists()) continue;
                    FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                    Lookup.Provider provider2 = provider = fileObject == null ? null : ProjectUtilities.getProject((FileObject)fileObject);
                    if (fileObject == null) continue;
                    this.selectedProjects.add(provider);
                }
                this.verifySelectedProjects(false);
            }
        }

        @Override
        String getID() {
            return "ProjectClassesMode";
        }

        @Override
        String getName() {
            return Bundle.ObjectsFeatureModes_projectClasses();
        }

        @Override
        void configureSettings(ProfilingSettings profilingSettings) {
            Lookup.Provider provider2;
            super.configureSettings(profilingSettings);
            StringBuilder stringBuilder = new StringBuilder();
            for (Lookup.Provider provider2 : this.selectedProjects) {
                ProjectContentsSupport projectContentsSupport = ProjectContentsSupport.get((Lookup.Provider)provider2);
                stringBuilder.append(projectContentsSupport.getInstrumentationFilter(false));
                stringBuilder.append(" ");
                projectContentsSupport.reset();
            }
            String string = stringBuilder.toString().replace(". ", ".* ").replace(".,", ".*,").trim();
            provider2 = new JavaTypeFilter(string, 10);
            profilingSettings.setInstrumentationFilter((GenericFilter)provider2);
        }

        @Override
        void confirmSettings() {
            if (this.ui != null) {
                assert (SwingUtilities.isEventDispatchThread());
                this.saveSelection();
            }
        }

        @Override
        boolean pendingChanges() {
            if (this.ui != null) {
                assert (SwingUtilities.isEventDispatchThread());
                if (!this.filesEquals(this.createFilesFromSelection(), this.createFilesFromStorage())) {
                    return true;
                }
            }
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            assert (SwingUtilities.isEventDispatchThread());
            return !this.selectedProjects.isEmpty();
        }

        private void saveSelection() {
            Collection<File> collection = this.createFilesFromSelection();
            if (collection.isEmpty()) {
                this.storeFlag(PROJECTS_FLAG, null);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                for (File file : collection) {
                    try {
                        stringBuilder.append(file.getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        stringBuilder.append(file.getAbsolutePath());
                    }
                    stringBuilder.append(File.pathSeparatorChar);
                }
                this.storeFlag(PROJECTS_FLAG, stringBuilder.toString());
            }
        }

        private Collection<File> createFilesFromStorage() {
            HashSet<File> hashSet = new HashSet<File>();
            String string = this.readFlag(PROJECTS_FLAG, null);
            if (string != null) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(File.pathSeparator)) {
                    hashSet.add(new File(string2));
                }
            }
            return hashSet;
        }

        private Collection<File> createFilesFromSelection() {
            HashSet<File> hashSet = new HashSet<File>();
            if (this.selectedProjects.size() > 1 || !this.selectedProjects.contains(this.getProject())) {
                for (Lookup.Provider provider : this.selectedProjects) {
                    hashSet.add(FileUtil.toFile((FileObject)ProjectUtilities.getProjectDirectory((Lookup.Provider)provider)));
                }
            }
            return hashSet;
        }

        private boolean filesEquals(Collection<File> collection, Collection<File> collection2) {
            if (collection.size() != collection2.size()) {
                return false;
            }
            for (File file : collection) {
                if (collection2.contains(file)) continue;
                return false;
            }
            return true;
        }

        private void verifySelectedProjects(boolean bl) {
            if (this.selectedProjects.size() == 1 && this.selectedProjects.contains(this.getProject())) {
                return;
            }
            List<Lookup.Provider> list = Arrays.asList(ProjectUtilities.getOpenedProjects());
            Iterator<Lookup.Provider> iterator = this.selectedProjects.iterator();
            while (iterator.hasNext()) {
                if (list.contains(iterator.next())) continue;
                iterator.remove();
            }
            if (this.selectedProjects.isEmpty()) {
                this.selectedProjects.add(this.getProject());
            }
            if (bl) {
                this.refreshProjectsLink();
            }
        }

        @Override
        JComponent getUI() {
            if (this.ui == null) {
                final ChangeListener changeListener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProjectClassesMode.this.verifySelectedProjects(true);
                            }
                        });
                    }
                };
                this.ui = new SettingsPanel(){

                    @Override
                    public void addNotify() {
                        super.addNotify();
                        ProjectUtilities.addOpenProjectsListener((ChangeListener)changeListener);
                    }

                    @Override
                    public void removeNotify() {
                        ProjectUtilities.removeOpenProjectsListener((ChangeListener)changeListener);
                        super.removeNotify();
                    }
                };
                this.editProjectLink = new JButton(){

                    @Override
                    public void setText(String string) {
                        super.setText(Bundle.MethodsFeatureModes_editLink(string));
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        ProjectClassesMode.this.performEditProject();
                    }

                    @Override
                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    @Override
                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.editProjectLink.setContentAreaFilled(false);
                this.editProjectLink.setBorderPainted(true);
                this.editProjectLink.setMargin(new Insets(0, 0, 0, 0));
                this.editProjectLink.setBorder(BorderFactory.createEmptyBorder());
                this.editProjectLink.setCursor(Cursor.getPredefinedCursor(12));
                this.refreshProjectsLink();
                this.ui.add(this.editProjectLink);
            }
            return this.ui;
        }

        private void performEditProject() {
            new ProjectsSelector(this.selectedProjects){

                @Override
                protected void selectionChanged(Collection<Lookup.Provider> collection) {
                    ProjectClassesMode.this.selectedProjects.clear();
                    ProjectClassesMode.this.selectedProjects.addAll(collection);
                    ProjectClassesMode.this.refreshProjectsLink();
                    ProjectClassesMode.this.settingsChanged();
                }
            }.show(this.ui);
        }

        private void refreshProjectsLink() {
            if (this.editProjectLink == null) {
                return;
            }
            if (this.selectedProjects.size() == 1) {
                this.editProjectLink.setText(Bundle.MethodsFeatureModes_selectedProject(ProjectUtilities.getDisplayName((Lookup.Provider)this.selectedProjects.iterator().next())));
            } else {
                this.editProjectLink.setText(Bundle.MethodsFeatureModes_selectedProjects(this.selectedProjects.size()));
            }
        }
    }

    static abstract class AllClassesMode
    extends SampledMemoryMode {
        AllClassesMode() {
        }

        @Override
        String getID() {
            return "AllClassesMode";
        }

        @Override
        String getName() {
            return Bundle.ObjectsFeatureModes_allClasses();
        }

        @Override
        void configureSettings(ProfilingSettings profilingSettings) {
            super.configureSettings(profilingSettings);
            profilingSettings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter());
        }
    }

    private static abstract class SampledMemoryMode
    extends MemoryMode {
        private SampledMemoryMode() {
        }

        @Override
        void configureSettings(ProfilingSettings profilingSettings) {
            super.configureSettings(profilingSettings);
            profilingSettings.setProfilingType(128);
        }

        @Override
        void confirmSettings() {
        }

        @Override
        boolean pendingChanges() {
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            return true;
        }

        @Override
        JComponent getUI() {
            return null;
        }
    }

    private static abstract class MemoryMode
    extends FeatureMode {
        private MemoryMode() {
        }

        @Override
        void configureSettings(ProfilingSettings profilingSettings) {
        }
    }
}

