/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import javajs.util.T4;
import org.jmol.api.SymmetryInterface;
import org.jmol.render.CageRenderer;
import org.jmol.shape.Axes;
import org.jmol.shape.Uccage;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.SimpleUnitCell;

public class UccageRenderer
extends CageRenderer {
    private final P3[] verticesT = new P3[8];
    private P3 fset0 = P3.new3(555.0f, 555.0f, 1.0f);
    private P3 cell0 = new P3();
    private P3 cell1 = new P3();
    private P3 offset = new P3();
    private P3 offsetT = new P3();
    private SymmetryInterface unitcell;
    private int lineheight;
    private int xpos;
    private int ypos;

    @Override
    protected void initRenderer() {
        int i = 8;
        while (--i >= 0) {
            this.verticesT[i] = new P3();
        }
        this.tickEdges = BoxInfo.uccageTickEdges;
        this.draw000 = false;
    }

    @Override
    protected boolean render() {
        this.imageFontScaling = this.vwr.imageFontScaling;
        this.font3d = this.vwr.gdata.getFont3DScaled(((Uccage)this.shape).font3d, this.imageFontScaling);
        int mad10 = this.vwr.getObjectMad10(5);
        if (mad10 == 0 || this.vwr.isJmolDataFrame() || this.tm.isNavigating() && this.vwr.getBoolean(603979890)) {
            return false;
        }
        this.colix = this.vwr.getObjectColix(5);
        boolean needTranslucent = C.renderPass2(this.colix);
        if (!this.isExport && needTranslucent != this.vwr.gdata.isPass2) {
            return needTranslucent;
        }
        this.render1(mad10);
        return false;
    }

    private void render1(int mad10) {
        int[][] faces;
        boolean haveMultiple;
        this.g3d.setC(this.colix);
        this.unitcell = this.vwr.getCurrentUnitCell();
        if (this.unitcell == null) {
            return;
        }
        this.isPolymer = this.unitcell.isPolymer();
        this.isSlab = this.unitcell.isSlab();
        P3[] vertices = this.unitcell.getUnitCellVerticesNoOffset();
        this.offset.setT(this.unitcell.getCartesianOffset());
        this.offsetT.setT(this.unitcell.getFractionalOrigin());
        this.unitcell.toCartesian(this.offsetT, true);
        this.offset.sub(this.offsetT);
        boolean hiddenLines = this.vwr.getBoolean(603979856);
        T3 fset = this.unitcell.getUnitCellMultiplier();
        boolean bl = haveMultiple = fset != null && fset.distanceSquared(this.fset0) != 0.0f;
        if (!haveMultiple) {
            fset = this.fset0;
        }
        int t3w = fset instanceof T4 ? (int)((T4)fset).w : 0;
        SimpleUnitCell.ijkToPoint3f((int)fset.x, this.cell0, 0, t3w);
        SimpleUnitCell.ijkToPoint3f((int)fset.y, this.cell1, 1, t3w);
        if (fset.z < 0.0f) {
            this.cell0.scale(-1.0f / fset.z);
            this.cell1.scale(-1.0f / fset.z);
        }
        float scale = Math.abs(fset.z);
        Axes axes = (Axes)this.vwr.shm.getShape(34);
        if (axes != null && this.vwr.areAxesTainted()) {
            axes.reinitShape();
        }
        P3[] axisPoints = axes == null || this.vwr.getObjectMad10(1) == 0 || axes.axisXY.z != 0.0f || axes.fixedOrigin != null || axes.fixedOriginUC.lengthSquared() > 0.0f ? null : axes.axisPoints;
        boolean drawAllLines = this.isExport || this.vwr.getObjectMad10(1) == 0 || this.vwr.getFloat(0x22000002) < 2.0f || axisPoints == null;
        P3[] aPoints = axisPoints;
        int[][] nArray = faces = hiddenLines ? BoxInfo.facePoints : (int[][])null;
        if (fset.z == 0.0f) {
            this.offsetT.setT(this.cell0);
            this.unitcell.toCartesian(this.offsetT, true);
            this.offsetT.add(this.offset);
            aPoints = this.cell0.x == 0.0f && this.cell0.y == 0.0f && this.cell0.z == 0.0f ? axisPoints : null;
            int firstLine = 0;
            int allow0 = 255;
            int allow1 = 255;
            P3[] pts = BoxInfo.unitCubePoints;
            int i = 8;
            while (--i >= 0) {
                P3 v = P3.new3(pts[i].x * (this.cell1.x - this.cell0.x), pts[i].y * (this.cell1.y - this.cell0.y), pts[i].z * (this.cell1.z - this.cell0.z));
                this.unitcell.toCartesian(v, true);
                this.verticesT[i].add2(v, this.offsetT);
            }
            this.renderCage(mad10, this.verticesT, faces, aPoints, firstLine, allow0, allow1, 1.0f);
        } else {
            int x = (int)this.cell0.x;
            while ((float)x < this.cell1.x) {
                int y = (int)this.cell0.y;
                while ((float)y < this.cell1.y) {
                    int z = (int)this.cell0.z;
                    while ((float)z < this.cell1.z) {
                        int firstLine;
                        if (haveMultiple) {
                            this.offsetT.set(x, y, z);
                            this.offsetT.scale(scale);
                            this.unitcell.toCartesian(this.offsetT, true);
                            this.offsetT.add(this.offset);
                            aPoints = x == 0 && y == 0 && z == 0 ? axisPoints : null;
                            firstLine = drawAllLines || aPoints == null ? 0 : 3;
                        } else {
                            this.offsetT.setT(this.offset);
                            firstLine = drawAllLines ? 0 : 3;
                        }
                        int allow0 = 255;
                        int allow1 = 255;
                        int i = 8;
                        while (--i >= 0) {
                            this.verticesT[i].add2(vertices[i], this.offsetT);
                        }
                        this.renderCage(mad10, this.verticesT, faces, aPoints, firstLine, allow0, allow1, scale);
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        this.renderInfo();
    }

    private void renderInfo() {
        Lst<String> info;
        String sgName;
        if (this.isExport || !this.vwr.getBoolean(603979828) || this.unitcell.isSimple() || this.vwr.isPreviewOnly || !this.vwr.gdata.setC(this.vwr.cm.colixBackgroundContrast) || this.vwr.gdata.getTextPosition() != 0) {
            return;
        }
        this.vwr.gdata.setFontFid(this.vwr.gdata.getFontFidFS("Monospaced", 14.0f * this.imageFontScaling));
        this.xpos = (int)Math.floor(5.0f * this.imageFontScaling);
        this.ypos = this.lineheight = (int)Math.floor(15.0f * this.imageFontScaling);
        String string = this.isPolymer ? "polymer" : (sgName = this.isSlab ? "slab" : this.unitcell.getSpaceGroupName());
        if (sgName != null) {
            String intTab;
            if (sgName.startsWith("cell=!")) {
                sgName = "cell=inverse[" + sgName.substring(6) + "]";
            }
            if ((sgName = PT.rep(sgName, ";0,0,0", "")).indexOf("#") < 0 && (intTab = this.unitcell.getIntTableNumber()) != null) {
                sgName = sgName + " #" + intTab;
            }
            if (!sgName.equals("-- [--]")) {
                this.drawInfo(sgName, 0, null);
            }
        }
        if ((info = this.unitcell.getMoreInfo()) != null) {
            for (int i = 0; i < info.size(); ++i) {
                this.drawInfo((String)info.get(i), 0, null);
            }
        }
        if (!this.vwr.getBoolean(603979937)) {
            return;
        }
        this.drawInfo("a=", 0, "\u00c5");
        if (!this.isPolymer) {
            this.drawInfo("b=", 1, "\u00c5");
        }
        if (!this.isPolymer && !this.isSlab) {
            this.drawInfo("c=", 2, "\u00c5");
        }
        if (!this.isPolymer) {
            if (!this.isSlab) {
                this.drawInfo("\u03b1=", 3, "\u00b0");
                this.drawInfo("\u03b2=", 4, "\u00b0");
            }
            this.drawInfo("\u03b3=", 5, "\u00b0");
        }
    }

    private void drawInfo(String s, int type, String post) {
        this.ypos += this.lineheight;
        if (post != null) {
            s = s + DF.formatDecimal(this.unitcell.getUnitCellInfoType(type), 3) + post;
        }
        this.g3d.drawStringNoSlab(s, null, this.xpos, this.ypos, 0, (short)0);
    }
}

