/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.RubyComplex;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Complex
extends ImmutableLiteral {
    private final ImmutableLiteral number;

    public Complex(ImmutableLiteral number) {
        this.number = number;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.COMPLEX;
    }

    public Object createCacheObject(ThreadContext context) {
        return RubyComplex.newComplexRaw(context.runtime, context.runtime.newFixnum(0), (IRubyObject)this.number.cachedObject(context));
    }

    public String toString() {
        return this.number + "i";
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Complex(this);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.number);
    }

    public static Complex decode(IRReaderDecoder d) {
        return new Complex((ImmutableLiteral)d.decodeOperand());
    }

    public Operand getNumber() {
        return this.number;
    }
}

