/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers;

import com.google.common.collect.LinkedListMultimap;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.DebugInfoUtil;
import org.jetbrains.kotlin.checkers.PositionalTextDiagnostic;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.AbstractDiagnosticWithParametersRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.MultiTargetPlatform;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

public class CheckerTestUtil {
    public static final Comparator<ActualDiagnostic> DIAGNOSTIC_COMPARATOR = (o1, o2) -> {
        List<TextRange> ranges1 = o1.diagnostic.getTextRanges();
        List<TextRange> ranges2 = o2.diagnostic.getTextRanges();
        int minNumberOfRanges = ranges1.size() < ranges2.size() ? ranges1.size() : ranges2.size();
        for (int i = 0; i < minNumberOfRanges; ++i) {
            int endOffset2;
            int startOffset2;
            TextRange range1 = ranges1.get(i);
            TextRange range2 = ranges2.get(i);
            int startOffset1 = range1.getStartOffset();
            if (startOffset1 != (startOffset2 = range2.getStartOffset())) {
                return startOffset1 - range2.getStartOffset();
            }
            int endOffset1 = range1.getEndOffset();
            if (endOffset1 == (endOffset2 = range2.getEndOffset())) continue;
            return endOffset2 - endOffset1;
        }
        return ranges1.size() - ranges2.size();
    };
    private static final Pattern RANGE_START_OR_END_PATTERN = Pattern.compile("(<!(\\w+;)?(\\w+:)?(\\w+)(\\((?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+(;\\s*(?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+)*\\))?(,\\s*(\\w+;)?(\\w+:)?(\\w+)(\\((?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+(;\\s*(?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+)*\\))?)*!>)|(<!>)");
    private static final Pattern INDIVIDUAL_DIAGNOSTIC_PATTERN = Pattern.compile("(\\w+;)?(\\w+:)?(\\w+)(\\((?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+(;\\s*(?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+)*\\))?");
    private static final Pattern INDIVIDUAL_PARAMETER_PATTERN = Pattern.compile("(?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+");

    @NotNull
    public static List<ActualDiagnostic> getDiagnosticsIncludingSyntaxErrors(@NotNull BindingContext bindingContext, @NotNull List<Pair<MultiTargetPlatform, BindingContext>> implementingModulesBindings, @NotNull PsiElement root2, boolean markDynamicCalls, @Nullable List<DeclarationDescriptor> dynamicCallDescriptors, boolean withNewInference) {
        List<ActualDiagnostic> result2 = CheckerTestUtil.getDiagnosticsIncludingSyntaxErrors(bindingContext, root2, markDynamicCalls, dynamicCallDescriptors, null, withNewInference);
        List<Pair<MultiTargetPlatform, BindingContext>> sortedBindings = CollectionsKt.sortedWith(implementingModulesBindings, (o1, o2) -> ((MultiTargetPlatform)o1.getFirst()).compareTo(o2.getFirst()));
        for (Pair<MultiTargetPlatform, BindingContext> binding : sortedBindings) {
            MultiTargetPlatform platform = binding.getFirst();
            assert (platform instanceof MultiTargetPlatform.Specific) : "Implementing module must have a specific platform: " + platform;
            result2.addAll(CheckerTestUtil.getDiagnosticsIncludingSyntaxErrors(binding.getSecond(), root2, markDynamicCalls, dynamicCallDescriptors, ((MultiTargetPlatform.Specific)platform).getPlatform(), withNewInference));
        }
        return result2;
    }

    @NotNull
    public static List<ActualDiagnostic> getDiagnosticsIncludingSyntaxErrors(@NotNull BindingContext bindingContext, @NotNull PsiElement root2, boolean markDynamicCalls, @Nullable List<DeclarationDescriptor> dynamicCallDescriptors, @Nullable String platform, boolean withNewInference) {
        ArrayList<ActualDiagnostic> diagnostics2 = new ArrayList<ActualDiagnostic>();
        for (Diagnostic diagnostic : bindingContext.getDiagnostics().all()) {
            if (!PsiTreeUtil.isAncestor(root2, diagnostic.getPsiElement(), false)) continue;
            diagnostics2.add(new ActualDiagnostic(diagnostic, platform, withNewInference));
        }
        for (PsiErrorElement errorElement : AnalyzingUtils.getSyntaxErrorRanges(root2)) {
            diagnostics2.add(new ActualDiagnostic(new SyntaxErrorDiagnostic(errorElement), platform, withNewInference));
        }
        diagnostics2.addAll(CheckerTestUtil.getDebugInfoDiagnostics(root2, bindingContext, markDynamicCalls, dynamicCallDescriptors, platform, withNewInference));
        return diagnostics2;
    }

    @NotNull
    private static List<ActualDiagnostic> getDebugInfoDiagnostics(@NotNull PsiElement root2, @NotNull BindingContext bindingContext, final boolean markDynamicCalls, final @Nullable List<DeclarationDescriptor> dynamicCallDescriptors, final @Nullable String platform, final boolean withNewInference) {
        final ArrayList<ActualDiagnostic> debugAnnotations = new ArrayList<ActualDiagnostic>();
        DebugInfoUtil.markDebugAnnotations(root2, bindingContext, new DebugInfoUtil.DebugInfoReporter(){

            @Override
            public void reportElementWithErrorType(@NotNull KtReferenceExpression expression2) {
                this.newDiagnostic(expression2, DebugInfoDiagnosticFactory.ELEMENT_WITH_ERROR_TYPE);
            }

            @Override
            public void reportMissingUnresolved(@NotNull KtReferenceExpression expression2) {
                this.newDiagnostic(expression2, DebugInfoDiagnosticFactory.MISSING_UNRESOLVED);
            }

            @Override
            public void reportUnresolvedWithTarget(@NotNull KtReferenceExpression expression2, @NotNull String target) {
                this.newDiagnostic(expression2, DebugInfoDiagnosticFactory.UNRESOLVED_WITH_TARGET);
            }

            @Override
            public void reportDynamicCall(@NotNull KtElement element, DeclarationDescriptor declarationDescriptor) {
                if (dynamicCallDescriptors != null) {
                    dynamicCallDescriptors.add(declarationDescriptor);
                }
                if (markDynamicCalls) {
                    this.newDiagnostic(element, DebugInfoDiagnosticFactory.DYNAMIC);
                }
            }

            private void newDiagnostic(KtElement element, DebugInfoDiagnosticFactory factory2) {
                debugAnnotations.add(new ActualDiagnostic(new DebugInfoDiagnostic(element, factory2), platform, withNewInference));
            }
        });
        for (Pair factory2 : Arrays.asList(TuplesKt.to(BindingContext.SMARTCAST, DebugInfoDiagnosticFactory.SMARTCAST), TuplesKt.to(BindingContext.IMPLICIT_RECEIVER_SMARTCAST, DebugInfoDiagnosticFactory.IMPLICIT_RECEIVER_SMARTCAST), TuplesKt.to(BindingContext.SMARTCAST_NULL, DebugInfoDiagnosticFactory.CONSTANT), TuplesKt.to(BindingContext.LEAKING_THIS, DebugInfoDiagnosticFactory.LEAKING_THIS), TuplesKt.to(BindingContext.IMPLICIT_EXHAUSTIVE_WHEN, DebugInfoDiagnosticFactory.IMPLICIT_EXHAUSTIVE))) {
            for (KtExpression expression2 : bindingContext.getSliceContents((ReadOnlySlice)factory2.getFirst()).keySet()) {
                if (!PsiTreeUtil.isAncestor(root2, expression2, false)) continue;
                debugAnnotations.add(new ActualDiagnostic(new DebugInfoDiagnostic(expression2, (DebugInfoDiagnosticFactory)factory2.getSecond()), platform, withNewInference));
            }
        }
        return debugAnnotations;
    }

    public static Map<AbstractTestDiagnostic, TextDiagnostic> diagnosticsDiff(List<DiagnosedRange> expected, Collection<ActualDiagnostic> actual, DiagnosticDiffCallbacks callbacks) {
        HashMap<AbstractTestDiagnostic, TextDiagnostic> diagnosticToExpectedDiagnostic = new HashMap<AbstractTestDiagnostic, TextDiagnostic>();
        CheckerTestUtil.assertSameFile(actual);
        Iterator<DiagnosedRange> expectedDiagnostics = expected.iterator();
        List<ActualDiagnosticDescriptor> sortedDiagnosticDescriptors = CheckerTestUtil.getActualSortedDiagnosticDescriptors(actual);
        Iterator<ActualDiagnosticDescriptor> actualDiagnostics = sortedDiagnosticDescriptors.iterator();
        DiagnosedRange currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
        ActualDiagnosticDescriptor currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
        while (currentExpected != null || currentActual != null) {
            if (currentExpected != null) {
                if (currentActual == null) {
                    CheckerTestUtil.missingDiagnostics(callbacks, currentExpected);
                    currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                    continue;
                }
                int expectedStart = currentExpected.getStart();
                int actualStart = currentActual.getStart();
                int expectedEnd = currentExpected.getEnd();
                int actualEnd = currentActual.getEnd();
                if (expectedStart < actualStart) {
                    CheckerTestUtil.missingDiagnostics(callbacks, currentExpected);
                    currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                    continue;
                }
                if (expectedStart > actualStart) {
                    CheckerTestUtil.unexpectedDiagnostics(currentActual, callbacks);
                    currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
                    continue;
                }
                if (expectedEnd > actualEnd) {
                    assert (expectedStart == actualStart);
                    CheckerTestUtil.missingDiagnostics(callbacks, currentExpected);
                    currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                    continue;
                }
                if (expectedEnd < actualEnd) {
                    assert (expectedStart == actualStart);
                    CheckerTestUtil.unexpectedDiagnostics(currentActual, callbacks);
                    currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
                    continue;
                }
                CheckerTestUtil.compareDiagnostics(callbacks, currentExpected, currentActual, diagnosticToExpectedDiagnostic);
                currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
                continue;
            }
            assert (currentActual != null);
            CheckerTestUtil.unexpectedDiagnostics(currentActual, callbacks);
            currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
        }
        return diagnosticToExpectedDiagnostic;
    }

    private static void compareDiagnostics(@NotNull DiagnosticDiffCallbacks callbacks, @NotNull DiagnosedRange currentExpected, @NotNull ActualDiagnosticDescriptor currentActual, @NotNull Map<AbstractTestDiagnostic, TextDiagnostic> diagnosticToInput) {
        int expectedStart = currentExpected.getStart();
        int expectedEnd = currentExpected.getEnd();
        int actualStart = currentActual.getStart();
        int actualEnd = currentActual.getEnd();
        assert (expectedStart == actualStart && expectedEnd == actualEnd);
        Map<AbstractTestDiagnostic, TextDiagnostic> actualDiagnostics = currentActual.getTextDiagnosticsMap();
        List<TextDiagnostic> expectedDiagnostics = currentExpected.getDiagnostics();
        for (TextDiagnostic expectedDiagnostic : expectedDiagnostics) {
            Map.Entry actualDiagnosticEntry = CollectionsKt.firstOrNull(actualDiagnostics.entrySet(), entry -> {
                TextDiagnostic actualDiagnostic = (TextDiagnostic)entry.getValue();
                return expectedDiagnostic.getDescription().equals(actualDiagnostic.getDescription()) && expectedDiagnostic.inferenceCompatibility.isCompatible(actualDiagnostic.inferenceCompatibility);
            });
            if (actualDiagnosticEntry != null) {
                AbstractTestDiagnostic actualDiagnostic = (AbstractTestDiagnostic)actualDiagnosticEntry.getKey();
                TextDiagnostic actualTextDiagnostic = (TextDiagnostic)actualDiagnosticEntry.getValue();
                if (!CheckerTestUtil.compareTextDiagnostic(expectedDiagnostic, actualTextDiagnostic)) {
                    callbacks.wrongParametersDiagnostic(expectedDiagnostic, actualTextDiagnostic, expectedStart, expectedEnd);
                }
                actualDiagnostics.remove(actualDiagnostic);
                actualDiagnostic.enhanceInferenceCompatibility(expectedDiagnostic.inferenceCompatibility);
                diagnosticToInput.put(actualDiagnostic, expectedDiagnostic);
                continue;
            }
            callbacks.missingDiagnostic(expectedDiagnostic, expectedStart, expectedEnd);
        }
        for (TextDiagnostic unexpectedDiagnostic : actualDiagnostics.values()) {
            callbacks.unexpectedDiagnostic(unexpectedDiagnostic, actualStart, actualEnd);
        }
    }

    private static boolean compareTextDiagnostic(@NotNull TextDiagnostic expected, @NotNull TextDiagnostic actual) {
        if (!expected.getDescription().equals(actual.getDescription())) {
            return false;
        }
        if (expected.getParameters() == null) {
            return true;
        }
        if (actual.getParameters() == null || expected.getParameters().size() != actual.getParameters().size()) {
            return false;
        }
        for (int index2 = 0; index2 < expected.getParameters().size(); ++index2) {
            String expectedParameter = expected.getParameters().get(index2);
            String actualParameter = actual.getParameters().get(index2);
            if (expectedParameter.equals("IGNORE") || expectedParameter.equals(actualParameter)) continue;
            return false;
        }
        return true;
    }

    private static void assertSameFile(Collection<ActualDiagnostic> actual) {
        if (actual.isEmpty()) {
            return;
        }
        PsiFile file2 = CollectionsKt.first(actual).getFile();
        for (ActualDiagnostic actualDiagnostic : actual) {
            assert (actualDiagnostic.getFile().equals(file2)) : "All diagnostics should come from the same file: " + actualDiagnostic.getFile() + ", " + file2;
        }
    }

    private static void unexpectedDiagnostics(ActualDiagnosticDescriptor descriptor2, DiagnosticDiffCallbacks callbacks) {
        for (AbstractTestDiagnostic diagnostic : descriptor2.diagnostics) {
            callbacks.unexpectedDiagnostic(TextDiagnostic.asTextDiagnostic(diagnostic), descriptor2.getStart(), descriptor2.getEnd());
        }
    }

    private static void missingDiagnostics(DiagnosticDiffCallbacks callbacks, DiagnosedRange currentExpected) {
        for (TextDiagnostic diagnostic : currentExpected.getDiagnostics()) {
            callbacks.missingDiagnostic(diagnostic, currentExpected.getStart(), currentExpected.getEnd());
        }
    }

    private static <T> T safeAdvance(Iterator<T> iterator2) {
        return iterator2.hasNext() ? (T)iterator2.next() : null;
    }

    public static String parseDiagnosedRanges(String text2, List<DiagnosedRange> result2) {
        Matcher matcher = RANGE_START_OR_END_PATTERN.matcher(text2);
        Stack<DiagnosedRange> opened = new Stack<DiagnosedRange>();
        int offsetCompensation = 0;
        while (matcher.find()) {
            int effectiveOffset = matcher.start() - offsetCompensation;
            String matchedText = matcher.group();
            if ("<!>".equals(matchedText)) {
                ((DiagnosedRange)opened.pop()).setEnd(effectiveOffset);
            } else {
                Matcher diagnosticTypeMatcher = INDIVIDUAL_DIAGNOSTIC_PATTERN.matcher(matchedText);
                DiagnosedRange range = new DiagnosedRange(effectiveOffset);
                while (diagnosticTypeMatcher.find()) {
                    range.addDiagnostic(diagnosticTypeMatcher.group());
                }
                opened.push(range);
                result2.add(range);
            }
            offsetCompensation += matchedText.length();
        }
        assert (opened.isEmpty()) : "Stack is not empty";
        matcher.reset();
        return matcher.replaceAll("");
    }

    public static StringBuffer addDiagnosticMarkersToText(@NotNull PsiFile psiFile, @NotNull Collection<ActualDiagnostic> diagnostics2) {
        return CheckerTestUtil.addDiagnosticMarkersToText(psiFile, diagnostics2, Collections.emptyMap(), PsiElement::getText, Collections.emptyList(), false);
    }

    public static StringBuffer addDiagnosticMarkersToText(@NotNull PsiFile psiFile, @NotNull Collection<ActualDiagnostic> diagnostics2, @NotNull Map<AbstractTestDiagnostic, TextDiagnostic> diagnosticToExpectedDiagnostic, @NotNull Function<PsiFile, String> getFileText, @NotNull Collection<PositionalTextDiagnostic> uncheckedDiagnostics, boolean withNewInferenceDirective) {
        String text2 = getFileText.fun(psiFile);
        StringBuffer result2 = new StringBuffer();
        if ((diagnostics2 = CollectionsKt.filter(diagnostics2, actualDiagnostic -> psiFile.equals(actualDiagnostic.getFile()))).isEmpty() && uncheckedDiagnostics.isEmpty()) {
            result2.append(text2);
            return result2;
        }
        List<AbstractDiagnosticDescriptor> diagnosticDescriptors = CheckerTestUtil.getSortedDiagnosticDescriptors(diagnostics2, uncheckedDiagnostics);
        Stack<AbstractDiagnosticDescriptor> opened = new Stack<AbstractDiagnosticDescriptor>();
        ListIterator<AbstractDiagnosticDescriptor> iterator2 = diagnosticDescriptors.listIterator();
        AbstractDiagnosticDescriptor currentDescriptor = iterator2.next();
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            while (!opened.isEmpty() && i == ((AbstractDiagnosticDescriptor)opened.peek()).end) {
                CheckerTestUtil.closeDiagnosticString(result2);
                opened.pop();
            }
            while (currentDescriptor != null && i == currentDescriptor.start) {
                CheckerTestUtil.openDiagnosticsString(result2, currentDescriptor, diagnosticToExpectedDiagnostic, withNewInferenceDirective);
                if (currentDescriptor.getEnd() == i) {
                    CheckerTestUtil.closeDiagnosticString(result2);
                } else {
                    opened.push(currentDescriptor);
                }
                if (iterator2.hasNext()) {
                    currentDescriptor = iterator2.next();
                    continue;
                }
                currentDescriptor = null;
            }
            result2.append(c);
        }
        if (currentDescriptor != null) {
            assert (currentDescriptor.start == text2.length());
            assert (currentDescriptor.end == text2.length());
            CheckerTestUtil.openDiagnosticsString(result2, currentDescriptor, diagnosticToExpectedDiagnostic, withNewInferenceDirective);
            opened.push(currentDescriptor);
        }
        while (!opened.isEmpty() && text2.length() == ((AbstractDiagnosticDescriptor)opened.peek()).end) {
            CheckerTestUtil.closeDiagnosticString(result2);
            opened.pop();
        }
        assert (opened.isEmpty()) : "Stack is not empty: " + opened;
        return result2;
    }

    private static void openDiagnosticsString(StringBuffer result2, AbstractDiagnosticDescriptor currentDescriptor, Map<AbstractTestDiagnostic, TextDiagnostic> diagnosticToExpectedDiagnostic, boolean withNewInferenceDirective) {
        result2.append("<!");
        if (currentDescriptor instanceof TextDiagnosticDescriptor) {
            TextDiagnostic diagnostic = ((TextDiagnosticDescriptor)currentDescriptor).getTextDiagnostic();
            result2.append(diagnostic.asString());
        } else if (currentDescriptor instanceof ActualDiagnosticDescriptor) {
            List<AbstractTestDiagnostic> diagnostics2 = ((ActualDiagnosticDescriptor)currentDescriptor).getDiagnostics();
            Iterator<AbstractTestDiagnostic> iterator2 = diagnostics2.iterator();
            while (iterator2.hasNext()) {
                AbstractTestDiagnostic diagnostic = iterator2.next();
                TextDiagnostic expectedDiagnostic = diagnosticToExpectedDiagnostic.get(diagnostic);
                if (expectedDiagnostic != null) {
                    TextDiagnostic actualTextDiagnostic = TextDiagnostic.asTextDiagnostic(diagnostic);
                    if (CheckerTestUtil.compareTextDiagnostic(expectedDiagnostic, actualTextDiagnostic)) {
                        result2.append(expectedDiagnostic.asString());
                    } else {
                        result2.append(actualTextDiagnostic.asString());
                    }
                } else {
                    if (withNewInferenceDirective && diagnostic.getInferenceCompatibility().abbreviation != null) {
                        result2.append(diagnostic.getInferenceCompatibility().abbreviation);
                        result2.append(";");
                    }
                    if (diagnostic.getPlatform() != null) {
                        result2.append(diagnostic.getPlatform());
                        result2.append(":");
                    }
                    result2.append(diagnostic.getName());
                }
                if (!iterator2.hasNext()) continue;
                result2.append(", ");
            }
        } else {
            throw new IllegalStateException("Unknown diagnostic descriptor: " + currentDescriptor);
        }
        result2.append("!>");
    }

    private static void closeDiagnosticString(StringBuffer result2) {
        result2.append("<!>");
    }

    private static List<ActualDiagnosticDescriptor> getActualSortedDiagnosticDescriptors(@NotNull Collection<ActualDiagnostic> diagnostics2) {
        return CollectionsKt.filterIsInstance(CheckerTestUtil.getSortedDiagnosticDescriptors(diagnostics2, Collections.emptyList()), ActualDiagnosticDescriptor.class);
    }

    @NotNull
    private static List<AbstractDiagnosticDescriptor> getSortedDiagnosticDescriptors(@NotNull Collection<ActualDiagnostic> diagnostics2, @NotNull Collection<PositionalTextDiagnostic> uncheckedDiagnostics) {
        List<ActualDiagnostic> validDiagnostics = CollectionsKt.filter(diagnostics2, actualDiagnostic -> actualDiagnostic.diagnostic.isValid());
        List<AbstractDiagnosticDescriptor> diagnosticDescriptors = CheckerTestUtil.groupDiagnosticsByTextRange(validDiagnostics, uncheckedDiagnostics);
        diagnosticDescriptors.sort((d1, d2) -> ((AbstractDiagnosticDescriptor)d1).start != ((AbstractDiagnosticDescriptor)d2).start ? ((AbstractDiagnosticDescriptor)d1).start - ((AbstractDiagnosticDescriptor)d2).start : ((AbstractDiagnosticDescriptor)d2).end - ((AbstractDiagnosticDescriptor)d1).end);
        return diagnosticDescriptors;
    }

    @NotNull
    private static List<AbstractDiagnosticDescriptor> groupDiagnosticsByTextRange(@NotNull Collection<ActualDiagnostic> diagnostics2, @NotNull Collection<PositionalTextDiagnostic> uncheckedDiagnostics) {
        LinkedListMultimap<TextRange, AbstractTestDiagnostic> diagnosticsGroupedByRanges = LinkedListMultimap.create();
        for (ActualDiagnostic actualDiagnostic : diagnostics2) {
            Diagnostic diagnostic = actualDiagnostic.diagnostic;
            for (TextRange textRange : diagnostic.getTextRanges()) {
                diagnosticsGroupedByRanges.put(textRange, actualDiagnostic);
            }
        }
        for (PositionalTextDiagnostic uncheckedDiagnostic : uncheckedDiagnostics) {
            TextRange range2 = new TextRange(uncheckedDiagnostic.getStart(), uncheckedDiagnostic.getEnd());
            diagnosticsGroupedByRanges.put(range2, uncheckedDiagnostic.getDiagnostic());
        }
        return CollectionsKt.map(diagnosticsGroupedByRanges.keySet(), range -> {
            Collection abstractDiagnostics = diagnosticsGroupedByRanges.get(range);
            Comparator<AbstractTestDiagnostic> comparator = Comparator.comparing(AbstractTestDiagnostic::getInferenceCompatibility);
            boolean needSortingByName = CollectionsKt.any(abstractDiagnostics, diagnostic -> diagnostic.getInferenceCompatibility() != TextDiagnostic.InferenceCompatibility.ALL);
            if (needSortingByName) {
                comparator = comparator.thenComparing(Comparator.comparing(AbstractTestDiagnostic::getName));
            }
            abstractDiagnostics.sort(comparator);
            return new ActualDiagnosticDescriptor(range.getStartOffset(), range.getEndOffset(), (List<AbstractTestDiagnostic>)abstractDiagnostics);
        });
    }

    public static class DiagnosedRange {
        private final int start;
        private int end;
        private final List<TextDiagnostic> diagnostics = ContainerUtil.newSmartList();

        protected DiagnosedRange(int start) {
            this.start = start;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public List<TextDiagnostic> getDiagnostics() {
            return this.diagnostics;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public void addDiagnostic(String diagnostic) {
            this.diagnostics.add(TextDiagnostic.parseDiagnostic(diagnostic));
        }
    }

    public static class TextDiagnostic
    implements AbstractTestDiagnostic {
        @NotNull
        private final String name;
        @Nullable
        private final String platform;
        @Nullable
        private final List<String> parameters;
        @NotNull
        private InferenceCompatibility inferenceCompatibility;

        @NotNull
        private static TextDiagnostic parseDiagnostic(String text2) {
            Matcher matcher = INDIVIDUAL_DIAGNOSTIC_PATTERN.matcher(text2);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Could not parse diagnostic: " + text2);
            }
            InferenceCompatibility inference = TextDiagnostic.computeInferenceCompatibility(TextDiagnostic.extractDataBefore(matcher.group(1), ";"));
            String platform = TextDiagnostic.extractDataBefore(matcher.group(2), ":");
            String name = matcher.group(3);
            String parameters2 = matcher.group(4);
            if (parameters2 == null) {
                return new TextDiagnostic(name, platform, null, inference);
            }
            SmartList<String> parsedParameters = new SmartList<String>();
            Matcher parametersMatcher = INDIVIDUAL_PARAMETER_PATTERN.matcher(parameters2);
            while (parametersMatcher.find()) {
                parsedParameters.add(TextDiagnostic.unescape(parametersMatcher.group().trim()));
            }
            return new TextDiagnostic(name, platform, parsedParameters, inference);
        }

        private static InferenceCompatibility computeInferenceCompatibility(@Nullable String abbreviation) {
            if (abbreviation == null) {
                return InferenceCompatibility.ALL;
            }
            return ArraysKt.single(InferenceCompatibility.values(), inference -> abbreviation.equals(inference.abbreviation));
        }

        private static String extractDataBefore(@Nullable String prefix, @NotNull String anchor2) {
            assert (prefix == null || prefix.endsWith(anchor2)) : prefix;
            return prefix == null ? null : StringsKt.substringBeforeLast(prefix, anchor2, prefix);
        }

        @NotNull
        private static String escape(@NotNull String s) {
            return s.replaceAll("([\\)\\(;])", "\\\\$1");
        }

        @NotNull
        private static String unescape(@NotNull String s) {
            return s.replaceAll("\\\\([\\)\\(;])", "$1");
        }

        public static TextDiagnostic asTextDiagnostic(@NotNull AbstractTestDiagnostic abstractTestDiagnostic) {
            if (abstractTestDiagnostic instanceof ActualDiagnostic) {
                return TextDiagnostic.asTextDiagnostic((ActualDiagnostic)abstractTestDiagnostic);
            }
            return (TextDiagnostic)abstractTestDiagnostic;
        }

        @NotNull
        public static TextDiagnostic asTextDiagnostic(@NotNull ActualDiagnostic actualDiagnostic) {
            Diagnostic diagnostic = actualDiagnostic.diagnostic;
            DiagnosticRenderer renderer = DefaultErrorMessages.getRendererForDiagnostic(diagnostic);
            String diagnosticName = actualDiagnostic.getName();
            if (renderer instanceof AbstractDiagnosticWithParametersRenderer) {
                Object[] renderParameters = ((AbstractDiagnosticWithParametersRenderer)renderer).renderParameters(diagnostic);
                List<String> parameters2 = ContainerUtil.map(renderParameters, Object::toString);
                return new TextDiagnostic(diagnosticName, actualDiagnostic.platform, parameters2, actualDiagnostic.inferenceCompatibility);
            }
            return new TextDiagnostic(diagnosticName, actualDiagnostic.platform, null, actualDiagnostic.inferenceCompatibility);
        }

        public TextDiagnostic(@NotNull String name, @Nullable String platform, @Nullable List<String> parameters2, @Nullable InferenceCompatibility inference) {
            this.name = name;
            this.platform = platform;
            this.parameters = parameters2;
            this.inferenceCompatibility = inference != null ? inference : InferenceCompatibility.ALL;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @Nullable
        public String getPlatform() {
            return this.platform;
        }

        @NotNull
        public String getDescription() {
            return (this.platform != null ? this.platform + ":" : "") + this.name;
        }

        @Nullable
        public List<String> getParameters() {
            return this.parameters;
        }

        @Override
        @NotNull
        public InferenceCompatibility getInferenceCompatibility() {
            return this.inferenceCompatibility;
        }

        @Override
        public void enhanceInferenceCompatibility(InferenceCompatibility inferenceCompatibility) {
            this.inferenceCompatibility = inferenceCompatibility;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextDiagnostic that = (TextDiagnostic)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) {
                return false;
            }
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
                return false;
            }
            return this.inferenceCompatibility == that.inferenceCompatibility;
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = 31 * result2 + (this.platform != null ? this.platform.hashCode() : 0);
            result2 = 31 * result2 + (this.parameters != null ? this.parameters.hashCode() : 0);
            result2 = 31 * result2 + this.inferenceCompatibility.hashCode();
            return result2;
        }

        @NotNull
        public String asString() {
            StringBuilder result2 = new StringBuilder();
            if (this.inferenceCompatibility.abbreviation != null) {
                result2.append(this.inferenceCompatibility.abbreviation);
                result2.append(";");
            }
            if (this.platform != null) {
                result2.append(this.platform);
                result2.append(":");
            }
            result2.append(this.name);
            if (this.parameters != null) {
                result2.append("(");
                result2.append(StringUtil.join(this.parameters, TextDiagnostic::escape, "; "));
                result2.append(")");
            }
            return result2.toString();
        }

        public String toString() {
            return this.asString();
        }

        public static enum InferenceCompatibility {
            NEW("NI"),
            OLD("OI"),
            ALL(null);

            @Nullable
            String abbreviation;

            private InferenceCompatibility(@Nullable String abbreviation) {
                this.abbreviation = abbreviation;
            }

            public boolean isCompatible(InferenceCompatibility other) {
                return this == other || this == ALL || other == ALL;
            }
        }
    }

    public static class ActualDiagnostic
    implements AbstractTestDiagnostic {
        public final Diagnostic diagnostic;
        public final String platform;
        public TextDiagnostic.InferenceCompatibility inferenceCompatibility;

        ActualDiagnostic(@NotNull Diagnostic diagnostic, @Nullable String platform, boolean withNewInference) {
            this.diagnostic = diagnostic;
            this.platform = platform;
            this.inferenceCompatibility = withNewInference ? TextDiagnostic.InferenceCompatibility.NEW : TextDiagnostic.InferenceCompatibility.OLD;
        }

        @Override
        @NotNull
        public String getName() {
            return this.diagnostic.getFactory().getName();
        }

        @Override
        public String getPlatform() {
            return this.platform;
        }

        @NotNull
        public PsiFile getFile() {
            return this.diagnostic.getPsiFile();
        }

        @Override
        public TextDiagnostic.InferenceCompatibility getInferenceCompatibility() {
            return this.inferenceCompatibility;
        }

        @Override
        public void enhanceInferenceCompatibility(TextDiagnostic.InferenceCompatibility inferenceCompatibility) {
            this.inferenceCompatibility = inferenceCompatibility;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ActualDiagnostic)) {
                return false;
            }
            ActualDiagnostic other = (ActualDiagnostic)obj;
            return other.diagnostic == this.diagnostic && (other.platform == null ? this.platform == null : other.platform.equals(this.platform)) && other.inferenceCompatibility == this.inferenceCompatibility;
        }

        public int hashCode() {
            int result2 = System.identityHashCode(this.diagnostic);
            result2 = 31 * result2 + (this.platform != null ? this.platform.hashCode() : 0);
            result2 = 31 * result2 + this.inferenceCompatibility.hashCode();
            return result2;
        }

        public String toString() {
            String inferenceAbbreviation = this.inferenceCompatibility.abbreviation;
            return (inferenceAbbreviation != null ? inferenceAbbreviation + ";" : "") + (this.platform != null ? this.platform + ":" : "") + this.diagnostic.toString();
        }
    }

    public static interface AbstractTestDiagnostic {
        public String getName();

        public String getPlatform();

        public TextDiagnostic.InferenceCompatibility getInferenceCompatibility();

        public void enhanceInferenceCompatibility(TextDiagnostic.InferenceCompatibility var1);
    }

    private static class TextDiagnosticDescriptor
    extends AbstractDiagnosticDescriptor {
        private final PositionalTextDiagnostic positionalTextDiagnostic;

        public TextDiagnostic getTextDiagnostic() {
            return this.positionalTextDiagnostic.getDiagnostic();
        }
    }

    private static class ActualDiagnosticDescriptor
    extends AbstractDiagnosticDescriptor {
        private final List<AbstractTestDiagnostic> diagnostics;

        ActualDiagnosticDescriptor(int start, int end, List<AbstractTestDiagnostic> diagnostics2) {
            super(start, end);
            this.diagnostics = diagnostics2;
        }

        public List<AbstractTestDiagnostic> getDiagnostics() {
            return this.diagnostics;
        }

        public Map<AbstractTestDiagnostic, TextDiagnostic> getTextDiagnosticsMap() {
            HashMap<AbstractTestDiagnostic, TextDiagnostic> diagnosticMap = new HashMap<AbstractTestDiagnostic, TextDiagnostic>();
            for (AbstractTestDiagnostic diagnostic : this.diagnostics) {
                diagnosticMap.put(diagnostic, TextDiagnostic.asTextDiagnostic(diagnostic));
            }
            return diagnosticMap;
        }
    }

    private static abstract class AbstractDiagnosticDescriptor {
        private final int start;
        private final int end;

        AbstractDiagnosticDescriptor(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public TextRange getTextRange() {
            return new TextRange(this.start, this.end);
        }
    }

    public static class DebugInfoDiagnostic
    extends AbstractDiagnosticForTests {
        public DebugInfoDiagnostic(@NotNull KtElement element, @NotNull DebugInfoDiagnosticFactory factory2) {
            super(element, factory2);
        }
    }

    public static class DebugInfoDiagnosticFactory
    extends DiagnosticFactory<DebugInfoDiagnostic> {
        public static final DebugInfoDiagnosticFactory SMARTCAST = new DebugInfoDiagnosticFactory("SMARTCAST");
        public static final DebugInfoDiagnosticFactory IMPLICIT_RECEIVER_SMARTCAST = new DebugInfoDiagnosticFactory("IMPLICIT_RECEIVER_SMARTCAST");
        public static final DebugInfoDiagnosticFactory CONSTANT = new DebugInfoDiagnosticFactory("CONSTANT");
        public static final DebugInfoDiagnosticFactory LEAKING_THIS = new DebugInfoDiagnosticFactory("LEAKING_THIS");
        public static final DebugInfoDiagnosticFactory IMPLICIT_EXHAUSTIVE = new DebugInfoDiagnosticFactory("IMPLICIT_EXHAUSTIVE");
        public static final DebugInfoDiagnosticFactory ELEMENT_WITH_ERROR_TYPE = new DebugInfoDiagnosticFactory("ELEMENT_WITH_ERROR_TYPE");
        public static final DebugInfoDiagnosticFactory UNRESOLVED_WITH_TARGET = new DebugInfoDiagnosticFactory("UNRESOLVED_WITH_TARGET");
        public static final DebugInfoDiagnosticFactory MISSING_UNRESOLVED = new DebugInfoDiagnosticFactory("MISSING_UNRESOLVED");
        public static final DebugInfoDiagnosticFactory DYNAMIC = new DebugInfoDiagnosticFactory("DYNAMIC");
        private final String name;

        private DebugInfoDiagnosticFactory(String name, Severity severity) {
            super(severity);
            this.name = name;
        }

        private DebugInfoDiagnosticFactory(String name) {
            this(name, Severity.ERROR);
        }

        @Override
        @NotNull
        public String getName() {
            return "DEBUG_INFO_" + this.name;
        }
    }

    public static class SyntaxErrorDiagnostic
    extends AbstractDiagnosticForTests {
        public SyntaxErrorDiagnostic(@NotNull PsiErrorElement errorElement) {
            super(errorElement, SyntaxErrorDiagnosticFactory.INSTANCE);
        }
    }

    public static class SyntaxErrorDiagnosticFactory
    extends DiagnosticFactory<SyntaxErrorDiagnostic> {
        public static final SyntaxErrorDiagnosticFactory INSTANCE = new SyntaxErrorDiagnosticFactory();

        private SyntaxErrorDiagnosticFactory() {
            super(Severity.ERROR);
        }

        @Override
        @NotNull
        public String getName() {
            return "SYNTAX";
        }
    }

    public static class AbstractDiagnosticForTests
    implements Diagnostic {
        private final PsiElement element;
        private final DiagnosticFactory<?> factory;

        public AbstractDiagnosticForTests(@NotNull PsiElement element, @NotNull DiagnosticFactory<?> factory2) {
            this.element = element;
            this.factory = factory2;
        }

        @Override
        @NotNull
        public DiagnosticFactory<?> getFactory() {
            return this.factory;
        }

        @Override
        @NotNull
        public Severity getSeverity() {
            return Severity.ERROR;
        }

        @Override
        @NotNull
        public PsiElement getPsiElement() {
            return this.element;
        }

        @Override
        @NotNull
        public List<TextRange> getTextRanges() {
            return Collections.singletonList(this.element.getTextRange());
        }

        @Override
        @NotNull
        public PsiFile getPsiFile() {
            return this.element.getContainingFile();
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }

    public static interface DiagnosticDiffCallbacks {
        public void missingDiagnostic(TextDiagnostic var1, int var2, int var3);

        public void wrongParametersDiagnostic(TextDiagnostic var1, TextDiagnostic var2, int var3, int var4);

        public void unexpectedDiagnostic(TextDiagnostic var1, int var2, int var3);
    }
}

