/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.util.Hashtable;
import java.util.Stack;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.office.FontDeclaration;
import writer2latex.office.ListCounter;
import writer2latex.office.ListStyle;
import writer2latex.office.OfficeReader;
import writer2latex.office.OfficeStyle;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.Misc;
import writer2latex.xhtml.AlphabeticalIndexConverter;
import writer2latex.xhtml.BibliographyConverter;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.ConverterHelper;
import writer2latex.xhtml.EndnoteConverter;
import writer2latex.xhtml.FootnoteConverter;
import writer2latex.xhtml.LOFConverter;
import writer2latex.xhtml.LOTConverter;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xhtml.TOCConverter;
import writer2latex.xhtml.XhtmlConfig;
import writer2latex.xhtml.XhtmlStyleMap;
import writer2latex.xhtml.XhtmlStyleMapItem;

public class TextConverter
extends ConverterHelper {
    private int nSplitAfter = 150000;
    private int nPageBreakSplit = 0;
    private boolean bPendingPageBreak = false;
    private int nSplit = 0;
    private int nRepeatLevels = 5;
    private int nLastSplitLevel = 1;
    private int nDontSplitLevel = 0;
    boolean bAfterHeading = false;
    protected Stack<Node> sections = new Stack();
    Element[] currentHeading = new Element[7];
    private int nCharacterCount = 0;
    private ListCounter outlineNumbering;
    private Hashtable<String, ListCounter> listCounters = new Hashtable();
    private String sCurrentListLabel = null;
    private ListStyle currentListStyle = null;
    private int nCurrentListLevel = 0;
    private int nFloatMode;
    private TOCConverter tocCv;
    private LOFConverter lofCv;
    private LOTConverter lotCv;
    private AlphabeticalIndexConverter indexCv;
    private BibliographyConverter bibCv;
    private FootnoteConverter footCv;
    private EndnoteConverter endCv;
    private Node asapNode = null;
    private boolean bInToc = false;
    private boolean bDisplayHiddenText = false;

    public TextConverter(OfficeReader ofr, XhtmlConfig config, Converter converter) {
        super(ofr, config, converter);
        this.tocCv = new TOCConverter(ofr, config, converter);
        this.lofCv = new LOFConverter(ofr, config, converter);
        this.lotCv = new LOTConverter(ofr, config, converter);
        this.bibCv = new BibliographyConverter(ofr, config, converter);
        this.indexCv = new AlphabeticalIndexConverter(ofr, config, converter);
        this.footCv = new FootnoteConverter(ofr, config, converter);
        this.endCv = new EndnoteConverter(ofr, config, converter);
        this.nSplitAfter = 1000 * config.splitAfter();
        this.nPageBreakSplit = config.pageBreakSplit();
        this.nSplit = config.getXhtmlSplitLevel();
        this.nRepeatLevels = converter.isOPS() ? 0 : config.getXhtmlRepeatLevels();
        this.nFloatMode = ofr.isText() && config.xhtmlFloatObjects() ? 1 : 2;
        this.outlineNumbering = new ListCounter(ofr.getOutlineStyle());
        this.bDisplayHiddenText = config.displayHiddenText();
    }

    public void convertTextContent(Element onode) {
        Element form;
        Element hnode = this.converter.nextOutFile();
        if (this.nSplit == 0 && (form = this.getDrawCv().createForm()) != null) {
            hnode.appendChild(form);
            hnode = form;
        }
        hnode = this.getDrawCv().insertCoverImage(hnode);
        hnode = (Element)this.traverseBlockText(onode, hnode);
        this.footCv.insertFootnotes(hnode, true);
        this.endCv.insertEndnotes(hnode);
        this.bInToc = true;
        this.tocCv.generate();
        this.bInToc = false;
        this.generateHeaders();
        this.generateFooters();
        this.bInToc = true;
        this.tocCv.generatePanels(this.nSplit);
        this.bInToc = false;
    }

    protected int getTocIndex() {
        return this.tocCv.getFileIndex();
    }

    protected int getAlphabeticalIndex() {
        return this.indexCv.getFileIndex();
    }

    protected void setAsapNode(Element node) {
        this.asapNode = node;
    }

    private void generateHeaders() {
    }

    private void generateFooters() {
    }

    public Node traverseBlockText(Node onode, Node hnode) {
        return this.traverseBlockText(onode, 0, null, hnode);
    }

    private Node traverseBlockText(Node onode, int nLevel, String styleName, Node hnode) {
        if (!onode.hasChildNodes()) {
            return hnode;
        }
        this.bAfterHeading = false;
        NodeList nList = onode.getChildNodes();
        int nLen = nList.getLength();
        for (int i = 0; i < nLen; ++i) {
            StyleWithProperties style;
            Node child = nList.item(i);
            if (child.getNodeType() != 1) continue;
            String nodeName = child.getNodeName();
            ++this.nDontSplitLevel;
            if (OfficeReader.isDrawElement(child)) {
                this.getDrawCv().handleDrawElement((Element)child, (Element)hnode, null, this.nFloatMode);
            } else if (nodeName.equals("text:p")) {
                String sDisplayName;
                style = this.ofr.getParStyle(Misc.getAttribute(child, "text:style-name"));
                hnode = this.maybeSplit(hnode, style);
                this.nCharacterCount += OfficeReader.getCharacterCount(child);
                XhtmlStyleMap xpar = this.config.getXParStyleMap();
                String string = sDisplayName = style != null ? style.getDisplayName() : null;
                if (sDisplayName != null && xpar.contains(sDisplayName)) {
                    Node curHnode = hnode;
                    XhtmlStyleMapItem map = xpar.get(sDisplayName);
                    String sBlockElement = map.sBlockElement;
                    String sBlockCss = map.sBlockCss;
                    if (map.sBlockElement.length() > 0) {
                        Element block = this.converter.createElement(map.sBlockElement);
                        if (!"(none)".equals(map.sBlockCss)) {
                            block.setAttribute("class", map.sBlockCss);
                        }
                        hnode.appendChild(block);
                        curHnode = block;
                    }
                    boolean bMoreParagraphs = true;
                    do {
                        String sCurDisplayName;
                        String cnodeName;
                        this.handleParagraph(child, curHnode);
                        bMoreParagraphs = false;
                        if (++i >= nLen || !(cnodeName = (child = nList.item(i)).getNodeName()).equals("text:p") || (sCurDisplayName = this.ofr.getParStyles().getDisplayName(Misc.getAttribute(child, "text:style-name"))) == null || !xpar.contains(sCurDisplayName)) continue;
                        XhtmlStyleMapItem newmap = xpar.get(sCurDisplayName);
                        if (!sBlockElement.equals(newmap.sBlockElement) || !sBlockCss.equals(newmap.sBlockCss)) continue;
                        bMoreParagraphs = true;
                    } while (bMoreParagraphs);
                    --i;
                } else {
                    this.handleParagraph(child, hnode);
                }
            } else if (nodeName.equals("text:h")) {
                style = this.ofr.getParStyle(Misc.getAttribute(child, "text:style-name"));
                int nOutlineLevel = this.getOutlineLevel((Element)child);
                Node rememberNode = hnode;
                hnode = this.maybeSplit(hnode, style, nOutlineLevel);
                this.nCharacterCount += OfficeReader.getCharacterCount(child);
                this.handleHeading((Element)child, (Element)hnode, rememberNode != hnode);
            } else if (nodeName.equals("text:list") || nodeName.equals("text:unordered-list") || nodeName.equals("text:ordered-list")) {
                hnode = this.maybeSplit(hnode, null);
                if (this.listIsOnlyHeadings(child)) {
                    --this.nDontSplitLevel;
                    hnode = this.handleFakeList(child, nLevel + 1, styleName, hnode);
                    ++this.nDontSplitLevel;
                } else {
                    this.handleList(child, nLevel + 1, styleName, hnode);
                }
            } else if (nodeName.equals("table:table")) {
                style = this.ofr.getTableStyle(Misc.getAttribute(child, "text:style-name"));
                hnode = this.maybeSplit(hnode, style);
                this.getTableCv().handleTable(child, hnode);
            } else if (nodeName.equals("table:sub-table")) {
                this.getTableCv().handleTable(child, hnode);
            } else if (nodeName.equals("text:section")) {
                hnode = this.maybeSplit(hnode, null);
                --this.nDontSplitLevel;
                hnode = this.handleSection(child, hnode);
                ++this.nDontSplitLevel;
            } else if (nodeName.equals("text:table-of-content")) {
                if (!this.ofr.getTocReader((Element)child).isByChapter()) {
                    hnode = this.maybeSplit(hnode, null, 1);
                }
                this.tocCv.handleIndex((Element)child, (Element)hnode);
            } else if (nodeName.equals("text:illustration-index")) {
                this.lofCv.handleLOF(child, hnode);
            } else if (nodeName.equals("text:table-index")) {
                this.lotCv.handleLOT(child, hnode);
            } else if (!nodeName.equals("text:object-index") && !nodeName.equals("text:user-index")) {
                if (nodeName.equals("text:alphabetical-index")) {
                    hnode = this.maybeSplit(hnode, null, 1);
                    this.indexCv.handleIndex((Element)child, (Element)hnode);
                } else if (nodeName.equals("text:bibliography")) {
                    hnode = this.maybeSplit(hnode, null, 1);
                    this.bibCv.handleIndex((Element)child, (Element)hnode);
                } else if (nodeName.equals("text:soft-page-break")) {
                    if (this.nPageBreakSplit == 3) {
                        this.bPendingPageBreak = true;
                    }
                } else if (nodeName.equals("office:annotation")) {
                    this.converter.handleOfficeAnnotation(child, hnode);
                } else if (nodeName.equals("text:sequence-decls")) {
                    // empty if block
                }
            }
            --this.nDontSplitLevel;
            if (this.nDontSplitLevel != 0) continue;
            this.bAfterHeading = nodeName.equals("text:h");
            hnode = this.getDrawCv().flushFullscreenFrames((Element)hnode);
        }
        return hnode;
    }

    private boolean getPageBreak(StyleWithProperties style) {
        if (style != null && this.nPageBreakSplit > 0) {
            if (style.isAutomatic() && this.nPageBreakSplit < 2) {
                OfficeStyle parentStyle = style.getParentStyle();
                if (parentStyle != null && parentStyle instanceof StyleWithProperties) {
                    style = (StyleWithProperties)parentStyle;
                } else {
                    return false;
                }
            }
            if ("page".equals(style.getProperty("fo:break-before"))) {
                return true;
            }
            if ("page".equals(style.getProperty("fo:break-after"))) {
                this.bPendingPageBreak = true;
                return false;
            }
            String sMasterPage = style.getMasterPageName();
            if (sMasterPage != null && sMasterPage.length() > 0) {
                return true;
            }
        }
        return false;
    }

    private Node maybeSplit(Node node, StyleWithProperties style) {
        return this.maybeSplit(node, style, -1);
    }

    private Node maybeSplit(Node node, StyleWithProperties style, int nLevel) {
        if (this.bPendingPageBreak) {
            return this.doMaybeSplit(node, 0);
        }
        if (this.getPageBreak(style)) {
            return this.doMaybeSplit(node, 0);
        }
        if (this.converter.isOPS() && this.nSplitAfter > 0 && this.nCharacterCount > this.nSplitAfter) {
            return this.doMaybeSplit(node, 0);
        }
        if (nLevel >= 0) {
            return this.doMaybeSplit(node, nLevel);
        }
        return node;
    }

    protected Element doMaybeSplit(Node node, int nLevel) {
        if (this.nDontSplitLevel > 1) {
            return (Element)node;
        }
        if (!this.converter.isOPS() && this.bAfterHeading && nLevel - this.nLastSplitLevel <= this.nRepeatLevels) {
            return (Element)node;
        }
        if (this.nSplit >= nLevel && this.converter.outFileHasContent()) {
            this.nCharacterCount = 0;
            this.bPendingPageBreak = false;
            if (this.converter.getOutFileIndex() >= 0) {
                this.footCv.insertFootnotes(node, false);
            }
            return this.converter.nextOutFile();
        }
        return (Element)node;
    }

    private Node handleSection(Node onode, Node hnode) {
        if (!this.bDisplayHiddenText && "none".equals(Misc.getAttribute(onode, "text:display"))) {
            return hnode;
        }
        String sName = Misc.getAttribute(onode, "text:name");
        String sStyleName = Misc.getAttribute(onode, "text:style-name");
        Element div = this.converter.createElement("div");
        hnode.appendChild(div);
        this.converter.addTarget(div, sName + "|region");
        StyleInfo sectionInfo = new StyleInfo();
        this.getSectionSc().applyStyle(sStyleName, sectionInfo);
        this.applyStyle(sectionInfo, div);
        this.sections.push(onode);
        Node newhnode = this.traverseBlockText(onode, div);
        this.sections.pop();
        return newhnode.getParentNode();
    }

    private void handleHeading(Element onode, Element hnode, boolean bAfterSplit) {
        int nListLevel = this.getOutlineLevel(onode);
        boolean bUnNumbered = "true".equals(Misc.getAttribute(onode, "text:is-list-header"));
        boolean bRestart = "true".equals(Misc.getAttribute(onode, "text:restart-numbering"));
        int nStartValue = Misc.getPosInteger(Misc.getAttribute(onode, "text:start-value"), 1) - 1;
        this.handleHeading(onode, hnode, bAfterSplit, this.ofr.getOutlineStyle(), nListLevel, bUnNumbered, bRestart, nStartValue);
    }

    private void handleHeading(Element onode, Element hnode, boolean bAfterSplit, ListStyle listStyle, int nListLevel, boolean bUnNumbered, boolean bRestart, int nStartValue) {
        int nLevel = this.getOutlineLevel(onode);
        if (nLevel <= 6) {
            String sStrikeOut;
            String sListStyleName;
            String sStyleName = onode.getAttribute("text:style-name");
            StyleWithProperties style = this.ofr.getParStyle(sStyleName);
            if (!this.bDisplayHiddenText && style != null && "none".equals(style.getProperty("text:display"))) {
                return;
            }
            if (!bUnNumbered && style != null && (sListStyleName = style.getListStyleName()) != null && sListStyleName.length() == 0) {
                bUnNumbered = true;
            }
            ListCounter counter = null;
            String sLabel = "";
            if (!bUnNumbered) {
                counter = this.getListCounter(listStyle);
                if (bRestart) {
                    counter.restart(nListLevel, nStartValue);
                }
                sLabel = counter.step(nListLevel).getLabel();
            }
            boolean bTocOnly = false;
            if (this.converter.isOPS() && style != null && (sStrikeOut = style.getProperty("style:text-line-through-style", true)) != null && !"none".equals(sStrikeOut)) {
                bTocOnly = true;
            }
            if (!bTocOnly) {
                if (bAfterSplit && this.nSplit > 0) {
                    int nFirst = nLevel - this.nRepeatLevels;
                    if (nFirst < 0) {
                        nFirst = 0;
                    }
                    for (int i = nFirst; i < nLevel; ++i) {
                        if (this.currentHeading[i] == null) continue;
                        hnode.appendChild(this.converter.importNode(this.currentHeading[i], true));
                    }
                }
                StyleInfo info = new StyleInfo();
                info.sTagName = "h" + nLevel;
                this.getHeadingSc().applyStyle(nLevel, sStyleName, info);
                Element heading = this.converter.createElement(info.sTagName);
                hnode.appendChild(heading);
                this.applyStyle(info, heading);
                this.traverseFloats(onode, hnode, heading);
                this.prependAsapNode(heading);
                if (!bUnNumbered) {
                    this.insertListLabel(listStyle, nListLevel, "SectionNumber", null, sLabel, heading);
                }
                if (!this.bInToc) {
                    this.tocCv.handleHeading(onode, heading, sLabel);
                }
                StyleInfo innerInfo = new StyleInfo();
                this.getHeadingSc().applyInnerStyle(nLevel, sStyleName, innerInfo);
                Element content = heading;
                if (innerInfo.sTagName != null && innerInfo.sTagName.length() > 0) {
                    content = this.converter.createElement(innerInfo.sTagName);
                    heading.appendChild(content);
                    this.applyStyle(innerInfo, content);
                }
                this.traverseInlineText(onode, content);
                this.addBeforeAfter(heading, this.ofr.getParStyle(this.getParSc().getRealParStyleName(sStyleName)), this.config.getXHeadingStyleMap());
                this.currentHeading[nLevel] = heading;
                for (int i = nLevel + 1; i <= 6; ++i) {
                    this.currentHeading[i] = null;
                }
            } else {
                if (!this.bInToc) {
                    this.tocCv.handleHeadingExternal(onode, hnode, sLabel);
                }
                this.currentHeading[nLevel] = null;
                for (int i = nLevel + 1; i <= 6; ++i) {
                    this.currentHeading[i] = null;
                }
            }
        } else {
            this.handleParagraph(onode, hnode);
        }
    }

    private void handleParagraph(Node onode, Node hnode) {
        Element par;
        boolean bIsEmpty = OfficeReader.isWhitespaceContent(onode);
        if (this.config.ignoreEmptyParagraphs() && bIsEmpty) {
            return;
        }
        String sStyleName = Misc.getAttribute(onode, "text:style-name");
        StyleWithProperties style = this.ofr.getParStyle(sStyleName);
        if (!this.bDisplayHiddenText && style != null && "none".equals(style.getProperty("text:display"))) {
            return;
        }
        if (this.ofr.isSpreadsheet()) {
            par = (Element)hnode;
        } else {
            Element temp = this.converter.createElement("temp");
            par = this.createParagraph(temp, sStyleName);
            this.prependAsapNode(par);
            this.traverseFloats(onode, hnode, par);
            hnode.appendChild(temp.getFirstChild());
        }
        this.tocCv.handleParagraph((Element)onode, par, this.sCurrentListLabel);
        if (!bIsEmpty) {
            par = this.createTextBackground(par, sStyleName);
            if (this.config.listFormatting() == 2) {
                this.insertListLabel(this.currentListStyle, this.nCurrentListLevel, "ItemNumber", null, this.sCurrentListLabel, par);
            }
            this.sCurrentListLabel = null;
            this.traverseInlineText(onode, par);
        } else {
            par.appendChild(this.converter.createTextNode("\u00a0"));
            this.sCurrentListLabel = null;
        }
        if (this.converter.isOPS() && !par.hasChildNodes()) {
            hnode.removeChild(par);
        } else {
            this.addBeforeAfter(par, this.ofr.getParStyle(this.getParSc().getRealParStyleName(sStyleName)), this.config.getXParStyleMap());
        }
    }

    private void prependAsapNode(Node node) {
        if (this.asapNode != null) {
            if (this.asapNode.getOwnerDocument() != node.getOwnerDocument()) {
                this.asapNode = this.converter.importNode(this.asapNode, true);
            }
            node.appendChild(this.asapNode);
            this.asapNode = null;
        }
    }

    private ListCounter getListCounter(ListStyle style) {
        if (style == this.ofr.getOutlineStyle()) {
            return this.outlineNumbering;
        }
        if (style != null) {
            if (this.listCounters.containsKey(style.getName())) {
                return this.listCounters.get(style.getName());
            }
            ListCounter counter = new ListCounter(style);
            this.listCounters.put(style.getName(), counter);
            return counter;
        }
        return new ListCounter();
    }

    private void insertListLabel(ListStyle style, int nLevel, String sDefaultStyle, String sPrefix, String sLabel, Element hnode) {
        if (sLabel != null && sLabel.length() > 0) {
            if (sPrefix != null) {
                Element prefix = this.converter.createElement("span");
                prefix.setAttribute("class", "chapter-name");
                hnode.appendChild(prefix);
                prefix.appendChild(this.converter.createTextNode(sPrefix));
            }
            StyleInfo info = new StyleInfo();
            if (style != null) {
                String sTextStyleName = style.getLevelProperty(nLevel, "text:style-name");
                this.getTextSc().applyStyle(sTextStyleName, info);
            }
            if (info.sTagName == null) {
                info.sTagName = "span";
            }
            if (info.sClass == null) {
                info.sClass = sDefaultStyle;
            }
            Element content = this.converter.createElement(info.sTagName);
            this.getTextSc().applyStyle(info, content);
            hnode.appendChild(content);
            content.appendChild(this.converter.createTextNode(sLabel));
        }
    }

    private boolean hasItems(Node onode) {
        for (Node child = onode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!Misc.isElement(child, "text:list-item") && !Misc.isElement(child, "text:list-header")) continue;
            return true;
        }
        return false;
    }

    private void handleOL(Node onode, int nLevel, String sStyleName, Node hnode) {
        if (this.hasItems(onode)) {
            Element list = this.converter.createElement("ol");
            StyleInfo listInfo = new StyleInfo();
            this.getListSc().applyStyle(nLevel, sStyleName, listInfo);
            this.applyStyle(listInfo, list);
            hnode.appendChild(list);
            this.traverseList(onode, nLevel, sStyleName, list);
        }
    }

    private void handleUL(Node onode, int nLevel, String sStyleName, Node hnode) {
        if (this.hasItems(onode)) {
            Element list = this.converter.createElement("ul");
            StyleInfo listInfo = new StyleInfo();
            this.getListSc().applyStyle(nLevel, sStyleName, listInfo);
            this.applyStyle(listInfo, list);
            hnode.appendChild(list);
            this.traverseList(onode, nLevel, sStyleName, list);
        }
    }

    private void handleList(Node onode, int nLevel, String sStyleName, Node hnode) {
        ListStyle style;
        String sStyleName1 = Misc.getAttribute(onode, "text:style-name");
        if (sStyleName1 != null) {
            sStyleName = sStyleName1;
        }
        if ((style = this.ofr.getListStyle(sStyleName)) != null && style.isNumber(nLevel)) {
            this.handleOL(onode, nLevel, sStyleName, hnode);
        } else {
            this.handleUL(onode, nLevel, sStyleName, hnode);
        }
    }

    private void traverseList(Node onode, int nLevel, String styleName, Element hnode) {
        ListCounter counter = this.getListCounter(this.ofr.getListStyle(styleName));
        boolean bContinueNumbering = "true".equals(Misc.getAttribute(onode, "text:continue-numbering"));
        if (!bContinueNumbering && counter != null) {
            counter.restart(nLevel);
        }
        if (this.config.listFormatting() == 1 && counter.getValue(nLevel) > 0) {
            hnode.setAttribute("start", Integer.toString(counter.getValue(nLevel) + 1));
        }
        if (onode.hasChildNodes()) {
            NodeList nList = onode.getChildNodes();
            int len = nList.getLength();
            for (int i = 0; i < len; ++i) {
                Node child = nList.item(i);
                if (child.getNodeType() != 1) continue;
                String nodeName = child.getNodeName();
                if (nodeName.equals("text:list-item")) {
                    boolean bIsImmediateNestedList = false;
                    Element child1 = Misc.getFirstChildElement(child);
                    if (child1.getTagName().equals("text:ordered-list") || child1.getTagName().equals("text:unordered-list") || child1.getTagName().equals("text:list")) {
                        bIsImmediateNestedList = true;
                    }
                    if (this.config.listFormatting() == 1 && bIsImmediateNestedList) {
                        this.traverseListItem(child, nLevel, styleName, hnode);
                    } else {
                        this.sCurrentListLabel = counter.step(nLevel).getLabel();
                        this.currentListStyle = this.ofr.getListStyle(styleName);
                        this.nCurrentListLevel = nLevel;
                        Element item = this.converter.createElement("li");
                        StyleInfo info = new StyleInfo();
                        this.getPresentationSc().applyOutlineStyle(nLevel, info);
                        this.applyStyle(info, item);
                        hnode.appendChild(item);
                        if (this.config.listFormatting() == 1) {
                            boolean bRestart = "true".equals(Misc.getAttribute(child, "text:restart-numbering"));
                            int nStartValue = Misc.getPosInteger(Misc.getAttribute(child, "text:start-value"), 1);
                            if (bRestart) {
                                item.setAttribute("value", Integer.toString(nStartValue));
                                this.sCurrentListLabel = counter.restart(nLevel, nStartValue).getLabel();
                            }
                        }
                        this.traverseListItem(child, nLevel, styleName, item);
                    }
                }
                if (!nodeName.equals("text:list-header")) continue;
                Element item = this.converter.createElement("li");
                hnode.appendChild(item);
                item.setAttribute("style", "list-style-type:none");
                this.traverseListItem(child, nLevel, styleName, item);
            }
        }
    }

    private void traverseListItem(Node onode, int nLevel, String styleName, Node hnode) {
        if (this.config.xhtmlFormatting() != 3 && onode.hasChildNodes()) {
            int i;
            NodeList list = onode.getChildNodes();
            int nLen = list.getLength();
            int nParCount = 0;
            boolean bNoPTag = true;
            for (i = 0; i < nLen; ++i) {
                if (list.item(i).getNodeType() != 1) continue;
                if (list.item(i).getNodeName().equals("text:p")) {
                    ++nParCount;
                    if (!bNoPTag) continue;
                    String sDisplayName = this.ofr.getParStyles().getDisplayName(Misc.getAttribute(list.item(0), "text:style-name"));
                    if (!this.config.getXParStyleMap().contains(sDisplayName)) continue;
                    bNoPTag = false;
                    continue;
                }
                bNoPTag = false;
            }
            if (bNoPTag && nParCount <= 1) {
                for (i = 0; i < nLen; ++i) {
                    Node child = list.item(i);
                    if (child.getNodeType() != 1) continue;
                    String nodeName = child.getNodeName();
                    if (nodeName.equals("text:p")) {
                        this.traverseInlineText(child, hnode);
                    }
                    if (nodeName.equals("text:list")) {
                        this.handleList(child, nLevel + 1, styleName, hnode);
                    }
                    if (nodeName.equals("text:ordered-list")) {
                        this.handleOL(child, nLevel + 1, styleName, hnode);
                    }
                    if (!nodeName.equals("text:unordered-list")) continue;
                    this.handleUL(child, nLevel + 1, styleName, hnode);
                }
                return;
            }
        }
        this.traverseBlockText(onode, nLevel, styleName, hnode);
    }

    private boolean listIsOnlyHeadings(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String nodeName;
            if (child.getNodeType() != 1 || !((nodeName = child.getNodeName()).equals("text:list-item") ? !this.itemIsOnlyHeadings(child) : nodeName.equals("text:list-header") && !this.itemIsOnlyHeadings(child))) continue;
            return false;
        }
        return true;
    }

    private boolean itemIsOnlyHeadings(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String nodeName;
            if (child.getNodeType() != 1 || !((nodeName = child.getNodeName()).equals("text:list") ? !this.listIsOnlyHeadings(child) : (nodeName.equals("text:ordered-list") ? !this.listIsOnlyHeadings(child) : (nodeName.equals("text:unordered-list") ? !this.listIsOnlyHeadings(child) : !nodeName.equals("text:h"))))) continue;
            return false;
        }
        return true;
    }

    private Node handleFakeList(Node onode, int nLevel, String sStyleName, Node hnode) {
        String sStyleName1 = Misc.getAttribute(onode, "text:style-name");
        if (sStyleName1 != null) {
            sStyleName = sStyleName1;
        }
        return this.traverseFakeList(onode, hnode, nLevel, sStyleName);
    }

    private Node traverseFakeList(Node onode, Node hnode, int nLevel, String sStyleName) {
        boolean bContinueNumbering = "true".equals(Misc.getAttribute(onode, "text:continue-numbering"));
        if (!bContinueNumbering) {
            this.getListCounter(this.ofr.getListStyle(sStyleName)).restart(nLevel);
        }
        for (Node child = onode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            String sNodeName = child.getNodeName();
            if (sNodeName.equals("text:list-item")) {
                boolean bRestart = "true".equals(Misc.getAttribute(child, "text:restart-numbering"));
                int nStartValue = Misc.getPosInteger(Misc.getAttribute(child, "text:start-value"), 1);
                hnode = this.traverseFakeListItem(child, hnode, nLevel, sStyleName, false, bRestart, nStartValue);
                continue;
            }
            if (!sNodeName.equals("text:list-header")) continue;
            hnode = this.traverseFakeListItem(child, hnode, nLevel, sStyleName, true, false, 0);
        }
        return hnode;
    }

    private Node traverseFakeListItem(Node onode, Node hnode, int nLevel, String sStyleName, boolean bUnNumbered, boolean bRestart, int nStartValue) {
        for (Node child = onode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            String sNodeName = child.getNodeName();
            if (sNodeName.equals("text:h")) {
                ++this.nDontSplitLevel;
                int nOutlineLevel = this.getOutlineLevel((Element)onode);
                Node rememberNode = hnode;
                StyleWithProperties style = this.ofr.getParStyle(Misc.getAttribute(child, "text:style-name"));
                hnode = this.maybeSplit(hnode, style, nOutlineLevel);
                this.handleHeading((Element)child, (Element)hnode, rememberNode != hnode, this.ofr.getListStyle(sStyleName), nLevel, bUnNumbered, bRestart, nStartValue);
                --this.nDontSplitLevel;
                if (this.nDontSplitLevel != 0) continue;
                this.bAfterHeading = true;
                continue;
            }
            if (sNodeName.equals("text:p")) continue;
            if (sNodeName.equals("text:list")) {
                return this.traverseFakeList(child, hnode, nLevel + 1, sStyleName);
            }
            if (sNodeName.equals("text:ordered-list")) {
                return this.traverseFakeList(child, hnode, nLevel + 1, sStyleName);
            }
            if (!sNodeName.equals("text:unordered-list")) continue;
            return this.traverseFakeList(child, hnode, nLevel + 1, sStyleName);
        }
        return hnode;
    }

    private void traverseFloats(Node onode, Node hnodeBlock, Node hnodeInline) {
        for (Node child = onode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            Element elm = (Element)child;
            if (OfficeReader.isDrawElement(elm)) {
                elm = this.getDrawCv().getRealDrawElement(elm);
                String sAnchor = elm.getAttribute("text:anchor-type");
                if (Misc.isElement(elm, "draw:frame")) {
                    elm = Misc.getFirstChildElement(elm);
                }
                if (elm == null) continue;
                String sTag = elm.getTagName();
                if (!"as-char".equals(sAnchor)) {
                    this.getDrawCv().handleDrawElement(elm, (Element)hnodeBlock, (Element)hnodeInline, this.nFloatMode);
                    continue;
                }
                if (!"draw:text-box".equals(sTag)) continue;
                this.getDrawCv().handleDrawElement(elm, (Element)hnodeBlock, (Element)hnodeInline, 0);
                continue;
            }
            if (!OfficeReader.isTextElement(elm) || OfficeReader.isNoteElement(elm)) continue;
            this.traverseFloats(elm, hnodeBlock, hnodeInline);
        }
    }

    protected void traverseInlineText(Node onode, Node hnode) {
        if (onode.hasChildNodes()) {
            NodeList nList = onode.getChildNodes();
            int nLen = nList.getLength();
            block4: for (int i = 0; i < nLen; ++i) {
                Node child = nList.item(i);
                short nodeType = child.getNodeType();
                switch (nodeType) {
                    case 3: {
                        String s = child.getNodeValue();
                        if (s.length() <= 0) continue block4;
                        hnode.appendChild(this.converter.createTextNode(s));
                        continue block4;
                    }
                    case 1: {
                        String sName = child.getNodeName();
                        if (OfficeReader.isDrawElement(child)) {
                            String sAnchor;
                            Element elm = this.getDrawCv().getRealDrawElement((Element)child);
                            if (elm == null || !"as-char".equals(sAnchor = elm.getAttribute("text:anchor-type"))) continue block4;
                            this.getDrawCv().handleDrawElement(elm, null, (Element)hnode, 0);
                            continue block4;
                        }
                        if (child.getNodeName().equals("text:s")) {
                            if (this.config.ignoreDoubleSpaces()) {
                                hnode.appendChild(this.converter.createTextNode(" "));
                                continue block4;
                            }
                            for (int count = Misc.getPosInteger(Misc.getAttribute(child, "text:c"), 1); count > 0; --count) {
                                hnode.appendChild(this.converter.createTextNode("\u00a0"));
                            }
                            continue block4;
                        }
                        if (sName.equals("text:tab-stop")) {
                            this.handleTabStop(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:tab")) {
                            this.handleTabStop(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:line-break")) {
                            if (this.config.ignoreHardLineBreaks()) continue block4;
                            hnode.appendChild(this.converter.createElement("br"));
                            continue block4;
                        }
                        if (sName.equals("text:span")) {
                            this.handleSpan(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:a")) {
                            this.handleAnchor(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:footnote")) {
                            this.footCv.handleNote(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:endnote")) {
                            this.endCv.handleNote(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:note")) {
                            if ("endnote".equals(Misc.getAttribute(child, "text:note-class"))) {
                                this.endCv.handleNote(child, hnode);
                                continue block4;
                            }
                            this.footCv.handleNote(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:sequence")) {
                            this.handleSequence(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:page-number")) {
                            this.handlePageNumber(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:page-count")) {
                            this.handlePageCount(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:sequence-ref")) {
                            this.handleSequenceRef(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:footnote-ref")) {
                            this.handleNoteRef(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:endnote-ref")) {
                            this.handleNoteRef(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:note-ref")) {
                            this.handleNoteRef(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:reference-mark")) {
                            this.handleReferenceMark(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:reference-mark-start")) {
                            this.handleReferenceMark(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:reference-ref")) {
                            this.handleReferenceRef(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:bookmark")) {
                            this.handleBookmark(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:bookmark-start")) {
                            this.handleBookmark(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:bookmark-ref")) {
                            this.handleBookmarkRef(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:alphabetical-index-mark")) {
                            if (this.bInToc) continue block4;
                            this.indexCv.handleIndexMark(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:alphabetical-index-mark-start")) {
                            if (this.bInToc) continue block4;
                            this.indexCv.handleIndexMarkStart(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:toc-mark")) {
                            this.tocCv.handleTocMark(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:toc-mark-start")) {
                            this.tocCv.handleTocMark(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:bibliography-mark")) {
                            this.handleBibliographyMark(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:soft-page-break")) {
                            if (this.nPageBreakSplit != 3) continue block4;
                            this.bPendingPageBreak = true;
                            continue block4;
                        }
                        if (sName.equals("office:annotation")) {
                            this.converter.handleOfficeAnnotation(child, hnode);
                            continue block4;
                        }
                        if (!sName.startsWith("text:")) continue block4;
                        this.traverseInlineText(child, hnode);
                        continue block4;
                    }
                }
            }
        }
    }

    private void handleTabStop(Node onode, Node hnode) {
        if (this.config.getXhtmlTabstopStyle().length() > 0) {
            Element span = this.converter.createElement("span");
            hnode.appendChild(span);
            span.setAttribute("class", this.config.getXhtmlTabstopStyle());
            span.appendChild(this.converter.createTextNode("\t"));
        } else {
            hnode.appendChild(this.converter.createTextNode("\t"));
        }
    }

    private void handleSpan(Node onode, Node hnode) {
        StyleWithProperties style = this.ofr.getTextStyle(Misc.getAttribute(onode, "text:style-name"));
        if (!this.bDisplayHiddenText && style != null && "none".equals(style.getProperty("text:display"))) {
            return;
        }
        if (!this.bInToc) {
            String sStyleName = Misc.getAttribute(onode, "text:style-name");
            Element span = this.createInline((Element)hnode, sStyleName);
            this.traverseInlineText(onode, span);
        } else {
            this.traverseInlineText(onode, hnode);
        }
    }

    protected void traversePCDATA(Node onode, Node hnode) {
        if (onode.hasChildNodes()) {
            NodeList nl = onode.getChildNodes();
            int nLen = nl.getLength();
            for (int i = 0; i < nLen; ++i) {
                if (nl.item(i).getNodeType() != 3) continue;
                hnode.appendChild(this.converter.createTextNode(nl.item(i).getNodeValue()));
            }
        }
    }

    protected void handleAnchor(Node onode, Node hnode) {
        Element anchor = this.converter.createLink((Element)onode);
        hnode.appendChild(anchor);
        this.traverseInlineText(onode, anchor);
    }

    private void handlePageNumber(Node onode, Node hnode) {
        hnode.appendChild(this.converter.createTextNode("(Page number)"));
    }

    private void handlePageCount(Node onode, Node hnode) {
        hnode.appendChild(this.converter.createTextNode("(Page count)"));
    }

    private void handleSequence(Node onode, Node hnode) {
        String sName = Misc.getAttribute(onode, "text:ref-name");
        if (sName != null && !this.bInToc && this.ofr.hasSequenceRefTo(sName)) {
            Element anchor = this.converter.createTarget("seq" + sName);
            hnode.appendChild(anchor);
            this.traversePCDATA(onode, anchor);
        } else {
            this.traversePCDATA(onode, hnode);
        }
    }

    private void createReference(Node onode, Node hnode, String sPrefix) {
        String sFormat = Misc.getAttribute(onode, "text:reference-format");
        String sName = Misc.getAttribute(onode, "text:ref-name");
        Element anchor = this.converter.createLink(sPrefix + sName);
        hnode.appendChild(anchor);
        if ("page".equals(sFormat)) {
            anchor.appendChild(this.converter.createTextNode("1"));
        } else {
            this.traversePCDATA(onode, anchor);
        }
    }

    private void handleSequenceRef(Node onode, Node hnode) {
        this.createReference(onode, hnode, "seq");
    }

    private void handleNoteRef(Node onode, Node hnode) {
        this.createReference(onode, hnode, "");
    }

    private void handleReferenceMark(Node onode, Node hnode) {
        String sName = Misc.getAttribute(onode, "text:name");
        if (sName != null && !this.bInToc && this.ofr.hasReferenceRefTo(sName)) {
            hnode.appendChild(this.converter.createTarget("ref" + sName));
        }
    }

    private void handleReferenceRef(Node onode, Node hnode) {
        this.createReference(onode, hnode, "ref");
    }

    private void handleBookmark(Node onode, Node hnode) {
        String sName = Misc.getAttribute(onode, "text:name");
        if (sName != null && !this.bInToc) {
            hnode.appendChild(this.converter.createTarget(sName));
            if (this.ofr.hasBookmarkRefTo(sName)) {
                hnode.appendChild(this.converter.createTarget("bkm" + sName));
            }
        }
    }

    private void handleBookmarkRef(Node onode, Node hnode) {
        this.createReference(onode, hnode, "bkm");
    }

    private void handleBibliographyMark(Node onode, Node hnode) {
        if (this.bInToc) {
            this.traversePCDATA(onode, hnode);
        } else {
            this.bibCv.handleBibliographyMark(onode, hnode);
        }
    }

    private void addBeforeAfter(Element elm, StyleWithProperties style, XhtmlStyleMap styleMap) {
        if (style != null && styleMap.contains(style.getDisplayName())) {
            XhtmlStyleMapItem mapItem = styleMap.get(style.getDisplayName());
            if (mapItem.sBefore != null && mapItem.sBefore.length() > 0) {
                Node child = elm.getFirstChild();
                if (child != null) {
                    elm.insertBefore(this.converter.createTextNode(mapItem.sBefore), child);
                } else {
                    elm.appendChild(this.converter.createTextNode(mapItem.sBefore));
                }
            }
            if (mapItem.sAfter != null && mapItem.sAfter.length() > 0) {
                elm.appendChild(this.converter.createTextNode(mapItem.sAfter));
            }
        }
    }

    private boolean isBold(StyleWithProperties style) {
        String s = style.getProperty("fo:font-weight", false);
        return s != null && "bold".equals(s);
    }

    private boolean isItalics(StyleWithProperties style) {
        String s = style.getProperty("fo:font-style", false);
        return s != null && !"normal".equals(s);
    }

    private boolean isFixed(StyleWithProperties style) {
        String s = style.getProperty("style:font-name", false);
        String s2 = null;
        String s3 = null;
        if (s != null) {
            FontDeclaration fd = (FontDeclaration)this.ofr.getFontDeclarations().getStyle(s);
            if (fd != null) {
                s2 = fd.getFontFamilyGeneric();
                s3 = fd.getFontPitch();
            }
        } else {
            s = style.getProperty("fo:font-family", false);
            s2 = style.getProperty("style:font-family-generic", false);
            s3 = style.getProperty("style:font-pitch", false);
        }
        if ("fixed".equals(s3)) {
            return true;
        }
        return "modern".equals(s2);
    }

    private boolean isSuperscript(StyleWithProperties style) {
        String sPos = style.getProperty("style:text-position", false);
        if (sPos == null) {
            return false;
        }
        if (sPos.startsWith("sub")) {
            return false;
        }
        if (sPos.startsWith("-")) {
            return false;
        }
        return !sPos.startsWith("0%");
    }

    private boolean isSubscript(StyleWithProperties style) {
        String sPos = style.getProperty("style:text-position", false);
        if (sPos == null) {
            return false;
        }
        if (sPos.startsWith("sub")) {
            return true;
        }
        return sPos.startsWith("-");
    }

    private boolean isUnderline(StyleWithProperties style) {
        String s = this.ofr.isOpenDocument() ? style.getProperty("style:text-underline-style", false) : style.getProperty("style:text-underline", false);
        return s != null && !"none".equals(s);
    }

    private boolean isOverstrike(StyleWithProperties style) {
        String s = this.ofr.isOpenDocument() ? style.getProperty("style:text-line-through-style", false) : style.getProperty("style:text-crossing-out", false);
        return s != null && !"none".equals(s);
    }

    private Element applyAttributes(Element node, StyleWithProperties style) {
        if (this.config.xhtmlFormatting() == 3 || this.config.xhtmlFormatting() == 1) {
            return node;
        }
        if (style == null) {
            return node;
        }
        if (!style.isAutomatic()) {
            return node;
        }
        node = this.applyAttribute(node, "bold", this.isBold(style));
        node = this.applyAttribute(node, "italics", this.isItalics(style));
        node = this.applyAttribute(node, "fixed", this.isFixed(style));
        node = this.applyAttribute(node, "superscript", this.isSuperscript(style));
        node = this.applyAttribute(node, "subscript", this.isSubscript(style));
        node = this.applyAttribute(node, "underline", this.isUnderline(style));
        node = this.applyAttribute(node, "overstrike", this.isOverstrike(style));
        return node;
    }

    private Element applyAttribute(Element node, String sAttr, boolean bApply) {
        XhtmlStyleMap xattr;
        if (bApply && (xattr = this.config.getXAttrStyleMap()).contains(sAttr) && xattr.get((String)sAttr).sElement.length() > 0) {
            XhtmlStyleMapItem map = xattr.get(sAttr);
            Element attr = this.converter.createElement(map.sElement);
            if (!"(none)".equals(map.sCss)) {
                attr.setAttribute("class", map.sCss);
            }
            node.appendChild(attr);
            return attr;
        }
        return node;
    }

    protected Element createParagraph(Element node, String sStyleName) {
        StyleInfo info = new StyleInfo();
        this.getParSc().applyStyle(sStyleName, info);
        Element par = this.converter.createElement(info.sTagName);
        node.appendChild(par);
        this.applyStyle(info, par);
        StyleWithProperties style = this.ofr.getParStyle(sStyleName);
        if (style != null && style.isAutomatic()) {
            return this.applyAttributes(par, style);
        }
        return par;
    }

    private Element createTextBackground(Element node, String sStyleName) {
        if (this.config.xhtmlFormatting() == 0 || this.config.xhtmlFormatting() == 2) {
            return node;
        }
        String sBack = this.getParSc().getTextBackground(sStyleName);
        if (sBack.length() > 0) {
            Element span = this.converter.createElement("span");
            span.setAttribute("style", sBack);
            node.appendChild(span);
            return span;
        }
        return node;
    }

    protected Element createInline(Element node, String sStyleName) {
        StyleInfo info = new StyleInfo();
        this.getTextSc().applyStyle(sStyleName, info);
        Element newNode = node;
        if (info.hasAttributes() || !"span".equals(info.sTagName)) {
            newNode = this.converter.createElement(info.sTagName);
            this.applyStyle(info, newNode);
            Node prev = node.getLastChild();
            if (prev != null && Misc.isElement(prev, info.sTagName)) {
                Element prevNode = (Element)prev;
                if (newNode.getAttribute("class").equals(prevNode.getAttribute("class")) && newNode.getAttribute("style").equals(prevNode.getAttribute("style")) && newNode.getAttribute("xml:lang").equals(prevNode.getAttribute("xml:lang")) && newNode.getAttribute("dir").equals(prevNode.getAttribute("dir"))) {
                    return this.applyAttributes(prevNode, this.ofr.getTextStyle(sStyleName));
                }
            }
            node.appendChild(newNode);
        }
        return this.applyAttributes(newNode, this.ofr.getTextStyle(sStyleName));
    }

    protected int getOutlineLevel(Element node) {
        return this.ofr.isOpenDocument() ? Misc.getPosInteger(node.getAttribute("text:outline-level"), 1) : Misc.getPosInteger(node.getAttribute("text:level"), 1);
    }
}

