# -*- coding: utf-8 -*-
# Auto-generated by Stone, do not modify.
# @generated
# flake8: noqa
# pylint: skip-file
"""
This namespace contains endpoints and data types for basic file operations.
"""

try:
    from . import stone_validators as bv
    from . import stone_base as bb
except (ImportError, SystemError, ValueError):
    # Catch errors raised when importing a relative module when not in a package.
    # This makes testing this file directly (outside of a package) easier.
    import stone_validators as bv
    import stone_base as bb

try:
    from . import (
        async_,
        common,
        file_properties,
        users_common,
    )
except (ImportError, SystemError, ValueError):
    import async_
    import common
    import file_properties
    import users_common

class GetMetadataArg(object):
    """
    :ivar path: The path of a file or folder on Dropbox.
    :ivar include_media_info: If true, ``FileMetadata.media_info`` is set for
        photo and video.
    :ivar include_deleted: If true, :class:`DeletedMetadata` will be returned
        for deleted file or folder, otherwise ``LookupError.not_found`` will be
        returned.
    :ivar include_has_explicit_shared_members: If true, the results will include
        a flag for each file indicating whether or not  that file has any
        explicit members.
    :ivar include_property_groups: If set to a valid list of template IDs,
        ``FileMetadata.property_groups`` is set if there exists property data
        associated with the file and each of the listed templates.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_include_media_info_value',
        '_include_media_info_present',
        '_include_deleted_value',
        '_include_deleted_present',
        '_include_has_explicit_shared_members_value',
        '_include_has_explicit_shared_members_present',
        '_include_property_groups_value',
        '_include_property_groups_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 include_media_info=None,
                 include_deleted=None,
                 include_has_explicit_shared_members=None,
                 include_property_groups=None):
        self._path_value = None
        self._path_present = False
        self._include_media_info_value = None
        self._include_media_info_present = False
        self._include_deleted_value = None
        self._include_deleted_present = False
        self._include_has_explicit_shared_members_value = None
        self._include_has_explicit_shared_members_present = False
        self._include_property_groups_value = None
        self._include_property_groups_present = False
        if path is not None:
            self.path = path
        if include_media_info is not None:
            self.include_media_info = include_media_info
        if include_deleted is not None:
            self.include_deleted = include_deleted
        if include_has_explicit_shared_members is not None:
            self.include_has_explicit_shared_members = include_has_explicit_shared_members
        if include_property_groups is not None:
            self.include_property_groups = include_property_groups

    @property
    def path(self):
        """
        The path of a file or folder on Dropbox.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def include_media_info(self):
        """
        If true, ``FileMetadata.media_info`` is set for photo and video.

        :rtype: bool
        """
        if self._include_media_info_present:
            return self._include_media_info_value
        else:
            return False

    @include_media_info.setter
    def include_media_info(self, val):
        val = self._include_media_info_validator.validate(val)
        self._include_media_info_value = val
        self._include_media_info_present = True

    @include_media_info.deleter
    def include_media_info(self):
        self._include_media_info_value = None
        self._include_media_info_present = False

    @property
    def include_deleted(self):
        """
        If true, :class:`DeletedMetadata` will be returned for deleted file or
        folder, otherwise ``LookupError.not_found`` will be returned.

        :rtype: bool
        """
        if self._include_deleted_present:
            return self._include_deleted_value
        else:
            return False

    @include_deleted.setter
    def include_deleted(self, val):
        val = self._include_deleted_validator.validate(val)
        self._include_deleted_value = val
        self._include_deleted_present = True

    @include_deleted.deleter
    def include_deleted(self):
        self._include_deleted_value = None
        self._include_deleted_present = False

    @property
    def include_has_explicit_shared_members(self):
        """
        If true, the results will include a flag for each file indicating
        whether or not  that file has any explicit members.

        :rtype: bool
        """
        if self._include_has_explicit_shared_members_present:
            return self._include_has_explicit_shared_members_value
        else:
            return False

    @include_has_explicit_shared_members.setter
    def include_has_explicit_shared_members(self, val):
        val = self._include_has_explicit_shared_members_validator.validate(val)
        self._include_has_explicit_shared_members_value = val
        self._include_has_explicit_shared_members_present = True

    @include_has_explicit_shared_members.deleter
    def include_has_explicit_shared_members(self):
        self._include_has_explicit_shared_members_value = None
        self._include_has_explicit_shared_members_present = False

    @property
    def include_property_groups(self):
        """
        If set to a valid list of template IDs, ``FileMetadata.property_groups``
        is set if there exists property data associated with the file and each
        of the listed templates.

        :rtype: file_properties.TemplateFilterBase_validator
        """
        if self._include_property_groups_present:
            return self._include_property_groups_value
        else:
            return None

    @include_property_groups.setter
    def include_property_groups(self, val):
        if val is None:
            del self.include_property_groups
            return
        self._include_property_groups_validator.validate_type_only(val)
        self._include_property_groups_value = val
        self._include_property_groups_present = True

    @include_property_groups.deleter
    def include_property_groups(self):
        self._include_property_groups_value = None
        self._include_property_groups_present = False

    def __repr__(self):
        return 'GetMetadataArg(path={!r}, include_media_info={!r}, include_deleted={!r}, include_has_explicit_shared_members={!r}, include_property_groups={!r})'.format(
            self._path_value,
            self._include_media_info_value,
            self._include_deleted_value,
            self._include_has_explicit_shared_members_value,
            self._include_property_groups_value,
        )

GetMetadataArg_validator = bv.Struct(GetMetadataArg)

class AlphaGetMetadataArg(GetMetadataArg):
    """
    :ivar include_property_templates: If set to a valid list of template IDs,
        ``FileMetadata.property_groups`` is set for files with custom
        properties.
    """

    __slots__ = [
        '_include_property_templates_value',
        '_include_property_templates_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 include_media_info=None,
                 include_deleted=None,
                 include_has_explicit_shared_members=None,
                 include_property_groups=None,
                 include_property_templates=None):
        super(AlphaGetMetadataArg, self).__init__(path,
                                                  include_media_info,
                                                  include_deleted,
                                                  include_has_explicit_shared_members,
                                                  include_property_groups)
        self._include_property_templates_value = None
        self._include_property_templates_present = False
        if include_property_templates is not None:
            self.include_property_templates = include_property_templates

    @property
    def include_property_templates(self):
        """
        If set to a valid list of template IDs, ``FileMetadata.property_groups``
        is set for files with custom properties.

        :rtype: list of [str]
        """
        if self._include_property_templates_present:
            return self._include_property_templates_value
        else:
            return None

    @include_property_templates.setter
    def include_property_templates(self, val):
        if val is None:
            del self.include_property_templates
            return
        val = self._include_property_templates_validator.validate(val)
        self._include_property_templates_value = val
        self._include_property_templates_present = True

    @include_property_templates.deleter
    def include_property_templates(self):
        self._include_property_templates_value = None
        self._include_property_templates_present = False

    def __repr__(self):
        return 'AlphaGetMetadataArg(path={!r}, include_media_info={!r}, include_deleted={!r}, include_has_explicit_shared_members={!r}, include_property_groups={!r}, include_property_templates={!r})'.format(
            self._path_value,
            self._include_media_info_value,
            self._include_deleted_value,
            self._include_has_explicit_shared_members_value,
            self._include_property_groups_value,
            self._include_property_templates_value,
        )

AlphaGetMetadataArg_validator = bv.Struct(AlphaGetMetadataArg)

class GetMetadataError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: GetMetadataError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'GetMetadataError(%r, %r)' % (self._tag, self._value)

GetMetadataError_validator = bv.Union(GetMetadataError)

class AlphaGetMetadataError(GetMetadataError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    @classmethod
    def properties_error(cls, val):
        """
        Create an instance of this class set to the ``properties_error`` tag
        with value ``val``.

        :param file_properties.LookUpPropertiesError_validator val:
        :rtype: AlphaGetMetadataError
        """
        return cls('properties_error', val)

    def is_properties_error(self):
        """
        Check if the union tag is ``properties_error``.

        :rtype: bool
        """
        return self._tag == 'properties_error'

    def get_properties_error(self):
        """
        Only call this if :meth:`is_properties_error` is true.

        :rtype: file_properties.LookUpPropertiesError_validator
        """
        if not self.is_properties_error():
            raise AttributeError("tag 'properties_error' not set")
        return self._value

    def __repr__(self):
        return 'AlphaGetMetadataError(%r, %r)' % (self._tag, self._value)

AlphaGetMetadataError_validator = bv.Union(AlphaGetMetadataError)

class CommitInfo(object):
    """
    :ivar path: Path in the user's Dropbox to save the file.
    :ivar mode: Selects what to do if the file already exists.
    :ivar autorename: If there's a conflict, as determined by ``mode``, have the
        Dropbox server try to autorename the file to avoid conflict.
    :ivar client_modified: The value to store as the ``client_modified``
        timestamp. Dropbox automatically records the time at which the file was
        written to the Dropbox servers. It can also record an additional
        timestamp, provided by Dropbox desktop clients, mobile clients, and API
        apps of when the file was actually created or modified.
    :ivar mute: Normally, users are made aware of any file modifications in
        their Dropbox account via notifications in the client software. If
        ``True``, this tells the clients that this modification shouldn't result
        in a user notification.
    :ivar property_groups: List of custom properties to add to file.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_mode_value',
        '_mode_present',
        '_autorename_value',
        '_autorename_present',
        '_client_modified_value',
        '_client_modified_present',
        '_mute_value',
        '_mute_present',
        '_property_groups_value',
        '_property_groups_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 mode=None,
                 autorename=None,
                 client_modified=None,
                 mute=None,
                 property_groups=None):
        self._path_value = None
        self._path_present = False
        self._mode_value = None
        self._mode_present = False
        self._autorename_value = None
        self._autorename_present = False
        self._client_modified_value = None
        self._client_modified_present = False
        self._mute_value = None
        self._mute_present = False
        self._property_groups_value = None
        self._property_groups_present = False
        if path is not None:
            self.path = path
        if mode is not None:
            self.mode = mode
        if autorename is not None:
            self.autorename = autorename
        if client_modified is not None:
            self.client_modified = client_modified
        if mute is not None:
            self.mute = mute
        if property_groups is not None:
            self.property_groups = property_groups

    @property
    def path(self):
        """
        Path in the user's Dropbox to save the file.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def mode(self):
        """
        Selects what to do if the file already exists.

        :rtype: WriteMode
        """
        if self._mode_present:
            return self._mode_value
        else:
            return WriteMode.add

    @mode.setter
    def mode(self, val):
        self._mode_validator.validate_type_only(val)
        self._mode_value = val
        self._mode_present = True

    @mode.deleter
    def mode(self):
        self._mode_value = None
        self._mode_present = False

    @property
    def autorename(self):
        """
        If there's a conflict, as determined by ``mode``, have the Dropbox
        server try to autorename the file to avoid conflict.

        :rtype: bool
        """
        if self._autorename_present:
            return self._autorename_value
        else:
            return False

    @autorename.setter
    def autorename(self, val):
        val = self._autorename_validator.validate(val)
        self._autorename_value = val
        self._autorename_present = True

    @autorename.deleter
    def autorename(self):
        self._autorename_value = None
        self._autorename_present = False

    @property
    def client_modified(self):
        """
        The value to store as the ``client_modified`` timestamp. Dropbox
        automatically records the time at which the file was written to the
        Dropbox servers. It can also record an additional timestamp, provided by
        Dropbox desktop clients, mobile clients, and API apps of when the file
        was actually created or modified.

        :rtype: datetime.datetime
        """
        if self._client_modified_present:
            return self._client_modified_value
        else:
            return None

    @client_modified.setter
    def client_modified(self, val):
        if val is None:
            del self.client_modified
            return
        val = self._client_modified_validator.validate(val)
        self._client_modified_value = val
        self._client_modified_present = True

    @client_modified.deleter
    def client_modified(self):
        self._client_modified_value = None
        self._client_modified_present = False

    @property
    def mute(self):
        """
        Normally, users are made aware of any file modifications in their
        Dropbox account via notifications in the client software. If ``True``,
        this tells the clients that this modification shouldn't result in a user
        notification.

        :rtype: bool
        """
        if self._mute_present:
            return self._mute_value
        else:
            return False

    @mute.setter
    def mute(self, val):
        val = self._mute_validator.validate(val)
        self._mute_value = val
        self._mute_present = True

    @mute.deleter
    def mute(self):
        self._mute_value = None
        self._mute_present = False

    @property
    def property_groups(self):
        """
        List of custom properties to add to file.

        :rtype: list of [file_properties.PropertyGroup_validator]
        """
        if self._property_groups_present:
            return self._property_groups_value
        else:
            return None

    @property_groups.setter
    def property_groups(self, val):
        if val is None:
            del self.property_groups
            return
        val = self._property_groups_validator.validate(val)
        self._property_groups_value = val
        self._property_groups_present = True

    @property_groups.deleter
    def property_groups(self):
        self._property_groups_value = None
        self._property_groups_present = False

    def __repr__(self):
        return 'CommitInfo(path={!r}, mode={!r}, autorename={!r}, client_modified={!r}, mute={!r}, property_groups={!r})'.format(
            self._path_value,
            self._mode_value,
            self._autorename_value,
            self._client_modified_value,
            self._mute_value,
            self._property_groups_value,
        )

CommitInfo_validator = bv.Struct(CommitInfo)

class CommitInfoWithProperties(CommitInfo):

    __slots__ = [
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 mode=None,
                 autorename=None,
                 client_modified=None,
                 mute=None,
                 property_groups=None):
        super(CommitInfoWithProperties, self).__init__(path,
                                                       mode,
                                                       autorename,
                                                       client_modified,
                                                       mute,
                                                       property_groups)

    def __repr__(self):
        return 'CommitInfoWithProperties(path={!r}, mode={!r}, autorename={!r}, client_modified={!r}, mute={!r}, property_groups={!r})'.format(
            self._path_value,
            self._mode_value,
            self._autorename_value,
            self._client_modified_value,
            self._mute_value,
            self._property_groups_value,
        )

CommitInfoWithProperties_validator = bv.Struct(CommitInfoWithProperties)

class ContentSyncSetting(object):
    """
    :ivar id: Id of the item this setting is applied to.
    :ivar sync_setting: Setting for this item.
    """

    __slots__ = [
        '_id_value',
        '_id_present',
        '_sync_setting_value',
        '_sync_setting_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 id=None,
                 sync_setting=None):
        self._id_value = None
        self._id_present = False
        self._sync_setting_value = None
        self._sync_setting_present = False
        if id is not None:
            self.id = id
        if sync_setting is not None:
            self.sync_setting = sync_setting

    @property
    def id(self):
        """
        Id of the item this setting is applied to.

        :rtype: str
        """
        if self._id_present:
            return self._id_value
        else:
            raise AttributeError("missing required field 'id'")

    @id.setter
    def id(self, val):
        val = self._id_validator.validate(val)
        self._id_value = val
        self._id_present = True

    @id.deleter
    def id(self):
        self._id_value = None
        self._id_present = False

    @property
    def sync_setting(self):
        """
        Setting for this item.

        :rtype: SyncSetting
        """
        if self._sync_setting_present:
            return self._sync_setting_value
        else:
            raise AttributeError("missing required field 'sync_setting'")

    @sync_setting.setter
    def sync_setting(self, val):
        self._sync_setting_validator.validate_type_only(val)
        self._sync_setting_value = val
        self._sync_setting_present = True

    @sync_setting.deleter
    def sync_setting(self):
        self._sync_setting_value = None
        self._sync_setting_present = False

    def __repr__(self):
        return 'ContentSyncSetting(id={!r}, sync_setting={!r})'.format(
            self._id_value,
            self._sync_setting_value,
        )

ContentSyncSetting_validator = bv.Struct(ContentSyncSetting)

class ContentSyncSettingArg(object):
    """
    :ivar id: Id of the item this setting is applied to.
    :ivar sync_setting: Setting for this item.
    """

    __slots__ = [
        '_id_value',
        '_id_present',
        '_sync_setting_value',
        '_sync_setting_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 id=None,
                 sync_setting=None):
        self._id_value = None
        self._id_present = False
        self._sync_setting_value = None
        self._sync_setting_present = False
        if id is not None:
            self.id = id
        if sync_setting is not None:
            self.sync_setting = sync_setting

    @property
    def id(self):
        """
        Id of the item this setting is applied to.

        :rtype: str
        """
        if self._id_present:
            return self._id_value
        else:
            raise AttributeError("missing required field 'id'")

    @id.setter
    def id(self, val):
        val = self._id_validator.validate(val)
        self._id_value = val
        self._id_present = True

    @id.deleter
    def id(self):
        self._id_value = None
        self._id_present = False

    @property
    def sync_setting(self):
        """
        Setting for this item.

        :rtype: SyncSettingArg
        """
        if self._sync_setting_present:
            return self._sync_setting_value
        else:
            raise AttributeError("missing required field 'sync_setting'")

    @sync_setting.setter
    def sync_setting(self, val):
        self._sync_setting_validator.validate_type_only(val)
        self._sync_setting_value = val
        self._sync_setting_present = True

    @sync_setting.deleter
    def sync_setting(self):
        self._sync_setting_value = None
        self._sync_setting_present = False

    def __repr__(self):
        return 'ContentSyncSettingArg(id={!r}, sync_setting={!r})'.format(
            self._id_value,
            self._sync_setting_value,
        )

ContentSyncSettingArg_validator = bv.Struct(ContentSyncSettingArg)

class CreateFolderArg(object):
    """
    :ivar path: Path in the user's Dropbox to create.
    :ivar autorename: If there's a conflict, have the Dropbox server try to
        autorename the folder to avoid the conflict.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_autorename_value',
        '_autorename_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 autorename=None):
        self._path_value = None
        self._path_present = False
        self._autorename_value = None
        self._autorename_present = False
        if path is not None:
            self.path = path
        if autorename is not None:
            self.autorename = autorename

    @property
    def path(self):
        """
        Path in the user's Dropbox to create.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def autorename(self):
        """
        If there's a conflict, have the Dropbox server try to autorename the
        folder to avoid the conflict.

        :rtype: bool
        """
        if self._autorename_present:
            return self._autorename_value
        else:
            return False

    @autorename.setter
    def autorename(self, val):
        val = self._autorename_validator.validate(val)
        self._autorename_value = val
        self._autorename_present = True

    @autorename.deleter
    def autorename(self):
        self._autorename_value = None
        self._autorename_present = False

    def __repr__(self):
        return 'CreateFolderArg(path={!r}, autorename={!r})'.format(
            self._path_value,
            self._autorename_value,
        )

CreateFolderArg_validator = bv.Struct(CreateFolderArg)

class CreateFolderBatchArg(object):
    """
    :ivar paths: List of paths to be created in the user's Dropbox. Duplicate
        path arguments in the batch are considered only once.
    :ivar autorename: If there's a conflict, have the Dropbox server try to
        autorename the folder to avoid the conflict.
    :ivar force_async: Whether to force the create to happen asynchronously.
    """

    __slots__ = [
        '_paths_value',
        '_paths_present',
        '_autorename_value',
        '_autorename_present',
        '_force_async_value',
        '_force_async_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 paths=None,
                 autorename=None,
                 force_async=None):
        self._paths_value = None
        self._paths_present = False
        self._autorename_value = None
        self._autorename_present = False
        self._force_async_value = None
        self._force_async_present = False
        if paths is not None:
            self.paths = paths
        if autorename is not None:
            self.autorename = autorename
        if force_async is not None:
            self.force_async = force_async

    @property
    def paths(self):
        """
        List of paths to be created in the user's Dropbox. Duplicate path
        arguments in the batch are considered only once.

        :rtype: list of [str]
        """
        if self._paths_present:
            return self._paths_value
        else:
            raise AttributeError("missing required field 'paths'")

    @paths.setter
    def paths(self, val):
        val = self._paths_validator.validate(val)
        self._paths_value = val
        self._paths_present = True

    @paths.deleter
    def paths(self):
        self._paths_value = None
        self._paths_present = False

    @property
    def autorename(self):
        """
        If there's a conflict, have the Dropbox server try to autorename the
        folder to avoid the conflict.

        :rtype: bool
        """
        if self._autorename_present:
            return self._autorename_value
        else:
            return False

    @autorename.setter
    def autorename(self, val):
        val = self._autorename_validator.validate(val)
        self._autorename_value = val
        self._autorename_present = True

    @autorename.deleter
    def autorename(self):
        self._autorename_value = None
        self._autorename_present = False

    @property
    def force_async(self):
        """
        Whether to force the create to happen asynchronously.

        :rtype: bool
        """
        if self._force_async_present:
            return self._force_async_value
        else:
            return False

    @force_async.setter
    def force_async(self, val):
        val = self._force_async_validator.validate(val)
        self._force_async_value = val
        self._force_async_present = True

    @force_async.deleter
    def force_async(self):
        self._force_async_value = None
        self._force_async_present = False

    def __repr__(self):
        return 'CreateFolderBatchArg(paths={!r}, autorename={!r}, force_async={!r})'.format(
            self._paths_value,
            self._autorename_value,
            self._force_async_value,
        )

CreateFolderBatchArg_validator = bv.Struct(CreateFolderBatchArg)

class CreateFolderBatchError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar too_many_files: The operation would involve too many files or folders.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    too_many_files = None
    # Attribute is overwritten below the class definition
    other = None

    def is_too_many_files(self):
        """
        Check if the union tag is ``too_many_files``.

        :rtype: bool
        """
        return self._tag == 'too_many_files'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'CreateFolderBatchError(%r, %r)' % (self._tag, self._value)

CreateFolderBatchError_validator = bv.Union(CreateFolderBatchError)

class CreateFolderBatchJobStatus(async_.PollResultBase):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar CreateFolderBatchResult complete: The batch create folder has
        finished.
    :ivar CreateFolderBatchError failed: The batch create folder has failed.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def complete(cls, val):
        """
        Create an instance of this class set to the ``complete`` tag with value
        ``val``.

        :param CreateFolderBatchResult val:
        :rtype: CreateFolderBatchJobStatus
        """
        return cls('complete', val)

    @classmethod
    def failed(cls, val):
        """
        Create an instance of this class set to the ``failed`` tag with value
        ``val``.

        :param CreateFolderBatchError val:
        :rtype: CreateFolderBatchJobStatus
        """
        return cls('failed', val)

    def is_complete(self):
        """
        Check if the union tag is ``complete``.

        :rtype: bool
        """
        return self._tag == 'complete'

    def is_failed(self):
        """
        Check if the union tag is ``failed``.

        :rtype: bool
        """
        return self._tag == 'failed'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_complete(self):
        """
        The batch create folder has finished.

        Only call this if :meth:`is_complete` is true.

        :rtype: CreateFolderBatchResult
        """
        if not self.is_complete():
            raise AttributeError("tag 'complete' not set")
        return self._value

    def get_failed(self):
        """
        The batch create folder has failed.

        Only call this if :meth:`is_failed` is true.

        :rtype: CreateFolderBatchError
        """
        if not self.is_failed():
            raise AttributeError("tag 'failed' not set")
        return self._value

    def __repr__(self):
        return 'CreateFolderBatchJobStatus(%r, %r)' % (self._tag, self._value)

CreateFolderBatchJobStatus_validator = bv.Union(CreateFolderBatchJobStatus)

class CreateFolderBatchLaunch(async_.LaunchResultBase):
    """
    Result returned by :meth:`dropbox.dropbox.Dropbox.files_create_folder_batch`
    that may either launch an asynchronous job or complete synchronously.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def complete(cls, val):
        """
        Create an instance of this class set to the ``complete`` tag with value
        ``val``.

        :param CreateFolderBatchResult val:
        :rtype: CreateFolderBatchLaunch
        """
        return cls('complete', val)

    def is_complete(self):
        """
        Check if the union tag is ``complete``.

        :rtype: bool
        """
        return self._tag == 'complete'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_complete(self):
        """
        Only call this if :meth:`is_complete` is true.

        :rtype: CreateFolderBatchResult
        """
        if not self.is_complete():
            raise AttributeError("tag 'complete' not set")
        return self._value

    def __repr__(self):
        return 'CreateFolderBatchLaunch(%r, %r)' % (self._tag, self._value)

CreateFolderBatchLaunch_validator = bv.Union(CreateFolderBatchLaunch)

class FileOpsResult(object):

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'FileOpsResult()'

FileOpsResult_validator = bv.Struct(FileOpsResult)

class CreateFolderBatchResult(FileOpsResult):

    __slots__ = [
        '_entries_value',
        '_entries_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 entries=None):
        super(CreateFolderBatchResult, self).__init__()
        self._entries_value = None
        self._entries_present = False
        if entries is not None:
            self.entries = entries

    @property
    def entries(self):
        """
        :rtype: list of [CreateFolderBatchResultEntry]
        """
        if self._entries_present:
            return self._entries_value
        else:
            raise AttributeError("missing required field 'entries'")

    @entries.setter
    def entries(self, val):
        val = self._entries_validator.validate(val)
        self._entries_value = val
        self._entries_present = True

    @entries.deleter
    def entries(self):
        self._entries_value = None
        self._entries_present = False

    def __repr__(self):
        return 'CreateFolderBatchResult(entries={!r})'.format(
            self._entries_value,
        )

CreateFolderBatchResult_validator = bv.Struct(CreateFolderBatchResult)

class CreateFolderBatchResultEntry(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = None

    @classmethod
    def success(cls, val):
        """
        Create an instance of this class set to the ``success`` tag with value
        ``val``.

        :param CreateFolderEntryResult val:
        :rtype: CreateFolderBatchResultEntry
        """
        return cls('success', val)

    @classmethod
    def failure(cls, val):
        """
        Create an instance of this class set to the ``failure`` tag with value
        ``val``.

        :param CreateFolderEntryError val:
        :rtype: CreateFolderBatchResultEntry
        """
        return cls('failure', val)

    def is_success(self):
        """
        Check if the union tag is ``success``.

        :rtype: bool
        """
        return self._tag == 'success'

    def is_failure(self):
        """
        Check if the union tag is ``failure``.

        :rtype: bool
        """
        return self._tag == 'failure'

    def get_success(self):
        """
        Only call this if :meth:`is_success` is true.

        :rtype: CreateFolderEntryResult
        """
        if not self.is_success():
            raise AttributeError("tag 'success' not set")
        return self._value

    def get_failure(self):
        """
        Only call this if :meth:`is_failure` is true.

        :rtype: CreateFolderEntryError
        """
        if not self.is_failure():
            raise AttributeError("tag 'failure' not set")
        return self._value

    def __repr__(self):
        return 'CreateFolderBatchResultEntry(%r, %r)' % (self._tag, self._value)

CreateFolderBatchResultEntry_validator = bv.Union(CreateFolderBatchResultEntry)

class CreateFolderEntryError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param WriteError val:
        :rtype: CreateFolderEntryError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: WriteError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'CreateFolderEntryError(%r, %r)' % (self._tag, self._value)

CreateFolderEntryError_validator = bv.Union(CreateFolderEntryError)

class CreateFolderEntryResult(object):
    """
    :ivar metadata: Metadata of the created folder.
    """

    __slots__ = [
        '_metadata_value',
        '_metadata_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 metadata=None):
        self._metadata_value = None
        self._metadata_present = False
        if metadata is not None:
            self.metadata = metadata

    @property
    def metadata(self):
        """
        Metadata of the created folder.

        :rtype: FolderMetadata
        """
        if self._metadata_present:
            return self._metadata_value
        else:
            raise AttributeError("missing required field 'metadata'")

    @metadata.setter
    def metadata(self, val):
        self._metadata_validator.validate_type_only(val)
        self._metadata_value = val
        self._metadata_present = True

    @metadata.deleter
    def metadata(self):
        self._metadata_value = None
        self._metadata_present = False

    def __repr__(self):
        return 'CreateFolderEntryResult(metadata={!r})'.format(
            self._metadata_value,
        )

CreateFolderEntryResult_validator = bv.Struct(CreateFolderEntryResult)

class CreateFolderError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param WriteError val:
        :rtype: CreateFolderError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: WriteError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'CreateFolderError(%r, %r)' % (self._tag, self._value)

CreateFolderError_validator = bv.Union(CreateFolderError)

class CreateFolderResult(FileOpsResult):
    """
    :ivar metadata: Metadata of the created folder.
    """

    __slots__ = [
        '_metadata_value',
        '_metadata_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 metadata=None):
        super(CreateFolderResult, self).__init__()
        self._metadata_value = None
        self._metadata_present = False
        if metadata is not None:
            self.metadata = metadata

    @property
    def metadata(self):
        """
        Metadata of the created folder.

        :rtype: FolderMetadata
        """
        if self._metadata_present:
            return self._metadata_value
        else:
            raise AttributeError("missing required field 'metadata'")

    @metadata.setter
    def metadata(self, val):
        self._metadata_validator.validate_type_only(val)
        self._metadata_value = val
        self._metadata_present = True

    @metadata.deleter
    def metadata(self):
        self._metadata_value = None
        self._metadata_present = False

    def __repr__(self):
        return 'CreateFolderResult(metadata={!r})'.format(
            self._metadata_value,
        )

CreateFolderResult_validator = bv.Struct(CreateFolderResult)

class DeleteArg(object):
    """
    :ivar path: Path in the user's Dropbox to delete.
    :ivar parent_rev: Perform delete if given "rev" matches the existing file's
        latest "rev". This field does not support deleting a folder.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_parent_rev_value',
        '_parent_rev_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 parent_rev=None):
        self._path_value = None
        self._path_present = False
        self._parent_rev_value = None
        self._parent_rev_present = False
        if path is not None:
            self.path = path
        if parent_rev is not None:
            self.parent_rev = parent_rev

    @property
    def path(self):
        """
        Path in the user's Dropbox to delete.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def parent_rev(self):
        """
        Perform delete if given "rev" matches the existing file's latest "rev".
        This field does not support deleting a folder.

        :rtype: str
        """
        if self._parent_rev_present:
            return self._parent_rev_value
        else:
            return None

    @parent_rev.setter
    def parent_rev(self, val):
        if val is None:
            del self.parent_rev
            return
        val = self._parent_rev_validator.validate(val)
        self._parent_rev_value = val
        self._parent_rev_present = True

    @parent_rev.deleter
    def parent_rev(self):
        self._parent_rev_value = None
        self._parent_rev_present = False

    def __repr__(self):
        return 'DeleteArg(path={!r}, parent_rev={!r})'.format(
            self._path_value,
            self._parent_rev_value,
        )

DeleteArg_validator = bv.Struct(DeleteArg)

class DeleteBatchArg(object):

    __slots__ = [
        '_entries_value',
        '_entries_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 entries=None):
        self._entries_value = None
        self._entries_present = False
        if entries is not None:
            self.entries = entries

    @property
    def entries(self):
        """
        :rtype: list of [DeleteArg]
        """
        if self._entries_present:
            return self._entries_value
        else:
            raise AttributeError("missing required field 'entries'")

    @entries.setter
    def entries(self, val):
        val = self._entries_validator.validate(val)
        self._entries_value = val
        self._entries_present = True

    @entries.deleter
    def entries(self):
        self._entries_value = None
        self._entries_present = False

    def __repr__(self):
        return 'DeleteBatchArg(entries={!r})'.format(
            self._entries_value,
        )

DeleteBatchArg_validator = bv.Struct(DeleteBatchArg)

class DeleteBatchError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar too_many_write_operations: Use
        ``DeleteError.too_many_write_operations``.
        :meth:`dropbox.dropbox.Dropbox.files_delete_batch` now provides smaller
        granularity about which entry has failed because of this.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    too_many_write_operations = None
    # Attribute is overwritten below the class definition
    other = None

    def is_too_many_write_operations(self):
        """
        Check if the union tag is ``too_many_write_operations``.

        :rtype: bool
        """
        return self._tag == 'too_many_write_operations'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'DeleteBatchError(%r, %r)' % (self._tag, self._value)

DeleteBatchError_validator = bv.Union(DeleteBatchError)

class DeleteBatchJobStatus(async_.PollResultBase):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar DeleteBatchResult complete: The batch delete has finished.
    :ivar DeleteBatchError failed: The batch delete has failed.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def complete(cls, val):
        """
        Create an instance of this class set to the ``complete`` tag with value
        ``val``.

        :param DeleteBatchResult val:
        :rtype: DeleteBatchJobStatus
        """
        return cls('complete', val)

    @classmethod
    def failed(cls, val):
        """
        Create an instance of this class set to the ``failed`` tag with value
        ``val``.

        :param DeleteBatchError val:
        :rtype: DeleteBatchJobStatus
        """
        return cls('failed', val)

    def is_complete(self):
        """
        Check if the union tag is ``complete``.

        :rtype: bool
        """
        return self._tag == 'complete'

    def is_failed(self):
        """
        Check if the union tag is ``failed``.

        :rtype: bool
        """
        return self._tag == 'failed'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_complete(self):
        """
        The batch delete has finished.

        Only call this if :meth:`is_complete` is true.

        :rtype: DeleteBatchResult
        """
        if not self.is_complete():
            raise AttributeError("tag 'complete' not set")
        return self._value

    def get_failed(self):
        """
        The batch delete has failed.

        Only call this if :meth:`is_failed` is true.

        :rtype: DeleteBatchError
        """
        if not self.is_failed():
            raise AttributeError("tag 'failed' not set")
        return self._value

    def __repr__(self):
        return 'DeleteBatchJobStatus(%r, %r)' % (self._tag, self._value)

DeleteBatchJobStatus_validator = bv.Union(DeleteBatchJobStatus)

class DeleteBatchLaunch(async_.LaunchResultBase):
    """
    Result returned by :meth:`dropbox.dropbox.Dropbox.files_delete_batch` that
    may either launch an asynchronous job or complete synchronously.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def complete(cls, val):
        """
        Create an instance of this class set to the ``complete`` tag with value
        ``val``.

        :param DeleteBatchResult val:
        :rtype: DeleteBatchLaunch
        """
        return cls('complete', val)

    def is_complete(self):
        """
        Check if the union tag is ``complete``.

        :rtype: bool
        """
        return self._tag == 'complete'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_complete(self):
        """
        Only call this if :meth:`is_complete` is true.

        :rtype: DeleteBatchResult
        """
        if not self.is_complete():
            raise AttributeError("tag 'complete' not set")
        return self._value

    def __repr__(self):
        return 'DeleteBatchLaunch(%r, %r)' % (self._tag, self._value)

DeleteBatchLaunch_validator = bv.Union(DeleteBatchLaunch)

class DeleteBatchResult(FileOpsResult):

    __slots__ = [
        '_entries_value',
        '_entries_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 entries=None):
        super(DeleteBatchResult, self).__init__()
        self._entries_value = None
        self._entries_present = False
        if entries is not None:
            self.entries = entries

    @property
    def entries(self):
        """
        :rtype: list of [DeleteBatchResultEntry]
        """
        if self._entries_present:
            return self._entries_value
        else:
            raise AttributeError("missing required field 'entries'")

    @entries.setter
    def entries(self, val):
        val = self._entries_validator.validate(val)
        self._entries_value = val
        self._entries_present = True

    @entries.deleter
    def entries(self):
        self._entries_value = None
        self._entries_present = False

    def __repr__(self):
        return 'DeleteBatchResult(entries={!r})'.format(
            self._entries_value,
        )

DeleteBatchResult_validator = bv.Struct(DeleteBatchResult)

class DeleteBatchResultData(object):
    """
    :ivar metadata: Metadata of the deleted object.
    """

    __slots__ = [
        '_metadata_value',
        '_metadata_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 metadata=None):
        self._metadata_value = None
        self._metadata_present = False
        if metadata is not None:
            self.metadata = metadata

    @property
    def metadata(self):
        """
        Metadata of the deleted object.

        :rtype: Metadata
        """
        if self._metadata_present:
            return self._metadata_value
        else:
            raise AttributeError("missing required field 'metadata'")

    @metadata.setter
    def metadata(self, val):
        self._metadata_validator.validate_type_only(val)
        self._metadata_value = val
        self._metadata_present = True

    @metadata.deleter
    def metadata(self):
        self._metadata_value = None
        self._metadata_present = False

    def __repr__(self):
        return 'DeleteBatchResultData(metadata={!r})'.format(
            self._metadata_value,
        )

DeleteBatchResultData_validator = bv.Struct(DeleteBatchResultData)

class DeleteBatchResultEntry(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = None

    @classmethod
    def success(cls, val):
        """
        Create an instance of this class set to the ``success`` tag with value
        ``val``.

        :param DeleteBatchResultData val:
        :rtype: DeleteBatchResultEntry
        """
        return cls('success', val)

    @classmethod
    def failure(cls, val):
        """
        Create an instance of this class set to the ``failure`` tag with value
        ``val``.

        :param DeleteError val:
        :rtype: DeleteBatchResultEntry
        """
        return cls('failure', val)

    def is_success(self):
        """
        Check if the union tag is ``success``.

        :rtype: bool
        """
        return self._tag == 'success'

    def is_failure(self):
        """
        Check if the union tag is ``failure``.

        :rtype: bool
        """
        return self._tag == 'failure'

    def get_success(self):
        """
        Only call this if :meth:`is_success` is true.

        :rtype: DeleteBatchResultData
        """
        if not self.is_success():
            raise AttributeError("tag 'success' not set")
        return self._value

    def get_failure(self):
        """
        Only call this if :meth:`is_failure` is true.

        :rtype: DeleteError
        """
        if not self.is_failure():
            raise AttributeError("tag 'failure' not set")
        return self._value

    def __repr__(self):
        return 'DeleteBatchResultEntry(%r, %r)' % (self._tag, self._value)

DeleteBatchResultEntry_validator = bv.Union(DeleteBatchResultEntry)

class DeleteError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar too_many_write_operations: There are too many write operations in
        user's Dropbox. Please retry this request.
    :ivar too_many_files: There are too many files in one request. Please retry
        with fewer files.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    too_many_write_operations = None
    # Attribute is overwritten below the class definition
    too_many_files = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path_lookup(cls, val):
        """
        Create an instance of this class set to the ``path_lookup`` tag with
        value ``val``.

        :param LookupError val:
        :rtype: DeleteError
        """
        return cls('path_lookup', val)

    @classmethod
    def path_write(cls, val):
        """
        Create an instance of this class set to the ``path_write`` tag with
        value ``val``.

        :param WriteError val:
        :rtype: DeleteError
        """
        return cls('path_write', val)

    def is_path_lookup(self):
        """
        Check if the union tag is ``path_lookup``.

        :rtype: bool
        """
        return self._tag == 'path_lookup'

    def is_path_write(self):
        """
        Check if the union tag is ``path_write``.

        :rtype: bool
        """
        return self._tag == 'path_write'

    def is_too_many_write_operations(self):
        """
        Check if the union tag is ``too_many_write_operations``.

        :rtype: bool
        """
        return self._tag == 'too_many_write_operations'

    def is_too_many_files(self):
        """
        Check if the union tag is ``too_many_files``.

        :rtype: bool
        """
        return self._tag == 'too_many_files'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path_lookup(self):
        """
        Only call this if :meth:`is_path_lookup` is true.

        :rtype: LookupError
        """
        if not self.is_path_lookup():
            raise AttributeError("tag 'path_lookup' not set")
        return self._value

    def get_path_write(self):
        """
        Only call this if :meth:`is_path_write` is true.

        :rtype: WriteError
        """
        if not self.is_path_write():
            raise AttributeError("tag 'path_write' not set")
        return self._value

    def __repr__(self):
        return 'DeleteError(%r, %r)' % (self._tag, self._value)

DeleteError_validator = bv.Union(DeleteError)

class DeleteResult(FileOpsResult):
    """
    :ivar metadata: Metadata of the deleted object.
    """

    __slots__ = [
        '_metadata_value',
        '_metadata_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 metadata=None):
        super(DeleteResult, self).__init__()
        self._metadata_value = None
        self._metadata_present = False
        if metadata is not None:
            self.metadata = metadata

    @property
    def metadata(self):
        """
        Metadata of the deleted object.

        :rtype: Metadata
        """
        if self._metadata_present:
            return self._metadata_value
        else:
            raise AttributeError("missing required field 'metadata'")

    @metadata.setter
    def metadata(self, val):
        self._metadata_validator.validate_type_only(val)
        self._metadata_value = val
        self._metadata_present = True

    @metadata.deleter
    def metadata(self):
        self._metadata_value = None
        self._metadata_present = False

    def __repr__(self):
        return 'DeleteResult(metadata={!r})'.format(
            self._metadata_value,
        )

DeleteResult_validator = bv.Struct(DeleteResult)

class Metadata(object):
    """
    Metadata for a file or folder.

    :ivar name: The last component of the path (including extension). This never
        contains a slash.
    :ivar path_lower: The lowercased full path in the user's Dropbox. This
        always starts with a slash. This field will be null if the file or
        folder is not mounted.
    :ivar path_display: The cased path to be used for display purposes only. In
        rare instances the casing will not correctly match the user's
        filesystem, but this behavior will match the path provided in the Core
        API v1, and at least the last path component will have the correct
        casing. Changes to only the casing of paths won't be returned by
        :meth:`dropbox.dropbox.Dropbox.files_list_folder_continue`. This field
        will be null if the file or folder is not mounted.
    :ivar parent_shared_folder_id: Please use
        ``FileSharingInfo.parent_shared_folder_id`` or
        ``FolderSharingInfo.parent_shared_folder_id`` instead.
    """

    __slots__ = [
        '_name_value',
        '_name_present',
        '_path_lower_value',
        '_path_lower_present',
        '_path_display_value',
        '_path_display_present',
        '_parent_shared_folder_id_value',
        '_parent_shared_folder_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 name=None,
                 path_lower=None,
                 path_display=None,
                 parent_shared_folder_id=None):
        self._name_value = None
        self._name_present = False
        self._path_lower_value = None
        self._path_lower_present = False
        self._path_display_value = None
        self._path_display_present = False
        self._parent_shared_folder_id_value = None
        self._parent_shared_folder_id_present = False
        if name is not None:
            self.name = name
        if path_lower is not None:
            self.path_lower = path_lower
        if path_display is not None:
            self.path_display = path_display
        if parent_shared_folder_id is not None:
            self.parent_shared_folder_id = parent_shared_folder_id

    @property
    def name(self):
        """
        The last component of the path (including extension). This never
        contains a slash.

        :rtype: str
        """
        if self._name_present:
            return self._name_value
        else:
            raise AttributeError("missing required field 'name'")

    @name.setter
    def name(self, val):
        val = self._name_validator.validate(val)
        self._name_value = val
        self._name_present = True

    @name.deleter
    def name(self):
        self._name_value = None
        self._name_present = False

    @property
    def path_lower(self):
        """
        The lowercased full path in the user's Dropbox. This always starts with
        a slash. This field will be null if the file or folder is not mounted.

        :rtype: str
        """
        if self._path_lower_present:
            return self._path_lower_value
        else:
            return None

    @path_lower.setter
    def path_lower(self, val):
        if val is None:
            del self.path_lower
            return
        val = self._path_lower_validator.validate(val)
        self._path_lower_value = val
        self._path_lower_present = True

    @path_lower.deleter
    def path_lower(self):
        self._path_lower_value = None
        self._path_lower_present = False

    @property
    def path_display(self):
        """
        The cased path to be used for display purposes only. In rare instances
        the casing will not correctly match the user's filesystem, but this
        behavior will match the path provided in the Core API v1, and at least
        the last path component will have the correct casing. Changes to only
        the casing of paths won't be returned by
        :meth:`dropbox.dropbox.Dropbox.files_list_folder_continue`. This field
        will be null if the file or folder is not mounted.

        :rtype: str
        """
        if self._path_display_present:
            return self._path_display_value
        else:
            return None

    @path_display.setter
    def path_display(self, val):
        if val is None:
            del self.path_display
            return
        val = self._path_display_validator.validate(val)
        self._path_display_value = val
        self._path_display_present = True

    @path_display.deleter
    def path_display(self):
        self._path_display_value = None
        self._path_display_present = False

    @property
    def parent_shared_folder_id(self):
        """
        Please use ``FileSharingInfo.parent_shared_folder_id`` or
        ``FolderSharingInfo.parent_shared_folder_id`` instead.

        :rtype: str
        """
        if self._parent_shared_folder_id_present:
            return self._parent_shared_folder_id_value
        else:
            return None

    @parent_shared_folder_id.setter
    def parent_shared_folder_id(self, val):
        if val is None:
            del self.parent_shared_folder_id
            return
        val = self._parent_shared_folder_id_validator.validate(val)
        self._parent_shared_folder_id_value = val
        self._parent_shared_folder_id_present = True

    @parent_shared_folder_id.deleter
    def parent_shared_folder_id(self):
        self._parent_shared_folder_id_value = None
        self._parent_shared_folder_id_present = False

    def __repr__(self):
        return 'Metadata(name={!r}, path_lower={!r}, path_display={!r}, parent_shared_folder_id={!r})'.format(
            self._name_value,
            self._path_lower_value,
            self._path_display_value,
            self._parent_shared_folder_id_value,
        )

Metadata_validator = bv.StructTree(Metadata)

class DeletedMetadata(Metadata):
    """
    Indicates that there used to be a file or folder at this path, but it no
    longer exists.
    """

    __slots__ = [
    ]

    _has_required_fields = True

    def __init__(self,
                 name=None,
                 path_lower=None,
                 path_display=None,
                 parent_shared_folder_id=None):
        super(DeletedMetadata, self).__init__(name,
                                              path_lower,
                                              path_display,
                                              parent_shared_folder_id)

    def __repr__(self):
        return 'DeletedMetadata(name={!r}, path_lower={!r}, path_display={!r}, parent_shared_folder_id={!r})'.format(
            self._name_value,
            self._path_lower_value,
            self._path_display_value,
            self._parent_shared_folder_id_value,
        )

DeletedMetadata_validator = bv.Struct(DeletedMetadata)

class Dimensions(object):
    """
    Dimensions for a photo or video.

    :ivar height: Height of the photo/video.
    :ivar width: Width of the photo/video.
    """

    __slots__ = [
        '_height_value',
        '_height_present',
        '_width_value',
        '_width_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 height=None,
                 width=None):
        self._height_value = None
        self._height_present = False
        self._width_value = None
        self._width_present = False
        if height is not None:
            self.height = height
        if width is not None:
            self.width = width

    @property
    def height(self):
        """
        Height of the photo/video.

        :rtype: long
        """
        if self._height_present:
            return self._height_value
        else:
            raise AttributeError("missing required field 'height'")

    @height.setter
    def height(self, val):
        val = self._height_validator.validate(val)
        self._height_value = val
        self._height_present = True

    @height.deleter
    def height(self):
        self._height_value = None
        self._height_present = False

    @property
    def width(self):
        """
        Width of the photo/video.

        :rtype: long
        """
        if self._width_present:
            return self._width_value
        else:
            raise AttributeError("missing required field 'width'")

    @width.setter
    def width(self, val):
        val = self._width_validator.validate(val)
        self._width_value = val
        self._width_present = True

    @width.deleter
    def width(self):
        self._width_value = None
        self._width_present = False

    def __repr__(self):
        return 'Dimensions(height={!r}, width={!r})'.format(
            self._height_value,
            self._width_value,
        )

Dimensions_validator = bv.Struct(Dimensions)

class DownloadArg(object):
    """
    :ivar path: The path of the file to download.
    :ivar rev: Please specify revision in ``path`` instead.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_rev_value',
        '_rev_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 rev=None):
        self._path_value = None
        self._path_present = False
        self._rev_value = None
        self._rev_present = False
        if path is not None:
            self.path = path
        if rev is not None:
            self.rev = rev

    @property
    def path(self):
        """
        The path of the file to download.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def rev(self):
        """
        Please specify revision in ``path`` instead.

        :rtype: str
        """
        if self._rev_present:
            return self._rev_value
        else:
            return None

    @rev.setter
    def rev(self, val):
        if val is None:
            del self.rev
            return
        val = self._rev_validator.validate(val)
        self._rev_value = val
        self._rev_present = True

    @rev.deleter
    def rev(self):
        self._rev_value = None
        self._rev_present = False

    def __repr__(self):
        return 'DownloadArg(path={!r}, rev={!r})'.format(
            self._path_value,
            self._rev_value,
        )

DownloadArg_validator = bv.Struct(DownloadArg)

class DownloadError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: DownloadError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'DownloadError(%r, %r)' % (self._tag, self._value)

DownloadError_validator = bv.Union(DownloadError)

class DownloadZipArg(object):
    """
    :ivar path: The path of the folder to download.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None):
        self._path_value = None
        self._path_present = False
        if path is not None:
            self.path = path

    @property
    def path(self):
        """
        The path of the folder to download.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    def __repr__(self):
        return 'DownloadZipArg(path={!r})'.format(
            self._path_value,
        )

DownloadZipArg_validator = bv.Struct(DownloadZipArg)

class DownloadZipError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar too_large: The folder is too large to download.
    :ivar too_many_files: The folder has too many files to download.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    too_large = None
    # Attribute is overwritten below the class definition
    too_many_files = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: DownloadZipError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_too_large(self):
        """
        Check if the union tag is ``too_large``.

        :rtype: bool
        """
        return self._tag == 'too_large'

    def is_too_many_files(self):
        """
        Check if the union tag is ``too_many_files``.

        :rtype: bool
        """
        return self._tag == 'too_many_files'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'DownloadZipError(%r, %r)' % (self._tag, self._value)

DownloadZipError_validator = bv.Union(DownloadZipError)

class DownloadZipResult(object):

    __slots__ = [
        '_metadata_value',
        '_metadata_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 metadata=None):
        self._metadata_value = None
        self._metadata_present = False
        if metadata is not None:
            self.metadata = metadata

    @property
    def metadata(self):
        """
        :rtype: FolderMetadata
        """
        if self._metadata_present:
            return self._metadata_value
        else:
            raise AttributeError("missing required field 'metadata'")

    @metadata.setter
    def metadata(self, val):
        self._metadata_validator.validate_type_only(val)
        self._metadata_value = val
        self._metadata_present = True

    @metadata.deleter
    def metadata(self):
        self._metadata_value = None
        self._metadata_present = False

    def __repr__(self):
        return 'DownloadZipResult(metadata={!r})'.format(
            self._metadata_value,
        )

DownloadZipResult_validator = bv.Struct(DownloadZipResult)

class FileMetadata(Metadata):
    """
    :ivar id: A unique identifier for the file.
    :ivar client_modified: For files, this is the modification time set by the
        desktop client when the file was added to Dropbox. Since this time is
        not verified (the Dropbox server stores whatever the desktop client
        sends up), this should only be used for display purposes (such as
        sorting) and not, for example, to determine if a file has changed or
        not.
    :ivar server_modified: The last time the file was modified on Dropbox.
    :ivar rev: A unique identifier for the current revision of a file. This
        field is the same rev as elsewhere in the API and can be used to detect
        changes and avoid conflicts.
    :ivar size: The file size in bytes.
    :ivar media_info: Additional information if the file is a photo or video.
    :ivar symlink_info: Set if this file is a symlink.
    :ivar sharing_info: Set if this file is contained in a shared folder.
    :ivar property_groups: Additional information if the file has custom
        properties with the property template specified.
    :ivar has_explicit_shared_members: This flag will only be present if
        include_has_explicit_shared_members  is true in
        :meth:`dropbox.dropbox.Dropbox.files_list_folder` or
        :meth:`dropbox.dropbox.Dropbox.files_get_metadata`. If this  flag is
        present, it will be true if this file has any explicit shared  members.
        This is different from sharing_info in that this could be true  in the
        case where a file has explicit members but is not contained within  a
        shared folder.
    :ivar content_hash: A hash of the file content. This field can be used to
        verify data integrity. For more information see our `Content hash
        </developers/reference/content-hash>`_ page.
    """

    __slots__ = [
        '_id_value',
        '_id_present',
        '_client_modified_value',
        '_client_modified_present',
        '_server_modified_value',
        '_server_modified_present',
        '_rev_value',
        '_rev_present',
        '_size_value',
        '_size_present',
        '_media_info_value',
        '_media_info_present',
        '_symlink_info_value',
        '_symlink_info_present',
        '_sharing_info_value',
        '_sharing_info_present',
        '_property_groups_value',
        '_property_groups_present',
        '_has_explicit_shared_members_value',
        '_has_explicit_shared_members_present',
        '_content_hash_value',
        '_content_hash_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 name=None,
                 id=None,
                 client_modified=None,
                 server_modified=None,
                 rev=None,
                 size=None,
                 path_lower=None,
                 path_display=None,
                 parent_shared_folder_id=None,
                 media_info=None,
                 symlink_info=None,
                 sharing_info=None,
                 property_groups=None,
                 has_explicit_shared_members=None,
                 content_hash=None):
        super(FileMetadata, self).__init__(name,
                                           path_lower,
                                           path_display,
                                           parent_shared_folder_id)
        self._id_value = None
        self._id_present = False
        self._client_modified_value = None
        self._client_modified_present = False
        self._server_modified_value = None
        self._server_modified_present = False
        self._rev_value = None
        self._rev_present = False
        self._size_value = None
        self._size_present = False
        self._media_info_value = None
        self._media_info_present = False
        self._symlink_info_value = None
        self._symlink_info_present = False
        self._sharing_info_value = None
        self._sharing_info_present = False
        self._property_groups_value = None
        self._property_groups_present = False
        self._has_explicit_shared_members_value = None
        self._has_explicit_shared_members_present = False
        self._content_hash_value = None
        self._content_hash_present = False
        if id is not None:
            self.id = id
        if client_modified is not None:
            self.client_modified = client_modified
        if server_modified is not None:
            self.server_modified = server_modified
        if rev is not None:
            self.rev = rev
        if size is not None:
            self.size = size
        if media_info is not None:
            self.media_info = media_info
        if symlink_info is not None:
            self.symlink_info = symlink_info
        if sharing_info is not None:
            self.sharing_info = sharing_info
        if property_groups is not None:
            self.property_groups = property_groups
        if has_explicit_shared_members is not None:
            self.has_explicit_shared_members = has_explicit_shared_members
        if content_hash is not None:
            self.content_hash = content_hash

    @property
    def id(self):
        """
        A unique identifier for the file.

        :rtype: str
        """
        if self._id_present:
            return self._id_value
        else:
            raise AttributeError("missing required field 'id'")

    @id.setter
    def id(self, val):
        val = self._id_validator.validate(val)
        self._id_value = val
        self._id_present = True

    @id.deleter
    def id(self):
        self._id_value = None
        self._id_present = False

    @property
    def client_modified(self):
        """
        For files, this is the modification time set by the desktop client when
        the file was added to Dropbox. Since this time is not verified (the
        Dropbox server stores whatever the desktop client sends up), this should
        only be used for display purposes (such as sorting) and not, for
        example, to determine if a file has changed or not.

        :rtype: datetime.datetime
        """
        if self._client_modified_present:
            return self._client_modified_value
        else:
            raise AttributeError("missing required field 'client_modified'")

    @client_modified.setter
    def client_modified(self, val):
        val = self._client_modified_validator.validate(val)
        self._client_modified_value = val
        self._client_modified_present = True

    @client_modified.deleter
    def client_modified(self):
        self._client_modified_value = None
        self._client_modified_present = False

    @property
    def server_modified(self):
        """
        The last time the file was modified on Dropbox.

        :rtype: datetime.datetime
        """
        if self._server_modified_present:
            return self._server_modified_value
        else:
            raise AttributeError("missing required field 'server_modified'")

    @server_modified.setter
    def server_modified(self, val):
        val = self._server_modified_validator.validate(val)
        self._server_modified_value = val
        self._server_modified_present = True

    @server_modified.deleter
    def server_modified(self):
        self._server_modified_value = None
        self._server_modified_present = False

    @property
    def rev(self):
        """
        A unique identifier for the current revision of a file. This field is
        the same rev as elsewhere in the API and can be used to detect changes
        and avoid conflicts.

        :rtype: str
        """
        if self._rev_present:
            return self._rev_value
        else:
            raise AttributeError("missing required field 'rev'")

    @rev.setter
    def rev(self, val):
        val = self._rev_validator.validate(val)
        self._rev_value = val
        self._rev_present = True

    @rev.deleter
    def rev(self):
        self._rev_value = None
        self._rev_present = False

    @property
    def size(self):
        """
        The file size in bytes.

        :rtype: long
        """
        if self._size_present:
            return self._size_value
        else:
            raise AttributeError("missing required field 'size'")

    @size.setter
    def size(self, val):
        val = self._size_validator.validate(val)
        self._size_value = val
        self._size_present = True

    @size.deleter
    def size(self):
        self._size_value = None
        self._size_present = False

    @property
    def media_info(self):
        """
        Additional information if the file is a photo or video.

        :rtype: MediaInfo
        """
        if self._media_info_present:
            return self._media_info_value
        else:
            return None

    @media_info.setter
    def media_info(self, val):
        if val is None:
            del self.media_info
            return
        self._media_info_validator.validate_type_only(val)
        self._media_info_value = val
        self._media_info_present = True

    @media_info.deleter
    def media_info(self):
        self._media_info_value = None
        self._media_info_present = False

    @property
    def symlink_info(self):
        """
        Set if this file is a symlink.

        :rtype: SymlinkInfo
        """
        if self._symlink_info_present:
            return self._symlink_info_value
        else:
            return None

    @symlink_info.setter
    def symlink_info(self, val):
        if val is None:
            del self.symlink_info
            return
        self._symlink_info_validator.validate_type_only(val)
        self._symlink_info_value = val
        self._symlink_info_present = True

    @symlink_info.deleter
    def symlink_info(self):
        self._symlink_info_value = None
        self._symlink_info_present = False

    @property
    def sharing_info(self):
        """
        Set if this file is contained in a shared folder.

        :rtype: FileSharingInfo
        """
        if self._sharing_info_present:
            return self._sharing_info_value
        else:
            return None

    @sharing_info.setter
    def sharing_info(self, val):
        if val is None:
            del self.sharing_info
            return
        self._sharing_info_validator.validate_type_only(val)
        self._sharing_info_value = val
        self._sharing_info_present = True

    @sharing_info.deleter
    def sharing_info(self):
        self._sharing_info_value = None
        self._sharing_info_present = False

    @property
    def property_groups(self):
        """
        Additional information if the file has custom properties with the
        property template specified.

        :rtype: list of [file_properties.PropertyGroup_validator]
        """
        if self._property_groups_present:
            return self._property_groups_value
        else:
            return None

    @property_groups.setter
    def property_groups(self, val):
        if val is None:
            del self.property_groups
            return
        val = self._property_groups_validator.validate(val)
        self._property_groups_value = val
        self._property_groups_present = True

    @property_groups.deleter
    def property_groups(self):
        self._property_groups_value = None
        self._property_groups_present = False

    @property
    def has_explicit_shared_members(self):
        """
        This flag will only be present if include_has_explicit_shared_members
        is true in :meth:`dropbox.dropbox.Dropbox.files_list_folder` or
        :meth:`dropbox.dropbox.Dropbox.files_get_metadata`. If this  flag is
        present, it will be true if this file has any explicit shared  members.
        This is different from sharing_info in that this could be true  in the
        case where a file has explicit members but is not contained within  a
        shared folder.

        :rtype: bool
        """
        if self._has_explicit_shared_members_present:
            return self._has_explicit_shared_members_value
        else:
            return None

    @has_explicit_shared_members.setter
    def has_explicit_shared_members(self, val):
        if val is None:
            del self.has_explicit_shared_members
            return
        val = self._has_explicit_shared_members_validator.validate(val)
        self._has_explicit_shared_members_value = val
        self._has_explicit_shared_members_present = True

    @has_explicit_shared_members.deleter
    def has_explicit_shared_members(self):
        self._has_explicit_shared_members_value = None
        self._has_explicit_shared_members_present = False

    @property
    def content_hash(self):
        """
        A hash of the file content. This field can be used to verify data
        integrity. For more information see our `Content hash
        </developers/reference/content-hash>`_ page.

        :rtype: str
        """
        if self._content_hash_present:
            return self._content_hash_value
        else:
            return None

    @content_hash.setter
    def content_hash(self, val):
        if val is None:
            del self.content_hash
            return
        val = self._content_hash_validator.validate(val)
        self._content_hash_value = val
        self._content_hash_present = True

    @content_hash.deleter
    def content_hash(self):
        self._content_hash_value = None
        self._content_hash_present = False

    def __repr__(self):
        return 'FileMetadata(name={!r}, id={!r}, client_modified={!r}, server_modified={!r}, rev={!r}, size={!r}, path_lower={!r}, path_display={!r}, parent_shared_folder_id={!r}, media_info={!r}, symlink_info={!r}, sharing_info={!r}, property_groups={!r}, has_explicit_shared_members={!r}, content_hash={!r})'.format(
            self._name_value,
            self._id_value,
            self._client_modified_value,
            self._server_modified_value,
            self._rev_value,
            self._size_value,
            self._path_lower_value,
            self._path_display_value,
            self._parent_shared_folder_id_value,
            self._media_info_value,
            self._symlink_info_value,
            self._sharing_info_value,
            self._property_groups_value,
            self._has_explicit_shared_members_value,
            self._content_hash_value,
        )

FileMetadata_validator = bv.Struct(FileMetadata)

class SharingInfo(object):
    """
    Sharing info for a file or folder.

    :ivar read_only: True if the file or folder is inside a read-only shared
        folder.
    """

    __slots__ = [
        '_read_only_value',
        '_read_only_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 read_only=None):
        self._read_only_value = None
        self._read_only_present = False
        if read_only is not None:
            self.read_only = read_only

    @property
    def read_only(self):
        """
        True if the file or folder is inside a read-only shared folder.

        :rtype: bool
        """
        if self._read_only_present:
            return self._read_only_value
        else:
            raise AttributeError("missing required field 'read_only'")

    @read_only.setter
    def read_only(self, val):
        val = self._read_only_validator.validate(val)
        self._read_only_value = val
        self._read_only_present = True

    @read_only.deleter
    def read_only(self):
        self._read_only_value = None
        self._read_only_present = False

    def __repr__(self):
        return 'SharingInfo(read_only={!r})'.format(
            self._read_only_value,
        )

SharingInfo_validator = bv.Struct(SharingInfo)

class FileSharingInfo(SharingInfo):
    """
    Sharing info for a file which is contained by a shared folder.

    :ivar parent_shared_folder_id: ID of shared folder that holds this file.
    :ivar modified_by: The last user who modified the file. This field will be
        null if the user's account has been deleted.
    """

    __slots__ = [
        '_parent_shared_folder_id_value',
        '_parent_shared_folder_id_present',
        '_modified_by_value',
        '_modified_by_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 read_only=None,
                 parent_shared_folder_id=None,
                 modified_by=None):
        super(FileSharingInfo, self).__init__(read_only)
        self._parent_shared_folder_id_value = None
        self._parent_shared_folder_id_present = False
        self._modified_by_value = None
        self._modified_by_present = False
        if parent_shared_folder_id is not None:
            self.parent_shared_folder_id = parent_shared_folder_id
        if modified_by is not None:
            self.modified_by = modified_by

    @property
    def parent_shared_folder_id(self):
        """
        ID of shared folder that holds this file.

        :rtype: str
        """
        if self._parent_shared_folder_id_present:
            return self._parent_shared_folder_id_value
        else:
            raise AttributeError("missing required field 'parent_shared_folder_id'")

    @parent_shared_folder_id.setter
    def parent_shared_folder_id(self, val):
        val = self._parent_shared_folder_id_validator.validate(val)
        self._parent_shared_folder_id_value = val
        self._parent_shared_folder_id_present = True

    @parent_shared_folder_id.deleter
    def parent_shared_folder_id(self):
        self._parent_shared_folder_id_value = None
        self._parent_shared_folder_id_present = False

    @property
    def modified_by(self):
        """
        The last user who modified the file. This field will be null if the
        user's account has been deleted.

        :rtype: str
        """
        if self._modified_by_present:
            return self._modified_by_value
        else:
            return None

    @modified_by.setter
    def modified_by(self, val):
        if val is None:
            del self.modified_by
            return
        val = self._modified_by_validator.validate(val)
        self._modified_by_value = val
        self._modified_by_present = True

    @modified_by.deleter
    def modified_by(self):
        self._modified_by_value = None
        self._modified_by_present = False

    def __repr__(self):
        return 'FileSharingInfo(read_only={!r}, parent_shared_folder_id={!r}, modified_by={!r})'.format(
            self._read_only_value,
            self._parent_shared_folder_id_value,
            self._modified_by_value,
        )

FileSharingInfo_validator = bv.Struct(FileSharingInfo)

class FolderMetadata(Metadata):
    """
    :ivar id: A unique identifier for the folder.
    :ivar shared_folder_id: Please use ``sharing_info`` instead.
    :ivar sharing_info: Set if the folder is contained in a shared folder or is
        a shared folder mount point.
    :ivar property_groups: Additional information if the file has custom
        properties with the property template specified. Note that only
        properties associated with user-owned templates, not team-owned
        templates, can be attached to folders.
    """

    __slots__ = [
        '_id_value',
        '_id_present',
        '_shared_folder_id_value',
        '_shared_folder_id_present',
        '_sharing_info_value',
        '_sharing_info_present',
        '_property_groups_value',
        '_property_groups_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 name=None,
                 id=None,
                 path_lower=None,
                 path_display=None,
                 parent_shared_folder_id=None,
                 shared_folder_id=None,
                 sharing_info=None,
                 property_groups=None):
        super(FolderMetadata, self).__init__(name,
                                             path_lower,
                                             path_display,
                                             parent_shared_folder_id)
        self._id_value = None
        self._id_present = False
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        self._sharing_info_value = None
        self._sharing_info_present = False
        self._property_groups_value = None
        self._property_groups_present = False
        if id is not None:
            self.id = id
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id
        if sharing_info is not None:
            self.sharing_info = sharing_info
        if property_groups is not None:
            self.property_groups = property_groups

    @property
    def id(self):
        """
        A unique identifier for the folder.

        :rtype: str
        """
        if self._id_present:
            return self._id_value
        else:
            raise AttributeError("missing required field 'id'")

    @id.setter
    def id(self, val):
        val = self._id_validator.validate(val)
        self._id_value = val
        self._id_present = True

    @id.deleter
    def id(self):
        self._id_value = None
        self._id_present = False

    @property
    def shared_folder_id(self):
        """
        Please use ``sharing_info`` instead.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            return None

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        if val is None:
            del self.shared_folder_id
            return
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    @property
    def sharing_info(self):
        """
        Set if the folder is contained in a shared folder or is a shared folder
        mount point.

        :rtype: FolderSharingInfo
        """
        if self._sharing_info_present:
            return self._sharing_info_value
        else:
            return None

    @sharing_info.setter
    def sharing_info(self, val):
        if val is None:
            del self.sharing_info
            return
        self._sharing_info_validator.validate_type_only(val)
        self._sharing_info_value = val
        self._sharing_info_present = True

    @sharing_info.deleter
    def sharing_info(self):
        self._sharing_info_value = None
        self._sharing_info_present = False

    @property
    def property_groups(self):
        """
        Additional information if the file has custom properties with the
        property template specified. Note that only properties associated with
        user-owned templates, not team-owned templates, can be attached to
        folders.

        :rtype: list of [file_properties.PropertyGroup_validator]
        """
        if self._property_groups_present:
            return self._property_groups_value
        else:
            return None

    @property_groups.setter
    def property_groups(self, val):
        if val is None:
            del self.property_groups
            return
        val = self._property_groups_validator.validate(val)
        self._property_groups_value = val
        self._property_groups_present = True

    @property_groups.deleter
    def property_groups(self):
        self._property_groups_value = None
        self._property_groups_present = False

    def __repr__(self):
        return 'FolderMetadata(name={!r}, id={!r}, path_lower={!r}, path_display={!r}, parent_shared_folder_id={!r}, shared_folder_id={!r}, sharing_info={!r}, property_groups={!r})'.format(
            self._name_value,
            self._id_value,
            self._path_lower_value,
            self._path_display_value,
            self._parent_shared_folder_id_value,
            self._shared_folder_id_value,
            self._sharing_info_value,
            self._property_groups_value,
        )

FolderMetadata_validator = bv.Struct(FolderMetadata)

class FolderSharingInfo(SharingInfo):
    """
    Sharing info for a folder which is contained in a shared folder or is a
    shared folder mount point.

    :ivar parent_shared_folder_id: Set if the folder is contained by a shared
        folder.
    :ivar shared_folder_id: If this folder is a shared folder mount point, the
        ID of the shared folder mounted at this location.
    :ivar traverse_only: Specifies that the folder can only be traversed and the
        user can only see a limited subset of the contents of this folder
        because they don't have read access to this folder. They do, however,
        have access to some sub folder.
    :ivar no_access: Specifies that the folder cannot be accessed by the user.
    """

    __slots__ = [
        '_parent_shared_folder_id_value',
        '_parent_shared_folder_id_present',
        '_shared_folder_id_value',
        '_shared_folder_id_present',
        '_traverse_only_value',
        '_traverse_only_present',
        '_no_access_value',
        '_no_access_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 read_only=None,
                 parent_shared_folder_id=None,
                 shared_folder_id=None,
                 traverse_only=None,
                 no_access=None):
        super(FolderSharingInfo, self).__init__(read_only)
        self._parent_shared_folder_id_value = None
        self._parent_shared_folder_id_present = False
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        self._traverse_only_value = None
        self._traverse_only_present = False
        self._no_access_value = None
        self._no_access_present = False
        if parent_shared_folder_id is not None:
            self.parent_shared_folder_id = parent_shared_folder_id
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id
        if traverse_only is not None:
            self.traverse_only = traverse_only
        if no_access is not None:
            self.no_access = no_access

    @property
    def parent_shared_folder_id(self):
        """
        Set if the folder is contained by a shared folder.

        :rtype: str
        """
        if self._parent_shared_folder_id_present:
            return self._parent_shared_folder_id_value
        else:
            return None

    @parent_shared_folder_id.setter
    def parent_shared_folder_id(self, val):
        if val is None:
            del self.parent_shared_folder_id
            return
        val = self._parent_shared_folder_id_validator.validate(val)
        self._parent_shared_folder_id_value = val
        self._parent_shared_folder_id_present = True

    @parent_shared_folder_id.deleter
    def parent_shared_folder_id(self):
        self._parent_shared_folder_id_value = None
        self._parent_shared_folder_id_present = False

    @property
    def shared_folder_id(self):
        """
        If this folder is a shared folder mount point, the ID of the shared
        folder mounted at this location.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            return None

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        if val is None:
            del self.shared_folder_id
            return
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    @property
    def traverse_only(self):
        """
        Specifies that the folder can only be traversed and the user can only
        see a limited subset of the contents of this folder because they don't
        have read access to this folder. They do, however, have access to some
        sub folder.

        :rtype: bool
        """
        if self._traverse_only_present:
            return self._traverse_only_value
        else:
            return False

    @traverse_only.setter
    def traverse_only(self, val):
        val = self._traverse_only_validator.validate(val)
        self._traverse_only_value = val
        self._traverse_only_present = True

    @traverse_only.deleter
    def traverse_only(self):
        self._traverse_only_value = None
        self._traverse_only_present = False

    @property
    def no_access(self):
        """
        Specifies that the folder cannot be accessed by the user.

        :rtype: bool
        """
        if self._no_access_present:
            return self._no_access_value
        else:
            return False

    @no_access.setter
    def no_access(self, val):
        val = self._no_access_validator.validate(val)
        self._no_access_value = val
        self._no_access_present = True

    @no_access.deleter
    def no_access(self):
        self._no_access_value = None
        self._no_access_present = False

    def __repr__(self):
        return 'FolderSharingInfo(read_only={!r}, parent_shared_folder_id={!r}, shared_folder_id={!r}, traverse_only={!r}, no_access={!r})'.format(
            self._read_only_value,
            self._parent_shared_folder_id_value,
            self._shared_folder_id_value,
            self._traverse_only_value,
            self._no_access_value,
        )

FolderSharingInfo_validator = bv.Struct(FolderSharingInfo)

class GetCopyReferenceArg(object):
    """
    :ivar path: The path to the file or folder you want to get a copy reference
        to.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None):
        self._path_value = None
        self._path_present = False
        if path is not None:
            self.path = path

    @property
    def path(self):
        """
        The path to the file or folder you want to get a copy reference to.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    def __repr__(self):
        return 'GetCopyReferenceArg(path={!r})'.format(
            self._path_value,
        )

GetCopyReferenceArg_validator = bv.Struct(GetCopyReferenceArg)

class GetCopyReferenceError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: GetCopyReferenceError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'GetCopyReferenceError(%r, %r)' % (self._tag, self._value)

GetCopyReferenceError_validator = bv.Union(GetCopyReferenceError)

class GetCopyReferenceResult(object):
    """
    :ivar metadata: Metadata of the file or folder.
    :ivar copy_reference: A copy reference to the file or folder.
    :ivar expires: The expiration date of the copy reference. This value is
        currently set to be far enough in the future so that expiration is
        effectively not an issue.
    """

    __slots__ = [
        '_metadata_value',
        '_metadata_present',
        '_copy_reference_value',
        '_copy_reference_present',
        '_expires_value',
        '_expires_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 metadata=None,
                 copy_reference=None,
                 expires=None):
        self._metadata_value = None
        self._metadata_present = False
        self._copy_reference_value = None
        self._copy_reference_present = False
        self._expires_value = None
        self._expires_present = False
        if metadata is not None:
            self.metadata = metadata
        if copy_reference is not None:
            self.copy_reference = copy_reference
        if expires is not None:
            self.expires = expires

    @property
    def metadata(self):
        """
        Metadata of the file or folder.

        :rtype: Metadata
        """
        if self._metadata_present:
            return self._metadata_value
        else:
            raise AttributeError("missing required field 'metadata'")

    @metadata.setter
    def metadata(self, val):
        self._metadata_validator.validate_type_only(val)
        self._metadata_value = val
        self._metadata_present = True

    @metadata.deleter
    def metadata(self):
        self._metadata_value = None
        self._metadata_present = False

    @property
    def copy_reference(self):
        """
        A copy reference to the file or folder.

        :rtype: str
        """
        if self._copy_reference_present:
            return self._copy_reference_value
        else:
            raise AttributeError("missing required field 'copy_reference'")

    @copy_reference.setter
    def copy_reference(self, val):
        val = self._copy_reference_validator.validate(val)
        self._copy_reference_value = val
        self._copy_reference_present = True

    @copy_reference.deleter
    def copy_reference(self):
        self._copy_reference_value = None
        self._copy_reference_present = False

    @property
    def expires(self):
        """
        The expiration date of the copy reference. This value is currently set
        to be far enough in the future so that expiration is effectively not an
        issue.

        :rtype: datetime.datetime
        """
        if self._expires_present:
            return self._expires_value
        else:
            raise AttributeError("missing required field 'expires'")

    @expires.setter
    def expires(self, val):
        val = self._expires_validator.validate(val)
        self._expires_value = val
        self._expires_present = True

    @expires.deleter
    def expires(self):
        self._expires_value = None
        self._expires_present = False

    def __repr__(self):
        return 'GetCopyReferenceResult(metadata={!r}, copy_reference={!r}, expires={!r})'.format(
            self._metadata_value,
            self._copy_reference_value,
            self._expires_value,
        )

GetCopyReferenceResult_validator = bv.Struct(GetCopyReferenceResult)

class GetTemporaryLinkArg(object):
    """
    :ivar path: The path to the file you want a temporary link to.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None):
        self._path_value = None
        self._path_present = False
        if path is not None:
            self.path = path

    @property
    def path(self):
        """
        The path to the file you want a temporary link to.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    def __repr__(self):
        return 'GetTemporaryLinkArg(path={!r})'.format(
            self._path_value,
        )

GetTemporaryLinkArg_validator = bv.Struct(GetTemporaryLinkArg)

class GetTemporaryLinkError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: GetTemporaryLinkError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'GetTemporaryLinkError(%r, %r)' % (self._tag, self._value)

GetTemporaryLinkError_validator = bv.Union(GetTemporaryLinkError)

class GetTemporaryLinkResult(object):
    """
    :ivar metadata: Metadata of the file.
    :ivar link: The temporary link which can be used to stream content the file.
    """

    __slots__ = [
        '_metadata_value',
        '_metadata_present',
        '_link_value',
        '_link_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 metadata=None,
                 link=None):
        self._metadata_value = None
        self._metadata_present = False
        self._link_value = None
        self._link_present = False
        if metadata is not None:
            self.metadata = metadata
        if link is not None:
            self.link = link

    @property
    def metadata(self):
        """
        Metadata of the file.

        :rtype: FileMetadata
        """
        if self._metadata_present:
            return self._metadata_value
        else:
            raise AttributeError("missing required field 'metadata'")

    @metadata.setter
    def metadata(self, val):
        self._metadata_validator.validate_type_only(val)
        self._metadata_value = val
        self._metadata_present = True

    @metadata.deleter
    def metadata(self):
        self._metadata_value = None
        self._metadata_present = False

    @property
    def link(self):
        """
        The temporary link which can be used to stream content the file.

        :rtype: str
        """
        if self._link_present:
            return self._link_value
        else:
            raise AttributeError("missing required field 'link'")

    @link.setter
    def link(self, val):
        val = self._link_validator.validate(val)
        self._link_value = val
        self._link_present = True

    @link.deleter
    def link(self):
        self._link_value = None
        self._link_present = False

    def __repr__(self):
        return 'GetTemporaryLinkResult(metadata={!r}, link={!r})'.format(
            self._metadata_value,
            self._link_value,
        )

GetTemporaryLinkResult_validator = bv.Struct(GetTemporaryLinkResult)

class GetThumbnailBatchArg(object):
    """
    Arguments for :meth:`dropbox.dropbox.Dropbox.files_get_thumbnail_batch`.

    :ivar entries: List of files to get thumbnails.
    """

    __slots__ = [
        '_entries_value',
        '_entries_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 entries=None):
        self._entries_value = None
        self._entries_present = False
        if entries is not None:
            self.entries = entries

    @property
    def entries(self):
        """
        List of files to get thumbnails.

        :rtype: list of [ThumbnailArg]
        """
        if self._entries_present:
            return self._entries_value
        else:
            raise AttributeError("missing required field 'entries'")

    @entries.setter
    def entries(self, val):
        val = self._entries_validator.validate(val)
        self._entries_value = val
        self._entries_present = True

    @entries.deleter
    def entries(self):
        self._entries_value = None
        self._entries_present = False

    def __repr__(self):
        return 'GetThumbnailBatchArg(entries={!r})'.format(
            self._entries_value,
        )

GetThumbnailBatchArg_validator = bv.Struct(GetThumbnailBatchArg)

class GetThumbnailBatchError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar too_many_files: The operation involves more than 25 files.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    too_many_files = None
    # Attribute is overwritten below the class definition
    other = None

    def is_too_many_files(self):
        """
        Check if the union tag is ``too_many_files``.

        :rtype: bool
        """
        return self._tag == 'too_many_files'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'GetThumbnailBatchError(%r, %r)' % (self._tag, self._value)

GetThumbnailBatchError_validator = bv.Union(GetThumbnailBatchError)

class GetThumbnailBatchResult(object):
    """
    :ivar entries: List of files and their thumbnails.
    """

    __slots__ = [
        '_entries_value',
        '_entries_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 entries=None):
        self._entries_value = None
        self._entries_present = False
        if entries is not None:
            self.entries = entries

    @property
    def entries(self):
        """
        List of files and their thumbnails.

        :rtype: list of [GetThumbnailBatchResultEntry]
        """
        if self._entries_present:
            return self._entries_value
        else:
            raise AttributeError("missing required field 'entries'")

    @entries.setter
    def entries(self, val):
        val = self._entries_validator.validate(val)
        self._entries_value = val
        self._entries_present = True

    @entries.deleter
    def entries(self):
        self._entries_value = None
        self._entries_present = False

    def __repr__(self):
        return 'GetThumbnailBatchResult(entries={!r})'.format(
            self._entries_value,
        )

GetThumbnailBatchResult_validator = bv.Struct(GetThumbnailBatchResult)

class GetThumbnailBatchResultData(object):

    __slots__ = [
        '_metadata_value',
        '_metadata_present',
        '_thumbnail_value',
        '_thumbnail_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 metadata=None,
                 thumbnail=None):
        self._metadata_value = None
        self._metadata_present = False
        self._thumbnail_value = None
        self._thumbnail_present = False
        if metadata is not None:
            self.metadata = metadata
        if thumbnail is not None:
            self.thumbnail = thumbnail

    @property
    def metadata(self):
        """
        :rtype: FileMetadata
        """
        if self._metadata_present:
            return self._metadata_value
        else:
            raise AttributeError("missing required field 'metadata'")

    @metadata.setter
    def metadata(self, val):
        self._metadata_validator.validate_type_only(val)
        self._metadata_value = val
        self._metadata_present = True

    @metadata.deleter
    def metadata(self):
        self._metadata_value = None
        self._metadata_present = False

    @property
    def thumbnail(self):
        """
        :rtype: str
        """
        if self._thumbnail_present:
            return self._thumbnail_value
        else:
            raise AttributeError("missing required field 'thumbnail'")

    @thumbnail.setter
    def thumbnail(self, val):
        val = self._thumbnail_validator.validate(val)
        self._thumbnail_value = val
        self._thumbnail_present = True

    @thumbnail.deleter
    def thumbnail(self):
        self._thumbnail_value = None
        self._thumbnail_present = False

    def __repr__(self):
        return 'GetThumbnailBatchResultData(metadata={!r}, thumbnail={!r})'.format(
            self._metadata_value,
            self._thumbnail_value,
        )

GetThumbnailBatchResultData_validator = bv.Struct(GetThumbnailBatchResultData)

class GetThumbnailBatchResultEntry(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar ThumbnailError failure: The result for this file if it was an error.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def success(cls, val):
        """
        Create an instance of this class set to the ``success`` tag with value
        ``val``.

        :param GetThumbnailBatchResultData val:
        :rtype: GetThumbnailBatchResultEntry
        """
        return cls('success', val)

    @classmethod
    def failure(cls, val):
        """
        Create an instance of this class set to the ``failure`` tag with value
        ``val``.

        :param ThumbnailError val:
        :rtype: GetThumbnailBatchResultEntry
        """
        return cls('failure', val)

    def is_success(self):
        """
        Check if the union tag is ``success``.

        :rtype: bool
        """
        return self._tag == 'success'

    def is_failure(self):
        """
        Check if the union tag is ``failure``.

        :rtype: bool
        """
        return self._tag == 'failure'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_success(self):
        """
        Only call this if :meth:`is_success` is true.

        :rtype: GetThumbnailBatchResultData
        """
        if not self.is_success():
            raise AttributeError("tag 'success' not set")
        return self._value

    def get_failure(self):
        """
        The result for this file if it was an error.

        Only call this if :meth:`is_failure` is true.

        :rtype: ThumbnailError
        """
        if not self.is_failure():
            raise AttributeError("tag 'failure' not set")
        return self._value

    def __repr__(self):
        return 'GetThumbnailBatchResultEntry(%r, %r)' % (self._tag, self._value)

GetThumbnailBatchResultEntry_validator = bv.Union(GetThumbnailBatchResultEntry)

class GpsCoordinates(object):
    """
    GPS coordinates for a photo or video.

    :ivar latitude: Latitude of the GPS coordinates.
    :ivar longitude: Longitude of the GPS coordinates.
    """

    __slots__ = [
        '_latitude_value',
        '_latitude_present',
        '_longitude_value',
        '_longitude_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 latitude=None,
                 longitude=None):
        self._latitude_value = None
        self._latitude_present = False
        self._longitude_value = None
        self._longitude_present = False
        if latitude is not None:
            self.latitude = latitude
        if longitude is not None:
            self.longitude = longitude

    @property
    def latitude(self):
        """
        Latitude of the GPS coordinates.

        :rtype: float
        """
        if self._latitude_present:
            return self._latitude_value
        else:
            raise AttributeError("missing required field 'latitude'")

    @latitude.setter
    def latitude(self, val):
        val = self._latitude_validator.validate(val)
        self._latitude_value = val
        self._latitude_present = True

    @latitude.deleter
    def latitude(self):
        self._latitude_value = None
        self._latitude_present = False

    @property
    def longitude(self):
        """
        Longitude of the GPS coordinates.

        :rtype: float
        """
        if self._longitude_present:
            return self._longitude_value
        else:
            raise AttributeError("missing required field 'longitude'")

    @longitude.setter
    def longitude(self, val):
        val = self._longitude_validator.validate(val)
        self._longitude_value = val
        self._longitude_present = True

    @longitude.deleter
    def longitude(self):
        self._longitude_value = None
        self._longitude_present = False

    def __repr__(self):
        return 'GpsCoordinates(latitude={!r}, longitude={!r})'.format(
            self._latitude_value,
            self._longitude_value,
        )

GpsCoordinates_validator = bv.Struct(GpsCoordinates)

class ListFolderArg(object):
    """
    :ivar path: A unique identifier for the file.
    :ivar recursive: If true, the list folder operation will be applied
        recursively to all subfolders and the response will contain contents of
        all subfolders.
    :ivar include_media_info: If true, ``FileMetadata.media_info`` is set for
        photo and video.
    :ivar include_deleted: If true, the results will include entries for files
        and folders that used to exist but were deleted.
    :ivar include_has_explicit_shared_members: If true, the results will include
        a flag for each file indicating whether or not  that file has any
        explicit members.
    :ivar include_mounted_folders: If true, the results will include entries
        under mounted folders which includes app folder, shared folder and team
        folder.
    :ivar limit: The maximum number of results to return per request. Note: This
        is an approximate number and there can be slightly more entries returned
        in some cases.
    :ivar shared_link: A shared link to list the contents of. If the link is
        password-protected, the password must be provided. If this field is
        present, ``ListFolderArg.path`` will be relative to root of the shared
        link. Only non-recursive mode is supported for shared link.
    :ivar include_property_groups: If set to a valid list of template IDs,
        ``FileMetadata.property_groups`` is set if there exists property data
        associated with the file and each of the listed templates.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_recursive_value',
        '_recursive_present',
        '_include_media_info_value',
        '_include_media_info_present',
        '_include_deleted_value',
        '_include_deleted_present',
        '_include_has_explicit_shared_members_value',
        '_include_has_explicit_shared_members_present',
        '_include_mounted_folders_value',
        '_include_mounted_folders_present',
        '_limit_value',
        '_limit_present',
        '_shared_link_value',
        '_shared_link_present',
        '_include_property_groups_value',
        '_include_property_groups_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 recursive=None,
                 include_media_info=None,
                 include_deleted=None,
                 include_has_explicit_shared_members=None,
                 include_mounted_folders=None,
                 limit=None,
                 shared_link=None,
                 include_property_groups=None):
        self._path_value = None
        self._path_present = False
        self._recursive_value = None
        self._recursive_present = False
        self._include_media_info_value = None
        self._include_media_info_present = False
        self._include_deleted_value = None
        self._include_deleted_present = False
        self._include_has_explicit_shared_members_value = None
        self._include_has_explicit_shared_members_present = False
        self._include_mounted_folders_value = None
        self._include_mounted_folders_present = False
        self._limit_value = None
        self._limit_present = False
        self._shared_link_value = None
        self._shared_link_present = False
        self._include_property_groups_value = None
        self._include_property_groups_present = False
        if path is not None:
            self.path = path
        if recursive is not None:
            self.recursive = recursive
        if include_media_info is not None:
            self.include_media_info = include_media_info
        if include_deleted is not None:
            self.include_deleted = include_deleted
        if include_has_explicit_shared_members is not None:
            self.include_has_explicit_shared_members = include_has_explicit_shared_members
        if include_mounted_folders is not None:
            self.include_mounted_folders = include_mounted_folders
        if limit is not None:
            self.limit = limit
        if shared_link is not None:
            self.shared_link = shared_link
        if include_property_groups is not None:
            self.include_property_groups = include_property_groups

    @property
    def path(self):
        """
        A unique identifier for the file.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def recursive(self):
        """
        If true, the list folder operation will be applied recursively to all
        subfolders and the response will contain contents of all subfolders.

        :rtype: bool
        """
        if self._recursive_present:
            return self._recursive_value
        else:
            return False

    @recursive.setter
    def recursive(self, val):
        val = self._recursive_validator.validate(val)
        self._recursive_value = val
        self._recursive_present = True

    @recursive.deleter
    def recursive(self):
        self._recursive_value = None
        self._recursive_present = False

    @property
    def include_media_info(self):
        """
        If true, ``FileMetadata.media_info`` is set for photo and video.

        :rtype: bool
        """
        if self._include_media_info_present:
            return self._include_media_info_value
        else:
            return False

    @include_media_info.setter
    def include_media_info(self, val):
        val = self._include_media_info_validator.validate(val)
        self._include_media_info_value = val
        self._include_media_info_present = True

    @include_media_info.deleter
    def include_media_info(self):
        self._include_media_info_value = None
        self._include_media_info_present = False

    @property
    def include_deleted(self):
        """
        If true, the results will include entries for files and folders that
        used to exist but were deleted.

        :rtype: bool
        """
        if self._include_deleted_present:
            return self._include_deleted_value
        else:
            return False

    @include_deleted.setter
    def include_deleted(self, val):
        val = self._include_deleted_validator.validate(val)
        self._include_deleted_value = val
        self._include_deleted_present = True

    @include_deleted.deleter
    def include_deleted(self):
        self._include_deleted_value = None
        self._include_deleted_present = False

    @property
    def include_has_explicit_shared_members(self):
        """
        If true, the results will include a flag for each file indicating
        whether or not  that file has any explicit members.

        :rtype: bool
        """
        if self._include_has_explicit_shared_members_present:
            return self._include_has_explicit_shared_members_value
        else:
            return False

    @include_has_explicit_shared_members.setter
    def include_has_explicit_shared_members(self, val):
        val = self._include_has_explicit_shared_members_validator.validate(val)
        self._include_has_explicit_shared_members_value = val
        self._include_has_explicit_shared_members_present = True

    @include_has_explicit_shared_members.deleter
    def include_has_explicit_shared_members(self):
        self._include_has_explicit_shared_members_value = None
        self._include_has_explicit_shared_members_present = False

    @property
    def include_mounted_folders(self):
        """
        If true, the results will include entries under mounted folders which
        includes app folder, shared folder and team folder.

        :rtype: bool
        """
        if self._include_mounted_folders_present:
            return self._include_mounted_folders_value
        else:
            return True

    @include_mounted_folders.setter
    def include_mounted_folders(self, val):
        val = self._include_mounted_folders_validator.validate(val)
        self._include_mounted_folders_value = val
        self._include_mounted_folders_present = True

    @include_mounted_folders.deleter
    def include_mounted_folders(self):
        self._include_mounted_folders_value = None
        self._include_mounted_folders_present = False

    @property
    def limit(self):
        """
        The maximum number of results to return per request. Note: This is an
        approximate number and there can be slightly more entries returned in
        some cases.

        :rtype: long
        """
        if self._limit_present:
            return self._limit_value
        else:
            return None

    @limit.setter
    def limit(self, val):
        if val is None:
            del self.limit
            return
        val = self._limit_validator.validate(val)
        self._limit_value = val
        self._limit_present = True

    @limit.deleter
    def limit(self):
        self._limit_value = None
        self._limit_present = False

    @property
    def shared_link(self):
        """
        A shared link to list the contents of. If the link is
        password-protected, the password must be provided. If this field is
        present, ``ListFolderArg.path`` will be relative to root of the shared
        link. Only non-recursive mode is supported for shared link.

        :rtype: SharedLink
        """
        if self._shared_link_present:
            return self._shared_link_value
        else:
            return None

    @shared_link.setter
    def shared_link(self, val):
        if val is None:
            del self.shared_link
            return
        self._shared_link_validator.validate_type_only(val)
        self._shared_link_value = val
        self._shared_link_present = True

    @shared_link.deleter
    def shared_link(self):
        self._shared_link_value = None
        self._shared_link_present = False

    @property
    def include_property_groups(self):
        """
        If set to a valid list of template IDs, ``FileMetadata.property_groups``
        is set if there exists property data associated with the file and each
        of the listed templates.

        :rtype: file_properties.TemplateFilterBase_validator
        """
        if self._include_property_groups_present:
            return self._include_property_groups_value
        else:
            return None

    @include_property_groups.setter
    def include_property_groups(self, val):
        if val is None:
            del self.include_property_groups
            return
        self._include_property_groups_validator.validate_type_only(val)
        self._include_property_groups_value = val
        self._include_property_groups_present = True

    @include_property_groups.deleter
    def include_property_groups(self):
        self._include_property_groups_value = None
        self._include_property_groups_present = False

    def __repr__(self):
        return 'ListFolderArg(path={!r}, recursive={!r}, include_media_info={!r}, include_deleted={!r}, include_has_explicit_shared_members={!r}, include_mounted_folders={!r}, limit={!r}, shared_link={!r}, include_property_groups={!r})'.format(
            self._path_value,
            self._recursive_value,
            self._include_media_info_value,
            self._include_deleted_value,
            self._include_has_explicit_shared_members_value,
            self._include_mounted_folders_value,
            self._limit_value,
            self._shared_link_value,
            self._include_property_groups_value,
        )

ListFolderArg_validator = bv.Struct(ListFolderArg)

class ListFolderContinueArg(object):
    """
    :ivar cursor: The cursor returned by your last call to
        :meth:`dropbox.dropbox.Dropbox.files_list_folder` or
        :meth:`dropbox.dropbox.Dropbox.files_list_folder_continue`.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 cursor=None):
        self._cursor_value = None
        self._cursor_present = False
        if cursor is not None:
            self.cursor = cursor

    @property
    def cursor(self):
        """
        The cursor returned by your last call to
        :meth:`dropbox.dropbox.Dropbox.files_list_folder` or
        :meth:`dropbox.dropbox.Dropbox.files_list_folder_continue`.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def __repr__(self):
        return 'ListFolderContinueArg(cursor={!r})'.format(
            self._cursor_value,
        )

ListFolderContinueArg_validator = bv.Struct(ListFolderContinueArg)

class ListFolderContinueError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar reset: Indicates that the cursor has been invalidated. Call
        :meth:`dropbox.dropbox.Dropbox.files_list_folder` to obtain a new
        cursor.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    reset = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: ListFolderContinueError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_reset(self):
        """
        Check if the union tag is ``reset``.

        :rtype: bool
        """
        return self._tag == 'reset'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'ListFolderContinueError(%r, %r)' % (self._tag, self._value)

ListFolderContinueError_validator = bv.Union(ListFolderContinueError)

class ListFolderError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: ListFolderError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'ListFolderError(%r, %r)' % (self._tag, self._value)

ListFolderError_validator = bv.Union(ListFolderError)

class ListFolderGetLatestCursorResult(object):
    """
    :ivar cursor: Pass the cursor into
        :meth:`dropbox.dropbox.Dropbox.files_list_folder_continue` to see what's
        changed in the folder since your previous query.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 cursor=None):
        self._cursor_value = None
        self._cursor_present = False
        if cursor is not None:
            self.cursor = cursor

    @property
    def cursor(self):
        """
        Pass the cursor into
        :meth:`dropbox.dropbox.Dropbox.files_list_folder_continue` to see what's
        changed in the folder since your previous query.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def __repr__(self):
        return 'ListFolderGetLatestCursorResult(cursor={!r})'.format(
            self._cursor_value,
        )

ListFolderGetLatestCursorResult_validator = bv.Struct(ListFolderGetLatestCursorResult)

class ListFolderLongpollArg(object):
    """
    :ivar cursor: A cursor as returned by
        :meth:`dropbox.dropbox.Dropbox.files_list_folder` or
        :meth:`dropbox.dropbox.Dropbox.files_list_folder_continue`. Cursors
        retrieved by setting ``ListFolderArg.include_media_info`` to ``True``
        are not supported.
    :ivar timeout: A timeout in seconds. The request will block for at most this
        length of time, plus up to 90 seconds of random jitter added to avoid
        the thundering herd problem. Care should be taken when using this
        parameter, as some network infrastructure does not support long
        timeouts.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
        '_timeout_value',
        '_timeout_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 cursor=None,
                 timeout=None):
        self._cursor_value = None
        self._cursor_present = False
        self._timeout_value = None
        self._timeout_present = False
        if cursor is not None:
            self.cursor = cursor
        if timeout is not None:
            self.timeout = timeout

    @property
    def cursor(self):
        """
        A cursor as returned by
        :meth:`dropbox.dropbox.Dropbox.files_list_folder` or
        :meth:`dropbox.dropbox.Dropbox.files_list_folder_continue`. Cursors
        retrieved by setting ``ListFolderArg.include_media_info`` to ``True``
        are not supported.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    @property
    def timeout(self):
        """
        A timeout in seconds. The request will block for at most this length of
        time, plus up to 90 seconds of random jitter added to avoid the
        thundering herd problem. Care should be taken when using this parameter,
        as some network infrastructure does not support long timeouts.

        :rtype: long
        """
        if self._timeout_present:
            return self._timeout_value
        else:
            return 30

    @timeout.setter
    def timeout(self, val):
        val = self._timeout_validator.validate(val)
        self._timeout_value = val
        self._timeout_present = True

    @timeout.deleter
    def timeout(self):
        self._timeout_value = None
        self._timeout_present = False

    def __repr__(self):
        return 'ListFolderLongpollArg(cursor={!r}, timeout={!r})'.format(
            self._cursor_value,
            self._timeout_value,
        )

ListFolderLongpollArg_validator = bv.Struct(ListFolderLongpollArg)

class ListFolderLongpollError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar reset: Indicates that the cursor has been invalidated. Call
        :meth:`dropbox.dropbox.Dropbox.files_list_folder` to obtain a new
        cursor.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    reset = None
    # Attribute is overwritten below the class definition
    other = None

    def is_reset(self):
        """
        Check if the union tag is ``reset``.

        :rtype: bool
        """
        return self._tag == 'reset'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'ListFolderLongpollError(%r, %r)' % (self._tag, self._value)

ListFolderLongpollError_validator = bv.Union(ListFolderLongpollError)

class ListFolderLongpollResult(object):
    """
    :ivar changes: Indicates whether new changes are available. If true, call
        :meth:`dropbox.dropbox.Dropbox.files_list_folder_continue` to retrieve
        the changes.
    :ivar backoff: If present, backoff for at least this many seconds before
        calling :meth:`dropbox.dropbox.Dropbox.files_list_folder_longpoll`
        again.
    """

    __slots__ = [
        '_changes_value',
        '_changes_present',
        '_backoff_value',
        '_backoff_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 changes=None,
                 backoff=None):
        self._changes_value = None
        self._changes_present = False
        self._backoff_value = None
        self._backoff_present = False
        if changes is not None:
            self.changes = changes
        if backoff is not None:
            self.backoff = backoff

    @property
    def changes(self):
        """
        Indicates whether new changes are available. If true, call
        :meth:`dropbox.dropbox.Dropbox.files_list_folder_continue` to retrieve
        the changes.

        :rtype: bool
        """
        if self._changes_present:
            return self._changes_value
        else:
            raise AttributeError("missing required field 'changes'")

    @changes.setter
    def changes(self, val):
        val = self._changes_validator.validate(val)
        self._changes_value = val
        self._changes_present = True

    @changes.deleter
    def changes(self):
        self._changes_value = None
        self._changes_present = False

    @property
    def backoff(self):
        """
        If present, backoff for at least this many seconds before calling
        :meth:`dropbox.dropbox.Dropbox.files_list_folder_longpoll` again.

        :rtype: long
        """
        if self._backoff_present:
            return self._backoff_value
        else:
            return None

    @backoff.setter
    def backoff(self, val):
        if val is None:
            del self.backoff
            return
        val = self._backoff_validator.validate(val)
        self._backoff_value = val
        self._backoff_present = True

    @backoff.deleter
    def backoff(self):
        self._backoff_value = None
        self._backoff_present = False

    def __repr__(self):
        return 'ListFolderLongpollResult(changes={!r}, backoff={!r})'.format(
            self._changes_value,
            self._backoff_value,
        )

ListFolderLongpollResult_validator = bv.Struct(ListFolderLongpollResult)

class ListFolderResult(object):
    """
    :ivar entries: The files and (direct) subfolders in the folder.
    :ivar cursor: Pass the cursor into
        :meth:`dropbox.dropbox.Dropbox.files_list_folder_continue` to see what's
        changed in the folder since your previous query.
    :ivar has_more: If true, then there are more entries available. Pass the
        cursor to :meth:`dropbox.dropbox.Dropbox.files_list_folder_continue` to
        retrieve the rest.
    """

    __slots__ = [
        '_entries_value',
        '_entries_present',
        '_cursor_value',
        '_cursor_present',
        '_has_more_value',
        '_has_more_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 entries=None,
                 cursor=None,
                 has_more=None):
        self._entries_value = None
        self._entries_present = False
        self._cursor_value = None
        self._cursor_present = False
        self._has_more_value = None
        self._has_more_present = False
        if entries is not None:
            self.entries = entries
        if cursor is not None:
            self.cursor = cursor
        if has_more is not None:
            self.has_more = has_more

    @property
    def entries(self):
        """
        The files and (direct) subfolders in the folder.

        :rtype: list of [Metadata]
        """
        if self._entries_present:
            return self._entries_value
        else:
            raise AttributeError("missing required field 'entries'")

    @entries.setter
    def entries(self, val):
        val = self._entries_validator.validate(val)
        self._entries_value = val
        self._entries_present = True

    @entries.deleter
    def entries(self):
        self._entries_value = None
        self._entries_present = False

    @property
    def cursor(self):
        """
        Pass the cursor into
        :meth:`dropbox.dropbox.Dropbox.files_list_folder_continue` to see what's
        changed in the folder since your previous query.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    @property
    def has_more(self):
        """
        If true, then there are more entries available. Pass the cursor to
        :meth:`dropbox.dropbox.Dropbox.files_list_folder_continue` to retrieve
        the rest.

        :rtype: bool
        """
        if self._has_more_present:
            return self._has_more_value
        else:
            raise AttributeError("missing required field 'has_more'")

    @has_more.setter
    def has_more(self, val):
        val = self._has_more_validator.validate(val)
        self._has_more_value = val
        self._has_more_present = True

    @has_more.deleter
    def has_more(self):
        self._has_more_value = None
        self._has_more_present = False

    def __repr__(self):
        return 'ListFolderResult(entries={!r}, cursor={!r}, has_more={!r})'.format(
            self._entries_value,
            self._cursor_value,
            self._has_more_value,
        )

ListFolderResult_validator = bv.Struct(ListFolderResult)

class ListRevisionsArg(object):
    """
    :ivar path: The path to the file you want to see the revisions of.
    :ivar mode: Determines the behavior of the API in listing the revisions for
        a given file path or id.
    :ivar limit: The maximum number of revision entries returned.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_mode_value',
        '_mode_present',
        '_limit_value',
        '_limit_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 mode=None,
                 limit=None):
        self._path_value = None
        self._path_present = False
        self._mode_value = None
        self._mode_present = False
        self._limit_value = None
        self._limit_present = False
        if path is not None:
            self.path = path
        if mode is not None:
            self.mode = mode
        if limit is not None:
            self.limit = limit

    @property
    def path(self):
        """
        The path to the file you want to see the revisions of.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def mode(self):
        """
        Determines the behavior of the API in listing the revisions for a given
        file path or id.

        :rtype: ListRevisionsMode
        """
        if self._mode_present:
            return self._mode_value
        else:
            return ListRevisionsMode.path

    @mode.setter
    def mode(self, val):
        self._mode_validator.validate_type_only(val)
        self._mode_value = val
        self._mode_present = True

    @mode.deleter
    def mode(self):
        self._mode_value = None
        self._mode_present = False

    @property
    def limit(self):
        """
        The maximum number of revision entries returned.

        :rtype: long
        """
        if self._limit_present:
            return self._limit_value
        else:
            return 10

    @limit.setter
    def limit(self, val):
        val = self._limit_validator.validate(val)
        self._limit_value = val
        self._limit_present = True

    @limit.deleter
    def limit(self):
        self._limit_value = None
        self._limit_present = False

    def __repr__(self):
        return 'ListRevisionsArg(path={!r}, mode={!r}, limit={!r})'.format(
            self._path_value,
            self._mode_value,
            self._limit_value,
        )

ListRevisionsArg_validator = bv.Struct(ListRevisionsArg)

class ListRevisionsError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: ListRevisionsError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'ListRevisionsError(%r, %r)' % (self._tag, self._value)

ListRevisionsError_validator = bv.Union(ListRevisionsError)

class ListRevisionsMode(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar path: Returns revisions with the same file path as identified by the
        latest file entry at the given file path or id.
    :ivar id: Returns revisions with the same file id as identified by the
        latest file entry at the given file path or id.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    path = None
    # Attribute is overwritten below the class definition
    id = None
    # Attribute is overwritten below the class definition
    other = None

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_id(self):
        """
        Check if the union tag is ``id``.

        :rtype: bool
        """
        return self._tag == 'id'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'ListRevisionsMode(%r, %r)' % (self._tag, self._value)

ListRevisionsMode_validator = bv.Union(ListRevisionsMode)

class ListRevisionsResult(object):
    """
    :ivar is_deleted: If the file identified by the latest revision in the
        response is either deleted or moved.
    :ivar server_deleted: The time of deletion if the file was deleted.
    :ivar entries: The revisions for the file. Only revisions that are not
        deleted will show up here.
    """

    __slots__ = [
        '_is_deleted_value',
        '_is_deleted_present',
        '_server_deleted_value',
        '_server_deleted_present',
        '_entries_value',
        '_entries_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 is_deleted=None,
                 entries=None,
                 server_deleted=None):
        self._is_deleted_value = None
        self._is_deleted_present = False
        self._server_deleted_value = None
        self._server_deleted_present = False
        self._entries_value = None
        self._entries_present = False
        if is_deleted is not None:
            self.is_deleted = is_deleted
        if server_deleted is not None:
            self.server_deleted = server_deleted
        if entries is not None:
            self.entries = entries

    @property
    def is_deleted(self):
        """
        If the file identified by the latest revision in the response is either
        deleted or moved.

        :rtype: bool
        """
        if self._is_deleted_present:
            return self._is_deleted_value
        else:
            raise AttributeError("missing required field 'is_deleted'")

    @is_deleted.setter
    def is_deleted(self, val):
        val = self._is_deleted_validator.validate(val)
        self._is_deleted_value = val
        self._is_deleted_present = True

    @is_deleted.deleter
    def is_deleted(self):
        self._is_deleted_value = None
        self._is_deleted_present = False

    @property
    def server_deleted(self):
        """
        The time of deletion if the file was deleted.

        :rtype: datetime.datetime
        """
        if self._server_deleted_present:
            return self._server_deleted_value
        else:
            return None

    @server_deleted.setter
    def server_deleted(self, val):
        if val is None:
            del self.server_deleted
            return
        val = self._server_deleted_validator.validate(val)
        self._server_deleted_value = val
        self._server_deleted_present = True

    @server_deleted.deleter
    def server_deleted(self):
        self._server_deleted_value = None
        self._server_deleted_present = False

    @property
    def entries(self):
        """
        The revisions for the file. Only revisions that are not deleted will
        show up here.

        :rtype: list of [FileMetadata]
        """
        if self._entries_present:
            return self._entries_value
        else:
            raise AttributeError("missing required field 'entries'")

    @entries.setter
    def entries(self, val):
        val = self._entries_validator.validate(val)
        self._entries_value = val
        self._entries_present = True

    @entries.deleter
    def entries(self):
        self._entries_value = None
        self._entries_present = False

    def __repr__(self):
        return 'ListRevisionsResult(is_deleted={!r}, entries={!r}, server_deleted={!r})'.format(
            self._is_deleted_value,
            self._entries_value,
            self._server_deleted_value,
        )

ListRevisionsResult_validator = bv.Struct(ListRevisionsResult)

class LookupError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar not_found: There is nothing at the given path.
    :ivar not_file: We were expecting a file, but the given path refers to
        something that isn't a file.
    :ivar not_folder: We were expecting a folder, but the given path refers to
        something that isn't a folder.
    :ivar restricted_content: The file cannot be transferred because the content
        is restricted.  For example, sometimes there are legal restrictions due
        to copyright claims.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    not_found = None
    # Attribute is overwritten below the class definition
    not_file = None
    # Attribute is overwritten below the class definition
    not_folder = None
    # Attribute is overwritten below the class definition
    restricted_content = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def malformed_path(cls, val):
        """
        Create an instance of this class set to the ``malformed_path`` tag with
        value ``val``.

        :param Optional[str] val:
        :rtype: LookupError
        """
        return cls('malformed_path', val)

    def is_malformed_path(self):
        """
        Check if the union tag is ``malformed_path``.

        :rtype: bool
        """
        return self._tag == 'malformed_path'

    def is_not_found(self):
        """
        Check if the union tag is ``not_found``.

        :rtype: bool
        """
        return self._tag == 'not_found'

    def is_not_file(self):
        """
        Check if the union tag is ``not_file``.

        :rtype: bool
        """
        return self._tag == 'not_file'

    def is_not_folder(self):
        """
        Check if the union tag is ``not_folder``.

        :rtype: bool
        """
        return self._tag == 'not_folder'

    def is_restricted_content(self):
        """
        Check if the union tag is ``restricted_content``.

        :rtype: bool
        """
        return self._tag == 'restricted_content'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_malformed_path(self):
        """
        Only call this if :meth:`is_malformed_path` is true.

        :rtype: Optional[str]
        """
        if not self.is_malformed_path():
            raise AttributeError("tag 'malformed_path' not set")
        return self._value

    def __repr__(self):
        return 'LookupError(%r, %r)' % (self._tag, self._value)

LookupError_validator = bv.Union(LookupError)

class MediaInfo(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar pending: Indicate the photo/video is still under processing and
        metadata is not available yet.
    :ivar MediaMetadata metadata: The metadata for the photo/video.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    pending = None

    @classmethod
    def metadata(cls, val):
        """
        Create an instance of this class set to the ``metadata`` tag with value
        ``val``.

        :param MediaMetadata val:
        :rtype: MediaInfo
        """
        return cls('metadata', val)

    def is_pending(self):
        """
        Check if the union tag is ``pending``.

        :rtype: bool
        """
        return self._tag == 'pending'

    def is_metadata(self):
        """
        Check if the union tag is ``metadata``.

        :rtype: bool
        """
        return self._tag == 'metadata'

    def get_metadata(self):
        """
        The metadata for the photo/video.

        Only call this if :meth:`is_metadata` is true.

        :rtype: MediaMetadata
        """
        if not self.is_metadata():
            raise AttributeError("tag 'metadata' not set")
        return self._value

    def __repr__(self):
        return 'MediaInfo(%r, %r)' % (self._tag, self._value)

MediaInfo_validator = bv.Union(MediaInfo)

class MediaMetadata(object):
    """
    Metadata for a photo or video.

    :ivar dimensions: Dimension of the photo/video.
    :ivar location: The GPS coordinate of the photo/video.
    :ivar time_taken: The timestamp when the photo/video is taken.
    """

    __slots__ = [
        '_dimensions_value',
        '_dimensions_present',
        '_location_value',
        '_location_present',
        '_time_taken_value',
        '_time_taken_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 dimensions=None,
                 location=None,
                 time_taken=None):
        self._dimensions_value = None
        self._dimensions_present = False
        self._location_value = None
        self._location_present = False
        self._time_taken_value = None
        self._time_taken_present = False
        if dimensions is not None:
            self.dimensions = dimensions
        if location is not None:
            self.location = location
        if time_taken is not None:
            self.time_taken = time_taken

    @property
    def dimensions(self):
        """
        Dimension of the photo/video.

        :rtype: Dimensions
        """
        if self._dimensions_present:
            return self._dimensions_value
        else:
            return None

    @dimensions.setter
    def dimensions(self, val):
        if val is None:
            del self.dimensions
            return
        self._dimensions_validator.validate_type_only(val)
        self._dimensions_value = val
        self._dimensions_present = True

    @dimensions.deleter
    def dimensions(self):
        self._dimensions_value = None
        self._dimensions_present = False

    @property
    def location(self):
        """
        The GPS coordinate of the photo/video.

        :rtype: GpsCoordinates
        """
        if self._location_present:
            return self._location_value
        else:
            return None

    @location.setter
    def location(self, val):
        if val is None:
            del self.location
            return
        self._location_validator.validate_type_only(val)
        self._location_value = val
        self._location_present = True

    @location.deleter
    def location(self):
        self._location_value = None
        self._location_present = False

    @property
    def time_taken(self):
        """
        The timestamp when the photo/video is taken.

        :rtype: datetime.datetime
        """
        if self._time_taken_present:
            return self._time_taken_value
        else:
            return None

    @time_taken.setter
    def time_taken(self, val):
        if val is None:
            del self.time_taken
            return
        val = self._time_taken_validator.validate(val)
        self._time_taken_value = val
        self._time_taken_present = True

    @time_taken.deleter
    def time_taken(self):
        self._time_taken_value = None
        self._time_taken_present = False

    def __repr__(self):
        return 'MediaMetadata(dimensions={!r}, location={!r}, time_taken={!r})'.format(
            self._dimensions_value,
            self._location_value,
            self._time_taken_value,
        )

MediaMetadata_validator = bv.StructTree(MediaMetadata)

class PhotoMetadata(MediaMetadata):
    """
    Metadata for a photo.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self,
                 dimensions=None,
                 location=None,
                 time_taken=None):
        super(PhotoMetadata, self).__init__(dimensions,
                                            location,
                                            time_taken)

    def __repr__(self):
        return 'PhotoMetadata(dimensions={!r}, location={!r}, time_taken={!r})'.format(
            self._dimensions_value,
            self._location_value,
            self._time_taken_value,
        )

PhotoMetadata_validator = bv.Struct(PhotoMetadata)

class PreviewArg(object):
    """
    :ivar path: The path of the file to preview.
    :ivar rev: Please specify revision in ``path`` instead.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_rev_value',
        '_rev_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 rev=None):
        self._path_value = None
        self._path_present = False
        self._rev_value = None
        self._rev_present = False
        if path is not None:
            self.path = path
        if rev is not None:
            self.rev = rev

    @property
    def path(self):
        """
        The path of the file to preview.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def rev(self):
        """
        Please specify revision in ``path`` instead.

        :rtype: str
        """
        if self._rev_present:
            return self._rev_value
        else:
            return None

    @rev.setter
    def rev(self, val):
        if val is None:
            del self.rev
            return
        val = self._rev_validator.validate(val)
        self._rev_value = val
        self._rev_present = True

    @rev.deleter
    def rev(self):
        self._rev_value = None
        self._rev_present = False

    def __repr__(self):
        return 'PreviewArg(path={!r}, rev={!r})'.format(
            self._path_value,
            self._rev_value,
        )

PreviewArg_validator = bv.Struct(PreviewArg)

class PreviewError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar LookupError path: An error occurs when downloading metadata for the
        file.
    :ivar in_progress: This preview generation is still in progress and the file
        is not ready  for preview yet.
    :ivar unsupported_extension: The file extension is not supported preview
        generation.
    :ivar unsupported_content: The file content is not supported for preview
        generation.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    in_progress = None
    # Attribute is overwritten below the class definition
    unsupported_extension = None
    # Attribute is overwritten below the class definition
    unsupported_content = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: PreviewError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_in_progress(self):
        """
        Check if the union tag is ``in_progress``.

        :rtype: bool
        """
        return self._tag == 'in_progress'

    def is_unsupported_extension(self):
        """
        Check if the union tag is ``unsupported_extension``.

        :rtype: bool
        """
        return self._tag == 'unsupported_extension'

    def is_unsupported_content(self):
        """
        Check if the union tag is ``unsupported_content``.

        :rtype: bool
        """
        return self._tag == 'unsupported_content'

    def get_path(self):
        """
        An error occurs when downloading metadata for the file.

        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'PreviewError(%r, %r)' % (self._tag, self._value)

PreviewError_validator = bv.Union(PreviewError)

class RelocationPath(object):
    """
    :ivar from_path: Path in the user's Dropbox to be copied or moved.
    :ivar to_path: Path in the user's Dropbox that is the destination.
    """

    __slots__ = [
        '_from_path_value',
        '_from_path_present',
        '_to_path_value',
        '_to_path_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 from_path=None,
                 to_path=None):
        self._from_path_value = None
        self._from_path_present = False
        self._to_path_value = None
        self._to_path_present = False
        if from_path is not None:
            self.from_path = from_path
        if to_path is not None:
            self.to_path = to_path

    @property
    def from_path(self):
        """
        Path in the user's Dropbox to be copied or moved.

        :rtype: str
        """
        if self._from_path_present:
            return self._from_path_value
        else:
            raise AttributeError("missing required field 'from_path'")

    @from_path.setter
    def from_path(self, val):
        val = self._from_path_validator.validate(val)
        self._from_path_value = val
        self._from_path_present = True

    @from_path.deleter
    def from_path(self):
        self._from_path_value = None
        self._from_path_present = False

    @property
    def to_path(self):
        """
        Path in the user's Dropbox that is the destination.

        :rtype: str
        """
        if self._to_path_present:
            return self._to_path_value
        else:
            raise AttributeError("missing required field 'to_path'")

    @to_path.setter
    def to_path(self, val):
        val = self._to_path_validator.validate(val)
        self._to_path_value = val
        self._to_path_present = True

    @to_path.deleter
    def to_path(self):
        self._to_path_value = None
        self._to_path_present = False

    def __repr__(self):
        return 'RelocationPath(from_path={!r}, to_path={!r})'.format(
            self._from_path_value,
            self._to_path_value,
        )

RelocationPath_validator = bv.Struct(RelocationPath)

class RelocationArg(RelocationPath):
    """
    :ivar allow_shared_folder: If true,
        :meth:`dropbox.dropbox.Dropbox.files_copy` will copy contents in shared
        folder, otherwise ``RelocationError.cant_copy_shared_folder`` will be
        returned if ``from_path`` contains shared folder. This field is always
        true for :meth:`dropbox.dropbox.Dropbox.files_move`.
    :ivar autorename: If there's a conflict, have the Dropbox server try to
        autorename the file to avoid the conflict.
    :ivar allow_ownership_transfer: Allow moves by owner even if it would result
        in an ownership transfer for the content being moved. This does not
        apply to copies.
    """

    __slots__ = [
        '_allow_shared_folder_value',
        '_allow_shared_folder_present',
        '_autorename_value',
        '_autorename_present',
        '_allow_ownership_transfer_value',
        '_allow_ownership_transfer_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 from_path=None,
                 to_path=None,
                 allow_shared_folder=None,
                 autorename=None,
                 allow_ownership_transfer=None):
        super(RelocationArg, self).__init__(from_path,
                                            to_path)
        self._allow_shared_folder_value = None
        self._allow_shared_folder_present = False
        self._autorename_value = None
        self._autorename_present = False
        self._allow_ownership_transfer_value = None
        self._allow_ownership_transfer_present = False
        if allow_shared_folder is not None:
            self.allow_shared_folder = allow_shared_folder
        if autorename is not None:
            self.autorename = autorename
        if allow_ownership_transfer is not None:
            self.allow_ownership_transfer = allow_ownership_transfer

    @property
    def allow_shared_folder(self):
        """
        If true, :meth:`dropbox.dropbox.Dropbox.files_copy` will copy contents
        in shared folder, otherwise ``RelocationError.cant_copy_shared_folder``
        will be returned if ``from_path`` contains shared folder. This field is
        always true for :meth:`dropbox.dropbox.Dropbox.files_move`.

        :rtype: bool
        """
        if self._allow_shared_folder_present:
            return self._allow_shared_folder_value
        else:
            return False

    @allow_shared_folder.setter
    def allow_shared_folder(self, val):
        val = self._allow_shared_folder_validator.validate(val)
        self._allow_shared_folder_value = val
        self._allow_shared_folder_present = True

    @allow_shared_folder.deleter
    def allow_shared_folder(self):
        self._allow_shared_folder_value = None
        self._allow_shared_folder_present = False

    @property
    def autorename(self):
        """
        If there's a conflict, have the Dropbox server try to autorename the
        file to avoid the conflict.

        :rtype: bool
        """
        if self._autorename_present:
            return self._autorename_value
        else:
            return False

    @autorename.setter
    def autorename(self, val):
        val = self._autorename_validator.validate(val)
        self._autorename_value = val
        self._autorename_present = True

    @autorename.deleter
    def autorename(self):
        self._autorename_value = None
        self._autorename_present = False

    @property
    def allow_ownership_transfer(self):
        """
        Allow moves by owner even if it would result in an ownership transfer
        for the content being moved. This does not apply to copies.

        :rtype: bool
        """
        if self._allow_ownership_transfer_present:
            return self._allow_ownership_transfer_value
        else:
            return False

    @allow_ownership_transfer.setter
    def allow_ownership_transfer(self, val):
        val = self._allow_ownership_transfer_validator.validate(val)
        self._allow_ownership_transfer_value = val
        self._allow_ownership_transfer_present = True

    @allow_ownership_transfer.deleter
    def allow_ownership_transfer(self):
        self._allow_ownership_transfer_value = None
        self._allow_ownership_transfer_present = False

    def __repr__(self):
        return 'RelocationArg(from_path={!r}, to_path={!r}, allow_shared_folder={!r}, autorename={!r}, allow_ownership_transfer={!r})'.format(
            self._from_path_value,
            self._to_path_value,
            self._allow_shared_folder_value,
            self._autorename_value,
            self._allow_ownership_transfer_value,
        )

RelocationArg_validator = bv.Struct(RelocationArg)

class RelocationBatchArg(object):
    """
    :ivar entries: List of entries to be moved or copied. Each entry is
        :class:`RelocationPath`.
    :ivar allow_shared_folder: If true,
        :meth:`dropbox.dropbox.Dropbox.files_copy_batch` will copy contents in
        shared folder, otherwise ``RelocationError.cant_copy_shared_folder``
        will be returned if ``RelocationPath.from_path`` contains shared folder.
        This field is always true for
        :meth:`dropbox.dropbox.Dropbox.files_move_batch`.
    :ivar autorename: If there's a conflict with any file, have the Dropbox
        server try to autorename that file to avoid the conflict.
    :ivar allow_ownership_transfer: Allow moves by owner even if it would result
        in an ownership transfer for the content being moved. This does not
        apply to copies.
    """

    __slots__ = [
        '_entries_value',
        '_entries_present',
        '_allow_shared_folder_value',
        '_allow_shared_folder_present',
        '_autorename_value',
        '_autorename_present',
        '_allow_ownership_transfer_value',
        '_allow_ownership_transfer_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 entries=None,
                 allow_shared_folder=None,
                 autorename=None,
                 allow_ownership_transfer=None):
        self._entries_value = None
        self._entries_present = False
        self._allow_shared_folder_value = None
        self._allow_shared_folder_present = False
        self._autorename_value = None
        self._autorename_present = False
        self._allow_ownership_transfer_value = None
        self._allow_ownership_transfer_present = False
        if entries is not None:
            self.entries = entries
        if allow_shared_folder is not None:
            self.allow_shared_folder = allow_shared_folder
        if autorename is not None:
            self.autorename = autorename
        if allow_ownership_transfer is not None:
            self.allow_ownership_transfer = allow_ownership_transfer

    @property
    def entries(self):
        """
        List of entries to be moved or copied. Each entry is
        :class:`RelocationPath`.

        :rtype: list of [RelocationPath]
        """
        if self._entries_present:
            return self._entries_value
        else:
            raise AttributeError("missing required field 'entries'")

    @entries.setter
    def entries(self, val):
        val = self._entries_validator.validate(val)
        self._entries_value = val
        self._entries_present = True

    @entries.deleter
    def entries(self):
        self._entries_value = None
        self._entries_present = False

    @property
    def allow_shared_folder(self):
        """
        If true, :meth:`dropbox.dropbox.Dropbox.files_copy_batch` will copy
        contents in shared folder, otherwise
        ``RelocationError.cant_copy_shared_folder`` will be returned if
        ``RelocationPath.from_path`` contains shared folder.  This field is
        always true for :meth:`dropbox.dropbox.Dropbox.files_move_batch`.

        :rtype: bool
        """
        if self._allow_shared_folder_present:
            return self._allow_shared_folder_value
        else:
            return False

    @allow_shared_folder.setter
    def allow_shared_folder(self, val):
        val = self._allow_shared_folder_validator.validate(val)
        self._allow_shared_folder_value = val
        self._allow_shared_folder_present = True

    @allow_shared_folder.deleter
    def allow_shared_folder(self):
        self._allow_shared_folder_value = None
        self._allow_shared_folder_present = False

    @property
    def autorename(self):
        """
        If there's a conflict with any file, have the Dropbox server try to
        autorename that file to avoid the conflict.

        :rtype: bool
        """
        if self._autorename_present:
            return self._autorename_value
        else:
            return False

    @autorename.setter
    def autorename(self, val):
        val = self._autorename_validator.validate(val)
        self._autorename_value = val
        self._autorename_present = True

    @autorename.deleter
    def autorename(self):
        self._autorename_value = None
        self._autorename_present = False

    @property
    def allow_ownership_transfer(self):
        """
        Allow moves by owner even if it would result in an ownership transfer
        for the content being moved. This does not apply to copies.

        :rtype: bool
        """
        if self._allow_ownership_transfer_present:
            return self._allow_ownership_transfer_value
        else:
            return False

    @allow_ownership_transfer.setter
    def allow_ownership_transfer(self, val):
        val = self._allow_ownership_transfer_validator.validate(val)
        self._allow_ownership_transfer_value = val
        self._allow_ownership_transfer_present = True

    @allow_ownership_transfer.deleter
    def allow_ownership_transfer(self):
        self._allow_ownership_transfer_value = None
        self._allow_ownership_transfer_present = False

    def __repr__(self):
        return 'RelocationBatchArg(entries={!r}, allow_shared_folder={!r}, autorename={!r}, allow_ownership_transfer={!r})'.format(
            self._entries_value,
            self._allow_shared_folder_value,
            self._autorename_value,
            self._allow_ownership_transfer_value,
        )

RelocationBatchArg_validator = bv.Struct(RelocationBatchArg)

class RelocationError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar cant_copy_shared_folder: Shared folders can't be copied.
    :ivar cant_nest_shared_folder: Your move operation would result in nested
        shared folders.  This is not allowed.
    :ivar cant_move_folder_into_itself: You cannot move a folder into itself.
    :ivar too_many_files: The operation would involve more than 10,000 files and
        folders.
    :ivar duplicated_or_nested_paths: There are duplicated/nested paths among
        ``RelocationArg.from_path`` and ``RelocationArg.to_path``.
    :ivar cant_transfer_ownership: Your move operation would result in an
        ownership transfer. You may reissue the request with the field
        ``RelocationArg.allow_ownership_transfer`` to true.
    :ivar insufficient_quota: The current user does not have enough space to
        move or copy the files.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    cant_copy_shared_folder = None
    # Attribute is overwritten below the class definition
    cant_nest_shared_folder = None
    # Attribute is overwritten below the class definition
    cant_move_folder_into_itself = None
    # Attribute is overwritten below the class definition
    too_many_files = None
    # Attribute is overwritten below the class definition
    duplicated_or_nested_paths = None
    # Attribute is overwritten below the class definition
    cant_transfer_ownership = None
    # Attribute is overwritten below the class definition
    insufficient_quota = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def from_lookup(cls, val):
        """
        Create an instance of this class set to the ``from_lookup`` tag with
        value ``val``.

        :param LookupError val:
        :rtype: RelocationError
        """
        return cls('from_lookup', val)

    @classmethod
    def from_write(cls, val):
        """
        Create an instance of this class set to the ``from_write`` tag with
        value ``val``.

        :param WriteError val:
        :rtype: RelocationError
        """
        return cls('from_write', val)

    @classmethod
    def to(cls, val):
        """
        Create an instance of this class set to the ``to`` tag with value
        ``val``.

        :param WriteError val:
        :rtype: RelocationError
        """
        return cls('to', val)

    def is_from_lookup(self):
        """
        Check if the union tag is ``from_lookup``.

        :rtype: bool
        """
        return self._tag == 'from_lookup'

    def is_from_write(self):
        """
        Check if the union tag is ``from_write``.

        :rtype: bool
        """
        return self._tag == 'from_write'

    def is_to(self):
        """
        Check if the union tag is ``to``.

        :rtype: bool
        """
        return self._tag == 'to'

    def is_cant_copy_shared_folder(self):
        """
        Check if the union tag is ``cant_copy_shared_folder``.

        :rtype: bool
        """
        return self._tag == 'cant_copy_shared_folder'

    def is_cant_nest_shared_folder(self):
        """
        Check if the union tag is ``cant_nest_shared_folder``.

        :rtype: bool
        """
        return self._tag == 'cant_nest_shared_folder'

    def is_cant_move_folder_into_itself(self):
        """
        Check if the union tag is ``cant_move_folder_into_itself``.

        :rtype: bool
        """
        return self._tag == 'cant_move_folder_into_itself'

    def is_too_many_files(self):
        """
        Check if the union tag is ``too_many_files``.

        :rtype: bool
        """
        return self._tag == 'too_many_files'

    def is_duplicated_or_nested_paths(self):
        """
        Check if the union tag is ``duplicated_or_nested_paths``.

        :rtype: bool
        """
        return self._tag == 'duplicated_or_nested_paths'

    def is_cant_transfer_ownership(self):
        """
        Check if the union tag is ``cant_transfer_ownership``.

        :rtype: bool
        """
        return self._tag == 'cant_transfer_ownership'

    def is_insufficient_quota(self):
        """
        Check if the union tag is ``insufficient_quota``.

        :rtype: bool
        """
        return self._tag == 'insufficient_quota'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_from_lookup(self):
        """
        Only call this if :meth:`is_from_lookup` is true.

        :rtype: LookupError
        """
        if not self.is_from_lookup():
            raise AttributeError("tag 'from_lookup' not set")
        return self._value

    def get_from_write(self):
        """
        Only call this if :meth:`is_from_write` is true.

        :rtype: WriteError
        """
        if not self.is_from_write():
            raise AttributeError("tag 'from_write' not set")
        return self._value

    def get_to(self):
        """
        Only call this if :meth:`is_to` is true.

        :rtype: WriteError
        """
        if not self.is_to():
            raise AttributeError("tag 'to' not set")
        return self._value

    def __repr__(self):
        return 'RelocationError(%r, %r)' % (self._tag, self._value)

RelocationError_validator = bv.Union(RelocationError)

class RelocationBatchError(RelocationError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar too_many_write_operations: There are too many write operations in
        user's Dropbox. Please retry this request.
    """

    # Attribute is overwritten below the class definition
    too_many_write_operations = None

    def is_too_many_write_operations(self):
        """
        Check if the union tag is ``too_many_write_operations``.

        :rtype: bool
        """
        return self._tag == 'too_many_write_operations'

    def __repr__(self):
        return 'RelocationBatchError(%r, %r)' % (self._tag, self._value)

RelocationBatchError_validator = bv.Union(RelocationBatchError)

class RelocationBatchJobStatus(async_.PollResultBase):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar RelocationBatchResult complete: The copy or move batch job has
        finished.
    :ivar RelocationBatchError failed: The copy or move batch job has failed
        with exception.
    """

    @classmethod
    def complete(cls, val):
        """
        Create an instance of this class set to the ``complete`` tag with value
        ``val``.

        :param RelocationBatchResult val:
        :rtype: RelocationBatchJobStatus
        """
        return cls('complete', val)

    @classmethod
    def failed(cls, val):
        """
        Create an instance of this class set to the ``failed`` tag with value
        ``val``.

        :param RelocationBatchError val:
        :rtype: RelocationBatchJobStatus
        """
        return cls('failed', val)

    def is_complete(self):
        """
        Check if the union tag is ``complete``.

        :rtype: bool
        """
        return self._tag == 'complete'

    def is_failed(self):
        """
        Check if the union tag is ``failed``.

        :rtype: bool
        """
        return self._tag == 'failed'

    def get_complete(self):
        """
        The copy or move batch job has finished.

        Only call this if :meth:`is_complete` is true.

        :rtype: RelocationBatchResult
        """
        if not self.is_complete():
            raise AttributeError("tag 'complete' not set")
        return self._value

    def get_failed(self):
        """
        The copy or move batch job has failed with exception.

        Only call this if :meth:`is_failed` is true.

        :rtype: RelocationBatchError
        """
        if not self.is_failed():
            raise AttributeError("tag 'failed' not set")
        return self._value

    def __repr__(self):
        return 'RelocationBatchJobStatus(%r, %r)' % (self._tag, self._value)

RelocationBatchJobStatus_validator = bv.Union(RelocationBatchJobStatus)

class RelocationBatchLaunch(async_.LaunchResultBase):
    """
    Result returned by :meth:`dropbox.dropbox.Dropbox.files_copy_batch` or
    :meth:`dropbox.dropbox.Dropbox.files_move_batch` that may either launch an
    asynchronous job or complete synchronously.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def complete(cls, val):
        """
        Create an instance of this class set to the ``complete`` tag with value
        ``val``.

        :param RelocationBatchResult val:
        :rtype: RelocationBatchLaunch
        """
        return cls('complete', val)

    def is_complete(self):
        """
        Check if the union tag is ``complete``.

        :rtype: bool
        """
        return self._tag == 'complete'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_complete(self):
        """
        Only call this if :meth:`is_complete` is true.

        :rtype: RelocationBatchResult
        """
        if not self.is_complete():
            raise AttributeError("tag 'complete' not set")
        return self._value

    def __repr__(self):
        return 'RelocationBatchLaunch(%r, %r)' % (self._tag, self._value)

RelocationBatchLaunch_validator = bv.Union(RelocationBatchLaunch)

class RelocationBatchResult(FileOpsResult):

    __slots__ = [
        '_entries_value',
        '_entries_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 entries=None):
        super(RelocationBatchResult, self).__init__()
        self._entries_value = None
        self._entries_present = False
        if entries is not None:
            self.entries = entries

    @property
    def entries(self):
        """
        :rtype: list of [RelocationBatchResultData]
        """
        if self._entries_present:
            return self._entries_value
        else:
            raise AttributeError("missing required field 'entries'")

    @entries.setter
    def entries(self, val):
        val = self._entries_validator.validate(val)
        self._entries_value = val
        self._entries_present = True

    @entries.deleter
    def entries(self):
        self._entries_value = None
        self._entries_present = False

    def __repr__(self):
        return 'RelocationBatchResult(entries={!r})'.format(
            self._entries_value,
        )

RelocationBatchResult_validator = bv.Struct(RelocationBatchResult)

class RelocationBatchResultData(object):
    """
    :ivar metadata: Metadata of the relocated object.
    """

    __slots__ = [
        '_metadata_value',
        '_metadata_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 metadata=None):
        self._metadata_value = None
        self._metadata_present = False
        if metadata is not None:
            self.metadata = metadata

    @property
    def metadata(self):
        """
        Metadata of the relocated object.

        :rtype: Metadata
        """
        if self._metadata_present:
            return self._metadata_value
        else:
            raise AttributeError("missing required field 'metadata'")

    @metadata.setter
    def metadata(self, val):
        self._metadata_validator.validate_type_only(val)
        self._metadata_value = val
        self._metadata_present = True

    @metadata.deleter
    def metadata(self):
        self._metadata_value = None
        self._metadata_present = False

    def __repr__(self):
        return 'RelocationBatchResultData(metadata={!r})'.format(
            self._metadata_value,
        )

RelocationBatchResultData_validator = bv.Struct(RelocationBatchResultData)

class RelocationResult(FileOpsResult):
    """
    :ivar metadata: Metadata of the relocated object.
    """

    __slots__ = [
        '_metadata_value',
        '_metadata_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 metadata=None):
        super(RelocationResult, self).__init__()
        self._metadata_value = None
        self._metadata_present = False
        if metadata is not None:
            self.metadata = metadata

    @property
    def metadata(self):
        """
        Metadata of the relocated object.

        :rtype: Metadata
        """
        if self._metadata_present:
            return self._metadata_value
        else:
            raise AttributeError("missing required field 'metadata'")

    @metadata.setter
    def metadata(self, val):
        self._metadata_validator.validate_type_only(val)
        self._metadata_value = val
        self._metadata_present = True

    @metadata.deleter
    def metadata(self):
        self._metadata_value = None
        self._metadata_present = False

    def __repr__(self):
        return 'RelocationResult(metadata={!r})'.format(
            self._metadata_value,
        )

RelocationResult_validator = bv.Struct(RelocationResult)

class RestoreArg(object):
    """
    :ivar path: The path to the file you want to restore.
    :ivar rev: The revision to restore for the file.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_rev_value',
        '_rev_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 rev=None):
        self._path_value = None
        self._path_present = False
        self._rev_value = None
        self._rev_present = False
        if path is not None:
            self.path = path
        if rev is not None:
            self.rev = rev

    @property
    def path(self):
        """
        The path to the file you want to restore.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def rev(self):
        """
        The revision to restore for the file.

        :rtype: str
        """
        if self._rev_present:
            return self._rev_value
        else:
            raise AttributeError("missing required field 'rev'")

    @rev.setter
    def rev(self, val):
        val = self._rev_validator.validate(val)
        self._rev_value = val
        self._rev_present = True

    @rev.deleter
    def rev(self):
        self._rev_value = None
        self._rev_present = False

    def __repr__(self):
        return 'RestoreArg(path={!r}, rev={!r})'.format(
            self._path_value,
            self._rev_value,
        )

RestoreArg_validator = bv.Struct(RestoreArg)

class RestoreError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar LookupError path_lookup: An error occurs when downloading metadata for
        the file.
    :ivar WriteError path_write: An error occurs when trying to restore the file
        to that path.
    :ivar invalid_revision: The revision is invalid. It may point to a different
        file.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    invalid_revision = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path_lookup(cls, val):
        """
        Create an instance of this class set to the ``path_lookup`` tag with
        value ``val``.

        :param LookupError val:
        :rtype: RestoreError
        """
        return cls('path_lookup', val)

    @classmethod
    def path_write(cls, val):
        """
        Create an instance of this class set to the ``path_write`` tag with
        value ``val``.

        :param WriteError val:
        :rtype: RestoreError
        """
        return cls('path_write', val)

    def is_path_lookup(self):
        """
        Check if the union tag is ``path_lookup``.

        :rtype: bool
        """
        return self._tag == 'path_lookup'

    def is_path_write(self):
        """
        Check if the union tag is ``path_write``.

        :rtype: bool
        """
        return self._tag == 'path_write'

    def is_invalid_revision(self):
        """
        Check if the union tag is ``invalid_revision``.

        :rtype: bool
        """
        return self._tag == 'invalid_revision'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path_lookup(self):
        """
        An error occurs when downloading metadata for the file.

        Only call this if :meth:`is_path_lookup` is true.

        :rtype: LookupError
        """
        if not self.is_path_lookup():
            raise AttributeError("tag 'path_lookup' not set")
        return self._value

    def get_path_write(self):
        """
        An error occurs when trying to restore the file to that path.

        Only call this if :meth:`is_path_write` is true.

        :rtype: WriteError
        """
        if not self.is_path_write():
            raise AttributeError("tag 'path_write' not set")
        return self._value

    def __repr__(self):
        return 'RestoreError(%r, %r)' % (self._tag, self._value)

RestoreError_validator = bv.Union(RestoreError)

class SaveCopyReferenceArg(object):
    """
    :ivar copy_reference: A copy reference returned by
        :meth:`dropbox.dropbox.Dropbox.files_copy_reference_get`.
    :ivar path: Path in the user's Dropbox that is the destination.
    """

    __slots__ = [
        '_copy_reference_value',
        '_copy_reference_present',
        '_path_value',
        '_path_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 copy_reference=None,
                 path=None):
        self._copy_reference_value = None
        self._copy_reference_present = False
        self._path_value = None
        self._path_present = False
        if copy_reference is not None:
            self.copy_reference = copy_reference
        if path is not None:
            self.path = path

    @property
    def copy_reference(self):
        """
        A copy reference returned by
        :meth:`dropbox.dropbox.Dropbox.files_copy_reference_get`.

        :rtype: str
        """
        if self._copy_reference_present:
            return self._copy_reference_value
        else:
            raise AttributeError("missing required field 'copy_reference'")

    @copy_reference.setter
    def copy_reference(self, val):
        val = self._copy_reference_validator.validate(val)
        self._copy_reference_value = val
        self._copy_reference_present = True

    @copy_reference.deleter
    def copy_reference(self):
        self._copy_reference_value = None
        self._copy_reference_present = False

    @property
    def path(self):
        """
        Path in the user's Dropbox that is the destination.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    def __repr__(self):
        return 'SaveCopyReferenceArg(copy_reference={!r}, path={!r})'.format(
            self._copy_reference_value,
            self._path_value,
        )

SaveCopyReferenceArg_validator = bv.Struct(SaveCopyReferenceArg)

class SaveCopyReferenceError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar invalid_copy_reference: The copy reference is invalid.
    :ivar no_permission: You don't have permission to save the given copy
        reference. Please make sure this app is same app which created the copy
        reference and the source user is still linked to the app.
    :ivar not_found: The file referenced by the copy reference cannot be found.
    :ivar too_many_files: The operation would involve more than 10,000 files and
        folders.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    invalid_copy_reference = None
    # Attribute is overwritten below the class definition
    no_permission = None
    # Attribute is overwritten below the class definition
    not_found = None
    # Attribute is overwritten below the class definition
    too_many_files = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param WriteError val:
        :rtype: SaveCopyReferenceError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_invalid_copy_reference(self):
        """
        Check if the union tag is ``invalid_copy_reference``.

        :rtype: bool
        """
        return self._tag == 'invalid_copy_reference'

    def is_no_permission(self):
        """
        Check if the union tag is ``no_permission``.

        :rtype: bool
        """
        return self._tag == 'no_permission'

    def is_not_found(self):
        """
        Check if the union tag is ``not_found``.

        :rtype: bool
        """
        return self._tag == 'not_found'

    def is_too_many_files(self):
        """
        Check if the union tag is ``too_many_files``.

        :rtype: bool
        """
        return self._tag == 'too_many_files'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: WriteError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'SaveCopyReferenceError(%r, %r)' % (self._tag, self._value)

SaveCopyReferenceError_validator = bv.Union(SaveCopyReferenceError)

class SaveCopyReferenceResult(object):
    """
    :ivar metadata: The metadata of the saved file or folder in the user's
        Dropbox.
    """

    __slots__ = [
        '_metadata_value',
        '_metadata_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 metadata=None):
        self._metadata_value = None
        self._metadata_present = False
        if metadata is not None:
            self.metadata = metadata

    @property
    def metadata(self):
        """
        The metadata of the saved file or folder in the user's Dropbox.

        :rtype: Metadata
        """
        if self._metadata_present:
            return self._metadata_value
        else:
            raise AttributeError("missing required field 'metadata'")

    @metadata.setter
    def metadata(self, val):
        self._metadata_validator.validate_type_only(val)
        self._metadata_value = val
        self._metadata_present = True

    @metadata.deleter
    def metadata(self):
        self._metadata_value = None
        self._metadata_present = False

    def __repr__(self):
        return 'SaveCopyReferenceResult(metadata={!r})'.format(
            self._metadata_value,
        )

SaveCopyReferenceResult_validator = bv.Struct(SaveCopyReferenceResult)

class SaveUrlArg(object):
    """
    :ivar path: The path in Dropbox where the URL will be saved to.
    :ivar url: The URL to be saved.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_url_value',
        '_url_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 url=None):
        self._path_value = None
        self._path_present = False
        self._url_value = None
        self._url_present = False
        if path is not None:
            self.path = path
        if url is not None:
            self.url = url

    @property
    def path(self):
        """
        The path in Dropbox where the URL will be saved to.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def url(self):
        """
        The URL to be saved.

        :rtype: str
        """
        if self._url_present:
            return self._url_value
        else:
            raise AttributeError("missing required field 'url'")

    @url.setter
    def url(self, val):
        val = self._url_validator.validate(val)
        self._url_value = val
        self._url_present = True

    @url.deleter
    def url(self):
        self._url_value = None
        self._url_present = False

    def __repr__(self):
        return 'SaveUrlArg(path={!r}, url={!r})'.format(
            self._path_value,
            self._url_value,
        )

SaveUrlArg_validator = bv.Struct(SaveUrlArg)

class SaveUrlError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar download_failed: Failed downloading the given URL.
    :ivar invalid_url: The given URL is invalid.
    :ivar not_found: The file where the URL is saved to no longer exists.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    download_failed = None
    # Attribute is overwritten below the class definition
    invalid_url = None
    # Attribute is overwritten below the class definition
    not_found = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param WriteError val:
        :rtype: SaveUrlError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_download_failed(self):
        """
        Check if the union tag is ``download_failed``.

        :rtype: bool
        """
        return self._tag == 'download_failed'

    def is_invalid_url(self):
        """
        Check if the union tag is ``invalid_url``.

        :rtype: bool
        """
        return self._tag == 'invalid_url'

    def is_not_found(self):
        """
        Check if the union tag is ``not_found``.

        :rtype: bool
        """
        return self._tag == 'not_found'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: WriteError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'SaveUrlError(%r, %r)' % (self._tag, self._value)

SaveUrlError_validator = bv.Union(SaveUrlError)

class SaveUrlJobStatus(async_.PollResultBase):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar FileMetadata complete: Metadata of the file where the URL is saved to.
    """

    @classmethod
    def complete(cls, val):
        """
        Create an instance of this class set to the ``complete`` tag with value
        ``val``.

        :param FileMetadata val:
        :rtype: SaveUrlJobStatus
        """
        return cls('complete', val)

    @classmethod
    def failed(cls, val):
        """
        Create an instance of this class set to the ``failed`` tag with value
        ``val``.

        :param SaveUrlError val:
        :rtype: SaveUrlJobStatus
        """
        return cls('failed', val)

    def is_complete(self):
        """
        Check if the union tag is ``complete``.

        :rtype: bool
        """
        return self._tag == 'complete'

    def is_failed(self):
        """
        Check if the union tag is ``failed``.

        :rtype: bool
        """
        return self._tag == 'failed'

    def get_complete(self):
        """
        Metadata of the file where the URL is saved to.

        Only call this if :meth:`is_complete` is true.

        :rtype: FileMetadata
        """
        if not self.is_complete():
            raise AttributeError("tag 'complete' not set")
        return self._value

    def get_failed(self):
        """
        Only call this if :meth:`is_failed` is true.

        :rtype: SaveUrlError
        """
        if not self.is_failed():
            raise AttributeError("tag 'failed' not set")
        return self._value

    def __repr__(self):
        return 'SaveUrlJobStatus(%r, %r)' % (self._tag, self._value)

SaveUrlJobStatus_validator = bv.Union(SaveUrlJobStatus)

class SaveUrlResult(async_.LaunchResultBase):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar FileMetadata complete: Metadata of the file where the URL is saved to.
    """

    @classmethod
    def complete(cls, val):
        """
        Create an instance of this class set to the ``complete`` tag with value
        ``val``.

        :param FileMetadata val:
        :rtype: SaveUrlResult
        """
        return cls('complete', val)

    def is_complete(self):
        """
        Check if the union tag is ``complete``.

        :rtype: bool
        """
        return self._tag == 'complete'

    def get_complete(self):
        """
        Metadata of the file where the URL is saved to.

        Only call this if :meth:`is_complete` is true.

        :rtype: FileMetadata
        """
        if not self.is_complete():
            raise AttributeError("tag 'complete' not set")
        return self._value

    def __repr__(self):
        return 'SaveUrlResult(%r, %r)' % (self._tag, self._value)

SaveUrlResult_validator = bv.Union(SaveUrlResult)

class SearchArg(object):
    """
    :ivar path: The path in the user's Dropbox to search. Should probably be a
        folder.
    :ivar query: The string to search for. The search string is split on spaces
        into multiple tokens. For file name searching, the last token is used
        for prefix matching (i.e. "bat c" matches "bat cave" but not "batman
        car").
    :ivar start: The starting index within the search results (used for paging).
    :ivar max_results: The maximum number of search results to return.
    :ivar mode: The search mode (filename, filename_and_content, or
        deleted_filename). Note that searching file content is only available
        for Dropbox Business accounts.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_query_value',
        '_query_present',
        '_start_value',
        '_start_present',
        '_max_results_value',
        '_max_results_present',
        '_mode_value',
        '_mode_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 query=None,
                 start=None,
                 max_results=None,
                 mode=None):
        self._path_value = None
        self._path_present = False
        self._query_value = None
        self._query_present = False
        self._start_value = None
        self._start_present = False
        self._max_results_value = None
        self._max_results_present = False
        self._mode_value = None
        self._mode_present = False
        if path is not None:
            self.path = path
        if query is not None:
            self.query = query
        if start is not None:
            self.start = start
        if max_results is not None:
            self.max_results = max_results
        if mode is not None:
            self.mode = mode

    @property
    def path(self):
        """
        The path in the user's Dropbox to search. Should probably be a folder.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def query(self):
        """
        The string to search for. The search string is split on spaces into
        multiple tokens. For file name searching, the last token is used for
        prefix matching (i.e. "bat c" matches "bat cave" but not "batman car").

        :rtype: str
        """
        if self._query_present:
            return self._query_value
        else:
            raise AttributeError("missing required field 'query'")

    @query.setter
    def query(self, val):
        val = self._query_validator.validate(val)
        self._query_value = val
        self._query_present = True

    @query.deleter
    def query(self):
        self._query_value = None
        self._query_present = False

    @property
    def start(self):
        """
        The starting index within the search results (used for paging).

        :rtype: long
        """
        if self._start_present:
            return self._start_value
        else:
            return 0

    @start.setter
    def start(self, val):
        val = self._start_validator.validate(val)
        self._start_value = val
        self._start_present = True

    @start.deleter
    def start(self):
        self._start_value = None
        self._start_present = False

    @property
    def max_results(self):
        """
        The maximum number of search results to return.

        :rtype: long
        """
        if self._max_results_present:
            return self._max_results_value
        else:
            return 100

    @max_results.setter
    def max_results(self, val):
        val = self._max_results_validator.validate(val)
        self._max_results_value = val
        self._max_results_present = True

    @max_results.deleter
    def max_results(self):
        self._max_results_value = None
        self._max_results_present = False

    @property
    def mode(self):
        """
        The search mode (filename, filename_and_content, or deleted_filename).
        Note that searching file content is only available for Dropbox Business
        accounts.

        :rtype: SearchMode
        """
        if self._mode_present:
            return self._mode_value
        else:
            return SearchMode.filename

    @mode.setter
    def mode(self, val):
        self._mode_validator.validate_type_only(val)
        self._mode_value = val
        self._mode_present = True

    @mode.deleter
    def mode(self):
        self._mode_value = None
        self._mode_present = False

    def __repr__(self):
        return 'SearchArg(path={!r}, query={!r}, start={!r}, max_results={!r}, mode={!r})'.format(
            self._path_value,
            self._query_value,
            self._start_value,
            self._max_results_value,
            self._mode_value,
        )

SearchArg_validator = bv.Struct(SearchArg)

class SearchError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: SearchError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'SearchError(%r, %r)' % (self._tag, self._value)

SearchError_validator = bv.Union(SearchError)

class SearchMatch(object):
    """
    :ivar match_type: The type of the match.
    :ivar metadata: The metadata for the matched file or folder.
    """

    __slots__ = [
        '_match_type_value',
        '_match_type_present',
        '_metadata_value',
        '_metadata_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 match_type=None,
                 metadata=None):
        self._match_type_value = None
        self._match_type_present = False
        self._metadata_value = None
        self._metadata_present = False
        if match_type is not None:
            self.match_type = match_type
        if metadata is not None:
            self.metadata = metadata

    @property
    def match_type(self):
        """
        The type of the match.

        :rtype: SearchMatchType
        """
        if self._match_type_present:
            return self._match_type_value
        else:
            raise AttributeError("missing required field 'match_type'")

    @match_type.setter
    def match_type(self, val):
        self._match_type_validator.validate_type_only(val)
        self._match_type_value = val
        self._match_type_present = True

    @match_type.deleter
    def match_type(self):
        self._match_type_value = None
        self._match_type_present = False

    @property
    def metadata(self):
        """
        The metadata for the matched file or folder.

        :rtype: Metadata
        """
        if self._metadata_present:
            return self._metadata_value
        else:
            raise AttributeError("missing required field 'metadata'")

    @metadata.setter
    def metadata(self, val):
        self._metadata_validator.validate_type_only(val)
        self._metadata_value = val
        self._metadata_present = True

    @metadata.deleter
    def metadata(self):
        self._metadata_value = None
        self._metadata_present = False

    def __repr__(self):
        return 'SearchMatch(match_type={!r}, metadata={!r})'.format(
            self._match_type_value,
            self._metadata_value,
        )

SearchMatch_validator = bv.Struct(SearchMatch)

class SearchMatchType(bb.Union):
    """
    Indicates what type of match was found for a given item.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar filename: This item was matched on its file or folder name.
    :ivar content: This item was matched based on its file contents.
    :ivar both: This item was matched based on both its contents and its file
        name.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    filename = None
    # Attribute is overwritten below the class definition
    content = None
    # Attribute is overwritten below the class definition
    both = None

    def is_filename(self):
        """
        Check if the union tag is ``filename``.

        :rtype: bool
        """
        return self._tag == 'filename'

    def is_content(self):
        """
        Check if the union tag is ``content``.

        :rtype: bool
        """
        return self._tag == 'content'

    def is_both(self):
        """
        Check if the union tag is ``both``.

        :rtype: bool
        """
        return self._tag == 'both'

    def __repr__(self):
        return 'SearchMatchType(%r, %r)' % (self._tag, self._value)

SearchMatchType_validator = bv.Union(SearchMatchType)

class SearchMode(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar filename: Search file and folder names.
    :ivar filename_and_content: Search file and folder names as well as file
        contents.
    :ivar deleted_filename: Search for deleted file and folder names.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    filename = None
    # Attribute is overwritten below the class definition
    filename_and_content = None
    # Attribute is overwritten below the class definition
    deleted_filename = None

    def is_filename(self):
        """
        Check if the union tag is ``filename``.

        :rtype: bool
        """
        return self._tag == 'filename'

    def is_filename_and_content(self):
        """
        Check if the union tag is ``filename_and_content``.

        :rtype: bool
        """
        return self._tag == 'filename_and_content'

    def is_deleted_filename(self):
        """
        Check if the union tag is ``deleted_filename``.

        :rtype: bool
        """
        return self._tag == 'deleted_filename'

    def __repr__(self):
        return 'SearchMode(%r, %r)' % (self._tag, self._value)

SearchMode_validator = bv.Union(SearchMode)

class SearchResult(object):
    """
    :ivar matches: A list (possibly empty) of matches for the query.
    :ivar more: Used for paging. If true, indicates there is another page of
        results available that can be fetched by calling
        :meth:`dropbox.dropbox.Dropbox.files_search` again.
    :ivar start: Used for paging. Value to set the start argument to when
        calling :meth:`dropbox.dropbox.Dropbox.files_search` to fetch the next
        page of results.
    """

    __slots__ = [
        '_matches_value',
        '_matches_present',
        '_more_value',
        '_more_present',
        '_start_value',
        '_start_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 matches=None,
                 more=None,
                 start=None):
        self._matches_value = None
        self._matches_present = False
        self._more_value = None
        self._more_present = False
        self._start_value = None
        self._start_present = False
        if matches is not None:
            self.matches = matches
        if more is not None:
            self.more = more
        if start is not None:
            self.start = start

    @property
    def matches(self):
        """
        A list (possibly empty) of matches for the query.

        :rtype: list of [SearchMatch]
        """
        if self._matches_present:
            return self._matches_value
        else:
            raise AttributeError("missing required field 'matches'")

    @matches.setter
    def matches(self, val):
        val = self._matches_validator.validate(val)
        self._matches_value = val
        self._matches_present = True

    @matches.deleter
    def matches(self):
        self._matches_value = None
        self._matches_present = False

    @property
    def more(self):
        """
        Used for paging. If true, indicates there is another page of results
        available that can be fetched by calling
        :meth:`dropbox.dropbox.Dropbox.files_search` again.

        :rtype: bool
        """
        if self._more_present:
            return self._more_value
        else:
            raise AttributeError("missing required field 'more'")

    @more.setter
    def more(self, val):
        val = self._more_validator.validate(val)
        self._more_value = val
        self._more_present = True

    @more.deleter
    def more(self):
        self._more_value = None
        self._more_present = False

    @property
    def start(self):
        """
        Used for paging. Value to set the start argument to when calling
        :meth:`dropbox.dropbox.Dropbox.files_search` to fetch the next page of
        results.

        :rtype: long
        """
        if self._start_present:
            return self._start_value
        else:
            raise AttributeError("missing required field 'start'")

    @start.setter
    def start(self, val):
        val = self._start_validator.validate(val)
        self._start_value = val
        self._start_present = True

    @start.deleter
    def start(self):
        self._start_value = None
        self._start_present = False

    def __repr__(self):
        return 'SearchResult(matches={!r}, more={!r}, start={!r})'.format(
            self._matches_value,
            self._more_value,
            self._start_value,
        )

SearchResult_validator = bv.Struct(SearchResult)

class SharedLink(object):
    """
    :ivar url: Shared link url.
    :ivar password: Password for the shared link.
    """

    __slots__ = [
        '_url_value',
        '_url_present',
        '_password_value',
        '_password_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 url=None,
                 password=None):
        self._url_value = None
        self._url_present = False
        self._password_value = None
        self._password_present = False
        if url is not None:
            self.url = url
        if password is not None:
            self.password = password

    @property
    def url(self):
        """
        Shared link url.

        :rtype: str
        """
        if self._url_present:
            return self._url_value
        else:
            raise AttributeError("missing required field 'url'")

    @url.setter
    def url(self, val):
        val = self._url_validator.validate(val)
        self._url_value = val
        self._url_present = True

    @url.deleter
    def url(self):
        self._url_value = None
        self._url_present = False

    @property
    def password(self):
        """
        Password for the shared link.

        :rtype: str
        """
        if self._password_present:
            return self._password_value
        else:
            return None

    @password.setter
    def password(self, val):
        if val is None:
            del self.password
            return
        val = self._password_validator.validate(val)
        self._password_value = val
        self._password_present = True

    @password.deleter
    def password(self):
        self._password_value = None
        self._password_present = False

    def __repr__(self):
        return 'SharedLink(url={!r}, password={!r})'.format(
            self._url_value,
            self._password_value,
        )

SharedLink_validator = bv.Struct(SharedLink)

class SymlinkInfo(object):
    """
    :ivar target: The target this symlink points to.
    """

    __slots__ = [
        '_target_value',
        '_target_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target=None):
        self._target_value = None
        self._target_present = False
        if target is not None:
            self.target = target

    @property
    def target(self):
        """
        The target this symlink points to.

        :rtype: str
        """
        if self._target_present:
            return self._target_value
        else:
            raise AttributeError("missing required field 'target'")

    @target.setter
    def target(self, val):
        val = self._target_validator.validate(val)
        self._target_value = val
        self._target_present = True

    @target.deleter
    def target(self):
        self._target_value = None
        self._target_present = False

    def __repr__(self):
        return 'SymlinkInfo(target={!r})'.format(
            self._target_value,
        )

SymlinkInfo_validator = bv.Struct(SymlinkInfo)

class SyncSetting(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar default: On first sync to members' computers, the specified folder
        will follow its parent folder's setting or otherwise follow default sync
        behavior.
    :ivar not_synced: On first sync to members' computers, the specified folder
        will be set to not sync with selective sync.
    :ivar not_synced_inactive: The specified folder's not_synced setting is
        inactive due to its location or other configuration changes. It will
        follow its parent folder's setting.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    default = None
    # Attribute is overwritten below the class definition
    not_synced = None
    # Attribute is overwritten below the class definition
    not_synced_inactive = None
    # Attribute is overwritten below the class definition
    other = None

    def is_default(self):
        """
        Check if the union tag is ``default``.

        :rtype: bool
        """
        return self._tag == 'default'

    def is_not_synced(self):
        """
        Check if the union tag is ``not_synced``.

        :rtype: bool
        """
        return self._tag == 'not_synced'

    def is_not_synced_inactive(self):
        """
        Check if the union tag is ``not_synced_inactive``.

        :rtype: bool
        """
        return self._tag == 'not_synced_inactive'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'SyncSetting(%r, %r)' % (self._tag, self._value)

SyncSetting_validator = bv.Union(SyncSetting)

class SyncSettingArg(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar default: On first sync to members' computers, the specified folder
        will follow its parent folder's setting or otherwise follow default sync
        behavior.
    :ivar not_synced: On first sync to members' computers, the specified folder
        will be set to not sync with selective sync.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    default = None
    # Attribute is overwritten below the class definition
    not_synced = None
    # Attribute is overwritten below the class definition
    other = None

    def is_default(self):
        """
        Check if the union tag is ``default``.

        :rtype: bool
        """
        return self._tag == 'default'

    def is_not_synced(self):
        """
        Check if the union tag is ``not_synced``.

        :rtype: bool
        """
        return self._tag == 'not_synced'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'SyncSettingArg(%r, %r)' % (self._tag, self._value)

SyncSettingArg_validator = bv.Union(SyncSettingArg)

class SyncSettingsError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar unsupported_combination: Setting this combination of sync settings
        simultaneously is not supported.
    :ivar unsupported_configuration: The specified configuration is not
        supported.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    unsupported_combination = None
    # Attribute is overwritten below the class definition
    unsupported_configuration = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: SyncSettingsError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_unsupported_combination(self):
        """
        Check if the union tag is ``unsupported_combination``.

        :rtype: bool
        """
        return self._tag == 'unsupported_combination'

    def is_unsupported_configuration(self):
        """
        Check if the union tag is ``unsupported_configuration``.

        :rtype: bool
        """
        return self._tag == 'unsupported_configuration'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'SyncSettingsError(%r, %r)' % (self._tag, self._value)

SyncSettingsError_validator = bv.Union(SyncSettingsError)

class ThumbnailArg(object):
    """
    :ivar path: The path to the image file you want to thumbnail.
    :ivar format: The format for the thumbnail image, jpeg (default) or png. For
        images that are photos, jpeg should be preferred, while png is  better
        for screenshots and digital arts.
    :ivar size: The size for the thumbnail image.
    :ivar mode: How to resize and crop the image to achieve the desired size.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_format_value',
        '_format_present',
        '_size_value',
        '_size_present',
        '_mode_value',
        '_mode_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 format=None,
                 size=None,
                 mode=None):
        self._path_value = None
        self._path_present = False
        self._format_value = None
        self._format_present = False
        self._size_value = None
        self._size_present = False
        self._mode_value = None
        self._mode_present = False
        if path is not None:
            self.path = path
        if format is not None:
            self.format = format
        if size is not None:
            self.size = size
        if mode is not None:
            self.mode = mode

    @property
    def path(self):
        """
        The path to the image file you want to thumbnail.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def format(self):
        """
        The format for the thumbnail image, jpeg (default) or png. For  images
        that are photos, jpeg should be preferred, while png is  better for
        screenshots and digital arts.

        :rtype: ThumbnailFormat
        """
        if self._format_present:
            return self._format_value
        else:
            return ThumbnailFormat.jpeg

    @format.setter
    def format(self, val):
        self._format_validator.validate_type_only(val)
        self._format_value = val
        self._format_present = True

    @format.deleter
    def format(self):
        self._format_value = None
        self._format_present = False

    @property
    def size(self):
        """
        The size for the thumbnail image.

        :rtype: ThumbnailSize
        """
        if self._size_present:
            return self._size_value
        else:
            return ThumbnailSize.w64h64

    @size.setter
    def size(self, val):
        self._size_validator.validate_type_only(val)
        self._size_value = val
        self._size_present = True

    @size.deleter
    def size(self):
        self._size_value = None
        self._size_present = False

    @property
    def mode(self):
        """
        How to resize and crop the image to achieve the desired size.

        :rtype: ThumbnailMode
        """
        if self._mode_present:
            return self._mode_value
        else:
            return ThumbnailMode.strict

    @mode.setter
    def mode(self, val):
        self._mode_validator.validate_type_only(val)
        self._mode_value = val
        self._mode_present = True

    @mode.deleter
    def mode(self):
        self._mode_value = None
        self._mode_present = False

    def __repr__(self):
        return 'ThumbnailArg(path={!r}, format={!r}, size={!r}, mode={!r})'.format(
            self._path_value,
            self._format_value,
            self._size_value,
            self._mode_value,
        )

ThumbnailArg_validator = bv.Struct(ThumbnailArg)

class ThumbnailError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar LookupError path: An error occurs when downloading metadata for the
        image.
    :ivar unsupported_extension: The file extension doesn't allow conversion to
        a thumbnail.
    :ivar unsupported_image: The image cannot be converted to a thumbnail.
    :ivar conversion_error: An error occurs during thumbnail conversion.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    unsupported_extension = None
    # Attribute is overwritten below the class definition
    unsupported_image = None
    # Attribute is overwritten below the class definition
    conversion_error = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: ThumbnailError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_unsupported_extension(self):
        """
        Check if the union tag is ``unsupported_extension``.

        :rtype: bool
        """
        return self._tag == 'unsupported_extension'

    def is_unsupported_image(self):
        """
        Check if the union tag is ``unsupported_image``.

        :rtype: bool
        """
        return self._tag == 'unsupported_image'

    def is_conversion_error(self):
        """
        Check if the union tag is ``conversion_error``.

        :rtype: bool
        """
        return self._tag == 'conversion_error'

    def get_path(self):
        """
        An error occurs when downloading metadata for the image.

        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'ThumbnailError(%r, %r)' % (self._tag, self._value)

ThumbnailError_validator = bv.Union(ThumbnailError)

class ThumbnailFormat(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    jpeg = None
    # Attribute is overwritten below the class definition
    png = None

    def is_jpeg(self):
        """
        Check if the union tag is ``jpeg``.

        :rtype: bool
        """
        return self._tag == 'jpeg'

    def is_png(self):
        """
        Check if the union tag is ``png``.

        :rtype: bool
        """
        return self._tag == 'png'

    def __repr__(self):
        return 'ThumbnailFormat(%r, %r)' % (self._tag, self._value)

ThumbnailFormat_validator = bv.Union(ThumbnailFormat)

class ThumbnailMode(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar strict: Scale down the image to fit within the given size.
    :ivar bestfit: Scale down the image to fit within the given size or its
        transpose.
    :ivar fitone_bestfit: Scale down the image to completely cover the given
        size or its transpose.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    strict = None
    # Attribute is overwritten below the class definition
    bestfit = None
    # Attribute is overwritten below the class definition
    fitone_bestfit = None

    def is_strict(self):
        """
        Check if the union tag is ``strict``.

        :rtype: bool
        """
        return self._tag == 'strict'

    def is_bestfit(self):
        """
        Check if the union tag is ``bestfit``.

        :rtype: bool
        """
        return self._tag == 'bestfit'

    def is_fitone_bestfit(self):
        """
        Check if the union tag is ``fitone_bestfit``.

        :rtype: bool
        """
        return self._tag == 'fitone_bestfit'

    def __repr__(self):
        return 'ThumbnailMode(%r, %r)' % (self._tag, self._value)

ThumbnailMode_validator = bv.Union(ThumbnailMode)

class ThumbnailSize(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar w32h32: 32 by 32 px.
    :ivar w64h64: 64 by 64 px.
    :ivar w128h128: 128 by 128 px.
    :ivar w256h256: 256 by 256 px.
    :ivar w480h320: 480 by 320 px.
    :ivar w640h480: 640 by 480 px.
    :ivar w960h640: 960 by 640 px.
    :ivar w1024h768: 1024 by 768 px.
    :ivar w2048h1536: 2048 by 1536 px.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    w32h32 = None
    # Attribute is overwritten below the class definition
    w64h64 = None
    # Attribute is overwritten below the class definition
    w128h128 = None
    # Attribute is overwritten below the class definition
    w256h256 = None
    # Attribute is overwritten below the class definition
    w480h320 = None
    # Attribute is overwritten below the class definition
    w640h480 = None
    # Attribute is overwritten below the class definition
    w960h640 = None
    # Attribute is overwritten below the class definition
    w1024h768 = None
    # Attribute is overwritten below the class definition
    w2048h1536 = None

    def is_w32h32(self):
        """
        Check if the union tag is ``w32h32``.

        :rtype: bool
        """
        return self._tag == 'w32h32'

    def is_w64h64(self):
        """
        Check if the union tag is ``w64h64``.

        :rtype: bool
        """
        return self._tag == 'w64h64'

    def is_w128h128(self):
        """
        Check if the union tag is ``w128h128``.

        :rtype: bool
        """
        return self._tag == 'w128h128'

    def is_w256h256(self):
        """
        Check if the union tag is ``w256h256``.

        :rtype: bool
        """
        return self._tag == 'w256h256'

    def is_w480h320(self):
        """
        Check if the union tag is ``w480h320``.

        :rtype: bool
        """
        return self._tag == 'w480h320'

    def is_w640h480(self):
        """
        Check if the union tag is ``w640h480``.

        :rtype: bool
        """
        return self._tag == 'w640h480'

    def is_w960h640(self):
        """
        Check if the union tag is ``w960h640``.

        :rtype: bool
        """
        return self._tag == 'w960h640'

    def is_w1024h768(self):
        """
        Check if the union tag is ``w1024h768``.

        :rtype: bool
        """
        return self._tag == 'w1024h768'

    def is_w2048h1536(self):
        """
        Check if the union tag is ``w2048h1536``.

        :rtype: bool
        """
        return self._tag == 'w2048h1536'

    def __repr__(self):
        return 'ThumbnailSize(%r, %r)' % (self._tag, self._value)

ThumbnailSize_validator = bv.Union(ThumbnailSize)

class UploadError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar UploadWriteFailed path: Unable to save the uploaded contents to a
        file.
    :ivar InvalidPropertyGroupError properties_error: The supplied property
        group is invalid. The file has uploaded without property groups.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param UploadWriteFailed val:
        :rtype: UploadError
        """
        return cls('path', val)

    @classmethod
    def properties_error(cls, val):
        """
        Create an instance of this class set to the ``properties_error`` tag
        with value ``val``.

        :param file_properties.InvalidPropertyGroupError_validator val:
        :rtype: UploadError
        """
        return cls('properties_error', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_properties_error(self):
        """
        Check if the union tag is ``properties_error``.

        :rtype: bool
        """
        return self._tag == 'properties_error'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Unable to save the uploaded contents to a file.

        Only call this if :meth:`is_path` is true.

        :rtype: UploadWriteFailed
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def get_properties_error(self):
        """
        The supplied property group is invalid. The file has uploaded without
        property groups.

        Only call this if :meth:`is_properties_error` is true.

        :rtype: file_properties.InvalidPropertyGroupError_validator
        """
        if not self.is_properties_error():
            raise AttributeError("tag 'properties_error' not set")
        return self._value

    def __repr__(self):
        return 'UploadError(%r, %r)' % (self._tag, self._value)

UploadError_validator = bv.Union(UploadError)

class UploadErrorWithProperties(UploadError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    def __repr__(self):
        return 'UploadErrorWithProperties(%r, %r)' % (self._tag, self._value)

UploadErrorWithProperties_validator = bv.Union(UploadErrorWithProperties)

class UploadSessionAppendArg(object):
    """
    :ivar cursor: Contains the upload session ID and the offset.
    :ivar close: If true, the current session will be closed, at which point you
        won't be able to call
        :meth:`dropbox.dropbox.Dropbox.files_upload_session_append_v2` anymore
        with the current session.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
        '_close_value',
        '_close_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 cursor=None,
                 close=None):
        self._cursor_value = None
        self._cursor_present = False
        self._close_value = None
        self._close_present = False
        if cursor is not None:
            self.cursor = cursor
        if close is not None:
            self.close = close

    @property
    def cursor(self):
        """
        Contains the upload session ID and the offset.

        :rtype: UploadSessionCursor
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        self._cursor_validator.validate_type_only(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    @property
    def close(self):
        """
        If true, the current session will be closed, at which point you won't be
        able to call
        :meth:`dropbox.dropbox.Dropbox.files_upload_session_append_v2` anymore
        with the current session.

        :rtype: bool
        """
        if self._close_present:
            return self._close_value
        else:
            return False

    @close.setter
    def close(self, val):
        val = self._close_validator.validate(val)
        self._close_value = val
        self._close_present = True

    @close.deleter
    def close(self):
        self._close_value = None
        self._close_present = False

    def __repr__(self):
        return 'UploadSessionAppendArg(cursor={!r}, close={!r})'.format(
            self._cursor_value,
            self._close_value,
        )

UploadSessionAppendArg_validator = bv.Struct(UploadSessionAppendArg)

class UploadSessionCursor(object):
    """
    :ivar session_id: The upload session ID (returned by
        :meth:`dropbox.dropbox.Dropbox.files_upload_session_start`).
    :ivar offset: The amount of data that has been uploaded so far. We use this
        to make sure upload data isn't lost or duplicated in the event of a
        network error.
    """

    __slots__ = [
        '_session_id_value',
        '_session_id_present',
        '_offset_value',
        '_offset_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 session_id=None,
                 offset=None):
        self._session_id_value = None
        self._session_id_present = False
        self._offset_value = None
        self._offset_present = False
        if session_id is not None:
            self.session_id = session_id
        if offset is not None:
            self.offset = offset

    @property
    def session_id(self):
        """
        The upload session ID (returned by
        :meth:`dropbox.dropbox.Dropbox.files_upload_session_start`).

        :rtype: str
        """
        if self._session_id_present:
            return self._session_id_value
        else:
            raise AttributeError("missing required field 'session_id'")

    @session_id.setter
    def session_id(self, val):
        val = self._session_id_validator.validate(val)
        self._session_id_value = val
        self._session_id_present = True

    @session_id.deleter
    def session_id(self):
        self._session_id_value = None
        self._session_id_present = False

    @property
    def offset(self):
        """
        The amount of data that has been uploaded so far. We use this to make
        sure upload data isn't lost or duplicated in the event of a network
        error.

        :rtype: long
        """
        if self._offset_present:
            return self._offset_value
        else:
            raise AttributeError("missing required field 'offset'")

    @offset.setter
    def offset(self, val):
        val = self._offset_validator.validate(val)
        self._offset_value = val
        self._offset_present = True

    @offset.deleter
    def offset(self):
        self._offset_value = None
        self._offset_present = False

    def __repr__(self):
        return 'UploadSessionCursor(session_id={!r}, offset={!r})'.format(
            self._session_id_value,
            self._offset_value,
        )

UploadSessionCursor_validator = bv.Struct(UploadSessionCursor)

class UploadSessionFinishArg(object):
    """
    :ivar cursor: Contains the upload session ID and the offset.
    :ivar commit: Contains the path and other optional modifiers for the commit.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
        '_commit_value',
        '_commit_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 cursor=None,
                 commit=None):
        self._cursor_value = None
        self._cursor_present = False
        self._commit_value = None
        self._commit_present = False
        if cursor is not None:
            self.cursor = cursor
        if commit is not None:
            self.commit = commit

    @property
    def cursor(self):
        """
        Contains the upload session ID and the offset.

        :rtype: UploadSessionCursor
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        self._cursor_validator.validate_type_only(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    @property
    def commit(self):
        """
        Contains the path and other optional modifiers for the commit.

        :rtype: CommitInfo
        """
        if self._commit_present:
            return self._commit_value
        else:
            raise AttributeError("missing required field 'commit'")

    @commit.setter
    def commit(self, val):
        self._commit_validator.validate_type_only(val)
        self._commit_value = val
        self._commit_present = True

    @commit.deleter
    def commit(self):
        self._commit_value = None
        self._commit_present = False

    def __repr__(self):
        return 'UploadSessionFinishArg(cursor={!r}, commit={!r})'.format(
            self._cursor_value,
            self._commit_value,
        )

UploadSessionFinishArg_validator = bv.Struct(UploadSessionFinishArg)

class UploadSessionFinishBatchArg(object):
    """
    :ivar entries: Commit information for each file in the batch.
    """

    __slots__ = [
        '_entries_value',
        '_entries_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 entries=None):
        self._entries_value = None
        self._entries_present = False
        if entries is not None:
            self.entries = entries

    @property
    def entries(self):
        """
        Commit information for each file in the batch.

        :rtype: list of [UploadSessionFinishArg]
        """
        if self._entries_present:
            return self._entries_value
        else:
            raise AttributeError("missing required field 'entries'")

    @entries.setter
    def entries(self, val):
        val = self._entries_validator.validate(val)
        self._entries_value = val
        self._entries_present = True

    @entries.deleter
    def entries(self):
        self._entries_value = None
        self._entries_present = False

    def __repr__(self):
        return 'UploadSessionFinishBatchArg(entries={!r})'.format(
            self._entries_value,
        )

UploadSessionFinishBatchArg_validator = bv.Struct(UploadSessionFinishBatchArg)

class UploadSessionFinishBatchJobStatus(async_.PollResultBase):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar UploadSessionFinishBatchResult complete: The
        :meth:`dropbox.dropbox.Dropbox.files_upload_session_finish_batch` has
        finished.
    """

    @classmethod
    def complete(cls, val):
        """
        Create an instance of this class set to the ``complete`` tag with value
        ``val``.

        :param UploadSessionFinishBatchResult val:
        :rtype: UploadSessionFinishBatchJobStatus
        """
        return cls('complete', val)

    def is_complete(self):
        """
        Check if the union tag is ``complete``.

        :rtype: bool
        """
        return self._tag == 'complete'

    def get_complete(self):
        """
        The :meth:`dropbox.dropbox.Dropbox.files_upload_session_finish_batch`
        has finished.

        Only call this if :meth:`is_complete` is true.

        :rtype: UploadSessionFinishBatchResult
        """
        if not self.is_complete():
            raise AttributeError("tag 'complete' not set")
        return self._value

    def __repr__(self):
        return 'UploadSessionFinishBatchJobStatus(%r, %r)' % (self._tag, self._value)

UploadSessionFinishBatchJobStatus_validator = bv.Union(UploadSessionFinishBatchJobStatus)

class UploadSessionFinishBatchLaunch(async_.LaunchResultBase):
    """
    Result returned by
    :meth:`dropbox.dropbox.Dropbox.files_upload_session_finish_batch` that may
    either launch an asynchronous job or complete synchronously.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def complete(cls, val):
        """
        Create an instance of this class set to the ``complete`` tag with value
        ``val``.

        :param UploadSessionFinishBatchResult val:
        :rtype: UploadSessionFinishBatchLaunch
        """
        return cls('complete', val)

    def is_complete(self):
        """
        Check if the union tag is ``complete``.

        :rtype: bool
        """
        return self._tag == 'complete'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_complete(self):
        """
        Only call this if :meth:`is_complete` is true.

        :rtype: UploadSessionFinishBatchResult
        """
        if not self.is_complete():
            raise AttributeError("tag 'complete' not set")
        return self._value

    def __repr__(self):
        return 'UploadSessionFinishBatchLaunch(%r, %r)' % (self._tag, self._value)

UploadSessionFinishBatchLaunch_validator = bv.Union(UploadSessionFinishBatchLaunch)

class UploadSessionFinishBatchResult(object):
    """
    :ivar entries: Commit result for each file in the batch.
    """

    __slots__ = [
        '_entries_value',
        '_entries_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 entries=None):
        self._entries_value = None
        self._entries_present = False
        if entries is not None:
            self.entries = entries

    @property
    def entries(self):
        """
        Commit result for each file in the batch.

        :rtype: list of [UploadSessionFinishBatchResultEntry]
        """
        if self._entries_present:
            return self._entries_value
        else:
            raise AttributeError("missing required field 'entries'")

    @entries.setter
    def entries(self, val):
        val = self._entries_validator.validate(val)
        self._entries_value = val
        self._entries_present = True

    @entries.deleter
    def entries(self):
        self._entries_value = None
        self._entries_present = False

    def __repr__(self):
        return 'UploadSessionFinishBatchResult(entries={!r})'.format(
            self._entries_value,
        )

UploadSessionFinishBatchResult_validator = bv.Struct(UploadSessionFinishBatchResult)

class UploadSessionFinishBatchResultEntry(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = None

    @classmethod
    def success(cls, val):
        """
        Create an instance of this class set to the ``success`` tag with value
        ``val``.

        :param FileMetadata val:
        :rtype: UploadSessionFinishBatchResultEntry
        """
        return cls('success', val)

    @classmethod
    def failure(cls, val):
        """
        Create an instance of this class set to the ``failure`` tag with value
        ``val``.

        :param UploadSessionFinishError val:
        :rtype: UploadSessionFinishBatchResultEntry
        """
        return cls('failure', val)

    def is_success(self):
        """
        Check if the union tag is ``success``.

        :rtype: bool
        """
        return self._tag == 'success'

    def is_failure(self):
        """
        Check if the union tag is ``failure``.

        :rtype: bool
        """
        return self._tag == 'failure'

    def get_success(self):
        """
        Only call this if :meth:`is_success` is true.

        :rtype: FileMetadata
        """
        if not self.is_success():
            raise AttributeError("tag 'success' not set")
        return self._value

    def get_failure(self):
        """
        Only call this if :meth:`is_failure` is true.

        :rtype: UploadSessionFinishError
        """
        if not self.is_failure():
            raise AttributeError("tag 'failure' not set")
        return self._value

    def __repr__(self):
        return 'UploadSessionFinishBatchResultEntry(%r, %r)' % (self._tag, self._value)

UploadSessionFinishBatchResultEntry_validator = bv.Union(UploadSessionFinishBatchResultEntry)

class UploadSessionFinishError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar UploadSessionLookupError lookup_failed: The session arguments are
        incorrect; the value explains the reason.
    :ivar WriteError path: Unable to save the uploaded contents to a file. Data
        has already been appended to the upload session. Please retry with empty
        data body and updated offset.
    :ivar InvalidPropertyGroupError properties_error: The supplied property
        group is invalid. The file has uploaded without property groups.
    :ivar too_many_shared_folder_targets: The batch request commits files into
        too many different shared folders. Please limit your batch request to
        files contained in a single shared folder.
    :ivar too_many_write_operations: There are too many write operations
        happening in the user's Dropbox. You should retry uploading this file.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    too_many_shared_folder_targets = None
    # Attribute is overwritten below the class definition
    too_many_write_operations = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def lookup_failed(cls, val):
        """
        Create an instance of this class set to the ``lookup_failed`` tag with
        value ``val``.

        :param UploadSessionLookupError val:
        :rtype: UploadSessionFinishError
        """
        return cls('lookup_failed', val)

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param WriteError val:
        :rtype: UploadSessionFinishError
        """
        return cls('path', val)

    @classmethod
    def properties_error(cls, val):
        """
        Create an instance of this class set to the ``properties_error`` tag
        with value ``val``.

        :param file_properties.InvalidPropertyGroupError_validator val:
        :rtype: UploadSessionFinishError
        """
        return cls('properties_error', val)

    def is_lookup_failed(self):
        """
        Check if the union tag is ``lookup_failed``.

        :rtype: bool
        """
        return self._tag == 'lookup_failed'

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_properties_error(self):
        """
        Check if the union tag is ``properties_error``.

        :rtype: bool
        """
        return self._tag == 'properties_error'

    def is_too_many_shared_folder_targets(self):
        """
        Check if the union tag is ``too_many_shared_folder_targets``.

        :rtype: bool
        """
        return self._tag == 'too_many_shared_folder_targets'

    def is_too_many_write_operations(self):
        """
        Check if the union tag is ``too_many_write_operations``.

        :rtype: bool
        """
        return self._tag == 'too_many_write_operations'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_lookup_failed(self):
        """
        The session arguments are incorrect; the value explains the reason.

        Only call this if :meth:`is_lookup_failed` is true.

        :rtype: UploadSessionLookupError
        """
        if not self.is_lookup_failed():
            raise AttributeError("tag 'lookup_failed' not set")
        return self._value

    def get_path(self):
        """
        Unable to save the uploaded contents to a file. Data has already been
        appended to the upload session. Please retry with empty data body and
        updated offset.

        Only call this if :meth:`is_path` is true.

        :rtype: WriteError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def get_properties_error(self):
        """
        The supplied property group is invalid. The file has uploaded without
        property groups.

        Only call this if :meth:`is_properties_error` is true.

        :rtype: file_properties.InvalidPropertyGroupError_validator
        """
        if not self.is_properties_error():
            raise AttributeError("tag 'properties_error' not set")
        return self._value

    def __repr__(self):
        return 'UploadSessionFinishError(%r, %r)' % (self._tag, self._value)

UploadSessionFinishError_validator = bv.Union(UploadSessionFinishError)

class UploadSessionLookupError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar not_found: The upload session ID was not found or has expired. Upload
        sessions are valid for 48 hours.
    :ivar UploadSessionOffsetError incorrect_offset: The specified offset was
        incorrect. See the value for the correct offset. This error may occur
        when a previous request was received and processed successfully but the
        client did not receive the response, e.g. due to a network error.
    :ivar closed: You are attempting to append data to an upload session that
        has alread been closed (i.e. committed).
    :ivar not_closed: The session must be closed before calling
        upload_session/finish_batch.
    :ivar too_large: You can not append to the upload session because the size
        of a file should not reach the max file size limit (i.e. 350GB).
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    not_found = None
    # Attribute is overwritten below the class definition
    closed = None
    # Attribute is overwritten below the class definition
    not_closed = None
    # Attribute is overwritten below the class definition
    too_large = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def incorrect_offset(cls, val):
        """
        Create an instance of this class set to the ``incorrect_offset`` tag
        with value ``val``.

        :param UploadSessionOffsetError val:
        :rtype: UploadSessionLookupError
        """
        return cls('incorrect_offset', val)

    def is_not_found(self):
        """
        Check if the union tag is ``not_found``.

        :rtype: bool
        """
        return self._tag == 'not_found'

    def is_incorrect_offset(self):
        """
        Check if the union tag is ``incorrect_offset``.

        :rtype: bool
        """
        return self._tag == 'incorrect_offset'

    def is_closed(self):
        """
        Check if the union tag is ``closed``.

        :rtype: bool
        """
        return self._tag == 'closed'

    def is_not_closed(self):
        """
        Check if the union tag is ``not_closed``.

        :rtype: bool
        """
        return self._tag == 'not_closed'

    def is_too_large(self):
        """
        Check if the union tag is ``too_large``.

        :rtype: bool
        """
        return self._tag == 'too_large'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_incorrect_offset(self):
        """
        The specified offset was incorrect. See the value for the correct
        offset. This error may occur when a previous request was received and
        processed successfully but the client did not receive the response, e.g.
        due to a network error.

        Only call this if :meth:`is_incorrect_offset` is true.

        :rtype: UploadSessionOffsetError
        """
        if not self.is_incorrect_offset():
            raise AttributeError("tag 'incorrect_offset' not set")
        return self._value

    def __repr__(self):
        return 'UploadSessionLookupError(%r, %r)' % (self._tag, self._value)

UploadSessionLookupError_validator = bv.Union(UploadSessionLookupError)

class UploadSessionOffsetError(object):
    """
    :ivar correct_offset: The offset up to which data has been collected.
    """

    __slots__ = [
        '_correct_offset_value',
        '_correct_offset_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 correct_offset=None):
        self._correct_offset_value = None
        self._correct_offset_present = False
        if correct_offset is not None:
            self.correct_offset = correct_offset

    @property
    def correct_offset(self):
        """
        The offset up to which data has been collected.

        :rtype: long
        """
        if self._correct_offset_present:
            return self._correct_offset_value
        else:
            raise AttributeError("missing required field 'correct_offset'")

    @correct_offset.setter
    def correct_offset(self, val):
        val = self._correct_offset_validator.validate(val)
        self._correct_offset_value = val
        self._correct_offset_present = True

    @correct_offset.deleter
    def correct_offset(self):
        self._correct_offset_value = None
        self._correct_offset_present = False

    def __repr__(self):
        return 'UploadSessionOffsetError(correct_offset={!r})'.format(
            self._correct_offset_value,
        )

UploadSessionOffsetError_validator = bv.Struct(UploadSessionOffsetError)

class UploadSessionStartArg(object):
    """
    :ivar close: If true, the current session will be closed, at which point you
        won't be able to call
        :meth:`dropbox.dropbox.Dropbox.files_upload_session_append_v2` anymore
        with the current session.
    """

    __slots__ = [
        '_close_value',
        '_close_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 close=None):
        self._close_value = None
        self._close_present = False
        if close is not None:
            self.close = close

    @property
    def close(self):
        """
        If true, the current session will be closed, at which point you won't be
        able to call
        :meth:`dropbox.dropbox.Dropbox.files_upload_session_append_v2` anymore
        with the current session.

        :rtype: bool
        """
        if self._close_present:
            return self._close_value
        else:
            return False

    @close.setter
    def close(self, val):
        val = self._close_validator.validate(val)
        self._close_value = val
        self._close_present = True

    @close.deleter
    def close(self):
        self._close_value = None
        self._close_present = False

    def __repr__(self):
        return 'UploadSessionStartArg(close={!r})'.format(
            self._close_value,
        )

UploadSessionStartArg_validator = bv.Struct(UploadSessionStartArg)

class UploadSessionStartResult(object):
    """
    :ivar session_id: A unique identifier for the upload session. Pass this to
        :meth:`dropbox.dropbox.Dropbox.files_upload_session_append_v2` and
        :meth:`dropbox.dropbox.Dropbox.files_upload_session_finish`.
    """

    __slots__ = [
        '_session_id_value',
        '_session_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 session_id=None):
        self._session_id_value = None
        self._session_id_present = False
        if session_id is not None:
            self.session_id = session_id

    @property
    def session_id(self):
        """
        A unique identifier for the upload session. Pass this to
        :meth:`dropbox.dropbox.Dropbox.files_upload_session_append_v2` and
        :meth:`dropbox.dropbox.Dropbox.files_upload_session_finish`.

        :rtype: str
        """
        if self._session_id_present:
            return self._session_id_value
        else:
            raise AttributeError("missing required field 'session_id'")

    @session_id.setter
    def session_id(self, val):
        val = self._session_id_validator.validate(val)
        self._session_id_value = val
        self._session_id_present = True

    @session_id.deleter
    def session_id(self):
        self._session_id_value = None
        self._session_id_present = False

    def __repr__(self):
        return 'UploadSessionStartResult(session_id={!r})'.format(
            self._session_id_value,
        )

UploadSessionStartResult_validator = bv.Struct(UploadSessionStartResult)

class UploadWriteFailed(object):
    """
    :ivar reason: The reason why the file couldn't be saved.
    :ivar upload_session_id: The upload session ID; data has already been
        uploaded to the corresponding upload session and this ID may be used to
        retry the commit with
        :meth:`dropbox.dropbox.Dropbox.files_upload_session_finish`.
    """

    __slots__ = [
        '_reason_value',
        '_reason_present',
        '_upload_session_id_value',
        '_upload_session_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 reason=None,
                 upload_session_id=None):
        self._reason_value = None
        self._reason_present = False
        self._upload_session_id_value = None
        self._upload_session_id_present = False
        if reason is not None:
            self.reason = reason
        if upload_session_id is not None:
            self.upload_session_id = upload_session_id

    @property
    def reason(self):
        """
        The reason why the file couldn't be saved.

        :rtype: WriteError
        """
        if self._reason_present:
            return self._reason_value
        else:
            raise AttributeError("missing required field 'reason'")

    @reason.setter
    def reason(self, val):
        self._reason_validator.validate_type_only(val)
        self._reason_value = val
        self._reason_present = True

    @reason.deleter
    def reason(self):
        self._reason_value = None
        self._reason_present = False

    @property
    def upload_session_id(self):
        """
        The upload session ID; data has already been uploaded to the
        corresponding upload session and this ID may be used to retry the commit
        with :meth:`dropbox.dropbox.Dropbox.files_upload_session_finish`.

        :rtype: str
        """
        if self._upload_session_id_present:
            return self._upload_session_id_value
        else:
            raise AttributeError("missing required field 'upload_session_id'")

    @upload_session_id.setter
    def upload_session_id(self, val):
        val = self._upload_session_id_validator.validate(val)
        self._upload_session_id_value = val
        self._upload_session_id_present = True

    @upload_session_id.deleter
    def upload_session_id(self):
        self._upload_session_id_value = None
        self._upload_session_id_present = False

    def __repr__(self):
        return 'UploadWriteFailed(reason={!r}, upload_session_id={!r})'.format(
            self._reason_value,
            self._upload_session_id_value,
        )

UploadWriteFailed_validator = bv.Struct(UploadWriteFailed)

class VideoMetadata(MediaMetadata):
    """
    Metadata for a video.

    :ivar duration: The duration of the video in milliseconds.
    """

    __slots__ = [
        '_duration_value',
        '_duration_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 dimensions=None,
                 location=None,
                 time_taken=None,
                 duration=None):
        super(VideoMetadata, self).__init__(dimensions,
                                            location,
                                            time_taken)
        self._duration_value = None
        self._duration_present = False
        if duration is not None:
            self.duration = duration

    @property
    def duration(self):
        """
        The duration of the video in milliseconds.

        :rtype: long
        """
        if self._duration_present:
            return self._duration_value
        else:
            return None

    @duration.setter
    def duration(self, val):
        if val is None:
            del self.duration
            return
        val = self._duration_validator.validate(val)
        self._duration_value = val
        self._duration_present = True

    @duration.deleter
    def duration(self):
        self._duration_value = None
        self._duration_present = False

    def __repr__(self):
        return 'VideoMetadata(dimensions={!r}, location={!r}, time_taken={!r}, duration={!r})'.format(
            self._dimensions_value,
            self._location_value,
            self._time_taken_value,
            self._duration_value,
        )

VideoMetadata_validator = bv.Struct(VideoMetadata)

class WriteConflictError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar file: There's a file in the way.
    :ivar folder: There's a folder in the way.
    :ivar file_ancestor: There's a file at an ancestor path, so we couldn't
        create the required parent folders.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    file = None
    # Attribute is overwritten below the class definition
    folder = None
    # Attribute is overwritten below the class definition
    file_ancestor = None
    # Attribute is overwritten below the class definition
    other = None

    def is_file(self):
        """
        Check if the union tag is ``file``.

        :rtype: bool
        """
        return self._tag == 'file'

    def is_folder(self):
        """
        Check if the union tag is ``folder``.

        :rtype: bool
        """
        return self._tag == 'folder'

    def is_file_ancestor(self):
        """
        Check if the union tag is ``file_ancestor``.

        :rtype: bool
        """
        return self._tag == 'file_ancestor'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'WriteConflictError(%r, %r)' % (self._tag, self._value)

WriteConflictError_validator = bv.Union(WriteConflictError)

class WriteError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar WriteConflictError conflict: Couldn't write to the target path because
        there was something in the way.
    :ivar no_write_permission: The user doesn't have permissions to write to the
        target location.
    :ivar insufficient_space: The user doesn't have enough available space
        (bytes) to write more data.
    :ivar disallowed_name: Dropbox will not save the file or folder because of
        its name.
    :ivar team_folder: This endpoint cannot move or delete team folders.
    :ivar too_many_write_operations: There are too many write operations in
        user's Dropbox. Please retry this request.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    no_write_permission = None
    # Attribute is overwritten below the class definition
    insufficient_space = None
    # Attribute is overwritten below the class definition
    disallowed_name = None
    # Attribute is overwritten below the class definition
    team_folder = None
    # Attribute is overwritten below the class definition
    too_many_write_operations = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def malformed_path(cls, val):
        """
        Create an instance of this class set to the ``malformed_path`` tag with
        value ``val``.

        :param Optional[str] val:
        :rtype: WriteError
        """
        return cls('malformed_path', val)

    @classmethod
    def conflict(cls, val):
        """
        Create an instance of this class set to the ``conflict`` tag with value
        ``val``.

        :param WriteConflictError val:
        :rtype: WriteError
        """
        return cls('conflict', val)

    def is_malformed_path(self):
        """
        Check if the union tag is ``malformed_path``.

        :rtype: bool
        """
        return self._tag == 'malformed_path'

    def is_conflict(self):
        """
        Check if the union tag is ``conflict``.

        :rtype: bool
        """
        return self._tag == 'conflict'

    def is_no_write_permission(self):
        """
        Check if the union tag is ``no_write_permission``.

        :rtype: bool
        """
        return self._tag == 'no_write_permission'

    def is_insufficient_space(self):
        """
        Check if the union tag is ``insufficient_space``.

        :rtype: bool
        """
        return self._tag == 'insufficient_space'

    def is_disallowed_name(self):
        """
        Check if the union tag is ``disallowed_name``.

        :rtype: bool
        """
        return self._tag == 'disallowed_name'

    def is_team_folder(self):
        """
        Check if the union tag is ``team_folder``.

        :rtype: bool
        """
        return self._tag == 'team_folder'

    def is_too_many_write_operations(self):
        """
        Check if the union tag is ``too_many_write_operations``.

        :rtype: bool
        """
        return self._tag == 'too_many_write_operations'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_malformed_path(self):
        """
        Only call this if :meth:`is_malformed_path` is true.

        :rtype: Optional[str]
        """
        if not self.is_malformed_path():
            raise AttributeError("tag 'malformed_path' not set")
        return self._value

    def get_conflict(self):
        """
        Couldn't write to the target path because there was something in the
        way.

        Only call this if :meth:`is_conflict` is true.

        :rtype: WriteConflictError
        """
        if not self.is_conflict():
            raise AttributeError("tag 'conflict' not set")
        return self._value

    def __repr__(self):
        return 'WriteError(%r, %r)' % (self._tag, self._value)

WriteError_validator = bv.Union(WriteError)

class WriteMode(bb.Union):
    """
    Your intent when writing a file to some path. This is used to determine what
    constitutes a conflict and what the autorename strategy is. In some
    situations, the conflict behavior is identical: (a) If the target path
    doesn't refer to anything, the file is always written; no conflict. (b) If
    the target path refers to a folder, it's always a conflict. (c) If the
    target path refers to a file with identical contents, nothing gets written;
    no conflict. The conflict checking differs in the case where there's a file
    at the target path with contents different from the contents you're trying
    to write.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar add: Do not overwrite an existing file if there is a conflict. The
        autorename strategy is to append a number to the file name. For example,
        "document.txt" might become "document (2).txt".
    :ivar overwrite: Always overwrite the existing file. The autorename strategy
        is the same as it is for ``add``.
    :ivar str update: Overwrite if the given "rev" matches the existing file's
        "rev". The autorename strategy is to append the string "conflicted copy"
        to the file name. For example, "document.txt" might become "document
        (conflicted copy).txt" or "document (Panda's conflicted copy).txt".
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    add = None
    # Attribute is overwritten below the class definition
    overwrite = None

    @classmethod
    def update(cls, val):
        """
        Create an instance of this class set to the ``update`` tag with value
        ``val``.

        :param str val:
        :rtype: WriteMode
        """
        return cls('update', val)

    def is_add(self):
        """
        Check if the union tag is ``add``.

        :rtype: bool
        """
        return self._tag == 'add'

    def is_overwrite(self):
        """
        Check if the union tag is ``overwrite``.

        :rtype: bool
        """
        return self._tag == 'overwrite'

    def is_update(self):
        """
        Check if the union tag is ``update``.

        :rtype: bool
        """
        return self._tag == 'update'

    def get_update(self):
        """
        Overwrite if the given "rev" matches the existing file's "rev". The
        autorename strategy is to append the string "conflicted copy" to the
        file name. For example, "document.txt" might become "document
        (conflicted copy).txt" or "document (Panda's conflicted copy).txt".

        Only call this if :meth:`is_update` is true.

        :rtype: str
        """
        if not self.is_update():
            raise AttributeError("tag 'update' not set")
        return self._value

    def __repr__(self):
        return 'WriteMode(%r, %r)' % (self._tag, self._value)

WriteMode_validator = bv.Union(WriteMode)

FileId_validator = bv.String(min_length=4, pattern=u'id:.+')
Id_validator = bv.String(min_length=1)
ListFolderCursor_validator = bv.String(min_length=1)
MalformedPathError_validator = bv.Nullable(bv.String())
Path_validator = bv.String(pattern=u'/(.|[\\r\\n])*')
PathOrId_validator = bv.String(pattern=u'/(.|[\\r\\n])*|id:.*|(ns:[0-9]+(/.*)?)')
PathR_validator = bv.String(pattern=u'(/(.|[\\r\\n])*)?|(ns:[0-9]+(/.*)?)')
PathROrId_validator = bv.String(pattern=u'(/(.|[\\r\\n])*)?|id:.*|(ns:[0-9]+(/.*)?)')
ReadPath_validator = bv.String(pattern=u'(/(.|[\\r\\n])*|id:.*)|(rev:[0-9a-f]{9,})|(ns:[0-9]+(/.*)?)')
Rev_validator = bv.String(min_length=9, pattern=u'[0-9a-f]+')
Sha256HexHash_validator = bv.String(min_length=64, max_length=64)
SharedLinkUrl_validator = bv.String()
WritePath_validator = bv.String(pattern=u'(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)')
WritePathOrId_validator = bv.String(pattern=u'(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)|(id:.*)')
GetMetadataArg._path_validator = ReadPath_validator
GetMetadataArg._include_media_info_validator = bv.Boolean()
GetMetadataArg._include_deleted_validator = bv.Boolean()
GetMetadataArg._include_has_explicit_shared_members_validator = bv.Boolean()
GetMetadataArg._include_property_groups_validator = bv.Nullable(file_properties.TemplateFilterBase_validator)
GetMetadataArg._all_field_names_ = set([
    'path',
    'include_media_info',
    'include_deleted',
    'include_has_explicit_shared_members',
    'include_property_groups',
])
GetMetadataArg._all_fields_ = [
    ('path', GetMetadataArg._path_validator),
    ('include_media_info', GetMetadataArg._include_media_info_validator),
    ('include_deleted', GetMetadataArg._include_deleted_validator),
    ('include_has_explicit_shared_members', GetMetadataArg._include_has_explicit_shared_members_validator),
    ('include_property_groups', GetMetadataArg._include_property_groups_validator),
]

AlphaGetMetadataArg._include_property_templates_validator = bv.Nullable(bv.List(file_properties.TemplateId_validator))
AlphaGetMetadataArg._all_field_names_ = GetMetadataArg._all_field_names_.union(set(['include_property_templates']))
AlphaGetMetadataArg._all_fields_ = GetMetadataArg._all_fields_ + [('include_property_templates', AlphaGetMetadataArg._include_property_templates_validator)]

GetMetadataError._path_validator = LookupError_validator
GetMetadataError._tagmap = {
    'path': GetMetadataError._path_validator,
}

AlphaGetMetadataError._properties_error_validator = file_properties.LookUpPropertiesError_validator
AlphaGetMetadataError._tagmap = {
    'properties_error': AlphaGetMetadataError._properties_error_validator,
}
AlphaGetMetadataError._tagmap.update(GetMetadataError._tagmap)

CommitInfo._path_validator = WritePathOrId_validator
CommitInfo._mode_validator = WriteMode_validator
CommitInfo._autorename_validator = bv.Boolean()
CommitInfo._client_modified_validator = bv.Nullable(common.DropboxTimestamp_validator)
CommitInfo._mute_validator = bv.Boolean()
CommitInfo._property_groups_validator = bv.Nullable(bv.List(file_properties.PropertyGroup_validator))
CommitInfo._all_field_names_ = set([
    'path',
    'mode',
    'autorename',
    'client_modified',
    'mute',
    'property_groups',
])
CommitInfo._all_fields_ = [
    ('path', CommitInfo._path_validator),
    ('mode', CommitInfo._mode_validator),
    ('autorename', CommitInfo._autorename_validator),
    ('client_modified', CommitInfo._client_modified_validator),
    ('mute', CommitInfo._mute_validator),
    ('property_groups', CommitInfo._property_groups_validator),
]

CommitInfoWithProperties._all_field_names_ = CommitInfo._all_field_names_.union(set([]))
CommitInfoWithProperties._all_fields_ = CommitInfo._all_fields_ + []

ContentSyncSetting._id_validator = FileId_validator
ContentSyncSetting._sync_setting_validator = SyncSetting_validator
ContentSyncSetting._all_field_names_ = set([
    'id',
    'sync_setting',
])
ContentSyncSetting._all_fields_ = [
    ('id', ContentSyncSetting._id_validator),
    ('sync_setting', ContentSyncSetting._sync_setting_validator),
]

ContentSyncSettingArg._id_validator = FileId_validator
ContentSyncSettingArg._sync_setting_validator = SyncSettingArg_validator
ContentSyncSettingArg._all_field_names_ = set([
    'id',
    'sync_setting',
])
ContentSyncSettingArg._all_fields_ = [
    ('id', ContentSyncSettingArg._id_validator),
    ('sync_setting', ContentSyncSettingArg._sync_setting_validator),
]

CreateFolderArg._path_validator = WritePath_validator
CreateFolderArg._autorename_validator = bv.Boolean()
CreateFolderArg._all_field_names_ = set([
    'path',
    'autorename',
])
CreateFolderArg._all_fields_ = [
    ('path', CreateFolderArg._path_validator),
    ('autorename', CreateFolderArg._autorename_validator),
]

CreateFolderBatchArg._paths_validator = bv.List(WritePath_validator)
CreateFolderBatchArg._autorename_validator = bv.Boolean()
CreateFolderBatchArg._force_async_validator = bv.Boolean()
CreateFolderBatchArg._all_field_names_ = set([
    'paths',
    'autorename',
    'force_async',
])
CreateFolderBatchArg._all_fields_ = [
    ('paths', CreateFolderBatchArg._paths_validator),
    ('autorename', CreateFolderBatchArg._autorename_validator),
    ('force_async', CreateFolderBatchArg._force_async_validator),
]

CreateFolderBatchError._too_many_files_validator = bv.Void()
CreateFolderBatchError._other_validator = bv.Void()
CreateFolderBatchError._tagmap = {
    'too_many_files': CreateFolderBatchError._too_many_files_validator,
    'other': CreateFolderBatchError._other_validator,
}

CreateFolderBatchError.too_many_files = CreateFolderBatchError('too_many_files')
CreateFolderBatchError.other = CreateFolderBatchError('other')

CreateFolderBatchJobStatus._complete_validator = CreateFolderBatchResult_validator
CreateFolderBatchJobStatus._failed_validator = CreateFolderBatchError_validator
CreateFolderBatchJobStatus._other_validator = bv.Void()
CreateFolderBatchJobStatus._tagmap = {
    'complete': CreateFolderBatchJobStatus._complete_validator,
    'failed': CreateFolderBatchJobStatus._failed_validator,
    'other': CreateFolderBatchJobStatus._other_validator,
}
CreateFolderBatchJobStatus._tagmap.update(async_.PollResultBase._tagmap)

CreateFolderBatchJobStatus.other = CreateFolderBatchJobStatus('other')

CreateFolderBatchLaunch._complete_validator = CreateFolderBatchResult_validator
CreateFolderBatchLaunch._other_validator = bv.Void()
CreateFolderBatchLaunch._tagmap = {
    'complete': CreateFolderBatchLaunch._complete_validator,
    'other': CreateFolderBatchLaunch._other_validator,
}
CreateFolderBatchLaunch._tagmap.update(async_.LaunchResultBase._tagmap)

CreateFolderBatchLaunch.other = CreateFolderBatchLaunch('other')

FileOpsResult._all_field_names_ = set([])
FileOpsResult._all_fields_ = []

CreateFolderBatchResult._entries_validator = bv.List(CreateFolderBatchResultEntry_validator)
CreateFolderBatchResult._all_field_names_ = FileOpsResult._all_field_names_.union(set(['entries']))
CreateFolderBatchResult._all_fields_ = FileOpsResult._all_fields_ + [('entries', CreateFolderBatchResult._entries_validator)]

CreateFolderBatchResultEntry._success_validator = CreateFolderEntryResult_validator
CreateFolderBatchResultEntry._failure_validator = CreateFolderEntryError_validator
CreateFolderBatchResultEntry._tagmap = {
    'success': CreateFolderBatchResultEntry._success_validator,
    'failure': CreateFolderBatchResultEntry._failure_validator,
}

CreateFolderEntryError._path_validator = WriteError_validator
CreateFolderEntryError._other_validator = bv.Void()
CreateFolderEntryError._tagmap = {
    'path': CreateFolderEntryError._path_validator,
    'other': CreateFolderEntryError._other_validator,
}

CreateFolderEntryError.other = CreateFolderEntryError('other')

CreateFolderEntryResult._metadata_validator = FolderMetadata_validator
CreateFolderEntryResult._all_field_names_ = set(['metadata'])
CreateFolderEntryResult._all_fields_ = [('metadata', CreateFolderEntryResult._metadata_validator)]

CreateFolderError._path_validator = WriteError_validator
CreateFolderError._tagmap = {
    'path': CreateFolderError._path_validator,
}

CreateFolderResult._metadata_validator = FolderMetadata_validator
CreateFolderResult._all_field_names_ = FileOpsResult._all_field_names_.union(set(['metadata']))
CreateFolderResult._all_fields_ = FileOpsResult._all_fields_ + [('metadata', CreateFolderResult._metadata_validator)]

DeleteArg._path_validator = WritePathOrId_validator
DeleteArg._parent_rev_validator = bv.Nullable(Rev_validator)
DeleteArg._all_field_names_ = set([
    'path',
    'parent_rev',
])
DeleteArg._all_fields_ = [
    ('path', DeleteArg._path_validator),
    ('parent_rev', DeleteArg._parent_rev_validator),
]

DeleteBatchArg._entries_validator = bv.List(DeleteArg_validator)
DeleteBatchArg._all_field_names_ = set(['entries'])
DeleteBatchArg._all_fields_ = [('entries', DeleteBatchArg._entries_validator)]

DeleteBatchError._too_many_write_operations_validator = bv.Void()
DeleteBatchError._other_validator = bv.Void()
DeleteBatchError._tagmap = {
    'too_many_write_operations': DeleteBatchError._too_many_write_operations_validator,
    'other': DeleteBatchError._other_validator,
}

DeleteBatchError.too_many_write_operations = DeleteBatchError('too_many_write_operations')
DeleteBatchError.other = DeleteBatchError('other')

DeleteBatchJobStatus._complete_validator = DeleteBatchResult_validator
DeleteBatchJobStatus._failed_validator = DeleteBatchError_validator
DeleteBatchJobStatus._other_validator = bv.Void()
DeleteBatchJobStatus._tagmap = {
    'complete': DeleteBatchJobStatus._complete_validator,
    'failed': DeleteBatchJobStatus._failed_validator,
    'other': DeleteBatchJobStatus._other_validator,
}
DeleteBatchJobStatus._tagmap.update(async_.PollResultBase._tagmap)

DeleteBatchJobStatus.other = DeleteBatchJobStatus('other')

DeleteBatchLaunch._complete_validator = DeleteBatchResult_validator
DeleteBatchLaunch._other_validator = bv.Void()
DeleteBatchLaunch._tagmap = {
    'complete': DeleteBatchLaunch._complete_validator,
    'other': DeleteBatchLaunch._other_validator,
}
DeleteBatchLaunch._tagmap.update(async_.LaunchResultBase._tagmap)

DeleteBatchLaunch.other = DeleteBatchLaunch('other')

DeleteBatchResult._entries_validator = bv.List(DeleteBatchResultEntry_validator)
DeleteBatchResult._all_field_names_ = FileOpsResult._all_field_names_.union(set(['entries']))
DeleteBatchResult._all_fields_ = FileOpsResult._all_fields_ + [('entries', DeleteBatchResult._entries_validator)]

DeleteBatchResultData._metadata_validator = Metadata_validator
DeleteBatchResultData._all_field_names_ = set(['metadata'])
DeleteBatchResultData._all_fields_ = [('metadata', DeleteBatchResultData._metadata_validator)]

DeleteBatchResultEntry._success_validator = DeleteBatchResultData_validator
DeleteBatchResultEntry._failure_validator = DeleteError_validator
DeleteBatchResultEntry._tagmap = {
    'success': DeleteBatchResultEntry._success_validator,
    'failure': DeleteBatchResultEntry._failure_validator,
}

DeleteError._path_lookup_validator = LookupError_validator
DeleteError._path_write_validator = WriteError_validator
DeleteError._too_many_write_operations_validator = bv.Void()
DeleteError._too_many_files_validator = bv.Void()
DeleteError._other_validator = bv.Void()
DeleteError._tagmap = {
    'path_lookup': DeleteError._path_lookup_validator,
    'path_write': DeleteError._path_write_validator,
    'too_many_write_operations': DeleteError._too_many_write_operations_validator,
    'too_many_files': DeleteError._too_many_files_validator,
    'other': DeleteError._other_validator,
}

DeleteError.too_many_write_operations = DeleteError('too_many_write_operations')
DeleteError.too_many_files = DeleteError('too_many_files')
DeleteError.other = DeleteError('other')

DeleteResult._metadata_validator = Metadata_validator
DeleteResult._all_field_names_ = FileOpsResult._all_field_names_.union(set(['metadata']))
DeleteResult._all_fields_ = FileOpsResult._all_fields_ + [('metadata', DeleteResult._metadata_validator)]

Metadata._name_validator = bv.String()
Metadata._path_lower_validator = bv.Nullable(bv.String())
Metadata._path_display_validator = bv.Nullable(bv.String())
Metadata._parent_shared_folder_id_validator = bv.Nullable(common.SharedFolderId_validator)
Metadata._field_names_ = set([
    'name',
    'path_lower',
    'path_display',
    'parent_shared_folder_id',
])
Metadata._all_field_names_ = Metadata._field_names_
Metadata._fields_ = [
    ('name', Metadata._name_validator),
    ('path_lower', Metadata._path_lower_validator),
    ('path_display', Metadata._path_display_validator),
    ('parent_shared_folder_id', Metadata._parent_shared_folder_id_validator),
]
Metadata._all_fields_ = Metadata._fields_

Metadata._tag_to_subtype_ = {
    (u'file',): FileMetadata_validator,
    (u'folder',): FolderMetadata_validator,
    (u'deleted',): DeletedMetadata_validator,
}
Metadata._pytype_to_tag_and_subtype_ = {
    FileMetadata: ((u'file',), FileMetadata_validator),
    FolderMetadata: ((u'folder',), FolderMetadata_validator),
    DeletedMetadata: ((u'deleted',), DeletedMetadata_validator),
}
Metadata._is_catch_all_ = False

DeletedMetadata._field_names_ = set([])
DeletedMetadata._all_field_names_ = Metadata._all_field_names_.union(DeletedMetadata._field_names_)
DeletedMetadata._fields_ = []
DeletedMetadata._all_fields_ = Metadata._all_fields_ + DeletedMetadata._fields_

Dimensions._height_validator = bv.UInt64()
Dimensions._width_validator = bv.UInt64()
Dimensions._all_field_names_ = set([
    'height',
    'width',
])
Dimensions._all_fields_ = [
    ('height', Dimensions._height_validator),
    ('width', Dimensions._width_validator),
]

DownloadArg._path_validator = ReadPath_validator
DownloadArg._rev_validator = bv.Nullable(Rev_validator)
DownloadArg._all_field_names_ = set([
    'path',
    'rev',
])
DownloadArg._all_fields_ = [
    ('path', DownloadArg._path_validator),
    ('rev', DownloadArg._rev_validator),
]

DownloadError._path_validator = LookupError_validator
DownloadError._other_validator = bv.Void()
DownloadError._tagmap = {
    'path': DownloadError._path_validator,
    'other': DownloadError._other_validator,
}

DownloadError.other = DownloadError('other')

DownloadZipArg._path_validator = ReadPath_validator
DownloadZipArg._all_field_names_ = set(['path'])
DownloadZipArg._all_fields_ = [('path', DownloadZipArg._path_validator)]

DownloadZipError._path_validator = LookupError_validator
DownloadZipError._too_large_validator = bv.Void()
DownloadZipError._too_many_files_validator = bv.Void()
DownloadZipError._other_validator = bv.Void()
DownloadZipError._tagmap = {
    'path': DownloadZipError._path_validator,
    'too_large': DownloadZipError._too_large_validator,
    'too_many_files': DownloadZipError._too_many_files_validator,
    'other': DownloadZipError._other_validator,
}

DownloadZipError.too_large = DownloadZipError('too_large')
DownloadZipError.too_many_files = DownloadZipError('too_many_files')
DownloadZipError.other = DownloadZipError('other')

DownloadZipResult._metadata_validator = FolderMetadata_validator
DownloadZipResult._all_field_names_ = set(['metadata'])
DownloadZipResult._all_fields_ = [('metadata', DownloadZipResult._metadata_validator)]

FileMetadata._id_validator = Id_validator
FileMetadata._client_modified_validator = common.DropboxTimestamp_validator
FileMetadata._server_modified_validator = common.DropboxTimestamp_validator
FileMetadata._rev_validator = Rev_validator
FileMetadata._size_validator = bv.UInt64()
FileMetadata._media_info_validator = bv.Nullable(MediaInfo_validator)
FileMetadata._symlink_info_validator = bv.Nullable(SymlinkInfo_validator)
FileMetadata._sharing_info_validator = bv.Nullable(FileSharingInfo_validator)
FileMetadata._property_groups_validator = bv.Nullable(bv.List(file_properties.PropertyGroup_validator))
FileMetadata._has_explicit_shared_members_validator = bv.Nullable(bv.Boolean())
FileMetadata._content_hash_validator = bv.Nullable(Sha256HexHash_validator)
FileMetadata._field_names_ = set([
    'id',
    'client_modified',
    'server_modified',
    'rev',
    'size',
    'media_info',
    'symlink_info',
    'sharing_info',
    'property_groups',
    'has_explicit_shared_members',
    'content_hash',
])
FileMetadata._all_field_names_ = Metadata._all_field_names_.union(FileMetadata._field_names_)
FileMetadata._fields_ = [
    ('id', FileMetadata._id_validator),
    ('client_modified', FileMetadata._client_modified_validator),
    ('server_modified', FileMetadata._server_modified_validator),
    ('rev', FileMetadata._rev_validator),
    ('size', FileMetadata._size_validator),
    ('media_info', FileMetadata._media_info_validator),
    ('symlink_info', FileMetadata._symlink_info_validator),
    ('sharing_info', FileMetadata._sharing_info_validator),
    ('property_groups', FileMetadata._property_groups_validator),
    ('has_explicit_shared_members', FileMetadata._has_explicit_shared_members_validator),
    ('content_hash', FileMetadata._content_hash_validator),
]
FileMetadata._all_fields_ = Metadata._all_fields_ + FileMetadata._fields_

SharingInfo._read_only_validator = bv.Boolean()
SharingInfo._all_field_names_ = set(['read_only'])
SharingInfo._all_fields_ = [('read_only', SharingInfo._read_only_validator)]

FileSharingInfo._parent_shared_folder_id_validator = common.SharedFolderId_validator
FileSharingInfo._modified_by_validator = bv.Nullable(users_common.AccountId_validator)
FileSharingInfo._all_field_names_ = SharingInfo._all_field_names_.union(set([
    'parent_shared_folder_id',
    'modified_by',
]))
FileSharingInfo._all_fields_ = SharingInfo._all_fields_ + [
    ('parent_shared_folder_id', FileSharingInfo._parent_shared_folder_id_validator),
    ('modified_by', FileSharingInfo._modified_by_validator),
]

FolderMetadata._id_validator = Id_validator
FolderMetadata._shared_folder_id_validator = bv.Nullable(common.SharedFolderId_validator)
FolderMetadata._sharing_info_validator = bv.Nullable(FolderSharingInfo_validator)
FolderMetadata._property_groups_validator = bv.Nullable(bv.List(file_properties.PropertyGroup_validator))
FolderMetadata._field_names_ = set([
    'id',
    'shared_folder_id',
    'sharing_info',
    'property_groups',
])
FolderMetadata._all_field_names_ = Metadata._all_field_names_.union(FolderMetadata._field_names_)
FolderMetadata._fields_ = [
    ('id', FolderMetadata._id_validator),
    ('shared_folder_id', FolderMetadata._shared_folder_id_validator),
    ('sharing_info', FolderMetadata._sharing_info_validator),
    ('property_groups', FolderMetadata._property_groups_validator),
]
FolderMetadata._all_fields_ = Metadata._all_fields_ + FolderMetadata._fields_

FolderSharingInfo._parent_shared_folder_id_validator = bv.Nullable(common.SharedFolderId_validator)
FolderSharingInfo._shared_folder_id_validator = bv.Nullable(common.SharedFolderId_validator)
FolderSharingInfo._traverse_only_validator = bv.Boolean()
FolderSharingInfo._no_access_validator = bv.Boolean()
FolderSharingInfo._all_field_names_ = SharingInfo._all_field_names_.union(set([
    'parent_shared_folder_id',
    'shared_folder_id',
    'traverse_only',
    'no_access',
]))
FolderSharingInfo._all_fields_ = SharingInfo._all_fields_ + [
    ('parent_shared_folder_id', FolderSharingInfo._parent_shared_folder_id_validator),
    ('shared_folder_id', FolderSharingInfo._shared_folder_id_validator),
    ('traverse_only', FolderSharingInfo._traverse_only_validator),
    ('no_access', FolderSharingInfo._no_access_validator),
]

GetCopyReferenceArg._path_validator = ReadPath_validator
GetCopyReferenceArg._all_field_names_ = set(['path'])
GetCopyReferenceArg._all_fields_ = [('path', GetCopyReferenceArg._path_validator)]

GetCopyReferenceError._path_validator = LookupError_validator
GetCopyReferenceError._other_validator = bv.Void()
GetCopyReferenceError._tagmap = {
    'path': GetCopyReferenceError._path_validator,
    'other': GetCopyReferenceError._other_validator,
}

GetCopyReferenceError.other = GetCopyReferenceError('other')

GetCopyReferenceResult._metadata_validator = Metadata_validator
GetCopyReferenceResult._copy_reference_validator = bv.String()
GetCopyReferenceResult._expires_validator = common.DropboxTimestamp_validator
GetCopyReferenceResult._all_field_names_ = set([
    'metadata',
    'copy_reference',
    'expires',
])
GetCopyReferenceResult._all_fields_ = [
    ('metadata', GetCopyReferenceResult._metadata_validator),
    ('copy_reference', GetCopyReferenceResult._copy_reference_validator),
    ('expires', GetCopyReferenceResult._expires_validator),
]

GetTemporaryLinkArg._path_validator = ReadPath_validator
GetTemporaryLinkArg._all_field_names_ = set(['path'])
GetTemporaryLinkArg._all_fields_ = [('path', GetTemporaryLinkArg._path_validator)]

GetTemporaryLinkError._path_validator = LookupError_validator
GetTemporaryLinkError._other_validator = bv.Void()
GetTemporaryLinkError._tagmap = {
    'path': GetTemporaryLinkError._path_validator,
    'other': GetTemporaryLinkError._other_validator,
}

GetTemporaryLinkError.other = GetTemporaryLinkError('other')

GetTemporaryLinkResult._metadata_validator = FileMetadata_validator
GetTemporaryLinkResult._link_validator = bv.String()
GetTemporaryLinkResult._all_field_names_ = set([
    'metadata',
    'link',
])
GetTemporaryLinkResult._all_fields_ = [
    ('metadata', GetTemporaryLinkResult._metadata_validator),
    ('link', GetTemporaryLinkResult._link_validator),
]

GetThumbnailBatchArg._entries_validator = bv.List(ThumbnailArg_validator)
GetThumbnailBatchArg._all_field_names_ = set(['entries'])
GetThumbnailBatchArg._all_fields_ = [('entries', GetThumbnailBatchArg._entries_validator)]

GetThumbnailBatchError._too_many_files_validator = bv.Void()
GetThumbnailBatchError._other_validator = bv.Void()
GetThumbnailBatchError._tagmap = {
    'too_many_files': GetThumbnailBatchError._too_many_files_validator,
    'other': GetThumbnailBatchError._other_validator,
}

GetThumbnailBatchError.too_many_files = GetThumbnailBatchError('too_many_files')
GetThumbnailBatchError.other = GetThumbnailBatchError('other')

GetThumbnailBatchResult._entries_validator = bv.List(GetThumbnailBatchResultEntry_validator)
GetThumbnailBatchResult._all_field_names_ = set(['entries'])
GetThumbnailBatchResult._all_fields_ = [('entries', GetThumbnailBatchResult._entries_validator)]

GetThumbnailBatchResultData._metadata_validator = FileMetadata_validator
GetThumbnailBatchResultData._thumbnail_validator = bv.String()
GetThumbnailBatchResultData._all_field_names_ = set([
    'metadata',
    'thumbnail',
])
GetThumbnailBatchResultData._all_fields_ = [
    ('metadata', GetThumbnailBatchResultData._metadata_validator),
    ('thumbnail', GetThumbnailBatchResultData._thumbnail_validator),
]

GetThumbnailBatchResultEntry._success_validator = GetThumbnailBatchResultData_validator
GetThumbnailBatchResultEntry._failure_validator = ThumbnailError_validator
GetThumbnailBatchResultEntry._other_validator = bv.Void()
GetThumbnailBatchResultEntry._tagmap = {
    'success': GetThumbnailBatchResultEntry._success_validator,
    'failure': GetThumbnailBatchResultEntry._failure_validator,
    'other': GetThumbnailBatchResultEntry._other_validator,
}

GetThumbnailBatchResultEntry.other = GetThumbnailBatchResultEntry('other')

GpsCoordinates._latitude_validator = bv.Float64()
GpsCoordinates._longitude_validator = bv.Float64()
GpsCoordinates._all_field_names_ = set([
    'latitude',
    'longitude',
])
GpsCoordinates._all_fields_ = [
    ('latitude', GpsCoordinates._latitude_validator),
    ('longitude', GpsCoordinates._longitude_validator),
]

ListFolderArg._path_validator = PathROrId_validator
ListFolderArg._recursive_validator = bv.Boolean()
ListFolderArg._include_media_info_validator = bv.Boolean()
ListFolderArg._include_deleted_validator = bv.Boolean()
ListFolderArg._include_has_explicit_shared_members_validator = bv.Boolean()
ListFolderArg._include_mounted_folders_validator = bv.Boolean()
ListFolderArg._limit_validator = bv.Nullable(bv.UInt32(min_value=1, max_value=2000))
ListFolderArg._shared_link_validator = bv.Nullable(SharedLink_validator)
ListFolderArg._include_property_groups_validator = bv.Nullable(file_properties.TemplateFilterBase_validator)
ListFolderArg._all_field_names_ = set([
    'path',
    'recursive',
    'include_media_info',
    'include_deleted',
    'include_has_explicit_shared_members',
    'include_mounted_folders',
    'limit',
    'shared_link',
    'include_property_groups',
])
ListFolderArg._all_fields_ = [
    ('path', ListFolderArg._path_validator),
    ('recursive', ListFolderArg._recursive_validator),
    ('include_media_info', ListFolderArg._include_media_info_validator),
    ('include_deleted', ListFolderArg._include_deleted_validator),
    ('include_has_explicit_shared_members', ListFolderArg._include_has_explicit_shared_members_validator),
    ('include_mounted_folders', ListFolderArg._include_mounted_folders_validator),
    ('limit', ListFolderArg._limit_validator),
    ('shared_link', ListFolderArg._shared_link_validator),
    ('include_property_groups', ListFolderArg._include_property_groups_validator),
]

ListFolderContinueArg._cursor_validator = ListFolderCursor_validator
ListFolderContinueArg._all_field_names_ = set(['cursor'])
ListFolderContinueArg._all_fields_ = [('cursor', ListFolderContinueArg._cursor_validator)]

ListFolderContinueError._path_validator = LookupError_validator
ListFolderContinueError._reset_validator = bv.Void()
ListFolderContinueError._other_validator = bv.Void()
ListFolderContinueError._tagmap = {
    'path': ListFolderContinueError._path_validator,
    'reset': ListFolderContinueError._reset_validator,
    'other': ListFolderContinueError._other_validator,
}

ListFolderContinueError.reset = ListFolderContinueError('reset')
ListFolderContinueError.other = ListFolderContinueError('other')

ListFolderError._path_validator = LookupError_validator
ListFolderError._other_validator = bv.Void()
ListFolderError._tagmap = {
    'path': ListFolderError._path_validator,
    'other': ListFolderError._other_validator,
}

ListFolderError.other = ListFolderError('other')

ListFolderGetLatestCursorResult._cursor_validator = ListFolderCursor_validator
ListFolderGetLatestCursorResult._all_field_names_ = set(['cursor'])
ListFolderGetLatestCursorResult._all_fields_ = [('cursor', ListFolderGetLatestCursorResult._cursor_validator)]

ListFolderLongpollArg._cursor_validator = ListFolderCursor_validator
ListFolderLongpollArg._timeout_validator = bv.UInt64(min_value=30, max_value=480)
ListFolderLongpollArg._all_field_names_ = set([
    'cursor',
    'timeout',
])
ListFolderLongpollArg._all_fields_ = [
    ('cursor', ListFolderLongpollArg._cursor_validator),
    ('timeout', ListFolderLongpollArg._timeout_validator),
]

ListFolderLongpollError._reset_validator = bv.Void()
ListFolderLongpollError._other_validator = bv.Void()
ListFolderLongpollError._tagmap = {
    'reset': ListFolderLongpollError._reset_validator,
    'other': ListFolderLongpollError._other_validator,
}

ListFolderLongpollError.reset = ListFolderLongpollError('reset')
ListFolderLongpollError.other = ListFolderLongpollError('other')

ListFolderLongpollResult._changes_validator = bv.Boolean()
ListFolderLongpollResult._backoff_validator = bv.Nullable(bv.UInt64())
ListFolderLongpollResult._all_field_names_ = set([
    'changes',
    'backoff',
])
ListFolderLongpollResult._all_fields_ = [
    ('changes', ListFolderLongpollResult._changes_validator),
    ('backoff', ListFolderLongpollResult._backoff_validator),
]

ListFolderResult._entries_validator = bv.List(Metadata_validator)
ListFolderResult._cursor_validator = ListFolderCursor_validator
ListFolderResult._has_more_validator = bv.Boolean()
ListFolderResult._all_field_names_ = set([
    'entries',
    'cursor',
    'has_more',
])
ListFolderResult._all_fields_ = [
    ('entries', ListFolderResult._entries_validator),
    ('cursor', ListFolderResult._cursor_validator),
    ('has_more', ListFolderResult._has_more_validator),
]

ListRevisionsArg._path_validator = PathOrId_validator
ListRevisionsArg._mode_validator = ListRevisionsMode_validator
ListRevisionsArg._limit_validator = bv.UInt64(min_value=1, max_value=100)
ListRevisionsArg._all_field_names_ = set([
    'path',
    'mode',
    'limit',
])
ListRevisionsArg._all_fields_ = [
    ('path', ListRevisionsArg._path_validator),
    ('mode', ListRevisionsArg._mode_validator),
    ('limit', ListRevisionsArg._limit_validator),
]

ListRevisionsError._path_validator = LookupError_validator
ListRevisionsError._other_validator = bv.Void()
ListRevisionsError._tagmap = {
    'path': ListRevisionsError._path_validator,
    'other': ListRevisionsError._other_validator,
}

ListRevisionsError.other = ListRevisionsError('other')

ListRevisionsMode._path_validator = bv.Void()
ListRevisionsMode._id_validator = bv.Void()
ListRevisionsMode._other_validator = bv.Void()
ListRevisionsMode._tagmap = {
    'path': ListRevisionsMode._path_validator,
    'id': ListRevisionsMode._id_validator,
    'other': ListRevisionsMode._other_validator,
}

ListRevisionsMode.path = ListRevisionsMode('path')
ListRevisionsMode.id = ListRevisionsMode('id')
ListRevisionsMode.other = ListRevisionsMode('other')

ListRevisionsResult._is_deleted_validator = bv.Boolean()
ListRevisionsResult._server_deleted_validator = bv.Nullable(common.DropboxTimestamp_validator)
ListRevisionsResult._entries_validator = bv.List(FileMetadata_validator)
ListRevisionsResult._all_field_names_ = set([
    'is_deleted',
    'server_deleted',
    'entries',
])
ListRevisionsResult._all_fields_ = [
    ('is_deleted', ListRevisionsResult._is_deleted_validator),
    ('server_deleted', ListRevisionsResult._server_deleted_validator),
    ('entries', ListRevisionsResult._entries_validator),
]

LookupError._malformed_path_validator = MalformedPathError_validator
LookupError._not_found_validator = bv.Void()
LookupError._not_file_validator = bv.Void()
LookupError._not_folder_validator = bv.Void()
LookupError._restricted_content_validator = bv.Void()
LookupError._other_validator = bv.Void()
LookupError._tagmap = {
    'malformed_path': LookupError._malformed_path_validator,
    'not_found': LookupError._not_found_validator,
    'not_file': LookupError._not_file_validator,
    'not_folder': LookupError._not_folder_validator,
    'restricted_content': LookupError._restricted_content_validator,
    'other': LookupError._other_validator,
}

LookupError.not_found = LookupError('not_found')
LookupError.not_file = LookupError('not_file')
LookupError.not_folder = LookupError('not_folder')
LookupError.restricted_content = LookupError('restricted_content')
LookupError.other = LookupError('other')

MediaInfo._pending_validator = bv.Void()
MediaInfo._metadata_validator = MediaMetadata_validator
MediaInfo._tagmap = {
    'pending': MediaInfo._pending_validator,
    'metadata': MediaInfo._metadata_validator,
}

MediaInfo.pending = MediaInfo('pending')

MediaMetadata._dimensions_validator = bv.Nullable(Dimensions_validator)
MediaMetadata._location_validator = bv.Nullable(GpsCoordinates_validator)
MediaMetadata._time_taken_validator = bv.Nullable(common.DropboxTimestamp_validator)
MediaMetadata._field_names_ = set([
    'dimensions',
    'location',
    'time_taken',
])
MediaMetadata._all_field_names_ = MediaMetadata._field_names_
MediaMetadata._fields_ = [
    ('dimensions', MediaMetadata._dimensions_validator),
    ('location', MediaMetadata._location_validator),
    ('time_taken', MediaMetadata._time_taken_validator),
]
MediaMetadata._all_fields_ = MediaMetadata._fields_

MediaMetadata._tag_to_subtype_ = {
    (u'photo',): PhotoMetadata_validator,
    (u'video',): VideoMetadata_validator,
}
MediaMetadata._pytype_to_tag_and_subtype_ = {
    PhotoMetadata: ((u'photo',), PhotoMetadata_validator),
    VideoMetadata: ((u'video',), VideoMetadata_validator),
}
MediaMetadata._is_catch_all_ = False

PhotoMetadata._field_names_ = set([])
PhotoMetadata._all_field_names_ = MediaMetadata._all_field_names_.union(PhotoMetadata._field_names_)
PhotoMetadata._fields_ = []
PhotoMetadata._all_fields_ = MediaMetadata._all_fields_ + PhotoMetadata._fields_

PreviewArg._path_validator = ReadPath_validator
PreviewArg._rev_validator = bv.Nullable(Rev_validator)
PreviewArg._all_field_names_ = set([
    'path',
    'rev',
])
PreviewArg._all_fields_ = [
    ('path', PreviewArg._path_validator),
    ('rev', PreviewArg._rev_validator),
]

PreviewError._path_validator = LookupError_validator
PreviewError._in_progress_validator = bv.Void()
PreviewError._unsupported_extension_validator = bv.Void()
PreviewError._unsupported_content_validator = bv.Void()
PreviewError._tagmap = {
    'path': PreviewError._path_validator,
    'in_progress': PreviewError._in_progress_validator,
    'unsupported_extension': PreviewError._unsupported_extension_validator,
    'unsupported_content': PreviewError._unsupported_content_validator,
}

PreviewError.in_progress = PreviewError('in_progress')
PreviewError.unsupported_extension = PreviewError('unsupported_extension')
PreviewError.unsupported_content = PreviewError('unsupported_content')

RelocationPath._from_path_validator = WritePathOrId_validator
RelocationPath._to_path_validator = WritePathOrId_validator
RelocationPath._all_field_names_ = set([
    'from_path',
    'to_path',
])
RelocationPath._all_fields_ = [
    ('from_path', RelocationPath._from_path_validator),
    ('to_path', RelocationPath._to_path_validator),
]

RelocationArg._allow_shared_folder_validator = bv.Boolean()
RelocationArg._autorename_validator = bv.Boolean()
RelocationArg._allow_ownership_transfer_validator = bv.Boolean()
RelocationArg._all_field_names_ = RelocationPath._all_field_names_.union(set([
    'allow_shared_folder',
    'autorename',
    'allow_ownership_transfer',
]))
RelocationArg._all_fields_ = RelocationPath._all_fields_ + [
    ('allow_shared_folder', RelocationArg._allow_shared_folder_validator),
    ('autorename', RelocationArg._autorename_validator),
    ('allow_ownership_transfer', RelocationArg._allow_ownership_transfer_validator),
]

RelocationBatchArg._entries_validator = bv.List(RelocationPath_validator, min_items=1)
RelocationBatchArg._allow_shared_folder_validator = bv.Boolean()
RelocationBatchArg._autorename_validator = bv.Boolean()
RelocationBatchArg._allow_ownership_transfer_validator = bv.Boolean()
RelocationBatchArg._all_field_names_ = set([
    'entries',
    'allow_shared_folder',
    'autorename',
    'allow_ownership_transfer',
])
RelocationBatchArg._all_fields_ = [
    ('entries', RelocationBatchArg._entries_validator),
    ('allow_shared_folder', RelocationBatchArg._allow_shared_folder_validator),
    ('autorename', RelocationBatchArg._autorename_validator),
    ('allow_ownership_transfer', RelocationBatchArg._allow_ownership_transfer_validator),
]

RelocationError._from_lookup_validator = LookupError_validator
RelocationError._from_write_validator = WriteError_validator
RelocationError._to_validator = WriteError_validator
RelocationError._cant_copy_shared_folder_validator = bv.Void()
RelocationError._cant_nest_shared_folder_validator = bv.Void()
RelocationError._cant_move_folder_into_itself_validator = bv.Void()
RelocationError._too_many_files_validator = bv.Void()
RelocationError._duplicated_or_nested_paths_validator = bv.Void()
RelocationError._cant_transfer_ownership_validator = bv.Void()
RelocationError._insufficient_quota_validator = bv.Void()
RelocationError._other_validator = bv.Void()
RelocationError._tagmap = {
    'from_lookup': RelocationError._from_lookup_validator,
    'from_write': RelocationError._from_write_validator,
    'to': RelocationError._to_validator,
    'cant_copy_shared_folder': RelocationError._cant_copy_shared_folder_validator,
    'cant_nest_shared_folder': RelocationError._cant_nest_shared_folder_validator,
    'cant_move_folder_into_itself': RelocationError._cant_move_folder_into_itself_validator,
    'too_many_files': RelocationError._too_many_files_validator,
    'duplicated_or_nested_paths': RelocationError._duplicated_or_nested_paths_validator,
    'cant_transfer_ownership': RelocationError._cant_transfer_ownership_validator,
    'insufficient_quota': RelocationError._insufficient_quota_validator,
    'other': RelocationError._other_validator,
}

RelocationError.cant_copy_shared_folder = RelocationError('cant_copy_shared_folder')
RelocationError.cant_nest_shared_folder = RelocationError('cant_nest_shared_folder')
RelocationError.cant_move_folder_into_itself = RelocationError('cant_move_folder_into_itself')
RelocationError.too_many_files = RelocationError('too_many_files')
RelocationError.duplicated_or_nested_paths = RelocationError('duplicated_or_nested_paths')
RelocationError.cant_transfer_ownership = RelocationError('cant_transfer_ownership')
RelocationError.insufficient_quota = RelocationError('insufficient_quota')
RelocationError.other = RelocationError('other')

RelocationBatchError._too_many_write_operations_validator = bv.Void()
RelocationBatchError._tagmap = {
    'too_many_write_operations': RelocationBatchError._too_many_write_operations_validator,
}
RelocationBatchError._tagmap.update(RelocationError._tagmap)

RelocationBatchError.too_many_write_operations = RelocationBatchError('too_many_write_operations')

RelocationBatchJobStatus._complete_validator = RelocationBatchResult_validator
RelocationBatchJobStatus._failed_validator = RelocationBatchError_validator
RelocationBatchJobStatus._tagmap = {
    'complete': RelocationBatchJobStatus._complete_validator,
    'failed': RelocationBatchJobStatus._failed_validator,
}
RelocationBatchJobStatus._tagmap.update(async_.PollResultBase._tagmap)

RelocationBatchLaunch._complete_validator = RelocationBatchResult_validator
RelocationBatchLaunch._other_validator = bv.Void()
RelocationBatchLaunch._tagmap = {
    'complete': RelocationBatchLaunch._complete_validator,
    'other': RelocationBatchLaunch._other_validator,
}
RelocationBatchLaunch._tagmap.update(async_.LaunchResultBase._tagmap)

RelocationBatchLaunch.other = RelocationBatchLaunch('other')

RelocationBatchResult._entries_validator = bv.List(RelocationBatchResultData_validator)
RelocationBatchResult._all_field_names_ = FileOpsResult._all_field_names_.union(set(['entries']))
RelocationBatchResult._all_fields_ = FileOpsResult._all_fields_ + [('entries', RelocationBatchResult._entries_validator)]

RelocationBatchResultData._metadata_validator = Metadata_validator
RelocationBatchResultData._all_field_names_ = set(['metadata'])
RelocationBatchResultData._all_fields_ = [('metadata', RelocationBatchResultData._metadata_validator)]

RelocationResult._metadata_validator = Metadata_validator
RelocationResult._all_field_names_ = FileOpsResult._all_field_names_.union(set(['metadata']))
RelocationResult._all_fields_ = FileOpsResult._all_fields_ + [('metadata', RelocationResult._metadata_validator)]

RestoreArg._path_validator = WritePath_validator
RestoreArg._rev_validator = Rev_validator
RestoreArg._all_field_names_ = set([
    'path',
    'rev',
])
RestoreArg._all_fields_ = [
    ('path', RestoreArg._path_validator),
    ('rev', RestoreArg._rev_validator),
]

RestoreError._path_lookup_validator = LookupError_validator
RestoreError._path_write_validator = WriteError_validator
RestoreError._invalid_revision_validator = bv.Void()
RestoreError._other_validator = bv.Void()
RestoreError._tagmap = {
    'path_lookup': RestoreError._path_lookup_validator,
    'path_write': RestoreError._path_write_validator,
    'invalid_revision': RestoreError._invalid_revision_validator,
    'other': RestoreError._other_validator,
}

RestoreError.invalid_revision = RestoreError('invalid_revision')
RestoreError.other = RestoreError('other')

SaveCopyReferenceArg._copy_reference_validator = bv.String()
SaveCopyReferenceArg._path_validator = Path_validator
SaveCopyReferenceArg._all_field_names_ = set([
    'copy_reference',
    'path',
])
SaveCopyReferenceArg._all_fields_ = [
    ('copy_reference', SaveCopyReferenceArg._copy_reference_validator),
    ('path', SaveCopyReferenceArg._path_validator),
]

SaveCopyReferenceError._path_validator = WriteError_validator
SaveCopyReferenceError._invalid_copy_reference_validator = bv.Void()
SaveCopyReferenceError._no_permission_validator = bv.Void()
SaveCopyReferenceError._not_found_validator = bv.Void()
SaveCopyReferenceError._too_many_files_validator = bv.Void()
SaveCopyReferenceError._other_validator = bv.Void()
SaveCopyReferenceError._tagmap = {
    'path': SaveCopyReferenceError._path_validator,
    'invalid_copy_reference': SaveCopyReferenceError._invalid_copy_reference_validator,
    'no_permission': SaveCopyReferenceError._no_permission_validator,
    'not_found': SaveCopyReferenceError._not_found_validator,
    'too_many_files': SaveCopyReferenceError._too_many_files_validator,
    'other': SaveCopyReferenceError._other_validator,
}

SaveCopyReferenceError.invalid_copy_reference = SaveCopyReferenceError('invalid_copy_reference')
SaveCopyReferenceError.no_permission = SaveCopyReferenceError('no_permission')
SaveCopyReferenceError.not_found = SaveCopyReferenceError('not_found')
SaveCopyReferenceError.too_many_files = SaveCopyReferenceError('too_many_files')
SaveCopyReferenceError.other = SaveCopyReferenceError('other')

SaveCopyReferenceResult._metadata_validator = Metadata_validator
SaveCopyReferenceResult._all_field_names_ = set(['metadata'])
SaveCopyReferenceResult._all_fields_ = [('metadata', SaveCopyReferenceResult._metadata_validator)]

SaveUrlArg._path_validator = Path_validator
SaveUrlArg._url_validator = bv.String()
SaveUrlArg._all_field_names_ = set([
    'path',
    'url',
])
SaveUrlArg._all_fields_ = [
    ('path', SaveUrlArg._path_validator),
    ('url', SaveUrlArg._url_validator),
]

SaveUrlError._path_validator = WriteError_validator
SaveUrlError._download_failed_validator = bv.Void()
SaveUrlError._invalid_url_validator = bv.Void()
SaveUrlError._not_found_validator = bv.Void()
SaveUrlError._other_validator = bv.Void()
SaveUrlError._tagmap = {
    'path': SaveUrlError._path_validator,
    'download_failed': SaveUrlError._download_failed_validator,
    'invalid_url': SaveUrlError._invalid_url_validator,
    'not_found': SaveUrlError._not_found_validator,
    'other': SaveUrlError._other_validator,
}

SaveUrlError.download_failed = SaveUrlError('download_failed')
SaveUrlError.invalid_url = SaveUrlError('invalid_url')
SaveUrlError.not_found = SaveUrlError('not_found')
SaveUrlError.other = SaveUrlError('other')

SaveUrlJobStatus._complete_validator = FileMetadata_validator
SaveUrlJobStatus._failed_validator = SaveUrlError_validator
SaveUrlJobStatus._tagmap = {
    'complete': SaveUrlJobStatus._complete_validator,
    'failed': SaveUrlJobStatus._failed_validator,
}
SaveUrlJobStatus._tagmap.update(async_.PollResultBase._tagmap)

SaveUrlResult._complete_validator = FileMetadata_validator
SaveUrlResult._tagmap = {
    'complete': SaveUrlResult._complete_validator,
}
SaveUrlResult._tagmap.update(async_.LaunchResultBase._tagmap)

SearchArg._path_validator = PathROrId_validator
SearchArg._query_validator = bv.String()
SearchArg._start_validator = bv.UInt64()
SearchArg._max_results_validator = bv.UInt64(min_value=1, max_value=1000)
SearchArg._mode_validator = SearchMode_validator
SearchArg._all_field_names_ = set([
    'path',
    'query',
    'start',
    'max_results',
    'mode',
])
SearchArg._all_fields_ = [
    ('path', SearchArg._path_validator),
    ('query', SearchArg._query_validator),
    ('start', SearchArg._start_validator),
    ('max_results', SearchArg._max_results_validator),
    ('mode', SearchArg._mode_validator),
]

SearchError._path_validator = LookupError_validator
SearchError._other_validator = bv.Void()
SearchError._tagmap = {
    'path': SearchError._path_validator,
    'other': SearchError._other_validator,
}

SearchError.other = SearchError('other')

SearchMatch._match_type_validator = SearchMatchType_validator
SearchMatch._metadata_validator = Metadata_validator
SearchMatch._all_field_names_ = set([
    'match_type',
    'metadata',
])
SearchMatch._all_fields_ = [
    ('match_type', SearchMatch._match_type_validator),
    ('metadata', SearchMatch._metadata_validator),
]

SearchMatchType._filename_validator = bv.Void()
SearchMatchType._content_validator = bv.Void()
SearchMatchType._both_validator = bv.Void()
SearchMatchType._tagmap = {
    'filename': SearchMatchType._filename_validator,
    'content': SearchMatchType._content_validator,
    'both': SearchMatchType._both_validator,
}

SearchMatchType.filename = SearchMatchType('filename')
SearchMatchType.content = SearchMatchType('content')
SearchMatchType.both = SearchMatchType('both')

SearchMode._filename_validator = bv.Void()
SearchMode._filename_and_content_validator = bv.Void()
SearchMode._deleted_filename_validator = bv.Void()
SearchMode._tagmap = {
    'filename': SearchMode._filename_validator,
    'filename_and_content': SearchMode._filename_and_content_validator,
    'deleted_filename': SearchMode._deleted_filename_validator,
}

SearchMode.filename = SearchMode('filename')
SearchMode.filename_and_content = SearchMode('filename_and_content')
SearchMode.deleted_filename = SearchMode('deleted_filename')

SearchResult._matches_validator = bv.List(SearchMatch_validator)
SearchResult._more_validator = bv.Boolean()
SearchResult._start_validator = bv.UInt64()
SearchResult._all_field_names_ = set([
    'matches',
    'more',
    'start',
])
SearchResult._all_fields_ = [
    ('matches', SearchResult._matches_validator),
    ('more', SearchResult._more_validator),
    ('start', SearchResult._start_validator),
]

SharedLink._url_validator = SharedLinkUrl_validator
SharedLink._password_validator = bv.Nullable(bv.String())
SharedLink._all_field_names_ = set([
    'url',
    'password',
])
SharedLink._all_fields_ = [
    ('url', SharedLink._url_validator),
    ('password', SharedLink._password_validator),
]

SymlinkInfo._target_validator = bv.String()
SymlinkInfo._all_field_names_ = set(['target'])
SymlinkInfo._all_fields_ = [('target', SymlinkInfo._target_validator)]

SyncSetting._default_validator = bv.Void()
SyncSetting._not_synced_validator = bv.Void()
SyncSetting._not_synced_inactive_validator = bv.Void()
SyncSetting._other_validator = bv.Void()
SyncSetting._tagmap = {
    'default': SyncSetting._default_validator,
    'not_synced': SyncSetting._not_synced_validator,
    'not_synced_inactive': SyncSetting._not_synced_inactive_validator,
    'other': SyncSetting._other_validator,
}

SyncSetting.default = SyncSetting('default')
SyncSetting.not_synced = SyncSetting('not_synced')
SyncSetting.not_synced_inactive = SyncSetting('not_synced_inactive')
SyncSetting.other = SyncSetting('other')

SyncSettingArg._default_validator = bv.Void()
SyncSettingArg._not_synced_validator = bv.Void()
SyncSettingArg._other_validator = bv.Void()
SyncSettingArg._tagmap = {
    'default': SyncSettingArg._default_validator,
    'not_synced': SyncSettingArg._not_synced_validator,
    'other': SyncSettingArg._other_validator,
}

SyncSettingArg.default = SyncSettingArg('default')
SyncSettingArg.not_synced = SyncSettingArg('not_synced')
SyncSettingArg.other = SyncSettingArg('other')

SyncSettingsError._path_validator = LookupError_validator
SyncSettingsError._unsupported_combination_validator = bv.Void()
SyncSettingsError._unsupported_configuration_validator = bv.Void()
SyncSettingsError._other_validator = bv.Void()
SyncSettingsError._tagmap = {
    'path': SyncSettingsError._path_validator,
    'unsupported_combination': SyncSettingsError._unsupported_combination_validator,
    'unsupported_configuration': SyncSettingsError._unsupported_configuration_validator,
    'other': SyncSettingsError._other_validator,
}

SyncSettingsError.unsupported_combination = SyncSettingsError('unsupported_combination')
SyncSettingsError.unsupported_configuration = SyncSettingsError('unsupported_configuration')
SyncSettingsError.other = SyncSettingsError('other')

ThumbnailArg._path_validator = ReadPath_validator
ThumbnailArg._format_validator = ThumbnailFormat_validator
ThumbnailArg._size_validator = ThumbnailSize_validator
ThumbnailArg._mode_validator = ThumbnailMode_validator
ThumbnailArg._all_field_names_ = set([
    'path',
    'format',
    'size',
    'mode',
])
ThumbnailArg._all_fields_ = [
    ('path', ThumbnailArg._path_validator),
    ('format', ThumbnailArg._format_validator),
    ('size', ThumbnailArg._size_validator),
    ('mode', ThumbnailArg._mode_validator),
]

ThumbnailError._path_validator = LookupError_validator
ThumbnailError._unsupported_extension_validator = bv.Void()
ThumbnailError._unsupported_image_validator = bv.Void()
ThumbnailError._conversion_error_validator = bv.Void()
ThumbnailError._tagmap = {
    'path': ThumbnailError._path_validator,
    'unsupported_extension': ThumbnailError._unsupported_extension_validator,
    'unsupported_image': ThumbnailError._unsupported_image_validator,
    'conversion_error': ThumbnailError._conversion_error_validator,
}

ThumbnailError.unsupported_extension = ThumbnailError('unsupported_extension')
ThumbnailError.unsupported_image = ThumbnailError('unsupported_image')
ThumbnailError.conversion_error = ThumbnailError('conversion_error')

ThumbnailFormat._jpeg_validator = bv.Void()
ThumbnailFormat._png_validator = bv.Void()
ThumbnailFormat._tagmap = {
    'jpeg': ThumbnailFormat._jpeg_validator,
    'png': ThumbnailFormat._png_validator,
}

ThumbnailFormat.jpeg = ThumbnailFormat('jpeg')
ThumbnailFormat.png = ThumbnailFormat('png')

ThumbnailMode._strict_validator = bv.Void()
ThumbnailMode._bestfit_validator = bv.Void()
ThumbnailMode._fitone_bestfit_validator = bv.Void()
ThumbnailMode._tagmap = {
    'strict': ThumbnailMode._strict_validator,
    'bestfit': ThumbnailMode._bestfit_validator,
    'fitone_bestfit': ThumbnailMode._fitone_bestfit_validator,
}

ThumbnailMode.strict = ThumbnailMode('strict')
ThumbnailMode.bestfit = ThumbnailMode('bestfit')
ThumbnailMode.fitone_bestfit = ThumbnailMode('fitone_bestfit')

ThumbnailSize._w32h32_validator = bv.Void()
ThumbnailSize._w64h64_validator = bv.Void()
ThumbnailSize._w128h128_validator = bv.Void()
ThumbnailSize._w256h256_validator = bv.Void()
ThumbnailSize._w480h320_validator = bv.Void()
ThumbnailSize._w640h480_validator = bv.Void()
ThumbnailSize._w960h640_validator = bv.Void()
ThumbnailSize._w1024h768_validator = bv.Void()
ThumbnailSize._w2048h1536_validator = bv.Void()
ThumbnailSize._tagmap = {
    'w32h32': ThumbnailSize._w32h32_validator,
    'w64h64': ThumbnailSize._w64h64_validator,
    'w128h128': ThumbnailSize._w128h128_validator,
    'w256h256': ThumbnailSize._w256h256_validator,
    'w480h320': ThumbnailSize._w480h320_validator,
    'w640h480': ThumbnailSize._w640h480_validator,
    'w960h640': ThumbnailSize._w960h640_validator,
    'w1024h768': ThumbnailSize._w1024h768_validator,
    'w2048h1536': ThumbnailSize._w2048h1536_validator,
}

ThumbnailSize.w32h32 = ThumbnailSize('w32h32')
ThumbnailSize.w64h64 = ThumbnailSize('w64h64')
ThumbnailSize.w128h128 = ThumbnailSize('w128h128')
ThumbnailSize.w256h256 = ThumbnailSize('w256h256')
ThumbnailSize.w480h320 = ThumbnailSize('w480h320')
ThumbnailSize.w640h480 = ThumbnailSize('w640h480')
ThumbnailSize.w960h640 = ThumbnailSize('w960h640')
ThumbnailSize.w1024h768 = ThumbnailSize('w1024h768')
ThumbnailSize.w2048h1536 = ThumbnailSize('w2048h1536')

UploadError._path_validator = UploadWriteFailed_validator
UploadError._properties_error_validator = file_properties.InvalidPropertyGroupError_validator
UploadError._other_validator = bv.Void()
UploadError._tagmap = {
    'path': UploadError._path_validator,
    'properties_error': UploadError._properties_error_validator,
    'other': UploadError._other_validator,
}

UploadError.other = UploadError('other')

UploadErrorWithProperties._tagmap = {
}
UploadErrorWithProperties._tagmap.update(UploadError._tagmap)

UploadSessionAppendArg._cursor_validator = UploadSessionCursor_validator
UploadSessionAppendArg._close_validator = bv.Boolean()
UploadSessionAppendArg._all_field_names_ = set([
    'cursor',
    'close',
])
UploadSessionAppendArg._all_fields_ = [
    ('cursor', UploadSessionAppendArg._cursor_validator),
    ('close', UploadSessionAppendArg._close_validator),
]

UploadSessionCursor._session_id_validator = bv.String()
UploadSessionCursor._offset_validator = bv.UInt64()
UploadSessionCursor._all_field_names_ = set([
    'session_id',
    'offset',
])
UploadSessionCursor._all_fields_ = [
    ('session_id', UploadSessionCursor._session_id_validator),
    ('offset', UploadSessionCursor._offset_validator),
]

UploadSessionFinishArg._cursor_validator = UploadSessionCursor_validator
UploadSessionFinishArg._commit_validator = CommitInfo_validator
UploadSessionFinishArg._all_field_names_ = set([
    'cursor',
    'commit',
])
UploadSessionFinishArg._all_fields_ = [
    ('cursor', UploadSessionFinishArg._cursor_validator),
    ('commit', UploadSessionFinishArg._commit_validator),
]

UploadSessionFinishBatchArg._entries_validator = bv.List(UploadSessionFinishArg_validator, max_items=1000)
UploadSessionFinishBatchArg._all_field_names_ = set(['entries'])
UploadSessionFinishBatchArg._all_fields_ = [('entries', UploadSessionFinishBatchArg._entries_validator)]

UploadSessionFinishBatchJobStatus._complete_validator = UploadSessionFinishBatchResult_validator
UploadSessionFinishBatchJobStatus._tagmap = {
    'complete': UploadSessionFinishBatchJobStatus._complete_validator,
}
UploadSessionFinishBatchJobStatus._tagmap.update(async_.PollResultBase._tagmap)

UploadSessionFinishBatchLaunch._complete_validator = UploadSessionFinishBatchResult_validator
UploadSessionFinishBatchLaunch._other_validator = bv.Void()
UploadSessionFinishBatchLaunch._tagmap = {
    'complete': UploadSessionFinishBatchLaunch._complete_validator,
    'other': UploadSessionFinishBatchLaunch._other_validator,
}
UploadSessionFinishBatchLaunch._tagmap.update(async_.LaunchResultBase._tagmap)

UploadSessionFinishBatchLaunch.other = UploadSessionFinishBatchLaunch('other')

UploadSessionFinishBatchResult._entries_validator = bv.List(UploadSessionFinishBatchResultEntry_validator)
UploadSessionFinishBatchResult._all_field_names_ = set(['entries'])
UploadSessionFinishBatchResult._all_fields_ = [('entries', UploadSessionFinishBatchResult._entries_validator)]

UploadSessionFinishBatchResultEntry._success_validator = FileMetadata_validator
UploadSessionFinishBatchResultEntry._failure_validator = UploadSessionFinishError_validator
UploadSessionFinishBatchResultEntry._tagmap = {
    'success': UploadSessionFinishBatchResultEntry._success_validator,
    'failure': UploadSessionFinishBatchResultEntry._failure_validator,
}

UploadSessionFinishError._lookup_failed_validator = UploadSessionLookupError_validator
UploadSessionFinishError._path_validator = WriteError_validator
UploadSessionFinishError._properties_error_validator = file_properties.InvalidPropertyGroupError_validator
UploadSessionFinishError._too_many_shared_folder_targets_validator = bv.Void()
UploadSessionFinishError._too_many_write_operations_validator = bv.Void()
UploadSessionFinishError._other_validator = bv.Void()
UploadSessionFinishError._tagmap = {
    'lookup_failed': UploadSessionFinishError._lookup_failed_validator,
    'path': UploadSessionFinishError._path_validator,
    'properties_error': UploadSessionFinishError._properties_error_validator,
    'too_many_shared_folder_targets': UploadSessionFinishError._too_many_shared_folder_targets_validator,
    'too_many_write_operations': UploadSessionFinishError._too_many_write_operations_validator,
    'other': UploadSessionFinishError._other_validator,
}

UploadSessionFinishError.too_many_shared_folder_targets = UploadSessionFinishError('too_many_shared_folder_targets')
UploadSessionFinishError.too_many_write_operations = UploadSessionFinishError('too_many_write_operations')
UploadSessionFinishError.other = UploadSessionFinishError('other')

UploadSessionLookupError._not_found_validator = bv.Void()
UploadSessionLookupError._incorrect_offset_validator = UploadSessionOffsetError_validator
UploadSessionLookupError._closed_validator = bv.Void()
UploadSessionLookupError._not_closed_validator = bv.Void()
UploadSessionLookupError._too_large_validator = bv.Void()
UploadSessionLookupError._other_validator = bv.Void()
UploadSessionLookupError._tagmap = {
    'not_found': UploadSessionLookupError._not_found_validator,
    'incorrect_offset': UploadSessionLookupError._incorrect_offset_validator,
    'closed': UploadSessionLookupError._closed_validator,
    'not_closed': UploadSessionLookupError._not_closed_validator,
    'too_large': UploadSessionLookupError._too_large_validator,
    'other': UploadSessionLookupError._other_validator,
}

UploadSessionLookupError.not_found = UploadSessionLookupError('not_found')
UploadSessionLookupError.closed = UploadSessionLookupError('closed')
UploadSessionLookupError.not_closed = UploadSessionLookupError('not_closed')
UploadSessionLookupError.too_large = UploadSessionLookupError('too_large')
UploadSessionLookupError.other = UploadSessionLookupError('other')

UploadSessionOffsetError._correct_offset_validator = bv.UInt64()
UploadSessionOffsetError._all_field_names_ = set(['correct_offset'])
UploadSessionOffsetError._all_fields_ = [('correct_offset', UploadSessionOffsetError._correct_offset_validator)]

UploadSessionStartArg._close_validator = bv.Boolean()
UploadSessionStartArg._all_field_names_ = set(['close'])
UploadSessionStartArg._all_fields_ = [('close', UploadSessionStartArg._close_validator)]

UploadSessionStartResult._session_id_validator = bv.String()
UploadSessionStartResult._all_field_names_ = set(['session_id'])
UploadSessionStartResult._all_fields_ = [('session_id', UploadSessionStartResult._session_id_validator)]

UploadWriteFailed._reason_validator = WriteError_validator
UploadWriteFailed._upload_session_id_validator = bv.String()
UploadWriteFailed._all_field_names_ = set([
    'reason',
    'upload_session_id',
])
UploadWriteFailed._all_fields_ = [
    ('reason', UploadWriteFailed._reason_validator),
    ('upload_session_id', UploadWriteFailed._upload_session_id_validator),
]

VideoMetadata._duration_validator = bv.Nullable(bv.UInt64())
VideoMetadata._field_names_ = set(['duration'])
VideoMetadata._all_field_names_ = MediaMetadata._all_field_names_.union(VideoMetadata._field_names_)
VideoMetadata._fields_ = [('duration', VideoMetadata._duration_validator)]
VideoMetadata._all_fields_ = MediaMetadata._all_fields_ + VideoMetadata._fields_

WriteConflictError._file_validator = bv.Void()
WriteConflictError._folder_validator = bv.Void()
WriteConflictError._file_ancestor_validator = bv.Void()
WriteConflictError._other_validator = bv.Void()
WriteConflictError._tagmap = {
    'file': WriteConflictError._file_validator,
    'folder': WriteConflictError._folder_validator,
    'file_ancestor': WriteConflictError._file_ancestor_validator,
    'other': WriteConflictError._other_validator,
}

WriteConflictError.file = WriteConflictError('file')
WriteConflictError.folder = WriteConflictError('folder')
WriteConflictError.file_ancestor = WriteConflictError('file_ancestor')
WriteConflictError.other = WriteConflictError('other')

WriteError._malformed_path_validator = MalformedPathError_validator
WriteError._conflict_validator = WriteConflictError_validator
WriteError._no_write_permission_validator = bv.Void()
WriteError._insufficient_space_validator = bv.Void()
WriteError._disallowed_name_validator = bv.Void()
WriteError._team_folder_validator = bv.Void()
WriteError._too_many_write_operations_validator = bv.Void()
WriteError._other_validator = bv.Void()
WriteError._tagmap = {
    'malformed_path': WriteError._malformed_path_validator,
    'conflict': WriteError._conflict_validator,
    'no_write_permission': WriteError._no_write_permission_validator,
    'insufficient_space': WriteError._insufficient_space_validator,
    'disallowed_name': WriteError._disallowed_name_validator,
    'team_folder': WriteError._team_folder_validator,
    'too_many_write_operations': WriteError._too_many_write_operations_validator,
    'other': WriteError._other_validator,
}

WriteError.no_write_permission = WriteError('no_write_permission')
WriteError.insufficient_space = WriteError('insufficient_space')
WriteError.disallowed_name = WriteError('disallowed_name')
WriteError.team_folder = WriteError('team_folder')
WriteError.too_many_write_operations = WriteError('too_many_write_operations')
WriteError.other = WriteError('other')

WriteMode._add_validator = bv.Void()
WriteMode._overwrite_validator = bv.Void()
WriteMode._update_validator = Rev_validator
WriteMode._tagmap = {
    'add': WriteMode._add_validator,
    'overwrite': WriteMode._overwrite_validator,
    'update': WriteMode._update_validator,
}

WriteMode.add = WriteMode('add')
WriteMode.overwrite = WriteMode('overwrite')

alpha_get_metadata = bb.Route(
    'alpha/get_metadata',
    1,
    True,
    AlphaGetMetadataArg_validator,
    Metadata_validator,
    AlphaGetMetadataError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
alpha_upload = bb.Route(
    'alpha/upload',
    1,
    True,
    CommitInfoWithProperties_validator,
    FileMetadata_validator,
    UploadErrorWithProperties_validator,
    {'host': u'content',
     'style': u'upload'},
)
copy = bb.Route(
    'copy',
    1,
    True,
    RelocationArg_validator,
    Metadata_validator,
    RelocationError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
copy_batch = bb.Route(
    'copy_batch',
    1,
    False,
    RelocationBatchArg_validator,
    RelocationBatchLaunch_validator,
    bv.Void(),
    {'host': u'api',
     'style': u'rpc'},
)
copy_batch_check = bb.Route(
    'copy_batch/check',
    1,
    False,
    async_.PollArg_validator,
    RelocationBatchJobStatus_validator,
    async_.PollError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
copy_reference_get = bb.Route(
    'copy_reference/get',
    1,
    False,
    GetCopyReferenceArg_validator,
    GetCopyReferenceResult_validator,
    GetCopyReferenceError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
copy_reference_save = bb.Route(
    'copy_reference/save',
    1,
    False,
    SaveCopyReferenceArg_validator,
    SaveCopyReferenceResult_validator,
    SaveCopyReferenceError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
copy_v2 = bb.Route(
    'copy_v2',
    1,
    False,
    RelocationArg_validator,
    RelocationResult_validator,
    RelocationError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
create_folder = bb.Route(
    'create_folder',
    1,
    True,
    CreateFolderArg_validator,
    FolderMetadata_validator,
    CreateFolderError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
create_folder_batch = bb.Route(
    'create_folder_batch',
    1,
    False,
    CreateFolderBatchArg_validator,
    CreateFolderBatchLaunch_validator,
    bv.Void(),
    {'host': u'api',
     'style': u'rpc'},
)
create_folder_batch_check = bb.Route(
    'create_folder_batch/check',
    1,
    False,
    async_.PollArg_validator,
    CreateFolderBatchJobStatus_validator,
    async_.PollError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
create_folder_v2 = bb.Route(
    'create_folder_v2',
    1,
    False,
    CreateFolderArg_validator,
    CreateFolderResult_validator,
    CreateFolderError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
delete = bb.Route(
    'delete',
    1,
    True,
    DeleteArg_validator,
    Metadata_validator,
    DeleteError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
delete_batch = bb.Route(
    'delete_batch',
    1,
    False,
    DeleteBatchArg_validator,
    DeleteBatchLaunch_validator,
    bv.Void(),
    {'host': u'api',
     'style': u'rpc'},
)
delete_batch_check = bb.Route(
    'delete_batch/check',
    1,
    False,
    async_.PollArg_validator,
    DeleteBatchJobStatus_validator,
    async_.PollError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
delete_v2 = bb.Route(
    'delete_v2',
    1,
    False,
    DeleteArg_validator,
    DeleteResult_validator,
    DeleteError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
download = bb.Route(
    'download',
    1,
    False,
    DownloadArg_validator,
    FileMetadata_validator,
    DownloadError_validator,
    {'host': u'content',
     'style': u'download'},
)
download_zip = bb.Route(
    'download_zip',
    1,
    False,
    DownloadZipArg_validator,
    DownloadZipResult_validator,
    DownloadZipError_validator,
    {'host': u'content',
     'style': u'download'},
)
get_metadata = bb.Route(
    'get_metadata',
    1,
    False,
    GetMetadataArg_validator,
    Metadata_validator,
    GetMetadataError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
get_preview = bb.Route(
    'get_preview',
    1,
    False,
    PreviewArg_validator,
    FileMetadata_validator,
    PreviewError_validator,
    {'host': u'content',
     'style': u'download'},
)
get_temporary_link = bb.Route(
    'get_temporary_link',
    1,
    False,
    GetTemporaryLinkArg_validator,
    GetTemporaryLinkResult_validator,
    GetTemporaryLinkError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
get_thumbnail = bb.Route(
    'get_thumbnail',
    1,
    False,
    ThumbnailArg_validator,
    FileMetadata_validator,
    ThumbnailError_validator,
    {'host': u'content',
     'style': u'download'},
)
get_thumbnail_batch = bb.Route(
    'get_thumbnail_batch',
    1,
    False,
    GetThumbnailBatchArg_validator,
    GetThumbnailBatchResult_validator,
    GetThumbnailBatchError_validator,
    {'host': u'content',
     'style': u'rpc'},
)
list_folder = bb.Route(
    'list_folder',
    1,
    False,
    ListFolderArg_validator,
    ListFolderResult_validator,
    ListFolderError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
list_folder_continue = bb.Route(
    'list_folder/continue',
    1,
    False,
    ListFolderContinueArg_validator,
    ListFolderResult_validator,
    ListFolderContinueError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
list_folder_get_latest_cursor = bb.Route(
    'list_folder/get_latest_cursor',
    1,
    False,
    ListFolderArg_validator,
    ListFolderGetLatestCursorResult_validator,
    ListFolderError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
list_folder_longpoll = bb.Route(
    'list_folder/longpoll',
    1,
    False,
    ListFolderLongpollArg_validator,
    ListFolderLongpollResult_validator,
    ListFolderLongpollError_validator,
    {'host': u'notify',
     'style': u'rpc'},
)
list_revisions = bb.Route(
    'list_revisions',
    1,
    False,
    ListRevisionsArg_validator,
    ListRevisionsResult_validator,
    ListRevisionsError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
move = bb.Route(
    'move',
    1,
    True,
    RelocationArg_validator,
    Metadata_validator,
    RelocationError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
move_batch = bb.Route(
    'move_batch',
    1,
    False,
    RelocationBatchArg_validator,
    RelocationBatchLaunch_validator,
    bv.Void(),
    {'host': u'api',
     'style': u'rpc'},
)
move_batch_check = bb.Route(
    'move_batch/check',
    1,
    False,
    async_.PollArg_validator,
    RelocationBatchJobStatus_validator,
    async_.PollError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
move_v2 = bb.Route(
    'move_v2',
    1,
    False,
    RelocationArg_validator,
    RelocationResult_validator,
    RelocationError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
permanently_delete = bb.Route(
    'permanently_delete',
    1,
    False,
    DeleteArg_validator,
    bv.Void(),
    DeleteError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
properties_add = bb.Route(
    'properties/add',
    1,
    True,
    file_properties.AddPropertiesArg_validator,
    bv.Void(),
    file_properties.AddPropertiesError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
properties_overwrite = bb.Route(
    'properties/overwrite',
    1,
    True,
    file_properties.OverwritePropertyGroupArg_validator,
    bv.Void(),
    file_properties.InvalidPropertyGroupError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
properties_remove = bb.Route(
    'properties/remove',
    1,
    True,
    file_properties.RemovePropertiesArg_validator,
    bv.Void(),
    file_properties.RemovePropertiesError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
properties_template_get = bb.Route(
    'properties/template/get',
    1,
    True,
    file_properties.GetTemplateArg_validator,
    file_properties.GetTemplateResult_validator,
    file_properties.TemplateError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
properties_template_list = bb.Route(
    'properties/template/list',
    1,
    True,
    bv.Void(),
    file_properties.ListTemplateResult_validator,
    file_properties.TemplateError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
properties_update = bb.Route(
    'properties/update',
    1,
    True,
    file_properties.UpdatePropertiesArg_validator,
    bv.Void(),
    file_properties.UpdatePropertiesError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
restore = bb.Route(
    'restore',
    1,
    False,
    RestoreArg_validator,
    FileMetadata_validator,
    RestoreError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
save_url = bb.Route(
    'save_url',
    1,
    False,
    SaveUrlArg_validator,
    SaveUrlResult_validator,
    SaveUrlError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
save_url_check_job_status = bb.Route(
    'save_url/check_job_status',
    1,
    False,
    async_.PollArg_validator,
    SaveUrlJobStatus_validator,
    async_.PollError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
search = bb.Route(
    'search',
    1,
    False,
    SearchArg_validator,
    SearchResult_validator,
    SearchError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
upload = bb.Route(
    'upload',
    1,
    False,
    CommitInfo_validator,
    FileMetadata_validator,
    UploadError_validator,
    {'host': u'content',
     'style': u'upload'},
)
upload_session_append = bb.Route(
    'upload_session/append',
    1,
    True,
    UploadSessionCursor_validator,
    bv.Void(),
    UploadSessionLookupError_validator,
    {'host': u'content',
     'style': u'upload'},
)
upload_session_append_v2 = bb.Route(
    'upload_session/append_v2',
    1,
    False,
    UploadSessionAppendArg_validator,
    bv.Void(),
    UploadSessionLookupError_validator,
    {'host': u'content',
     'style': u'upload'},
)
upload_session_finish = bb.Route(
    'upload_session/finish',
    1,
    False,
    UploadSessionFinishArg_validator,
    FileMetadata_validator,
    UploadSessionFinishError_validator,
    {'host': u'content',
     'style': u'upload'},
)
upload_session_finish_batch = bb.Route(
    'upload_session/finish_batch',
    1,
    False,
    UploadSessionFinishBatchArg_validator,
    UploadSessionFinishBatchLaunch_validator,
    bv.Void(),
    {'host': u'api',
     'style': u'rpc'},
)
upload_session_finish_batch_check = bb.Route(
    'upload_session/finish_batch/check',
    1,
    False,
    async_.PollArg_validator,
    UploadSessionFinishBatchJobStatus_validator,
    async_.PollError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
upload_session_start = bb.Route(
    'upload_session/start',
    1,
    False,
    UploadSessionStartArg_validator,
    UploadSessionStartResult_validator,
    bv.Void(),
    {'host': u'content',
     'style': u'upload'},
)

ROUTES = {
    'alpha/get_metadata': alpha_get_metadata,
    'alpha/upload': alpha_upload,
    'copy': copy,
    'copy_batch': copy_batch,
    'copy_batch/check': copy_batch_check,
    'copy_reference/get': copy_reference_get,
    'copy_reference/save': copy_reference_save,
    'copy_v2': copy_v2,
    'create_folder': create_folder,
    'create_folder_batch': create_folder_batch,
    'create_folder_batch/check': create_folder_batch_check,
    'create_folder_v2': create_folder_v2,
    'delete': delete,
    'delete_batch': delete_batch,
    'delete_batch/check': delete_batch_check,
    'delete_v2': delete_v2,
    'download': download,
    'download_zip': download_zip,
    'get_metadata': get_metadata,
    'get_preview': get_preview,
    'get_temporary_link': get_temporary_link,
    'get_thumbnail': get_thumbnail,
    'get_thumbnail_batch': get_thumbnail_batch,
    'list_folder': list_folder,
    'list_folder/continue': list_folder_continue,
    'list_folder/get_latest_cursor': list_folder_get_latest_cursor,
    'list_folder/longpoll': list_folder_longpoll,
    'list_revisions': list_revisions,
    'move': move,
    'move_batch': move_batch,
    'move_batch/check': move_batch_check,
    'move_v2': move_v2,
    'permanently_delete': permanently_delete,
    'properties/add': properties_add,
    'properties/overwrite': properties_overwrite,
    'properties/remove': properties_remove,
    'properties/template/get': properties_template_get,
    'properties/template/list': properties_template_list,
    'properties/update': properties_update,
    'restore': restore,
    'save_url': save_url,
    'save_url/check_job_status': save_url_check_job_status,
    'search': search,
    'upload': upload,
    'upload_session/append': upload_session_append,
    'upload_session/append_v2': upload_session_append_v2,
    'upload_session/finish': upload_session_finish,
    'upload_session/finish_batch': upload_session_finish_batch,
    'upload_session/finish_batch/check': upload_session_finish_batch_check,
    'upload_session/start': upload_session_start,
}

