/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.File;
import java.io.Serializable;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.AnalysisCallback;
import sbt.internal.inc.ClassFileManager$;
import sbt.internal.inc.IncrementalNameHashing;
import sbt.internal.inc.InitialChanges;
import sbt.internal.inc.Lookup;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.math.Equiv;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import xsbti.compile.ClassFileManager;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.DependencyChanges;
import xsbti.compile.IncOptions;
import xsbti.compile.analysis.ReadStamps;
import xsbti.compile.analysis.Stamp;

public final class Incremental$ {
    public static Incremental$ MODULE$;
    private final String incDebugProp;
    private final String apiDebugProp;

    static {
        new Incremental$();
    }

    public Tuple2<Object, Analysis> compile(Set<File> sources, Lookup lookup, CompileAnalysis previous0, ReadStamps current, Function4<Set<File>, DependencyChanges, xsbti.AnalysisCallback, ClassFileManager, BoxedUnit> compile, AnalysisCallback.Builder callbackBuilder, Logger log, IncOptions options, Equiv<Stamp> equivS) {
        Analysis analysis;
        CompileAnalysis compileAnalysis = previous0;
        if (!(compileAnalysis instanceof Analysis)) {
            throw new MatchError((Object)compileAnalysis);
        }
        Analysis analysis2 = analysis = (Analysis)compileAnalysis;
        Analysis previous = analysis2;
        IncrementalNameHashing incremental = new IncrementalNameHashing(log, options);
        InitialChanges initialChanges = incremental.changedInitial(sources, previous, current, lookup, equivS);
        DependencyChanges binaryChanges = new DependencyChanges(initialChanges){
            private final File[] modifiedBinaries;
            private final String[] modifiedClasses;

            public File[] modifiedBinaries() {
                return this.modifiedBinaries;
            }

            public String[] modifiedClasses() {
                return this.modifiedClasses;
            }

            public boolean isEmpty() {
                return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.modifiedBinaries())).isEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.modifiedClasses())).isEmpty();
            }
            {
                this.modifiedBinaries = (File[])initialChanges$1.binaryDeps().toArray(ClassTag$.MODULE$.apply(File.class));
                this.modifiedClasses = (String[])initialChanges$1.external().allModified().toArray(ClassTag$.MODULE$.apply(String.class));
            }
        };
        Tuple2<Set<String>, Set<File>> tuple2 = incremental.invalidateInitial(previous.relations(), initialChanges);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Set initialInvClasses = (Set)tuple2._1();
        Set initialInvSources = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)initialInvClasses, (Object)initialInvSources);
        Tuple2 tuple23 = tuple22;
        Set initialInvClasses2 = (Set)tuple23._1();
        Set initialInvSources2 = (Set)tuple23._2();
        if (initialInvClasses2.nonEmpty() || initialInvSources2.nonEmpty()) {
            Set set = initialInvSources2;
            Set<File> set2 = sources;
            if (!(set != null ? !set.equals(set2) : set2 != null)) {
                incremental.log().debug((Function0 & Serializable & scala.Serializable)() -> "All sources are invalidated.");
            } else {
                incremental.log().debug((Function0 & Serializable & scala.Serializable)() -> "All initially invalidated classes: " + initialInvClasses2 + "\n" + "All initially invalidated sources:" + initialInvSources2 + "\n");
            }
        }
        Analysis analysis3 = (Analysis)this.manageClassfiles(options, (Function1 & Serializable & scala.Serializable)classfileManager -> incremental.cycle((Set<String>)initialInvClasses2, (Set<File>)initialInvSources2, sources, binaryChanges, lookup, previous, (Function2<Set<File>, DependencyChanges, Analysis>)(Function2 & Serializable & scala.Serializable)(srcs, changes) -> MODULE$.doCompile(compile, callbackBuilder, (ClassFileManager)classfileManager, (Set<File>)srcs, (DependencyChanges)changes), (ClassFileManager)classfileManager, 1));
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((initialInvClasses2.nonEmpty() || initialInvSources2.nonEmpty() ? 1 : 0) != 0), (Object)analysis3);
    }

    public Analysis doCompile(Function4<Set<File>, DependencyChanges, xsbti.AnalysisCallback, ClassFileManager, BoxedUnit> compile, AnalysisCallback.Builder callbackBuilder, ClassFileManager classFileManager, Set<File> srcs, DependencyChanges changes) {
        AnalysisCallback callback = callbackBuilder.build();
        compile.apply(srcs, (Object)changes, (Object)callback, (Object)classFileManager);
        return callback.get();
    }

    public String incDebugProp() {
        return this.incDebugProp;
    }

    public String apiDebugProp() {
        return this.apiDebugProp;
    }

    public boolean apiDebug(IncOptions options) {
        return options.apiDebug() || Boolean.getBoolean(this.apiDebugProp());
    }

    public Analysis prune(Set<File> invalidatedSrcs, CompileAnalysis previous) {
        return this.prune(invalidatedSrcs, previous, ClassFileManager$.MODULE$.deleteImmediately());
    }

    public Analysis prune(Set<File> invalidatedSrcs, CompileAnalysis previous0, ClassFileManager classfileManager) {
        Analysis analysis;
        CompileAnalysis compileAnalysis = previous0;
        if (!(compileAnalysis instanceof Analysis)) {
            throw new MatchError((Object)compileAnalysis);
        }
        Analysis analysis2 = analysis = (Analysis)compileAnalysis;
        Analysis previous = analysis2;
        classfileManager.delete((File[])((TraversableOnce)invalidatedSrcs.flatMap((Function1 & Serializable & scala.Serializable)src -> previous.relations().products((File)src), Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)));
        return previous.$minus$minus((Iterable<File>)invalidatedSrcs);
    }

    private <T> T manageClassfiles(IncOptions options, Function1<ClassFileManager, T> run) {
        Object object;
        ClassFileManager classfileManager = ClassFileManager$.MODULE$.getClassFileManager(options);
        try {
            object = run.apply((Object)classfileManager);
        }
        catch (Throwable e) {
            classfileManager.complete(false);
            throw e;
        }
        Object result = object;
        classfileManager.complete(true);
        return (T)result;
    }

    private Incremental$() {
        MODULE$ = this;
        this.incDebugProp = "xsbt.inc.debug";
        this.apiDebugProp = "xsbt.api.debug";
    }
}

