/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class UTF_32Coder {
    protected static final int BOM_BIG = 65279;
    protected static final int BOM_LITTLE = -131072;
    protected static final int NONE = 0;
    protected static final int BIG = 1;
    protected static final int LITTLE = 2;

    UTF_32Coder() {
    }

    protected static class Encoder
    extends CharsetEncoder {
        private boolean doBOM;
        private boolean doneBOM;
        private int byteOrder;

        protected void put(int cp, ByteBuffer dst) {
            if (this.byteOrder == 1) {
                dst.put((byte)(cp >> 24));
                dst.put((byte)(cp >> 16));
                dst.put((byte)(cp >> 8));
                dst.put((byte)cp);
            } else {
                dst.put((byte)cp);
                dst.put((byte)(cp >> 8));
                dst.put((byte)(cp >> 16));
                dst.put((byte)(cp >> 24));
            }
        }

        protected Encoder(Charset cs, int byteOrder, boolean doBOM) {
            byte[] byArray;
            float f = doBOM ? 8.0f : 4.0f;
            if (byteOrder == 1) {
                byte[] byArray2 = new byte[4];
                byArray2[0] = 0;
                byArray2[1] = 0;
                byArray2[2] = -1;
                byArray = byArray2;
                byArray2[3] = -3;
            } else {
                byte[] byArray3 = new byte[4];
                byArray3[0] = -3;
                byArray3[1] = -1;
                byArray3[2] = 0;
                byArray = byArray3;
                byArray3[3] = 0;
            }
            super(cs, 4.0f, f, byArray);
            this.doBOM = false;
            this.doneBOM = true;
            this.byteOrder = byteOrder;
            this.doBOM = doBOM;
            this.doneBOM = !doBOM;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            int mark = src.position();
            if (!this.doneBOM && src.hasRemaining()) {
                if (dst.remaining() < 4) {
                    return CoderResult.OVERFLOW;
                }
                this.put(65279, dst);
                this.doneBOM = true;
            }
            try {
                while (src.hasRemaining()) {
                    char c = src.get();
                    if (!Character.isSurrogate(c)) {
                        if (dst.remaining() < 4) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        ++mark;
                        this.put(c, dst);
                        continue;
                    }
                    if (!Character.isHighSurrogate(c)) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    if (!src.hasRemaining()) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    char low = src.get();
                    if (!Character.isLowSurrogate(low)) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    if (dst.remaining() < 4) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    mark += 2;
                    this.put(Character.toCodePoint(c, low), dst);
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected void implReset() {
            this.doneBOM = !this.doBOM;
        }
    }

    protected static class Decoder
    extends CharsetDecoder {
        private int currentBO;
        private int expectedBO;

        protected Decoder(Charset cs, int bo) {
            super(cs, 0.25f, 1.0f);
            this.expectedBO = bo;
            this.currentBO = 0;
        }

        private int getCP(ByteBuffer src) {
            return this.currentBO == 1 ? (src.get() & 0xFF) << 24 | (src.get() & 0xFF) << 16 | (src.get() & 0xFF) << 8 | src.get() & 0xFF : src.get() & 0xFF | (src.get() & 0xFF) << 8 | (src.get() & 0xFF) << 16 | (src.get() & 0xFF) << 24;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (src.remaining() < 4) {
                return CoderResult.UNDERFLOW;
            }
            int mark = src.position();
            try {
                int cp;
                if (this.currentBO == 0) {
                    cp = (src.get() & 0xFF) << 24 | (src.get() & 0xFF) << 16 | (src.get() & 0xFF) << 8 | src.get() & 0xFF;
                    if (cp == 65279 && this.expectedBO != 2) {
                        this.currentBO = 1;
                        mark += 4;
                    } else if (cp == -131072 && this.expectedBO != 1) {
                        this.currentBO = 2;
                        mark += 4;
                    } else {
                        this.currentBO = this.expectedBO == 0 ? 1 : this.expectedBO;
                        src.position(mark);
                    }
                }
                while (src.remaining() >= 4) {
                    cp = this.getCP(src);
                    if (Character.isBmpCodePoint(cp)) {
                        if (!dst.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        mark += 4;
                        dst.put((char)cp);
                        continue;
                    }
                    if (Character.isValidCodePoint(cp)) {
                        if (dst.remaining() < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        mark += 4;
                        dst.put(Character.highSurrogate(cp));
                        dst.put(Character.lowSurrogate(cp));
                        continue;
                    }
                    CoderResult coderResult = CoderResult.malformedForLength(4);
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected void implReset() {
            this.currentBO = 0;
        }
    }
}

