/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import org.openide.awt.AcceleratorBinding;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public final class NbKeymap
implements Keymap,
Comparator<KeyStroke> {
    private static final RequestProcessor RP = new RequestProcessor(NbKeymap.class);
    public static final String BINDING_REMOVED = "removed";
    public static final String SHADOW_EXT = "shadow";
    private RequestProcessor.Task refreshTask;
    private static final Action BROKEN = new AbstractAction("<broken>"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Toolkit.getDefaultToolkit().beep();
        }
    };
    private Map<KeyStroke, Binding> bindings;
    private Map<String, KeyStroke> id2Stroke;
    private final Map<Action, String> action2Id = new WeakHashMap<Action, String>();
    private FileChangeListener keymapListener;
    private FileChangeListener bindingsListener = new FileChangeAdapter(){

        public void fileDataCreated(FileEvent fileEvent) {
            NbKeymap.this.refreshBindings();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            NbKeymap.this.refreshBindings();
        }

        public void fileChanged(FileEvent fileEvent) {
            NbKeymap.this.refreshBindings();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            NbKeymap.this.refreshBindings();
        }

        public void fileDeleted(FileEvent fileEvent) {
            NbKeymap.this.refreshBindings();
        }
    };
    private static final List<KeyStroke> context = new ArrayList<KeyStroke>();
    private static final Logger LOG = Logger.getLogger(NbKeymap.class.getName());

    private void refreshBindings() {
        this.refreshTask = RP.post(new Runnable(){

            @Override
            public void run() {
                NbKeymap.this.doRefreshBindings();
            }
        });
    }

    private synchronized void doRefreshBindings() {
        this.bindings = null;
        this.bindings();
    }

    boolean waitFinished() throws InterruptedException {
        return this.refreshTask != null ? this.refreshTask.waitFinished(9999L) : false;
    }

    private synchronized Map<KeyStroke, Binding> bindings() {
        if (this.bindings == null) {
            Object object;
            this.bindings = new HashMap<KeyStroke, Binding>();
            boolean bl = this.id2Stroke != null;
            this.id2Stroke = new TreeMap<String, KeyStroke>();
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>(2);
            arrayList.add(FileUtil.getConfigFile((String)"Shortcuts"));
            FileObject fileObject = FileUtil.getConfigFile((String)"Keymaps");
            if (fileObject != null) {
                object = (String)fileObject.getAttribute("currentKeymap");
                if (object == null) {
                    object = "NetBeans";
                }
                arrayList.add(fileObject.getFileObject((String)object));
                if (this.keymapListener == null) {
                    this.keymapListener = new FileChangeAdapter(){

                        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
                            NbKeymap.this.refreshBindings();
                        }
                    };
                    fileObject.addFileChangeListener(this.keymapListener);
                }
            }
            object = new HashMap();
            boolean bl2 = false;
            LinkedHashMap<String, FileObject> linkedHashMap = new LinkedHashMap<String, FileObject>();
            for (FileObject object2 : arrayList) {
                if (object2 != null) {
                    for (FileObject fileObject2 : object2.getChildren()) {
                        if (!fileObject2.isData()) continue;
                        boolean bl3 = bl2 && BINDING_REMOVED.equals(fileObject2.getExt());
                        String string = fileObject2.getName().toUpperCase();
                        if (bl3) {
                            linkedHashMap.remove(string);
                            continue;
                        }
                        linkedHashMap.put(string, fileObject2);
                    }
                    object2.removeFileChangeListener(this.bindingsListener);
                    object2.addFileChangeListener(this.bindingsListener);
                }
                bl2 = true;
            }
            for (FileObject fileObject3 : linkedHashMap.values()) {
                Binding binding;
                FileObject fileObject4 = fileObject3.getParent();
                if (!fileObject3.isData()) continue;
                KeyStroke[] keyStrokeArray = Utilities.stringToKeys((String)fileObject3.getName());
                if (keyStrokeArray == null || keyStrokeArray.length == 0) {
                    LOG.log(Level.WARNING, "could not load parse name of " + fileObject3.getPath());
                    continue;
                }
                Map<KeyStroke, Binding> map = this.bindings;
                for (int i = 0; i < keyStrokeArray.length - 1; ++i) {
                    binding = map.get(keyStrokeArray[i]);
                    if (binding != null && binding.nested == null) {
                        LOG.log(Level.WARNING, "conflict between " + binding.actionDefinition.getPath() + " and " + fileObject3.getPath());
                        binding = null;
                    }
                    if (binding == null) {
                        binding = new Binding();
                        map.put(keyStrokeArray[i], binding);
                    }
                    map = binding.nested;
                }
                map.put(keyStrokeArray[keyStrokeArray.length - 1], new Binding(fileObject3));
                if (keyStrokeArray.length != 1) continue;
                String string = NbKeymap.idForFile(fileObject3);
                Binding binding2 = binding = object.put(string, fileObject4) == fileObject4 ? this.id2Stroke.get(string) : null;
                if (binding != null && this.compare((KeyStroke)((Object)binding), keyStrokeArray[0]) <= 0) continue;
                this.id2Stroke.put(string, keyStrokeArray[0]);
            }
            if (bl) {
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Map map = NbKeymap.this.action2Id;
                        synchronized (map) {
                            for (Map.Entry entry : NbKeymap.this.action2Id.entrySet()) {
                                ((Action)entry.getKey()).putValue("AcceleratorKey", NbKeymap.this.id2Stroke.get(entry.getValue()));
                            }
                        }
                    }
                });
            }
            if (LOG.isLoggable(Level.FINE)) {
                for (Map.Entry entry : this.id2Stroke.entrySet()) {
                    LOG.fine(entry.getValue() + " => " + (String)entry.getKey());
                }
            }
        }
        return this.bindings;
    }

    private static void resetContext() {
        context.clear();
        StatusDisplayer.getDefault().setStatusText("");
    }

    public static KeyStroke[] getContext() {
        return context.toArray(new KeyStroke[context.size()]);
    }

    private static void shiftContext(KeyStroke keyStroke) {
        context.add(keyStroke);
        StringBuilder stringBuilder = new StringBuilder();
        for (KeyStroke keyStroke2 : context) {
            stringBuilder.append(NbKeymap.getKeyText(keyStroke2)).append(' ');
        }
        StatusDisplayer.getDefault().setStatusText(stringBuilder.toString());
    }

    private static String getKeyText(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return "";
        }
        String string = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        if ("".equals(string)) {
            return KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        return string + "+" + KeyEvent.getKeyText(keyStroke.getKeyCode());
    }

    public NbKeymap() {
        context.clear();
    }

    @Override
    public Action getDefaultAction() {
        return null;
    }

    @Override
    public void setDefaultAction(Action action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return "Default";
    }

    @Override
    public Action getAction(final KeyStroke keyStroke) {
        switch (keyStroke.getKeyCode()) {
            case 0: 
            case 16: 
            case 17: 
            case 18: 
            case 157: 
            case 65406: 
            case 65535: {
                return null;
            }
        }
        if (keyStroke.isOnKeyRelease()) {
            return null;
        }
        LOG.log(Level.FINE, "getAction {0}", keyStroke);
        Map<KeyStroke, Binding> map = this.bindings();
        for (KeyStroke keyStroke2 : context) {
            Binding binding = map.get(keyStroke2);
            if (binding == null) {
                NbKeymap.resetContext();
                return BROKEN;
            }
            map = binding.nested;
            if (map != null) continue;
            NbKeymap.resetContext();
            return BROKEN;
        }
        Binding binding = map.get(keyStroke);
        if (binding == null) {
            NbKeymap.resetContext();
            return null;
        }
        if (binding.nested == null) {
            NbKeymap.resetContext();
            return binding.loadAction();
        }
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NbKeymap.shiftContext(keyStroke);
            }
        };
    }

    @Override
    public KeyStroke[] getBoundKeyStrokes() {
        assert (false);
        return null;
    }

    @Override
    public Action[] getBoundActions() {
        assert (false);
        return null;
    }

    @Override
    public KeyStroke[] getKeyStrokesForAction(Action action) {
        return new KeyStroke[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyStroke keyStrokeForAction(Action action, FileObject fileObject) {
        String string = NbKeymap.idForFile(fileObject);
        this.bindings();
        Map<Action, String> map = this.action2Id;
        synchronized (map) {
            this.action2Id.put(action, string);
            KeyStroke keyStroke = this.id2Stroke.get(string);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "found keystroke {0} for {1} with ID {2}", new Object[]{keyStroke, NbKeymap.id(action), string});
            }
            return keyStroke;
        }
    }

    private static String idForFile(FileObject fileObject) {
        String string;
        if (fileObject.hasExt(SHADOW_EXT)) {
            string = (String)fileObject.getAttribute("originalFile");
            if (string != null && fileObject.getSize() == 0L) {
                fileObject = FileUtil.getConfigFile((String)string);
                if (fileObject == null) {
                    return string;
                }
            } else {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    if (dataObject instanceof DataShadow) {
                        fileObject = ((DataShadow)dataObject).getOriginal().getPrimaryFile();
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    LOG.log(Level.FINE, fileObject.getPath(), dataObjectNotFoundException);
                }
            }
        }
        if (fileObject.hasExt("instance") && !Collections.list(fileObject.getAttributes()).contains("instanceCreate")) {
            string = (String)fileObject.getAttribute("instanceClass");
            if (string != null) {
                return string;
            }
            return fileObject.getName().replace('-', '.');
        }
        return fileObject.getPath();
    }

    @Override
    public synchronized boolean isLocallyDefined(KeyStroke keyStroke) {
        assert (false);
        return false;
    }

    @Override
    public int compare(KeyStroke keyStroke, KeyStroke keyStroke2) {
        return KeyEvent.getKeyText(keyStroke.getKeyCode()).length() - KeyEvent.getKeyText(keyStroke2.getKeyCode()).length();
    }

    @Override
    public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
        assert (false);
    }

    @Override
    public void removeKeyStrokeBinding(KeyStroke keyStroke) {
        assert (false);
    }

    @Override
    public void removeBindings() {
        assert (false);
    }

    @Override
    public Keymap getResolveParent() {
        return null;
    }

    @Override
    public void setResolveParent(Keymap keymap) {
        throw new UnsupportedOperationException();
    }

    private static Object id(Action action) {
        if (action instanceof SystemAction) {
            return action.getClass();
        }
        return action;
    }

    public static final class AcceleratorBindingImpl
    extends AcceleratorBinding {
        protected KeyStroke keyStrokeForAction(Action action, FileObject fileObject) {
            Keymap keymap = (Keymap)Lookup.getDefault().lookup(Keymap.class);
            if (keymap instanceof NbKeymap) {
                return ((NbKeymap)keymap).keyStrokeForAction(action, fileObject);
            }
            LOG.log(Level.WARNING, "unexpected keymap: {0}", keymap);
            return null;
        }
    }

    private static class Binding {
        final FileObject actionDefinition;
        private Action action;
        final Map<KeyStroke, Binding> nested;

        Binding(FileObject fileObject) {
            this.actionDefinition = fileObject;
            this.nested = null;
        }

        Binding() {
            this.actionDefinition = null;
            this.nested = new HashMap<KeyStroke, Binding>();
        }

        synchronized Action loadAction() {
            assert (this.actionDefinition != null);
            if (this.action == null) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)this.actionDefinition);
                    InstanceCookie instanceCookie = (InstanceCookie)dataObject.getLookup().lookup(InstanceCookie.class);
                    if (instanceCookie == null) {
                        return null;
                    }
                    this.action = (Action)instanceCookie.instanceCreate();
                }
                catch (Exception exception) {
                    LOG.log(Level.INFO, "could not load action for " + this.actionDefinition.getPath(), exception);
                }
            }
            if (this.action == null) {
                this.action = BROKEN;
            }
            return this.action;
        }
    }
}

