/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.http;

import gnu.inet.http.Authenticator;
import gnu.inet.http.ByteArrayRequestBodyWriter;
import gnu.inet.http.ChunkedInputStream;
import gnu.inet.http.Cookie;
import gnu.inet.http.CookieManager;
import gnu.inet.http.Credentials;
import gnu.inet.http.HTTPConnection;
import gnu.inet.http.HTTPDateFormat;
import gnu.inet.http.Headers;
import gnu.inet.http.RequestBodyWriter;
import gnu.inet.http.Response;
import gnu.inet.http.ResponseBodyReader;
import gnu.inet.http.ResponseHeaderHandler;
import gnu.inet.util.BASE64;
import gnu.inet.util.LineInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class Request {
    protected final HTTPConnection connection;
    protected final String method;
    protected final String path;
    protected final Headers requestHeaders;
    protected RequestBodyWriter requestBodyWriter;
    protected int requestBodyNegotiationThreshold;
    protected ResponseBodyReader responseBodyReader;
    protected Map responseHeaderHandlers;
    protected Authenticator authenticator;
    private boolean dispatched;
    byte[] nonce;

    protected Request(HTTPConnection hTTPConnection, String string, String string2) {
        this.connection = hTTPConnection;
        this.method = string;
        this.path = string2;
        this.requestHeaders = new Headers();
        this.responseHeaderHandlers = new HashMap();
        this.requestBodyNegotiationThreshold = 4096;
    }

    public HTTPConnection getConnection() {
        return this.connection;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public String getRequestURI() {
        return this.connection.getURI() + this.path;
    }

    public Headers getHeaders() {
        return this.requestHeaders;
    }

    public String getHeader(String string) {
        return this.requestHeaders.getValue(string);
    }

    public int getIntHeader(String string) {
        return this.requestHeaders.getIntValue(string);
    }

    public Date getDateHeader(String string) {
        return this.requestHeaders.getDateValue(string);
    }

    public void setHeader(String string, String string2) {
        this.requestHeaders.put(string, string2);
    }

    public void setRequestBody(byte[] byArray) {
        this.setRequestBodyWriter(new ByteArrayRequestBodyWriter(byArray));
    }

    public void setRequestBodyWriter(RequestBodyWriter requestBodyWriter) {
        this.requestBodyWriter = requestBodyWriter;
    }

    public void setResponseBodyReader(ResponseBodyReader responseBodyReader) {
        this.responseBodyReader = responseBodyReader;
    }

    public void setResponseHeaderHandler(String string, ResponseHeaderHandler responseHeaderHandler) {
        this.responseHeaderHandlers.put(string, responseHeaderHandler);
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setRequestBodyNegotiationThreshold(int n) {
        this.requestBodyNegotiationThreshold = n;
    }

    public Response dispatch() throws IOException {
        Response response;
        if (this.dispatched) {
            throw new ProtocolException("request already dispatched");
        }
        String string = this.connection.getVersion();
        int n = -1;
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = false;
        if (this.requestBodyWriter != null) {
            n = this.requestBodyWriter.getContentLength();
            if (n > this.requestBodyNegotiationThreshold && (this.connection.minorVersion > 0 || this.connection.majorVersion > 1)) {
                bl2 = true;
                this.setHeader("Expect", "100-continue");
            } else {
                this.setHeader("Content-Length", Integer.toString(n));
            }
        }
        try {
            do {
                bl = false;
                this.connection.fireRequestEvent(1, this);
                OutputStream outputStream = this.connection.getOutputStream();
                LineInputStream lineInputStream = new LineInputStream(this.connection.getInputStream());
                String string2 = this.path;
                if (this.connection.isUsingProxy() && !"*".equals(string2) && !"CONNECT".equals(this.method)) {
                    string2 = this.getRequestURI();
                }
                String string3 = this.method + ' ' + string2 + ' ' + string + "\r\n";
                outputStream.write(string3.getBytes("US-ASCII"));
                for (String string4 : this.requestHeaders.keySet()) {
                    String string5 = (String)this.requestHeaders.get(string4);
                    string3 = string4 + ": " + string5 + "\r\n";
                    outputStream.write(string3.getBytes("US-ASCII"));
                }
                outputStream.write("\r\n".getBytes("US-ASCII"));
                if (this.requestBodyWriter != null && !bl2) {
                    int n3;
                    Object object = new byte[4096];
                    int n4 = 0;
                    this.requestBodyWriter.reset();
                    do {
                        if ((n3 = this.requestBodyWriter.write((byte[])object)) <= 0) continue;
                        outputStream.write((byte[])object, 0, n3);
                    } while (n3 > -1 && (n4 += n3) < n);
                    outputStream.write("\r\n".getBytes("US-ASCII"));
                }
                outputStream.flush();
                this.connection.fireRequestEvent(2, this);
                response = this.readResponse(lineInputStream);
                int n5 = response.getCode();
                if (n5 == 401 && this.authenticator != null) {
                    if (!this.authenticate(response, n2++)) continue;
                    bl = true;
                    continue;
                }
                if (n5 != 100) continue;
                this.requestHeaders.remove("Expect");
                this.setHeader("Content-Length", Integer.toString(n));
                bl2 = false;
                bl = true;
            } while (bl);
        }
        catch (IOException iOException) {
            this.connection.close();
            throw iOException;
        }
        return response;
    }

    Response readResponse(LineInputStream lineInputStream) throws IOException {
        String string = lineInputStream.readLine();
        if (string == null) {
            throw new ProtocolException("Peer closed connection");
        }
        if (!string.startsWith("HTTP/")) {
            throw new ProtocolException(string);
        }
        int n = string.length();
        int n2 = 5;
        int n3 = 6;
        while (string.charAt(n3) != '.') {
            ++n3;
        }
        int n4 = Integer.parseInt(string.substring(n2, n3));
        n2 = n3 + 1;
        n3 = n2 + 1;
        while (string.charAt(n3) != ' ') {
            ++n3;
        }
        int n5 = Integer.parseInt(string.substring(n2, n3));
        n2 = n3 + 1;
        n3 = n2 + 3;
        int n6 = Integer.parseInt(string.substring(n2, n3));
        String string2 = string.substring(n3 + 1, n - 1);
        Headers headers = new Headers();
        headers.parse(lineInputStream);
        this.notifyHeaderHandlers(headers);
        int n7 = n6 / 100;
        Response response = new Response(n4, n5, n6, n7, string2, headers);
        if (!"HEAD".equals(this.method) && !"OPTIONS".equals(this.method)) {
            switch (n6) {
                case 204: 
                case 205: {
                    break;
                }
                default: {
                    boolean bl;
                    boolean bl2 = bl = this.responseBodyReader != null;
                    if (bl && !this.responseBodyReader.accept(this, response)) {
                        bl = false;
                    }
                    this.readResponseBody(response, lineInputStream, bl);
                }
            }
        }
        return response;
    }

    void notifyHeaderHandlers(Headers headers) {
        for (Map.Entry entry : headers.entrySet()) {
            Object object;
            String string = (String)entry.getKey();
            if ("Set-Cookie".equalsIgnoreCase(string)) {
                object = (String)entry.getValue();
                this.handleSetCookie((String)object);
            }
            if ((object = (ResponseHeaderHandler)this.responseHeaderHandlers.get(string)) == null) continue;
            String string2 = (String)entry.getValue();
            object.setValue(string2);
        }
    }

    void readResponseBody(Response response, InputStream inputStream, boolean bl) throws IOException {
        Headers headers;
        block13: {
            boolean bl2;
            int n;
            byte[] byArray;
            block12: {
                byArray = new byte[4096];
                n = -1;
                headers = null;
                String string = response.getHeader("Transfer-Encoding");
                if ("chunked".equalsIgnoreCase(string)) {
                    headers = new Headers();
                    inputStream = new ChunkedInputStream(inputStream, headers);
                } else {
                    n = response.getIntHeader("Content-Length");
                }
                String string2 = response.getHeader("Content-Encoding");
                if (string2 != null && !"identity".equals(string2)) {
                    if ("gzip".equals(string2)) {
                        inputStream = new GZIPInputStream(inputStream);
                    } else if ("deflate".equals(string2)) {
                        inputStream = new InflaterInputStream(inputStream);
                    } else {
                        throw new ProtocolException("Unsupported Content-Encoding: " + string2);
                    }
                    response.headers.remove("Content-Encoding");
                }
                boolean bl3 = bl2 = "close".equalsIgnoreCase(this.getHeader("Connection")) || "close".equalsIgnoreCase(response.getHeader("Connection")) || this.connection.majorVersion == 1 && this.connection.minorVersion == 0 || response.majorVersion == 1 && response.minorVersion == 0 || n == -1;
                if (n != 0) break block12;
                if (!bl2) break block13;
                this.connection.closeConnection();
                break block13;
            }
            int n2 = n;
            int n3 = n2 > -1 ? n2 : byArray.length;
            int n4 = n3 = n3 > byArray.length ? byArray.length : n3;
            while (n3 > -1) {
                if ((n3 = inputStream.read(byArray, 0, n3)) < 0) {
                    this.connection.closeConnection();
                    break;
                }
                if (bl) {
                    this.responseBodyReader.read(byArray, 0, n3);
                }
                if (n2 <= -1 || (n2 -= n3) >= 1) continue;
                if (!bl2) break;
                this.connection.closeConnection();
                break;
            }
        }
        if (bl) {
            this.responseBodyReader.close();
        }
        if (headers != null) {
            response.getHeaders().putAll((Map)headers);
            this.notifyHeaderHandlers(headers);
        }
    }

    boolean authenticate(Response response, int n) throws IOException {
        int n2;
        String string;
        String string2 = response.getHeader("WWW-Authenticate");
        if (string2 == null) {
            string2 = response.getHeader("Proxy-Authenticate");
        }
        String string3 = string = (n2 = string2.indexOf(32)) == -1 ? string2 : string2.substring(0, n2);
        if ("Basic".equalsIgnoreCase(string)) {
            Properties properties = this.parseAuthParams(string2.substring(n2 + 1));
            String string4 = properties.getProperty("realm");
            Credentials credentials = this.authenticator.getCredentials(string4, n);
            String string5 = credentials.getUsername() + ':' + credentials.getPassword();
            byte[] byArray = string5.getBytes("US-ASCII");
            byte[] byArray2 = BASE64.encode(byArray);
            String string6 = string + " " + new String(byArray2, "US-ASCII");
            this.setHeader("Authorization", string6);
            return true;
        }
        if ("Digest".equalsIgnoreCase(string)) {
            Properties properties = this.parseAuthParams(string2.substring(n2 + 1));
            String string7 = properties.getProperty("realm");
            String string8 = properties.getProperty("nonce");
            String string9 = properties.getProperty("qop");
            String string10 = properties.getProperty("algorithm");
            String string11 = this.getRequestURI();
            Credentials credentials = this.authenticator.getCredentials(string7, n);
            String string12 = credentials.getUsername();
            String string13 = credentials.getPassword();
            this.connection.incrementNonce(string8);
            try {
                Object object;
                String string14;
                byte[] byArray;
                Object object2;
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                byte[] byArray3 = new byte[]{58};
                messageDigest.reset();
                messageDigest.update(string12.getBytes("US-ASCII"));
                messageDigest.update(byArray3);
                messageDigest.update(string7.getBytes("US-ASCII"));
                messageDigest.update(byArray3);
                messageDigest.update(string13.getBytes("US-ASCII"));
                byte[] byArray4 = messageDigest.digest();
                if ("md5-sess".equals(string10)) {
                    object2 = this.generateNonce();
                    messageDigest.reset();
                    messageDigest.update(byArray4);
                    messageDigest.update(byArray3);
                    messageDigest.update(string8.getBytes("US-ASCII"));
                    messageDigest.update(byArray3);
                    messageDigest.update((byte[])object2);
                    byArray4 = messageDigest.digest();
                }
                object2 = this.toHexString(byArray4);
                messageDigest.reset();
                messageDigest.update(this.method.getBytes("US-ASCII"));
                messageDigest.update(byArray3);
                messageDigest.update(string11.getBytes("US-ASCII"));
                if ("auth-int".equals(string9)) {
                    byArray = null;
                    messageDigest.update(byArray3);
                    messageDigest.update(byArray);
                }
                byArray = messageDigest.digest();
                String string15 = this.toHexString(byArray);
                messageDigest.reset();
                messageDigest.update(((String)object2).getBytes("US-ASCII"));
                messageDigest.update(byArray3);
                messageDigest.update(string8.getBytes("US-ASCII"));
                if ("auth".equals(string9) || "auth-int".equals(string9)) {
                    string14 = this.getNonceCount(string8);
                    object = this.generateNonce();
                    messageDigest.update(byArray3);
                    messageDigest.update(string14.getBytes("US-ASCII"));
                    messageDigest.update(byArray3);
                    messageDigest.update((byte[])object);
                    messageDigest.update(byArray3);
                    messageDigest.update(string9.getBytes("US-ASCII"));
                }
                messageDigest.update(byArray3);
                messageDigest.update(string15.getBytes("US-ASCII"));
                string14 = this.toHexString(messageDigest.digest());
                object = string + " username=\"" + string12 + "\"" + " realm=\"" + string7 + "\"" + " nonce=\"" + string8 + "\"" + " uri=\"" + string11 + "\"" + " response=\"" + string14 + "\"";
                this.setHeader("Authorization", (String)object);
                return true;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return false;
            }
        }
        return false;
    }

    Properties parseAuthParams(String string) {
        int n = string.length();
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        Properties properties = new Properties();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                bl = !bl;
                continue;
            }
            if (c == '=' && string2 == null) {
                string2 = stringBuffer.toString().trim();
                stringBuffer.setLength(0);
                continue;
            }
            if (c == ' ' && !bl) {
                String string3 = this.unquote(stringBuffer.toString().trim());
                properties.put(string2, string3);
                string2 = null;
                stringBuffer.setLength(0);
                continue;
            }
            if (c == ',' && (i >= n - 1 || string.charAt(i + 1) == ' ')) continue;
            stringBuffer.append(c);
        }
        if (string2 != null) {
            String string4 = this.unquote(stringBuffer.toString().trim());
            properties.put(string2, string4);
        }
        return properties;
    }

    String unquote(String string) {
        int n = string.length();
        if (n > 0 && string.charAt(0) == '\"' && string.charAt(n - 1) == '\"') {
            return string.substring(1, n - 1);
        }
        return string;
    }

    String getNonceCount(String string) {
        int n = this.connection.getNonceCount(string);
        String string2 = Integer.toHexString(n);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 8 - string2.length(); i > 0; --i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    byte[] generateNonce() throws IOException, NoSuchAlgorithmException {
        if (this.nonce == null) {
            long l = System.currentTimeMillis();
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(Long.toString(l).getBytes("US-ASCII"));
            this.nonce = messageDigest.digest();
        }
        return this.nonce;
    }

    String toHexString(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i];
            if (n2 < 0) {
                n2 += 256;
            }
            cArray[n++] = Character.forDigit(n2 / 16, 16);
            cArray[n++] = Character.forDigit(n2 % 16, 16);
        }
        return new String(cArray);
    }

    void handleSetCookie(String string) {
        CookieManager cookieManager = this.connection.getCookieManager();
        if (cookieManager == null) {
            return;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = this.connection.getHostName();
        String string6 = this.path;
        int n = string6.lastIndexOf(47);
        if (n != -1) {
            string6 = string6.substring(0, n);
        }
        boolean bl = false;
        Date date = null;
        int n2 = string.length();
        String string7 = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        for (int i = 0; i <= n2; ++i) {
            char c;
            char c2 = c = i == n2 ? (char)'\u0000' : string.charAt(i);
            if (c == '\"') {
                bl2 = !bl2;
                continue;
            }
            if (!bl2) {
                if (c == '=' && string7 == null) {
                    string7 = stringBuffer.toString().trim();
                    stringBuffer.setLength(0);
                    continue;
                }
                if (c == ';' || i == n2 || c == ',') {
                    String string8 = this.unquote(stringBuffer.toString().trim());
                    if (string2 == null) {
                        string2 = string7;
                        string3 = string8;
                    } else if ("Comment".equalsIgnoreCase(string7)) {
                        string4 = string8;
                    } else if ("Domain".equalsIgnoreCase(string7)) {
                        string5 = string8;
                    } else if ("Path".equalsIgnoreCase(string7)) {
                        string6 = string8;
                    } else if ("Secure".equalsIgnoreCase(string8)) {
                        bl = true;
                    } else if ("Max-Age".equalsIgnoreCase(string7)) {
                        int n3 = Integer.parseInt(string8);
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTimeInMillis(System.currentTimeMillis());
                        calendar.add(13, n3);
                        date = calendar.getTime();
                    } else if ("Expires".equalsIgnoreCase(string7)) {
                        HTTPDateFormat hTTPDateFormat = new HTTPDateFormat();
                        try {
                            date = hTTPDateFormat.parse(string8);
                        }
                        catch (ParseException parseException) {
                            stringBuffer.append(c);
                            continue;
                        }
                    }
                    string7 = null;
                    stringBuffer.setLength(0);
                    if (i == n2 || c == ',') {
                        Cookie cookie = new Cookie(string2, string3, string4, string5, string6, bl, date);
                        cookieManager.setCookie(cookie);
                    }
                    if (c != ',') continue;
                    string2 = null;
                    string3 = null;
                    string4 = null;
                    string5 = this.connection.getHostName();
                    string6 = this.path;
                    if (n != -1) {
                        string6 = string6.substring(0, n);
                    }
                    bl = false;
                    date = null;
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
    }
}

