import ts = require('typescript');
/***
 * This module is designed to match simple patterns on Typescript AST Tree
 * it functionality mirrors jsASTMatchers which allows you to match on jsAST
 */
export declare module Matching {
    type Node = ts.Node;
    type Expression = ts.Expression;
    type Identifier = ts.Identifier;
    type SyntaxKind = ts.SyntaxKind;
    type CallExpression = ts.CallExpression;
    interface NodeMatcher {
        doMatch(node: Node): any;
    }
    interface TypedMatcher<T extends Node> extends NodeMatcher {
        /**
         * returns null or the value not null means that matched
         * @param node
         */
        doMatch(node: Node): any;
        nodeType(): ts.SyntaxKind;
    }
    interface Transformer<T, R> {
        (a: T): R;
    }
    interface NodeCallback<T> {
        (node: Node): T;
    }
    interface NodesCallback<T> {
        (nodes: Node[]): T;
    }
    /**
     * do match checks the node type and if node type is ok
     * calls match function otherwise it returns null
     */
    class BasicMatcher {
        protected match(node: Node): any;
        nodeType(): ts.SyntaxKind;
        doMatch(n: Node): any;
    }
    class ClassDeclarationMatcher extends BasicMatcher implements TypedMatcher<ts.ClassDeclaration> {
        protected match(node: Node): ts.ClassDeclaration;
        constructor();
        nodeType(): ts.SyntaxKind;
    }
    class FieldMatcher extends BasicMatcher implements TypedMatcher<ts.ClassDeclaration> {
        match(node: ts.PropertyDeclaration): ts.PropertyDeclaration;
        nodeType(): ts.SyntaxKind;
    }
    class AssignmentExpressionMatcher extends BasicMatcher implements TypedMatcher<ts.BinaryExpression> {
        private left;
        private right;
        private tr;
        match(node: ts.BinaryExpression): any;
        constructor(left: TypedMatcher<Expression>, right: TypedMatcher<Expression>, tr: Transformer<ts.BinaryExpression, any>);
        nodeType(): ts.SyntaxKind;
    }
    class VariableDeclarationMatcher extends BasicMatcher implements TypedMatcher<ts.VariableDeclaration> {
        private left;
        private right;
        private tr;
        match(node: ts.VariableDeclaration): any;
        constructor(left: TypedMatcher<Expression>, right: TypedMatcher<Expression>, tr: Transformer<ts.VariableDeclaration, any>);
        nodeType(): ts.SyntaxKind;
    }
    var SKIP: {};
    function visit<T>(n: Node, cb: NodeCallback<T>): T;
    class PathNode {
        private _base;
        name: string;
        arguments: ReadonlyArray<Expression>;
        _callExpression: ts.CallExpression;
        constructor(name: string, _base: Node);
    }
    class CallPath {
        private _baseNode;
        base: string;
        start(): number;
        startLocation(): ts.LineAndCharacter;
        endLocation(): ts.LineAndCharacter;
        end(): number;
        constructor(base: string, _baseNode: ts.Node);
        path: PathNode[];
        toString(): string;
    }
    function memberFromExp(objMatcher: string, tr?: Transformer<Expression, any>): TypedMatcher<any>;
    class CallBaseMatcher implements TypedMatcher<Expression> {
        private rootMatcher;
        doMatch(node: Expression): CallPath;
        nodeType(): ts.SyntaxKind;
        constructor(rootMatcher: TypedMatcher<Identifier>);
    }
    function ident(name: string): TypedMatcher<Identifier>;
    function anyNode(): TypedMatcher<Node>;
    function call(calleeMatcher: TypedMatcher<Expression>, tr?: Transformer<CallExpression, any>): TypedMatcher<CallExpression>;
    function exprStmt(eM: TypedMatcher<Expression>, tr?: Transformer<ts.MemberExpression, any>): TypedMatcher<ts.ExpressionStatement>;
    function assign(left: TypedMatcher<Expression>, right: TypedMatcher<Expression>, tr?: Transformer<ts.BinaryExpression, any>): TypedMatcher<ts.BinaryExpression>;
    function varDecl(left: TypedMatcher<Expression>, right: TypedMatcher<Expression>, tr?: Transformer<ts.VariableDeclaration, any>): TypedMatcher<ts.BinaryExpression>;
    function field(): FieldMatcher;
    function classDeclaration(): ClassDeclarationMatcher;
}
