/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.synonym.WordnetSynonymParser;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.analysis.ESSolrSynonymParser;

public class ESWordnetSynonymParser
extends WordnetSynonymParser {
    private final boolean lenient;
    private static final Logger logger = Loggers.getLogger(ESSolrSynonymParser.class, "ESWordnetSynonymParser");

    public ESWordnetSynonymParser(boolean dedup, boolean expand, boolean lenient, Analyzer analyzer) {
        super(dedup, expand, analyzer);
        this.lenient = lenient;
    }

    public void add(CharsRef input, CharsRef output, boolean includeOrig) {
        if (!this.lenient || input.length > 0 && output.length > 0) {
            super.add(input, output, includeOrig);
        }
    }

    public CharsRef analyze(String text, CharsRefBuilder reuse) throws IOException {
        try {
            return super.analyze(text, reuse);
        }
        catch (IllegalArgumentException ex) {
            if (this.lenient) {
                logger.info("Synonym rule for [" + text + "] was ignored");
                return new CharsRef("");
            }
            throw ex;
        }
    }
}

