/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Objects;
import java.util.TimeZone;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.function.aggregate.AggregateFunctionAttribute;
import org.elasticsearch.xpack.sql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.ProcessorDefinition;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.ProcessorDefinitions;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.UnaryProcessorDefinition;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;
import org.joda.time.DateTime;

public abstract class DateTimeFunction
extends UnaryScalarFunction {
    private final TimeZone timeZone;
    private final String name;

    DateTimeFunction(Location location, Expression field, TimeZone timeZone) {
        super(location, field);
        this.timeZone = timeZone;
        StringBuilder sb = new StringBuilder(super.name());
        sb.insert(sb.length() - 1, " [" + timeZone.getID() + "]");
        this.name = sb.toString();
    }

    @Override
    protected final NodeInfo<DateTimeFunction> info() {
        return NodeInfo.create(this, this.ctorForInfo(), this.field(), this.timeZone());
    }

    protected abstract NodeInfo.NodeCtor2<Expression, TimeZone, DateTimeFunction> ctorForInfo();

    @Override
    protected Expression.TypeResolution resolveType() {
        if (this.field().dataType() == DataType.DATE) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return new Expression.TypeResolution("Function [" + this.functionName() + "] cannot be applied on a non-date expression ([" + Expressions.name(this.field()) + "] of type [" + this.field().dataType().esType + "])", new Object[0]);
    }

    public TimeZone timeZone() {
        return this.timeZone;
    }

    @Override
    public boolean foldable() {
        return this.field().foldable();
    }

    @Override
    public Object fold() {
        DateTime folded = (DateTime)this.field().fold();
        if (folded == null) {
            return null;
        }
        return DateTimeFunction.dateTimeChrono(folded.getMillis(), this.timeZone.getID(), this.chronoField().name());
    }

    public static Integer dateTimeChrono(long millis, String tzId, String chronoName) {
        ZonedDateTime time = ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.of(tzId));
        return time.get(ChronoField.valueOf(chronoName));
    }

    @Override
    protected ScriptTemplate asScriptFrom(FieldAttribute field) {
        ParamsBuilder params = ParamsBuilder.paramsBuilder();
        String template = null;
        template = ScriptTemplate.formatTemplate("{sql}.dateTimeChrono(doc[{}].value.millis, {}, {})");
        params.variable(field.name()).variable(this.timeZone.getID()).variable(this.chronoField().name());
        return new ScriptTemplate(template, params.build(), this.dataType());
    }

    @Override
    protected ScriptTemplate asScriptFrom(AggregateFunctionAttribute aggregate) {
        throw new UnsupportedOperationException();
    }

    protected abstract ChronoField chronoField();

    @Override
    protected final ProcessorDefinition makeProcessorDefinition() {
        return new UnaryProcessorDefinition(this.location(), this, ProcessorDefinitions.toProcessorDefinition(this.field()), new DateTimeProcessor(this.extractor(), this.timeZone));
    }

    protected abstract DateTimeProcessor.DateTimeExtractor extractor();

    @Override
    public DataType dataType() {
        return DataType.INTEGER;
    }

    public abstract String dateTimeFormat();

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DateTimeFunction other = (DateTimeFunction)obj;
        return Objects.equals(other.field(), this.field()) && Objects.equals(other.timeZone, this.timeZone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field(), this.timeZone);
    }
}

