/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.rows.merge;

import java.math.BigDecimal;
import javax.swing.Icon;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.plugin.manipulators.rows.merge.FirstQuartileNumber;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.datalab.spi.rows.merge.AttributeRowsMergeStrategy;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.gephi.utils.StatisticsUtils;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class InterQuartileRangeNumber
implements AttributeRowsMergeStrategy {
    private Element[] rows;
    private Column column;
    private BigDecimal result;

    public void setup(Element[] rows, Element selectedRow, Column column) {
        this.rows = rows;
        this.column = column;
    }

    public Object getReducedValue() {
        return this.result;
    }

    public void execute() {
        Number[] numbers = ((AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class)).getRowsColumnNumbers(this.rows, this.column);
        BigDecimal Q3 = StatisticsUtils.quartile3((Number[])numbers);
        BigDecimal Q1 = StatisticsUtils.quartile1((Number[])numbers);
        this.result = Q3 != null && Q1 != null ? Q3.subtract(Q1) : null;
    }

    public String getName() {
        return NbBundle.getMessage(FirstQuartileNumber.class, (String)"InterQuartileRangeNumber.name");
    }

    public String getDescription() {
        return NbBundle.getMessage(FirstQuartileNumber.class, (String)"InterQuartileRangeNumber.description");
    }

    public boolean canExecute() {
        return AttributeUtils.isNumberType((Class)this.column.getTypeClass());
    }

    public ManipulatorUI getUI() {
        return null;
    }

    public int getType() {
        return 100;
    }

    public int getPosition() {
        return 400;
    }

    public Icon getIcon() {
        return null;
    }
}

