/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.tooling.internal.gradle.DefaultGradleModuleVersion;
import org.gradle.tooling.internal.gradle.DefaultGradlePublication;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.internal.gradle.DefaultProjectPublications;
import org.gradle.tooling.model.GradleModuleVersion;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

class PublicationsBuilder
implements ToolingModelBuilder {
    private final ProjectPublicationRegistry publicationRegistry;

    PublicationsBuilder(ProjectPublicationRegistry publicationRegistry) {
        this.publicationRegistry = publicationRegistry;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.gradle.ProjectPublications");
    }

    public Object buildAll(String modelName, Project project) {
        DefaultProjectIdentifier projectIdentifier = new DefaultProjectIdentifier(project.getRootDir(), project.getPath());
        return new DefaultProjectPublications().setPublications(this.publications(projectIdentifier)).setProjectIdentifier(projectIdentifier);
    }

    private List<DefaultGradlePublication> publications(DefaultProjectIdentifier projectIdentifier) {
        ArrayList gradlePublications = Lists.newArrayList();
        Set projectPublications = this.publicationRegistry.getPublications(projectIdentifier.getProjectPath());
        for (ProjectPublication projectPublication : projectPublications) {
            ModuleVersionIdentifier id = (ModuleVersionIdentifier)projectPublication.getCoordinates(ModuleVersionIdentifier.class);
            if (id == null) continue;
            gradlePublications.add(new DefaultGradlePublication().setId((GradleModuleVersion)new DefaultGradleModuleVersion(id)).setProjectIdentifier(projectIdentifier));
        }
        return gradlePublications;
    }
}

