/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@Beta
public interface Service {
    public Service startAsync();

    public boolean isRunning();

    public State state();

    public Service stopAsync();

    public void awaitRunning();

    public void awaitRunning(long var1, TimeUnit var3) throws TimeoutException;

    public void awaitTerminated();

    public void awaitTerminated(long var1, TimeUnit var3) throws TimeoutException;

    public Throwable failureCause();

    public void addListener(Listener var1, Executor var2);

    @Beta
    public static abstract class Listener {
        public void starting() {
        }

        public void running() {
        }

        public void stopping(State from) {
        }

        public void terminated(State from) {
        }

        public void failed(State from, Throwable failure) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Beta
    public static enum State {
        NEW{

            boolean isTerminal() {
                return false;
            }
        }
        ,
        STARTING{

            boolean isTerminal() {
                return false;
            }
        }
        ,
        RUNNING{

            boolean isTerminal() {
                return false;
            }
        }
        ,
        STOPPING{

            boolean isTerminal() {
                return false;
            }
        }
        ,
        TERMINATED{

            boolean isTerminal() {
                return true;
            }
        }
        ,
        FAILED{

            boolean isTerminal() {
                return true;
            }
        };


        abstract boolean isTerminal();
    }
}

